/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.ProcessCheckRunner;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class ProcessCheckAction
extends ProvisioningAction {
    private static final String ACTION_PCHECK = "processcheck";

    public IStatus execute(Map<String, Object> parameters) {
        String[] processes = ((String)parameters.get("processName")).split(" ");
        String target = (String)parameters.get("target");
        int noProcesses = processes.length;
        String runningProc = "";
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath path = Util.getLocationIPath(location);
                IPath eclipsePath = Util.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(path)) {
                    IPath newTarget = path.removeLastSegments(1);
                    newTarget = newTarget.addTrailingSeparator();
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", newTarget.toString()));
                    target = newTarget.toString();
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < noProcesses) {
                if (ProcessCheckRunner.getProcessRunning(processes[i], target)) {
                    sb.append(processes[i]).append(" ");
                }
                ++i;
            }
            runningProc = sb.toString();
            if (!runningProc.equals("")) {
                return new Status(8, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.process_is_running, (Object)runningProc), null);
            }
            return Status.OK_STATUS;
        }
        catch (IOException err) {
            err.printStackTrace();
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ACTION_PCHECK), null);
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }
}

