/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports.toolchains;

import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import com.freescale.s32ds.cross.wizard.pi.toolchains.ToolchainMetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public interface IToolChainExporter
extends ToolchainMetadata {
    default public List<String> processOptions(ITool tool, List<String> options, ProjectInfoExportSettings settings) {
        ArrayList<String> resultLits = new ArrayList<String>();
        for (String result : options) {
            if (settings.getDefaultPaths().booleanValue()) {
                try {
                    result = result.replace(CCorePlugin.getDefault().getCdtVariableManager().resolveValue("${ProjDirPath}", "", "", settings.getConfiguration()), "${ProjDirPath}");
                }
                catch (CdtVariableException e1) {
                    S32DSWizardPiPlugin.log(e1);
                }
            } else if (settings.getAbsolutePaths().booleanValue()) {
                String otherSeporator = "/".equals(File.separator) ? "\\" : "/";
                result = result.replace(otherSeporator, File.separator);
            }
            Pattern includePattern = Pattern.compile("-I\"([^\"]+)\"|-I([^ ]+)");
            Matcher matcher = includePattern.matcher(result);
            while (matcher.find()) {
                String group = matcher.group(0);
                if (group != null) {
                    String path = group.replace("\"", "").replace("-I", "");
                    try {
                        path = CCorePlugin.getDefault().getCdtVariableManager().resolveValue(path, "", "", settings.getConfiguration());
                        path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
                    }
                    catch (CoreException e) {
                        S32DSWizardPiPlugin.log(e);
                    }
                    continue;
                }
                S32DSWizardPiPlugin.logWarning("processOps: grp=null, res=" + result + " mat=" + matcher);
            }
            resultLits.add(result);
        }
        return resultLits;
    }

    public String getLinkerCommandFile(List<String> var1, ProjectInfoExportSettings var2);
}

