/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi;

import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public final class ProjectInfoPathProcessor {
    public static final String EMPTY = "";
    public static final String PROJDIRPATH = "${ProjDirPath}";

    public static final String getAbsolutePath(ICConfigurationDescription config, String path) throws CoreException {
        String resolvedPath = ProjectInfoPathProcessor.resolvePath(config, path);
        java.nio.file.Path path1 = Paths.get(resolvedPath, new String[0]);
        if (path1.isAbsolute() && Files.exists(path1, new LinkOption[0])) {
            return path1.normalize().toString();
        }
        IProject project = config.getProjectDescription().getProject();
        IResource member = project.findMember(resolvedPath);
        if (member == null) {
            member = project.getWorkspace().getRoot().findMember(resolvedPath);
        }
        if (member == null) {
            throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard.pi", "Can't process " + resolvedPath));
        }
        return member.getLocation().toOSString();
    }

    public static final String resolvePath(ICConfigurationDescription config, String path) {
        try {
            return CCorePlugin.getDefault().getCdtVariableManager().resolveValue(path, EMPTY, EMPTY, config);
        }
        catch (CdtVariableException e) {
            S32DSWizardPiPlugin.log(e);
            return path;
        }
    }

    public static final IFile makeOutIFile(IProject project, String path, PIReader importPIReader) throws IOException {
        if (importPIReader.getProjectInfoPath() == null && path.contains(PROJDIRPATH)) {
            path = path.replace(PROJDIRPATH, EMPTY);
        } else if (Paths.get(path = path.replace('\\', '/'), new String[0]).isAbsolute() && importPIReader.getProjectInfoPath() != null) {
            String oldProjectPath = Paths.get(importPIReader.getProjectInfoPath(), new String[0]).getParent().toString().replace('\\', '/');
            if (path.startsWith(oldProjectPath)) {
                path = path.substring(oldProjectPath.length());
            } else {
                S32DSWizardPiPlugin.logWarning(String.format("String %s cannot be made relative for %s. No changes.", path, oldProjectPath));
            }
        }
        return project.getFile(path);
    }

    public static final java.nio.file.Path makeInPath(String path, PIReader importPIReader) throws IOException {
        java.nio.file.Path result;
        java.nio.file.Path source;
        if ((path = path.replace('\\', '/')).contains(PROJDIRPATH)) {
            path = path.replace(PROJDIRPATH, importPIReader.getRootFolder());
        }
        if ((source = Paths.get(path, new String[0])).isAbsolute() && importPIReader.getProjectInfoPath() != null) {
            String oldProjectPath = Paths.get(importPIReader.getProjectInfoPath(), new String[0]).getParent().toString().replace('\\', '/');
            if (path.startsWith(oldProjectPath)) {
                path = path.substring(oldProjectPath.length());
                result = Paths.get(importPIReader.getRootFolder(), path);
            } else {
                result = Paths.get(path, new String[0]);
            }
        } else {
            result = Paths.get(importPIReader.getRootFolder(), path);
        }
        if (!result.toFile().exists()) {
            S32DSWizardPiPlugin.logWarning(String.format("Cannot find %s", result.toString()));
        }
        return result;
    }

    public static final String substituteVarsPaths(String toolCommandFlagsString, ITool tool) {
        IOption option;
        int n;
        IOption[] iOptionArray;
        List<String> findValue = ProjectInfoPathProcessor.findValue(toolCommandFlagsString, "-I ?\"([^\"]+)\"|-I ?([^ ]+)");
        if (!findValue.isEmpty()) {
            for (String string : findValue) {
                toolCommandFlagsString = toolCommandFlagsString.replace(string, EMPTY);
            }
            iOptionArray = tool.getOptions();
            n = iOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                option = iOptionArray[n2];
                if (option.getId() != null && option.getId().contains("include.paths")) {
                    toolCommandFlagsString = ProjectInfoPathProcessor.substituteIncludePath(toolCommandFlagsString, option);
                }
                ++n2;
            }
        }
        if (!(findValue = ProjectInfoPathProcessor.findValue(toolCommandFlagsString, "--sysroot=\"[^\"]+\"|--sysroot=[^ ]+")).isEmpty()) {
            for (String string : findValue) {
                toolCommandFlagsString = toolCommandFlagsString.replace(string, EMPTY);
            }
            iOptionArray = tool.getOptions();
            n = iOptionArray.length;
            int n3 = 0;
            while (n3 < n) {
                option = iOptionArray[n3];
                if (option.getId() != null && option.getId().contains("sysroot")) {
                    toolCommandFlagsString = ProjectInfoPathProcessor.substituteSysrootPath(toolCommandFlagsString, option);
                }
                ++n3;
            }
        }
        return toolCommandFlagsString;
    }

    private static String substituteSysrootPath(String toolCommandFlagsString, IOption option) {
        String stringValue = (String)option.getValue();
        String listCmd = option.getCommand();
        if (stringValue != null) {
            stringValue = String.valueOf(listCmd) + ' ' + stringValue + ' ';
        }
        toolCommandFlagsString = String.valueOf(stringValue) + toolCommandFlagsString;
        return toolCommandFlagsString;
    }

    private static String substituteIncludePath(String toolCommandFlagsString, IOption option) {
        try {
            String[] stringValue = option.getBasicStringListValue();
            String listCmd = option.getCommand();
            StringBuilder builder = new StringBuilder();
            if (stringValue != null) {
                String[] stringArray = stringValue;
                int n = stringValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    if (temp.length() > 0) {
                        builder.append(String.valueOf(listCmd) + ' ' + temp + ' ');
                    }
                    ++n2;
                }
            }
            toolCommandFlagsString = String.valueOf(builder.toString()) + toolCommandFlagsString;
        }
        catch (BuildException e) {
            S32DSWizardPiPlugin.log(e);
        }
        return toolCommandFlagsString;
    }

    private static final List<String> findValue(String values, String stringPattern) {
        Pattern pattern = Pattern.compile(stringPattern);
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = pattern.matcher(values);
        while (matcher.find()) {
            list.add(matcher.group(0));
        }
        return list;
    }

    public static String process(String path, Boolean defaultPaths, ICConfigurationDescription config) throws CoreException {
        if (defaultPaths.booleanValue()) {
            return path;
        }
        return ProjectInfoPathProcessor.getAbsolutePath(config, path);
    }

    public static String makeAbsOrRel(String path, boolean useAbsolute, ICConfigurationDescription cfg) throws CoreException {
        Path p = new Path(path);
        boolean isAbsolute = p.isAbsolute();
        if (!useAbsolute && isAbsolute) {
            IPath root = cfg.getProjectDescription().getProject().getLocation();
            path = p.makeRelativeTo(root).toOSString();
        } else if (useAbsolute && !isAbsolute) {
            path = ProjectInfoPathProcessor.getAbsolutePath(cfg, path);
        }
        return path;
    }
}

