/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cll;

import com.nxp.s32ds.ext.rcp.license.IFeatureId;
import com.nxp.s32ds.ext.rcp.license.ILicenseModel;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.cll.CLL;
import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureId;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.ext.rcp.license.cll.LicenseException;
import java.util.Map;
import java.util.Set;

public class CLLModel
implements ILicenseModel {
    public static final String PARAM_FEATURE_PRODUCT_NAME = "productName";
    public static final String PARAM_FEATURE_ID = "featureId";
    public static final String PARAM_FEATURE_VERSION = "featureVersion";
    private static final String PARAM_MODEL_TEST_MODE = "license.cll.test";
    public static final String ACT_PARAM_OFFLINE_RESPONSE = "offlineResponse";
    public static final String ACT_PARAM_OFFLINE_REQUEST = "offlineRequest";
    private static final ICLL cll = new CLL();
    private boolean testFNO = false;
    private Map<String, String> params;
    private int evaluationWarningDays = 7;

    public static ICLL instanceCLL() {
        return cll;
    }

    @Override
    public String getModelDetails() {
        return "CLL License " + this.params;
    }

    @Override
    public LicenseStatus getStatus(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f == null) {
            return LicenseStatus.MISSED;
        }
        if ("FOREVER".equals(f.getDaysToExpire())) {
            return LicenseStatus.ACTIVATED;
        }
        if (Integer.parseInt(f.getDaysToExpire()) < 1) {
            return LicenseStatus.EXPIRED;
        }
        if (f.getExpirationDate() != null) {
            return LicenseStatus.EVALUATION;
        }
        return LicenseStatus.ACTIVATED;
    }

    private CLLFeatureDetail getBestFor(CLLFeatureId fid) {
        CLLFeatureDetail f = cll.listFeatures(fid.getProductName(), fid.getFeatureId(), fid.getVersion(), new CLLReason());
        if (f != null && f.getNext() != null) {
            if ("FOREVER".equals(f.getDaysToExpire())) {
                return f;
            }
            long maxDays = Long.parseLong(f.getDaysToExpire());
            CLLFeatureDetail best = f;
            CLLFeatureDetail cur = f;
            while (cur.getNext() != null) {
                if ("FOREVER".equals((cur = cur.getNext()).getDaysToExpire())) {
                    return cur;
                }
                long curDays = Long.parseLong(cur.getDaysToExpire());
                if (maxDays >= curDays) continue;
                maxDays = curDays;
                best = cur;
            }
            return best;
        }
        return f;
    }

    @Override
    public void activate(String id, Map<String, String> params) throws LicenseException {
        if (params.containsKey(ACT_PARAM_OFFLINE_REQUEST)) {
            CLLModel.checked(cll.activateLicense(id, CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO, params.get(ACT_PARAM_OFFLINE_REQUEST), 0L, 0L));
        } else if (params.containsKey(ACT_PARAM_OFFLINE_RESPONSE)) {
            CLLModel.checked(cll.processOfflineResponse(params.get(ACT_PARAM_OFFLINE_RESPONSE)));
        } else {
            CLLModel.checked(cll.activateLicense(id, CLLActivationType.CLL_ACTIVATION_TYPE_FNO, "", 0L, 0L));
        }
    }

    @Override
    public void init(Map<String, String> params, Set<String> products) throws LicenseException {
        this.params = params;
        if (params.containsKey(PARAM_MODEL_TEST_MODE) && "true".equalsIgnoreCase(params.get(PARAM_MODEL_TEST_MODE))) {
            cll.setFNOUrlForTesting(true);
            this.testFNO = true;
        }
        if (params.containsKey("http.proxySet")) {
            String proxyHost = CLLModel.getOrEmpty(params, "http.proxyHost");
            int proxyPort = Integer.parseInt(CLLModel.getOrEmpty(params, "http.proxyPort"));
            String proxyUser = CLLModel.getOrEmpty(params, "http.proxyUser");
            String proxyPassword = CLLModel.getOrEmpty(params, "http.proxyPassword");
            cll.configureProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
        }
        this.evaluationWarningDays = params.containsKey("intNumberOfDays") ? Integer.parseInt(params.get("intNumberOfDays")) : 7;
    }

    private void registerProductsInCLLService(Set<String> products) throws Exception {
        for (String productName : products) {
            CLLModel.checked(cll.installService(productName));
        }
    }

    private static String getOrEmpty(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    @Override
    public int getEvaluationDays(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f == null) {
            return -1;
        }
        if ("FOREVER".equals(f.getDaysToExpire())) {
            return 3650000;
        }
        return Integer.parseInt(f.getDaysToExpire());
    }

    @Override
    public int getEvaluationWarningDays() {
        return this.evaluationWarningDays;
    }

    @Override
    public String getActivationId(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f != null) {
            return f.getActivationID();
        }
        return "";
    }

    @Override
    public String getFeatureDetails(IFeatureId licenseFeatureId) {
        CLLFeatureId fId = (CLLFeatureId)licenseFeatureId;
        CLLFeatureDetail f = this.getBestFor(fId);
        if (f != null) {
            return f.toString();
        }
        return "feature " + fId.getFeatureId() + " " + fId.getVersion() + " is missing";
    }

    @Override
    public IFeatureId createFeatureId(Map<String, String> params) {
        return new CLLFeatureId(params.get(PARAM_FEATURE_PRODUCT_NAME), params.get(PARAM_FEATURE_ID), params.get(PARAM_FEATURE_VERSION));
    }

    @Override
    public void refreshFeature(IFeatureId id) {
        String activationId = this.getActivationId(id);
        if (activationId.isEmpty()) {
            throw new IllegalStateException("activationId is missing");
        }
        CLLReason result = cll.refreshLicense(activationId, false, "", 0L, 0L);
        if (result != null && result.isError()) {
            throw new RuntimeException(result.toString());
        }
    }

    @Override
    public boolean isTestMode() {
        return this.testFNO;
    }

    @Override
    public void returnFeature(String id, Map<String, String> params) throws LicenseException {
        if (params.containsKey(ACT_PARAM_OFFLINE_REQUEST)) {
            CLLModel.checked(cll.returnLicense(id, true, params.get(ACT_PARAM_OFFLINE_REQUEST)));
        } else if (params.containsKey(ACT_PARAM_OFFLINE_RESPONSE)) {
            CLLModel.checked(cll.processOfflineResponse(params.get(ACT_PARAM_OFFLINE_RESPONSE)));
        } else {
            CLLModel.checked(cll.returnLicense(id, false, ""));
        }
    }

    private static void checked(CLLReason reason) throws LicenseException {
        if (reason != null) {
            throw new LicenseException(reason.toString());
        }
    }
}

