/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.utils;

import java.util.stream.Stream;

public enum OSFamily {
    WINDOWS("windows", OSFamily.osStartsWith("win")),
    LINUX("linux", OSFamily.osStartsWith("linux")),
    OSX("osx", OSFamily.osStartsWith("mac")),
    OTHER("other", false);

    private static final String OS_NAME = "os.name";
    public static final OSFamily current;
    public final String family;
    private final boolean isCurrent;

    static {
        current = Stream.of(OSFamily.values()).filter(f -> f.isCurrent).findAny().orElse(OTHER);
    }

    private OSFamily(String family, boolean isCurrent) {
        this.family = family;
        this.isCurrent = isCurrent;
    }

    public boolean isCurrent() {
        return this.equals((Object)current);
    }

    private static boolean osStartsWith(String prefix) {
        return System.getProperty(OS_NAME).toLowerCase().startsWith(prefix);
    }
}

