/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public interface IRenameParticipant {
    public IStatus renameProject(IProject var1, String var2, String var3, IProgressMonitor var4);

    default public IStatus renameFile(IFile file, String search, String replace, IProgressMonitor monitor) {
        String oldName;
        String newName;
        if (file == null || search == null || replace == null) {
            return Status.CANCEL_STATUS;
        }
        if (search.equals(replace)) {
            return Status.OK_STATUS;
        }
        if (file.exists() && !(newName = RenameUtils.renameProjectOccurencesInFileName(oldName = file.getName(), search, replace)).equals(oldName)) {
            IPath path = file.getFullPath().removeLastSegments(1).append(newName);
            try {
                file.move(path, false, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }
}

