/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclaration;

class IntrinsicInvocationFormatter {
    private static final String FUNCTION_SIGNATURE_FORMAT = "%s\n%s%s%s;%n";
    private static final String COMMENT_PREFIX = "\n/*";
    private static final String COMMENT_LINE_PREFIX = " * ";
    private static final String COMMENT_POSTFIX = "*/";
    private static final String LF = "\r\n";
    private static final int COMMENT_LINE_LENGTH = 80;

    IntrinsicInvocationFormatter() {
    }

    static String getFormattedDescription(IntrinsicDeclaration id) {
        return IntrinsicInvocationFormatter.getComment(id).replaceAll("( \\* )|(\\/\\*)|(\\*\\/)", "").replaceAll(" \r\n", LF).trim();
    }

    static String format(IntrinsicDeclaration id) {
        return String.format(FUNCTION_SIGNATURE_FORMAT, IntrinsicInvocationFormatter.getComment(id), IntrinsicInvocationFormatter.getReturn(id), id.getName(), IntrinsicInvocationFormatter.getParameters(id));
    }

    private static String getComment(IntrinsicDeclaration id) {
        String description = id.getDescription().trim();
        if (description.isEmpty()) {
            return "";
        }
        StringBuilder comment = new StringBuilder(COMMENT_PREFIX);
        String[] splitted = description.split(" ");
        int wCount = splitted.length - 1;
        int lineLength = 0;
        StringBuilder line = new StringBuilder();
        int w = 0;
        int lineCount = 0;
        while (w <= wCount) {
            String word = splitted[w];
            line.append(word).append(' ');
            if ((lineLength += word.length()) > 80 || w == wCount) {
                comment.append(lineCount == 0 ? Character.valueOf(' ') : COMMENT_LINE_PREFIX).append((CharSequence)line).append(w < wCount ? LF : "");
                line.setLength(0);
                lineLength = 0;
                ++lineCount;
            }
            ++w;
            ++lineLength;
        }
        return comment.append(COMMENT_POSTFIX).toString();
    }

    private static String getReturn(IntrinsicDeclaration id) {
        String retType = id.getReturnType();
        String returnExpression = "";
        if (!"void".equals(retType)) {
            returnExpression = String.format("%s = ", retType);
        }
        return returnExpression;
    }

    private static String getParameters(IntrinsicDeclaration id) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(id.getParameterTypesAsString()).append(')');
        return sb.toString();
    }
}

