/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class SDKResourcesHandler {
    public static final SDKResourcesHandler INSTANCE = new SDKResourcesHandler();

    public IFile getTargetFile(IExtendedPath sdkFile, ISDK sdk, IProject project) {
        IFile file = null;
        String copyPath = sdkFile.copyPath();
        String renameTo = sdkFile.renameTo();
        if (this.isCopyToProjectRoot(copyPath)) {
            file = this.isRenamed(renameTo) ? project.getFile(renameTo) : project.getFile(sdkFile.lastSegment());
        } else {
            IPath srcRelPath = sdkFile.makeRelativeTo(SDKSupportPlugin.getEclipsePath(sdk));
            IFolder folder = this.getFolder(srcRelPath, copyPath, sdk, project);
            if (folder != null && srcRelPath.lastSegment() != null) {
                file = this.isRenamed(renameTo) ? folder.getFile(renameTo) : folder.getFile(srcRelPath.lastSegment());
            }
        }
        return file;
    }

    private boolean isCopyToProjectRoot(String copyPath) {
        return copyPath != null && (copyPath.isEmpty() || copyPath.equals(".") || copyPath.equals("/"));
    }

    private boolean isRenamed(String renameTo) {
        return renameTo != null && !renameTo.isEmpty();
    }

    private IFolder getFolder(IPath srcRelPath, String copyPath, ISDK sdk, IProject project) {
        IFolder folder = null;
        if (copyPath == null) {
            folder = project.getFolder(sdk.getName());
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                ++i;
            }
        } else {
            folder = project.getFolder(copyPath);
        }
        return folder;
    }
}

