/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TCHolder {
    public static final String SYMBOLS_ATTRIBUTE_TAG = "symbols";
    public static final String SOURCE_PATH_ATTRIBUTE_TAG = "path";
    public static final String SOURCE_COPY_ATTRIBUTE_TAG = "copy";
    public static final String SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG = "copyToProjectPath";
    public static final String RENAME_TO_ATTRIBUTE_TAG = "renameTo";
    public static final String IS_PUBLIC_ATTRIBUTE_TAG = "isPublic";
    public static final String TO_OPEN_ATTRIBUTE_TAG = "toOpen";
    public static final String SOURCE_FOLDER_ELEMENT_TAG = "sourceFolder";
    public static final String SOURCE_FILE_ELEMENT_TAG = "sourceFile";
    public static final String LINKER_FILE_ELEMENT_TAG = "linkerFile";
    public static final String HEADER_FOLDER_ELEMENT_TAG = "headerFolder";
    public static final String HEADER_FILE_ELEMENT_TAG = "headerFile";
    public static final String BINARY_FILE_ELEMENT_TAG = "binaryFile";
    public static final String OTHER_FOLDER_ELEMENT_TAG = "resourceFolder";
    public static final String OTHER_FILE_ELEMENT_TAG = "resourceFile";
    public static final String ID_ATTRIBUTE_TAG = "id";
    public static final String ALIAS_ATTRIBUTE_TAG = "alias";
    private final String toolchainId;
    private final String alias;
    public static final int T_SOURCE = 0;
    public static final int T_HEADER = 1;
    public static final int T_BINARY = 2;
    public static final int T_OTHERS = 3;
    public static final int T_LINKER = 4;
    public static final IExtendedPath[] EMPTY_PATHS = new IExtendedPath[0];
    public List<IExtendedPath> srcs = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> hdrs = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> bins = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> oths = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> ldfs = new ArrayList<IExtendedPath>();
    public List<String> defs = new ArrayList<String>();

    public TCHolder(String tc) {
        this.toolchainId = tc;
        this.alias = null;
    }

    public TCHolder(Element e, String path, String env) {
        this.toolchainId = e.getAttribute(ID_ATTRIBUTE_TAG);
        this.alias = e.getAttribute(ALIAS_ATTRIBUTE_TAG);
        NodeList nlt = e.getChildNodes();
        int nltLen = nlt.getLength();
        int k = 0;
        while (k < nltLen) {
            Node n = nlt.item(k);
            if (n.getNodeType() == 1) {
                Element el = (Element)n;
                this.process(el, path, env);
            }
            ++k;
        }
    }

    public TCHolder(IConfigurationElement ce, IPath sdkRootPath) {
        String id = ce.getAttribute(ID_ATTRIBUTE_TAG);
        String al = ce.getAttribute(ALIAS_ATTRIBUTE_TAG);
        if (al == null || id == null) {
            id = null;
            al = null;
        }
        this.toolchainId = id;
        this.alias = al;
        this.srcs = TCHolder.getPaths(ce, sdkRootPath, SOURCE_FOLDER_ELEMENT_TAG, SOURCE_FILE_ELEMENT_TAG, SDKSupportPlugin.sourcesMatcher);
        this.hdrs = TCHolder.getPaths(ce, sdkRootPath, HEADER_FOLDER_ELEMENT_TAG, "", SDKSupportPlugin.headersMatcher);
        this.bins = TCHolder.getPaths(ce, sdkRootPath, "", BINARY_FILE_ELEMENT_TAG, SDKSupportPlugin.binariesMatcher);
        this.oths = TCHolder.getPaths(ce, sdkRootPath, OTHER_FOLDER_ELEMENT_TAG, OTHER_FILE_ELEMENT_TAG, SDKSupportPlugin.othersMatcher);
        this.ldfs = TCHolder.getPaths(ce, sdkRootPath, "", LINKER_FILE_ELEMENT_TAG, SDKSupportPlugin.ldMatcher);
        String s = ce.getAttribute(SYMBOLS_ATTRIBUTE_TAG);
        this.defs = s == null || s.trim().isEmpty() ? new ArrayList<String>() : Arrays.asList(s.split(","));
    }

    public String getTCId() {
        return this.toolchainId;
    }

    public String getTCAlias() {
        return this.alias;
    }

    public void process(Element e, String path, String env) {
        String name;
        if (env == null) {
            env = path;
        }
        if ((name = e.getNodeName()).equals(SOURCE_FILE_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.srcs, null);
        } else if (name.equals(SOURCE_FOLDER_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.srcs, SDKSupportPlugin.sourcesMatcher);
        } else if (name.equals(HEADER_FILE_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.hdrs, null);
        } else if (name.equals(HEADER_FOLDER_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.hdrs, SDKSupportPlugin.headersMatcher);
        } else if (name.equals(BINARY_FILE_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.bins, null);
        } else if (name.equals(OTHER_FILE_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.oths, null);
        } else if (name.equals(OTHER_FOLDER_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.oths, SDKSupportPlugin.othersMatcher);
        } else if (name.equals(LINKER_FILE_ELEMENT_TAG)) {
            TCHolder.extractPath(e, env, this.ldfs, null);
        }
    }

    private static void extractPath(Element e, String newPath, List<IExtendedPath> lst, PathMatcher matcher) {
        String path = e.getAttribute(SOURCE_PATH_ATTRIBUTE_TAG);
        boolean copy = Boolean.valueOf(e.getAttribute(SOURCE_COPY_ATTRIBUTE_TAG));
        String copyToProjectPath = e.getAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG);
        Boolean toOpen = Boolean.valueOf(e.getAttribute(TO_OPEN_ATTRIBUTE_TAG));
        Boolean isPublic = Boolean.valueOf(e.getAttribute(IS_PUBLIC_ATTRIBUTE_TAG));
        String renameTo = e.getAttribute(RENAME_TO_ATTRIBUTE_TAG);
        String fullPath = path;
        if (newPath != null) {
            String string = fullPath = path.startsWith(newPath) ? path : String.format("%s/%s", newPath, path).replace('\\', '/');
        }
        if (matcher != null) {
            IPath sourcePath = new Path(newPath).append(Path.fromOSString((String)path));
            TCHolder.processFolder(lst, sourcePath, copy, copyToProjectPath, renameTo, isPublic, toOpen, matcher);
        } else {
            lst.add(ExtendedPath.fromOSString(fullPath, copy, copyToProjectPath, renameTo, isPublic, toOpen, false));
        }
    }

    public boolean isEmpty() {
        return this.srcs.isEmpty() && this.hdrs.isEmpty() && this.bins.isEmpty() && this.oths.isEmpty() && this.ldfs.isEmpty();
    }

    public void asXML(Document document, Element sdkElement, IPath sdkPath) {
        sdkElement.setAttribute(SYMBOLS_ATTRIBUTE_TAG, String.join((CharSequence)",", this.defs.toArray(new String[0])));
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.srcs, SOURCE_FILE_ELEMENT_TAG);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.hdrs, HEADER_FILE_ELEMENT_TAG);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.bins, BINARY_FILE_ELEMENT_TAG);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.oths, OTHER_FILE_ELEMENT_TAG);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.ldfs, LINKER_FILE_ELEMENT_TAG);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TCHolder ALIAS=").append(this.alias);
        sb.append(" TC=").append(this.toolchainId);
        sb.append(" SRC=").append(Arrays.toString(this.srcs.toArray()));
        sb.append(" HDR=").append(Arrays.toString(this.hdrs.toArray()));
        sb.append(" BIN=").append(Arrays.toString(this.bins.toArray()));
        sb.append(" OTH=").append(Arrays.toString(this.oths.toArray()));
        sb.append(" LDS=").append(Arrays.toString(this.ldfs.toArray()));
        sb.append(" DEF=").append(Arrays.toString(this.defs.toArray()));
        sb.append(" END.");
        return sb.toString();
    }

    private static void appendChildren(Document document, Element sdkElement, IPath sdkPath, Collection<IExtendedPath> paths, String fileTag) {
        for (IExtendedPath s : paths) {
            String renameTo;
            Element se = document.createElement(fileTag);
            IPath path = s.makeRelativeTo(sdkPath);
            se.setAttribute(SOURCE_PATH_ATTRIBUTE_TAG, path.toOSString());
            se.setAttribute(SOURCE_COPY_ATTRIBUTE_TAG, Boolean.toString(s.isCopy()));
            String copyPath = s.copyPath();
            if (copyPath != null && !copyPath.isEmpty()) {
                se.setAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG, copyPath);
            }
            if ((renameTo = s.renameTo()) != null && !renameTo.isEmpty()) {
                se.setAttribute(RENAME_TO_ATTRIBUTE_TAG, renameTo);
            }
            sdkElement.appendChild(se);
        }
    }

    public void clear() {
        this.srcs.clear();
        this.hdrs.clear();
        this.bins.clear();
        this.oths.clear();
        this.ldfs.clear();
        this.defs.clear();
    }

    private static List<IExtendedPath> getPaths(IConfigurationElement ce, IPath sdkRootPath, String folderElementTag, String fileElementTag, PathMatcher matcher) {
        IConfigurationElement[] folders = ce.getChildren(folderElementTag);
        IConfigurationElement[] files = ce.getChildren(fileElementTag);
        IConfigurationElement[] srcs = new IConfigurationElement[folders.length + files.length];
        int foldersLength = folders.length;
        System.arraycopy(folders, 0, srcs, 0, foldersLength);
        System.arraycopy(files, 0, srcs, foldersLength, files.length);
        files = null;
        folders = null;
        ArrayList<IExtendedPath> sdkPaths = new ArrayList<IExtendedPath>();
        int i = 0;
        while (i < srcs.length) {
            IConfigurationElement sce = srcs[i];
            String path = sce.getAttribute(SOURCE_PATH_ATTRIBUTE_TAG);
            if (path != null) {
                while (path.length() > 1 && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
                    path = path.substring(1);
                }
            }
            boolean copy = Boolean.valueOf(sce.getAttribute(SOURCE_COPY_ATTRIBUTE_TAG));
            Boolean toOpen = Boolean.valueOf(sce.getAttribute(TO_OPEN_ATTRIBUTE_TAG));
            Boolean isPublic = Boolean.valueOf(sce.getAttribute(IS_PUBLIC_ATTRIBUTE_TAG));
            String renameTo = sce.getAttribute(RENAME_TO_ATTRIBUTE_TAG);
            String copyToProjectPath = sce.getAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG);
            IPath sourcePath = sdkRootPath.append(Path.fromOSString((String)path));
            if (i >= foldersLength) {
                sdkPaths.add(ExtendedPath.fromOSString(sourcePath.toOSString(), copy, copyToProjectPath, renameTo, isPublic, toOpen, false));
            } else {
                TCHolder.processFolder(sdkPaths, sourcePath, copy, copyToProjectPath, renameTo, isPublic, toOpen, matcher);
            }
            ++i;
        }
        return sdkPaths;
    }

    private static void processFolder(final List<IExtendedPath> paths, IPath src, final boolean copy, final String copyDest, final String renameTo, final boolean isPublic, final boolean toOpen, final PathMatcher matcher) {
        paths.add(ExtendedPath.fromOSString(src.toOSString(), copy, copyDest, renameTo, isPublic, toOpen, true));
        File file = src.toFile();
        if (file.exists()) {
            String absolutePath = file.getAbsolutePath();
            try {
                Files.walkFileTree(Paths.get(absolutePath, new String[0]), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        if (matcher.matches(file.getFileName())) {
                            paths.add(ExtendedPath.fromOSString(file.toString(), copy, copyDest, renameTo, isPublic, toOpen, false));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                SDKSupportPlugin.error(e);
            }
        }
    }

    public IExtendedPath[] get(int type) {
        switch (type) {
            case 0: {
                return this.srcs.toArray(new IExtendedPath[0]);
            }
            case 1: {
                return this.hdrs.toArray(new IExtendedPath[0]);
            }
            case 2: {
                return this.bins.toArray(new IExtendedPath[0]);
            }
            case 3: {
                return this.oths.toArray(new IExtendedPath[0]);
            }
            case 4: {
                return this.ldfs.toArray(new IExtendedPath[0]);
            }
        }
        return EMPTY_PATHS;
    }
}

