/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SDKHeader {
    public static final String NAME_ATTRIBUTE_TAG = "name";
    public static final String VERSION_ATTRIBUTE_TAG = "version";
    public static final String BASE_PATH_ATTRIBUTE_TAG = "basePath";
    public static final String INTERNAL_PATH_ATTRIBUTE_TAG = "internalPath";
    public static final String LANGS_ATTRIBUTE_TAG = "langs";
    public static final String CORES_ATTRIBUTE_TAG = "cores";
    public static final String DESC_ATTRIBUTE_TAG = "description";
    public static final String GIT_PATH_ATTRIBUTE_TAG = "gitPath";
    public static final String GIT_BRANCH_ATTRIBUTE_TAG = "gitBranch";
    public static final String GIT_LABEL_ATTRIBUTE_TAG = "gitLabel";
    public static final String PEX_ATTRIBUTE_TAG = "pex";
    public static final String ENV_ELEMENT_TAG = "env";
    public static final String ENV_NAME_ATTRIBUTE_TAG = "name";
    public static final String ENV_VALUE_ATTRIBUTE_TAG = "value";
    public static final String ENV_IS_SYSTEM_ATTRIBUTE_TAG = "isSystem";
    public static final String OBSOLETE_TCS_ATTRIBUTE_TAG = "toolchains";
    private final String name;
    private final String version;
    private final String description;
    public IEnvironment env;
    private final String id;
    private final boolean isPex;
    public final String cores;
    public final String langs;
    private final String basePath;
    private final boolean isInternal;
    public final String gitpath;
    public final String gitbranch;
    public final String gitlabel;
    public final String obsoleteToolchainIds;

    public SDKHeader(String name, String vers, String desc, String path, String langs, String cores, boolean isPex, boolean isInternal, IEnvironment env) {
        this.name = name;
        this.version = vers;
        this.description = desc;
        this.basePath = path;
        this.cores = cores;
        this.env = env;
        this.isPex = isPex;
        this.langs = isPex ? "c" : langs;
        this.isInternal = isInternal;
        this.id = SDKHeader.makeId(name, vers);
        this.obsoleteToolchainIds = null;
        this.gitlabel = null;
        this.gitbranch = null;
        this.gitpath = null;
    }

    public SDKHeader(String name, String vers, SDKHeader copy) {
        this.name = name;
        this.version = vers;
        this.description = copy.getDescription();
        this.basePath = copy.getBasePath();
        this.cores = copy.cores;
        this.env = copy.getEnv();
        this.isPex = copy.isPex;
        this.langs = this.isPex ? "c" : copy.langs;
        this.isInternal = copy.isInternal;
        this.id = SDKHeader.makeId(name, vers);
        this.gitlabel = null;
        this.gitbranch = null;
        this.gitpath = null;
        this.obsoleteToolchainIds = copy.obsoleteToolchainIds;
    }

    public SDKHeader(boolean createVar, Element e) {
        this(e, createVar);
    }

    public SDKHeader(IConfigurationElement e) {
        this(e, true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isPEx() {
        return this.isPex;
    }

    public String getLangs() {
        return this.langs;
    }

    public String getCores() {
        return this.cores;
    }

    public String getObsoleteToolchainIds() {
        return this.obsoleteToolchainIds;
    }

    public IEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(IEnvironment env) {
        this.env = env;
    }

    private SDKHeader(Object x, boolean createVar) {
        this.name = SDKHeader.get(x, "name");
        this.version = SDKHeader.get(x, VERSION_ATTRIBUTE_TAG);
        this.description = SDKHeader.get(x, DESC_ATTRIBUTE_TAG);
        this.obsoleteToolchainIds = SDKHeader.get(x, OBSOLETE_TCS_ATTRIBUTE_TAG);
        this.isPex = SDKUtils.getBoolean(SDKHeader.get(x, PEX_ATTRIBUTE_TAG), false);
        this.langs = this.isPex ? "c" : SDKHeader.get(x, LANGS_ATTRIBUTE_TAG);
        this.cores = SDKHeader.get(x, CORES_ATTRIBUTE_TAG);
        this.id = SDKHeader.makeId(this.name, this.version);
        this.basePath = SDKHeader.get(x, BASE_PATH_ATTRIBUTE_TAG);
        this.isInternal = Boolean.valueOf(SDKHeader.get(x, INTERNAL_PATH_ATTRIBUTE_TAG));
        this.gitpath = SDKHeader.get(x, GIT_PATH_ATTRIBUTE_TAG);
        this.gitbranch = SDKHeader.get(x, GIT_BRANCH_ATTRIBUTE_TAG);
        this.gitlabel = SDKHeader.get(x, GIT_LABEL_ATTRIBUTE_TAG);
        if (createVar) {
            this.env = this.getEnv(x, this.basePath);
        }
    }

    private static String get(Object x, String tag) {
        if (x instanceof Element) {
            return ((Element)x).getAttribute(tag);
        }
        if (x instanceof IConfigurationElement) {
            return ((IConfigurationElement)x).getAttribute(tag);
        }
        SDKSupportPlugin.log("Bad class: " + x);
        return "";
    }

    public boolean isGit() {
        return this.gitpath != null && this.gitpath.length() > 0;
    }

    public static String makeId(String n, String v) {
        if (n == null) {
            n = "";
        }
        if (v == null) {
            v = "";
        }
        return String.valueOf(n) + '_' + v + "_PATH";
    }

    private IEnvironment getEnv(Object x, String path) {
        if (x instanceof Element) {
            Element e0 = (Element)x;
            NodeList nl = e0.getElementsByTagName(ENV_ELEMENT_TAG);
            if (nl == null || nl.getLength() == 0) {
                return null;
            }
            Element e = (Element)nl.item(0);
            String envName = e.getAttribute("name");
            String envValue = e.getAttribute(ENV_VALUE_ATTRIBUTE_TAG);
            boolean isSystem = Boolean.valueOf(e.getAttribute(ENV_IS_SYSTEM_ATTRIBUTE_TAG));
            path = path != null && path.trim().length() > 0 ? path : envValue;
            return SDKSupportPlugin.createEnvironment(envName, isSystem, false, path, envName);
        }
        if (x instanceof IConfigurationElement) {
            return null;
        }
        SDKSupportPlugin.log("Bad class: " + x);
        return null;
    }
}

