/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.WizardArtifactType;
import com.freescale.s32ds.cross.wizard.page1.ContentComposite;
import com.freescale.s32ds.cross.wizard.page1.FilteredContentComposite;
import com.freescale.s32ds.cross.wizard.page1.IPage1Manager;
import com.freescale.s32ds.cross.wizard.page1.LocationArea;
import com.freescale.s32ds.cross.wizard.page1.NameListener;
import com.freescale.s32ds.cross.wizard.page1.Page1Utils;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class Page1Manager
implements IPage1Manager {
    private LocationArea locationArea;
    protected Text projectNameText;
    protected final String initProjectName = "";
    private final S32DSMultiPageOne wizardPage;
    private final GeneralContext context;
    protected TabFolder tabFolder;
    protected final Composite parent;
    private ContentComposite executableContentComposite;
    private ContentComposite libraryContentComposite;
    private TabItem tabExecutable;
    private TabItem tabLibrary;
    private ProcessorData selectedProcessor;

    public Page1Manager(S32DSMultiPageOne page1, GeneralContext context, Composite parent) {
        this.wizardPage = page1;
        this.context = context;
        this.parent = parent;
    }

    @Override
    public void createContents(WizardArtifactType type) {
        this.projectNameText = Page1Utils.createProjectNameInGroup("", this.parent);
        this.locationArea = new LocationArea(this.parent, this.wizardPage);
        if ("" != null) {
            this.locationArea.updateProjectName("");
        }
        this.wizardPage.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.projectNameText.addListener(24, (Listener)new NameListener(this, this.locationArea, this.context));
        if (type == WizardArtifactType.SELECTION) {
            this.tabFolder = new TabFolder(this.parent, 0);
            this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            this.tabExecutable = new TabItem(this.tabFolder, 0);
            this.tabExecutable.setText("Elf S32DS project");
            this.tabLibrary = new TabItem(this.tabFolder, 0);
            this.tabLibrary.setText("Library project");
            this.executableContentComposite = new FilteredContentComposite(this, true, (Composite)this.tabFolder, 4);
            this.tabExecutable.setControl((Control)this.executableContentComposite);
            this.libraryContentComposite = new FilteredContentComposite(this, false, (Composite)this.tabFolder, 4);
            this.tabLibrary.setControl((Control)this.libraryContentComposite);
            this.getContext().setExecutable(true);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean executable = Page1Manager.this.tabFolder.getSelectionIndex() == 0;
                    ContentComposite from = Page1Manager.this.getContentComposite(!executable);
                    ContentComposite to = Page1Manager.this.getContentComposite(executable);
                    Page1Manager.this.switchTab(from, to, executable);
                }
            });
            this.tabFolder.pack();
        } else if (type == WizardArtifactType.APPLICATION) {
            this.getContext().setExecutable(true);
            this.executableContentComposite = new FilteredContentComposite(this, true, this.parent, 4);
        } else {
            this.getContext().setExecutable(false);
            this.libraryContentComposite = new FilteredContentComposite(this, false, this.parent, 4);
        }
        this.checkPageComplete();
        this.wizardPage.setErrorMessage(null);
        this.wizardPage.setMessage(null);
    }

    private void checkPageComplete() {
        this.wizardPage.setPageComplete(this.wizardPage.validatePage());
    }

    public GeneralContext getContext() {
        return this.context;
    }

    @Override
    public String getProjectBaseName() {
        if (this.projectNameText == null) {
            return "";
        }
        return this.projectNameText.getText().trim();
    }

    @Override
    public LocationArea getLocationArea() {
        return this.locationArea;
    }

    public S32DSMultiPageOne getWizardPage() {
        return this.wizardPage;
    }

    @Override
    public void setFocus() {
        this.projectNameText.setFocus();
    }

    @Override
    public ProcessorData getSelectedProcessor() {
        return this.selectedProcessor;
    }

    void setSelectedProcessor(ProcessorData processorData) {
        this.selectedProcessor = processorData;
    }

    protected void switchTab(ContentComposite from, ContentComposite to, boolean executable) {
        this.getContext().setExecutable(executable);
        TreeItem[] selection = from.getHardwareTree().getSelection();
        if (selection.length > 0) {
            this.tabFolder.setSelection(executable ? 0 : 1);
            this.tabFolder.update();
            if (selection[0].getData() instanceof ConfigurationData) {
                to.select((ConfigurationData)selection[0].getData());
            }
        }
    }

    protected ContentComposite getContentComposite(boolean executable) {
        return executable ? this.executableContentComposite : this.libraryContentComposite;
    }
}

