/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.ui;

import com.freescale.s32ds.ui.S32dsResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class S32dsUtils {
    private S32dsUtils() {
    }

    public static GridLayout makeTight(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    public static GridLayout makeTightMargin(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    public static Composite createTightGridComposite(Composite parent) {
        return S32dsUtils.createTightGridComposite(parent, 1, false);
    }

    public static Composite createTightGridComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(numColumns, makeColumnsEqualWidth);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    public static GridData vertIndent(GridData gridData, int indent) {
        gridData.verticalIndent = indent;
        return gridData;
    }

    public static GridData horizIndent(GridData gridData, int indent) {
        gridData.horizontalIndent = indent;
        return gridData;
    }

    public static GridData indent(GridData gridData, int hindent, int vindent) {
        gridData.horizontalIndent = hindent;
        gridData.verticalIndent = vindent;
        return gridData;
    }

    public static GridData spanCells(GridData gridData, int span) {
        gridData.horizontalSpan = span;
        return gridData;
    }

    public static void colorBackground(Control control, int r, int g, int b) {
        control.setBackground(new Color(null, new RGB(r, g, b)));
    }

    public static Composite createNote(Composite parent, String message) {
        Composite composite = S32dsUtils.createTightGridComposite(parent, 2, false);
        Label label = new Label(composite, 0);
        label.setText(S32dsResources.NOTE_PREFIX);
        label.setLayoutData((Object)new GridData(1, 128, false, true));
        S32dsUtils.setTextStyle((Control)label, 1);
        label = new Label(composite, 64);
        label.setText(message);
        GridData gd = new GridData(1808);
        label.setLayoutData((Object)gd);
        return composite;
    }

    public static void setTextStyle(Control control, int style) {
        Font font = control.getFont();
        if (font == null) {
            return;
        }
        FontData[] fontData = font.getFontData();
        if (fontData == null || fontData.length != 1) {
            return;
        }
        fontData[0].setStyle(style);
        final Font newFont = new Font((Device)control.getDisplay(), fontData[0]);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private static FontMetrics getFontMetrics(Control control) {
        GC gc = null;
        try {
            gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            return fontMetrics;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public static void setGridButtonSize(Button button) {
        GridData gd = (GridData)button.getLayoutData();
        if (gd == null) {
            gd = new GridData();
            button.setLayoutData((Object)gd);
        }
        button.setFont(JFaceResources.getDialogFont());
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)S32dsUtils.getFontMetrics((Control)button), (int)61);
        gd.widthHint = widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Color getEditorColorForeground(boolean enabled) {
        return Display.getCurrent().getSystemColor(enabled ? 24 : 18);
    }

    public static Color getEditorColorBackground(boolean enabled) {
        return Display.getCurrent().getSystemColor(enabled ? 25 : 22);
    }

    public static int getStandardIndent(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText("");
        int checkboxWidth = button.computeSize((int)-1, (int)-1).x;
        button.setText("oo");
        int checkboxWithTextWidth = button.computeSize((int)-1, (int)-1).x;
        int textWidth = checkboxWithTextWidth - checkboxWidth;
        button.setText("o");
        int charWidth = checkboxWithTextWidth - button.computeSize((int)-1, (int)-1).x;
        int marginWidth = (textWidth - 2 * charWidth) / 2;
        button.dispose();
        return checkboxWidth + marginWidth;
    }
}

