/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cli.Settings;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.AbstractCommand;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.UIUtils;
import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ActivateUI
extends AbstractCommand {
    public static final String TITLE = "S32DS Activation";

    public ActivateUI(Settings settings, ICLL cll) {
        super(cll, settings);
    }

    @Override
    public String getName() {
        return "activateUI";
    }

    @Override
    public String getOneLineDesc() {
        return "Shows activation UI";
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public String getProblemDescription() {
        return null;
    }

    @Override
    public int execute() {
        String actID = ActivateUI.showInputDialog("Software Activation Code");
        if (actID == null) {
            System.err.println("No Software Activation Code was entered");
            return 1;
        }
        try {
            super.initLicenseLocation();
            super.setupProxy();
            this.getCll().setFNOUrlForTesting(this.isTestFNO());
            int type = JOptionPane.showOptionDialog(null, "Choose activation type", TITLE, 0, 1, null, new String[]{"Online", "Offline"}, "Online");
            switch (type) {
                case 0: {
                    return ActivateUI.activateOnline(actID, this.getCll());
                }
                case 1: {
                    return ActivateUI.activateOffline(actID, this.getCll());
                }
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            UIUtils.showMessageDialog(TITLE, e.getMessage());
            return 1;
        }
    }

    public static int activateOnline(String actID, ICLL cll) {
        CLLReason result = cll.activateLicense(actID, CLLActivationType.CLL_ACTIVATION_TYPE_FNO, null, 0L, 0L);
        if (result == null) {
            return 0;
        }
        UIUtils.showMessageDialog(TITLE, result.getErrorString());
        System.err.println(result);
        return 1;
    }

    public static int activateOffline(String actID, ICLL cll) {
        File request = null;
        do {
            if ((request = UIUtils.chooseFile("Activation request", "Save", new File("request.xml"))) != null) continue;
            System.out.println("Exit by user request (no file selected)");
            return 1;
        } while (request.exists() && JOptionPane.showConfirmDialog(null, "File already exists, are you sure you want to overwrite it?", "Warning", 0) != 0);
        CLLReason requestResult = cll.activateLicense(actID, CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO, request.getAbsolutePath(), 0L, 0L);
        if (requestResult != null) {
            UIUtils.showMessageDialog(TITLE, requestResult.getErrorString());
            System.err.println(requestResult);
            return 1;
        }
        while (true) {
            File response;
            if ((response = UIUtils.chooseFile("Activation response", "Load", null)) == null) {
                return 1;
            }
            CLLReason responseResult = cll.processOfflineResponse(response.getAbsolutePath());
            if (responseResult == null) break;
            UIUtils.showMessageDialog(TITLE, responseResult.getErrorString());
            System.err.println(responseResult);
        }
        return 0;
    }

    public static String showInputDialog(String message) {
        return ActivateUI.showInputDialog(message, "");
    }

    public static String showInputDialog(String message, String initial) throws HeadlessException {
        Object value = new JOptionPane(message, 3, 2, null, null, null, initial){
            {
                this.setWantsInput(true);
                this.setSelectionValues(null);
                this.setInitialSelectionValue(string);
                this.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
                this.selectInitialValue();
                JDialog dialog = this.createDialog(ActivateUI.TITLE);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                dialog.dispose();
            }
        }.getInputValue();
        return value == JOptionPane.UNINITIALIZED_VALUE ? null : value.toString().trim();
    }
}

