/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.databinding;

import com.nxp.s32ds.ext.rcp.databinding.BeanFieldDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SimpleBean {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, Boolean> touchedAttributes = new HashMap<String, Boolean>();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract List<BeanFieldDescriptor> getFields();

    public String getStringValue(String key) {
        if (key != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public void setValue(String key, String value) {
        if (key != null) {
            this.attributes.put(key, value);
        }
    }

    public void setStringValue(String key, String value) {
        if (key != null) {
            this.touchedAttributes.put(key, true);
            String old = this.attributes.put(key, value);
            this.firePropertyChange(key, old, value);
        }
    }

    public void setStringValueInitial(String key, String value) {
        Boolean touched = this.touchedAttributes.get(key);
        if (touched != null) {
            return;
        }
        if (key != null) {
            String old = this.attributes.put(key, value);
            this.firePropertyChange(key, old, value);
        }
    }
}

