/**************************************************************************
 * FILE NAME: MAC57D54H.h                    COPYRIGHT (c) Freescale 2016 *
 * REVISION:  5.0.0.1                                 All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the Halo.                                                              *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1    M. Doidge   04-DEC-13     First generation from RDP             *
 *                                                                        *
 * 0.2    M. Doidge   05-DEC-13     Corrected QuadSPI LUT register def    *
 *                                                                        *
 * 0.3    M. Doidge   06-DEC-13     Added CA5 module and updates made to  *
 *                                  GPU2D and CM4 modules                 *
 * 0.4    M. Doidge   16-DEC-13     Re-Generated from updated RDP         *
 *                                                                        *
 * 0.5    M. Doidge   27-FEB-14     Re-Generated from updated draft RDP   *
 *                                                                        *
 * 1.0    M. Doidge   09-APR-14     Generated from updated RDP Rev1       *
 *                                                                        *
 * 1.1    M. Doidge   28-APR-14     Generated from updated RDP Rev1.1     *
 *                                                                        *
 * 1.1.1  M. Doidge   29-APR-14     Added SGM module                      *
 *                                                                        *
 * 1.2.0  M. Doidge   22-MAY-14     Generated from updated RDP Rev1.2     *
 *                                                                        *
 * 1.2.1  M. Doidge   05-JUN-14     Generated from updated RDP Rev1.2     *
 *                                                                        *
 * 3.0.0  M. Doidge   09-DEC-14     Generated from RDP Rev3 Draft B       *
 *                                                                        *
 * 3.0.1  M. Doidge   10-DEC-14     Updated DMAMUX, eDMA, and SEMA42      *
 *                                                                        *
 * 3.0.2  M. Doidge   13-AUG-15     Generated from RDP Rev3               *
 *                                                                        *
 * 3.0.3  M. Doidge   25-AUG-15     Removed array formatting from SMC     *
 *                                                                        *
 * 4.0.0  M. Doidge   20-JAN-16     Generated from RDP Rev4               *
 *                                                                        *
 * 4.0.1  M. Doidge   25-JAN-16     Per Pooja Dhiman, the base address of *
 *                                  MC_PCTL193 (DMA_1) is 0x182 and       *
 *                                  ME_PCTL192 (DMA_0) is 0x183           *
 *                                                                        *
 * 4.0.2  M. Doidge   20-MAY-16     Generated from RDP 04.may.2016        *
 *                                  CAN update                            *
 *                                                                        *
 * 5.0.0  M. Doidge   04-OCT-16     Generated from RDP Rev5               *
 *                                                                        *
 * 5.0.0.1  A. Kala     05-OCT-16   Added CM4 Module                      *
 * 									Fixed MSCR subscript range from 360 to 1024*
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MAC57D54H_H_
#define _MAC57D54H_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif

/**************************************************************************/
/*                                            Module: CM4                                                               */
/**************************************************************************/

struct CM4_tag {
    uint8_t CM4_reserved0[57348];

    union {
        vuint32_t R;
        struct {
           vuint32_t INTLINESNUM:4;
           vuint32_t:28;
        } B;
    } ICTR;				/*0000E004*/

    union {
        vuint32_t R;
        struct {
           vuint32_t DISMCYCINT:1;
           vuint32_t DISDEFWBUF:1;
           vuint32_t DISFOLD:1;
           vuint32_t:5;
           vuint32_t DISFPCA:1;
           vuint32_t DISOOFP:1;
           vuint32_t:22;
        } B;
    } ACTLR;				/*0000E008*/

    uint8_t CM4_reserved1[4];

    union {
        vuint32_t R;
        struct {
           vuint32_t ENABLE:1;
           vuint32_t TICKINT:1;
           vuint32_t CLKSOURCE:1;
           vuint32_t:13;
           vuint32_t COUNTFLAG:1;
           vuint32_t:15;
        } B;
    } STCSR;				/*0000E010*/

    union {
        vuint32_t R;
        struct {
           vuint32_t RELOAD:24;
           vuint32_t:8;
        } B;
    } STRVR;				/*0000E014*/

    union {
        vuint32_t R;
        struct {
           vuint32_t CURRENT:24;
           vuint32_t:8;
        } B;
    } STCVR;				/*0000E018*/

    union {
        vuint32_t R;
        struct {
           vuint32_t TENMS:24;
           vuint32_t:6;
           vuint32_t SKEW:1;
           vuint32_t NOREF:1;
        } B;
    } STCR;				/*0000E01C*/

    uint8_t CM4_reserved2[224];

    union {
        vuint32_t R;
        struct {
           vuint32_t SETENA:32;
        } B;
    } NVIC_ISER[8];				/*0000E100*/

    uint8_t CM4_reserved3[96];

    union {
        vuint32_t R;
        struct {
           vuint32_t CLRENA:32;
        } B;
    } NVIC_ICER[8];				/*0000E180*/

    uint8_t CM4_reserved4[96];

    union {
        vuint32_t R;
        struct {
           vuint32_t SETPEND:32;
        } B;
    } NVIC_ISPR[8];				/*0000E200*/

    uint8_t CM4_reserved5[96];

    union {
        vuint32_t R;
        struct {
           vuint32_t CLRPEND:32;
        } B;
    } NVIC_ICPR[8];				/*0000E280*/

    uint8_t CM4_reserved6[96];

    union {
        vuint32_t R;
        struct {
           vuint32_t ACTIVE:32;
        } B;
    } NVIC_IABR[8];				/*0000E300*/

    uint8_t CM4_reserved7[224];

    union {
        vuint32_t R;
        struct {
           vuint32_t PRI_N0:8;
           vuint32_t PRI_N1:8;
           vuint32_t PRI_N2:8;
           vuint32_t PRI_N3:8;
        } B;
    } NVIC_IPR[60];				/*0000E400*/

    uint8_t CM4_reserved8[2064];

    union {
        vuint32_t R;
        struct {
           vuint32_t REVISION:4;
           vuint32_t PARTNO:12;
           vuint32_t:4;
           vuint32_t VARIANT:4;
           vuint32_t IMPLEMENTER:8;
        } B;
    } CPUID;				/*0000ED00*/

    union {
        vuint32_t R;
        struct {
           vuint32_t VECTACTIVE:9;
           vuint32_t:2;
           vuint32_t RETTOBASE:1;
           vuint32_t VECTPENDING:10;
           vuint32_t ISRPENDING:1;
           vuint32_t:2;
           vuint32_t PENDSTCLR:1;
           vuint32_t PENDSTSET:1;
           vuint32_t PENDSVCLR:1;
           vuint32_t PENDSVSET:1;
           vuint32_t:2;
           vuint32_t NMIPENDSET:1;
        } B;
    } ICSR;				/*0000ED04*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:7;
           vuint32_t TBLOFF:25;
        } B;
    } VTOR;				/*0000ED08*/

    union {
        vuint32_t R;
        struct {
           vuint32_t VECTRESET:1;
           vuint32_t VECTCLRACTIVE:1;
           vuint32_t SYSRESETREQ:1;
           vuint32_t:5;
           vuint32_t PRIGROUP:3;
           vuint32_t:4;
           vuint32_t ENDIANNESS:1;
           vuint32_t VECTKEYSTAT:16;
        } B;
    } AIRCR;				/*0000ED0C*/

    union {
        vuint32_t R;
        struct {
        	 vuint32_t:1;
           vuint32_t SLEEPONEXIT:1;
           vuint32_t SLEEPDEEP:1;
           vuint32_t:1;
           vuint32_t SEVONPEND:1;
           vuint32_t:27;
        } B;
    } SCR;				/*0000ED10*/

    union {
        vuint32_t R;
        struct {
           vuint32_t NONBASETHRDENA:1;
           vuint32_t USERSETMPEND:1;
           vuint32_t:1;
           vuint32_t UNALIGN_TRP:1;
           vuint32_t DIV_0_TRP:1;
           vuint32_t:3;
           vuint32_t BFHFNMIGN:1;
           vuint32_t STKALIGN:1;
           vuint32_t:22;
        } B;
    } CCR;				/*0000ED14*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PRI_4:8;
           vuint32_t PRI_5:8;
           vuint32_t PRI_6:8;
           vuint32_t:8;
        } B;
    } SHPR1;				/*0000ED18*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:24;
           vuint32_t PRI_11:8;
        } B;
    } SHPR2;				/*0000ED1C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:16;
           vuint32_t PRI_14:8;
           vuint32_t PRI_15:8;
        } B;
    } SHPR3;				/*0000ED20*/

    union {
        vuint32_t R;
        struct {
           vuint32_t MEMFAULTACT:1;
           vuint32_t BUSFAULTACT:1;
           vuint32_t:1;
           vuint32_t USGFAULTACT:1;
           vuint32_t:3;
           vuint32_t SVCALLACT:1;
           vuint32_t MONITORACT:1;
           vuint32_t:1;
           vuint32_t PENDSVACT:1;
           vuint32_t SYSTICKACT:1;
           vuint32_t USGFAULTPENDED:1;
           vuint32_t MEMFAULTPENDED:1;
           vuint32_t BUSFAULTPENDED:1;
           vuint32_t SVCALLPENDED:1;
           vuint32_t MEMFAULTENA:1;
           vuint32_t BUSFAULTENA:1;
           vuint32_t USGFAULTENA:1;
           vuint32_t:13;
        } B;
    } SHCSR;				/*0000ED24*/

    union {
        vuint32_t R;
        struct {
           vuint32_t MMFSR:8;
           vuint32_t BFSR:8;
           vuint32_t UFSR:16;
        } B;
    } CFSR;				/*0000ED28*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:1;
           vuint32_t VECTTBL:1;
           vuint32_t:28;
           vuint32_t FORCED:1;
           vuint32_t DEBUGEVT:1;
        } B;
    } HFSR;				/*0000ED2C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t HALTED:1;
           vuint32_t BKPT:1;
           vuint32_t DWTTRAP:1;
           vuint32_t VCATCH:1;
           vuint32_t EXTERNAL:1;
           vuint32_t:27;
        } B;
    } DFSR;				/*0000ED30*/

    union {
        vuint32_t R;
        struct {
           vuint32_t ADDRESS:32;
        } B;
    } MMFAR;				/*0000ED34*/

    union {
        vuint32_t R;
        struct {
           vuint32_t ADDRESS:32;
        } B;
    } BFAR;				/*0000ED38*/

    union {
        vuint32_t R;
        struct {
           vuint32_t IMPDEF:32;
        } B;
    } AFSR;				/*0000ED3C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t STATE0:4;
           vuint32_t STATE1:4;
           vuint32_t STATE2:4;
           vuint32_t STATE3:4;
           vuint32_t:16;
        } B;
    } ID_PFR0;				/*0000ED40*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:8;
           vuint32_t M_PROFILE_PROGRAMMERS_MODEL:4;
           vuint32_t:20;
        } B;
    } ID_PFR1;				/*0000ED44*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:20;
           vuint32_t DEBUG_MODEL_M_PROFILE:4;
           vuint32_t:8;
        } B;
    } ID_DFR0;				/*0000ED48*/

    union {
        vuint32_t R;
        struct {
           vuint32_t ID_AFR0_0:4;
           vuint32_t ID_AFR0_4:4;
           vuint32_t ID_AFR0_8:4;
           vuint32_t ID_AFR0_12:4;
           vuint32_t:16;
        } B;
    } ID_AFR0;				/*0000ED4C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:4;
           vuint32_t PMSA_SUPPORT:4;
           vuint32_t OUTERMOST_SHAREABILITY:4;
           vuint32_t SHAREABILITY_LEVELS:4;
           vuint32_t:4;
           vuint32_t AUXILIARY_REGISTERS:4;
           vuint32_t:8;
        } B;
    } ID_MMFR0;				/*0000ED50*/

    union {
        vuint32_t R;
        struct {
           vuint32_t ID_MMFR1:32;
        } B;
    } ID_MMFR1;				/*0000ED54*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:24;
           vuint32_t WFI_STALL:4;
           vuint32_t:4;
        } B;
    } ID_MMFR2;				/*0000ED58*/

    union {
        vuint32_t R;
        struct {
        	 vuint32_t ID_MMFR3:32;
        } B;
    } ID_MMFR3;				/*0000ED5C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:4;
           vuint32_t BITCOUNT_INSTRS:4;
           vuint32_t BITFIELD_INSTRS:4;
           vuint32_t CMPBRANCH_INSTRS:4;
           vuint32_t COPROC_INSTRS:4;
           vuint32_t DEBUG_INSTRS:4;
           vuint32_t DIVIDE_INSTRS:4;
           vuint32_t:4;
        } B;
    } ID_ISAR0;				/*0000ED60*/

    union {
        vuint32_t R;
        struct {
           vuint32_t:12;
           vuint32_t EXTEND_INSTRS:4;
           vuint32_t IFTHEN_INSTRS:4;
           vuint32_t IMMEDIATE_INSTRS:4;
           vuint32_t INTERWORK_INSTRS:4;
           vuint32_t:4;
        } B;
    } ID_ISAR1;				/*0000ED64*/

    union {
        vuint32_t R;
        struct {
           vuint32_t LOADSTORE_INSTRS:4;
           vuint32_t MEMHINT_INSTRS:4;
           vuint32_t MULTIACCESSINT_INSTRS:4;
           vuint32_t MULT_INSTRS:4;
           vuint32_t MULTS_INSTRS:4;
           vuint32_t MULTU_INSTRS:4;
           vuint32_t:4;
           vuint32_t REVERSAL_INSTRS:4;
        } B;
    } ID_ISAR2;				/*0000ED68*/

    union {
        vuint32_t R;
        struct {
           vuint32_t SATURATE_INSTRS:4;
           vuint32_t SIMD_INSTRS:4;
           vuint32_t SVC_INSTRS:4;
           vuint32_t SYNCHPRIM_INSTRS:4;
           vuint32_t TABBRANCH_INSTRS:4;
           vuint32_t THUMBCOPY_INSTRS:4;
           vuint32_t TRUENOP_INSTRS:4;
           vuint32_t:4;
        } B;
    } ID_ISAR3;				/*0000ED6C*/

    union {
        vuint32_t R;
        struct {
           vuint32_t UNPRIV_INSTRS:4;
           vuint32_t WITHSHIFTS_INSTRS:4;
           vuint32_t WRITEBACK_INSTRS:4;
           vuint32_t:4;
           vuint32_t BARRIER_INSTRS:4;
           vuint32_t SYNCHPRIM_INSTRS_FRAC:4;
           vuint32_t PSR_M_INSTRS:4;
           vuint32_t:4;
        } B;
    } ID_ISAR4;				/*0000ED70*/

    uint8_t CM4_reserved10[124];

    union {
        vuint32_t R;
        struct {
           vuint32_t C_DEBUGEN:1;
           vuint32_t C_HALT:1;
           vuint32_t C_STEP:1;
           vuint32_t C_MASKINTS:1;
           vuint32_t:1;
           vuint32_t C_SNAPSTALL:1;
           vuint32_t:10;
           vuint32_t S_REGRDY:1;
           vuint32_t S_HALT:1;
           vuint32_t S_SLEEP:1;
           vuint32_t S_LOCKUP:1;
           vuint32_t:4;
           vuint32_t S_RETIRE_ST:1;
           vuint32_t S_RESET_ST:1;
	         vuint32_t:6;
	} B;
    } DHCSR;				/*0000EDF0*/

    union {
        vuint32_t R;
        struct {
           vuint32_t REGSEL:5;
           vuint32_t:11;
           vuint32_t REGWnR:1;
           vuint32_t:15;
        } B;
    } DCRSR;				/*0000EDF4*/

    union {
        vuint32_t R;
        struct {
           vuint32_t DBGTMP:32;
        } B;
    } DCRDR;				/*0000EDF8*/

    union {
        vuint32_t R;
        struct {
           vuint32_t VC_CORERESET:1;
           vuint32_t:3;
           vuint32_t VC_MMERR:1;
           vuint32_t VC_NOCPERR:1;
           vuint32_t VC_CHKERR:1;
           vuint32_t VC_STATERR:1;
           vuint32_t VC_BUSERR:1;
           vuint32_t VC_INTERR:1;
           vuint32_t VC_HARDERR:1;
           vuint32_t:5;
           vuint32_t MON_EN:1;
           vuint32_t MON_PEND:1;
           vuint32_t MON_STEP:1;
           vuint32_t MON_REQ:1;
           vuint32_t:4;
           vuint32_t TRCENA:1;
           vuint32_t:7;
        } B;
    } DEMCR;				/*0000EDFC*/

    uint8_t CM4_reserved11[256];

    union {
        vuint32_t R;
        struct {
           vuint32_t INTID:9;
           vuint32_t:23;
        } B;
    } STIR;				/*0000EF00*/

    uint8_t CM4_reserved12[204];

    union {
        vuint32_t R;
        struct {
           vuint32_t PID4:32;
        } B;
    } PID4;				/*0000EFD0*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID5:32;
        } B;
    } PID5;				/*0000EFD4*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID6:32;
        } B;
    } PID6;				/*0000EFD8*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID7:32;
        } B;
    } PID7;				/*0000EFDC*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID0:32;
        } B;
    } PID0;				/*0000EFE0*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID1:32;
        } B;
    } PID1;				/*0000EFE4*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID2:32;
        } B;
    } PID2;				/*0000EFE8*/

    union {
        vuint32_t R;
        struct {
           vuint32_t PID3:32;
        } B;
    } PID3;				/*0000EFEC*/

    union {
        vuint32_t R;
        struct {
           vuint32_t DUMMY_NOBIT:32;
        } B;
    } CID[4];				/*0000EFF0*/

};


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t PWDN:1;                  /* Power-down enable. */
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t _unused_3:2;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t _unused_9:6;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:2;
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t JEDGE:1;                 /* Injection trigger edge selection. */
    vuint32_t JTRGEN:1;                /* Injection external trigger enable. */
    vuint32_t _unused_23:1;
    vuint32_t NSTART:1;                /* Start conversion. */
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_28:1;
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t OWREN:1;                 /* Overwrite enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
    vuint32_t _unused_3:2;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_6:3;
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t _unused_21:2;
    vuint32_t _unused_23:1;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t _unused_25:6;
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t ECH:1;                   /* End of chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH16:1;               /* EOC Channel 16. */
    vuint32_t EOCCH17:1;               /* EOC Channel 17. */
    vuint32_t EOCCH18:1;               /* EOC Channel 18. */
    vuint32_t EOCCH19:1;               /* EOC Channel 19. */
    vuint32_t EOCCH20:1;               /* EOC Channel 20. */
    vuint32_t EOCCH21:1;               /* EOC Channel 21. */
    vuint32_t EOCCH22:1;               /* EOC Channel 22. */
    vuint32_t EOCCH23:1;               /* EOC Channel 23. */
    vuint32_t EOCCH24:1;               /* EOC Channel 24. */
    vuint32_t EOCCH25:1;               /* EOC Channel 25. */
    vuint32_t EOCCH26:1;               /* EOC Channel 26. */
    vuint32_t EOCCH27:1;               /* EOC Channel 27. */
    vuint32_t EOCCH28:1;               /* EOC Channel 28. */
    vuint32_t EOCCH29:1;               /* EOC Channel 29. */
    vuint32_t EOCCH30:1;               /* EOC Channel 30. */
    vuint32_t EOCCH31:1;               /* EOC Channel 31. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_CEOCFR1_union_tag {  /* Channel Pending register 1 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH32:1;               /* EOC Channel 32. */
    vuint32_t EOCCH33:1;               /* EOC Channel 33. */
    vuint32_t EOCCH34:1;               /* EOC Channel 34. */
    vuint32_t EOCCH35:1;               /* EOC Channel 35. */
    vuint32_t EOCCH36:1;               /* EOC Channel 36. */
    vuint32_t EOCCH37:1;               /* EOC Channel 37. */
    vuint32_t EOCCH38:1;               /* EOC Channel 38. */
    vuint32_t EOCCH39:1;               /* EOC Channel 39. */
    vuint32_t EOCCH40:1;               /* EOC Channel 40. */
    vuint32_t EOCCH41:1;               /* EOC Channel 41. */
    vuint32_t EOCCH42:1;               /* EOC Channel 42. */
    vuint32_t EOCCH43:1;               /* EOC Channel 43. */
    vuint32_t EOCCH44:1;               /* EOC Channel 44. */
    vuint32_t EOCCH45:1;               /* EOC Channel 45. */
    vuint32_t EOCCH46:1;               /* EOC Channel 46. */
    vuint32_t EOCCH47:1;               /* EOC Channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_CEOCFR1_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:10;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:16;
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM16:1;                 /* Channel 16 interrupt enable. */
    vuint32_t CIM17:1;                 /* Channel 17 interrupt enable. */
    vuint32_t CIM18:1;                 /* Channel 18 interrupt enable. */
    vuint32_t CIM19:1;                 /* Channel 19 interrupt enable. */
    vuint32_t CIM20:1;                 /* Channel 20 interrupt enable. */
    vuint32_t CIM21:1;                 /* Channel 21 interrupt enable. */
    vuint32_t CIM22:1;                 /* Channel 22 interrupt enable. */
    vuint32_t CIM23:1;                 /* Channel 23 interrupt enable. */
    vuint32_t CIM24:1;                 /* Channel 24 interrupt enable. */
    vuint32_t CIM25:1;                 /* Channel 25 interrupt enable. */
    vuint32_t CIM26:1;                 /* Channel 26 interrupt enable. */
    vuint32_t CIM27:1;                 /* Channel 27 interrupt enable. */
    vuint32_t CIM28:1;                 /* Channel 28 interrupt enable. */
    vuint32_t CIM29:1;                 /* Channel 29 interrupt enable. */
    vuint32_t CIM30:1;                 /* Channel 30 interrupt enable. */
    vuint32_t CIM31:1;                 /* Channel 31 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_CIMR1_union_tag {    /* Channel Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CIM32:1;                 /* Channel 32 interrupt enable. */
    vuint32_t CIM33:1;                 /* Channel 33 interrupt enable. */
    vuint32_t CIM34:1;                 /* Channel 34 interrupt enable. */
    vuint32_t CIM35:1;                 /* Channel 35 interrupt enable. */
    vuint32_t CIM36:1;                 /* Channel 36 interrupt enable. */
    vuint32_t CIM37:1;                 /* Channel 37 interrupt enable. */
    vuint32_t CIM38:1;                 /* Channel 38 interrupt enable. */
    vuint32_t CIM39:1;                 /* Channel 39 interrupt enable. */
    vuint32_t CIM40:1;                 /* Channel 40 interrupt enable. */
    vuint32_t CIM41:1;                 /* Channel 41 interrupt enable. */
    vuint32_t CIM42:1;                 /* Channel 42 interrupt enable. */
    vuint32_t CIM43:1;                 /* Channel 43 interrupt enable. */
    vuint32_t CIM44:1;                 /* Channel 44 interrupt enable. */
    vuint32_t CIM45:1;                 /* Channel 45 interrupt enable. */
    vuint32_t CIM46:1;                 /* Channel 46 interrupt enable. */
    vuint32_t CIM47:1;                 /* Channel 47 interrupt enable. */
    vuint32_t _unused_16:16;
  } B;
} ADC_CIMR1_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t WDG0L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG5H:1;
    vuint32_t WDG6L:1;
    vuint32_t WDG6H:1;
    vuint32_t WDG7L:1;
    vuint32_t WDG7H:1;
    vuint32_t WDG8L:1;
    vuint32_t WDG8H:1;
    vuint32_t WDG9L:1;
    vuint32_t WDG9H:1;
    vuint32_t WDG10L:1;
    vuint32_t WDG10H:1;
    vuint32_t WDG11L:1;
    vuint32_t WDG11H:1;
    vuint32_t WDG12L:1;
    vuint32_t WDG12H:1;
    vuint32_t WDG13L:1;
    vuint32_t WDG13H:1;
    vuint32_t WDG14L:1;
    vuint32_t WDG14H:1;
    vuint32_t WDG15L:1;
    vuint32_t WDG15H:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKWDG0L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG6L:1;
    vuint32_t MSKWDG6H:1;
    vuint32_t MSKWDG7L:1;
    vuint32_t MSKWDG7H:1;
    vuint32_t MSKWDG8L:1;
    vuint32_t MSKWDG8H:1;
    vuint32_t MSKWDG9L:1;
    vuint32_t MSKWDG9H:1;
    vuint32_t MSKWDG10L:1;
    vuint32_t MSKWDG10H:1;
    vuint32_t MSKWDG11L:1;
    vuint32_t MSKWDG11H:1;
    vuint32_t MSKWDG12L:1;
    vuint32_t MSKWDG12H:1;
    vuint32_t MSKWDG13L:1;
    vuint32_t MSKWDG13H:1;
    vuint32_t MSKWDG14L:1;
    vuint32_t MSKWDG14H:1;
    vuint32_t MSKWDG15L:1;
    vuint32_t MSKWDG15H:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t DMAEN:1;                 /* DMA global enable. */
    vuint32_t DCLR:1;                  /* DMA Clear sequence enable. */
    vuint32_t _unused_2:30;
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA16:1;                 /* DMA enable for channel 16. */
    vuint32_t DMA17:1;                 /* DMA enable for channel 17. */
    vuint32_t DMA18:1;                 /* DMA enable for channel 18. */
    vuint32_t DMA19:1;                 /* DMA enable for channel 19. */
    vuint32_t DMA20:1;                 /* DMA enable for channel 20. */
    vuint32_t DMA21:1;                 /* DMA enable for channel 21. */
    vuint32_t DMA22:1;                 /* DMA enable for channel 22. */
    vuint32_t DMA23:1;                 /* DMA enable for channel 23. */
    vuint32_t DMA24:1;                 /* DMA enable for channel 24. */
    vuint32_t DMA25:1;                 /* DMA enable for channel 25. */
    vuint32_t DMA26:1;                 /* DMA enable for channel 26. */
    vuint32_t DMA27:1;                 /* DMA enable for channel 27. */
    vuint32_t DMA28:1;                 /* DMA enable for channel 28. */
    vuint32_t DMA29:1;                 /* DMA enable for channel 29. */
    vuint32_t DMA30:1;                 /* DMA enable for channel 30. */
    vuint32_t DMA31:1;                 /* DMA enable for channel 31. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_DMAR1_union_tag {    /* DMA Channel Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DMA32:1;                 /* DMA enable for channel 32. */
    vuint32_t DMA33:1;                 /* DMA enable for channel 33. */
    vuint32_t DMA34:1;                 /* DMA enable for channel 34. */
    vuint32_t DMA35:1;                 /* DMA enable for channel 35. */
    vuint32_t DMA36:1;                 /* DMA enable for channel 36. */
    vuint32_t DMA37:1;                 /* DMA enable for channel 37. */
    vuint32_t DMA38:1;                 /* DMA enable for channel 38. */
    vuint32_t DMA39:1;                 /* DMA enable for channel 39. */
    vuint32_t DMA40:1;                 /* DMA enable for channel 40. */
    vuint32_t DMA41:1;                 /* DMA enable for channel 41. */
    vuint32_t DMA42:1;                 /* DMA enable for channel 42. */
    vuint32_t DMA43:1;                 /* DMA enable for channel 43. */
    vuint32_t DMA44:1;                 /* DMA enable for channel 44. */
    vuint32_t DMA45:1;                 /* DMA enable for channel 45. */
    vuint32_t DMA46:1;                 /* DMA enable for channel 46. */
    vuint32_t DMA47:1;                 /* DMA enable for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_DMAR1_tag;

typedef union ADC_THRHLR0_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR0_tag;

typedef union ADC_THRHLR1_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR1_tag;

typedef union ADC_THRHLR2_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR2_tag;

typedef union ADC_THRHLR3_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR3_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t PRECONV:1;               /* Convert Presampled value */
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PREVAL1:2;               /* Internal voltage selection for Presampling. */
    vuint32_t _unused_5:2;
    vuint32_t _unused_7:25;
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES16:1;                /* Presampling enable for channel 16. */
    vuint32_t PRES17:1;                /* Presampling enable for channel 17. */
    vuint32_t PRES18:1;                /* Presampling enable for channel 18. */
    vuint32_t PRES19:1;                /* Presampling enable for channel 19. */
    vuint32_t PRES20:1;                /* Presampling enable for channel 20. */
    vuint32_t PRES21:1;                /* Presampling enable for channel 21. */
    vuint32_t PRES22:1;                /* Presampling enable for channel 22. */
    vuint32_t PRES23:1;                /* Presampling enable for channel 23. */
    vuint32_t PRES24:1;                /* Presampling enable for channel 24. */
    vuint32_t PRES25:1;                /* Presampling enable for channel 25. */
    vuint32_t PRES26:1;                /* Presampling enable for channel 26. */
    vuint32_t PRES27:1;                /* Presampling enable for channel 27. */
    vuint32_t PRES28:1;                /* Presampling enable for channel 28. */
    vuint32_t PRES29:1;                /* Presampling enable for channel 29. */
    vuint32_t PRES30:1;                /* Presampling enable for channel 30. */
    vuint32_t PRES31:1;                /* Presampling enable for channel 31. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_PSR1_union_tag {     /* Presampling register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRES32:1;                /* Presampling enable for channel 32. */
    vuint32_t PRES33:1;                /* Presampling enable for channel 33. */
    vuint32_t PRES34:1;                /* Presampling enable for channel 34. */
    vuint32_t PRES35:1;                /* Presampling enable for channel 35. */
    vuint32_t PRES36:1;                /* Presampling enable for channel 36. */
    vuint32_t PRES37:1;                /* Presampling enable for channel 37. */
    vuint32_t PRES38:1;                /* Presampling enable for channel 38. */
    vuint32_t PRES39:1;                /* Presampling enable for channel 39. */
    vuint32_t PRES40:1;                /* Presampling enable for channel 40. */
    vuint32_t PRES41:1;                /* Presampling enable for channel 41. */
    vuint32_t PRES42:1;                /* Presampling enable for channel 42. */
    vuint32_t PRES43:1;                /* Presampling enable for channel 43. */
    vuint32_t PRES44:1;                /* Presampling enable for channel 44. */
    vuint32_t PRES45:1;                /* Presampling enable for channel 45. */
    vuint32_t PRES46:1;                /* Presampling enable for channel 46. */
    vuint32_t PRES47:1;                /* Presampling enable for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_PSR1_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
    vuint32_t _unused_8:24;
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
    vuint32_t _unused_8:24;
  } B;
} ADC_CTR1_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH16:1;                  /* Normal sampling enable for channel 16. */
    vuint32_t CH17:1;                  /* Normal sampling enable for channel 17. */
    vuint32_t CH18:1;                  /* Normal sampling enable for channel 18. */
    vuint32_t CH19:1;                  /* Normal sampling enable for channel 19. */
    vuint32_t CH20:1;                  /* Normal sampling enable for channel 20. */
    vuint32_t CH21:1;                  /* Normal sampling enable for channel 21. */
    vuint32_t CH22:1;                  /* Normal sampling enable for channel 22. */
    vuint32_t CH23:1;                  /* Normal sampling enable for channel 23. */
    vuint32_t CH24:1;                  /* Normal sampling enable for channel 24. */
    vuint32_t CH25:1;                  /* Normal sampling enable for channel 25. */
    vuint32_t CH26:1;                  /* Normal sampling enable for channel 26. */
    vuint32_t CH27:1;                  /* Normal sampling enable for channel 27. */
    vuint32_t CH28:1;                  /* Normal sampling enable for channel 28. */
    vuint32_t CH29:1;                  /* Normal sampling enable for channel 29. */
    vuint32_t CH30:1;                  /* Normal sampling enable for channel 30. */
    vuint32_t CH31:1;                  /* Normal sampling enable for channel 31. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_NCMR1_union_tag {    /* Normal Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH32:1;                  /* Normal sampling enable for channel 32. */
    vuint32_t CH33:1;                  /* Normal sampling enable for channel 33. */
    vuint32_t CH34:1;                  /* Normal sampling enable for channel 34. */
    vuint32_t CH35:1;                  /* Normal sampling enable for channel 35. */
    vuint32_t CH36:1;                  /* Normal sampling enable for channel 36. */
    vuint32_t CH37:1;                  /* Normal sampling enable for channel 37. */
    vuint32_t CH38:1;                  /* Normal sampling enable for channel 38. */
    vuint32_t CH39:1;                  /* Normal sampling enable for channel 39. */
    vuint32_t CH40:1;                  /* Normal sampling enable for channel 40. */
    vuint32_t CH41:1;                  /* Normal sampling enable for channel 41. */
    vuint32_t CH42:1;                  /* Normal sampling enable for channel 42. */
    vuint32_t CH43:1;                  /* Normal sampling enable for channel 43. */
    vuint32_t CH44:1;                  /* Normal sampling enable for channel 44. */
    vuint32_t CH45:1;                  /* Normal sampling enable for channel 45. */
    vuint32_t CH46:1;                  /* Normal sampling enable for channel 46. */
    vuint32_t CH47:1;                  /* Normal sampling enable for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_NCMR1_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH16:1;                  /* Injected sampling enable for channel 16. */
    vuint32_t CH17:1;                  /* Injected sampling enable for channel 17. */
    vuint32_t CH18:1;                  /* Injected sampling enable for channel 18. */
    vuint32_t CH19:1;                  /* Injected sampling enable for channel 19. */
    vuint32_t CH20:1;                  /* Injected sampling enable for channel 20. */
    vuint32_t CH21:1;                  /* Injected sampling enable for channel 21. */
    vuint32_t CH22:1;                  /* Injected sampling enable for channel 22. */
    vuint32_t CH23:1;                  /* Injected sampling enable for channel 23. */
    vuint32_t CH24:1;                  /* Injected sampling enable for channel 24. */
    vuint32_t CH25:1;                  /* Injected sampling enable for channel 25. */
    vuint32_t CH26:1;                  /* Injected sampling enable for channel 26. */
    vuint32_t CH27:1;                  /* Injected sampling enable for channel 27. */
    vuint32_t CH28:1;                  /* Injected sampling enable for channel 28. */
    vuint32_t CH29:1;                  /* Injected sampling enable for channel 29. */
    vuint32_t CH30:1;                  /* Injected sampling enable for channel 30. */
    vuint32_t CH31:1;                  /* Injected sampling enable for channel 31. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_JCMR1_union_tag {    /* Injected Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CH32:1;                  /* Injected sampling enable for channel 32. */
    vuint32_t CH33:1;                  /* Injected sampling enable for channel 33. */
    vuint32_t CH34:1;                  /* Injected sampling enable for channel 34. */
    vuint32_t CH35:1;                  /* Injected sampling enable for channel 35. */
    vuint32_t CH36:1;                  /* Injected sampling enable for channel 36. */
    vuint32_t CH37:1;                  /* Injected sampling enable for channel 37. */
    vuint32_t CH38:1;                  /* Injected sampling enable for channel 38. */
    vuint32_t CH39:1;                  /* Injected sampling enable for channel 39. */
    vuint32_t CH40:1;                  /* Injected sampling enable for channel 40. */
    vuint32_t CH41:1;                  /* Injected sampling enable for channel 41. */
    vuint32_t CH42:1;                  /* Injected sampling enable for channel 42. */
    vuint32_t CH43:1;                  /* Injected sampling enable for channel 43. */
    vuint32_t CH44:1;                  /* Injected sampling enable for channel 44. */
    vuint32_t CH45:1;                  /* Injected sampling enable for channel 45. */
    vuint32_t CH46:1;                  /* Injected sampling enable for channel 46. */
    vuint32_t CH47:1;                  /* Injected sampling enable for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_JCMR1_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t PDED:8;
    vuint32_t _unused_8:24;
  } B;
} ADC_PDEDR_tag;

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
    vuint32_t RESULT:2;
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t _unused_20:12;
  } B;
} ADC_CDR_tag;

typedef union ADC_THRHLR4_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR4_tag;

typedef union ADC_THRHLR5_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR5_tag;

typedef union ADC_THRHLR6_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR6_tag;

typedef union ADC_THRHLR7_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR7_tag;

typedef union ADC_THRHLR8_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR8_tag;

typedef union ADC_THRHLR9_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR9_tag;

typedef union ADC_THRHLR10_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR10_tag;

typedef union ADC_THRHLR11_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR11_tag;

typedef union ADC_THRHLR12_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR12_tag;

typedef union ADC_THRHLR13_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR13_tag;

typedef union ADC_THRHLR14_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR14_tag;

typedef union ADC_THRHLR15_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_28:4;
  } B;
} ADC_THRHLR15_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWSELR2_union_tag {  /* Channel Watchdog Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH16:4;             /* Channel Watchdog select for channel 16. */
    vuint32_t WSEL_CH17:4;             /* Channel Watchdog select for channel 17. */
    vuint32_t WSEL_CH18:4;             /* Channel Watchdog select for channel 18. */
    vuint32_t WSEL_CH19:4;             /* Channel Watchdog select for channel 19. */
    vuint32_t WSEL_CH20:4;             /* Channel Watchdog select for channel 20. */
    vuint32_t WSEL_CH21:4;             /* Channel Watchdog select for channel 21. */
    vuint32_t WSEL_CH22:4;             /* Channel Watchdog select for channel 22. */
    vuint32_t WSEL_CH23:4;             /* Channel Watchdog select for channel 23. */
  } B;
} ADC_CWSELR2_tag;

typedef union ADC_CWSELR3_union_tag {  /* Channel Watchdog Select Register 3 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH24:4;             /* Channel Watchdog select for channel 24. */
    vuint32_t WSEL_CH25:4;             /* Channel Watchdog select for channel 25. */
    vuint32_t WSEL_CH26:4;             /* Channel Watchdog select for channel 26. */
    vuint32_t WSEL_CH27:4;             /* Channel Watchdog select for channel 27. */
    vuint32_t WSEL_CH28:4;             /* Channel Watchdog select for channel 28. */
    vuint32_t WSEL_CH29:4;             /* Channel Watchdog select for channel 29. */
    vuint32_t WSEL_CH30:4;             /* Channel Watchdog select for channel 30. */
    vuint32_t WSEL_CH31:4;             /* Channel Watchdog select for channel 31. */
  } B;
} ADC_CWSELR3_tag;

typedef union ADC_CWSELR4_union_tag {  /* Channel Watchdog Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH32:4;             /* Channel Watchdog select for channel 32. */
    vuint32_t WSEL_CH33:4;             /* Channel Watchdog select for channel 33. */
    vuint32_t WSEL_CH34:4;             /* Channel Watchdog select for channel 34. */
    vuint32_t WSEL_CH35:4;             /* Channel Watchdog select for channel 35. */
    vuint32_t WSEL_CH36:4;             /* Channel Watchdog select for channel 36. */
    vuint32_t WSEL_CH37:4;             /* Channel Watchdog select for channel 37. */
    vuint32_t WSEL_CH38:4;             /* Channel Watchdog select for channel 38. */
    vuint32_t WSEL_CH39:4;             /* Channel Watchdog select for channel 39. */
  } B;
} ADC_CWSELR4_tag;

typedef union ADC_CWSELR5_union_tag {  /* Channel Watchdog Select Register 5 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH40:4;             /* Channel Watchdog select for channel 40. */
    vuint32_t WSEL_CH41:4;             /* Channel Watchdog select for channel 41. */
    vuint32_t WSEL_CH42:4;             /* Channel Watchdog select for channel 42. */
    vuint32_t WSEL_CH43:4;             /* Channel Watchdog select for channel 43. */
    vuint32_t WSEL_CH44:4;             /* Channel Watchdog select for channel 44. */
    vuint32_t WSEL_CH45:4;             /* Channel Watchdog select for channel 45. */
    vuint32_t WSEL_CH46:4;             /* Channel Watchdog select for channel 46. */
    vuint32_t WSEL_CH47:4;             /* Channel Watchdog select for channel 47. */
  } B;
} ADC_CWSELR5_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN16:1;                /* Watchdog enable for channel 16. */
    vuint32_t CWEN17:1;                /* Watchdog enable for channel 17. */
    vuint32_t CWEN18:1;                /* Watchdog enable for channel 18. */
    vuint32_t CWEN19:1;                /* Watchdog enable for channel 19. */
    vuint32_t CWEN20:1;                /* Watchdog enable for channel 20. */
    vuint32_t CWEN21:1;                /* Watchdog enable for channel 21. */
    vuint32_t CWEN22:1;                /* Watchdog enable for channel 22. */
    vuint32_t CWEN23:1;                /* Watchdog enable for channel 23. */
    vuint32_t CWEN24:1;                /* Watchdog enable for channel 24. */
    vuint32_t CWEN25:1;                /* Watchdog enable for channel 25. */
    vuint32_t CWEN26:1;                /* Watchdog enable for channel 26. */
    vuint32_t CWEN27:1;                /* Watchdog enable for channel 27. */
    vuint32_t CWEN28:1;                /* Watchdog enable for channel 28. */
    vuint32_t CWEN29:1;                /* Watchdog enable for channel 29. */
    vuint32_t CWEN30:1;                /* Watchdog enable for channel 30. */
    vuint32_t CWEN31:1;                /* Watchdog enable for channel 31. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_CWENR1_union_tag {   /* Channel Watchdog Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CWEN32:1;                /* Watchdog enable for channel 32. */
    vuint32_t CWEN33:1;                /* Watchdog enable for channel 33. */
    vuint32_t CWEN34:1;                /* Watchdog enable for channel 34. */
    vuint32_t CWEN35:1;                /* Watchdog enable for channel 35. */
    vuint32_t CWEN36:1;                /* Watchdog enable for channel 36. */
    vuint32_t CWEN37:1;                /* Watchdog enable for channel 37. */
    vuint32_t CWEN38:1;                /* Watchdog enable for channel 38. */
    vuint32_t CWEN39:1;                /* Watchdog enable for channel 39. */
    vuint32_t CWEN40:1;                /* Watchdog enable for channel 40. */
    vuint32_t CWEN41:1;                /* Watchdog enable for channel 41. */
    vuint32_t CWEN42:1;                /* Watchdog enable for channel 42. */
    vuint32_t CWEN43:1;                /* Watchdog enable for channel 43. */
    vuint32_t CWEN44:1;                /* Watchdog enable for channel 44. */
    vuint32_t CWEN45:1;                /* Watchdog enable for channel 45. */
    vuint32_t CWEN46:1;                /* Watchdog enable for channel 46. */
    vuint32_t CWEN47:1;                /* Watchdog enable for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_CWENR1_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH16:1;             /* Analog watchdog out of range for channel 16. */
    vuint32_t AWOR_CH17:1;             /* Analog watchdog out of range for channel 17. */
    vuint32_t AWOR_CH18:1;             /* Analog watchdog out of range for channel 18. */
    vuint32_t AWOR_CH19:1;             /* Analog watchdog out of range for channel 19. */
    vuint32_t AWOR_CH20:1;             /* Analog watchdog out of range for channel 20. */
    vuint32_t AWOR_CH21:1;             /* Analog watchdog out of range for channel 21. */
    vuint32_t AWOR_CH22:1;             /* Analog watchdog out of range for channel 22. */
    vuint32_t AWOR_CH23:1;             /* Analog watchdog out of range for channel 23. */
    vuint32_t AWOR_CH24:1;             /* Analog watchdog out of range for channel 24. */
    vuint32_t AWOR_CH25:1;             /* Analog watchdog out of range for channel 25. */
    vuint32_t AWOR_CH26:1;             /* Analog watchdog out of range for channel 26. */
    vuint32_t AWOR_CH27:1;             /* Analog watchdog out of range for channel 27. */
    vuint32_t AWOR_CH28:1;             /* Analog watchdog out of range for channel 28. */
    vuint32_t AWOR_CH29:1;             /* Analog watchdog out of range for channel 29. */
    vuint32_t AWOR_CH30:1;             /* Analog watchdog out of range for channel 30. */
    vuint32_t AWOR_CH31:1;             /* Analog watchdog out of range for channel 31. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_AWORR1_union_tag {   /* Analog Watchdog Out of Range Register 1 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH32:1;             /* Analog watchdog out of range for channel 32. */
    vuint32_t AWOR_CH33:1;             /* Analog watchdog out of range for channel 33. */
    vuint32_t AWOR_CH34:1;             /* Analog watchdog out of range for channel 34. */
    vuint32_t AWOR_CH35:1;             /* Analog watchdog out of range for channel 35. */
    vuint32_t AWOR_CH36:1;             /* Analog watchdog out of range for channel 36. */
    vuint32_t AWOR_CH37:1;             /* Analog watchdog out of range for channel 37. */
    vuint32_t AWOR_CH38:1;             /* Analog watchdog out of range for channel 38. */
    vuint32_t AWOR_CH39:1;             /* Analog watchdog out of range for channel 39. */
    vuint32_t AWOR_CH40:1;             /* Analog watchdog out of range for channel 40. */
    vuint32_t AWOR_CH41:1;             /* Analog watchdog out of range for channel 41. */
    vuint32_t AWOR_CH42:1;             /* Analog watchdog out of range for channel 42. */
    vuint32_t AWOR_CH43:1;             /* Analog watchdog out of range for channel 43. */
    vuint32_t AWOR_CH44:1;             /* Analog watchdog out of range for channel 44. */
    vuint32_t AWOR_CH45:1;             /* Analog watchdog out of range for channel 45. */
    vuint32_t AWOR_CH46:1;             /* Analog watchdog out of range for channel 46. */
    vuint32_t AWOR_CH47:1;             /* Analog watchdog out of range for channel 47. */
    vuint32_t _unused_16:16;
  } B;
} ADC_AWORR1_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t TEST_EN:1;               /* Enable the test. */
    vuint32_t _unused_1:2;
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_14:1;
    vuint32_t C_T_BUSY:1;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:3;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t _unused_29:2;
    vuint32_t _unused_31:1;
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET_USER:8;
    vuint32_t _unused_8:8;
    vuint32_t GAIN_USER:10;
    vuint32_t _unused_26:6;
  } B;
} ADC_OFSGNUSR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  ADC_CEOCFR1_tag CEOCFR1;             /* Channel Pending register 1 */
  uint8_t ADC_reserved1[4];
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  ADC_CIMR1_tag CIMR1;                 /* Channel Interrupt Mask Register 1 */
  uint8_t ADC_reserved2[4];
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved3[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  ADC_DMAR1_tag DMAR1;                 /* DMA Channel Select Register 1 */
  uint8_t ADC_reserved4[20];
  ADC_THRHLR0_tag THRHLR0;             /* Threshold Register */
  ADC_THRHLR1_tag THRHLR1;             /* Threshold Register */
  ADC_THRHLR2_tag THRHLR2;             /* Threshold Register */
  ADC_THRHLR3_tag THRHLR3;             /* Threshold Register */
  uint8_t ADC_reserved5[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  ADC_PSR1_tag PSR1;                   /* Presampling register 1 */
  uint8_t ADC_reserved6[8];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  uint8_t ADC_reserved7[8];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  ADC_NCMR1_tag NCMR1;                 /* Normal Conversion Mask Register 1 */
  uint8_t ADC_reserved8[8];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  ADC_JCMR1_tag JCMR1;                 /* Injected Conversion Mask Register 1 */
  uint8_t ADC_reserved9[12];
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved10[52];
  ADC_CDR_tag CDR[48];                 /* Channel Data Register n (Precision Channels) */
  uint8_t ADC_reserved11[192];
  ADC_THRHLR4_tag THRHLR4;             /* Threshold Register */
  ADC_THRHLR5_tag THRHLR5;             /* Threshold Register */
  ADC_THRHLR6_tag THRHLR6;             /* Threshold Register */
  ADC_THRHLR7_tag THRHLR7;             /* Threshold Register */
  ADC_THRHLR8_tag THRHLR8;             /* Threshold Register */
  ADC_THRHLR9_tag THRHLR9;             /* Threshold Register */
  ADC_THRHLR10_tag THRHLR10;           /* Threshold Register */
  ADC_THRHLR11_tag THRHLR11;           /* Threshold Register */
  ADC_THRHLR12_tag THRHLR12;           /* Threshold Register */
  ADC_THRHLR13_tag THRHLR13;           /* Threshold Register */
  ADC_THRHLR14_tag THRHLR14;           /* Threshold Register */
  ADC_THRHLR15_tag THRHLR15;           /* Threshold Register */
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  ADC_CWSELR2_tag CWSELR2;             /* Channel Watchdog Select Register 2 */
  ADC_CWSELR3_tag CWSELR3;             /* Channel Watchdog Select Register 3 */
  ADC_CWSELR4_tag CWSELR4;             /* Channel Watchdog Select Register 4 */
  ADC_CWSELR5_tag CWSELR5;             /* Channel Watchdog Select Register 5 */
  uint8_t ADC_reserved12[24];
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  ADC_CWENR1_tag CWENR1;               /* Channel Watchdog Enable Register 1 */
  uint8_t ADC_reserved13[8];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  ADC_AWORR1_tag AWORR1;               /* Analog Watchdog Out of Range Register 1 */
  uint8_t ADC_reserved14[168];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved15[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t MPL7:1;                  /* Master 7 Privilege Level */
    vuint32_t MTW7:1;                  /* Master 7 Trusted for Writes */
    vuint32_t MTR7:1;                  /* Master 7 Trusted for Read */
    vuint32_t _unused_3:1;
    vuint32_t MPL6:1;                  /* Master 6 Privilege Level */
    vuint32_t MTW6:1;                  /* Master 6 Trusted for Writes */
    vuint32_t MTR6:1;                  /* Master 6 Trusted for Read */
    vuint32_t _unused_7:1;
    vuint32_t MPL5:1;                  /* Master 5 Privilege Level */
    vuint32_t MTW5:1;                  /* Master 5 Trusted For Writes */
    vuint32_t MTR5:1;                  /* Master 5 Trusted For Read */
    vuint32_t _unused_11:1;
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t _unused_15:1;
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t _unused_19:1;
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t _unused_23:1;
    vuint32_t MPL1:1;                  /* Master 1 Privilege Level */
    vuint32_t MTW1:1;                  /* Master 1 Trusted for Writes */
    vuint32_t MTR1:1;                  /* Master 1 Trusted for Read */
    vuint32_t _unused_27:1;
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t _unused_31:1;
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t MPL15:1;                 /* Master 15 Privilege Level */
    vuint32_t MTW15:1;                 /* Master 15 Trusted for Writes */
    vuint32_t MTR15:1;                 /* Master 15 Trusted For Read */
    vuint32_t _unused_3:1;
    vuint32_t MP14:1;                  /* Master 14 Privilege Level */
    vuint32_t MTW14:1;                 /* Master 14 Trusted For Writes */
    vuint32_t MTR14:1;                 /* Master 14 Trusted for Read */
    vuint32_t _unused_7:1;
    vuint32_t MPL13:1;                 /* Master 13 Privilege Level */
    vuint32_t MTW13:1;                 /* Master 13 Trusted for Writes */
    vuint32_t MTR13:1;                 /* Master 13 Trusted for Read */
    vuint32_t _unused_11:1;
    vuint32_t MPL12:1;                 /* Master 12 Privilege Level */
    vuint32_t MTW12:1;                 /* Master 12 Trusted for Writes */
    vuint32_t MTR12:1;                 /* Master 12 Trusted for Read */
    vuint32_t _unused_15:1;
    vuint32_t MPL11:1;                 /* Master 11 Privilege Level */
    vuint32_t MTW11:1;                 /* Master 11 Trusted for Writes */
    vuint32_t MTR11:1;                 /* Master 11 Trusted for Read */
    vuint32_t _unused_19:1;
    vuint32_t MPL10:1;                 /* Master 10 Privilege Level */
    vuint32_t MTW10:1;                 /* Master 10 Trusted for Writes */
    vuint32_t MTR10:1;                 /* Master 10 Trusted for Read */
    vuint32_t _unused_23:1;
    vuint32_t MPL9:1;                  /* Master 9 Privilege Level */
    vuint32_t MTW9:1;                  /* Master 9 Trusted for Writes */
    vuint32_t MTR9:1;                  /* Master 9 Trusted for Read */
    vuint32_t _unused_27:1;
    vuint32_t MPL8:1;                  /* Master 8 Privilege Level */
    vuint32_t MTW8:1;                  /* Master 8 Trusted for Writes */
    vuint32_t MTR8:1;                  /* Master 8 Trusted for Read */
    vuint32_t _unused_31:1;
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t TP7:1;                   /* Trusted Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t _unused_3:1;
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t _unused_7:1;
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t TP7:1;                   /* Trusted Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t _unused_3:1;
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t _unused_7:1;
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;
  } B;
} AIPS_OPACR_tag;

typedef union AIPS_PACRU_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;
  } B;
} AIPS_PACRU_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[24];
  AIPS_PACR_tag PACR[4];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[16];
  AIPS_OPACR_tag OPACR[16];            /* Off-Platform Peripheral Access Control Register */
  AIPS_PACRU_tag PACRU;                /* Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

typedef union AXBS_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_31:1;
  } B;
} AXBS_PORT_PRS_tag;

typedef union AXBS_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t PARK:3;                  /* Park */
    vuint32_t _unused_3:1;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_6:2;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_10:20;
    vuint32_t HLP:1;                   /* Halt Low Priority */
    vuint32_t RO:1;                    /* Read Only */
  } B;
} AXBS_PORT_CRS_tag;

typedef struct AXBS_PORT_struct_tag {
  AXBS_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  AXBS_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} AXBS_PORT_tag;

typedef union AXBS_MGPCR_MGPCR_union_tag { /* Master General Purpose Control Register */
  vuint32_t R;
  struct {
    vuint32_t AULB:3;                  /* Arbitrates On Undefined Length Bursts */
    vuint32_t _unused_3:29;
  } B;
} AXBS_MGPCR_MGPCR_tag;

typedef struct AXBS_MGPCR_struct_tag {
  AXBS_MGPCR_MGPCR_tag MGPCR;          /* Master General Purpose Control Register */
  uint8_t MGPCR_reserved0[252];
} AXBS_MGPCR_tag;

struct AXBS_tag {
  AXBS_PORT_tag PORT[8];
  AXBS_MGPCR_tag MGPCR[8];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t EHV:1;                   /* Enable High Voltage */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t PGM:1;                   /* Program */
    vuint32_t _unused_5:3;
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t _unused_12:1;
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t _unused_16:12;
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t RVE:1;                   /* Read Voltage Error */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t n16Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n64Kl:3;
    vuint32_t n16Km:3;
    vuint32_t n32Km:2;
    vuint32_t n64Km:3;
    vuint32_t n16Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n64Kh:3;
    vuint32_t n256K:5;
    vuint32_t _unused_29:2;
    vuint32_t HT:1;                    /* High Temperature Enabled. */
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t _unused_30:1;
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t _unused_30:2;
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHSEL:16;              /* High Block Select. */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:21;
    vuint32_t a16k:1;
    vuint32_t a32k:1;
    vuint32_t a64k:1;
    vuint32_t a256k:1;
    vuint32_t aL:1;
    vuint32_t aM:1;
    vuint32_t aH:1;
    vuint32_t SAD:1;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t AID:1;
    vuint32_t AIE:1;
    vuint32_t AIS:1;
    vuint32_t _unused_3:1;
    vuint32_t MRV:1;
    vuint32_t MRE:1;
    vuint32_t AISUS:1;
    vuint32_t _unused_7:1;
    vuint32_t AIBPE:1;
    vuint32_t NAIBP:1;
    vuint32_t _unused_10:6;
    vuint32_t CPE:1;
    vuint32_t CPA:1;
    vuint32_t CPR:1;
    vuint32_t _unused_19:11;
    vuint32_t SBCE:1;
    vuint32_t UTE:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:1;                  /* MISR[288]. */
    vuint32_t _unused_1:31;
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t _unused_30:2;
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
    vuint32_t _unused_16:16;
  } B;
} C55FMC_OPP3_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
    vuint32_t _unused_7:1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t _unused_14:1;
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t _unused_22:1;
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t _unused_26:1;
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t MDIS:1;                  /* Module Disable */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PROPSEG:3;               /* Propagation Segment */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t TIMER:16;                /* Timer Value */
    vuint32_t _unused_16:16;
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t IDLE:1;
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t _unused_20:1;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t _unused_22:4;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or Clear FIFO bit */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t _unused_31:1;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:13;
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t _unused_15:1;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_23:9;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
    vuint32_t _unused_15:1;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_23:9;
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
    vuint32_t _unused_9:23;
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t _unused_20:1;
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
  } B;
} CAN_CBT_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t _unused_23:1;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t _unused_28:4;
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t PRIO:3;                  /* Local Priority */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t _unused_10:3;
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t _unused_17:1;
    vuint32_t FANCEI_MSK:1;            /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t HANCEI_MSK:1;            /* Host Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t _unused_20:11;
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t INJADDR:14;              /* Error Injection Address */
    vuint32_t _unused_14:18;
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
    vuint32_t _unused_5:3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_13:3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_21:3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_29:3;
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
    vuint32_t _unused_14:2;
    vuint32_t SAID:3;
    vuint32_t _unused_19:5;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_25:7;
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
    vuint32_t _unused_5:2;
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t _unused_13:2;
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t _unused_21:2;
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t _unused_29:2;
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_4:12;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_20:12;
  } B;
} CAN_ERRSR_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[44];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved3[1024];
  CAN_RXIMR_tag RXIMR[64];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved4[352];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
};


/* ============================================================================
   =============================== Module: CMP ================================
   ============================================================================ */

typedef union CMP_C0_union_tag {       /* CMP Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t HYSTCTR:2;               /* Comparator hard block hysteresis control */
    vuint32_t _unused_2:2;
    vuint32_t FILTER_CNT:3;            /* Filter Sample Count */
    vuint32_t _unused_7:1;
    vuint32_t EN:1;                    /* Comparator Module Enable */
    vuint32_t OPE:1;                   /* Comparator Output Pin Enable */
    vuint32_t COS:1;                   /* Comparator Output Select */
    vuint32_t INVT:1;                  /* Comparator invert */
    vuint32_t PMODE:1;                 /* Power Mode Select */
    vuint32_t _unused_13:1;
    vuint32_t WE:1;                    /* Windowing Enable */
    vuint32_t SE:1;                    /* Sample Enable */
    vuint32_t FPR:8;                   /* Filter Sample Period */
    vuint32_t COUT:1;                  /* Analog Comparator Output */
    vuint32_t CFF:1;                   /* Analog Comparator Flag Falling */
    vuint32_t CFR:1;                   /* Analog Comparator Flag Rising */
    vuint32_t IEF:1;                   /* Comparator Interrupt Enable Falling */
    vuint32_t IER:1;                   /* Comparator Interrupt Enable Rising */
    vuint32_t _unused_29:1;
    vuint32_t DMAEN:1;                 /* DMA Enable */
    vuint32_t _unused_31:1;
  } B;
} CMP_C0_tag;

typedef union CMP_C1_union_tag {       /* CMP Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t VOSEL:6;                 /* DAC Output Voltage Select */
    vuint32_t VRSEL:1;                 /* Supply Voltage Reference Source Select */
    vuint32_t DACEN:1;                 /* DAC Enable */
    vuint32_t MSEL:3;                  /* Minus Input MUX Control */
    vuint32_t PSEL:3;                  /* Plus Input MUX Control */
    vuint32_t DMSEL:1;                 /* DAC output to Minus side ANMUX selection */
    vuint32_t DPSEL:1;                 /* DAC output to Plus side ANMUX selection */
    vuint32_t CHN0:1;                  /* Channel 0 input enable */
    vuint32_t CHN1:1;                  /* Channel 1 input enable */
    vuint32_t CHN2:1;                  /* Channel 2 input enable */
    vuint32_t CHN3:1;                  /* Channel 3 input enable */
    vuint32_t CHN4:1;                  /* Channel 4 input enable */
    vuint32_t CHN5:1;                  /* Channel 5 input enable */
    vuint32_t CHN6:1;                  /* Channel 6 input enable */
    vuint32_t CHN7:1;                  /* Channel 7 input enable */
    vuint32_t _unused_24:7;
    vuint32_t _unused_31:1;
  } B;
} CMP_C1_tag;

typedef union CMP_C2_union_tag {       /* CMP Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t ACOn:8;
    vuint32_t _unused_8:6;
    vuint32_t NSAM:2;                  /* Number of sample clocks */
    vuint32_t CH0F:1;
    vuint32_t CH1F:1;
    vuint32_t CH2F:1;
    vuint32_t CH3F:1;
    vuint32_t CH4F:1;
    vuint32_t CH5F:1;
    vuint32_t CH6F:1;
    vuint32_t CH7F:1;
    vuint32_t _unused_24:1;
    vuint32_t FXMXCH:3;                /* Fixed channel selection */
    vuint32_t FXDACI:1;                /* Fix DAC input to the fixed mux port side */
    vuint32_t FXMP:1;                  /* Fixed MUX Port */
    vuint32_t RRIE:1;                  /* Round-Robin interrupt enable */
    vuint32_t RRE:1;                   /* Round-Robin Enable */
  } B;
} CMP_C2_tag;

struct CMP_tag {
  CMP_C0_tag C0;                       /* CMP Control Register 0 */
  CMP_C1_tag C1;                       /* CMP Control Register 1 */
  CMP_C2_tag C2;                       /* CMP Control Register 2 */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t _unused_3:5;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_10:13;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_24:8;
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t FD:20;                   /* Measured frequency bits. */
    vuint32_t _unused_20:12;
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t HFREF:12;                /* High Frequency reference value. */
    vuint32_t _unused_12:20;
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
    vuint32_t _unused_12:20;
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLCI:1;                  /* CLKMN1 frequency less than reference clock event status. */
    vuint32_t _unused_4:28;
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t MD:20;                   /* Measurement duration bits */
    vuint32_t _unused_20:12;
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_DATA_union_tag {     /* CRC Data register */
  vuint32_t R;
  struct {
    vuint32_t LL:8;                    /* CRC Low Lower Byte */
    vuint32_t LU:8;                    /* CRC Low Upper Byte */
    vuint32_t HL:8;                    /* CRC High Lower Byte */
    vuint32_t HU:8;                    /* CRC High Upper Byte */
  } B;
} CRC_DATA_tag;

typedef union CRC_GPOLY_union_tag {    /* CRC Polynomial register */
  vuint32_t R;
  struct {
    vuint32_t LOW:16;                  /* Low Polynominal Half-word */
    vuint32_t HIGH:16;                 /* High Polynominal Half-word */
  } B;
} CRC_GPOLY_tag;

typedef union CRC_CTRL_union_tag {     /* CRC Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TCRC:1;
    vuint32_t WAS:1;                   /* Write CRC Data Register As Seed */
    vuint32_t FXOR:1;                  /* Complement Read Of CRC Data Register */
    vuint32_t _unused_27:1;
    vuint32_t TOTR:2;                  /* Type Of Transpose For Read */
    vuint32_t TOT:2;                   /* Type Of Transpose For Writes */
  } B;
} CRC_CTRL_tag;

struct CRC_tag {
  CRC_DATA_tag DATA;                   /* CRC Data register */
  CRC_GPOLY_tag GPOLY;                 /* CRC Polynomial register */
  CRC_CTRL_tag CTRL;                   /* CRC Control register */
};


/* ============================================================================
   =============================== Module: CSE ================================
   ============================================================================ */

typedef union CSE_CR_union_tag {       /* CSE Control Register */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;
    vuint32_t DRE:1;
    vuint32_t SUS:1;
    vuint32_t MDIS:1;
    vuint32_t SFE:1;
    vuint32_t KBS:1;
    vuint32_t _unused_6:2;
    vuint32_t DIV:8;
    vuint32_t _unused_16:16;
  } B;
} CSE_CR_tag;

typedef union CSE_SR_union_tag {       /* CSE Status Register */
  vuint32_t R;
  struct {
    vuint32_t BSY:1;
    vuint32_t SB:1;
    vuint32_t BIN:1;
    vuint32_t BFN:1;
    vuint32_t BOK:1;
    vuint32_t RIN:1;
    vuint32_t EDB:1;
    vuint32_t IDB:1;
    vuint32_t EX:1;
    vuint32_t _unused_9:23;
  } B;
} CSE_SR_tag;

typedef union CSE_IR_union_tag {       /* CSE Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t CIF:1;
    vuint32_t _unused_1:31;
  } B;
} CSE_IR_tag;

typedef union CSE_ECR_union_tag {      /* CSE Error Code Register */
  vuint32_t R;
  struct {
    vuint32_t EC:5;
    vuint32_t _unused_5:27;
  } B;
} CSE_ECR_tag;

typedef union CSE_CMD_union_tag {      /* CSE Command Register */
  vuint32_t R;
  struct {
    vuint32_t CMD:5;
    vuint32_t _unused_5:27;
  } B;
} CSE_CMD_tag;

typedef union CSE_P_union_tag {        /* CSE Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t PARM:32;
  } B;
} CSE_P_tag;

struct CSE_tag {
  CSE_CR_tag CR;                       /* CSE Control Register */
  CSE_SR_tag SR;                       /* CSE Status Register */
  CSE_IR_tag IR;                       /* CSE Interrupt Register */
  CSE_ECR_tag ECR;                     /* CSE Error Code Register */
  uint8_t CSE_reserved0[16];
  CSE_CMD_tag CMD;                     /* CSE Command Register */
  CSE_P_tag P[5];                      /* CSE Parameter Register */
};


/* ============================================================================
   =============================== Module: DCU ================================
   ============================================================================ */

typedef union DCU_CTRLDESCCURSOR1_union_tag { /* Control Descriptor Cursor 1 Register */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:11;                /* Width of the cursor in pixels. */
    vuint32_t _unused_11:5;
    vuint32_t HEIGHT:11;               /* Height of the cursor in pixels. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CTRLDESCCURSOR1_tag;

typedef union DCU_CTRLDESCCURSOR2_union_tag { /* Control Descriptor Cursor 2 Register */
  vuint32_t R;
  struct {
    vuint32_t POSX:11;                 /* X position of the cursor in pixels */
    vuint32_t _unused_11:5;
    vuint32_t POSY:11;                 /* Y position of the cursor in pixels */
    vuint32_t _unused_27:5;
  } B;
} DCU_CTRLDESCCURSOR2_tag;

typedef union DCU_CTRLDESCCURSOR3_union_tag { /* Control Descriptor Cursor 3 Register */
  vuint32_t R;
  struct {
    vuint32_t DEFAULT_CURSOR_COLOR:24; /* Default pixel color value for the cursor. In the 2D-ACE, the pixel value for the cursor is fixed for a particular frame. */
    vuint32_t _unused_24:7;
    vuint32_t CUR_EN:1;                /* Cursor Enable signal. */
  } B;
} DCU_CTRLDESCCURSOR3_tag;

typedef union DCU_CTRLDESCCURSOR4_union_tag { /* Control Descriptor Cursor 4 Register */
  vuint32_t R;
  struct {
    vuint32_t HWC_BLINK_ON:8;          /* HWC blink register. Loads the counter value (number of frames) for which the cursor will remain turned ON. */
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:7;
    vuint32_t HWC_BLINK_OFF:8;         /* HWC blink register. Loads the counter value (number of frames) for which the cursor will remain turned OFF. */
    vuint32_t _unused_24:8;
  } B;
} DCU_CTRLDESCCURSOR4_tag;

typedef union DCU_MODE_union_tag {     /* Mode Register */
  vuint32_t R;
  struct {
    vuint32_t DCU_MODE:2;              /* 2D-ACE operating mode. */
    vuint32_t EN_GAMMA:1;              /* Enables/Disables the Gamma Correction. */
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t SIG_EN:1;                /* Enables the signature calculator block. */
    vuint32_t TAG_EN:1;                /* Enables the calculation of CRC only on the safety layers. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:2;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t RASTER_EN:1;             /* Enables raster scanning of pixel data including the VSYNC and HSYNC signals and the pixel data. This bit takes effect immediately and does not require a transfer to the frame timing logic. */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:4;
    vuint32_t BLEND_ITER:3;            /* Defines the maximum number of pixels which are blended in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t ADDR:2;                  /* Two-bit value to be added to pixel red component for dithering. */
    vuint32_t ADDG:2;                  /* Two bit Value to be added with pixel green component for dithering. */
    vuint32_t ADDB:2;                  /* Two-bit value to be added to pixel blue component for dithering. */
    vuint32_t EN_DITHER:1;             /* Enable dithering mode. */
    vuint32_t DCU_SW_RESET:1;
  } B;
} DCU_MODE_tag;

typedef union DCU_BGND_union_tag {     /* Background Register */
  vuint32_t R;
  struct {
    vuint32_t BGND_B:8;                /* Blue component of the default color displayed in the sectors where no layer is active. */
    vuint32_t BGND_G:8;                /* Green component of the default color displayed in the sectors where no layer is active. */
    vuint32_t BGND_R:8;                /* Red component of the default color displayed in the sectors where no layer is active. */
    vuint32_t _unused_24:8;
  } B;
} DCU_BGND_tag;

typedef union DCU_DISP_SIZE_union_tag { /* Display Size Register */
  vuint32_t R;
  struct {
    vuint32_t DELTA_X:7;               /* Sets the display size horizontal resolution (in multiples of 16 pixels) when HUD is disabled. When HUD is enabled, this field provides the width of the image at blending stage of the pipeline on which the warping operation is performed. */
    vuint32_t _unused_7:9;
    vuint32_t DELTA_Y:11;              /* Sets the display size vertical resolution (in pixels) when HUD is disabled. When HUD is enabled, the field provides the height of the image at the blending stage of the pipeline on which the warping operation is performed. */
    vuint32_t _unused_27:5;
  } B;
} DCU_DISP_SIZE_tag;

typedef union DCU_HSYN_PARA_union_tag { /* Horizontal Sync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t FP_H:9;                  /* HSYNC front-porch pulse width (in pixel clock cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_9:2;
    vuint32_t PW_H:9;                  /* HSYNC active pulse width (in pixel clock cycles). */
    vuint32_t _unused_20:2;
    vuint32_t BP_H:9;                  /* HSYNC back-porch pulse width (in pixel clock cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_31:1;
  } B;
} DCU_HSYN_PARA_tag;

typedef union DCU_VSYN_PARA_union_tag { /* Vertical Sync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t FP_V:9;                  /* VSYNC front-porch pulse width (in horizontal line cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_9:2;
    vuint32_t PW_V:9;                  /* VSYNC active pulse width (in horizontal line cycles). */
    vuint32_t _unused_20:2;
    vuint32_t BP_V:9;                  /* VSYNC back-porch pulse width (in horizontal line cycles). Pulse width has a minimum value of 1. */
    vuint32_t _unused_31:1;
  } B;
} DCU_VSYN_PARA_tag;

typedef union DCU_SYNPOL_union_tag {   /* Synchronize Polarity Register */
  vuint32_t R;
  struct {
    vuint32_t INV_HS:1;                /* Invert Horizontal synchronization signal. */
    vuint32_t INV_VS:1;                /* Invert Vertical synchronization signal. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t NEG:1;                   /* Indicates if value at the output (pixel data output) needs to be negated. */
    vuint32_t INV_PXCK:1;              /* Polarity change of Pixel Clock. */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:1;
    vuint32_t INV_DE:1;                /* Invert Data Enable polarity */
    vuint32_t _unused_12:20;
  } B;
} DCU_SYNPOL_tag;

typedef union DCU_THRESHOLD_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t OUT_BUF_LOW:8;           /* Output buffer filling low Threshold (in pixels).This value is used to generate the underrun exception (UNDRUN in INT_STATUS). */
    vuint32_t OUT_BUF_HIGH:8;          /* Output buffer high threshold (in pixels). When the output buffer exceeds this value, the datapath clock is suspended. */
    vuint32_t LS_BF_VS:11;             /* Lines before VS_BLANK threshold value. This field provides the value in terms of number of lines before the VS_BLANK interval starts at which the LS_BF_VS status flag in INT_STATUS register is set. */
    vuint32_t _unused_27:5;
  } B;
} DCU_THRESHOLD_tag;

typedef union DCU_INT_STATUS_union_tag { /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t VSYNC:1;                 /* Interrupt flag to indicate that the vertical synchronization phase has begun. If enabled, an interrupt is generated at the beginning of a frame. */
    vuint32_t UNDRUN:1;                /* Interrupt flag to indicate the output buffer underrun condition. Asserted when the panel needs data and the output buffer level is lower than or equal to the OUT_BUF_LOW threshold. Flag is cleared when the data in the output buffer is greater than threshold and CPU writes 1 to this bit. */
    vuint32_t LS_BF_VS:1;              /* Interrupt flag to indicate the Lines Before VS_BLANK event has been reached. The LS_BF_VS field in the Threshold register defines the timing of the event. */
    vuint32_t VS_BLANK:1;              /* Interrupt signal to indicate vertical blanking period. This is the period in which all the registers that affect the visible state of the layers need to be latched. This is needed so that CPU writes to the register while the display is being updated does not cause any errors. Interrupt can be cleared by writing 1 to this bit.. */
    vuint32_t CRC_READY:1;             /* Interrupt flag to indicate CRC calculation is done and ready to be compared with precomputed CRC value by the software. */
    vuint32_t CRC_OVERFLOW:1;          /* Interrupt signal to indicate that CRC_ready has not been serviced and CRC has been calculated for the next frame */
    vuint32_t P1_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t P1_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t P2_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 2 in the pixel blend stack. */
    vuint32_t P2_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 2 in the pixel blend stack. */
    vuint32_t PROG_END:1;              /* Interrupt flag which indicates that the 2D-ACE has begun to transfer layer configuration from the layer control descriptor registers into the functional block. Any register modification after this time and before LYR_TRANS_FINISH is asserted may or may not be included in this transfer. */
    vuint32_t IPM_ERROR:1;             /* Interrupt flag, which indicates that an error has occured in an AXI bus read transaction. */
    vuint32_t LYR_TRANS_FINISH:1;      /* Interrupt flag to indicate that the transfer is complete of layer configuration from the layer control descriptor registers into the functional block */
    vuint32_t _unused_13:1;
    vuint32_t DMA_TRANS_FINISH:1;      /* Interrupt flag, which indicates that the DMA has fetched the last pixel of data from the memory. */
    vuint32_t _unused_15:1;
    vuint32_t P3_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 3 in the pixel blend stack. */
    vuint32_t P3_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 3 in the pixel blend stack. */
    vuint32_t P4_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 4 in the pixel blend stack. */
    vuint32_t P4_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 4 in the pixel blend stack. */
    vuint32_t P5_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 5 in the pixel blend stack. */
    vuint32_t P5_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 5 in the pixel blend stack. */
    vuint32_t P6_FIFO_LO_FLAG:1;       /* Interrupt flag to indicate that the low threshold has been reached in the FIFO in position 6 in the pixel blend stack. */
    vuint32_t P6_FIFO_HI_FLAG:1;       /* Interrupt flag to indicate that the high threshold has been reached in the FIFO in position 6 in the pixel blend stack. */
    vuint32_t _unused_24:2;
    vuint32_t P1_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 1 (lowest) in the pixel blend stack underflowed. */
    vuint32_t P2_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 2 in the pixel blend stack underflowed. */
    vuint32_t P3_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 3 in the pixel blend stack underflowed. */
    vuint32_t P4_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 4 in the pixel blend stack underflowed. */
    vuint32_t P5_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 5 in the pixel blend stack underflowed. */
    vuint32_t P6_EMPTY:1;              /* Interrupt flag to indicate that the FIFO in position 6 in the pixel blend stack underflowed. */
  } B;
} DCU_INT_STATUS_tag;

typedef union DCU_INT_MASK_union_tag { /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t M_VSYNC:1;               /* Mask for VSYNC interrupt flag. */
    vuint32_t M_UNDRUN:1;              /* Mask for M_UNDRUN interrupt flag. */
    vuint32_t M_LS_BF_VS:1;            /* Mask for LS_BF_VS interrupt flag. */
    vuint32_t M_VS_BLANK:1;            /* Mask for VS_BLANK interrupt flag */
    vuint32_t M_CRC_READY:1;           /* Mask for CRC_READY interrupt flag. */
    vuint32_t M_CRC_OVERFLOW:1;        /* Mask for CRC_OVERFLOW interrupt flag. */
    vuint32_t M_P1_FIFO_LO_FLAG:1;     /* Mask for P1_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P1_FIFO_HI_FLAG:1;     /* Mask for P1_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_P2_FIFO_LO_FLAG:1;     /* Mask for P2_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P2_FIFO_HI_FLAG:1;     /* Mask for P2_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_PROG_END:1;            /* Mask for PROG_END interrupt flag. */
    vuint32_t M_IPM_ERROR:1;           /* Mask for IPM_ERROR interrupt flag. */
    vuint32_t M_LYR_TRANS_FINISH:1;    /* Mask for LYR_TRANS_FINISH interrupt flag. */
    vuint32_t _unused_13:1;
    vuint32_t M_DMA_TRANS_FINISH:1;    /* Mask for DMA_TRANS_FINISH interrupt flag. */
    vuint32_t _unused_15:1;
    vuint32_t M_P3_FIFO_LO_FLAG:1;     /* Mask for P3_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P3_FIFO_HI_FLAG:1;     /* Mask for P3_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_P4_FIFO_LO_FLAG:1;     /* Mask for P4_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P4_FIFO_HI_FLAG:1;     /* Mask for P4_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_P5_FIFO_LO_FLAG:1;     /* Mask for P5_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P5_FIFO_HI_FLAG:1;     /* Mask for P5_FIFO_HI_FLAG interrupt flag. */
    vuint32_t M_P6_FIFO_LO_FLAG:1;     /* Mask for P6_FIFO_LO_FLAG interrupt flag. */
    vuint32_t M_P6_FIFO_HI_FLAG:1;     /* Mask for P6_FIFO_HI_FLAG interrupt flag. */
    vuint32_t _unused_24:2;
    vuint32_t M_P1_EMPTY:1;            /* Mask for P1_EMPTY interrupt flag. */
    vuint32_t M_P2_EMPTY:1;            /* Mask for P2_EMPTY interrupt flag. */
    vuint32_t M_P3_EMPTY:1;            /* Mask for P3_EMPTY interrupt flag. */
    vuint32_t M_P4_EMPTY:1;            /* Mask for P4_EMPTY interrupt flag. */
    vuint32_t M_P5_EMPTY:1;            /* Mask for P5_EMPTY interrupt flag. */
    vuint32_t M_P6_EMPTY:1;            /* Mask for P6_EMPTY interrupt flag. */
  } B;
} DCU_INT_MASK_tag;

typedef union DCU_COLBAR_1_union_tag { /* COLBAR_1 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_1_tag;

typedef union DCU_COLBAR_2_union_tag { /* COLBAR_2 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_2_tag;

typedef union DCU_COLBAR_3_union_tag { /* COLBAR_3 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_3_tag;

typedef union DCU_COLBAR_4_union_tag { /* COLBAR_4 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_4_tag;

typedef union DCU_COLBAR_5_union_tag { /* COLBAR_5 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_5_tag;

typedef union DCU_COLBAR_6_union_tag { /* COLBAR_6 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_6_tag;

typedef union DCU_COLBAR_7_union_tag { /* COLBAR_7 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_7_tag;

typedef union DCU_COLBAR_8_union_tag { /* COLBAR_8 Register */
  vuint32_t R;
  struct {
    vuint32_t COLBAR_B:8;              /* Blue component value. */
    vuint32_t COLBAR_G:8;              /* Green component value. */
    vuint32_t COLBAR_R:8;              /* Red component value. */
    vuint32_t _unused_24:8;
  } B;
} DCU_COLBAR_8_tag;

typedef union DCU_DIV_RATIO_union_tag { /* Divide Ratio Register */
  vuint32_t R;
  struct {
    vuint32_t DIV_RATIO:8;             /* Specifies the divide value for the input clock. Used to generate the pixel clock to support different types of displays. To divide by N, set the DIV_RATIO to (N - 1). */
    vuint32_t _unused_8:24;
  } B;
} DCU_DIV_RATIO_tag;

typedef union DCU_SIGN_CALC_1_union_tag { /* Sign Calculation 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SIG_HOR_SIZE:11;         /* Horizontal size of window of interest of pixels for CRC calculations (in pixels). */
    vuint32_t _unused_11:5;
    vuint32_t SIG_VER_SIZE:11;         /* Vertical size of the window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_27:5;
  } B;
} DCU_SIGN_CALC_1_tag;

typedef union DCU_SIGN_CALC_2_union_tag { /* Sign Calculation 2 Register */
  vuint32_t R;
  struct {
    vuint32_t SIG_HOR_POS:11;          /* Horizontal position of window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_11:5;
    vuint32_t SIG_VER_POS:11;          /* Vertical position of the window of interest of pixels for CRC calculation (in pixels). */
    vuint32_t _unused_27:5;
  } B;
} DCU_SIGN_CALC_2_tag;

typedef union DCU_CRC_VAL_union_tag {  /* CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CRC_VAL:32;              /* The result of the CRC calculation for the value of the pixels on the safety layers */
  } B;
} DCU_CRC_VAL_tag;

typedef union DCU_PARR_ERR_STATUS1_union_tag { /* Parameter Error Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t L31_0:32;                /* A value of 1 indicates that a parameter error exists for the corresponding layer */
  } B;
} DCU_PARR_ERR_STATUS1_tag;

typedef union DCU_PARR_ERR_STATUS3_union_tag { /* Parameter Error Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t DISP_ERR:1;              /* Interrupt occurs whenever width and height of display, pulse width (both vertical and horizontal sync) value is 0. */
    vuint32_t SIG_ERR:1;               /* Interrupt occurs whenever the area of interest specified by SIG_CALC register is outside the display size. */
    vuint32_t HWC_ERR:1;               /* Interrupt signal to indicate HWC error. This can occur if HWC position is out of display area or cursor memory is bigger than the HWC size. When this occurs, the HWC is disabled. */
    vuint32_t RLE_ERR:1;               /* Error signal to indicate that more than 4 layers have RLE_EN bit field set in the CTRLDESCLn_4 register. */
    vuint32_t _unused_4:28;
  } B;
} DCU_PARR_ERR_STATUS3_tag;

typedef union DCU_MASK_PARR_ERR_STATUS1_union_tag { /* Mask Parameter Error Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ML31_0:32;               /* Mask for L[31:0] interrupt flag. */
  } B;
} DCU_MASK_PARR_ERR_STATUS1_tag;

typedef union DCU_MASK_PARR_ERR_STATUS3_union_tag { /* Mask Parameter Error Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t M_DISP_ERR:1;            /* Mask for DISP_ERR interrupt flag. */
    vuint32_t M_SIG_ERR:1;             /* Mask for SIG_ERR interrupt flag. */
    vuint32_t M_HWC_ERR:1;             /* Mask for HWC_ERR interrupt flag. */
    vuint32_t M_RLE_ERR:1;             /* Mask for RLE_ERR interrupt flag. */
    vuint32_t _unused_4:28;
  } B;
} DCU_MASK_PARR_ERR_STATUS3_tag;

typedef union DCU_THRESHOLD_INP_BUF_1_union_tag { /* Threshold Input 1 Register */
  vuint32_t R;
  struct {
    vuint32_t INP_BUF_P1_LO:7;         /* Low threshold for the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t _unused_7:1;
    vuint32_t INP_BUF_P1_HI:7;         /* High threshold for the FIFO in position 1 (lowest) in the pixel blend stack. */
    vuint32_t _unused_15:1;
    vuint32_t INP_BUF_P2_LO:7;         /* Low threshold for the FIFO in position 2 in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t INP_BUF_P2_HI:7;         /* High threshold for the FIFO in position 2 in the pixel blend stack. */
    vuint32_t _unused_31:1;
  } B;
} DCU_THRESHOLD_INP_BUF_1_tag;

typedef union DCU_THRESHOLD_INP_BUF_2_union_tag { /* Threshold Input 2 Register */
  vuint32_t R;
  struct {
    vuint32_t INP_BUF_P3_LO:7;         /* Low threshold for the FIFO in position 3 in the pixel blend stack. */
    vuint32_t _unused_7:1;
    vuint32_t INP_BUF_P3_HI:7;         /* High threshold for the FIFO in position 3 in the pixel blend stack. */
    vuint32_t _unused_15:1;
    vuint32_t INP_BUF_P4_LO:7;         /* Low threshold for the FIFO in position 4 in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t INP_BUF_P4_HI:7;         /* High threshold for the FIFO in position 4 in the pixel blend stack. */
    vuint32_t _unused_31:1;
  } B;
} DCU_THRESHOLD_INP_BUF_2_tag;

typedef union DCU_THRESHOLD_INP_BUF_3_union_tag { /* Threshold Input 3 Register */
  vuint32_t R;
  struct {
    vuint32_t INP_BUF_P5_LO:7;         /* Low threshold for the FIFO in position 5 in the pixel blend stack. */
    vuint32_t _unused_7:1;
    vuint32_t INP_BUF_P5_HI:7;         /* High threshold for the FIFO in position 5 in the pixel blend stack. */
    vuint32_t _unused_15:1;
    vuint32_t INP_BUF_P6_LO:7;         /* Low threshold for the FIFO in position 6 in the pixel blend stack. */
    vuint32_t _unused_23:1;
    vuint32_t INP_BUF_P6_HI:7;         /* High threshold for the FIFO in position 6 in the pixel blend stack. */
    vuint32_t _unused_31:1;
  } B;
} DCU_THRESHOLD_INP_BUF_3_tag;

typedef union DCU_LUMA_COMP_union_tag { /* LUMA Component Register */
  vuint32_t R;
  struct {
    vuint32_t Y_BLUE:10;               /* Luminance coefficient for blue component. */
    vuint32_t _unused_10:1;
    vuint32_t Y_GREEN:10;              /* Luminance coefficient for green component. */
    vuint32_t _unused_21:1;
    vuint32_t Y_RED:10;                /* Luminance coefficient for red component. */
  } B;
} DCU_LUMA_COMP_tag;

typedef union DCU_CHROMA_RED_union_tag { /* Red Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_RED:12;               /* Cb coefficient for calculation of red component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_RED:11;               /* Cr coefficient for calculation of red component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_RED_tag;

typedef union DCU_CHROMA_GREEN_union_tag { /* Green Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_GREEN:12;             /* Cb coefficient for calculation of green component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_GREEN:11;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_GREEN_tag;

typedef union DCU_CHROMA_BLUE_union_tag { /* Blue Chroma Components Register */
  vuint32_t R;
  struct {
    vuint32_t CB_BLUE:12;              /* Cb coefficient for calculation of blue component. */
    vuint32_t _unused_12:4;
    vuint32_t CR_BLUE:11;              /* Cr coefficient for calculation of blue component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_CHROMA_BLUE_tag;

typedef union DCU_CRC_POS_union_tag {  /* CRC Position Register */
  vuint32_t R;
  struct {
    vuint32_t CRC_POS:32;              /* The result of the CRC calculation for the position of the pixels on the safety layers. */
  } B;
} DCU_CRC_POS_tag;

typedef union DCU_LYR_INTPOL_EN_union_tag { /* Layer Interpolation Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t EN:1;                    /* Interpolation Enable bit for DCU3 Layer coded in YCbCr422 format. */
  } B;
} DCU_LYR_INTPOL_EN_tag;

typedef union DCU_LYR_LUMA_COMP_union_tag { /* Layer Luminance Component Register */
  vuint32_t R;
  struct {
    vuint32_t Y_BLUE:10;               /* Luminance coefficient for blue component. */
    vuint32_t _unused_10:1;
    vuint32_t Y_GREEN:10;              /* Luminance coefficient for green component. */
    vuint32_t _unused_21:1;
    vuint32_t Y_RED:10;                /* Luminance coefficient for red component. */
  } B;
} DCU_LYR_LUMA_COMP_tag;

typedef union DCU_LYR_CHRM_RED_union_tag { /* Layer Chroma Red Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_RED:12;               /* Cb coefficient for calculation of red component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_RED:11;               /* Cr coefficient for calculation of red component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_RED_tag;

typedef union DCU_LYR_CHRM_GRN_union_tag { /* Layer Chroma Green Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_GREEN:12;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_GREEN:11;             /* Cr coefficient for calculation of green component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_GRN_tag;

typedef union DCU_LYR_CHRM_BLUE_union_tag { /* Layer Chroma Blue Register */
  vuint32_t R;
  struct {
    vuint32_t Cb_BLUE:12;              /* Cb coefficient for calculation of blue component. */
    vuint32_t _unused_12:4;
    vuint32_t Cr_BLUE:11;              /* Cr coefficient for calculation of blue component. */
    vuint32_t _unused_27:5;
  } B;
} DCU_LYR_CHRM_BLUE_tag;

typedef union DCU_UPDATE_MODE_union_tag { /* Update Mode Register */
  vuint32_t R;
  struct {
    vuint32_t TRIG_PROG_END:8;
    vuint32_t _unused_8:22;
    vuint32_t READREG:1;               /* When the MODE bit is clear this bit is a control bit which can be written to initiate a transfer of register value during the next vertical blanking period. */
    vuint32_t MODE:1;                  /* Do not set the MODE bit while the READREG is also set as this will block automatic updates. Do not set the MODE bit and the READREG register in the same write operation. */
  } B;
} DCU_UPDATE_MODE_tag;

typedef union DCU_UNDERRUN_union_tag { /* Underrun Register */
  vuint32_t R;
  struct {
    vuint32_t PIXEL:11;                /* Pixel number where the under run occured. */
    vuint32_t _unused_11:5;
    vuint32_t LINE:11;                 /* Line number where the underrun occured. */
    vuint32_t _unused_27:5;
  } B;
} DCU_UNDERRUN_tag;

typedef union DCU_WRITEBACK_ADDR_union_tag { /* Write back address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t WB_ADDR:29;
  } B;
} DCU_WRITEBACK_ADDR_tag;

typedef union DCU_WRITEBACK_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MODE:2;
    vuint32_t TYPE:1;
    vuint32_t _unused_3:13;
    vuint32_t WALPHA:8;
    vuint32_t _unused_24:8;
  } B;
} DCU_WRITEBACK_CTRL_tag;

typedef union DCU_WRITEBACK_STAT_union_tag { /* Writeback status */
  vuint32_t R;
  struct {
    vuint32_t WERROR:1;
    vuint32_t WDONE:1;
    vuint32_t _unused_2:1;
    vuint32_t WUNDERRUN:1;
    vuint32_t _unused_4:28;
  } B;
} DCU_WRITEBACK_STAT_tag;

typedef union DCU_GPR_union_tag {      /* Global Protection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t HLB:1;                   /* Hard Lock Bit. This bit cannot be cleared once it is set by software. It can only be cleared by a system reset. */
  } B;
} DCU_GPR_tag;

typedef union DCU_SLR_L0_union_tag {   /* Soft Lock Bit Layer 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t SLB_L0_11:1;             /* Soft Lock Bit for Control Desc L0_11 Register. */
    vuint32_t _unused_12:3;
    vuint32_t WEN_L0_11:1;             /* Write Enable for Soft Lock Bit SLB_L0_11. */
    vuint32_t SLB_L0_10:1;             /* Soft Lock Bit for Control Desc L0_10 Register. */
    vuint32_t SLB_L0_7:1;              /* Soft Lock Bit for Control Desc L0_7 Register. */
    vuint32_t SLB_L0_6:1;              /* Soft Lock Bit for Control Desc L0_6 Register. */
    vuint32_t SLB_L0_5:1;              /* Soft Lock Bit for Control Desc L0_5 Register. */
    vuint32_t WEN_L0_10:1;             /* Write Enable for Soft Lock Bit SLB_L0_10. */
    vuint32_t WEN_LO_7:1;              /* Write Enable for Soft Lock Bit SLB_L0_7. */
    vuint32_t WEN_LO_6:1;              /* Write Enable for Soft Lock Bit SLB_L0_6. */
    vuint32_t WEN_LO_5:1;              /* Write Enable for Soft Lock Bit SLB_L0_5. */
    vuint32_t SLB_L0_4:1;              /* Soft Lock Bit for Control Desc L0_4 Register. */
    vuint32_t SLB_L0_3:1;              /* Soft Lock Bit for Control Desc L0_3 Register. */
    vuint32_t SLB_L0_2:1;              /* Soft Lock Bit for Control Desc L0_2 Register. */
    vuint32_t SLB_L0_1:1;              /* Soft Lock Bit for Control Desc L0_1 Register. */
    vuint32_t WEN_LO_4:1;              /* Write Enable for Soft Lock Bit SLB_L0_4. */
    vuint32_t WEN_LO_3:1;              /* Write Enable for Soft Lock Bit SLB_L0_3. */
    vuint32_t WEN_LO_2:1;              /* Write Enable for Soft Lock Bit SLB_L0_2. */
    vuint32_t WEN_LO_1:1;              /* Write Enable for Soft Lock Bit SLB_L0_1. */
  } B;
} DCU_SLR_L0_tag;

typedef union DCU_SLR_L1_union_tag {   /* Soft Lock Bit Layer 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;
    vuint32_t SLB_L1_11:1;             /* Soft Lock Bit for Control Desc L1_11 Register. */
    vuint32_t _unused_12:3;
    vuint32_t WEN_L1_11:1;             /* Write Enable for Soft Lock Bit SLB_L1_11. */
    vuint32_t SLB_L1_10:1;             /* Soft Lock Bit for Control Desc L1_10 Register. */
    vuint32_t SLB_L1_7:1;              /* Soft Lock Bit for Control Desc L1_7 Register. */
    vuint32_t SLB_L1_6:1;              /* Soft Lock Bit for Control Desc L1_6 Register. */
    vuint32_t SLB_L1_5:1;              /* Soft Lock Bit for Control Desc L1_5 Register. */
    vuint32_t WEN_L1_10:1;             /* Write Enable for Soft Lock Bit SLB_L1_10. */
    vuint32_t WEN_L1_7:1;              /* Write Enable for Soft Lock Bit SLB_L1_7. */
    vuint32_t WEN_L1_6:1;              /* Write Enable for Soft Lock Bit SLB_L1_6. */
    vuint32_t WEN_L1_5:1;              /* Write Enable for Soft Lock Bit SLB_L1_5. */
    vuint32_t SLB_L1_4:1;              /* Soft Lock Bit for Control Desc L1_4 Register. */
    vuint32_t SLB_L1_3:1;              /* Soft Lock Bit for Control Desc L1_3 Register. */
    vuint32_t SLB_L1_2:1;              /* Soft Lock Bit for Control Desc L1_2 Register. */
    vuint32_t SLB_L1_1:1;              /* Soft Lock Bit for Control Desc L1_1 Register. */
    vuint32_t WEN_L1_4:1;              /* Write Enable for Soft Lock Bit SLB_L1_4. */
    vuint32_t WEN_L1_3:1;              /* Write Enable for Soft Lock Bit SLB_L1_3. */
    vuint32_t WEN_L1_2:1;              /* Write Enable for Soft Lock Bit SLB_L1_2. */
    vuint32_t WEN_L1_1:1;              /* Write Enable for Soft Lock Bit SLB_L1_1. */
  } B;
} DCU_SLR_L1_tag;

typedef union DCU_SLR_DISP_SIZE_union_tag { /* Soft Lock Display Size Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t SLB_DISP:1;              /* Soft Lock Bit for DISP_SIZE Register. This bit cannot be cleared once set by software. Can only be cleared by system reset. */
    vuint32_t _unused_28:3;
    vuint32_t WEN_DISP:1;              /* Write Enable for Soft Lock Bit SLB_DISP. */
  } B;
} DCU_SLR_DISP_SIZE_tag;

typedef union DCU_SLR_HVSYNC_PARA_union_tag { /* Soft Lock Hsync/Vsync Parameter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_VSYNC:1;             /* Soft Lock Bit for VSYNC Register. */
    vuint32_t SLB_HSYNC:1;             /* Soft Lock Bit for HSYNC Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_VSYNC:1;             /* Write Enable for Soft Lock Bit SLB_VSYNC */
    vuint32_t WEN_HSYNC:1;             /* Write Enable for Soft Lock Bit SLB_HSYNC. */
  } B;
} DCU_SLR_HVSYNC_PARA_tag;

typedef union DCU_SLR_POL_union_tag {  /* Soft Lock POL Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t SLB_POL:1;               /* Soft Lock Bit for SYN_POL Register. */
    vuint32_t _unused_28:3;
    vuint32_t WEN_POL:1;               /* Write Enable for Soft Lock Bit SLB_POL */
  } B;
} DCU_SLR_POL_tag;

typedef union DCU_SLR_L0_TRANSP_union_tag { /* Soft Lock L0 Transparency Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_L0_BCOLOR:1;         /* Soft Lock Bit for L0_BCOLOR Register. */
    vuint32_t SLB_L0_FCOLOR:1;         /* Soft Lock Bit for L0_FCOLOR Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_L0_BCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L0_BCOLOR */
    vuint32_t WEN_L0_FCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L0_FCOLOR */
  } B;
} DCU_SLR_L0_TRANSP_tag;

typedef union DCU_SLR_L1_TRANSP_union_tag { /* Soft Lock L1 Transparency Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_L1_BCOLOR:1;         /* Soft Lock Bit for L1_BCOLOR Register. */
    vuint32_t SLB_L1_FCOLOR:1;         /* Soft Lock Bit for L1_FCOLOR Register. */
    vuint32_t _unused_28:2;
    vuint32_t WEN_L1_BCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L1_BCOLOR */
    vuint32_t WEN_L1_FCOLOR:1;         /* Write Enable for Soft Lock Bit SLB_L1_FCOLOR */
  } B;
} DCU_SLR_L1_TRANSP_tag;

typedef union DCU_SLR_HUD_union_tag {  /* Soft Lock HUD Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:26;
    vuint32_t SLB_HUD_HEIGHT:1;        /* SLB_HUD_HEIGHT */
    vuint32_t SLB_HUD_WIDTH:1;         /* SLB_HUD_WIDTH */
    vuint32_t _unused_28:2;
    vuint32_t WEN_HUD_HEIGHT:1;        /* WEN_HUD_HEIGHT */
    vuint32_t WEN_HUD_WIDTH:1;         /* WEN_HUD_WIDTH */
  } B;
} DCU_SLR_HUD_tag;

typedef union DCU_R_CTRLDESCL_1_union_tag { /* Control Descriptor Layer 1 Register */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:11;                /* Width of the layer (in pixels). */
    vuint32_t _unused_11:5;
    vuint32_t HEIGHT:11;               /* Height of the layer in pixels. */
    vuint32_t _unused_27:5;
  } B;
} DCU_R_CTRLDESCL_1_tag;

typedef union DCU_R_CTRLDESCL_2_union_tag { /* Control Descriptor Layer 2 Register */
  vuint32_t R;
  struct {
    vuint32_t POSX:12;                 /* Two's complement signed value setting the horizontal position of left hand column of the layer, where 0 is the left-hand column of the panel. Positive values are to the right and negative values are to the left the left-hand column of the panel. */
    vuint32_t _unused_12:4;
    vuint32_t POSY:12;                 /* Two's complement signed value setting the vertical position of top row of the layer, where 0 is the top row of the panel. Positive values are below and negative values are above the top row of the panel. */
    vuint32_t _unused_28:4;
  } B;
} DCU_R_CTRLDESCL_2_tag;

typedef union DCU_R_CTRLDESCL_3_union_tag { /* Control Descriptor Layer 3 Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;                 /* Address of layer data in the memory. The address programmed should be 64-bit aligned. */
  } B;
} DCU_R_CTRLDESCL_3_tag;

typedef union DCU_R_CTRLDESCL_4_union_tag { /* Control Descriptor Layer 4 Register */
  vuint32_t R;
  struct {
    vuint32_t AB:2;                    /* Alpha Blending. */
    vuint32_t BB:1;                    /* Chroma Keying. */
    vuint32_t GRLE_SEL:1;              /* Select gradient RLE decoding scheme */
    vuint32_t LUOFFS:11;               /* Look Up Table offset. */
    vuint32_t RLE_EN:1;                /* Enable RLE mode for layer. */
    vuint32_t BPP:4;                   /* Layer encoding format (bit per pixel) */
    vuint32_t TRANS:8;                 /* Transparency Level. Specifies the alpha value for the layer. This value may be used by the blending engine to blend pixels on this layer. Value can vary between 0-255 where 0 is completely transparent and 255 is completely opaque. */
    vuint32_t SAFETY_EN:1;             /* Safety Mode Enable Bit. Valid only for layer 0 and layer 1. For registers of all other layers, this should be set to 0. */
    vuint32_t DATA_SEL:1;              /* Selects the Tile data either from chip memory or CLUT. */
    vuint32_t TILE_EN:1;               /* Enable the Tile Mode. Cannot be used when POSY is a negative value. */
    vuint32_t EN:1;                    /* Enable the layer. */
  } B;
} DCU_R_CTRLDESCL_4_tag;

typedef union DCU_R_CTRLDESCL_5_union_tag { /* Control Descriptor Layer 5 Register */
  vuint32_t R;
  struct {
    vuint32_t CKMAX_B:8;               /* Chroma Keying Max Blue Component. */
    vuint32_t CKMAX_G:8;               /* Chroma Keying Max Green Component */
    vuint32_t CKMAX_R:8;               /* Chroma Keying Max Red Component. */
    vuint32_t _unused_24:8;
  } B;
} DCU_R_CTRLDESCL_5_tag;

typedef union DCU_R_CTRLDESCL_6_union_tag { /* Control Descriptor Layer 6 Register */
  vuint32_t R;
  struct {
    vuint32_t CKMIN_B:8;               /* Chroma Keying Minimum Blue Component. */
    vuint32_t CKMIN_G:8;               /* Chroma Keying Minimum Green Component. */
    vuint32_t CKMIN_R:8;               /* Chroma Keying Minimum Red Component */
    vuint32_t _unused_24:8;
  } B;
} DCU_R_CTRLDESCL_6_tag;

typedef union DCU_R_CTRLDESCL_7_union_tag { /* Control Descriptor Layer 7 Register */
  vuint32_t R;
  struct {
    vuint32_t TILE_HOR_SIZE:7;         /* Width of the TILE (in multiples of 16 pixels). */
    vuint32_t _unused_7:9;
    vuint32_t TILE_VER_SIZE:11;        /* Height of the TILE (in pixels). */
    vuint32_t _unused_27:5;
  } B;
} DCU_R_CTRLDESCL_7_tag;

typedef union DCU_R_CTRLDESCL_8_union_tag { /* Control Descriptor Layer 8 Register */
  vuint32_t R;
  struct {
    vuint32_t FGn_FCOLOR:24;           /* Foreground color to use when the layer is configured to use a transparency mode. */
    vuint32_t _unused_24:8;
  } B;
} DCU_R_CTRLDESCL_8_tag;

typedef union DCU_R_CTRLDESCL_9_union_tag { /* Control Descriptor Layer 9 Register */
  vuint32_t R;
  struct {
    vuint32_t FGn_BCOLOR:24;           /* Background color to use when the layer is configured to use a transparency mode */
    vuint32_t _unused_24:8;
  } B;
} DCU_R_CTRLDESCL_9_tag;

typedef union DCU_R_CTRLDESCL_10_union_tag { /* Control Descriptor Layer 10 Register */
  vuint32_t R;
  struct {
    vuint32_t PRE_SKIP:11;             /* This field indicates the number of pixels to be skipped from the start at each line of the rectangular layer. The number of pixels specified by the PRE_SKIP field do not take part in arbitration and blending stage. PRE_SKIP field along with POST_SKIP field provides a visual in which layer appears to be horizontally cropped. This value in this field is treated as unsigned. */
    vuint32_t _unused_11:5;
    vuint32_t POST_SKIP:11;            /* This field indicates the number of pixels to be skipped before the end of each line of the rectangular layer. The number of pixels specified by the POST_SKIP field do not take part in arbitration and blending stage. POST_SKIP field along with PRE_SKIP field provides a visual in which layer appears to be horizontally cropped. The value in this field is treated as unsigned. */
    vuint32_t _unused_27:4;
    vuint32_t _unused_31:1;
  } B;
} DCU_R_CTRLDESCL_10_tag;

typedef union DCU_R_CTRLDESCL_11_union_tag { /* Control Descriptor Layer 11 Register */
  vuint32_t R;
  struct {
    vuint32_t COMP_IM_SZ:32;           /* If RLE_EN bit in CTRLDESCL4_n register is set to 1, then this field provides the size of RLE encoded image in bytes. If the RLE_EN bit is set 0, then contents of this field is ignored. */
  } B;
} DCU_R_CTRLDESCL_11_tag;

typedef struct DCU_R_struct_tag {
  DCU_R_CTRLDESCL_1_tag CTRLDESCL_1;   /* Control Descriptor Layer 1 Register */
  DCU_R_CTRLDESCL_2_tag CTRLDESCL_2;   /* Control Descriptor Layer 2 Register */
  DCU_R_CTRLDESCL_3_tag CTRLDESCL_3;   /* Control Descriptor Layer 3 Register */
  DCU_R_CTRLDESCL_4_tag CTRLDESCL_4;   /* Control Descriptor Layer 4 Register */
  DCU_R_CTRLDESCL_5_tag CTRLDESCL_5;   /* Control Descriptor Layer 5 Register */
  DCU_R_CTRLDESCL_6_tag CTRLDESCL_6;   /* Control Descriptor Layer 6 Register */
  DCU_R_CTRLDESCL_7_tag CTRLDESCL_7;   /* Control Descriptor Layer 7 Register */
  DCU_R_CTRLDESCL_8_tag CTRLDESCL_8;   /* Control Descriptor Layer 8 Register */
  DCU_R_CTRLDESCL_9_tag CTRLDESCL_9;   /* Control Descriptor Layer 9 Register */
  DCU_R_CTRLDESCL_10_tag CTRLDESCL_10; /* Control Descriptor Layer 10 Register */
  DCU_R_CTRLDESCL_11_tag CTRLDESCL_11; /* Control Descriptor Layer 11 Register */
  uint8_t R_reserved0[20];
} DCU_R_tag;

typedef union DCU_HUD_WIDTH_union_tag { /* Hud width */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:11;                /* When HUD is enabled this field indicates the width of the display. When HUD is disabled: display width is indicated by DELTA_X field of the DISP_SIZE register */
    vuint32_t _unused_11:21;
  } B;
} DCU_HUD_WIDTH_tag;

typedef union DCU_HUD_HEIGHT_union_tag { /* Hud height */
  vuint32_t R;
  struct {
    vuint32_t HEIGHT:11;               /* When HUD is enabled this field indicates the height of the display. When HUD is disabled then height of the display is indicated by DELTA_Y field of the DISP_SIZE register. */
    vuint32_t _unused_11:21;
  } B;
} DCU_HUD_HEIGHT_tag;

typedef union DCU_WARP_DESC_ADDR_union_tag { /* Warping Descriptor base address */
  vuint32_t R;
  struct {
    vuint32_t LDESC_ADDR:32;           /* This field provides of the base address of the line descriptor table for the warping operation.The address programmed should be 64-bit aligned */
  } B;
} DCU_WARP_DESC_ADDR_tag;

typedef union DCU_WARP_IRQ_CTRL_union_tag { /* Warping interrupt configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t M_X_OVERFLOW:1;          /* Masks horizontal pixel position overflow interrupt of the warping operation. Pixel position overflow occurs in horizontal direction (X) when the source pixel number at the input of bilinear-interpolation function is greater than DELTA_X field of DISP_SIZE register or less than zero. */
    vuint32_t M_Y_OVERFLOW:1;          /* Masks vertical pixel position overflow interrupt of the warping operation. Pixel position overflow occurs in vertical direction (Y) when the source pixel line number is beyond the indices of the lines in the HUD line buffer. */
    vuint32_t _unused_3:12;
    vuint32_t M_LD_DN:1;               /* Masks Line Descriptor table fetch complete interrupt. */
    vuint32_t _unused_16:16;
  } B;
} DCU_WARP_IRQ_CTRL_tag;

typedef union DCU_WARP_IRQ_STAT_union_tag { /* Warp interrupt status */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t X_OVERFLOW:1;            /* 1'b1: Indicates that horizontal pixel position overflow occurred. 1'b0: Indicates that no horizontal pixel position overflow occurred. Pixel position overflow occurs in horizontal direction (X) when the source pixel number at the input of bilinear-interpolation function is greater than DISP_SIZE[DELTA_X] field or less than zero. */
    vuint32_t Y_OVERFLOW:1;            /* 1'b1: Indicates that vertical pixel position overflow occurred. 1'b0: Indicates that no vertical pixel position overflow occurred. Pixel position overflow occurs in vertical direction (Y) when the source pixel line number is beyond the indices of the lines in the HUD line buffer. */
    vuint32_t _unused_3:12;
    vuint32_t LD_DONE:1;               /* 1'b1: Indicates that line descriptor table fetch completed. 1'b0: Indicates that line descriptor fetch has not yet completed. */
    vuint32_t _unused_16:16;
  } B;
} DCU_WARP_IRQ_STAT_tag;

typedef union DCU_WARP_CTRL_union_tag { /* Warping control */
  vuint32_t R;
  struct {
    vuint32_t HUD_EN:1;                /* When this bit is 1, HUD is enabled else HUD is disabled. */
    vuint32_t AXI_XFRS:3;              /* This field describes the AXI Read transaction transfer size for the fetching line descriptor table. The line descriptor table is fetched in chunks of bytes, where the number of bytes in a single chunk is determined by AXI_XRFS field. Relationship between AXI_XFRS and number of bytes in a single AXI read transaction is given by (AXI_XFRS+1)*8. Each AXI burst transaction is performed as per AXI_XFRS. When the line descriptor table size of not a multiple of number of bytes determined AXI_XFRS then the very last AXI burst is adjusted accordingly. */
    vuint32_t _unused_4:12;
    vuint32_t LINES_IN_LB:6;           /* Indicates the number of blended image lines that can be held in line buffer memory. The line buffer interpolation and buffer management configures itself for their corresponding operation as per the value in this field. The LINES_IN_LB value can be up to 32, this means that distortion can take place over 32 lines. However the user must ensure that the horizontal pixel length is such that the desired number of lines can fit in the line buffer. */
    vuint32_t _unused_22:10;
  } B;
} DCU_WARP_CTRL_tag;

typedef union DCU_WARP_XOVR_STAT_union_tag { /* Warping X overflow status */
  vuint32_t R;
  struct {
    vuint32_t LINE_NUM:12;             /* When X_OVERFLOW occurs, this field indicates the line number (or the line descriptor) for which the overflow occurred. */
    vuint32_t _unused_12:4;
    vuint32_t PIXEL_NUM:12;            /* When X_OVERFLOW occurs, this field indicates the pixel number for which the overflow occurred */
    vuint32_t _unused_28:4;
  } B;
} DCU_WARP_XOVR_STAT_tag;

typedef union DCU_WARP_YOVR_STAT_union_tag { /* Warping Y overflow status */
  vuint32_t R;
  struct {
    vuint32_t LINE_NUM:12;             /* When Y_OVERFLOW occurs, LINE NUM indicates the line number (or the line descriptor) for which the overflow occurred */
    vuint32_t _unused_12:4;
    vuint32_t PIXEL_NUM:12;            /* When Y_OVERFLOW occurs, this field indicates the pixel number for which the overflow occurred */
    vuint32_t _unused_28:4;
  } B;
} DCU_WARP_YOVR_STAT_tag;

typedef union DCU_WARP_DESC_TB_SZ_union_tag { /* Warping line descriptor table size */
  vuint32_t R;
  struct {
    vuint32_t TB_SIZE:32;              /* This field indicates the size of Line Descriptor table in bytes. */
  } B;
} DCU_WARP_DESC_TB_SZ_tag;

struct DCU_tag {
  DCU_CTRLDESCCURSOR1_tag CTRLDESCCURSOR1; /* Control Descriptor Cursor 1 Register */
  DCU_CTRLDESCCURSOR2_tag CTRLDESCCURSOR2; /* Control Descriptor Cursor 2 Register */
  DCU_CTRLDESCCURSOR3_tag CTRLDESCCURSOR3; /* Control Descriptor Cursor 3 Register */
  DCU_CTRLDESCCURSOR4_tag CTRLDESCCURSOR4; /* Control Descriptor Cursor 4 Register */
  DCU_MODE_tag MODE;                   /* Mode Register */
  DCU_BGND_tag BGND;                   /* Background Register */
  DCU_DISP_SIZE_tag DISP_SIZE;         /* Display Size Register */
  DCU_HSYN_PARA_tag HSYN_PARA;         /* Horizontal Sync Parameter Register */
  DCU_VSYN_PARA_tag VSYN_PARA;         /* Vertical Sync Parameter Register */
  DCU_SYNPOL_tag SYNPOL;               /* Synchronize Polarity Register */
  DCU_THRESHOLD_tag THRESHOLD;         /* Threshold Register */
  DCU_INT_STATUS_tag INT_STATUS;       /* Interrupt Status Register */
  DCU_INT_MASK_tag INT_MASK;           /* Interrupt Mask Register */
  DCU_COLBAR_1_tag COLBAR_1;           /* COLBAR_1 Register */
  DCU_COLBAR_2_tag COLBAR_2;           /* COLBAR_2 Register */
  DCU_COLBAR_3_tag COLBAR_3;           /* COLBAR_3 Register */
  DCU_COLBAR_4_tag COLBAR_4;           /* COLBAR_4 Register */
  DCU_COLBAR_5_tag COLBAR_5;           /* COLBAR_5 Register */
  DCU_COLBAR_6_tag COLBAR_6;           /* COLBAR_6 Register */
  DCU_COLBAR_7_tag COLBAR_7;           /* COLBAR_7 Register */
  DCU_COLBAR_8_tag COLBAR_8;           /* COLBAR_8 Register */
  DCU_DIV_RATIO_tag DIV_RATIO;         /* Divide Ratio Register */
  DCU_SIGN_CALC_1_tag SIGN_CALC_1;     /* Sign Calculation 1 Register */
  DCU_SIGN_CALC_2_tag SIGN_CALC_2;     /* Sign Calculation 2 Register */
  DCU_CRC_VAL_tag CRC_VAL;             /* CRC Value Register */
  uint8_t DCU_reserved0[8];
  DCU_PARR_ERR_STATUS1_tag PARR_ERR_STATUS1; /* Parameter Error Status 1 Register */
  uint8_t DCU_reserved1[12];
  DCU_PARR_ERR_STATUS3_tag PARR_ERR_STATUS3; /* Parameter Error Status 3 Register */
  DCU_MASK_PARR_ERR_STATUS1_tag MASK_PARR_ERR_STATUS1; /* Mask Parameter Error Status 1 Register */
  uint8_t DCU_reserved2[12];
  DCU_MASK_PARR_ERR_STATUS3_tag MASK_PARR_ERR_STATUS3; /* Mask Parameter Error Status 3 Register */
  DCU_THRESHOLD_INP_BUF_1_tag THRESHOLD_INP_BUF_1; /* Threshold Input 1 Register */
  DCU_THRESHOLD_INP_BUF_2_tag THRESHOLD_INP_BUF_2; /* Threshold Input 2 Register */
  DCU_THRESHOLD_INP_BUF_3_tag THRESHOLD_INP_BUF_3; /* Threshold Input 3 Register */
  DCU_LUMA_COMP_tag LUMA_COMP;         /* LUMA Component Register */
  DCU_CHROMA_RED_tag CHROMA_RED;       /* Red Chroma Components Register */
  DCU_CHROMA_GREEN_tag CHROMA_GREEN;   /* Green Chroma Components Register */
  DCU_CHROMA_BLUE_tag CHROMA_BLUE;     /* Blue Chroma Components Register */
  DCU_CRC_POS_tag CRC_POS;             /* CRC Position Register */
  DCU_LYR_INTPOL_EN_tag LYR_INTPOL_EN; /* Layer Interpolation Enable Register */
  DCU_LYR_LUMA_COMP_tag LYR_LUMA_COMP; /* Layer Luminance Component Register */
  DCU_LYR_CHRM_RED_tag LYR_CHRM_RED;   /* Layer Chroma Red Register */
  DCU_LYR_CHRM_GRN_tag LYR_CHRM_GRN;   /* Layer Chroma Green Register */
  DCU_LYR_CHRM_BLUE_tag LYR_CHRM_BLUE; /* Layer Chroma Blue Register */
  uint8_t DCU_reserved3[4];
  DCU_UPDATE_MODE_tag UPDATE_MODE;     /* Update Mode Register */
  DCU_UNDERRUN_tag UNDERRUN;           /* Underrun Register */
  DCU_WRITEBACK_ADDR_tag WRITEBACK_ADDR; /* Write back address */
  DCU_WRITEBACK_CTRL_tag WRITEBACK_CTRL;
  DCU_WRITEBACK_STAT_tag WRITEBACK_STAT; /* Writeback status */
  uint8_t DCU_reserved4[32];
  DCU_GPR_tag GPR;                     /* Global Protection Register */
  DCU_SLR_L0_tag SLR_L0;               /* Soft Lock Bit Layer 0 Register */
  DCU_SLR_L1_tag SLR_L1;               /* Soft Lock Bit Layer 1 Register */
  DCU_SLR_DISP_SIZE_tag SLR_DISP_SIZE; /* Soft Lock Display Size Register */
  DCU_SLR_HVSYNC_PARA_tag SLR_HVSYNC_PARA; /* Soft Lock Hsync/Vsync Parameter Register */
  DCU_SLR_POL_tag SLR_POL;             /* Soft Lock POL Register */
  DCU_SLR_L0_TRANSP_tag SLR_L0_TRANSP; /* Soft Lock L0 Transparency Register */
  DCU_SLR_L1_TRANSP_tag SLR_L1_TRANSP; /* Soft Lock L1 Transparency Register */
  DCU_SLR_HUD_tag SLR_HUD;             /* Soft Lock HUD Register */
  uint8_t DCU_reserved5[220];
  DCU_R_tag R[32];
  uint8_t DCU_reserved6[17920];
  DCU_HUD_WIDTH_tag HUD_WIDTH;         /* Hud width */
  DCU_HUD_HEIGHT_tag HUD_HEIGHT;       /* Hud height */
  DCU_WARP_DESC_ADDR_tag WARP_DESC_ADDR; /* Warping Descriptor base address */
  DCU_WARP_IRQ_CTRL_tag WARP_IRQ_CTRL; /* Warping interrupt configuration */
  DCU_WARP_IRQ_STAT_tag WARP_IRQ_STAT; /* Warp interrupt status */
  DCU_WARP_CTRL_tag WARP_CTRL;         /* Warping control */
  DCU_WARP_XOVR_STAT_tag WARP_XOVR_STAT; /* Warping X overflow status */
  DCU_WARP_YOVR_STAT_tag WARP_YOVR_STAT; /* Warping Y overflow status */
  DCU_WARP_DESC_TB_SZ_tag WARP_DESC_TB_SZ; /* Warping line descriptor table size */
};


/* ============================================================================
   =============================== Module: DDRC_PRIOMAN =======================
   ============================================================================ */

typedef union DDRC_PRIOMAN_CONFIG1_union_tag { /* DDRC PRIOMAN_CONFIG1 */
  vuint32_t R;
  struct {
    vuint32_t ACK_COUNT0:4;
    vuint32_t ACK_COUNT1:4;
    vuint32_t ACK_COUNT2:4;
    vuint32_t ACK_COUNT3:4;
    vuint32_t ACK_COUNT4:4;
    vuint32_t ACK_COUNT5:4;
    vuint32_t LUT_SEL0:2;
    vuint32_t LUT_SEL1:2;
    vuint32_t LUT_SEL2:2;
    vuint32_t LUT_SEL3:2;
  } B;
} DDRC_PRIOMAN_CONFIG1_tag;

typedef union DDRC_PRIOMAN_CONFIG2_union_tag { /* PRIOMAN_CONFIG2 */
  vuint32_t R;
  struct {
    vuint32_t LUTSEL4:2;
    vuint32_t LUTSEL5:2;
    vuint32_t ACKSEL0:1;
    vuint32_t ACKSEL1:1;
    vuint32_t ACKSEL2:1;
    vuint32_t ACKSEL3:1;
    vuint32_t ACKSEL4:1;
    vuint32_t ACKSEL5:1;
    vuint32_t _unused_10:1;
    vuint32_t CONGESTED:1;
    vuint32_t _unused_12:20;
  } B;
} DDRC_PRIOMAN_CONFIG2_tag;

typedef union DDRC_PRIOMAN_HIPRIO_CONFIG_union_tag { /* High Priority Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t AV_HIPRIO:13;
    vuint32_t FIL_BW:3;
    vuint32_t C_CONGEST_L:8;
    vuint32_t SET_CONGEST_L:8;
  } B;
} DDRC_PRIOMAN_HIPRIO_CONFIG_tag;

typedef union DDRC_PRIOMAN_LUT_MAIN_U_union_tag { /* LUT Main Upper Registers */
  vuint32_t R;
  struct {
    vuint32_t PRIO8:4;
    vuint32_t PRIO9:4;
    vuint32_t PRIO10:4;
    vuint32_t PRIO11:4;
    vuint32_t PRIO12:4;
    vuint32_t PRIO13:4;
    vuint32_t PRIO14:4;
    vuint32_t PRIO15:4;
  } B;
} DDRC_PRIOMAN_LUT_MAIN_U_tag;

typedef union DDRC_PRIOMAN_LUT_MAIN_L_union_tag { /* LUT Main Lower Registers */
  vuint32_t R;
  struct {
    vuint32_t PRIO0:4;
    vuint32_t PRIO1:4;
    vuint32_t PRIO2:4;
    vuint32_t PRIO3:4;
    vuint32_t PRIO4:4;
    vuint32_t PRIO5:4;
    vuint32_t PRIO6:4;
    vuint32_t PRIO7:4;
  } B;
} DDRC_PRIOMAN_LUT_MAIN_L_tag;

typedef union DDRC_PRIOMAN_LUT_ALT_union_tag { /* LUT Alternate Upper Registers */
  vuint32_t R;
  struct {
    vuint32_t PRIO8:4;
    vuint32_t PRIO9:4;
    vuint32_t PRIO10:4;
    vuint32_t PRIO11:4;
    vuint32_t PRIO12:4;
    vuint32_t PRIO13:4;
    vuint32_t PRIO14:4;
    vuint32_t PRIO15:4;
  } B;
} DDRC_PRIOMAN_LUT_ALT_tag;

typedef union DDRC_PRIOMAN_LUT_ALT_L_union_tag { /* LUT Alternate Lower Registers */
  vuint32_t R;
  struct {
    vuint32_t PRIO0:4;
    vuint32_t PRIO1:4;
    vuint32_t PRIO2:4;
    vuint32_t PRIO3:4;
    vuint32_t PRIO4:4;
    vuint32_t PRIO5:4;
    vuint32_t PRIO6:4;
    vuint32_t PRIO7:4;
  } B;
} DDRC_PRIOMAN_LUT_ALT_L_tag;

typedef union DDRC_PRIOMAN_PERMON_CONFIG_union_tag { /* Performance Monitor Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LUTSEL0:2;
    vuint32_t LUTSEL1:2;
    vuint32_t LUTSEL2:2;
    vuint32_t LUTSEL3:2;
    vuint32_t LUTSEL4:2;
    vuint32_t LUTSEL5:2;
    vuint32_t _unused_12:13;
    vuint32_t EV_CNT_TRG:1;
    vuint32_t EV_CNT_FR:1;
    vuint32_t DMAREQSTOP:1;
    vuint32_t DMAREQ:1;
    vuint32_t INTEN:1;
    vuint32_t INTCLEAR:1;
    vuint32_t INT:1;
  } B;
} DDRC_PRIOMAN_PERMON_CONFIG_tag;

typedef union DDRC_PRIOMAN_ETC_union_tag { /* Event Time Counter Register */
  vuint32_t R;
  struct {
    vuint32_t ETC:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_ETC_tag;

typedef union DDRC_PRIOMAN_ETP_union_tag { /* Event Time Preset Register */
  vuint32_t R;
  struct {
    vuint32_t ETP:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_ETP_tag;

typedef union DDRC_PRIOMAN_PER_MON_1_2_L0_union_tag { /* Performance Monitor 1 and 2 Address Registers */
  vuint32_t R;
  struct {
    vuint32_t BUS_SEL:3;
    vuint32_t _unused_3:2;
    vuint32_t PER_MON_1_2_L:27;
  } B;
} DDRC_PRIOMAN_PER_MON_1_2_L0_tag;

typedef union DDRC_PRIOMAN_PER_MON_1_2_L1_union_tag { /* Performance Monitor 1 and 2 Address Registers */
  vuint32_t R;
  struct {
    vuint32_t BUS_SEL:3;
    vuint32_t _unused_3:2;
    vuint32_t PER_MON_1_2_L:27;
  } B;
} DDRC_PRIOMAN_PER_MON_1_2_L1_tag;

typedef union DDRC_PRIOMAN_PER_MON_1_2_H0_union_tag { /* Performance Monitor 1 and 2 Address High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t PER_MON_1_2_H:27;
  } B;
} DDRC_PRIOMAN_PER_MON_1_2_H0_tag;

typedef union DDRC_PRIOMAN_PER_MON_1_2_H1_union_tag { /* Performance Monitor 1 and 2 Address High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:5;
    vuint32_t PER_MON_1_2_H:27;
  } B;
} DDRC_PRIOMAN_PER_MON_1_2_H1_tag;

typedef union DDRC_PRIOMAN_PER_MON_C_union_tag { /* Performance Monitor Counters Registers */
  vuint32_t R;
  struct {
    vuint32_t PER_MON_R_W_C:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_PER_MON_C_tag;

typedef union DDRC_PRIOMAN_GRA_ACK_C_union_tag { /* Granted Ack Counter Registers */
  vuint32_t R;
  struct {
    vuint32_t G_ACK_C:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_GRA_ACK_C_tag;

typedef union DDRC_PRIOMAN_CUM_WAIT_C_union_tag { /* Cumulative Wait Counter Registers */
  vuint32_t R;
  struct {
    vuint32_t CUM_WAIT_C:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_CUM_WAIT_C_tag;

typedef union DDRC_PRIOMAN_SUM_PRI_C_union_tag { /* Summed Priority Counter Registers */
  vuint32_t R;
  struct {
    vuint32_t SUM_PRI_C:24;
    vuint32_t _unused_24:8;
  } B;
} DDRC_PRIOMAN_SUM_PRI_C_tag;

struct DDRC_PRIOMAN_tag {
  uint8_t DDRC_PRIOMAN_reserved0[128];
  DDRC_PRIOMAN_CONFIG1_tag CONFIG1;    /* DDRC PRIOMAN_CONFIG1 */
  DDRC_PRIOMAN_CONFIG2_tag CONFIG2;    /* PRIOMAN_CONFIG2 */
  DDRC_PRIOMAN_HIPRIO_CONFIG_tag HIPRIO_CONFIG; /* High Priority Configuration Register */
  DDRC_PRIOMAN_LUT_MAIN_U_tag LUT_MAIN_U[6]; /* LUT Main Upper Registers */
  DDRC_PRIOMAN_LUT_MAIN_L_tag LUT_MAIN_L[6]; /* LUT Main Lower Registers */
  DDRC_PRIOMAN_LUT_ALT_tag LUT_ALT[6]; /* LUT Alternate Upper Registers */
  DDRC_PRIOMAN_LUT_ALT_L_tag LUT_ALT_L[6]; /* LUT Alternate Lower Registers */
  DDRC_PRIOMAN_PERMON_CONFIG_tag PERMON_CONFIG; /* Performance Monitor Configuration Register */
  DDRC_PRIOMAN_ETC_tag ETC;            /* Event Time Counter Register */
  DDRC_PRIOMAN_ETP_tag ETP;            /* Event Time Preset Register */
  DDRC_PRIOMAN_PER_MON_1_2_L0_tag PER_MON_1_2_L0; /* Performance Monitor 1 and 2 Address Registers */
  DDRC_PRIOMAN_PER_MON_1_2_L1_tag PER_MON_1_2_L1; /* Performance Monitor 1 and 2 Address Registers */
  DDRC_PRIOMAN_PER_MON_1_2_H0_tag PER_MON_1_2_H0; /* Performance Monitor 1 and 2 Address High Register */
  DDRC_PRIOMAN_PER_MON_1_2_H1_tag PER_MON_1_2_H1; /* Performance Monitor 1 and 2 Address High Register */
  DDRC_PRIOMAN_PER_MON_C_tag PER_MON_C[4]; /* Performance Monitor Counters Registers */
  DDRC_PRIOMAN_GRA_ACK_C_tag GRA_ACK_C[6]; /* Granted Ack Counter Registers */
  DDRC_PRIOMAN_CUM_WAIT_C_tag CUM_WAIT_C[6]; /* Cumulative Wait Counter Registers */
  DDRC_PRIOMAN_SUM_PRI_C_tag SUM_PRI_C[6]; /* Summed Priority Counter Registers */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t _unused_3:1;
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t _unused_8:8;
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t _unused_18:14;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t DBE:1;                   /* Destination Bus Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t ERRCHN:4;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t _unused_12:2;
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_15:1;
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t _unused_17:14;
    vuint32_t VLD:1;
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t _unused_16:16;
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t _unused_16:16;
  } B;
} DMA_EEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t CEEI:4;                   /* Clear Enable Error Interrupt */
    vuint8_t _unused_4:2;
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CEEI_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SEEI:4;                   /* Set Enable Error Interrupt */
    vuint8_t _unused_4:2;
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t CERQ:4;                   /* Clear Enable Request */
    vuint8_t _unused_4:2;
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t SERQ:4;                   /* Set Enable Request */
    vuint8_t _unused_4:2;
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t CDNE:4;                   /* Clear DONE Bit */
    vuint8_t _unused_4:2;
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CDNE_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t SSRT:4;                   /* Set START Bit */
    vuint8_t _unused_4:2;
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t CERR:4;                   /* Clear Error Indicator */
    vuint8_t _unused_4:2;
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CERR_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t CINT:4;                   /* Clear Interrupt Request */
    vuint8_t _unused_4:2;
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} DMA_CINT_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t _unused_16:16;
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t _unused_16:16;
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t _unused_16:16;
  } B;
} DMA_HRS_tag;

typedef union DMA_DCHPRI3_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI3_tag;

typedef union DMA_DCHPRI2_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI2_tag;

typedef union DMA_DCHPRI1_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI1_tag;

typedef union DMA_DCHPRI0_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI0_tag;

typedef union DMA_DCHPRI7_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI7_tag;

typedef union DMA_DCHPRI6_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI6_tag;

typedef union DMA_DCHPRI5_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI5_tag;

typedef union DMA_DCHPRI4_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI4_tag;

typedef union DMA_DCHPRI11_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI11_tag;

typedef union DMA_DCHPRI10_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI10_tag;

typedef union DMA_DCHPRI9_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI9_tag;

typedef union DMA_DCHPRI8_union_tag {  /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI8_tag;

typedef union DMA_DCHPRI15_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI15_tag;

typedef union DMA_DCHPRI14_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI14_tag;

typedef union DMA_DCHPRI13_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI13_tag;

typedef union DMA_DCHPRI12_union_tag { /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
  } B;
} DMA_DCHPRI12_tag;

typedef union DMA_DCHMID3_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID3_tag;

typedef union DMA_DCHMID2_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID2_tag;

typedef union DMA_DCHMID1_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID1_tag;

typedef union DMA_DCHMID0_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID0_tag;

typedef union DMA_DCHMID7_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID7_tag;

typedef union DMA_DCHMID6_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID6_tag;

typedef union DMA_DCHMID5_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID5_tag;

typedef union DMA_DCHMID4_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID4_tag;

typedef union DMA_DCHMID11_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID11_tag;

typedef union DMA_DCHMID10_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID10_tag;

typedef union DMA_DCHMID9_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID9_tag;

typedef union DMA_DCHMID8_union_tag {  /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID8_tag;

typedef union DMA_DCHMID15_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID15_tag;

typedef union DMA_DCHMID14_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID14_tag;

typedef union DMA_DCHMID13_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID13_tag;

typedef union DMA_DCHMID12_union_tag { /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t MID:4;                    /* Master ID */
    vuint8_t _unused_4:2;
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t EMI:1;                    /* Enable Master ID replication */
  } B;
} DMA_DCHMID12_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t SMOD:5;                  /* Source Address Modulo */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:15;                /* Current Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
    vuint16_t LINKCH:4;                /* Minor Loop Link Channel Number */
    vuint16_t _unused_13:2;
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t START:1;                 /* Channel Start */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t MAJORLINKCH:4;           /* Major Loop Link Channel Number */
    vuint16_t _unused_12:2;
    vuint16_t BWC:2;                   /* Bandwidth Control */
  } B;
} DMA_TCD_CSR_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:9;                 /* Starting major iteration count */
    vuint16_t LINKCH:4;                /* Link Channel Number */
    vuint16_t _unused_13:2;
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
  DMA_TCD_BITER_tag BITER;
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  uint8_t DMA_reserved5[200];
  DMA_DCHPRI3_tag DCHPRI3;             /* Channel n Priority Register */
  DMA_DCHPRI2_tag DCHPRI2;             /* Channel n Priority Register */
  DMA_DCHPRI1_tag DCHPRI1;             /* Channel n Priority Register */
  DMA_DCHPRI0_tag DCHPRI0;             /* Channel n Priority Register */
  DMA_DCHPRI7_tag DCHPRI7;             /* Channel n Priority Register */
  DMA_DCHPRI6_tag DCHPRI6;             /* Channel n Priority Register */
  DMA_DCHPRI5_tag DCHPRI5;             /* Channel n Priority Register */
  DMA_DCHPRI4_tag DCHPRI4;             /* Channel n Priority Register */
  DMA_DCHPRI11_tag DCHPRI11;           /* Channel n Priority Register */
  DMA_DCHPRI10_tag DCHPRI10;           /* Channel n Priority Register */
  DMA_DCHPRI9_tag DCHPRI9;             /* Channel n Priority Register */
  DMA_DCHPRI8_tag DCHPRI8;             /* Channel n Priority Register */
  DMA_DCHPRI15_tag DCHPRI15;           /* Channel n Priority Register */
  DMA_DCHPRI14_tag DCHPRI14;           /* Channel n Priority Register */
  DMA_DCHPRI13_tag DCHPRI13;           /* Channel n Priority Register */
  DMA_DCHPRI12_tag DCHPRI12;           /* Channel n Priority Register */
  uint8_t DMA_reserved6[48];
  DMA_DCHMID3_tag DCHMID3;             /* Channel n Master ID Register */
  DMA_DCHMID2_tag DCHMID2;             /* Channel n Master ID Register */
  DMA_DCHMID1_tag DCHMID1;             /* Channel n Master ID Register */
  DMA_DCHMID0_tag DCHMID0;             /* Channel n Master ID Register */
  DMA_DCHMID7_tag DCHMID7;             /* Channel n Master ID Register */
  DMA_DCHMID6_tag DCHMID6;             /* Channel n Master ID Register */
  DMA_DCHMID5_tag DCHMID5;             /* Channel n Master ID Register */
  DMA_DCHMID4_tag DCHMID4;             /* Channel n Master ID Register */
  DMA_DCHMID11_tag DCHMID11;           /* Channel n Master ID Register */
  DMA_DCHMID10_tag DCHMID10;           /* Channel n Master ID Register */
  DMA_DCHMID9_tag DCHMID9;             /* Channel n Master ID Register */
  DMA_DCHMID8_tag DCHMID8;             /* Channel n Master ID Register */
  DMA_DCHMID15_tag DCHMID15;           /* Channel n Master ID Register */
  DMA_DCHMID14_tag DCHMID14;           /* Channel n Master ID Register */
  DMA_DCHMID13_tag DCHMID13;           /* Channel n Master ID Register */
  DMA_DCHMID12_tag DCHMID12;           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3760];
  DMA_TCD_tag TCD[16];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG3_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG3_tag;

typedef union DMAMUX_CHCFG2_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG2_tag;

typedef union DMAMUX_CHCFG1_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG1_tag;

typedef union DMAMUX_CHCFG0_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG0_tag;

typedef union DMAMUX_CHCFG7_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG7_tag;

typedef union DMAMUX_CHCFG6_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG6_tag;

typedef union DMAMUX_CHCFG5_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG5_tag;

typedef union DMAMUX_CHCFG4_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG4_tag;

typedef union DMAMUX_CHCFG11_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG11_tag;

typedef union DMAMUX_CHCFG10_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG10_tag;

typedef union DMAMUX_CHCFG9_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG9_tag;

typedef union DMAMUX_CHCFG8_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG8_tag;

typedef union DMAMUX_CHCFG15_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG15_tag;

typedef union DMAMUX_CHCFG14_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG14_tag;

typedef union DMAMUX_CHCFG13_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG13_tag;

typedef union DMAMUX_CHCFG12_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG12_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG3_tag CHCFG3;            /* Channel Configuration register */
  DMAMUX_CHCFG2_tag CHCFG2;            /* Channel Configuration register */
  DMAMUX_CHCFG1_tag CHCFG1;            /* Channel Configuration register */
  DMAMUX_CHCFG0_tag CHCFG0;            /* Channel Configuration register */
  DMAMUX_CHCFG7_tag CHCFG7;            /* Channel Configuration register */
  DMAMUX_CHCFG6_tag CHCFG6;            /* Channel Configuration register */
  DMAMUX_CHCFG5_tag CHCFG5;            /* Channel Configuration register */
  DMAMUX_CHCFG4_tag CHCFG4;            /* Channel Configuration register */
  DMAMUX_CHCFG11_tag CHCFG11;          /* Channel Configuration register */
  DMAMUX_CHCFG10_tag CHCFG10;          /* Channel Configuration register */
  DMAMUX_CHCFG9_tag CHCFG9;            /* Channel Configuration register */
  DMAMUX_CHCFG8_tag CHCFG8;            /* Channel Configuration register */
  DMAMUX_CHCFG15_tag CHCFG15;          /* Channel Configuration register */
  DMAMUX_CHCFG14_tag CHCFG14;          /* Channel Configuration register */
  DMAMUX_CHCFG13_tag CHCFG13;          /* Channel Configuration register */
  DMAMUX_CHCFG12_tag CHCFG12;          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:18;
    vuint32_t EICH13EN:1;              /* Error Injection Channel 13 Enable */
    vuint32_t EICH12EN:1;              /* Error Injection Channel 12 Enable */
    vuint32_t EICH11EN:1;              /* Error Injection Channel 11 Enable */
    vuint32_t EICH10EN:1;              /* Error Injection Channel 10 Enable */
    vuint32_t EICH9EN:1;               /* Error Injection Channel 9 Enable */
    vuint32_t EICH8EN:1;               /* Error Injection Channel 8 Enable */
    vuint32_t EICH7EN:1;               /* Error Injection Channel 7 Enable */
    vuint32_t EICH6EN:1;               /* Error Injection Channel 6 Enable */
    vuint32_t EICH5EN:1;               /* Error Injection Channel 5 Enable */
    vuint32_t EICH4EN:1;               /* Error Injection Channel 4 Enable */
    vuint32_t EICH3EN:1;               /* Error Injection Channel 3 Enable */
    vuint32_t EICH2EN:1;               /* Error Injection Channel 2 Enable */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t CHKBIT_MASK:8;           /* Checkbit Mask */
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

typedef struct EIM_EICHD_struct_tag {
  EIM_EICHD_WORD0_tag WORD0;           /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag WORD1;           /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag WORD2;           /* Error Injection Channel Descriptor, Word2 */
  uint8_t EICHD_reserved0[244];
} EIM_EICHD_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_tag EICHD[14];
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

typedef union ENET_EIR_union_tag {     /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:3;
    vuint32_t RXFLUSH_0:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_2:1;
    vuint32_t TS_TIMER:1;              /* Timestamp Timer */
    vuint32_t TS_AVAIL:1;              /* Transmit Timestamp Available */
    vuint32_t WAKEUP:1;                /* Node Wakeup Request Indication */
    vuint32_t PLR:1;                   /* Payload Receive Error */
    vuint32_t UN:1;                    /* Transmit FIFO Underrun */
    vuint32_t RL:1;                    /* Collision Retry Limit */
    vuint32_t LC:1;                    /* Late Collision */
    vuint32_t EBERR:1;                 /* Ethernet Bus Error */
    vuint32_t MII:1;                   /* MII Interrupt. */
    vuint32_t RXB:1;                   /* Receive Buffer Interrupt */
    vuint32_t RXF:1;                   /* Receive Frame Interrupt */
    vuint32_t TXB:1;                   /* Transmit Buffer Interrupt */
    vuint32_t TXF:1;                   /* Transmit Frame Interrupt */
    vuint32_t GRA:1;                   /* Graceful Stop Complete */
    vuint32_t BABT:1;                  /* Babbling Transmit Error */
    vuint32_t BABR:1;                  /* Babbling Receive Error */
    vuint32_t _unused_31:1;
  } B;
} ENET_EIR_tag;

typedef union ENET_EIMR_union_tag {    /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t RXB1:1;                  /* Receive buffer interrupt, class 1 */
    vuint32_t RXF1:1;                  /* Receive frame interrupt, class 1 */
    vuint32_t TXB1:1;                  /* Transmit buffer interrupt, class 1 */
    vuint32_t TXF1:1;                  /* Transmit frame interrupt, class 1 */
    vuint32_t RXB2:1;                  /* Receive buffer interrupt, class 2 */
    vuint32_t RXF2:1;                  /* Receive frame interrupt, class 2 */
    vuint32_t TXB2:1;                  /* Transmit buffer interrupt, class 2 */
    vuint32_t TXF2:1;                  /* Transmit frame interrupt, class 2 */
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:3;
    vuint32_t RXFLUSH_0:1;
    vuint32_t RXFLUSH_1:1;
    vuint32_t RXFLUSH_2:1;
    vuint32_t TS_TIMER:1;              /* TS_TIMER Interrupt Mask */
    vuint32_t TS_AVAIL:1;              /* TS_AVAIL Interrupt Mask */
    vuint32_t WAKEUP:1;                /* WAKEUP Interrupt Mask */
    vuint32_t PLR:1;                   /* PLR Interrupt Mask */
    vuint32_t UN:1;                    /* UN Interrupt Mask */
    vuint32_t RL:1;                    /* RL Interrupt Mask */
    vuint32_t LC:1;                    /* LC Interrupt Mask */
    vuint32_t EBERR:1;                 /* EBERR Interrupt Mask */
    vuint32_t MII:1;                   /* MII Interrupt Mask */
    vuint32_t RXB:1;                   /* RXB Interrupt Mask */
    vuint32_t RXF:1;                   /* RXF Interrupt Mask */
    vuint32_t TXB:1;                   /* TXB Interrupt Mask */
    vuint32_t TXF:1;                   /* TXF Interrupt Mask */
    vuint32_t GRA:1;                   /* GRA Interrupt Mask */
    vuint32_t BABT:1;                  /* BABT Interrupt Mask */
    vuint32_t BABR:1;                  /* BABR Interrupt Mask */
    vuint32_t _unused_31:1;
  } B;
} ENET_EIMR_tag;

typedef union ENET_RDAR_union_tag {    /* Receive Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR_tag;

typedef union ENET_TDAR_union_tag {    /* Transmit Descriptor Active Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR_tag;

typedef union ENET_ECR_union_tag {     /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t RESET:1;                 /* Ethernet MAC Reset */
    vuint32_t ETHEREN:1;               /* Ethernet Enable */
    vuint32_t MAGICEN:1;               /* Magic Packet Detection Enable */
    vuint32_t SLEEP:1;                 /* Sleep Mode Enable */
    vuint32_t EN1588:1;                /* EN1588 Enable */
    vuint32_t _unused_5:1;
    vuint32_t DBGEN:1;                 /* Debug Enable */
    vuint32_t _unused_7:1;
    vuint32_t DBSWP:1;                 /* Descriptor Byte Swapping Enable */
    vuint32_t SVLANEN:1;               /* S-VLAN enable */
    vuint32_t VLANUSE2ND:1;            /* VLAN use second tag */
    vuint32_t SVLANDBL:1;              /* S-VLAN double tag */
    vuint32_t _unused_12:6;
    vuint32_t _unused_18:14;
  } B;
} ENET_ECR_tag;

typedef union ENET_MMFR_union_tag {    /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:16;                 /* Management Frame Data */
    vuint32_t TA:2;                    /* Turn Around */
    vuint32_t RA:5;                    /* Register Address */
    vuint32_t PA:5;                    /* PHY Address */
    vuint32_t OP:2;                    /* Operation Code */
    vuint32_t ST:2;                    /* Start Of Frame Delimiter */
  } B;
} ENET_MMFR_tag;

typedef union ENET_MSCR_union_tag {    /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t MII_SPEED:6;             /* MII Speed */
    vuint32_t DIS_PRE:1;               /* Disable Preamble */
    vuint32_t HOLDTIME:3;              /* Hold time On MDIO Output */
    vuint32_t _unused_11:21;
  } B;
} ENET_MSCR_tag;

typedef union ENET_MIBC_union_tag {    /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:29;
    vuint32_t MIB_CLEAR:1;             /* MIB Clear */
    vuint32_t MIB_IDLE:1;              /* MIB Idle */
    vuint32_t MIB_DIS:1;               /* Disable MIB Logic */
  } B;
} ENET_MIBC_tag;

typedef union ENET_RCR_union_tag {     /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* Internal Loopback */
    vuint32_t DRT:1;                   /* Disable Receive On Transmit */
    vuint32_t MII_MODE:1;              /* Media Independent Interface Mode */
    vuint32_t PROM:1;                  /* Promiscuous Mode */
    vuint32_t BC_REJ:1;                /* Broadcast Frame Reject */
    vuint32_t FCE:1;                   /* Flow Control Enable */
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t RMII_MODE:1;             /* RMII Mode Enable */
    vuint32_t RMII_10T:1;
    vuint32_t _unused_10:2;
    vuint32_t PADEN:1;                 /* Enable Frame Padding Remove On Receive */
    vuint32_t PAUFWD:1;                /* Terminate/Forward Pause Frames */
    vuint32_t CRCFWD:1;                /* Terminate/Forward Received CRC */
    vuint32_t CFEN:1;                  /* MAC Control Frame Enable */
    vuint32_t MAX_FL:14;               /* Maximum Frame Length */
    vuint32_t NLC:1;                   /* Payload Length Check Disable */
    vuint32_t GRS:1;                   /* Graceful Receive Stopped */
  } B;
} ENET_RCR_tag;

typedef union ENET_TCR_union_tag {     /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t GTS:1;                   /* Graceful Transmit Stop */
    vuint32_t _unused_1:1;
    vuint32_t FDEN:1;                  /* Full-Duplex Enable */
    vuint32_t TFC_PAUSE:1;             /* Transmit Frame Control Pause */
    vuint32_t RFC_PAUSE:1;             /* Receive Frame Control Pause */
    vuint32_t ADDSEL:3;                /* Source MAC Address Select On Transmit */
    vuint32_t ADDINS:1;                /* Set MAC Address On Transmit */
    vuint32_t CRCFWD:1;                /* Forward Frame From Application With CRC */
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:21;
  } B;
} ENET_TCR_tag;

typedef union ENET_PALR_union_tag {    /* Physical Address Lower Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;               /* Pause Address */
  } B;
} ENET_PALR_tag;

typedef union ENET_PAUR_union_tag {    /* Physical Address Upper Register */
  vuint32_t R;
  struct {
    vuint32_t TYPE:16;                 /* Type Field In PAUSE Frames */
    vuint32_t PADDR2:16;
  } B;
} ENET_PAUR_tag;

typedef union ENET_OPD_union_tag {     /* Opcode/Pause Duration Register */
  vuint32_t R;
  struct {
    vuint32_t PAUSE_DUR:16;            /* Pause Duration */
    vuint32_t OPCODE:16;               /* Opcode Field In PAUSE Frames */
  } B;
} ENET_OPD_tag;

typedef union ENET_TXIC_union_tag {    /* Transmit Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
  } B;
} ENET_TXIC_tag;

typedef union ENET_RXIC_union_tag {    /* Receive Interrupt Coalescing Register */
  vuint32_t R;
  struct {
    vuint32_t ICTT:16;                 /* Interrupt coalescing timer threshold */
    vuint32_t _unused_16:4;            /* This field must be set to 0. */
    vuint32_t ICFT:8;                  /* Interrupt coalescing frame count threshold */
    vuint32_t _unused_28:2;            /* This field must be set to 0. */
    vuint32_t ICCS:1;                  /* Interrupt Coalescing Timer Clock Source Select */
    vuint32_t ICEN:1;                  /* Interrupt Coalescing Enable */
  } B;
} ENET_RXIC_tag;

typedef union ENET_IAUR_union_tag {    /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} ENET_IAUR_tag;

typedef union ENET_IALR_union_tag {    /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} ENET_IALR_tag;

typedef union ENET_GAUR_union_tag {    /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} ENET_GAUR_tag;

typedef union ENET_GALR_union_tag {    /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} ENET_GALR_tag;

typedef union ENET_TFWR_union_tag {    /* Transmit FIFO Watermark Register */
  vuint32_t R;
  struct {
    vuint32_t TFWR:6;                  /* Transmit FIFO Write */
    vuint32_t _unused_6:2;
    vuint32_t STRFWD:1;                /* Store And Forward Enable */
    vuint32_t _unused_9:23;
  } B;
} ENET_TFWR_tag;

typedef union ENET_RDSR1_union_tag {   /* Receive Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR1_tag;

typedef union ENET_TDSR1_union_tag {   /* Transmit Buffer Descriptor Ring 1 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR1_tag;

typedef union ENET_MRBR1_union_tag {   /* Maximum Receive Buffer Size Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_11:21;
  } B;
} ENET_MRBR1_tag;

typedef union ENET_RDSR2_union_tag {   /* Receive Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR2_tag;

typedef union ENET_TDSR2_union_tag {   /* Transmit Buffer Descriptor Ring 2 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR2_tag;

typedef union ENET_MRBR2_union_tag {   /* Maximum Receive Buffer Size Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_11:21;
  } B;
} ENET_MRBR2_tag;

typedef union ENET_RDSR_union_tag {    /* Receive Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t R_DES_START:29;
  } B;
} ENET_RDSR_tag;

typedef union ENET_TDSR_union_tag {    /* Transmit Buffer Descriptor Ring 0 Start Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:1;
    vuint32_t X_DES_START:29;
  } B;
} ENET_TDSR_tag;

typedef union ENET_MRBR_union_tag {    /* Maximum Receive Buffer Size Register - Ring 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_11:21;
  } B;
} ENET_MRBR_tag;

typedef union ENET_RSFL_union_tag {    /* Receive FIFO Section Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_SECTION_FULL:8;       /* Value Of Receive FIFO Section Full Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_RSFL_tag;

typedef union ENET_RSEM_union_tag {    /* Receive FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_SECTION_EMPTY:8;      /* Value Of The Receive FIFO Section Empty Threshold */
    vuint32_t _unused_8:8;
    vuint32_t STAT_SECTION_EMPTY:5;    /* RX Status FIFO Section Empty Threshold */
    vuint32_t _unused_21:11;
  } B;
} ENET_RSEM_tag;

typedef union ENET_RAEM_union_tag {    /* Receive FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_ALMOST_EMPTY:8;       /* Value Of The Receive FIFO Almost Empty Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_RAEM_tag;

typedef union ENET_RAFL_union_tag {    /* Receive FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t RX_ALMOST_FULL:8;        /* Value Of The Receive FIFO Almost Full Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_RAFL_tag;

typedef union ENET_TSEM_union_tag {    /* Transmit FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_SECTION_EMPTY:8;      /* Value Of The Transmit FIFO Section Empty Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_TSEM_tag;

typedef union ENET_TAEM_union_tag {    /* Transmit FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_ALMOST_EMPTY:8;       /* Value of Transmit FIFO Almost Empty Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_TAEM_tag;

typedef union ENET_TAFL_union_tag {    /* Transmit FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t TX_ALMOST_FULL:8;        /* Value Of The Transmit FIFO Almost Full Threshold */
    vuint32_t _unused_8:24;
  } B;
} ENET_TAFL_tag;

typedef union ENET_TIPG_union_tag {    /* Transmit Inter-Packet Gap */
  vuint32_t R;
  struct {
    vuint32_t IPG:5;                   /* Transmit Inter-Packet Gap */
    vuint32_t _unused_5:27;
  } B;
} ENET_TIPG_tag;

typedef union ENET_FTRL_union_tag {    /* Frame Truncation Length */
  vuint32_t R;
  struct {
    vuint32_t TRUNC_FL:14;             /* Frame Truncation Length */
    vuint32_t _unused_14:18;
  } B;
} ENET_FTRL_tag;

typedef union ENET_TACC_union_tag {    /* Transmit Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t SHIFT16:1;               /* TX FIFO Shift-16 */
    vuint32_t _unused_1:2;
    vuint32_t IPCHK:1;
    vuint32_t PROCHK:1;
    vuint32_t _unused_5:27;
  } B;
} ENET_TACC_tag;

typedef union ENET_RACC_union_tag {    /* Receive Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t PADREM:1;                /* Enable Padding Removal For Short IP Frames */
    vuint32_t IPDIS:1;                 /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
    vuint32_t PRODIS:1;                /* Enable Discard Of Frames With Wrong Protocol Checksum */
    vuint32_t _unused_3:3;
    vuint32_t LINEDIS:1;               /* Enable Discard Of Frames With MAC Layer Errors */
    vuint32_t SHIFT16:1;               /* RX FIFO Shift-16 */
    vuint32_t _unused_8:24;
  } B;
} ENET_RACC_tag;

typedef union ENET_RCMR_union_tag {    /* Receive Classification Match Register for Class n */
  vuint32_t R;
  struct {
    vuint32_t CMP0:3;                  /* Compare 0 */
    vuint32_t _unused_3:1;
    vuint32_t CMP1:3;                  /* Compare 1 */
    vuint32_t _unused_7:1;
    vuint32_t CMP2:3;                  /* Compare 2 */
    vuint32_t _unused_11:1;
    vuint32_t CMP3:3;                  /* Compare 3 */
    vuint32_t _unused_15:1;
    vuint32_t MATCHEN:1;               /* Match Enable */
    vuint32_t _unused_17:15;
  } B;
} ENET_RCMR_tag;

typedef union ENET_DMACFG_union_tag {  /* DMA Class Based Configuration */
  vuint32_t R;
  struct {
    vuint32_t IDLE_SLOPE:16;           /* Idle slope */
    vuint32_t DMA_CLASS_EN:1;          /* DMA class enable */
    vuint32_t CALC_NOIPG:1;            /* Calculate no IPG */
    vuint32_t _unused_18:6;
    vuint32_t _unused_24:8;
  } B;
} ENET_DMACFG_tag;

typedef union ENET_RDAR1_union_tag {   /* Receive Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR1_tag;

typedef union ENET_TDAR1_union_tag {   /* Transmit Descriptor Active Register - Ring 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR1_tag;

typedef union ENET_RDAR2_union_tag {   /* Receive Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_RDAR2_tag;

typedef union ENET_TDAR2_union_tag {   /* Transmit Descriptor Active Register - Ring 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_25:7;
  } B;
} ENET_TDAR2_tag;

typedef union ENET_QOS_union_tag {     /* QOS Scheme */
  vuint32_t R;
  struct {
    vuint32_t TX_SCHEME:3;             /* TX scheme configuration */
    vuint32_t RX_FLUSH0:1;             /* RX Flush Ring 0 */
    vuint32_t RX_FLUSH1:1;             /* RX Flush Ring 1 */
    vuint32_t RX_FLUSH2:1;             /* RX Flush Ring 2 */
    vuint32_t _unused_6:26;
  } B;
} ENET_QOS_tag;

typedef union ENET_RMON_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_RMON_T_DROP_tag;

typedef union ENET_RMON_T_PACKETS_union_tag { /* Tx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Packet count */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_PACKETS_tag;

typedef union ENET_RMON_T_BC_PKT_union_tag { /* Tx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Broadcast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_BC_PKT_tag;

typedef union ENET_RMON_T_MC_PKT_union_tag { /* Tx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Multicast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_MC_PKT_tag;

typedef union ENET_RMON_T_CRC_ALIGN_union_tag { /* Tx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Packets with CRC/align error */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_CRC_ALIGN_tag;

typedef union ENET_RMON_T_UNDERSIZE_union_tag { /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_UNDERSIZE_tag;

typedef union ENET_RMON_T_OVERSIZE_union_tag { /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_OVERSIZE_tag;

typedef union ENET_RMON_T_FRAG_union_tag { /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_FRAG_tag;

typedef union ENET_RMON_T_JAB_union_tag { /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_JAB_tag;

typedef union ENET_RMON_T_COL_union_tag { /* Tx Collision Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_COL_tag;

typedef union ENET_RMON_T_P64_union_tag { /* Tx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 64-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P64_tag;

typedef union ENET_RMON_T_P65TO127_union_tag { /* Tx 65- to 127-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P65TO127_tag;

typedef union ENET_RMON_T_P128TO255_union_tag { /* Tx 128- to 255-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P128TO255_tag;

typedef union ENET_RMON_T_P256TO511_union_tag { /* Tx 256- to 511-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P256TO511_tag;

typedef union ENET_RMON_T_P512TO1023_union_tag { /* Tx 512- to 1023-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P512TO1023_tag;

typedef union ENET_RMON_T_P1024TO2047_union_tag { /* Tx 1024- to 2047-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P1024TO2047_tag;

typedef union ENET_RMON_T_P_GTE2048_union_tag { /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXPKTS:16;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_T_P_GTE2048_tag;

typedef union ENET_RMON_T_OCTETS_union_tag { /* Tx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXOCTS:32;               /* Number of transmit octets */
  } B;
} ENET_RMON_T_OCTETS_tag;

typedef union ENET_IEEE_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_IEEE_T_DROP_tag;

typedef union ENET_IEEE_T_FRAME_OK_union_tag { /* Frames Transmitted OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted OK */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_FRAME_OK_tag;

typedef union ENET_IEEE_T_1COL_union_tag { /* Frames Transmitted with Single Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with one collision */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_1COL_tag;

typedef union ENET_IEEE_T_MCOL_union_tag { /* Frames Transmitted with Multiple Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with multiple collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_MCOL_tag;

typedef union ENET_IEEE_T_DEF_union_tag { /* Frames Transmitted after Deferral Delay Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with deferral delay */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_DEF_tag;

typedef union ENET_IEEE_T_LCOL_union_tag { /* Frames Transmitted with Late Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with late collision */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_LCOL_tag;

typedef union ENET_IEEE_T_EXCOL_union_tag { /* Frames Transmitted with Excessive Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with excessive collisions */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_EXCOL_tag;

typedef union ENET_IEEE_T_MACERR_union_tag { /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_MACERR_tag;

typedef union ENET_IEEE_T_CSERR_union_tag { /* Frames Transmitted with Carrier Sense Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames transmitted with carrier sense error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_CSERR_tag;

typedef union ENET_IEEE_T_SQE_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_SQE_tag;

typedef union ENET_IEEE_T_FDXFC_union_tag { /* Flow Control Pause Frames Transmitted Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of flow-control pause frames transmitted */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_T_FDXFC_tag;

typedef union ENET_IEEE_T_OCTETS_OK_union_tag { /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
  } B;
} ENET_IEEE_T_OCTETS_OK_tag;

typedef union ENET_RMON_R_PACKETS_union_tag { /* Rx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of packets received */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_PACKETS_tag;

typedef union ENET_RMON_R_BC_PKT_union_tag { /* Rx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive broadcast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_BC_PKT_tag;

typedef union ENET_RMON_R_MC_PKT_union_tag { /* Rx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive multicast packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_MC_PKT_tag;

typedef union ENET_RMON_R_CRC_ALIGN_union_tag { /* Rx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with CRC or align error */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_CRC_ALIGN_tag;

typedef union ENET_RMON_R_UNDERSIZE_union_tag { /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_UNDERSIZE_tag;

typedef union ENET_RMON_R_OVERSIZE_union_tag { /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_OVERSIZE_tag;

typedef union ENET_RMON_R_FRAG_union_tag { /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_FRAG_tag;

typedef union ENET_RMON_R_JAB_union_tag { /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_JAB_tag;

typedef union ENET_RMON_R_RESVD_0_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_RESVD_0_tag;

typedef union ENET_RMON_R_P64_union_tag { /* Rx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 64-byte receive packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P64_tag;

typedef union ENET_RMON_R_P65TO127_union_tag { /* Rx 65- to 127-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P65TO127_tag;

typedef union ENET_RMON_R_P128TO255_union_tag { /* Rx 128- to 255-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P128TO255_tag;

typedef union ENET_RMON_R_P256TO511_union_tag { /* Rx 256- to 511-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P256TO511_tag;

typedef union ENET_RMON_R_P512TO1023_union_tag { /* Rx 512- to 1023-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P512TO1023_tag;

typedef union ENET_RMON_R_P1024TO2047_union_tag { /* Rx 1024- to 2047-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P1024TO2047_tag;

typedef union ENET_RMON_R_P_GTE2048_union_tag { /* Rx Packets Greater than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t _unused_16:16;
  } B;
} ENET_RMON_R_P_GTE2048_tag;

typedef union ENET_RMON_R_OCTETS_union_tag { /* Rx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of receive octets */
  } B;
} ENET_RMON_R_OCTETS_tag;

typedef union ENET_IEEE_R_DROP_union_tag { /* Frames not Counted Correctly Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Frame count */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_DROP_tag;

typedef union ENET_IEEE_R_FRAME_OK_union_tag { /* Frames Received OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received OK */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_FRAME_OK_tag;

typedef union ENET_IEEE_R_CRC_union_tag { /* Frames Received with CRC Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received with CRC error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_CRC_tag;

typedef union ENET_IEEE_R_ALIGN_union_tag { /* Frames Received with Alignment Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of frames received with alignment error */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_ALIGN_tag;

typedef union ENET_IEEE_R_MACERR_union_tag { /* Receive FIFO Overflow Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Receive FIFO overflow count */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_MACERR_tag;

typedef union ENET_IEEE_R_FDXFC_union_tag { /* Flow Control Pause Frames Received Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Number of flow-control pause frames received */
    vuint32_t _unused_16:16;
  } B;
} ENET_IEEE_R_FDXFC_tag;

typedef union ENET_IEEE_R_OCTETS_OK_union_tag { /* Octet Count for Frames Received without Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Number of octets for frames received without error */
  } B;
} ENET_IEEE_R_OCTETS_OK_tag;

typedef union ENET_ATCR_union_tag {    /* Adjustable Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t EN:1;                    /* Enable Timer */
    vuint32_t _unused_1:1;
    vuint32_t OFFEN:1;                 /* Enable One-Shot Offset Event */
    vuint32_t OFFRST:1;                /* Reset Timer On Offset Event */
    vuint32_t PEREN:1;                 /* Enable Periodical Event */
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t PINPER:1;
    vuint32_t _unused_8:1;
    vuint32_t RESTART:1;               /* Reset Timer */
    vuint32_t _unused_10:1;
    vuint32_t CAPTURE:1;               /* Capture Timer Value */
    vuint32_t _unused_12:1;
    vuint32_t SLAVE:1;                 /* Enable Timer Slave Mode */
    vuint32_t _unused_14:18;
  } B;
} ENET_ATCR_tag;

typedef union ENET_ATVR_union_tag {    /* Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t ATIME:32;
  } B;
} ENET_ATVR_tag;

typedef union ENET_ATOFF_union_tag {   /* Timer Offset Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:32;
  } B;
} ENET_ATOFF_tag;

typedef union ENET_ATPER_union_tag {   /* Timer Period Register */
  vuint32_t R;
  struct {
    vuint32_t PERIOD:32;
  } B;
} ENET_ATPER_tag;

typedef union ENET_ATCOR_union_tag {   /* Timer Correction Register */
  vuint32_t R;
  struct {
    vuint32_t COR:31;                  /* Correction Counter Wrap-Around Value */
    vuint32_t _unused_31:1;
  } B;
} ENET_ATCOR_tag;

typedef union ENET_ATINC_union_tag {   /* Time-Stamping Clock Period Register */
  vuint32_t R;
  struct {
    vuint32_t INC:7;                   /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
    vuint32_t _unused_7:1;
    vuint32_t INC_CORR:7;              /* Correction Increment Value */
    vuint32_t _unused_15:17;
  } B;
} ENET_ATINC_tag;

typedef union ENET_ATSTMP_union_tag {  /* Timestamp of Last Transmitted Frame */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:32;
  } B;
} ENET_ATSTMP_tag;

typedef union ENET_TGSR_union_tag {    /* Timer Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t TF0:1;                   /* Copy Of Timer Flag For Channel 0 */
    vuint32_t TF1:1;                   /* Copy Of Timer Flag For Channel 1 */
    vuint32_t TF2:1;                   /* Copy Of Timer Flag For Channel 2 */
    vuint32_t TF3:1;                   /* Copy Of Timer Flag For Channel 3 */
    vuint32_t _unused_4:28;
  } B;
} ENET_TGSR_tag;

typedef union ENET_TIMER_TCSR_union_tag { /* Timer Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t TDRE:1;                  /* Timer DMA Request Enable */
    vuint32_t _unused_1:1;
    vuint32_t TMODE:4;                 /* Timer Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TF:1;                    /* Timer Flag */
    vuint32_t _unused_8:24;
  } B;
} ENET_TIMER_TCSR_tag;

typedef union ENET_TIMER_TCCR_union_tag { /* Timer Compare Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TCC:32;                  /* Timer Capture Compare */
  } B;
} ENET_TIMER_TCCR_tag;

typedef struct ENET_TIMER_struct_tag {
  ENET_TIMER_TCSR_tag TCSR;            /* Timer Control Status Register */
  ENET_TIMER_TCCR_tag TCCR;            /* Timer Compare Capture Register */
} ENET_TIMER_tag;

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  ENET_EIR_tag EIR;                    /* Interrupt Event Register */
  ENET_EIMR_tag EIMR;                  /* Interrupt Mask Register */
  uint8_t ENET_reserved1[4];
  ENET_RDAR_tag RDAR;                  /* Receive Descriptor Active Register - Ring 0 */
  ENET_TDAR_tag TDAR;                  /* Transmit Descriptor Active Register - Ring 0 */
  uint8_t ENET_reserved2[12];
  ENET_ECR_tag ECR;                    /* Ethernet Control Register */
  uint8_t ENET_reserved3[24];
  ENET_MMFR_tag MMFR;                  /* MII Management Frame Register */
  ENET_MSCR_tag MSCR;                  /* MII Speed Control Register */
  uint8_t ENET_reserved4[28];
  ENET_MIBC_tag MIBC;                  /* MIB Control Register */
  uint8_t ENET_reserved5[28];
  ENET_RCR_tag RCR;                    /* Receive Control Register */
  uint8_t ENET_reserved6[60];
  ENET_TCR_tag TCR;                    /* Transmit Control Register */
  uint8_t ENET_reserved7[28];
  ENET_PALR_tag PALR;                  /* Physical Address Lower Register */
  ENET_PAUR_tag PAUR;                  /* Physical Address Upper Register */
  ENET_OPD_tag OPD;                    /* Opcode/Pause Duration Register */
  ENET_TXIC_tag TXIC[3];               /* Transmit Interrupt Coalescing Register */
  uint8_t ENET_reserved8[4];
  ENET_RXIC_tag RXIC[3];               /* Receive Interrupt Coalescing Register */
  uint8_t ENET_reserved9[12];
  ENET_IAUR_tag IAUR;                  /* Descriptor Individual Upper Address Register */
  ENET_IALR_tag IALR;                  /* Descriptor Individual Lower Address Register */
  ENET_GAUR_tag GAUR;                  /* Descriptor Group Upper Address Register */
  ENET_GALR_tag GALR;                  /* Descriptor Group Lower Address Register */
  uint8_t ENET_reserved10[28];
  ENET_TFWR_tag TFWR;                  /* Transmit FIFO Watermark Register */
  uint8_t ENET_reserved11[24];
  ENET_RDSR1_tag RDSR1;                /* Receive Descriptor Ring 1 Start Register */
  ENET_TDSR1_tag TDSR1;                /* Transmit Buffer Descriptor Ring 1 Start Register */
  ENET_MRBR1_tag MRBR1;                /* Maximum Receive Buffer Size Register - Ring 1 */
  ENET_RDSR2_tag RDSR2;                /* Receive Descriptor Ring 2 Start Register */
  ENET_TDSR2_tag TDSR2;                /* Transmit Buffer Descriptor Ring 2 Start Register */
  ENET_MRBR2_tag MRBR2;                /* Maximum Receive Buffer Size Register - Ring 2 */
  uint8_t ENET_reserved12[8];
  ENET_RDSR_tag RDSR;                  /* Receive Descriptor Ring 0 Start Register */
  ENET_TDSR_tag TDSR;                  /* Transmit Buffer Descriptor Ring 0 Start Register */
  ENET_MRBR_tag MRBR;                  /* Maximum Receive Buffer Size Register - Ring 0 */
  uint8_t ENET_reserved13[4];
  ENET_RSFL_tag RSFL;                  /* Receive FIFO Section Full Threshold */
  ENET_RSEM_tag RSEM;                  /* Receive FIFO Section Empty Threshold */
  ENET_RAEM_tag RAEM;                  /* Receive FIFO Almost Empty Threshold */
  ENET_RAFL_tag RAFL;                  /* Receive FIFO Almost Full Threshold */
  ENET_TSEM_tag TSEM;                  /* Transmit FIFO Section Empty Threshold */
  ENET_TAEM_tag TAEM;                  /* Transmit FIFO Almost Empty Threshold */
  ENET_TAFL_tag TAFL;                  /* Transmit FIFO Almost Full Threshold */
  ENET_TIPG_tag TIPG;                  /* Transmit Inter-Packet Gap */
  ENET_FTRL_tag FTRL;                  /* Frame Truncation Length */
  uint8_t ENET_reserved14[12];
  ENET_TACC_tag TACC;                  /* Transmit Accelerator Function Configuration */
  ENET_RACC_tag RACC;                  /* Receive Accelerator Function Configuration */
  ENET_RCMR_tag RCMR[2];               /* Receive Classification Match Register for Class n */
  uint8_t ENET_reserved15[8];
  ENET_DMACFG_tag DMACFG[2];           /* DMA Class Based Configuration */
  ENET_RDAR1_tag RDAR1;                /* Receive Descriptor Active Register - Ring 1 */
  ENET_TDAR1_tag TDAR1;                /* Transmit Descriptor Active Register - Ring 1 */
  ENET_RDAR2_tag RDAR2;                /* Receive Descriptor Active Register - Ring 2 */
  ENET_TDAR2_tag TDAR2;                /* Transmit Descriptor Active Register - Ring 2 */
  ENET_QOS_tag QOS;                    /* QOS Scheme */
  uint8_t ENET_reserved16[12];
  ENET_RMON_T_DROP_tag RMON_T_DROP;    /* Reserved Statistic Register */
  ENET_RMON_T_PACKETS_tag RMON_T_PACKETS; /* Tx Packet Count Statistic Register */
  ENET_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* Tx Broadcast Packets Statistic Register */
  ENET_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* Tx Multicast Packets Statistic Register */
  ENET_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* Tx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  ENET_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  ENET_RMON_T_FRAG_tag RMON_T_FRAG;    /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_T_JAB_tag RMON_T_JAB;      /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  ENET_RMON_T_COL_tag RMON_T_COL;      /* Tx Collision Count Statistic Register */
  ENET_RMON_T_P64_tag RMON_T_P64;      /* Tx 64-Byte Packets Statistic Register */
  ENET_RMON_T_P65TO127_tag RMON_T_P65TO127; /* Tx 65- to 127-byte Packets Statistic Register */
  ENET_RMON_T_P128TO255_tag RMON_T_P128TO255; /* Tx 128- to 255-byte Packets Statistic Register */
  ENET_RMON_T_P256TO511_tag RMON_T_P256TO511; /* Tx 256- to 511-byte Packets Statistic Register */
  ENET_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* Tx 512- to 1023-byte Packets Statistic Register */
  ENET_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* Tx 1024- to 2047-byte Packets Statistic Register */
  ENET_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  ENET_RMON_T_OCTETS_tag RMON_T_OCTETS; /* Tx Octets Statistic Register */
  ENET_IEEE_T_DROP_tag IEEE_T_DROP;    /* Reserved Statistic Register */
  ENET_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames Transmitted OK Statistic Register */
  ENET_IEEE_T_1COL_tag IEEE_T_1COL;    /* Frames Transmitted with Single Collision Statistic Register */
  ENET_IEEE_T_MCOL_tag IEEE_T_MCOL;    /* Frames Transmitted with Multiple Collisions Statistic Register */
  ENET_IEEE_T_DEF_tag IEEE_T_DEF;      /* Frames Transmitted after Deferral Delay Statistic Register */
  ENET_IEEE_T_LCOL_tag IEEE_T_LCOL;    /* Frames Transmitted with Late Collision Statistic Register */
  ENET_IEEE_T_EXCOL_tag IEEE_T_EXCOL;  /* Frames Transmitted with Excessive Collisions Statistic Register */
  ENET_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  ENET_IEEE_T_CSERR_tag IEEE_T_CSERR;  /* Frames Transmitted with Carrier Sense Error Statistic Register */
  ENET_IEEE_T_SQE_tag IEEE_T_SQE;      /* Reserved Statistic Register */
  ENET_IEEE_T_FDXFC_tag IEEE_T_FDXFC;  /* Flow Control Pause Frames Transmitted Statistic Register */
  ENET_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  uint8_t ENET_reserved17[12];
  ENET_RMON_R_PACKETS_tag RMON_R_PACKETS; /* Rx Packet Count Statistic Register */
  ENET_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* Rx Broadcast Packets Statistic Register */
  ENET_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* Rx Multicast Packets Statistic Register */
  ENET_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* Rx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  ENET_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  ENET_RMON_R_FRAG_tag RMON_R_FRAG;    /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_JAB_tag RMON_R_JAB;      /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved Statistic Register */
  ENET_RMON_R_P64_tag RMON_R_P64;      /* Rx 64-Byte Packets Statistic Register */
  ENET_RMON_R_P65TO127_tag RMON_R_P65TO127; /* Rx 65- to 127-Byte Packets Statistic Register */
  ENET_RMON_R_P128TO255_tag RMON_R_P128TO255; /* Rx 128- to 255-Byte Packets Statistic Register */
  ENET_RMON_R_P256TO511_tag RMON_R_P256TO511; /* Rx 256- to 511-Byte Packets Statistic Register */
  ENET_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* Rx 512- to 1023-Byte Packets Statistic Register */
  ENET_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* Rx 1024- to 2047-Byte Packets Statistic Register */
  ENET_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* Rx Packets Greater than 2048 Bytes Statistic Register */
  ENET_RMON_R_OCTETS_tag RMON_R_OCTETS; /* Rx Octets Statistic Register */
  ENET_IEEE_R_DROP_tag IEEE_R_DROP;    /* Frames not Counted Correctly Statistic Register */
  ENET_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames Received OK Statistic Register */
  ENET_IEEE_R_CRC_tag IEEE_R_CRC;      /* Frames Received with CRC Error Statistic Register */
  ENET_IEEE_R_ALIGN_tag IEEE_R_ALIGN;  /* Frames Received with Alignment Error Statistic Register */
  ENET_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO Overflow Count Statistic Register */
  ENET_IEEE_R_FDXFC_tag IEEE_R_FDXFC;  /* Flow Control Pause Frames Received Statistic Register */
  ENET_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet Count for Frames Received without Error Statistic Register */
  uint8_t ENET_reserved18[284];
  ENET_ATCR_tag ATCR;                  /* Adjustable Timer Control Register */
  ENET_ATVR_tag ATVR;                  /* Timer Value Register */
  ENET_ATOFF_tag ATOFF;                /* Timer Offset Register */
  ENET_ATPER_tag ATPER;                /* Timer Period Register */
  ENET_ATCOR_tag ATCOR;                /* Timer Correction Register */
  ENET_ATINC_tag ATINC;                /* Time-Stamping Clock Period Register */
  ENET_ATSTMP_tag ATSTMP;              /* Timestamp of Last Transmitted Frame */
  uint8_t ENET_reserved19[488];
  ENET_TGSR_tag TGSR;                  /* Timer Global Status Register */
  ENET_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: ERM ================================
   ============================================================================ */

typedef union ERM_CR0_union_tag {      /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t ENCIE7:1;
    vuint32_t ESCIE7:1;
    vuint32_t _unused_4:2;
    vuint32_t ENCIE6:1;
    vuint32_t ESCIE6:1;
    vuint32_t _unused_8:2;
    vuint32_t ENCIE5:1;
    vuint32_t ESCIE5:1;
    vuint32_t _unused_12:2;
    vuint32_t ENCIE4:1;
    vuint32_t ESCIE4:1;
    vuint32_t _unused_16:2;
    vuint32_t ENCIE3:1;
    vuint32_t ESCIE3:1;
    vuint32_t _unused_20:2;
    vuint32_t ENCIE2:1;
    vuint32_t ESCIE2:1;
    vuint32_t _unused_24:2;
    vuint32_t ENCIE1:1;
    vuint32_t ESCIE1:1;
    vuint32_t _unused_28:2;
    vuint32_t ENCIE0:1;
    vuint32_t ESCIE0:1;
  } B;
} ERM_CR0_tag;

typedef union ERM_CR1_union_tag {      /* ERM Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t _unused_2:2;
    vuint32_t _unused_4:2;
    vuint32_t _unused_6:2;
    vuint32_t _unused_8:2;
    vuint32_t ENCIE13:1;
    vuint32_t ESCIE13:1;
    vuint32_t _unused_12:2;
    vuint32_t ENCIE12:1;
    vuint32_t ESCIE12:1;
    vuint32_t _unused_16:2;
    vuint32_t ENCIE11:1;
    vuint32_t ESCIE11:1;
    vuint32_t _unused_20:2;
    vuint32_t ENCIE10:1;
    vuint32_t ESCIE10:1;
    vuint32_t _unused_24:2;
    vuint32_t ENCIE9:1;
    vuint32_t ESCIE9:1;
    vuint32_t _unused_28:2;
    vuint32_t ENCIE8:1;
    vuint32_t ESCIE8:1;
  } B;
} ERM_CR1_tag;

typedef union ERM_SR0_union_tag {      /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t NCE7:1;
    vuint32_t SBC7:1;
    vuint32_t _unused_4:2;
    vuint32_t NCE6:1;
    vuint32_t SBC6:1;
    vuint32_t _unused_8:2;
    vuint32_t NCE5:1;
    vuint32_t SBC5:1;
    vuint32_t _unused_12:2;
    vuint32_t NCE4:1;
    vuint32_t SBC4:1;
    vuint32_t _unused_16:2;
    vuint32_t NCE3:1;
    vuint32_t SBC3:1;
    vuint32_t _unused_20:2;
    vuint32_t NCE2:1;
    vuint32_t SBC2:1;
    vuint32_t _unused_24:2;
    vuint32_t NCE1:1;
    vuint32_t SBC1:1;
    vuint32_t _unused_28:2;
    vuint32_t NCE0:1;
    vuint32_t SBC0:1;
  } B;
} ERM_SR0_tag;

typedef union ERM_SR1_union_tag {      /* ERM Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t NCE13:1;
    vuint32_t SBC13:1;
    vuint32_t _unused_12:2;
    vuint32_t NCE12:1;
    vuint32_t SBC12:1;
    vuint32_t _unused_16:2;
    vuint32_t NCE11:1;
    vuint32_t SBC11:1;
    vuint32_t _unused_20:2;
    vuint32_t NCE10:1;
    vuint32_t SBC10:1;
    vuint32_t _unused_24:2;
    vuint32_t NCE9:1;
    vuint32_t SBC9:1;
    vuint32_t _unused_28:2;
    vuint32_t NCE8:1;
    vuint32_t SBC8:1;
  } B;
} ERM_SR1_tag;

typedef union ERM_ERROR_EAR_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;
  } B;
} ERM_ERROR_EAR_tag;

typedef union ERM_ERROR_SYN_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SYNDROME:8;
  } B;
} ERM_ERROR_SYN_tag;

typedef struct ERM_ERROR_struct_tag {
  ERM_ERROR_EAR_tag EAR;               /* ERM Memory n Error Address Register */
  ERM_ERROR_SYN_tag SYN;               /* ERM Memory n Syndrome Register */
  uint8_t ERROR_reserved0[8];
} ERM_ERROR_tag;

struct ERM_tag {
  ERM_CR0_tag CR0;                     /* ERM Configuration Register */
  ERM_CR1_tag CR1;                     /* ERM Configuration Register */
  uint8_t ERM_reserved0[8];
  ERM_SR0_tag SR0;                     /* ERM Status Register */
  ERM_SR1_tag SR1;                     /* ERM Status Register */
  uint8_t ERM_reserved1[232];
  ERM_ERROR_tag ERROR[14];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t OPR:5;
    vuint32_t _unused_5:1;
    vuint32_t OPS:2;
    vuint32_t _unused_8:1;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_10:19;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t FILTER_BYPASS:1;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t CM:1;                    /* Fault-Output (EOUT) Configuration-Indication Mode */
    vuint32_t OD:1;
    vuint32_t _unused_13:2;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t _unused_16:4;
    vuint32_t _unused_20:2;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t _unused_25:7;
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC0:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC31:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC0:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC31:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS0:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS31:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE0:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE31:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE0:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE31:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:3;
    vuint32_t _unused_3:29;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t EOUT0:1;
    vuint32_t EOUT1:1;
    vuint32_t _unused_2:2;
    vuint32_t EIN0:1;
    vuint32_t EIN1:1;
    vuint32_t _unused_6:26;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t STATUS:3;
    vuint32_t ESTAT:1;
    vuint32_t PhysicErrorPin:2;
    vuint32_t _unused_6:26;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NAFS:8;
    vuint32_t _unused_8:24;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t AFFS:8;
    vuint32_t AF_SRC:2;
    vuint32_t _unused_10:22;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NFFS:8;
    vuint32_t NF_SRC:2;
    vuint32_t _unused_10:22;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t FAFS:9;
    vuint32_t _unused_9:23;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t FNCFC:7;
    vuint32_t _unused_7:25;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t NMI_STAT:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:27;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_IEN:1;
    vuint32_t _unused_1:2;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:28;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t MCS0:4;
    vuint32_t _unused_4:2;
    vuint32_t FS0:1;
    vuint32_t VL0:1;
    vuint32_t MCS1:4;
    vuint32_t _unused_12:2;
    vuint32_t FS1:1;
    vuint32_t VL1:1;
    vuint32_t MCS2:4;
    vuint32_t _unused_20:2;
    vuint32_t FS2:1;
    vuint32_t VL2:1;
    vuint32_t MCS3:4;
    vuint32_t _unused_28:2;
    vuint32_t FS3:1;
    vuint32_t VL3:1;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock */
  vuint32_t R;
  struct {
    vuint32_t TRANSKEY:9;
    vuint32_t _unused_9:23;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock */
  vuint32_t R;
  struct {
    vuint32_t PERMNTKEY:9;
    vuint32_t _unused_9:23;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t DELTA_T:14;
    vuint32_t _unused_14:2;
    vuint32_t _unused_16:14;
    vuint32_t _unused_30:2;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN0:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN31:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN0:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN31:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Fault-Output (EOUT) Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN0:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN1:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN2:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN3:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN4:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN5:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN6:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN7:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN8:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN9:1;               /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN10:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN11:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN12:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN13:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN14:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN15:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN16:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN17:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN18:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN19:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN20:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN21:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN22:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN23:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN24:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN25:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN26:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN27:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN28:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN29:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN30:1;              /* Fault-Output (EOUT) Signaling Enable */
    vuint32_t EOUTEN31:1;              /* Fault-Output (EOUT) Signaling Enable */
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[3];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[36];
  FCCU_NCFS_CFG_tag NCFS_CFG[5];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[32];
  FCCU_NCF_S_tag NCF_S[3];             /* Noncritical Fault Status */
  uint8_t FCCU_reserved3[4];
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[3];             /* Noncritical Fault Enable */
  uint8_t FCCU_reserved4[4];
  FCCU_NCF_TOE_tag NCF_TOE[3];         /* Noncritical Fault Timeout Enable */
  uint8_t FCCU_reserved5[4];
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timeout */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved6[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[3]; /* IRQ Alarm Enable */
  uint8_t FCCU_reserved7[4];
  FCCU_NMI_EN_tag NMI_EN[3];           /* NMI Enable */
  uint8_t FCCU_reserved8[4];
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[3]; /* Fault-Output (EOUT) Signaling Enable */
};


/* ============================================================================
   =============================== Module: FIRC ===============================
   ============================================================================ */

typedef union FIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t STDBY:1;                 /* Low power RC control in Standby mode */
    vuint32_t _unused_1:3;
    vuint32_t FIRCS:1;                 /* Describes the FIRC clock status. */
    vuint32_t _unused_5:3;
    vuint32_t FIRCDIV:5;               /* The FIRC Divider bits select the clock divider factor. */
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:6;
    vuint32_t _unused_22:10;
  } B;
} FIRC_CTL_tag;

struct FIRC_tag {
  FIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: FTM ================================
   ============================================================================ */

typedef union FTM_SC_union_tag {       /* Status And Control */
  vuint32_t R;
  struct {
    vuint32_t PS:3;                    /* Prescale Factor Selection */
    vuint32_t CLKS:2;                  /* Clock Source Selection */
    vuint32_t CPWMS:1;                 /* Center-Aligned PWM Select */
    vuint32_t TOIE:1;                  /* Timer Overflow Interrupt Enable */
    vuint32_t TOF:1;                   /* Timer Overflow Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_SC_tag;

typedef union FTM_CNT_union_tag {      /* Counter */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Counter Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_CNT_tag;

typedef union FTM_MOD_union_tag {      /* Modulo */
  vuint32_t R;
  struct {
    vuint32_t MOD:16;
    vuint32_t _unused_16:16;
  } B;
} FTM_MOD_tag;

typedef union FTM_CONTROLS_CSC_union_tag { /* Channel (n) Status And Control */
  vuint32_t R;
  struct {
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t ICRST:1;                 /* FTM counter reset by the selected input capture event. */
    vuint32_t ELSA:1;                  /* Edge or Level Select */
    vuint32_t ELSB:1;                  /* Edge or Level Select */
    vuint32_t MSA:1;                   /* Channel Mode Select */
    vuint32_t MSB:1;                   /* Channel Mode Select */
    vuint32_t CHIE:1;                  /* Channel Interrupt Enable */
    vuint32_t CHF:1;                   /* Channel Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_CONTROLS_CSC_tag;

typedef union FTM_CONTROLS_CV_union_tag { /* Channel (n) Value */
  vuint32_t R;
  struct {
    vuint32_t VAL:16;                  /* Channel Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_CONTROLS_CV_tag;

typedef struct FTM_CONTROLS_struct_tag {
  FTM_CONTROLS_CSC_tag CSC;            /* Channel (n) Status And Control */
  FTM_CONTROLS_CV_tag CV;              /* Channel (n) Value */
} FTM_CONTROLS_tag;

typedef union FTM_CNTIN_union_tag {    /* Counter Initial Value */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_16:16;
  } B;
} FTM_CNTIN_tag;

typedef union FTM_STATUS_union_tag {   /* Capture And Compare Status */
  vuint32_t R;
  struct {
    vuint32_t CH0F:1;                  /* Channel 0 Flag */
    vuint32_t CH1F:1;                  /* Channel 1 Flag */
    vuint32_t CH2F:1;                  /* Channel 2 Flag */
    vuint32_t CH3F:1;                  /* Channel 3 Flag */
    vuint32_t CH4F:1;                  /* Channel 4 Flag */
    vuint32_t CH5F:1;                  /* Channel 5 Flag */
    vuint32_t CH6F:1;                  /* Channel 6 Flag */
    vuint32_t CH7F:1;                  /* Channel 7 Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_STATUS_tag;

typedef union FTM_MODE_union_tag {     /* Features Mode Selection */
  vuint32_t R;
  struct {
    vuint32_t FTMEN:1;                 /* FTM Enable */
    vuint32_t INIT:1;                  /* Initialize The Channels Output */
    vuint32_t WPDIS:1;                 /* Write Protection Disable */
    vuint32_t PWMSYNC:1;               /* PWM Synchronization Mode */
    vuint32_t CAPTEST:1;               /* Capture Test Mode Enable */
    vuint32_t _unused_5:3;
    vuint32_t _unused_8:24;
  } B;
} FTM_MODE_tag;

typedef union FTM_SYNC_union_tag {     /* Synchronization */
  vuint32_t R;
  struct {
    vuint32_t CNTMIN:1;                /* Minimum Loading Point Enable */
    vuint32_t CNTMAX:1;                /* Maximum Loading Point Enable */
    vuint32_t REINIT:1;                /* FTM Counter Reinitialization By Synchronization (FTM counter synchronization) */
    vuint32_t SYNCHOM:1;               /* Output Mask Synchronization */
    vuint32_t TRIG0:1;                 /* PWM Synchronization Hardware Trigger 0 */
    vuint32_t TRIG1:1;                 /* PWM Synchronization Hardware Trigger 1 */
    vuint32_t TRIG2:1;                 /* PWM Synchronization Hardware Trigger 2 */
    vuint32_t SWSYNC:1;                /* PWM Synchronization Software Trigger */
    vuint32_t _unused_8:24;
  } B;
} FTM_SYNC_tag;

typedef union FTM_OUTINIT_union_tag {  /* Initial State For Channels Output */
  vuint32_t R;
  struct {
    vuint32_t CH0OI:1;                 /* Channel 0 Output Initialization Value */
    vuint32_t CH1OI:1;                 /* Channel 1 Output Initialization Value */
    vuint32_t CH2OI:1;                 /* Channel 2 Output Initialization Value */
    vuint32_t CH3OI:1;                 /* Channel 3 Output Initialization Value */
    vuint32_t CH4OI:1;                 /* Channel 4 Output Initialization Value */
    vuint32_t CH5OI:1;                 /* Channel 5 Output Initialization Value */
    vuint32_t CH6OI:1;                 /* Channel 6 Output Initialization Value */
    vuint32_t CH7OI:1;                 /* Channel 7 Output Initialization Value */
    vuint32_t _unused_8:24;
  } B;
} FTM_OUTINIT_tag;

typedef union FTM_OUTMASK_union_tag {  /* Output Mask */
  vuint32_t R;
  struct {
    vuint32_t CH0OM:1;                 /* Channel 0 Output Mask */
    vuint32_t CH1OM:1;                 /* Channel 1 Output Mask */
    vuint32_t CH2OM:1;                 /* Channel 2 Output Mask */
    vuint32_t CH3OM:1;                 /* Channel 3 Output Mask */
    vuint32_t CH4OM:1;                 /* Channel 4 Output Mask */
    vuint32_t CH5OM:1;                 /* Channel 5 Output Mask */
    vuint32_t CH6OM:1;                 /* Channel 6 Output Mask */
    vuint32_t CH7OM:1;                 /* Channel 7 Output Mask */
    vuint32_t _unused_8:24;
  } B;
} FTM_OUTMASK_tag;

typedef union FTM_COMBINE_union_tag {  /* Function For Linked Channels */
  vuint32_t R;
  struct {
    vuint32_t COMBINE0:1;              /* Combine Channels For n = 0 */
    vuint32_t COMP0:1;                 /* Complement Of Channel (n) For n = 0 */
    vuint32_t DECAPEN0:1;              /* Dual Edge Capture Mode Enable For n = 0 */
    vuint32_t DECAP0:1;                /* Dual Edge Capture Mode Captures For n = 0 */
    vuint32_t DTEN0:1;                 /* Deadtime Enable For n = 0 */
    vuint32_t SYNCEN0:1;               /* Synchronization Enable For n = 0 */
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t COMBINE1:1;              /* Combine Channels For n = 2 */
    vuint32_t COMP1:1;                 /* Complement Of Channel (n) For n = 2 */
    vuint32_t DECAPEN1:1;              /* Dual Edge Capture Mode Enable For n = 2 */
    vuint32_t DECAP1:1;                /* Dual Edge Capture Mode Captures For n = 2 */
    vuint32_t DTEN1:1;                 /* Deadtime Enable For n = 2 */
    vuint32_t SYNCEN1:1;               /* Synchronization Enable For n = 2 */
    vuint32_t _unused_14:1;
    vuint32_t _unused_15:1;
    vuint32_t COMBINE2:1;              /* Combine Channels For n = 4 */
    vuint32_t COMP2:1;                 /* Complement Of Channel (n) For n = 4 */
    vuint32_t DECAPEN2:1;              /* Dual Edge Capture Mode Enable For n = 4 */
    vuint32_t DECAP2:1;                /* Dual Edge Capture Mode Captures For n = 4 */
    vuint32_t DTEN2:1;                 /* Deadtime Enable For n = 4 */
    vuint32_t SYNCEN2:1;               /* Synchronization Enable For n = 4 */
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t COMBINE3:1;              /* Combine Channels For n = 6 */
    vuint32_t COMP3:1;                 /* Complement Of Channel (n) for n = 6 */
    vuint32_t DECAPEN3:1;              /* Dual Edge Capture Mode Enable For n = 6 */
    vuint32_t DECAP3:1;                /* Dual Edge Capture Mode Captures For n = 6 */
    vuint32_t DTEN3:1;                 /* Deadtime Enable For n = 6 */
    vuint32_t SYNCEN3:1;               /* Synchronization Enable For n = 6 */
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} FTM_COMBINE_tag;

typedef union FTM_DEADTIME_union_tag { /* Deadtime Insertion Control */
  vuint32_t R;
  struct {
    vuint32_t DTVAL:6;                 /* Deadtime Value */
    vuint32_t DTPS:2;                  /* Deadtime Prescaler Value */
    vuint32_t _unused_8:24;
  } B;
} FTM_DEADTIME_tag;

typedef union FTM_EXTTRIG_union_tag {  /* FTM External Trigger */
  vuint32_t R;
  struct {
    vuint32_t CH2TRIG:1;               /* Channel 2 Trigger Enable */
    vuint32_t CH3TRIG:1;               /* Channel 3 Trigger Enable */
    vuint32_t CH4TRIG:1;               /* Channel 4 Trigger Enable */
    vuint32_t CH5TRIG:1;               /* Channel 5 Trigger Enable */
    vuint32_t CH0TRIG:1;               /* Channel 0 Trigger Enable */
    vuint32_t CH1TRIG:1;               /* Channel 1 Trigger Enable */
    vuint32_t INITTRIGEN:1;            /* Initialization Trigger Enable */
    vuint32_t TRIGF:1;                 /* Channel Trigger Flag */
    vuint32_t _unused_8:24;
  } B;
} FTM_EXTTRIG_tag;

typedef union FTM_POL_union_tag {      /* Channels Polarity */
  vuint32_t R;
  struct {
    vuint32_t POL0:1;                  /* Channel 0 Polarity */
    vuint32_t POL1:1;                  /* Channel 1 Polarity */
    vuint32_t POL2:1;                  /* Channel 2 Polarity */
    vuint32_t POL3:1;                  /* Channel 3 Polarity */
    vuint32_t POL4:1;                  /* Channel 4 Polarity */
    vuint32_t POL5:1;                  /* Channel 5 Polarity */
    vuint32_t POL6:1;                  /* Channel 6 Polarity */
    vuint32_t POL7:1;                  /* Channel 7 Polarity */
    vuint32_t _unused_8:24;
  } B;
} FTM_POL_tag;

typedef union FTM_FMS_union_tag {      /* Fault Mode Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:6;
    vuint32_t WPEN:1;                  /* Write Protection Enable */
    vuint32_t _unused_7:25;
  } B;
} FTM_FMS_tag;

typedef union FTM_FILTER_union_tag {   /* Input Capture Filter Control */
  vuint32_t R;
  struct {
    vuint32_t CH0FVAL:4;               /* Channel 0 Input Filter */
    vuint32_t CH1FVAL:4;               /* Channel 1 Input Filter */
    vuint32_t CH2FVAL:4;               /* Channel 2 Input Filter */
    vuint32_t CH3FVAL:4;               /* Channel 3 Input Filter */
    vuint32_t _unused_16:16;
  } B;
} FTM_FILTER_tag;

typedef union FTM_QDCTRL_union_tag {   /* Quadrature Decoder Control And Status */
  vuint32_t R;
  struct {
    vuint32_t QUADEN:1;                /* Quadrature Decoder Mode Enable */
    vuint32_t TOFDIR:1;                /* Timer Overflow Direction In Quadrature Decoder Mode */
    vuint32_t QUADIR:1;                /* FTM Counter Direction In Quadrature Decoder Mode */
    vuint32_t QUADMODE:1;              /* Quadrature Decoder Mode */
    vuint32_t PHBPOL:1;                /* Phase B Input Polarity */
    vuint32_t PHAPOL:1;                /* Phase A Input Polarity */
    vuint32_t PHBFLTREN:1;             /* Phase B Input Filter Enable */
    vuint32_t PHAFLTREN:1;             /* Phase A Input Filter Enable */
    vuint32_t _unused_8:24;
  } B;
} FTM_QDCTRL_tag;

typedef union FTM_CONF_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t NUMTOF:5;                /* TOF Frequency */
    vuint32_t _unused_5:1;
    vuint32_t BDMMODE:2;               /* BDM Mode */
    vuint32_t _unused_8:1;
    vuint32_t GTBEEN:1;                /* Global Time Base Enable */
    vuint32_t GTBEOUT:1;               /* Global Time Base Output */
    vuint32_t _unused_11:21;
  } B;
} FTM_CONF_tag;

typedef union FTM_SYNCONF_union_tag {  /* Synchronization Configuration */
  vuint32_t R;
  struct {
    vuint32_t HWTRIGMODE:1;            /* Hardware Trigger Mode */
    vuint32_t _unused_1:1;
    vuint32_t CNTINC:1;                /* CNTIN Register Synchronization */
    vuint32_t _unused_3:1;
    vuint32_t INVC:1;                  /* INVCTRL Register Synchronization */
    vuint32_t SWOC:1;                  /* SWOCTRL Register Synchronization */
    vuint32_t _unused_6:1;
    vuint32_t SYNCMODE:1;              /* Synchronization Mode */
    vuint32_t SWRSTCNT:1;
    vuint32_t SWWRBUF:1;
    vuint32_t SWOM:1;
    vuint32_t SWINVC:1;
    vuint32_t SWSOC:1;
    vuint32_t _unused_13:3;
    vuint32_t HWRSTCNT:1;
    vuint32_t HWWRBUF:1;
    vuint32_t HWOM:1;
    vuint32_t HWINVC:1;
    vuint32_t HWSOC:1;
    vuint32_t _unused_21:11;
  } B;
} FTM_SYNCONF_tag;

typedef union FTM_INVCTRL_union_tag {  /* FTM Inverting Control */
  vuint32_t R;
  struct {
    vuint32_t INV0EN:1;                /* Pair Channels 0 Inverting Enable */
    vuint32_t INV1EN:1;                /* Pair Channels 1 Inverting Enable */
    vuint32_t INV2EN:1;                /* Pair Channels 2 Inverting Enable */
    vuint32_t INV3EN:1;                /* Pair Channels 3 Inverting Enable */
    vuint32_t _unused_4:28;
  } B;
} FTM_INVCTRL_tag;

typedef union FTM_SWOCTRL_union_tag {  /* FTM Software Output Control */
  vuint32_t R;
  struct {
    vuint32_t CH0OC:1;                 /* Channel 0 Software Output Control Enable */
    vuint32_t CH1OC:1;                 /* Channel 1 Software Output Control Enable */
    vuint32_t CH2OC:1;                 /* Channel 2 Software Output Control Enable */
    vuint32_t CH3OC:1;                 /* Channel 3 Software Output Control Enable */
    vuint32_t CH4OC:1;                 /* Channel 4 Software Output Control Enable */
    vuint32_t CH5OC:1;                 /* Channel 5 Software Output Control Enable */
    vuint32_t CH6OC:1;                 /* Channel 6 Software Output Control Enable */
    vuint32_t CH7OC:1;                 /* Channel 7 Software Output Control Enable */
    vuint32_t CH0OCV:1;                /* Channel 0 Software Output Control Value */
    vuint32_t CH1OCV:1;                /* Channel 1 Software Output Control Value */
    vuint32_t CH2OCV:1;                /* Channel 2 Software Output Control Value */
    vuint32_t CH3OCV:1;                /* Channel 3 Software Output Control Value */
    vuint32_t CH4OCV:1;                /* Channel 4 Software Output Control Value */
    vuint32_t CH5OCV:1;                /* Channel 5 Software Output Control Value */
    vuint32_t CH6OCV:1;                /* Channel 6 Software Output Control Value */
    vuint32_t CH7OCV:1;                /* Channel 7 Software Output Control Value */
    vuint32_t _unused_16:16;
  } B;
} FTM_SWOCTRL_tag;

typedef union FTM_PWMLOAD_union_tag {  /* FTM PWM Load */
  vuint32_t R;
  struct {
    vuint32_t CH0SEL:1;                /* Channel 0 Select */
    vuint32_t CH1SEL:1;                /* Channel 1 Select */
    vuint32_t CH2SEL:1;                /* Channel 2 Select */
    vuint32_t CH3SEL:1;                /* Channel 3 Select */
    vuint32_t CH4SEL:1;                /* Channel 4 Select */
    vuint32_t CH5SEL:1;                /* Channel 5 Select */
    vuint32_t CH6SEL:1;                /* Channel 6 Select */
    vuint32_t CH7SEL:1;                /* Channel 7 Select */
    vuint32_t _unused_8:1;
    vuint32_t LDOK:1;                  /* Load Enable */
    vuint32_t _unused_10:22;
  } B;
} FTM_PWMLOAD_tag;

struct FTM_tag {
  FTM_SC_tag SC;                       /* Status And Control */
  FTM_CNT_tag CNT;                     /* Counter */
  FTM_MOD_tag MOD;                     /* Modulo */
  FTM_CONTROLS_tag CONTROLS[8];
  FTM_CNTIN_tag CNTIN;                 /* Counter Initial Value */
  FTM_STATUS_tag STATUS;               /* Capture And Compare Status */
  FTM_MODE_tag MODE;                   /* Features Mode Selection */
  FTM_SYNC_tag SYNC;                   /* Synchronization */
  FTM_OUTINIT_tag OUTINIT;             /* Initial State For Channels Output */
  FTM_OUTMASK_tag OUTMASK;             /* Output Mask */
  FTM_COMBINE_tag COMBINE;             /* Function For Linked Channels */
  FTM_DEADTIME_tag DEADTIME;           /* Deadtime Insertion Control */
  FTM_EXTTRIG_tag EXTTRIG;             /* FTM External Trigger */
  FTM_POL_tag POL;                     /* Channels Polarity */
  FTM_FMS_tag FMS;                     /* Fault Mode Status */
  FTM_FILTER_tag FILTER;               /* Input Capture Filter Control */
  uint8_t FTM_reserved0[4];
  FTM_QDCTRL_tag QDCTRL;               /* Quadrature Decoder Control And Status */
  FTM_CONF_tag CONF;                   /* Configuration */
  uint8_t FTM_reserved1[4];
  FTM_SYNCONF_tag SYNCONF;             /* Synchronization Configuration */
  FTM_INVCTRL_tag INVCTRL;             /* FTM Inverting Control */
  FTM_SWOCTRL_tag SWOCTRL;             /* FTM Software Output Control */
  FTM_PWMLOAD_tag PWMLOAD;             /* FTM PWM Load */
};


/* ============================================================================
   =============================== Module: FXOSC ==============================
   ============================================================================ */

typedef union FXOSC_CTL_union_tag {    /* FXOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:3;
    vuint32_t I_OSC:1;
    vuint32_t OSCDIV:5;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t _unused_24:5;
    vuint32_t _unused_29:1;
    vuint32_t OSCM:1;                  /* Crystal Oscillator Mode. */
    vuint32_t OSCBYP:1;
  } B;
} FXOSC_CTL_tag;

struct FXOSC_tag {
  FXOSC_CTL_tag CTL;                   /* FXOSC Control Register */
};


/* ============================================================================
   =============================== Module: GC355 ==============================
   ============================================================================ */

typedef union GC355_HICLKCTL_union_tag { /* Clock control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t CLK2D_DIS:1;             /* Disable 2D clock. */
    vuint32_t FS_VAL:7;                /* Core clock frequency scale value. */
    vuint32_t FS_CMD_L:1;              /* Core clock frequency scale value enable. */
    vuint32_t D_RAM_CLK_G:1;           /* Disables clock gating for RAMs. */
    vuint32_t D_DEBUG:1;               /* Disable debug registers. */
    vuint32_t S_RST:1;                 /* Initiates a soft reset of the IP. */
    vuint32_t D_RAM_PWR_OPT:1;         /* Disables RAM power optimization. */
    vuint32_t _unused_14:2;
    vuint32_t _unused_16:2;
    vuint32_t IDLE_VG:1;               /* VG pipe is idle. */
    vuint32_t _unused_19:13;
  } B;
} GC355_HICLKCTL_tag;

typedef union GC355_HIIDLE_union_tag { /* Idle status register */
  vuint32_t R;
  struct {
    vuint32_t IDLE_FE:1;               /* IDLE_FE */
    vuint32_t _unused_1:1;
    vuint32_t IDLE_PE:1;               /* IDLE_PE */
    vuint32_t _unused_3:5;
    vuint32_t IDLE_VG:1;               /* IDLE_VG */
    vuint32_t IDLE_IM:1;               /* IDLE_IM */
    vuint32_t _unused_10:1;
    vuint32_t IDLE_TS:1;               /* IDLE_TS */
    vuint32_t _unused_12:19;
    vuint32_t AXI_LP:1;                /* 1 = AXI is in low power mode. */
  } B;
} GC355_HIIDLE_tag;

typedef union GC355_AXI_CONFIG_union_tag { /* AXI configuration register */
  vuint32_t R;
  struct {
    vuint32_t AWID:4;                  /* Master Write address ID. */
    vuint32_t ARID:4;                  /* Master Read address ID. */
    vuint32_t AWCACHE:4;               /* Master Cache type. */
    vuint32_t ARCACHE:4;               /* Master Cache type. */
    vuint32_t _unused_16:16;
  } B;
} GC355_AXI_CONFIG_tag;

typedef union GC355_AXISTATUS_union_tag { /* AXI status register */
  vuint32_t R;
  struct {
    vuint32_t WR_ERR_ID:4;             /* Reports the error ID for write error. */
    vuint32_t RD_ERR_ID:4;             /* Reports the error ID for read error. */
    vuint32_t DET_WR_ERR:1;            /* Write error has been detected. */
    vuint32_t DET_RD_ERR:1;            /* Read error has been detected. */
    vuint32_t _unused_10:22;
  } B;
} GC355_AXISTATUS_tag;

typedef union GC355_INT_ACK_union_tag { /* Interrupt acknowledge register */
  vuint32_t R;
  struct {
    vuint32_t INTR_VEC:32;             /* Interrupt Vector with each bit representing a core event */
  } B;
} GC355_INT_ACK_tag;

typedef union GC355_INT_EN_union_tag { /* Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t INT_EN_VEC:32;           /* Each bit enables a corresponding event. */
  } B;
} GC355_INT_EN_tag;

typedef union GC355_CHIPID_union_tag { /* Chip ID register */
  vuint32_t R;
  struct {
    vuint32_t ID:32;                   /* Shows the ID for the chip in BCD. */
  } B;
} GC355_CHIPID_tag;

typedef union GC355_CHIPREV_union_tag { /* Chip revision register */
  vuint32_t R;
  struct {
    vuint32_t REV:32;                  /* Shows the revision for the chip in BCD. */
  } B;
} GC355_CHIPREV_tag;

typedef union GC355_CHIPDATE_union_tag { /* Chip date register */
  vuint32_t R;
  struct {
    vuint32_t DATE:32;                 /* Shows the release date for the IP. */
  } B;
} GC355_CHIPDATE_tag;

typedef union GC355_CHIPTIME_union_tag { /* Chip time register */
  vuint32_t R;
  struct {
    vuint32_t TIME:32;                 /* Shows the release time for the IP. */
  } B;
} GC355_CHIPTIME_tag;

typedef union GC355_T_CYC_union_tag {  /* Total cycles register */
  vuint32_t R;
  struct {
    vuint32_t CYCLES:32;               /* Total Cycles. */
  } B;
} GC355_T_CYC_tag;

typedef union GC355_MOD_PWR_CTL_union_tag { /* Module power control register */
  vuint32_t R;
  struct {
    vuint32_t ENMOD_CLKG:1;            /* Enable Module Clock Gating */
    vuint32_t D_STALMOD_CLKG:1;        /* Disable Stall Module Clock Gating */
    vuint32_t D_STARMOD_CLKG:1;        /* Disable Starve Module Clock Gating */
    vuint32_t _unused_3:1;
    vuint32_t T_ON_CNT:4;              /* Number of clock cycles to wait after turning on the clock. */
    vuint32_t _unused_8:8;
    vuint32_t T_OFF_CNT:16;            /* Counter value for clock gating the module if the module is idle for this amount of clock cycles. */
  } B;
} GC355_MOD_PWR_CTL_tag;

typedef union GC355_MEM_DEBUG_union_tag { /* Memory debug register */
  vuint32_t R;
  struct {
    vuint32_t MAX_OS_RD:8;             /* Maximum Outstanding Reads */
    vuint32_t _unused_8:24;
  } B;
} GC355_MEM_DEBUG_tag;

typedef union GC355_REG_FET_ADD_union_tag { /* Fetch address register */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;              /* Address of the command buffer. */
  } B;
} GC355_REG_FET_ADD_tag;

typedef union GC355_REG_FET_CTL_union_tag { /* Fetch control register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:21;                /* Number of 64-bit words to fetch. 21 bits is enough for 16MB. */
    vuint32_t _unused_21:11;
  } B;
} GC355_REG_FET_CTL_tag;

struct GC355_tag {
  GC355_HICLKCTL_tag HICLKCTL;         /* Clock control register */
  GC355_HIIDLE_tag HIIDLE;             /* Idle status register */
  GC355_AXI_CONFIG_tag AXI_CONFIG;     /* AXI configuration register */
  GC355_AXISTATUS_tag AXISTATUS;       /* AXI status register */
  GC355_INT_ACK_tag INT_ACK;           /* Interrupt acknowledge register */
  GC355_INT_EN_tag INT_EN;             /* Interrupt enable register */
  uint8_t GC355_reserved0[8];
  GC355_CHIPID_tag CHIPID;             /* Chip ID register */
  GC355_CHIPREV_tag CHIPREV;           /* Chip revision register */
  GC355_CHIPDATE_tag CHIPDATE;         /* Chip date register */
  GC355_CHIPTIME_tag CHIPTIME;         /* Chip time register */
  uint8_t GC355_reserved1[72];
  GC355_T_CYC_tag T_CYC;               /* Total cycles register */
  uint8_t GC355_reserved2[132];
  GC355_MOD_PWR_CTL_tag MOD_PWR_CTL;   /* Module power control register */
  uint8_t GC355_reserved3[784];
  GC355_MEM_DEBUG_tag MEM_DEBUG;       /* Memory debug register */
  uint8_t GC355_reserved4[232];
  GC355_REG_FET_ADD_tag REG_FET_ADD;   /* Fetch address register */
  GC355_REG_FET_CTL_tag REG_FET_CTL;   /* Fetch control register */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t RXAK:1;
    vuint8_t IBIF:1;
    vuint8_t SRW:1;
    vuint8_t _unused_3:1;
    vuint8_t IBAL:1;
    vuint8_t IBB:1;
    vuint8_t IAAS:1;
    vuint8_t TCF:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:1;
    vuint8_t DMAEN:1;
    vuint8_t RSTA:1;
    vuint8_t NOACK:1;
    vuint8_t TXRX:1;
    vuint8_t MSSL:1;
    vuint8_t IBIE:1;
    vuint8_t MDIS:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:1;
    vuint8_t ADR:7;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t IPG_DEBUG_EN:1;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t BYTE_RX:1;
    vuint8_t _unused_3:5;
  } B;
} I2C_IBDBG_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_0:6;
    vuint8_t BYTERXIE:1;
    vuint8_t BIIE:1;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

struct I2C_tag {
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  uint8_t I2C_reserved0[1];
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
};


/* ============================================================================
   =============================== Module: IOP ================================
   ============================================================================ */

typedef union IOP_MCTL_union_tag {     /* IOP Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:16;                  /* These bits provide the key to change the target mode. */
    vuint32_t _unused_16:12;
    vuint32_t TARGET_MODE:4;           /* Target Chip Mode */
  } B;
} IOP_MCTL_tag;

typedef union IOP_RUN_CF_union_tag {   /* IOP Run Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during IOP_RUN */
    vuint32_t FXOSC_ON:1;              /* FXOSC control during IOP_RUN */
    vuint32_t SIRC_ON:1;               /* SIRC control during IOP_RUN */
    vuint32_t SXOSC_ON:1;              /* SXOSC control during IOP_RUN */
    vuint32_t _unused_4:2;
    vuint32_t IOP_SLEEP:1;             /* CM0+ core sleep request during IOP RUN */
    vuint32_t SYS_CLK_SEL:1;           /* System clock selection in IOP RUN mode */
    vuint32_t DIRECT_DRUN:1;           /* Transition to DRUN on IOP_STANDBY exit */
    vuint32_t _unused_9:8;
    vuint32_t AUX2_CLK_SEL:1;          /* AUX2 Clock select */
    vuint32_t AUX3_CLK_SEL:1;          /* AUX3 Clock select */
    vuint32_t AUX14_CLK_SEL:1;         /* AUX14 Clock select */
    vuint32_t AUX15_CLK_SEL:1;         /* AUX15 Clock select */
    vuint32_t _unused_21:3;
    vuint32_t RMC:1;                   /* Reset On Mode Change */
    vuint32_t _unused_25:7;
  } B;
} IOP_RUN_CF_tag;

typedef union IOP_STOP_CF_union_tag {  /* IOP Stop Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during IOP_STOP */
    vuint32_t FXOSC_ON:1;              /* FXOSC control during IOP_STOP */
    vuint32_t SIRC_ON:1;               /* SIRC control during IOP_STOP */
    vuint32_t SXOSC_ON:1;              /* SXOSC control during IOP_STOP */
    vuint32_t _unused_4:28;
  } B;
} IOP_STOP_CF_tag;

typedef union IOP_STANDBY_CF_union_tag { /* IOP Standby Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FIRC_ON:1;               /* FIRC oscillator control during IOP_STANDBY */
    vuint32_t FXOSC_ON:1;              /* FXOSC clock source control during IOP_STANDBY */
    vuint32_t SIRC_ON:1;               /* SIRC clock source control during IOP_STANDBY */
    vuint32_t SXOSC_ON:1;              /* SXOSC control during IOP_STANDBY */
    vuint32_t _unused_4:28;
  } B;
} IOP_STANDBY_CF_tag;

typedef union IOP_SR_union_tag {       /* IOP Status Register */
  vuint32_t R;
  struct {
    vuint32_t CURRENT_MODE:4;          /* Current mode of the chip when in IOP Mode */
    vuint32_t _unused_4:1;
    vuint32_t MTRANS:1;                /* IOP mode transition */
    vuint32_t _unused_6:8;
    vuint32_t CLK0_STOP:1;             /* FIRC clock status during IOP mode */
    vuint32_t CLK1_STOP:1;             /* FXOSC clock status during IOP mode */
    vuint32_t FIRC_STAT:1;             /* FIRC clock status */
    vuint32_t FXOSC_STAT:1;            /* FIRC clock status */
    vuint32_t SIRC_STAT:1;             /* SIRC clock status */
    vuint32_t SXOSC_STAT:1;            /* SXOSC clock status */
    vuint32_t _unused_20:1;
    vuint32_t SW_STATUS:1;             /* Status of Switch Between Power Domain 2 and Power Domain 1 */
    vuint32_t AUX_MUX2_CLK0_STOP:1;    /* AUX MUX2 CLK0 status during IOP mode */
    vuint32_t AUX_MUX3_CLK0_STOP:1;    /* AUX MUX2 CLK0 status during IOP mode */
    vuint32_t AUX_MUX14_CLK0_STOP:1;   /* AUX MUX14 CLK0 status during IOP mode */
    vuint32_t AUX_MUX15_CLK0_STOP:1;   /* AUX MUX15 CLK0 status */
    vuint32_t _unused_26:1;
    vuint32_t AUX_MUX2_CLK1_STOP:1;    /* AUX MUX2 CLK1 status */
    vuint32_t AUX_MUX3_CLK1_STOP:1;    /* AUX MUX3 CLK1 status during IOP mode */
    vuint32_t AUX_MUX14_CLK1_STOP:1;   /* AUX MUX14 CLK1 status */
    vuint32_t AUX_MUX15_CLK1_STOP:1;   /* AUX_MUX15 CLK1 clock status */
    vuint32_t _unused_31:1;
  } B;
} IOP_SR_tag;

typedef union IOP_ICR_union_tag {      /* IOP Interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t IOP_NEM:1;               /* IOP non-existing mode interrupt */
    vuint32_t IOP_MRIG:1;              /* IOP mode request ignored */
    vuint32_t _unused_4:12;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t IOP_NEM_E:1;             /* IOP non-existing mode interrupt enable */
    vuint32_t IOP_MRIG_E:1;            /* IOP mode request ignored interrupt enable */
    vuint32_t _unused_20:12;
  } B;
} IOP_ICR_tag;

typedef union IOP_MOD_MDIS_union_tag { /* Module Disable Register */
  vuint32_t R;
  struct {
    vuint32_t LCD:1;                   /* LCD control */
    vuint32_t FTM_0:1;
    vuint32_t CMP_0:1;                 /* CMP_0 control */
    vuint32_t CMP_1:1;                 /* CMP_1 control */
    vuint32_t SPI_2:1;                 /* SPI_2 Control */
    vuint32_t ADC:1;                   /* ADC control */
    vuint32_t PIT:1;                   /* PIT control */
    vuint32_t SIUL:1;                  /* SIUL control */
    vuint32_t _unused_8:1;
    vuint32_t RTC:1;                   /* RTC control */
    vuint32_t _unused_10:22;
  } B;
} IOP_MOD_MDIS_tag;

struct IOP_tag {
  IOP_MCTL_tag MCTL;                   /* IOP Mode Control Register */
  IOP_RUN_CF_tag RUN_CF;               /* IOP Run Configuration Register */
  IOP_STOP_CF_tag STOP_CF;             /* IOP Stop Configuration Register */
  IOP_STANDBY_CF_tag STANDBY_CF;       /* IOP Standby Configuration Register */
  IOP_SR_tag SR;                       /* IOP Status Register */
  IOP_ICR_tag ICR;                     /* IOP Interrupt control register */
  IOP_MOD_MDIS_tag MOD_MDIS;           /* Module Disable Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t JOUT_IEN:1;
    vuint32_t _unused_1:15;
    vuint32_t JIN_IEN:1;
    vuint32_t _unused_17:15;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t JOUT_INT:1;
    vuint32_t _unused_1:1;
    vuint32_t JOUT_RDY:1;
    vuint32_t _unused_3:13;
    vuint32_t JIN_INT:1;
    vuint32_t _unused_17:1;
    vuint32_t JIN_RDY:1;
    vuint32_t _unused_19:13;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: LCD ================================
   ============================================================================ */

typedef union LCD_LCDCR_union_tag {    /* LCD Control Register */
  vuint32_t R;
  struct {
    vuint32_t LCDBPS:3;
    vuint32_t _unused_3:1;
    vuint32_t LCDBPA:2;
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t NOF:8;
    vuint32_t EOFIF:1;
    vuint32_t LCDINT:1;
    vuint32_t LCDOCS:1;
    vuint32_t BSTAO:1;
    vuint32_t BSTSEL:1;
    vuint32_t BSTEN:1;
    vuint32_t PWR:2;
    vuint32_t VLCDS:1;
    vuint32_t BIAS:1;
    vuint32_t DUTY:3;
    vuint32_t LCDRCS:1;
    vuint32_t LCDRST:1;
    vuint32_t LCDEN:1;
  } B;
} LCD_LCDCR_tag;

typedef union LCD_LCDPCR_union_tag {   /* LCD Prescaler Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t LCLK:4;
    vuint32_t _unused_28:4;
  } B;
} LCD_LCDPCR_tag;

typedef union LCD_LCDCCR_union_tag {   /* LCD Contrast Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t LCC:11;
    vuint32_t _unused_27:4;
    vuint32_t CCEN:1;
  } B;
} LCD_LCDCCR_tag;

typedef union LCD_ENFPR0_union_tag {   /* LCD Frontplane Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ENFP:32;
  } B;
} LCD_ENFPR0_tag;

typedef union LCD_ENFPR1_union_tag {   /* LCD Frontplane Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t ENFP:32;
  } B;
} LCD_ENFPR1_tag;

typedef union LCD_LCDRAM0_union_tag {  /* LCDRAM (Location 0) */
  vuint32_t R;
  struct {
    vuint32_t FP3_BP:8;
    vuint32_t FP2_BP:8;
    vuint32_t FP1_BP:8;
    vuint32_t FP0_BP:8;
  } B;
} LCD_LCDRAM0_tag;

typedef union LCD_LCDRAM1_union_tag {  /* LCDRAM Location 1 */
  vuint32_t R;
  struct {
    vuint32_t FP7_BP:8;
    vuint32_t FP6_BP:8;
    vuint32_t FP5_BP:8;
    vuint32_t FP4_BP:8;
  } B;
} LCD_LCDRAM1_tag;

typedef union LCD_LCDRAM2_union_tag {  /* LCDRAM Location 2 */
  vuint32_t R;
  struct {
    vuint32_t FP11_BP:8;
    vuint32_t FP10_BP:8;
    vuint32_t FP9_BP:8;
    vuint32_t FP8_BP:8;
  } B;
} LCD_LCDRAM2_tag;

typedef union LCD_LCDRAM3_union_tag {  /* LCDRAM Location 3 */
  vuint32_t R;
  struct {
    vuint32_t FP15_BP:8;
    vuint32_t FP14_BP:8;
    vuint32_t FP13_BP:8;
    vuint32_t FP12_BP:8;
  } B;
} LCD_LCDRAM3_tag;

typedef union LCD_LCDRAM4_union_tag {  /* LCDRAM Location 4 */
  vuint32_t R;
  struct {
    vuint32_t FP19_BP:8;
    vuint32_t FP18_BP:8;
    vuint32_t FP17_BP:8;
    vuint32_t FP16_BP:8;
  } B;
} LCD_LCDRAM4_tag;

typedef union LCD_LCDRAM5_union_tag {  /* LCDRAM Location 5 */
  vuint32_t R;
  struct {
    vuint32_t FP23_BP:8;
    vuint32_t FP22_BP:8;
    vuint32_t FP21_BP:8;
    vuint32_t FP20_BP:8;
  } B;
} LCD_LCDRAM5_tag;

typedef union LCD_LCDRAM6_union_tag {  /* LCDRAM Location 6 */
  vuint32_t R;
  struct {
    vuint32_t FP27_BP:8;
    vuint32_t FP26_BP:8;
    vuint32_t FP25_BP:8;
    vuint32_t FP24_BP:8;
  } B;
} LCD_LCDRAM6_tag;

typedef union LCD_LCDRAM7_union_tag {  /* LCDRAM Location 7 */
  vuint32_t R;
  struct {
    vuint32_t FP31_BP:8;
    vuint32_t FP30_BP:8;
    vuint32_t FP29_BP:8;
    vuint32_t FP28_BP:8;
  } B;
} LCD_LCDRAM7_tag;

typedef union LCD_LCDRAM8_union_tag {  /* LCDRAM Location 8 */
  vuint32_t R;
  struct {
    vuint32_t FP35_BP:8;
    vuint32_t FP34_BP:8;
    vuint32_t FP33_BP:8;
    vuint32_t FP32_BP:8;
  } B;
} LCD_LCDRAM8_tag;

typedef union LCD_LCDRAM9_union_tag {  /* LCDRAM Location 9 */
  vuint32_t R;
  struct {
    vuint32_t FP39_BP:8;
    vuint32_t FP38_BP:8;
    vuint32_t FP37_BP:8;
    vuint32_t FP36_BP:8;
  } B;
} LCD_LCDRAM9_tag;

struct LCD_tag {
  LCD_LCDCR_tag LCDCR;                 /* LCD Control Register */
  LCD_LCDPCR_tag LCDPCR;               /* LCD Prescaler Control Register */
  LCD_LCDCCR_tag LCDCCR;               /* LCD Contrast Control Register */
  uint8_t LCD_reserved0[4];
  LCD_ENFPR0_tag ENFPR0;               /* LCD Frontplane Enable Register 0 */
  LCD_ENFPR1_tag ENFPR1;               /* LCD Frontplane Enable Register 1 */
  uint8_t LCD_reserved1[8];
  LCD_LCDRAM0_tag LCDRAM0;             /* LCDRAM (Location 0) */
  LCD_LCDRAM1_tag LCDRAM1;             /* LCDRAM Location 1 */
  LCD_LCDRAM2_tag LCDRAM2;             /* LCDRAM Location 2 */
  LCD_LCDRAM3_tag LCDRAM3;             /* LCDRAM Location 3 */
  LCD_LCDRAM4_tag LCDRAM4;             /* LCDRAM Location 4 */
  LCD_LCDRAM5_tag LCDRAM5;             /* LCDRAM Location 5 */
  LCD_LCDRAM6_tag LCDRAM6;             /* LCDRAM Location 6 */
  LCD_LCDRAM7_tag LCDRAM7;             /* LCDRAM Location 7 */
  LCD_LCDRAM8_tag LCDRAM8;             /* LCDRAM Location 8 */
  LCD_LCDRAM9_tag LCDRAM9;             /* LCDRAM Location 9 */
};


/* ============================================================================
   =============================== Module: LDB ================================
   ============================================================================ */

typedef union LDB_CTRL_union_tag {     /* LDB Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH0MOD:2;
    vuint32_t _unused_2:2;
    vuint32_t _unused_4:1;
    vuint32_t DWCH0:1;
    vuint32_t BITMAPCH0:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t DI0VSYNPOL:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:4;
    vuint32_t _unused_15:1;
    vuint32_t LVDSCHKS:3;
    vuint32_t _unused_19:1;
    vuint32_t CNTRSTV:2;
    vuint32_t _unused_22:10;
  } B;
} LDB_CTRL_tag;

struct LDB_tag {
  LDB_CTRL_tag CTRL;                   /* LDB Control Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:1;
    vuint32_t SLEEP:1;
    vuint32_t RBLM:1;
    vuint32_t SSBL:1;
    vuint32_t MME:1;
    vuint32_t LBKM:1;
    vuint32_t _unused_6:1;
    vuint32_t BF:1;
    vuint32_t MBL:4;
    vuint32_t AUTOWU:1;
    vuint32_t LASE:1;
    vuint32_t CFD:1;
    vuint32_t CCD:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t HRIE:1;
    vuint32_t DTIE:1;
    vuint32_t DRIE:1;
    vuint32_t TOIE:1;
    vuint32_t _unused_4:1;
    vuint32_t WUIE:1;
    vuint32_t LSIE:1;
    vuint32_t BOIE:1;
    vuint32_t FEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t HEIE:1;
    vuint32_t CEIE:1;
    vuint32_t BEIE:1;
    vuint32_t OCIE:1;
    vuint32_t SZIE:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRF:1;
    vuint32_t DTF:1;
    vuint32_t DRF:1;
    vuint32_t _unused_3:2;
    vuint32_t WUF:1;
    vuint32_t RDI:1;
    vuint32_t RXbusy:1;
    vuint32_t DRBNE:1;
    vuint32_t RMB:1;
    vuint32_t _unused_10:2;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t RDC:3;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t _unused_20:12;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t NF:1;
    vuint32_t _unused_1:6;
    vuint32_t BOF:1;
    vuint32_t FEF:1;
    vuint32_t IDPEF:1;
    vuint32_t SDEF:1;
    vuint32_t SFEF:1;
    vuint32_t CEF:1;
    vuint32_t BEF:1;
    vuint32_t OCF:1;
    vuint32_t SZF:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t UART:1;
    vuint32_t WL0:1;
    vuint32_t PCE:1;
    vuint32_t PC0:1;
    vuint32_t TxEn:1;
    vuint32_t RxEn:1;
    vuint32_t PC1:1;
    vuint32_t WL1:1;
    vuint32_t TFBM:1;
    vuint32_t RFBM:1;
    vuint32_t RDFL_RFC:3;
    vuint32_t TDFL_TFC:3;
    vuint32_t WLS:1;
    vuint32_t SBUR:2;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t NEF:3;
    vuint32_t ROSE:1;
    vuint32_t OSR:4;
    vuint32_t CSP:3;
    vuint32_t MIS:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t NF:1;
    vuint32_t DTFTFF:1;
    vuint32_t DRFRFE:1;
    vuint32_t TO:1;
    vuint32_t RFNE:1;
    vuint32_t WUF:1;
    vuint32_t RDI:1;
    vuint32_t BOF:1;
    vuint32_t FEF:1;
    vuint32_t RMB:1;
    vuint32_t PE:4;
    vuint32_t OCF:1;
    vuint32_t SZF:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:8;
    vuint32_t TOCE:1;
    vuint32_t IOT:1;
    vuint32_t MODE:1;
    vuint32_t _unused_11:21;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t OC1:8;
    vuint32_t OC2:8;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t HTO:7;
    vuint32_t _unused_7:1;
    vuint32_t RTO:4;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t FBR:4;
    vuint32_t _unused_4:28;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t IBR:20;
    vuint32_t _unused_20:12;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t CF:8;
    vuint32_t _unused_8:24;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t HTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t DDRQ:1;
    vuint32_t WURQ:1;
    vuint32_t IOPE:1;
    vuint32_t IOBE:1;
    vuint32_t TBDE:1;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t ID:6;
    vuint32_t _unused_6:2;
    vuint32_t CCS:1;
    vuint32_t DIR:1;
    vuint32_t DFL:3;
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA0:8;
    vuint32_t DATA1:8;
    vuint32_t DATA2:8;
    vuint32_t DATA3:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA4:8;
    vuint32_t DATA5:8;
    vuint32_t DATA6:8;
    vuint32_t DATA7:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FACT:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t IFMI:5;
    vuint32_t _unused_5:27;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t IFM:8;
    vuint32_t _unused_8:24;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t ID:6;                    /* Identifier */
    vuint32_t _unused_6:2;
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t DFL:3;                   /* Data Field Length */
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t SR:1;
    vuint32_t STOP:1;
    vuint32_t RDLIS:1;
    vuint32_t TDLIS:1;
    vuint32_t RDFBM:1;
    vuint32_t TDFBM:1;
    vuint32_t _unused_6:26;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t PTO:12;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t CTO:12;
    vuint32_t _unused_12:20;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t DTE:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t DRE:16;
    vuint32_t _unused_16:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: LMEM ===============================
   ============================================================================ */

typedef union LMEM_PCCCR_union_tag {   /* Cache control register */
  vuint32_t R;
  struct {
    vuint32_t ENCACHE:1;               /* Cache enable */
    vuint32_t ENWRBUF:1;               /* Enable Write Buffer */
    vuint32_t PCCR2:1;                 /* Forces all cacheable spaces to write through */
    vuint32_t PCCR3:1;                 /* Forces no allocation on cache misses (must also have PCCR2 asserted) */
    vuint32_t _unused_4:20;
    vuint32_t INVW0:1;                 /* Invalidate Way 0 */
    vuint32_t PUSHW0:1;                /* Push Way 0 */
    vuint32_t INVW1:1;                 /* Invalidate Way 1 */
    vuint32_t PUSHW1:1;                /* Push Way 1 */
    vuint32_t _unused_28:3;
    vuint32_t GO:1;                    /* Initiate Cache Command */
  } B;
} LMEM_PCCCR_tag;

typedef union LMEM_PCCLCR_union_tag {  /* Cache line control register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t CACHEADDR:11;            /* Cache address */
    vuint32_t _unused_13:1;
    vuint32_t WSEL:1;                  /* Way select */
    vuint32_t _unused_15:1;
    vuint32_t TDSEL:1;                 /* Tag/Data Select */
    vuint32_t _unused_17:3;
    vuint32_t LCIVB:1;                 /* Line Command Initial Valid Bit */
    vuint32_t LCIMB:1;                 /* Line Command Initial Modified Bit */
    vuint32_t LCWAY:1;                 /* Line Command Way */
    vuint32_t _unused_23:1;
    vuint32_t LCMD:2;                  /* Line Command */
    vuint32_t LADSEL:1;                /* Line Address Select */
    vuint32_t LACC:1;                  /* Line access type */
    vuint32_t _unused_28:4;
  } B;
} LMEM_PCCLCR_tag;

typedef union LMEM_PCCSAR_union_tag {  /* Cache search address register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t PHYADDR:30;              /* Physical Address */
  } B;
} LMEM_PCCSAR_tag;

typedef union LMEM_PCCCVR_union_tag {  /* Cache read/write value register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Cache read/write Data */
  } B;
} LMEM_PCCCVR_tag;

typedef union LMEM_PSCCR_union_tag {   /* Cache control register */
  vuint32_t R;
  struct {
    vuint32_t ENCACHE:1;               /* Cache enable */
    vuint32_t ENWRBUF:1;               /* Enable Write Buffer */
    vuint32_t PCCR2:1;
    vuint32_t PCCR3:1;
    vuint32_t _unused_4:20;
    vuint32_t INVW0:1;                 /* Invalidate Way 0 */
    vuint32_t PUSHW0:1;                /* Push Way 0 */
    vuint32_t INVW1:1;                 /* Invalidate Way 1 */
    vuint32_t PUSHW1:1;                /* Push Way 1 */
    vuint32_t _unused_28:3;
    vuint32_t GO:1;                    /* Initiate Cache Command */
  } B;
} LMEM_PSCCR_tag;

typedef union LMEM_PSCLCR_union_tag {  /* Cache line control register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t CACHEADDR:11;            /* Cache address */
    vuint32_t _unused_13:1;
    vuint32_t WSEL:1;                  /* Way select */
    vuint32_t _unused_15:1;
    vuint32_t TDSEL:1;                 /* Tag/Data Select */
    vuint32_t _unused_17:3;
    vuint32_t LCIVB:1;                 /* Line Command Initial Valid Bit */
    vuint32_t LCIMB:1;                 /* Line Command Initial Modified Bit */
    vuint32_t LCWAY:1;                 /* Line Command Way */
    vuint32_t _unused_23:1;
    vuint32_t LCMD:2;                  /* Line Command */
    vuint32_t LADSEL:1;                /* Line Address Select */
    vuint32_t LACC:1;                  /* Line access type */
    vuint32_t _unused_28:4;
  } B;
} LMEM_PSCLCR_tag;

typedef union LMEM_PSCSAR_union_tag {  /* Cache search address register */
  vuint32_t R;
  struct {
    vuint32_t LGO:1;                   /* Initiate Cache Line Command */
    vuint32_t _unused_1:1;
    vuint32_t PHYADDR:30;              /* Physical Address */
  } B;
} LMEM_PSCSAR_tag;

typedef union LMEM_PSCCVR_union_tag {  /* Cache read/write value register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Cache read/write Data */
  } B;
} LMEM_PSCCVR_tag;

struct LMEM_tag {
  LMEM_PCCCR_tag PCCCR;                /* Cache control register */
  LMEM_PCCLCR_tag PCCLCR;              /* Cache line control register */
  LMEM_PCCSAR_tag PCCSAR;              /* Cache search address register */
  LMEM_PCCCVR_tag PCCCVR;              /* Cache read/write value register */
  uint8_t LMEM_reserved0[2032];
  LMEM_PSCCR_tag PSCCR;                /* Cache control register */
  LMEM_PSCLCR_tag PSCLCR;              /* Cache line control register */
  LMEM_PSCSAR_tag PSCSAR;              /* Cache search address register */
  LMEM_PSCCVR_tag PSCCVR;              /* Cache read/write value register */
};


/* ============================================================================
   =============================== Module: MCM ================================
   ============================================================================ */

typedef union MCM_PLAMC_union_tag {    /* Crossbar Switch (AXBS) Master Configuration */
  vuint16_t R;
  struct {
    vuint16_t AMC:6;                   /* Each bit in the AMC field indicates whether there is a corresponding connection to the AXBS master input port. */
    vuint16_t _unused_6:10;
  } B;
} MCM_PLAMC_tag;

typedef union MCM_PLASC_union_tag {    /* Crossbar Switch (AXBS) Slave Configuration */
  vuint16_t R;
  struct {
    vuint16_t ASC:8;                   /* Each bit in the ASC field indicates whether there is a corresponding connection to the crossbar switch's slave input port. */
    vuint16_t _unused_8:8;
  } B;
} MCM_PLASC_tag;

typedef union MCM_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:9;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:14;
    vuint32_t TCMUAP:2;                /* TCMU arbitration priority */
    vuint32_t TCMUWP:1;                /* TCMU write protect */
    vuint32_t _unused_27:1;
    vuint32_t TCMLAP:2;                /* TCML arbitration priority */
    vuint32_t TCMLWP:1;                /* TCML Write Protect */
    vuint32_t _unused_31:1;
  } B;
} MCM_CR_tag;

typedef union MCM_ISCR_union_tag {     /* Interrupt Status and Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t DHREQ:1;                 /* Debug Halt Request Indicator */
    vuint32_t CWBER:1;                 /* Cache write buffer error status */
    vuint32_t _unused_5:3;
    vuint32_t FIOC:1;                  /* FPU invalid operation interrupt status */
    vuint32_t FDZC:1;                  /* FPU divide-by-zero interrupt status */
    vuint32_t FOFC:1;                  /* FPU overflow interrupt status */
    vuint32_t FUFC:1;                  /* FPU underflow interrupt status */
    vuint32_t FIXC:1;                  /* FPU inexact interrupt status */
    vuint32_t _unused_13:2;
    vuint32_t FIDC:1;                  /* FPU input denormal interrupt status */
    vuint32_t _unused_16:4;
    vuint32_t CWBEE:1;                 /* Cache write buffer error enable */
    vuint32_t _unused_21:3;
    vuint32_t FIOCE:1;                 /* FPU invalid operation interrupt enable */
    vuint32_t FDZCE:1;                 /* FPU divide-by-zero interrupt enable */
    vuint32_t FOFCE:1;                 /* FPU overflow interrupt enable */
    vuint32_t FUFCE:1;                 /* FPU underflow interrupt enable */
    vuint32_t FIXCE:1;                 /* FPU inexact interrupt enable */
    vuint32_t _unused_29:2;
    vuint32_t FIDCE:1;                 /* FPU input denormal interrupt enable */
  } B;
} MCM_ISCR_tag;

typedef union MCM_FADR_union_tag {     /* Fault address register */
  vuint32_t R;
  struct {
    vuint32_t ADDRESS:32;              /* Fault address */
  } B;
} MCM_FADR_tag;

typedef union MCM_FATR_union_tag {     /* Fault attributes register */
  vuint32_t R;
  struct {
    vuint32_t BEDA:1;                  /* Bus error access type */
    vuint32_t BEMD:1;                  /* Bus error privilege level */
    vuint32_t _unused_2:2;
    vuint32_t BESZ:2;                  /* Bus error size */
    vuint32_t _unused_6:1;
    vuint32_t BEWT:1;                  /* Bus error write */
    vuint32_t BEMN:4;                  /* Bus error master number */
    vuint32_t _unused_12:19;
    vuint32_t BEOVR:1;                 /* Bus error overrun */
  } B;
} MCM_FATR_tag;

typedef union MCM_FDR_union_tag {      /* Fault data register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Fault data */
  } B;
} MCM_FDR_tag;

struct MCM_tag {
  uint8_t MCM_reserved0[8];
  MCM_PLAMC_tag PLAMC;                 /* Crossbar Switch (AXBS) Master Configuration */
  MCM_PLASC_tag PLASC;                 /* Crossbar Switch (AXBS) Slave Configuration */
  MCM_CR_tag CR;                       /* Control Register */
  MCM_ISCR_tag ISCR;                   /* Interrupt Status and Control Register */
  uint8_t MCM_reserved1[12];
  MCM_FADR_tag FADR;                   /* Fault address register */
  MCM_FATR_tag FATR;                   /* Fault attributes register */
  MCM_FDR_tag FDR;                     /* Fault data register */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_SC_DC6_union_tag { /* System Clock Divider 6 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC6_tag;

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC4_union_tag { /* PCS Divider Change Register 4 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_PCS_DIVC4_tag;

typedef union MC_CGM_PCS_DIVE4_union_tag { /* PCS Divider End Register 4 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVE4_tag;

typedef union MC_CGM_PCS_DIVS4_union_tag { /* PCS Divider Start Register 4 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVS4_tag;

typedef union MC_CGM_PCS_DIVC5_union_tag { /* PCS Divider Change Register 5 */
  vuint32_t R;
  struct {
    vuint32_t RATE:8;
    vuint32_t _unused_8:8;
    vuint32_t INIT:16;
  } B;
} MC_CGM_PCS_DIVC5_tag;

typedef union MC_CGM_PCS_DIVE5_union_tag { /* PCS Divider End Register 5 */
  vuint32_t R;
  struct {
    vuint32_t DIVE:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVE5_tag;

typedef union MC_CGM_PCS_DIVS5_union_tag { /* PCS Divider Start Register 5 */
  vuint32_t R;
  struct {
    vuint32_t DIVS:20;
    vuint32_t _unused_20:12;
  } B;
} MC_CGM_PCS_DIVS5_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_DIV_RATIO_CHNG:1;
    vuint32_t _unused_1:31;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t AUXn_UPD_TYPE:15;
    vuint32_t _unused_16:15;
    vuint32_t SYS_UPD_TYPE:1;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t AUXn_UPD_STAT:15;
    vuint32_t _unused_16:15;
    vuint32_t SYS_UPD_STAT:1;
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SWIP:1;
    vuint32_t SWTRG:3;
    vuint32_t _unused_20:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:2;
    vuint32_t _unused_18:13;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:3;
    vuint32_t _unused_19:12;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_SC_DC3_union_tag { /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC3_tag;

typedef union MC_CGM_SC_DC4_union_tag { /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:5;
    vuint32_t _unused_21:10;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC4_tag;

typedef union MC_CGM_SC_DC5_union_tag { /* System Clock Divider 5 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_SC_DC5_tag;

typedef union MC_CGM_AC0_SC_union_tag { /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:1;
    vuint32_t _unused_25:7;
  } B;
} MC_CGM_AC0_SC_tag;

typedef union MC_CGM_AC0_SS_union_tag { /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_25:7;
  } B;
} MC_CGM_AC0_SS_tag;

typedef union MC_CGM_AC1_SC_union_tag { /* Auxiliary Clock 1 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC1_SC_tag;

typedef union MC_CGM_AC1_SS_union_tag { /* Auxiliary Clock 1 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC1_SS_tag;

typedef union MC_CGM_AC1_DC0_union_tag { /* Auxiliary Clock 1 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:5;
    vuint32_t _unused_21:10;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC1_DC0_tag;

typedef union MC_CGM_AC2_SC_union_tag { /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC2_SC_tag;

typedef union MC_CGM_AC2_SS_union_tag { /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC2_SS_tag;

typedef union MC_CGM_AC2_DC0_union_tag { /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC2_DC0_tag;

typedef union MC_CGM_AC2_DC1_union_tag { /* Auxiliary Clock 2 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC2_DC1_tag;

typedef union MC_CGM_AC3_SC_union_tag { /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC3_SC_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC3_DC0_union_tag { /* Auxiliary Clock 3 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC3_DC0_tag;

typedef union MC_CGM_AC4_SC_union_tag { /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC4_SC_tag;

typedef union MC_CGM_AC4_SS_union_tag { /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC4_SS_tag;

typedef union MC_CGM_AC4_DC0_union_tag { /* Auxiliary Clock 4 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC4_DC0_tag;

typedef union MC_CGM_AC5_SC_union_tag { /* Auxiliary Clock 5 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC5_SC_tag;

typedef union MC_CGM_AC5_SS_union_tag { /* Auxiliary Clock 5 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC5_SS_tag;

typedef union MC_CGM_AC5_DC0_union_tag { /* Auxiliary Clock 5 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:5;
    vuint32_t _unused_21:10;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC5_DC0_tag;

typedef union MC_CGM_AC5_DC1_union_tag { /* Auxiliary Clock 5 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC5_DC1_tag;

typedef union MC_CGM_AC6_SC_union_tag { /* Auxiliary Clock 6 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC6_SC_tag;

typedef union MC_CGM_AC6_SS_union_tag { /* Auxiliary Clock 6 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC6_SS_tag;

typedef union MC_CGM_AC6_DC0_union_tag { /* Auxiliary Clock 6 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC6_DC0_tag;

typedef union MC_CGM_AC6_DC1_union_tag { /* Auxiliary Clock 6 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC6_DC1_tag;

typedef union MC_CGM_AC7_SC_union_tag { /* Auxiliary Clock 7 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC7_SC_tag;

typedef union MC_CGM_AC7_SS_union_tag { /* Auxiliary Clock 7 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC7_SS_tag;

typedef union MC_CGM_AC7_DC0_union_tag { /* Auxiliary Clock 7 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC7_DC0_tag;

typedef union MC_CGM_AC7_DC1_union_tag { /* Auxiliary Clock 7 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC7_DC1_tag;

typedef union MC_CGM_AC8_SC_union_tag { /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC8_SC_tag;

typedef union MC_CGM_AC8_SS_union_tag { /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC8_SS_tag;

typedef union MC_CGM_AC8_DC0_union_tag { /* Auxiliary Clock 8 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC8_DC0_tag;

typedef union MC_CGM_AC9_SC_union_tag { /* Auxiliary Clock 9 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC9_SC_tag;

typedef union MC_CGM_AC9_SS_union_tag { /* Auxiliary Clock 9 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC9_SS_tag;

typedef union MC_CGM_AC9_DC0_union_tag { /* Auxiliary Clock 9 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC9_DC0_tag;

typedef union MC_CGM_AC10_SC_union_tag { /* Auxiliary Clock 10 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC10_SC_tag;

typedef union MC_CGM_AC10_SS_union_tag { /* Auxiliary Clock 10 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC10_SS_tag;

typedef union MC_CGM_AC10_DC0_union_tag { /* Auxiliary Clock 10 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC10_DC0_tag;

typedef union MC_CGM_AC11_SC_union_tag { /* Auxiliary Clock 11 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC11_SC_tag;

typedef union MC_CGM_AC11_SS_union_tag { /* Auxiliary Clock 11 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC11_SS_tag;

typedef union MC_CGM_AC11_DC0_union_tag { /* Auxiliary Clock 11 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC11_DC0_tag;

typedef union MC_CGM_AC12_SC_union_tag { /* Auxiliary Clock 12 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:23;
    vuint32_t SELCTL:4;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC12_SC_tag;

typedef union MC_CGM_AC12_SS_union_tag { /* Auxiliary Clock 12 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:23;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC12_SS_tag;

typedef union MC_CGM_AC12_DC0_union_tag { /* Auxiliary Clock 12 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC12_DC0_tag;

typedef union MC_CGM_AC13_SC_union_tag { /* Auxiliary Clock 13 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_AC13_SC_tag;

typedef union MC_CGM_AC13_SS_union_tag { /* Auxiliary Clock 13 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_28:4;
  } B;
} MC_CGM_AC13_SS_tag;

typedef union MC_CGM_AC13_DC0_union_tag { /* Auxiliary Clock 13 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC13_DC0_tag;

typedef union MC_CGM_AC14_SC_union_tag { /* Auxiliary Clock 14 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC14_SC_tag;

typedef union MC_CGM_AC14_SS_union_tag { /* Auxiliary Clock 14 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC14_SS_tag;

typedef union MC_CGM_AC14_DC0_union_tag { /* Auxiliary Clock 14 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:4;
    vuint32_t _unused_20:11;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC14_DC0_tag;

typedef union MC_CGM_AC15_SC_union_tag { /* Auxiliary Clock 15 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELCTL:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC15_SC_tag;

typedef union MC_CGM_AC15_SS_union_tag { /* Auxiliary Clock 14 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_27:5;
  } B;
} MC_CGM_AC15_SS_tag;

typedef union MC_CGM_AC15_DC_DC0_union_tag { /* Auxiliary Clock 15 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:5;
    vuint32_t _unused_21:10;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC15_DC_DC0_tag;

typedef union MC_CGM_AC15_DC_DC1_union_tag { /* Auxiliary Clock 15 Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DIV:6;
    vuint32_t _unused_22:9;
    vuint32_t DE:1;
  } B;
} MC_CGM_AC15_DC_DC1_tag;

typedef union MC_CGM_AC15_DC_union_tag {
  MC_CGM_AC15_DC_DC0_tag DC0;          /* Auxiliary Clock 15 Divider 0 Configuration Register */
  MC_CGM_AC15_DC_DC1_tag DC1;          /* Auxiliary Clock 15 Divider 1 Configuration Register */
} MC_CGM_AC15_DC_tag;

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1024];
  MC_CGM_SC_DC6_tag SC_DC6;            /* System Clock Divider 6 Configuration Register */
  uint8_t MC_CGM_reserved1[767];
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration Register */
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change Register 1 */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End Register 1 */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start Register 1 */
  uint8_t MC_CGM_reserved2[24];
  MC_CGM_PCS_DIVC4_tag PCS_DIVC4;      /* PCS Divider Change Register 4 */
  MC_CGM_PCS_DIVE4_tag PCS_DIVE4;      /* PCS Divider End Register 4 */
  MC_CGM_PCS_DIVS4_tag PCS_DIVS4;      /* PCS Divider Start Register 4 */
  MC_CGM_PCS_DIVC5_tag PCS_DIVC5;      /* PCS Divider Change Register 5 */
  MC_CGM_PCS_DIVE5_tag PCS_DIVE5;      /* PCS Divider End Register 5 */
  MC_CGM_PCS_DIVS5_tag PCS_DIVS5;      /* PCS Divider Start Register 5 */
  uint8_t MC_CGM_reserved3[144];
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status */
  uint8_t MC_CGM_reserved4[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status Register */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider 0 Configuration Register */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider 1 Configuration Register */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider 2 Configuration Register */
  MC_CGM_SC_DC3_tag SC_DC3;            /* System Clock Divider 3 Configuration Register */
  MC_CGM_SC_DC4_tag SC_DC4;            /* System Clock Divider 4 Configuration Register */
  MC_CGM_SC_DC5_tag SC_DC5;            /* System Clock Divider 5 Configuration Register */
  MC_CGM_AC0_SC_tag AC0_SC;            /* Auxiliary Clock 0 Select Control Register */
  MC_CGM_AC0_SS_tag AC0_SS;            /* Auxiliary Clock 0 Select Status Register */
  uint8_t MC_CGM_reserved5[24];
  MC_CGM_AC1_SC_tag AC1_SC;            /* Auxiliary Clock 1 Select Control Register */
  MC_CGM_AC1_SS_tag AC1_SS;            /* Auxiliary Clock 1 Select Status Register */
  MC_CGM_AC1_DC0_tag AC1_DC0;          /* Auxiliary Clock 1 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved6[20];
  MC_CGM_AC2_SC_tag AC2_SC;            /* Auxiliary Clock 2 Select Control Register */
  MC_CGM_AC2_SS_tag AC2_SS;            /* Auxiliary Clock 2 Select Status Register */
  MC_CGM_AC2_DC0_tag AC2_DC0;          /* Auxiliary Clock 2 Divider 0 Configuration Register */
  MC_CGM_AC2_DC1_tag AC2_DC1;          /* Auxiliary Clock 2 Divider 1 Configuration Register */
  uint8_t MC_CGM_reserved7[16];
  MC_CGM_AC3_SC_tag AC3_SC;            /* Auxiliary Clock 3 Select Control Register */
  MC_CGM_AC3_SS_tag AC3_SS;            /* Auxiliary Clock 3 Select Status Register */
  MC_CGM_AC3_DC0_tag AC3_DC0;          /* Auxiliary Clock 3 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved8[20];
  MC_CGM_AC4_SC_tag AC4_SC;            /* Auxiliary Clock 4 Select Control Register */
  MC_CGM_AC4_SS_tag AC4_SS;            /* Auxiliary Clock 4 Select Status Register */
  MC_CGM_AC4_DC0_tag AC4_DC0;          /* Auxiliary Clock 4 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved9[20];
  MC_CGM_AC5_SC_tag AC5_SC;            /* Auxiliary Clock 5 Select Control Register */
  MC_CGM_AC5_SS_tag AC5_SS;            /* Auxiliary Clock 5 Select Status Register */
  MC_CGM_AC5_DC0_tag AC5_DC0;          /* Auxiliary Clock 5 Divider 0 Configuration Register */
  MC_CGM_AC5_DC1_tag AC5_DC1;          /* Auxiliary Clock 5 Divider 1 Configuration Register */
  uint8_t MC_CGM_reserved10[16];
  MC_CGM_AC6_SC_tag AC6_SC;            /* Auxiliary Clock 6 Select Control Register */
  MC_CGM_AC6_SS_tag AC6_SS;            /* Auxiliary Clock 6 Select Status Register */
  MC_CGM_AC6_DC0_tag AC6_DC0;          /* Auxiliary Clock 6 Divider 0 Configuration Register */
  MC_CGM_AC6_DC1_tag AC6_DC1;          /* Auxiliary Clock 6 Divider 1 Configuration Register */
  uint8_t MC_CGM_reserved11[16];
  MC_CGM_AC7_SC_tag AC7_SC;            /* Auxiliary Clock 7 Select Control Register */
  MC_CGM_AC7_SS_tag AC7_SS;            /* Auxiliary Clock 7 Select Status Register */
  MC_CGM_AC7_DC0_tag AC7_DC0;          /* Auxiliary Clock 7 Divider 0 Configuration Register */
  MC_CGM_AC7_DC1_tag AC7_DC1;          /* Auxiliary Clock 7 Divider 1 Configuration Register */
  uint8_t MC_CGM_reserved12[16];
  MC_CGM_AC8_SC_tag AC8_SC;            /* Auxiliary Clock 8 Select Control Register */
  MC_CGM_AC8_SS_tag AC8_SS;            /* Auxiliary Clock 8 Select Status Register */
  MC_CGM_AC8_DC0_tag AC8_DC0;          /* Auxiliary Clock 8 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved13[20];
  MC_CGM_AC9_SC_tag AC9_SC;            /* Auxiliary Clock 9 Select Control Register */
  MC_CGM_AC9_SS_tag AC9_SS;            /* Auxiliary Clock 9 Select Status Register */
  MC_CGM_AC9_DC0_tag AC9_DC0;          /* Auxiliary Clock 9 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved14[20];
  MC_CGM_AC10_SC_tag AC10_SC;          /* Auxiliary Clock 10 Select Control Register */
  MC_CGM_AC10_SS_tag AC10_SS;          /* Auxiliary Clock 10 Select Status Register */
  MC_CGM_AC10_DC0_tag AC10_DC0;        /* Auxiliary Clock 10 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved15[20];
  MC_CGM_AC11_SC_tag AC11_SC;          /* Auxiliary Clock 11 Select Control Register */
  MC_CGM_AC11_SS_tag AC11_SS;          /* Auxiliary Clock 11 Select Status Register */
  MC_CGM_AC11_DC0_tag AC11_DC0;        /* Auxiliary Clock 11 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved16[20];
  MC_CGM_AC12_SC_tag AC12_SC;          /* Auxiliary Clock 12 Select Control Register */
  MC_CGM_AC12_SS_tag AC12_SS;          /* Auxiliary Clock 12 Select Status Register */
  MC_CGM_AC12_DC0_tag AC12_DC0;        /* Auxiliary Clock 12 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved17[20];
  MC_CGM_AC13_SC_tag AC13_SC;          /* Auxiliary Clock 13 Select Control Register */
  MC_CGM_AC13_SS_tag AC13_SS;          /* Auxiliary Clock 13 Select Status Register */
  MC_CGM_AC13_DC0_tag AC13_DC0;        /* Auxiliary Clock 13 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved18[20];
  MC_CGM_AC14_SC_tag AC14_SC;          /* Auxiliary Clock 14 Select Control Register */
  MC_CGM_AC14_SS_tag AC14_SS;          /* Auxiliary Clock 14 Select Status Register */
  MC_CGM_AC14_DC0_tag AC14_DC0;        /* Auxiliary Clock 14 Divider 0 Configuration Register */
  uint8_t MC_CGM_reserved19[20];
  MC_CGM_AC15_SC_tag AC15_SC;          /* Auxiliary Clock 15 Select Control Register */
  MC_CGM_AC15_SS_tag AC15_SS;          /* Auxiliary Clock 14 Select Status Register */
  MC_CGM_AC15_DC_tag AC15_DC;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_SYSCLK:4;
    vuint32_t S_RC:1;
    vuint32_t S_FXOSC:1;
    vuint32_t S_SIRC:1;
    vuint32_t S_SXOSC:1;
    vuint32_t S_PLL0:1;
    vuint32_t S_PLL1:1;
    vuint32_t S_PLL2:1;
    vuint32_t S_PLL3:1;
    vuint32_t _unused_12:4;
    vuint32_t S_FLA:2;
    vuint32_t _unused_18:2;
    vuint32_t S_MVR:1;
    vuint32_t _unused_21:2;
    vuint32_t S_PDO:1;
    vuint32_t _unused_24:2;
    vuint32_t _unused_26:1;
    vuint32_t S_MTRANS:1;
    vuint32_t S_CURRENT_MODE:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:16;
    vuint32_t _unused_16:12;
    vuint32_t TARGET_MODE:4;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t RESET_FUNC:1;
    vuint32_t _unused_1:1;
    vuint32_t SAFE:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t STOP0:1;
    vuint32_t _unused_11:2;
    vuint32_t STANDBY0:1;
    vuint32_t _unused_14:1;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_16:16;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t I_MTC:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_ICONF:1;
    vuint32_t _unused_4:1;
    vuint32_t I_ICONF_CC:1;
    vuint32_t _unused_6:26;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t M_MTC:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_ICONF:1;
    vuint32_t _unused_4:1;
    vuint32_t M_ICONF_CC:1;
    vuint32_t _unused_6:26;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_SEA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_DMA:1;
    vuint32_t S_MRI:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRIG:1;
    vuint32_t _unused_6:26;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t CDP_PRPH_0_31:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t _unused_7:1;
    vuint32_t CFLASH_SC:1;
    vuint32_t _unused_9:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t RC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CDP_PRPH_0_255:1;
    vuint32_t SMR:1;
    vuint32_t PCS_PROG:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t PMC_PROG:1;
    vuint32_t _unused_21:2;
    vuint32_t MPH_BUSY:1;
    vuint32_t _unused_24:4;
    vuint32_t PREVIOUS_MODE:4;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_STOP0_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_STOP0_MC_tag;

typedef union MC_ME_STANDBY0_MC_union_tag { /* STANDBY0 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t SYSCLK:4;
    vuint32_t RCON:1;
    vuint32_t FXOSCON:1;
    vuint32_t SIRCON:1;
    vuint32_t SXOSCON:1;
    vuint32_t PLL0ON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL2ON:1;
    vuint32_t PLL3ON:1;
    vuint32_t _unused_12:4;
    vuint32_t FLAON:2;
    vuint32_t _unused_18:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_21:2;
    vuint32_t PDO:1;
    vuint32_t _unused_24:4;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_STANDBY0_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t S_DMAMUX:1;
    vuint32_t S_I2C_0:1;
    vuint32_t S_I2C_1:1;
    vuint32_t S_FTM_0:1;
    vuint32_t S_FTM_1:1;
    vuint32_t S_FTM_2:1;
    vuint32_t S_FTM_3:1;
    vuint32_t _unused_8:1;
    vuint32_t S_CMP_0:1;
    vuint32_t S_CMP_1:1;
    vuint32_t S_SMC:1;
    vuint32_t S_SSD_0:1;
    vuint32_t S_SSD_1:1;
    vuint32_t S_SSD_2:1;
    vuint32_t S_SSD_3:1;
    vuint32_t S_SSD_4:1;
    vuint32_t S_SSD_5:1;
    vuint32_t S_MPR:1;
    vuint32_t S_SPI_0:1;
    vuint32_t S_SPI_1:1;
    vuint32_t S_SPI_2:1;
    vuint32_t S_SPI_3:1;
    vuint32_t S_SPI_4:1;
    vuint32_t S_LINFLEX_0:1;
    vuint32_t S_LINFLEX_1:1;
    vuint32_t S_LINFLEX_2:1;
    vuint32_t S_LCD:1;
    vuint32_t S_FlexCAN_1:1;
    vuint32_t S_FlexCAN_2:1;
    vuint32_t S_ADC:1;
    vuint32_t _unused_31:1;
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t S_CRC:1;
    vuint32_t _unused_3:1;
    vuint32_t S_PIT:1;
    vuint32_t _unused_5:23;
    vuint32_t S_SIUL:1;
    vuint32_t _unused_29:3;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:20;
    vuint32_t S_RTC:1;
    vuint32_t _unused_21:3;
    vuint32_t S_FlexCAN_0:1;
    vuint32_t _unused_25:3;
    vuint32_t S_STCU:1;
    vuint32_t _unused_29:3;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS4_union_tag {    /* Peripheral Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t S_QuadSPI_0:1;
    vuint32_t S_QuadSPI_1:1;
    vuint32_t _unused_2:2;
    vuint32_t S_MDDRC:1;
    vuint32_t _unused_5:3;
    vuint32_t S_ACE_0:1;
    vuint32_t _unused_9:7;
    vuint32_t _unused_16:7;
    vuint32_t _unused_23:1;
    vuint32_t S_ACE_1:1;               /* Peripheral Status */
    vuint32_t _unused_25:7;
  } B;
} MC_ME_PS4_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t S_VIU:1;
    vuint32_t _unused_9:3;
    vuint32_t S_GC355:1;
    vuint32_t _unused_13:3;
    vuint32_t S_TCON_0:1;
    vuint32_t _unused_17:3;
    vuint32_t S_TCON_1:1;
    vuint32_t _unused_21:3;
    vuint32_t S_RLE_DEC:1;
    vuint32_t _unused_25:3;
    vuint32_t S_SGM:1;
    vuint32_t _unused_29:3;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status Register 6 */
  vuint32_t R;
  struct {
    vuint32_t S_DMA_0:1;
    vuint32_t S_DMA_1:1;
    vuint32_t _unused_2:2;
    vuint32_t S_ENET:1;
    vuint32_t _unused_5:3;
    vuint32_t S_LDB:1;
    vuint32_t _unused_9:3;
    vuint32_t S_MLB:1;
    vuint32_t _unused_13:19;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RESET:1;
    vuint32_t _unused_1:1;
    vuint32_t SAFE:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:24;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:9;
    vuint32_t _unused_9:1;
    vuint32_t STOP0:1;
    vuint32_t _unused_11:2;
    vuint32_t STANDBY0:1;
    vuint32_t _unused_14:18;
  } B;
} MC_ME_LP_PC_tag;

typedef union MC_ME_PCTL3_union_tag {  /* I2C_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL3_tag;

typedef union MC_ME_PCTL2_union_tag {  /* I2C_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL2_tag;

typedef union MC_ME_PCTL1_union_tag {  /* DMA_CH_MUX_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL1_tag;

typedef union MC_ME_PCTL7_union_tag {  /* FLEXTIMER_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL7_tag;

typedef union MC_ME_PCTL6_union_tag {  /* FLEXTIMER_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL6_tag;

typedef union MC_ME_PCTL5_union_tag {  /* FLEXTIMER_1 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL5_tag;

typedef union MC_ME_PCTL4_union_tag {  /* FLEXTIMER_0 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL4_tag;

typedef union MC_ME_PCTL11_union_tag { /* SMC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL11_tag;

typedef union MC_ME_PCTL10_union_tag { /* CMP_1 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL10_tag;

typedef union MC_ME_PCTL9_union_tag {  /* CMP_0 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL9_tag;

typedef union MC_ME_PCTL15_union_tag { /* SSD_3 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL15_tag;

typedef union MC_ME_PCTL14_union_tag { /* SSD_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL14_tag;

typedef union MC_ME_PCTL13_union_tag { /* SSD_1 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL13_tag;

typedef union MC_ME_PCTL12_union_tag { /* SSD_0 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL12_tag;

typedef union MC_ME_PCTL19_union_tag { /* SPI_0 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL19_tag;

typedef union MC_ME_PCTL18_union_tag { /* MPR Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL18_tag;

typedef union MC_ME_PCTL17_union_tag { /* SSD_5 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL17_tag;

typedef union MC_ME_PCTL16_union_tag { /* SSD_4 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL16_tag;

typedef union MC_ME_PCTL23_union_tag { /* SPI_4 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL23_tag;

typedef union MC_ME_PCTL22_union_tag { /* SPI_3 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL22_tag;

typedef union MC_ME_PCTL21_union_tag { /* SPI_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL21_tag;

typedef union MC_ME_PCTL20_union_tag { /* SPI_1 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL20_tag;

typedef union MC_ME_PCTL27_union_tag { /* LCD Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL27_tag;

typedef union MC_ME_PCTL26_union_tag { /* LINFLEX_2 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL26_tag;

typedef union MC_ME_PCTL25_union_tag { /* LINFLEX_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL25_tag;

typedef union MC_ME_PCTL24_union_tag { /* LINFLEX_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL24_tag;

typedef union MC_ME_PCTL30_union_tag { /* ADC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL30_tag;

typedef union MC_ME_PCTL29_union_tag { /* FlexCAN_2 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL29_tag;

typedef union MC_ME_PCTL28_union_tag { /* FlexCAN_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL28_tag;

typedef union MC_ME_PCTL34_union_tag { /* CRC Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL34_tag;

typedef union MC_ME_PCTL36_union_tag { /* PIT Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL36_tag;

typedef union MC_ME_PCTL60_union_tag { /* SIUL Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL60_tag;

typedef union MC_ME_PCTL84_union_tag { /* RTC_API Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL84_tag;

typedef union MC_ME_PCTL88_union_tag { /* FLEXCAN_0 Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL88_tag;

typedef union MC_ME_PCTL129_union_tag { /* QuadSPI_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL129_tag;

typedef union MC_ME_PCTL128_union_tag { /* QuadSPI_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL128_tag;

typedef union MC_ME_PCTL132_union_tag { /* DRAM_CTRLR Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL132_tag;

typedef union MC_ME_PCTL136_union_tag { /* 2D-ACE 0 (DCU_0) Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL136_tag;

typedef union MC_ME_PCTL152_union_tag { /* 2D-ACE 1 (DCU_1) Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL152_tag;

typedef union MC_ME_PCTL168_union_tag { /* VIU Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL168_tag;

typedef union MC_ME_PCTL172_union_tag { /* GC355 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL172_tag;

typedef union MC_ME_PCTL176_union_tag { /* TCON Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL176_tag;

typedef union MC_ME_PCTL180_union_tag { /* TCON_LITE Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL180_tag;

typedef union MC_ME_PCTL184_union_tag { /* RLE Peripheral Control */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL184_tag;

typedef union MC_ME_PCTL188_union_tag { /* SGM Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL188_tag;

typedef union MC_ME_PCTL193_union_tag { /* DMA_1 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL193_tag;

typedef union MC_ME_PCTL192_union_tag { /* DMA_0 Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL192_tag;

typedef union MC_ME_PCTL196_union_tag { /* ENET Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL196_tag;

typedef union MC_ME_PCTL200_union_tag { /* LDB Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL200_tag;

typedef union MC_ME_PCTL204_union_tag { /* MLB Peripheral Control Register */
  vuint8_t R;
  struct {
    vuint8_t RUN_CFG:3;
    vuint8_t LP_CFG:3;
    vuint8_t _unused_6:2;
  } B;
} MC_ME_PCTL204_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_M4:1;
    vuint32_t S_A5:1;
    vuint32_t S_IOP:1;
    vuint32_t _unused_3:29;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL1_union_tag {  /* CORE1 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:2;
    vuint16_t SAFE:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_11:2;
    vuint16_t STANDBY0:1;
    vuint16_t _unused_14:2;
  } B;
} MC_ME_CCTL1_tag;

typedef union MC_ME_CCTL0_union_tag {  /* CORE0 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:2;
    vuint16_t SAFE:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_11:2;
    vuint16_t STANDBY0:1;
    vuint16_t _unused_14:2;
  } B;
} MC_ME_CCTL0_tag;

typedef union MC_ME_CCTL2_union_tag {  /* CORE2 Control Register */
  vuint16_t R;
  struct {
    vuint16_t RESET:2;
    vuint16_t SAFE:1;
    vuint16_t DRUN:1;
    vuint16_t RUN0:1;
    vuint16_t RUN1:1;
    vuint16_t RUN2:1;
    vuint16_t RUN3:1;
    vuint16_t _unused_8:2;
    vuint16_t STOP0:1;
    vuint16_t _unused_11:2;
    vuint16_t STANDBY0:1;
    vuint16_t _unused_14:2;
  } B;
} MC_ME_CCTL2_tag;

typedef union MC_ME_CADDR0_union_tag { /* CORE0 Address Register */
  vuint32_t R;
  struct {
    vuint32_t RMC:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR0_tag;

typedef union MC_ME_CADDR1_union_tag { /* CORE1 Address Register */
  vuint32_t R;
  struct {
    vuint32_t RMC:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR2_union_tag { /* CORE2 Address Register */
  vuint32_t R;
  struct {
    vuint32_t RMC:1;
    vuint32_t _unused_1:1;
    vuint32_t ADDR:30;
  } B;
} MC_ME_CADDR2_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN Mode Configuration Register */
  uint8_t MC_ME_reserved2[8];
  MC_ME_STOP0_MC_tag STOP0_MC;         /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved3[8];
  MC_ME_STANDBY0_MC_tag STANDBY0_MC;   /* STANDBY0 Mode Configuration */
  uint8_t MC_ME_reserved4[8];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  uint8_t MC_ME_reserved5[4];
  MC_ME_PS4_tag PS4;                   /* Peripheral Status Register 4 */
  MC_ME_PS5_tag PS5;                   /* Peripheral Status Register 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status Register 6 */
  uint8_t MC_ME_reserved6[4];
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  MC_ME_PCTL3_tag PCTL3;               /* I2C_1 Peripheral Control Register */
  MC_ME_PCTL2_tag PCTL2;               /* I2C_0 Peripheral Control Register */
  MC_ME_PCTL1_tag PCTL1;               /* DMA_CH_MUX_0 Peripheral Control Register */
  uint8_t MC_ME_reserved7[1];
  MC_ME_PCTL7_tag PCTL7;               /* FLEXTIMER_3 Peripheral Control Register */
  MC_ME_PCTL6_tag PCTL6;               /* FLEXTIMER_2 Peripheral Control Register */
  MC_ME_PCTL5_tag PCTL5;               /* FLEXTIMER_1 Peripheral Control */
  MC_ME_PCTL4_tag PCTL4;               /* FLEXTIMER_0 Peripheral Control */
  MC_ME_PCTL11_tag PCTL11;             /* SMC Peripheral Control Register */
  MC_ME_PCTL10_tag PCTL10;             /* CMP_1 Peripheral Control */
  MC_ME_PCTL9_tag PCTL9;               /* CMP_0 Peripheral Control */
  uint8_t MC_ME_reserved8[1];
  MC_ME_PCTL15_tag PCTL15;             /* SSD_3 Peripheral Control Register */
  MC_ME_PCTL14_tag PCTL14;             /* SSD_2 Peripheral Control Register */
  MC_ME_PCTL13_tag PCTL13;             /* SSD_1 Peripheral Control */
  MC_ME_PCTL12_tag PCTL12;             /* SSD_0 Peripheral Control */
  MC_ME_PCTL19_tag PCTL19;             /* SPI_0 Peripheral Control */
  MC_ME_PCTL18_tag PCTL18;             /* MPR Peripheral Control */
  MC_ME_PCTL17_tag PCTL17;             /* SSD_5 Peripheral Control */
  MC_ME_PCTL16_tag PCTL16;             /* SSD_4 Peripheral Control */
  MC_ME_PCTL23_tag PCTL23;             /* SPI_4 Peripheral Control */
  MC_ME_PCTL22_tag PCTL22;             /* SPI_3 Peripheral Control */
  MC_ME_PCTL21_tag PCTL21;             /* SPI_2 Peripheral Control Register */
  MC_ME_PCTL20_tag PCTL20;             /* SPI_1 Peripheral Control */
  MC_ME_PCTL27_tag PCTL27;             /* LCD Peripheral Control Register */
  MC_ME_PCTL26_tag PCTL26;             /* LINFLEX_2 Peripheral Control */
  MC_ME_PCTL25_tag PCTL25;             /* LINFLEX_1 Peripheral Control Register */
  MC_ME_PCTL24_tag PCTL24;             /* LINFLEX_0 Peripheral Control Register */
  uint8_t MC_ME_reserved9[1];
  MC_ME_PCTL30_tag PCTL30;             /* ADC Peripheral Control Register */
  MC_ME_PCTL29_tag PCTL29;             /* FlexCAN_2 Peripheral Control Register */
  MC_ME_PCTL28_tag PCTL28;             /* FlexCAN_1 Peripheral Control Register */
  uint8_t MC_ME_reserved10[1];
  MC_ME_PCTL34_tag PCTL34;             /* CRC Peripheral Control Register */
  uint8_t MC_ME_reserved11[5];
  MC_ME_PCTL36_tag PCTL36;             /* PIT Peripheral Control Register */
  uint8_t MC_ME_reserved12[23];
  MC_ME_PCTL60_tag PCTL60;             /* SIUL Peripheral Control Register */
  uint8_t MC_ME_reserved13[23];
  MC_ME_PCTL84_tag PCTL84;             /* RTC_API Peripheral Control Register */
  uint8_t MC_ME_reserved14[3];
  MC_ME_PCTL88_tag PCTL88;             /* FLEXCAN_0 Peripheral Control */
  uint8_t MC_ME_reserved15[38];
  MC_ME_PCTL129_tag PCTL129;           /* QuadSPI_1 Peripheral Control Register */
  MC_ME_PCTL128_tag PCTL128;           /* QuadSPI_0 Peripheral Control Register */
  uint8_t MC_ME_reserved16[3];
  MC_ME_PCTL132_tag PCTL132;           /* DRAM_CTRLR Peripheral Control */
  uint8_t MC_ME_reserved17[3];
  MC_ME_PCTL136_tag PCTL136;           /* 2D-ACE 0 (DCU_0) Peripheral Control Register */
  uint8_t MC_ME_reserved18[15];
  MC_ME_PCTL152_tag PCTL152;           /* 2D-ACE 1 (DCU_1) Peripheral Control */
  uint8_t MC_ME_reserved19[15];
  MC_ME_PCTL168_tag PCTL168;           /* VIU Peripheral Control */
  uint8_t MC_ME_reserved20[3];
  MC_ME_PCTL172_tag PCTL172;           /* GC355 Peripheral Control Register */
  uint8_t MC_ME_reserved21[3];
  MC_ME_PCTL176_tag PCTL176;           /* TCON Peripheral Control Register */
  uint8_t MC_ME_reserved22[3];
  MC_ME_PCTL180_tag PCTL180;           /* TCON_LITE Peripheral Control */
  uint8_t MC_ME_reserved23[3];
  MC_ME_PCTL184_tag PCTL184;           /* RLE Peripheral Control */
  uint8_t MC_ME_reserved24[3];
  MC_ME_PCTL188_tag PCTL188;           /* SGM Peripheral Control Register */
  uint8_t MC_ME_reserved25[2];
  MC_ME_PCTL193_tag PCTL193;           /* DMA_1 Peripheral Control Register */
  MC_ME_PCTL192_tag PCTL192;           /* DMA_0 Peripheral Control Register */
  uint8_t MC_ME_reserved26[3];
  MC_ME_PCTL196_tag PCTL196;           /* ENET Peripheral Control Register */
  uint8_t MC_ME_reserved27[3];
  MC_ME_PCTL200_tag PCTL200;           /* LDB Peripheral Control Register */
  uint8_t MC_ME_reserved28[3];
  MC_ME_PCTL204_tag PCTL204;           /* MLB Peripheral Control Register */
  uint8_t MC_ME_reserved29[48];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  MC_ME_CCTL1_tag CCTL1;               /* CORE1 Control Register */
  MC_ME_CCTL0_tag CCTL0;               /* CORE0 Control Register */
  uint8_t MC_ME_reserved30[2];
  MC_ME_CCTL2_tag CCTL2;               /* CORE2 Control Register */
  uint8_t MC_ME_reserved31[20];
  MC_ME_CADDR0_tag CADDR0;             /* CORE0 Address Register */
  MC_ME_CADDR1_tag CADDR1;             /* CORE1 Address Register */
  MC_ME_CADDR2_tag CADDR2;             /* CORE2 Address Register */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PCONF0_union_tag { /* Power Domain #0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RST:1;
    vuint32_t _unused_1:1;
    vuint32_t SAFE:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_11:2;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_14:18;
  } B;
} MC_PCU_PCONF0_tag;

typedef union MC_PCU_PCONF1_union_tag { /* Power Domain #1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RST:1;
    vuint32_t _unused_1:1;
    vuint32_t SAFE:1;
    vuint32_t DRUN:1;
    vuint32_t RUN0:1;
    vuint32_t RUN1:1;
    vuint32_t RUN2:1;
    vuint32_t RUN3:1;
    vuint32_t _unused_8:2;
    vuint32_t STOP0:1;
    vuint32_t _unused_11:2;
    vuint32_t STBY0:1;                 /* Power domain control during STANDBY0 mode */
    vuint32_t _unused_14:18;
  } B;
} MC_PCU_PCONF1_tag;

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t PD0:1;
    vuint32_t PD1:1;                   /* Power status for power domain 1 */
    vuint32_t _unused_2:30;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  MC_PCU_PCONF0_tag PCONF0;            /* Power Domain #0 Configuration Register */
  MC_PCU_PCONF1_tag PCONF1;            /* Power Domain #1 Configuration Register */
  uint8_t MC_PCU_reserved0[56];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* Destructive Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t F_POR:1;
    vuint32_t _unused_1:2;
    vuint32_t F_SOFT_DEST:1;
    vuint32_t _unused_4:1;
    vuint32_t F_SUF:1;
    vuint32_t F_SSSR:1;
    vuint32_t _unused_7:1;
    vuint32_t F_EFR:1;
    vuint32_t F_FIF:1;
    vuint32_t _unused_10:2;
    vuint32_t F_JTAG:1;
    vuint32_t _unused_13:19;
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_DBRE_union_tag {  /* DestructiveBidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t BE_SOFT_DEST:1;
    vuint32_t _unused_4:1;
    vuint32_t BE_SUF:1;
    vuint32_t BE_SSSR:1;
    vuint32_t _unused_7:1;
    vuint32_t BE_EFR:1;
    vuint32_t BE_FIF:1;
    vuint32_t _unused_10:2;
    vuint32_t BE_JTAG:1;
    vuint32_t _unused_13:19;
  } B;
} MC_RGM_DBRE_tag;

typedef union MC_RGM_FES_union_tag {   /* Functional Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t F_EXR:1;
    vuint32_t _unused_1:2;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t F_CM0_LOCKUP:1;          /* Flag for CM0 LOCKUP */
    vuint32_t F_JTAG_FUNC:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t F_FXOSC_OR:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t _unused_10:4;
    vuint32_t F_HVD_VDD_LV_PD2:1;
    vuint32_t F_LVD_LV_PD2_COLD:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t F_CM4_LOCKUP:1;          /* Flag for CM4 LOCKUP reset */
    vuint32_t _unused_19:7;
    vuint32_t F_CM0_RST_REQ:1;
    vuint32_t F_SWT2_RST_REQ:1;
    vuint32_t F_SWT1_RST_REQ:1;
    vuint32_t F_SWT0_RST_REQ:1;
    vuint32_t _unused_30:2;
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* Functional Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t D_CM0_LOCKUP:1;
    vuint32_t D_JTAG_FUNC:1;
    vuint32_t _unused_6:1;
    vuint32_t D_FXOSC_OR:1;
    vuint32_t _unused_8:6;
    vuint32_t D_HVD_VDD_LV_PD2:1;
    vuint32_t D_LVD_LV_PD2_COLD:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t D_CM4_LOCKUP:1;
    vuint32_t _unused_19:13;
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FEAR_union_tag {  /* Functional Event Reset Disable Alternate Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t AR_CM0_LOCKUP:1;
    vuint32_t AR_JTAG_FUNC:1;
    vuint32_t _unused_6:1;
    vuint32_t AR_FXOSC_OR:1;
    vuint32_t _unused_8:6;
    vuint32_t AR_HVD_VDD_LV_PD2:1;
    vuint32_t AR_LVD_LV_PD2_COLD:1;
    vuint32_t _unused_16:2;
    vuint32_t AR_CM4_LOCKUP:1;
    vuint32_t _unused_19:13;
  } B;
} MC_RGM_FEAR_tag;

typedef union MC_RGM_FBRE_union_tag {  /* FunctionalBidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t BE_ESR0:1;
    vuint32_t _unused_1:2;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t BE_CM0_LOCKUP:1;
    vuint32_t BE_JTAG_FUNC:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t BE_FXOSC_OR:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t _unused_10:4;
    vuint32_t BE_HVD_VDD_LV_PD2:1;
    vuint32_t BE_LVD_LV_PD2_COLD:1;
    vuint32_t _unused_16:2;
    vuint32_t BE_CM4_LOCKUP:1;
    vuint32_t _unused_19:7;
    vuint32_t BE_CM0_RST_REQ:1;
    vuint32_t BE_SWT2_RST_REQ:1;
    vuint32_t BE_SWT1_RST_REQ:1;
    vuint32_t BE_SWT0_RST_REQ:1;
    vuint32_t _unused_30:2;
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* Functional Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t SS_EXR:1;
    vuint32_t _unused_1:2;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t SS_CM0_LOCKUP:1;         /* Short Sequence for CM0 LOCKUP reset */
    vuint32_t SS_JTAG_FUNC:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t SS_FXOSC_OR:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t _unused_10:4;
    vuint32_t SS_HVD_VDD_LV_PD2:1;
    vuint32_t SS_LVD_LV_PD2_COLD:1;
    vuint32_t _unused_16:2;
    vuint32_t SS_CM4_LOCKUP:1;
    vuint32_t _unused_19:7;
    vuint32_t SS_CM0_RST_REQ:1;
    vuint32_t SS_SWT2_RST_REQ:1;
    vuint32_t SS_SWT1_RST_REQ:1;
    vuint32_t SS_SWT0_RST_REQ:1;
    vuint32_t _unused_30:2;
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_FRET_union_tag {  /* Functional Reset Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t FRET:4;
    vuint8_t _unused_4:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* Destructive' Reset Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t DRET:4;
    vuint8_t _unused_4:4;
  } B;
} MC_RGM_DRET_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* Destructive Event Status Register */
  uint8_t MC_RGM_reserved0[44];
  MC_RGM_DBRE_tag DBRE;                /* DestructiveBidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved1[716];
  MC_RGM_FES_tag FES;                  /* Functional Event Status Register */
  uint8_t MC_RGM_reserved2[12];
  MC_RGM_FERD_tag FERD;                /* Functional Event Reset Disable Register */
  uint8_t MC_RGM_reserved3[12];
  MC_RGM_FEAR_tag FEAR;                /* Functional Event Reset Disable Alternate Request Status Register */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_FBRE_tag FBRE;                /* FunctionalBidirectional Reset Enable Register */
  uint8_t MC_RGM_reserved5[12];
  MC_RGM_FESS_tag FESS;                /* Functional Event Short Sequence Register */
  uint8_t MC_RGM_reserved6[707];
  MC_RGM_FRET_tag FRET;                /* Functional Reset Threshold Register */
  uint8_t MC_RGM_reserved7[3];
  MC_RGM_DRET_tag DRET;                /* Destructive' Reset Threshold Register */
};


/* ============================================================================
   =============================== Module: MDDRC ==============================
   ============================================================================ */

typedef union MDDRC_SYS_CONFIG_union_tag { /* System Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FIFOUVEN:1;
    vuint32_t FIFOOVEN:1;
    vuint32_t _unused_2:2;
    vuint32_t FIFOUVPEND:1;
    vuint32_t FIFOOVPEND:1;
    vuint32_t ONDIETERMINATE:1;
    vuint32_t EARLYODT:1;
    vuint32_t WDLY:3;
    vuint32_t QUARTDQSDLY:1;
    vuint32_t HALFDQSDLY:1;
    vuint32_t RDLY:4;
    vuint32_t A16BITMODE:1;
    vuint32_t SELFREFEN:1;
    vuint32_t _unused_19:2;
    vuint32_t DRAM_BANK_SELECT:4;
    vuint32_t DRAM_ROW_SELECT:3;
    vuint32_t CMDMODE:1;
    vuint32_t CLKON:1;
    vuint32_t CKE:1;
    vuint32_t RST_B:1;
  } B;
} MDDRC_SYS_CONFIG_tag;

typedef union MDDRC_TIME_CONFIG0_union_tag { /* Time Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DRAM_BANK_PRE_TIME:8;
    vuint32_t DRAM_COMMAND_TIME:8;
    vuint32_t DRAM_REFRESH_TIME:14;
    vuint32_t _unused_30:2;
  } B;
} MDDRC_TIME_CONFIG0_tag;

typedef union MDDRC_TIME_CONFIG1_union_tag { /* Time Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DRAM_TIME_RAS:5;
    vuint32_t DRAM_TIME_RC:6;
    vuint32_t DRAM_TIME_RRD:5;
    vuint32_t DRAM_TIME_WTR:4;
    vuint32_t DRAM_TIME_WR1:5;
    vuint32_t DRAM_TIME_RFC:7;
  } B;
} MDDRC_TIME_CONFIG1_tag;

typedef union MDDRC_TIME_CONFIG2_union_tag { /* Time Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DRAM_TIME_RPA:5;
    vuint32_t DRAM_TIME_RP:5;
    vuint32_t DRAM_TIME_RTP:5;
    vuint32_t DRAM_TIME_CCD:4;
    vuint32_t DRAM_TIME_RTW:4;
    vuint32_t DRAM_TIME_FAW:5;
    vuint32_t DRAM_TIME_RCD:4;
  } B;
} MDDRC_TIME_CONFIG2_tag;

typedef union MDDRC_CMD_union_tag {    /* Command Register */
  vuint32_t R;
  struct {
    vuint32_t DRAM_COMMAND:24;
    vuint32_t _unused_24:8;
  } B;
} MDDRC_CMD_tag;

typedef union MDDRC_COM_CMD_union_tag { /* Compact Command Register */
  vuint32_t R;
  struct {
    vuint32_t DRAM_COMPACT_COMMAND:16;
    vuint32_t _unused_16:16;
  } B;
} MDDRC_COM_CMD_tag;

typedef union MDDRC_SELREF_CMD_union_tag { /* Enter/Exit Self-Refresh Registers */
  vuint32_t R;
  struct {
    vuint32_t SELF_REFRESH_CMD:16;
    vuint32_t _unused_16:16;
  } B;
} MDDRC_SELREF_CMD_tag;

typedef union MDDRC_DQS_CFG_union_tag { /* DQS Config Offset Count Register */
  vuint32_t R;
  struct {
    vuint32_t DQS_SLAVE_0_OFFSET_COUNT:8;
    vuint32_t DQS_SLAVE_1_OFFSET_COUNT:8;
    vuint32_t DQS_SLAVE_2_OFFSET_COUNT:8;
    vuint32_t DQS_SLAVE_3_OFFSET_COUNT:8;
  } B;
} MDDRC_DQS_CFG_tag;

typedef union MDDRC_DQS_CFG_OFF_union_tag { /* DQS Config Offset Time Register */
  vuint32_t R;
  struct {
    vuint32_t DQS_SLAVE_0_OFFSET_TIME:6;
    vuint32_t _unused_6:2;
    vuint32_t DQS_SLAVE_1_OFFSET_TIME:6;
    vuint32_t _unused_14:2;
    vuint32_t DQS_SLAVE_2_OFFSET_TIME:6;
    vuint32_t _unused_22:2;
    vuint32_t DQS_SLAVE_3_OFFSET_TIME:6;
    vuint32_t _unused_30:2;
  } B;
} MDDRC_DQS_CFG_OFF_tag;

typedef union MDDRC_AUX_CFG_union_tag { /* Aux Config Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;
    vuint32_t DQS_LOW:1;
    vuint32_t INPUTS_ALWAYS_ON:1;
    vuint32_t DRIVE_DQS:1;
    vuint32_t DQS_TIMING:2;
    vuint32_t RDATACOMPARE:1;
    vuint32_t LOOPBACK:1;
    vuint32_t WDATA_INJECT:1;
  } B;
} MDDRC_AUX_CFG_tag;

typedef union MDDRC_EX_AT_union_tag {  /* Extra Attributes Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:22;
    vuint32_t CONFIG_CAS3:1;
    vuint32_t CONFIG_SDR:1;
    vuint32_t _unused_24:8;
  } B;
} MDDRC_EX_AT_tag;

struct MDDRC_tag {
  MDDRC_SYS_CONFIG_tag SYS_CONFIG;     /* System Configuration Register */
  MDDRC_TIME_CONFIG0_tag TIME_CONFIG0; /* Time Configuration Register 0 */
  MDDRC_TIME_CONFIG1_tag TIME_CONFIG1; /* Time Configuration Register 1 */
  MDDRC_TIME_CONFIG2_tag TIME_CONFIG2; /* Time Configuration Register 2 */
  MDDRC_CMD_tag CMD;                   /* Command Register */
  MDDRC_COM_CMD_tag COM_CMD;           /* Compact Command Register */
  MDDRC_SELREF_CMD_tag SELREF_CMD[8];  /* Enter/Exit Self-Refresh Registers */
  MDDRC_DQS_CFG_tag DQS_CFG;           /* DQS Config Offset Count Register */
  MDDRC_DQS_CFG_OFF_tag DQS_CFG_OFF;   /* DQS Config Offset Time Register */
  uint8_t MDDRC_reserved0[4];
  MDDRC_AUX_CFG_tag AUX_CFG;           /* Aux Config Register */
  uint8_t MDDRC_reserved1[24];
  MDDRC_EX_AT_tag EX_AT;               /* Extra Attributes Register */
};


/* ============================================================================
   =============================== Module: MLB ================================
   ============================================================================ */

typedef union MLB_DCCR_union_tag {     /* Device Control Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDA:8;
    vuint32_t _unused_8:15;
    vuint32_t MRS:1;
    vuint32_t MHRE:1;
    vuint32_t MLE:1;
    vuint32_t MLK:1;
    vuint32_t _unused_27:1;
    vuint32_t MCS:2;
    vuint32_t LBM:1;
    vuint32_t MDE:1;
  } B;
} MLB_DCCR_tag;

typedef union MLB_SSCR_union_tag {     /* System Status Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SDR:1;
    vuint32_t SDNL:1;
    vuint32_t SDNU:1;
    vuint32_t SDCS:1;
    vuint32_t SDSC:1;
    vuint32_t SDML:1;
    vuint32_t SDMU:1;
    vuint32_t SSRE:1;
    vuint32_t _unused_8:24;
  } B;
} MLB_SSCR_tag;

typedef union MLB_SDCR_union_tag {     /* System Data Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSD:32;
  } B;
} MLB_SDCR_tag;

typedef union MLB_SMCR_union_tag {     /* System Mask Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SMR:1;
    vuint32_t SMNL:1;
    vuint32_t SMNU:1;
    vuint32_t SMCS:1;
    vuint32_t SMSC:1;
    vuint32_t SMML:1;
    vuint32_t SMMU:1;
    vuint32_t _unused_7:25;
  } B;
} MLB_SMCR_tag;

typedef union MLB_VCCR_union_tag {     /* Version Control Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MMI:8;
    vuint32_t MMA:8;
    vuint32_t UMI:8;
    vuint32_t UMA:8;
  } B;
} MLB_VCCR_tag;

typedef union MLB_SBCR_union_tag {     /* Synchronous Base Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t STBA:16;
    vuint32_t SRBA:16;
  } B;
} MLB_SBCR_tag;

typedef union MLB_ABCR_union_tag {     /* Asynchronous Base Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ATBA:16;
    vuint32_t ARBA:16;
  } B;
} MLB_ABCR_tag;

typedef union MLB_CBCR_union_tag {     /* Control Base Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CTBA:16;
    vuint32_t CRBA:16;
  } B;
} MLB_CBCR_tag;

typedef union MLB_IBCR_union_tag {     /* Isochronous Base Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ITBA:16;
    vuint32_t IRBA:16;
  } B;
} MLB_IBCR_tag;

typedef union MLB_CICR_union_tag {     /* Channel Interrupt Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CSU:16;
    vuint32_t _unused_16:16;
  } B;
} MLB_CICR_tag;

typedef union MLB_CHANNELS_CECR_union_tag { /* Channel Entry Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CA:8;
    vuint32_t Rsvd_FSPC_IPL:5;
    vuint32_t Rsvd_IPL:2;
    vuint32_t Rsvd_FSCD_IPL:1;
    vuint32_t MPE:1;
    vuint32_t MDB:1;
    vuint32_t MBD:1;
    vuint32_t MBS:1;
    vuint32_t MBE:1;
    vuint32_t _unused_21:1;
    vuint32_t MLFS:1;
    vuint32_t _unused_23:2;
    vuint32_t MDS:2;
    vuint32_t Rsvd_FSE_FCE:1;
    vuint32_t CT:2;
    vuint32_t TR:1;
    vuint32_t CE:1;
  } B;
} MLB_CHANNELS_CECR_tag;

typedef union MLB_CHANNELS_CSCR_union_tag { /* Channel Status Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CBPE:1;
    vuint32_t CBDB:1;
    vuint32_t CBD:1;
    vuint32_t CBS:1;
    vuint32_t BE:1;
    vuint32_t ABE:1;
    vuint32_t LFS:1;
    vuint32_t _unused_7:1;
    vuint32_t PBPE:1;
    vuint32_t PBDB:1;
    vuint32_t PBD:1;
    vuint32_t PBS:1;
    vuint32_t _unused_12:4;
    vuint32_t RDY:1;                   /* RDY */
    vuint32_t GIRB:1;
    vuint32_t IVB:2;
    vuint32_t _unused_20:10;
    vuint32_t BF:1;
    vuint32_t BM:1;
  } B;
} MLB_CHANNELS_CSCR_tag;

typedef union MLB_CHANNELS_CCBCR_union_tag { /* Channel Current Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t BFA0:2;
    vuint32_t BFA1:14;
    vuint32_t BCA0:2;
    vuint32_t BCA1:14;
  } B;
} MLB_CHANNELS_CCBCR_tag;

typedef union MLB_CHANNELS_CNBCR_union_tag { /* Channel Next Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t BEA:16;
    vuint32_t BSA:16;
  } B;
} MLB_CHANNELS_CNBCR_tag;

typedef struct MLB_CHANNELS_struct_tag {
  MLB_CHANNELS_CECR_tag CECR;          /* Channel Entry Configuration Register */
  MLB_CHANNELS_CSCR_tag CSCR;          /* Channel Status Configuration Register */
  MLB_CHANNELS_CCBCR_tag CCBCR;        /* Channel Current Buffer Configuration Register */
  MLB_CHANNELS_CNBCR_tag CNBCR;        /* Channel Next Buffer Configuration Register */
} MLB_CHANNELS_tag;

typedef union MLB_LCBCR_union_tag {    /* Local Channel Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SA:9;
    vuint32_t _unused_9:4;
    vuint32_t BD:7;
    vuint32_t _unused_20:2;
    vuint32_t TH:8;
    vuint32_t _unused_30:2;
  } B;
} MLB_LCBCR_tag;

struct MLB_tag {
  MLB_DCCR_tag DCCR;                   /* Device Control Configuration Register */
  MLB_SSCR_tag SSCR;                   /* System Status Configuration Register */
  MLB_SDCR_tag SDCR;                   /* System Data Configuration Register */
  MLB_SMCR_tag SMCR;                   /* System Mask Configuration Register */
  uint8_t MLB_reserved0[12];
  MLB_VCCR_tag VCCR;                   /* Version Control Configuration Register */
  MLB_SBCR_tag SBCR;                   /* Synchronous Base Address Configuration Register */
  MLB_ABCR_tag ABCR;                   /* Asynchronous Base Address Configuration Register */
  MLB_CBCR_tag CBCR;                   /* Control Base Address Configuration Register */
  MLB_IBCR_tag IBCR;                   /* Isochronous Base Address Configuration Register */
  MLB_CICR_tag CICR;                   /* Channel Interrupt Configuration Register */
  uint8_t MLB_reserved1[12];
  MLB_CHANNELS_tag CHANNELS[16];
  uint8_t MLB_reserved2[320];
  MLB_LCBCR_tag LCBCR[16];             /* Local Channel Buffer Configuration Register */
};


/* ============================================================================
   =============================== Module: MPR ================================
   ============================================================================ */

typedef union MPR_CTRL0_union_tag {    /* Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t FLEXECC_EN:1;            /* This bit is to control the Flex-ECC feature of 1.3 MB Graphics RAM of the device. This is a write once register and if set will only be cleared by a functional reset. */
    vuint32_t CMP_SAMPLE_SEL:1;        /* This field controls the sample input source of each Comparator */
    vuint32_t CMP_SAMPLE_IN:1;         /* Initiate a software trigger to comparator. Sample input if selected by CMP_SAMPLE_SEL[Bit1] */
    vuint32_t _unused_3:2;
    vuint32_t _unused_5:1;
    vuint32_t AUTO_LV_EN:1;            /* Controls The automotive feature of GPI pads */
    vuint32_t _unused_7:1;
    vuint32_t SRAM_PD0:1;
    vuint32_t SRAM_PD1:1;
    vuint32_t SRAM_PD2:1;
    vuint32_t SRAM_PD3:1;
    vuint32_t GRAM_PD0:1;
    vuint32_t GRAM_PD1:1;
    vuint32_t GRAM_PD2:1;
    vuint32_t _unused_15:3;
    vuint32_t SXOSC_STAT_BYP:1;
    vuint32_t _unused_19:1;
    vuint32_t DDR_S6_CLKR:1;
    vuint32_t DDR_M14_CLKR:1;
    vuint32_t DDR_M13_CLKR:1;
    vuint32_t _unused_23:2;
    vuint32_t FCCU_SOFT_ERR:2;         /* These bits set soft error to corresponding FCCU NCF channel */
    vuint32_t _unused_27:1;
    vuint32_t CLKOUT_1_CLK_SEL:4;
  } B;
} MPR_CTRL0_tag;

typedef union MPR_DBGCTRL_union_tag {  /* Debug Control Register */
  vuint32_t R;
  struct {
    vuint32_t CM0_PERIPH_DEBUG_DIS:1;  /* This field controls peripheral debug mode entry while CM0 is in debug mode */
    vuint32_t CM4_PERIPH_DEBUG_DIS:1;  /* This field controls peripheral debug mode entry while CM4 is in debug mode */
    vuint32_t CA5_PERIPH_DEBUG_DIS:1;  /* This field controls peripheral debug mode entry while CA5 is in debug mode */
    vuint32_t DAP_CLKEN:1;             /* This bit enables the DAP clock to core side debug components mainly used to configure debug components on APB-AP through Core */
    vuint32_t _unused_4:12;
    vuint32_t TCK_PULL_EN:1;           /* This bit controls the pull enable/disable of TCK pad */
    vuint32_t TCK_PULL_SEL:1;          /* This bit controls the pull select of TCK pad */
    vuint32_t TCK_SLEW_0:1;            /* This bit controls the slew rate of TCK pad */
    vuint32_t TCK_SLEW_1:1;            /* This bit controls the slew rate of TCK pad */
    vuint32_t TCK_HYS:1;               /* This bit controls the hysteresis TCK pad */
    vuint32_t TMS_PULL_EN:1;           /* This bit controls the pull enable/disable of TMS pad */
    vuint32_t TMS_PULL_SEL:1;          /* This bit controls the pull select of TMS pad */
    vuint32_t TMS_SLEW_0:1;            /* This bit controls the slew rate of TMS pad */
    vuint32_t TMS_SLEW_1:1;            /* This bit controls the slew rate of TMS pad */
    vuint32_t TMS_HYS:1;               /* This bit controls the hysteresis TMS pad */
    vuint32_t TDI_TDO_CONFIG:1;        /* Configure TDO and TDI */
    vuint32_t _unused_27:5;
  } B;
} MPR_DBGCTRL_tag;

typedef union MPR_MISC2_union_tag {    /* Miscellaneous Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;
    vuint32_t IOP_SLEEP_S:1;
    vuint32_t IOP_STOP_S:1;
    vuint32_t _unused_9:7;
    vuint32_t EOUT_EN_IOP:1;           /* EOUT signalling enable in IOP mode */
    vuint32_t _unused_17:2;
    vuint32_t DE_VIU:1;                /* Data endian control bit for VIU in RGB565 mode */
    vuint32_t _unused_20:4;
    vuint32_t IOP_PRAM_SBC:1;
    vuint32_t IOP_PRAM_NCE:1;
    vuint32_t IOP_PRAM_ESCIN:1;
    vuint32_t IOP_PRAM_ENCIN:1;
    vuint32_t _unused_28:3;
    vuint32_t NMI_UNMASK:1;            /* Unmask NMI at the start of the application */
  } B;
} MPR_MISC2_tag;

struct MPR_tag {
  MPR_CTRL0_tag CTRL0;                 /* Control Register 0 */
  MPR_DBGCTRL_tag DBGCTRL;             /* Debug Control Register */
  MPR_MISC2_tag MISC2;                 /* Miscellaneous Control Register */
};


/* ============================================================================
   =============================== Module: MSCM ===============================
   ============================================================================ */

typedef union MSCM_CPXTYPE_union_tag { /* Processor x Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CPXTYPE_tag;

typedef union MSCM_CPXNUM_union_tag {  /* Processor x Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:2;
    vuint32_t _unused_2:30;
  } B;
} MSCM_CPXNUM_tag;

typedef union MSCM_CPXMASTER_union_tag { /* Processor x Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CPXMASTER_tag;

typedef union MSCM_CPXCOUNT_union_tag { /* Processor x Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CPXCOUNT_tag;

typedef union MSCM_CPXCFG0_union_tag { /* Processor x Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CPXCFG0_tag;

typedef union MSCM_CPXCFG1_union_tag { /* Processor x Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CPXCFG1_tag;

typedef union MSCM_CPXCFG2_union_tag { /* Processor x Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CPXCFG2_tag;

typedef union MSCM_CPXCFG3_union_tag { /* Processor x Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CPXCFG3_tag;

typedef union MSCM_CP0TYPE_union_tag { /* Processor 0 Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CP0TYPE_tag;

typedef union MSCM_CP0NUM_union_tag {  /* Processor 0 Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP0NUM_tag;

typedef union MSCM_CP0MASTER_union_tag { /* Processor 0 Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CP0MASTER_tag;

typedef union MSCM_CP0COUNT_union_tag { /* Processor 0 Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP0COUNT_tag;

typedef union MSCM_CP0CFG0_union_tag { /* Processor 0 Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CP0CFG0_tag;

typedef union MSCM_CP0CFG1_union_tag { /* Processor 0 Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CP0CFG1_tag;

typedef union MSCM_CP0CFG2_union_tag { /* Processor 0 Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CP0CFG2_tag;

typedef union MSCM_CP0CFG3_union_tag { /* Processor 0 Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CP0CFG3_tag;

typedef union MSCM_CP1TYPE_union_tag { /* Processor 1 Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CP1TYPE_tag;

typedef union MSCM_CP1NUM_union_tag {  /* Processor 1 Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP1NUM_tag;

typedef union MSCM_CP1MASTER_union_tag { /* Processor 1 Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CP1MASTER_tag;

typedef union MSCM_CP1COUNT_union_tag { /* Processor 1 Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP1COUNT_tag;

typedef union MSCM_CP1CFG0_union_tag { /* Processor 1 Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CP1CFG0_tag;

typedef union MSCM_CP1CFG1_union_tag { /* Processor 1 Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CP1CFG1_tag;

typedef union MSCM_CP1CFG2_union_tag { /* Processor 1 Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CP1CFG2_tag;

typedef union MSCM_CP1CFG3_union_tag { /* Processor 1 Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CP1CFG3_tag;

typedef union MSCM_CP2TYPE_union_tag { /* Processor 2 Type Register */
  vuint32_t R;
  struct {
    vuint32_t RYPZ:8;
    vuint32_t PERSONALITY:24;
  } B;
} MSCM_CP2TYPE_tag;

typedef union MSCM_CP2NUM_union_tag {  /* Processor 2 Number Register */
  vuint32_t R;
  struct {
    vuint32_t CPN:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP2NUM_tag;

typedef union MSCM_CP2MASTER_union_tag { /* Processor 2 Master Number Register */
  vuint32_t R;
  struct {
    vuint32_t PPN:5;
    vuint32_t _unused_5:27;
  } B;
} MSCM_CP2MASTER_tag;

typedef union MSCM_CP2COUNT_union_tag { /* Processor 2 Count Register */
  vuint32_t R;
  struct {
    vuint32_t PCNT:1;
    vuint32_t _unused_1:31;
  } B;
} MSCM_CP2COUNT_tag;

typedef union MSCM_CP2CFG0_union_tag { /* Processor 2 Configuration 0 Register */
  vuint32_t R;
  struct {
    vuint32_t DCWY:8;
    vuint32_t DCSZ:8;
    vuint32_t ICWY:8;
    vuint32_t ICSZ:8;
  } B;
} MSCM_CP2CFG0_tag;

typedef union MSCM_CP2CFG1_union_tag { /* Processor 2 Configuration 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t L2WY:8;
    vuint32_t L2SZ:8;
  } B;
} MSCM_CP2CFG1_tag;

typedef union MSCM_CP2CFG2_union_tag { /* Processor 2 Configuration 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:7;
    vuint32_t TMUSZ:8;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:7;
    vuint32_t TMLSZ:8;
  } B;
} MSCM_CP2CFG2_tag;

typedef union MSCM_CP2CFG3_union_tag { /* Processor 2 Configuration 3 Register */
  vuint32_t R;
  struct {
    vuint32_t FPU:1;
    vuint32_t SIMD:1;
    vuint32_t JAZ:1;
    vuint32_t MMU:1;
    vuint32_t TZ:1;
    vuint32_t CMP:1;
    vuint32_t BB:1;
    vuint32_t _unused_7:1;
    vuint32_t SBP:2;
    vuint32_t _unused_10:22;
  } B;
} MSCM_CP2CFG3_tag;

typedef union MSCM_OCMDR_union_tag {   /* On-Chip Memory Descriptor Register */
  vuint32_t R;
  struct {
    vuint32_t OCMC0:4;                 /* OCMEM Control Field 1. This field (if used) defines the configuration of the on-chip memory. The field's functionality is dependent on the OCMT value. */
    vuint32_t OCMC1:4;
    vuint32_t OCMC2:4;
    vuint32_t OCMPU:1;
    vuint32_t OCMTZ:1;
    vuint32_t OCMT:2;
    vuint32_t LOCK:1;
    vuint32_t OCMW:3;
    vuint32_t _unused_20:4;
    vuint32_t OCMSZ:4;
    vuint32_t OCMSZH:1;
    vuint32_t _unused_29:2;
    vuint32_t V:1;
  } B;
} MSCM_OCMDR_tag;

typedef union MSCM_PFLT_EN_union_tag { /* Parity Fault Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCM_P_EFLT_EN:1;         /* Tightly Coupled Memory parity error fault enable */
    vuint32_t _unused_1:3;
    vuint32_t CODE_CP_EFLT_EN:1;       /* Code cache parity error fault enable */
    vuint32_t CODE_CP_COR_EN:1;        /* Code cache parity correction enable */
    vuint32_t _unused_6:2;
    vuint32_t SYS_CAP_EFLT_EN:1;       /* System cache parity error fault enable */
    vuint32_t SYS_CAP_CO_EN:1;         /* System cache parity correction enable */
    vuint32_t _unused_10:22;
  } B;
} MSCM_PFLT_EN_tag;

typedef union MSCM_IRCP0IR_union_tag { /* Interrupt Router CP0 Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;
    vuint32_t INT1:1;
    vuint32_t INT2:1;
    vuint32_t INT3:1;
    vuint32_t _unused_4:28;
  } B;
} MSCM_IRCP0IR_tag;

typedef union MSCM_IRCP1IR_union_tag { /* Interrupt Router CP1 Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;
    vuint32_t INT1:1;
    vuint32_t INT2:1;
    vuint32_t INT3:1;
    vuint32_t _unused_4:28;
  } B;
} MSCM_IRCP1IR_tag;

typedef union MSCM_IRCP2IR_union_tag { /* Interrupt Router CP2 Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;
    vuint32_t INT1:1;
    vuint32_t INT2:1;
    vuint32_t INT3:1;
    vuint32_t _unused_4:28;
  } B;
} MSCM_IRCP2IR_tag;

typedef union MSCM_IRCPGIR_union_tag { /* Interrupt Router CPU Generate Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t INTID:2;
    vuint32_t _unused_2:14;
    vuint32_t CPUTL:3;
    vuint32_t _unused_19:5;
    vuint32_t TLF:2;
    vuint32_t _unused_26:6;
  } B;
} MSCM_IRCPGIR_tag;

typedef union MSCM_IRSPRC_union_tag {  /* Interrupt Router Shared Peripheral Routing Control Register */
  vuint16_t R;
  struct {
    vuint16_t CP0E:1;
    vuint16_t CP1E:1;
    vuint16_t CP2E:1;
    vuint16_t _unused_3:12;
    vuint16_t RO:1;
  } B;
} MSCM_IRSPRC_tag;

typedef union MSCM_IAHBBE0_union_tag { /* Gasket Burst Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t BWE_IOP:1;
    vuint32_t BRE_IOP:1;
    vuint32_t PRE_IOP:1;
    vuint32_t _unused_3:5;
    vuint32_t BWE_DDR:1;
    vuint32_t BRE_DDR:1;
    vuint32_t PRE_DDR:1;
    vuint32_t _unused_11:5;
    vuint32_t BWE_MLB:1;
    vuint32_t BRE_MLB:1;
    vuint32_t PRE_MLB:1;
    vuint32_t _unused_19:5;
    vuint32_t BWE_PFL:1;
    vuint32_t BRE_PFL:1;
    vuint32_t PRE_PFL:1;
    vuint32_t _unused_27:5;
  } B;
} MSCM_IAHBBE0_tag;

typedef union MSCM_IAHBBE1_union_tag { /* Gasket Burst Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BWE_VIU:1;
    vuint32_t BRE_VIU:1;
    vuint32_t PRE_VIU:1;
    vuint32_t _unused_3:5;
    vuint32_t BWE_DMA:1;
    vuint32_t BRE_DMA:1;
    vuint32_t PRE_DMA:1;
    vuint32_t _unused_11:21;
  } B;
} MSCM_IAHBBE1_tag;

struct MSCM_tag {
  MSCM_CPXTYPE_tag CPXTYPE;            /* Processor x Type Register */
  MSCM_CPXNUM_tag CPXNUM;              /* Processor x Number Register */
  MSCM_CPXMASTER_tag CPXMASTER;        /* Processor x Master Number Register */
  MSCM_CPXCOUNT_tag CPXCOUNT;          /* Processor x Count Register */
  MSCM_CPXCFG0_tag CPXCFG0;            /* Processor x Configuration 0 Register */
  MSCM_CPXCFG1_tag CPXCFG1;            /* Processor x Configuration 1 Register */
  MSCM_CPXCFG2_tag CPXCFG2;            /* Processor x Configuration 2 Register */
  MSCM_CPXCFG3_tag CPXCFG3;            /* Processor x Configuration 3 Register */
  MSCM_CP0TYPE_tag CP0TYPE;            /* Processor 0 Type Register */
  MSCM_CP0NUM_tag CP0NUM;              /* Processor 0 Number Register */
  MSCM_CP0MASTER_tag CP0MASTER;        /* Processor 0 Master Number Register */
  MSCM_CP0COUNT_tag CP0COUNT;          /* Processor 0 Count Register */
  MSCM_CP0CFG0_tag CP0CFG0;            /* Processor 0 Configuration 0 Register */
  MSCM_CP0CFG1_tag CP0CFG1;            /* Processor 0 Configuration 1 Register */
  MSCM_CP0CFG2_tag CP0CFG2;            /* Processor 0 Configuration 2 Register */
  MSCM_CP0CFG3_tag CP0CFG3;            /* Processor 0 Configuration 3 Register */
  MSCM_CP1TYPE_tag CP1TYPE;            /* Processor 1 Type Register */
  MSCM_CP1NUM_tag CP1NUM;              /* Processor 1 Number Register */
  MSCM_CP1MASTER_tag CP1MASTER;        /* Processor 1 Master Number Register */
  MSCM_CP1COUNT_tag CP1COUNT;          /* Processor 1 Count Register */
  MSCM_CP1CFG0_tag CP1CFG0;            /* Processor 1 Configuration 0 Register */
  MSCM_CP1CFG1_tag CP1CFG1;            /* Processor 1 Configuration 1 Register */
  MSCM_CP1CFG2_tag CP1CFG2;            /* Processor 1 Configuration 2 Register */
  MSCM_CP1CFG3_tag CP1CFG3;            /* Processor 1 Configuration 3 Register */
  MSCM_CP2TYPE_tag CP2TYPE;            /* Processor 2 Type Register */
  MSCM_CP2NUM_tag CP2NUM;              /* Processor 2 Number Register */
  MSCM_CP2MASTER_tag CP2MASTER;        /* Processor 2 Master Number Register */
  MSCM_CP2COUNT_tag CP2COUNT;          /* Processor 2 Count Register */
  MSCM_CP2CFG0_tag CP2CFG0;            /* Processor 2 Configuration 0 Register */
  MSCM_CP2CFG1_tag CP2CFG1;            /* Processor 2 Configuration 1 Register */
  MSCM_CP2CFG2_tag CP2CFG2;            /* Processor 2 Configuration 2 Register */
  MSCM_CP2CFG3_tag CP2CFG3;            /* Processor 2 Configuration 3 Register */
  uint8_t MSCM_reserved0[896];
  MSCM_OCMDR_tag OCMDR[4];             /* On-Chip Memory Descriptor Register */
  uint8_t MSCM_reserved1[240];
  MSCM_PFLT_EN_tag PFLT_EN;            /* Parity Fault Enable Register */
  uint8_t MSCM_reserved2[764];
  MSCM_IRCP0IR_tag IRCP0IR;            /* Interrupt Router CP0 Interrupt Register */
  MSCM_IRCP1IR_tag IRCP1IR;            /* Interrupt Router CP1 Interrupt Register */
  MSCM_IRCP2IR_tag IRCP2IR;            /* Interrupt Router CP2 Interrupt Register */
  uint8_t MSCM_reserved3[20];
  MSCM_IRCPGIR_tag IRCPGIR;            /* Interrupt Router CPU Generate Interrupt Register */
  uint8_t MSCM_reserved4[92];
  MSCM_IRSPRC_tag IRSPRC[112];         /* Interrupt Router Shared Peripheral Routing Control Register */
  uint8_t MSCM_reserved5[672];
  MSCM_IAHBBE0_tag IAHBBE0;            /* Gasket Burst Enable Register 0 */
  MSCM_IAHBBE1_tag IAHBBE1;            /* Gasket Burst Enable Register 1 */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t LIFE:3;
    vuint32_t _unused_3:26;
    vuint32_t _unused_29:1;
    vuint32_t JUN:1;
    vuint32_t CNS:1;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t GRP:2;
    vuint32_t _unused_2:30;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t CMST:4;
    vuint32_t _unused_4:28;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t MIDLOCK:16;
    vuint32_t LOWLOCK:14;
    vuint32_t ATSL:1;
    vuint32_t TSLOCK:1;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t HIGHLOCK:16;
    vuint32_t _unused_16:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t U_256LCK:16;
    vuint32_t RL0:1;
    vuint32_t RL1:1;
    vuint32_t RL2:1;
    vuint32_t RL3:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:3;
    vuint32_t MSTR:4;
    vuint32_t _unused_28:1;
    vuint32_t MO:1;
    vuint32_t DBL:1;
    vuint32_t PGL:1;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_BFEN:1;
    vuint32_t P0_PFLIM:2;
    vuint32_t _unused_3:1;
    vuint32_t P0_IPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P0_DPFEN:1;
    vuint32_t _unused_7:1;
    vuint32_t RWSC:5;
    vuint32_t APC:3;
    vuint32_t P0_M0PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M15PFE:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_BFEN:1;
    vuint32_t P1_PFLIM:2;
    vuint32_t _unused_3:1;
    vuint32_t P1_IPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P1_DPFEN:1;
    vuint32_t _unused_7:9;
    vuint32_t P1_M0PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M15PFE:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:11;
    vuint32_t _unused_12:2;
    vuint32_t ARBM:2;
    vuint32_t BAF_DIS:1;
    vuint32_t _unused_17:3;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:5;
    vuint32_t _unused_26:2;
    vuint32_t P1_WCFG:2;
    vuint32_t P0_WCFG:2;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M15AP:2;
    vuint32_t M14AP:2;
    vuint32_t M13AP:2;
    vuint32_t M12AP:2;
    vuint32_t M11AP:2;
    vuint32_t M10AP:2;
    vuint32_t M9AP:2;
    vuint32_t M8AP:2;
    vuint32_t M7AP:2;
    vuint32_t M6AP:2;
    vuint32_t M5AP:2;
    vuint32_t M4AP:2;
    vuint32_t M3AP:2;
    vuint32_t M2AP:2;
    vuint32_t M1AP:2;
    vuint32_t M0AP:2;
  } B;
} PFLASH_PFAPR_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:29;
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t TEN:1;                   /* Timer Enable */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t _unused_3:29;
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[220];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint8_t PIT_reserved1[24];
  PIT_TIMER_tag TIMER[8];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLLCAL3_union_tag { /* PLL Calibration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:14;
    vuint32_t MFDEN:16;                /* Denominator of fractional loop division factor. */
    vuint32_t _unused_30:2;
  } B;
} PLLDIG_PLLCAL3_tag;

typedef union PLLDIG_PLLCR_union_tag { /* PLLDIG PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t EXPDIE:1;                /* External Power Down Cycle Complete indication interrupt enable. */
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:21;
  } B;
} PLLDIG_PLLCR_tag;

typedef union PLLDIG_PLLSR_union_tag { /* PLLDIG PLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t _unused_1:1;
    vuint32_t LOCK:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t EXTPDF:1;
    vuint32_t ENPHI:1;                 /* PLL PHI Output Enable */
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:22;
  } B;
} PLLDIG_PLLSR_tag;

typedef union PLLDIG_PLLDV_union_tag { /* PLLDIG PLL Divider Register */
  vuint32_t R;
  struct {
    vuint32_t MFD:8;                   /* Loop multiplication factor divider. */
    vuint32_t _unused_8:3;
    vuint32_t _unused_11:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_15:1;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_22:10;
  } B;
} PLLDIG_PLLDV_tag;

typedef union PLLDIG_PLLFM_union_tag { /* PLLDIG PLL Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t INCSTP:11;               /* Increment step. */
    vuint32_t _unused_11:5;
    vuint32_t MODPRD:10;               /* Modulation period. */
    vuint32_t _unused_26:3;
    vuint32_t _unused_29:1;
    vuint32_t SSCGBYP:1;               /* Modulation enable. */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLFM_tag;

typedef union PLLDIG_PLLFD_union_tag { /* PLLDIG PLL Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t MFN:15;
    vuint32_t _unused_15:1;
    vuint32_t DTHDIS:2;                /* Dither Disable. */
    vuint32_t DTHRCTL:4;               /* Dither Control. */
    vuint32_t _unused_22:6;
    vuint32_t SDM3:1;                  /* Third Order Sigma Delta Modulation Select */
    vuint32_t SDM2:1;                  /* Second Order Sigma Delta Modulation Select */
    vuint32_t SMDEN:1;                 /* Sigma Delta Modulation Enable */
    vuint32_t _unused_31:1;
  } B;
} PLLDIG_PLLFD_tag;

struct PLLDIG_tag {
  uint8_t PLLDIG_reserved0[24];
  PLLDIG_PLLCAL3_tag PLLCAL3;          /* PLL Calibration Register 3 */
  uint8_t PLLDIG_reserved1[4];
  PLLDIG_PLLCR_tag PLLCR;              /* PLLDIG PLL Control Register */
  PLLDIG_PLLSR_tag PLLSR;              /* PLLDIG PLL Status Register */
  PLLDIG_PLLDV_tag PLLDV;              /* PLLDIG PLL Divider Register */
  PLLDIG_PLLFM_tag PLLFM;              /* PLLDIG PLL Frequency Modulation Register */
  PLLDIG_PLLFD_tag PLLFD;              /* PLLDIG PLL Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

typedef union PMCDIG_RDCR_union_tag {  /* RAM Domain Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RD24_RET:1;              /* RAM Domain 24K Retention */
    vuint32_t _unused_1:3;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:3;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:7;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:3;
    vuint32_t MEM_SLEEP_EN:1;          /* Memory Sleep Enable */
    vuint32_t _unused_21:11;
  } B;
} PMCDIG_RDCR_tag;

typedef union PMCDIG_SGSR_union_tag {  /* Supply Gauge Status Register */
  vuint32_t R;
  struct {
    vuint32_t POR_LV:1;                /* Power On Reset Flag */
    vuint32_t LVD_LV_PD2_HOT:1;        /* LVD LV_PD2 hot Point Flag */
    vuint32_t LVD_LV_PD2_COLD:1;       /* LVD_LV_PD2 Cold Point Flag */
    vuint32_t LVD_LV_PD1_hot:1;        /* LVD VDD_LV PD1 hot point Flag */
    vuint32_t LVD_LV_PD0_hot:1;        /* LVD VDD_LV PD0 hot point Flag */
    vuint32_t LVD_IO_A_LO:1;           /* LVD IO Segment A Low Flag */
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t HVD_LV_COLD:1;           /* HVD LV PD2 Flag */
    vuint32_t _unused_10:1;
    vuint32_t LP_STATUS:2;             /* Low Power Status */
    vuint32_t _unused_13:19;
  } B;
} PMCDIG_SGSR_tag;

typedef union PMCDIG_MCR_union_tag {   /* MISC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t _unused_3:5;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t HVD_REE:1;               /* HVD Reset Event Enable */
    vuint32_t LVD_PD2_COLD_REE:1;      /* LVD_PD2 Cold Point Flag Reset Event Enable */
    vuint32_t _unused_12:3;
    vuint32_t FLASH_LP_FAST_EXIT_DIS:1; /* Flash Low Power Fast Exit Disable */
    vuint32_t LP_ST_CHG_IN_PRGRS:1;    /* Low Power State Change in Progress */
    vuint32_t SIG_TO_ADC_SEL:4;        /* Signal to ADC Select */
    vuint32_t _unused_21:3;
    vuint32_t _unused_24:1;
    vuint32_t _unused_25:3;
    vuint32_t ISO_ACK0:1;              /* Software controlled Retention on IOP Standby Entry and Exit. */
    vuint32_t ISO_ACK1:1;              /* Software controlled Retention on Standby Entry and Exit. */
    vuint32_t ISO_ACK2:1;              /* Software controlled Retention on IOP RUN Entry and Exit. */
    vuint32_t _unused_31:1;
  } B;
} PMCDIG_MCR_tag;

struct PMCDIG_tag {
  PMCDIG_RDCR_tag RDCR;                /* RAM Domain Configuration Register */
  PMCDIG_SGSR_tag SGSR;                /* Supply Gauge Status Register */
  uint8_t PMCDIG_reserved0[8];
  PMCDIG_MCR_tag MCR;                  /* MISC Control Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
    vuint32_t _unused_1:5;
    vuint32_t _unused_6:2;
    vuint32_t PRI:2;                   /* AHB port arbitration mode. */
    vuint32_t _unused_10:22;
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: QuadSPI ============================
   ============================================================================ */

typedef union QuadSPI_MCR_union_tag {  /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRSTSD:1;
    vuint32_t SWRSTHD:1;
    vuint32_t END_CFG:2;
    vuint32_t _unused_4:1;
    vuint32_t DQS_LAT_EN:1;
    vuint32_t DQS_EN:1;
    vuint32_t DDR_EN:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t CLR_RXF:1;
    vuint32_t CLR_TXF:1;
    vuint32_t _unused_12:2;
    vuint32_t MDIS:1;
    vuint32_t DOZE:1;
    vuint32_t _unused_16:4;
    vuint32_t _unused_20:4;
    vuint32_t SCLKCFG:8;
  } B;
} QuadSPI_MCR_tag;

typedef union QuadSPI_IPCR_union_tag { /* IP Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t IDATSZ:16;
    vuint32_t PAR_EN:1;
    vuint32_t _unused_17:7;
    vuint32_t SEQID:4;
    vuint32_t _unused_28:4;
  } B;
} QuadSPI_IPCR_tag;

typedef union QuadSPI_FLSHCR_union_tag { /* Flash Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCSS:4;
    vuint32_t _unused_4:4;
    vuint32_t TCSH:4;
    vuint32_t _unused_12:4;
    vuint32_t TDH:2;
    vuint32_t _unused_18:14;
  } B;
} QuadSPI_FLSHCR_tag;

typedef union QuadSPI_BUF0CR_union_tag { /* Buffer0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:4;
    vuint32_t _unused_4:4;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:15;
    vuint32_t HP_EN:1;
  } B;
} QuadSPI_BUF0CR_tag;

typedef union QuadSPI_BUF1CR_union_tag { /* Buffer1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:4;
    vuint32_t _unused_4:4;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_BUF1CR_tag;

typedef union QuadSPI_BUF2CR_union_tag { /* Buffer2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:4;
    vuint32_t _unused_4:4;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_BUF2CR_tag;

typedef union QuadSPI_BUF3CR_union_tag { /* Buffer3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTRID:4;
    vuint32_t _unused_4:4;
    vuint32_t ADATSZ:8;                /* AHB data transfer size */
    vuint32_t _unused_16:15;
    vuint32_t ALLMST:1;
  } B;
} QuadSPI_BUF3CR_tag;

typedef union QuadSPI_BFGENCR_union_tag { /* Buffer Generic Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t SEQID:4;
    vuint32_t PAR_EN:1;
    vuint32_t _unused_17:15;
  } B;
} QuadSPI_BFGENCR_tag;

typedef union QuadSPI_SOCCR_union_tag { /* SOC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SOCCFG:32;
  } B;
} QuadSPI_SOCCR_tag;

typedef union QuadSPI_BUF0IND_union_tag { /* Buffer0 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX0:29;
  } B;
} QuadSPI_BUF0IND_tag;

typedef union QuadSPI_BUF1IND_union_tag { /* Buffer1 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX1:29;
  } B;
} QuadSPI_BUF1IND_tag;

typedef union QuadSPI_BUF2IND_union_tag { /* Buffer2 Top Index Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t TPINDX2:29;
  } B;
} QuadSPI_BUF2IND_tag;

typedef union QuadSPI_SFAR_union_tag { /* Serial Flash Address Register */
  vuint32_t R;
  struct {
    vuint32_t SFADR:32;
  } B;
} QuadSPI_SFAR_tag;

typedef union QuadSPI_SFACR_union_tag { /* Serial Flash Address Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CAS:4;                   /* Column Address Space */
    vuint32_t _unused_4:12;
    vuint32_t WA:1;                    /* Word Addressable */
    vuint32_t _unused_17:15;
  } B;
} QuadSPI_SFACR_tag;

typedef union QuadSPI_SMPR_union_tag { /* Sampling Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t _unused_3:2;
    vuint32_t FSPHS:1;                 /* Full Speed Phase selection for SDR instructions. */
    vuint32_t FSDLY:1;                 /* Full Speed Delay selection for SDR instructions. Select the delay with respect to the reference edge for the sample point valid for full speed commands. */
    vuint32_t _unused_7:9;
    vuint32_t DDRSMP:3;                /* DDR Sampling point */
    vuint32_t _unused_19:13;
  } B;
} QuadSPI_SMPR_tag;

typedef union QuadSPI_RBSR_union_tag { /* RX Buffer Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t RDBFL:6;
    vuint32_t _unused_14:2;
    vuint32_t RDCTR:16;
  } B;
} QuadSPI_RBSR_tag;

typedef union QuadSPI_RBCT_union_tag { /* RX Buffer Control Register */
  vuint32_t R;
  struct {
    vuint32_t WMRK:5;
    vuint32_t _unused_5:3;
    vuint32_t RXBRD:1;
    vuint32_t _unused_9:23;
  } B;
} QuadSPI_RBCT_tag;

typedef union QuadSPI_TBSR_union_tag { /* TX Buffer Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t TRBFL:6;
    vuint32_t _unused_14:2;
    vuint32_t TRCTR:16;
  } B;
} QuadSPI_TBSR_tag;

typedef union QuadSPI_TBDR_union_tag { /* TX Buffer Data Register */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:32;
  } B;
} QuadSPI_TBDR_tag;

typedef union QuadSPI_TBCT_union_tag { /* Tx Buffer Control Register */
  vuint32_t R;
  struct {
    vuint32_t WMRK:5;
    vuint32_t _unused_5:27;
  } B;
} QuadSPI_TBCT_tag;

typedef union QuadSPI_SR_union_tag {   /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t BUSY:1;
    vuint32_t IP_ACC:1;
    vuint32_t AHB_ACC:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t AHBGNT:1;
    vuint32_t AHBTRN:1;
    vuint32_t AHB0NE:1;
    vuint32_t AHB1NE:1;
    vuint32_t AHB2NE:1;
    vuint32_t AHB3NE:1;
    vuint32_t AHB0FUL:1;
    vuint32_t AHB1FUL:1;
    vuint32_t AHB2FUL:1;
    vuint32_t AHB3FUL:1;
    vuint32_t _unused_15:1;
    vuint32_t RXWE:1;
    vuint32_t _unused_17:2;
    vuint32_t RXFULL:1;
    vuint32_t _unused_20:3;
    vuint32_t RXDMA:1;
    vuint32_t TXEDA:1;                 /* Tx Buffer Enough Data Available */
    vuint32_t TXWA:1;                  /* TX Buffer watermark Available */
    vuint32_t TXDMA:1;                 /* TXDMA */
    vuint32_t TXFULL:1;
    vuint32_t _unused_28:1;
    vuint32_t DLPSMP:3;
  } B;
} QuadSPI_SR_tag;

typedef union QuadSPI_FR_union_tag {   /* Flag Register */
  vuint32_t R;
  struct {
    vuint32_t TFF:1;
    vuint32_t _unused_1:3;
    vuint32_t IPGEF:1;
    vuint32_t _unused_5:1;
    vuint32_t IPIEF:1;
    vuint32_t IPAEF:1;
    vuint32_t _unused_8:3;
    vuint32_t IUEF:1;
    vuint32_t ABOF:1;
    vuint32_t AIBSEF:1;
    vuint32_t AITEF:1;
    vuint32_t ABSEF:1;
    vuint32_t RBDF:1;
    vuint32_t RBOF:1;
    vuint32_t _unused_18:5;
    vuint32_t ILLINE:1;
    vuint32_t _unused_24:2;
    vuint32_t TBUF:1;
    vuint32_t TBFF:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:2;
    vuint32_t DLPFF:1;
  } B;
} QuadSPI_FR_tag;

typedef union QuadSPI_RSER_union_tag { /* Interrupt and DMA Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TFIE:1;
    vuint32_t _unused_1:3;
    vuint32_t IPGEIE:1;
    vuint32_t _unused_5:1;
    vuint32_t IPIEIE:1;
    vuint32_t IPAEIE:1;
    vuint32_t _unused_8:3;
    vuint32_t IUEIE:1;
    vuint32_t ABOIE:1;
    vuint32_t AIBSIE:1;
    vuint32_t AITIE:1;
    vuint32_t ABSEIE:1;
    vuint32_t RBDIE:1;
    vuint32_t RBOIE:1;
    vuint32_t _unused_18:3;
    vuint32_t RBDDE:1;
    vuint32_t _unused_22:1;
    vuint32_t ILLINIE:1;
    vuint32_t _unused_24:1;
    vuint32_t TBFDE:1;                 /* TX Buffer Fill DMA Enable */
    vuint32_t TBUIE:1;
    vuint32_t TBFIE:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:2;
    vuint32_t DLPFIE:1;
  } B;
} QuadSPI_RSER_tag;

typedef union QuadSPI_SPNDST_union_tag { /* Sequence Suspend Status Register */
  vuint32_t R;
  struct {
    vuint32_t SUSPND:1;
    vuint32_t _unused_1:5;
    vuint32_t SPDBUF:2;
    vuint32_t _unused_8:1;
    vuint32_t DATLFT:7;
    vuint32_t _unused_16:16;
  } B;
} QuadSPI_SPNDST_tag;

typedef union QuadSPI_SPTRCLR_union_tag { /* Sequence Pointer Clear Register */
  vuint32_t R;
  struct {
    vuint32_t BFPTRC:1;
    vuint32_t _unused_1:7;
    vuint32_t IPPTRC:1;
    vuint32_t _unused_9:23;
  } B;
} QuadSPI_SPTRCLR_tag;

typedef union QuadSPI_SFA1AD_union_tag { /* Serial Flash A1 Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADA1:22;
  } B;
} QuadSPI_SFA1AD_tag;

typedef union QuadSPI_SFA2AD_union_tag { /* Serial Flash A2 Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADA2:22;
  } B;
} QuadSPI_SFA2AD_tag;

typedef union QuadSPI_SFB1AD_union_tag { /* Serial Flash B1Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADB1:22;
  } B;
} QuadSPI_SFB1AD_tag;

typedef union QuadSPI_SFB2AD_union_tag { /* Serial Flash B2Top Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:10;
    vuint32_t TPADB2:22;
  } B;
} QuadSPI_SFB2AD_tag;

typedef union QuadSPI_DLPR_union_tag { /* Data Learn Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DLPV:32;
  } B;
} QuadSPI_DLPR_tag;

typedef union QuadSPI_RBDR_union_tag { /* RX Buffer Data Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;
  } B;
} QuadSPI_RBDR_tag;

typedef union QuadSPI_LUTKEY_union_tag { /* LUT Key Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:32;
  } B;
} QuadSPI_LUTKEY_tag;

typedef union QuadSPI_LCKCR_union_tag { /* LUT Lock Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LOCK:1;
    vuint32_t UNLOCK:1;
    vuint32_t _unused_2:30;
  } B;
} QuadSPI_LCKCR_tag;

typedef union QuadSPI_LUT_union_tag {  /* Look-up Table register */
  vuint32_t R;
  struct {
    vuint32_t OPRND0:8;                /* Operand for INSTR0. */
    vuint32_t PAD0:2;                  /* Pad information for INSTR0. */
    vuint32_t INSTR0:6;                /* Instruction 0 */
    vuint32_t OPRND1:8;                /* Operand for INSTR1. */
    vuint32_t PAD1:2;                  /* Pad information for INSTR1. */
    vuint32_t INSTR1:6;                /* Instruction 1 */
  } B;
} QuadSPI_LUT_tag;

struct QuadSPI_tag {
  QuadSPI_MCR_tag MCR;                 /* Module Configuration Register */
  uint8_t QuadSPI_reserved0[4];
  QuadSPI_IPCR_tag IPCR;               /* IP Configuration Register */
  QuadSPI_FLSHCR_tag FLSHCR;           /* Flash Configuration Register */
  QuadSPI_BUF0CR_tag BUF0CR;           /* Buffer0 Configuration Register */
  QuadSPI_BUF1CR_tag BUF1CR;           /* Buffer1 Configuration Register */
  QuadSPI_BUF2CR_tag BUF2CR;           /* Buffer2 Configuration Register */
  QuadSPI_BUF3CR_tag BUF3CR;           /* Buffer3 Configuration Register */
  QuadSPI_BFGENCR_tag BFGENCR;         /* Buffer Generic Configuration Register */
  QuadSPI_SOCCR_tag SOCCR;             /* SOC Configuration Register */
  uint8_t QuadSPI_reserved1[8];
  QuadSPI_BUF0IND_tag BUF0IND;         /* Buffer0 Top Index Register */
  QuadSPI_BUF1IND_tag BUF1IND;         /* Buffer1 Top Index Register */
  QuadSPI_BUF2IND_tag BUF2IND;         /* Buffer2 Top Index Register */
  uint8_t QuadSPI_reserved2[196];
  QuadSPI_SFAR_tag SFAR;               /* Serial Flash Address Register */
  QuadSPI_SFACR_tag SFACR;             /* Serial Flash Address Configuration Register */
  QuadSPI_SMPR_tag SMPR;               /* Sampling Register */
  QuadSPI_RBSR_tag RBSR;               /* RX Buffer Status Register */
  QuadSPI_RBCT_tag RBCT;               /* RX Buffer Control Register */
  uint8_t QuadSPI_reserved3[60];
  QuadSPI_TBSR_tag TBSR;               /* TX Buffer Status Register */
  QuadSPI_TBDR_tag TBDR;               /* TX Buffer Data Register */
  QuadSPI_TBCT_tag TBCT;               /* Tx Buffer Control Register */
  QuadSPI_SR_tag SR;                   /* Status Register */
  QuadSPI_FR_tag FR;                   /* Flag Register */
  QuadSPI_RSER_tag RSER;               /* Interrupt and DMA Request Select and Enable Register */
  QuadSPI_SPNDST_tag SPNDST;           /* Sequence Suspend Status Register */
  QuadSPI_SPTRCLR_tag SPTRCLR;         /* Sequence Pointer Clear Register */
  uint8_t QuadSPI_reserved4[16];
  QuadSPI_SFA1AD_tag SFA1AD;           /* Serial Flash A1 Top Address */
  QuadSPI_SFA2AD_tag SFA2AD;           /* Serial Flash A2 Top Address */
  QuadSPI_SFB1AD_tag SFB1AD;           /* Serial Flash B1Top Address */
  QuadSPI_SFB2AD_tag SFB2AD;           /* Serial Flash B2Top Address */
  QuadSPI_DLPR_tag DLPR;               /* Data Learn Pattern Register */
  uint8_t QuadSPI_reserved5[108];
  QuadSPI_RBDR_tag RBDR[32];           /* RX Buffer Data Register */
  uint8_t QuadSPI_reserved6[128];
  QuadSPI_LUTKEY_tag LUTKEY;           /* LUT Key Register */
  QuadSPI_LCKCR_tag LCKCR;             /* LUT Lock Configuration Register */
  uint8_t QuadSPI_reserved7[8];
  QuadSPI_LUT_tag LUT[64];             /* Look-up Table register */
};


/* ============================================================================
   =============================== Module: RLE_DEC ============================
   ============================================================================ */

typedef union RLE_DEC_MCR_union_tag {  /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;
    vuint32_t _unused_1:1;             /* This bit should not be written by the user. Writes to a reserved location can result in unpredictable functionality or behavior. */
    vuint32_t TXFFEN:1;
    vuint32_t GRLE_EN:1;               /* Enable Gradient RLE decoding */
    vuint32_t _unused_4:12;
    vuint32_t TX_FIFO_THRESHOLD:6;
    vuint32_t _unused_22:2;
    vuint32_t RX_FIFO_THRESHOLD:6;
    vuint32_t _unused_30:2;
  } B;
} RLE_DEC_MCR_tag;

typedef union RLE_DEC_ICR_union_tag {  /* Image Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t WIDTH:2;
    vuint32_t _unused_2:2;
    vuint32_t _unused_4:28;
  } B;
} RLE_DEC_ICR_tag;

typedef union RLE_DEC_CISR_union_tag { /* Compressed Image Size Register */
  vuint32_t R;
  struct {
    vuint32_t SIZE:32;
  } B;
} RLE_DEC_CISR_tag;

typedef union RLE_DEC_DICR_union_tag { /* Decompressed Image Co-ordinates register */
  vuint32_t R;
  struct {
    vuint32_t Y:16;
    vuint32_t X:16;
  } B;
} RLE_DEC_DICR_tag;

typedef union RLE_DEC_SR_union_tag {   /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TXFILL:8;
    vuint32_t RXFREE:8;
    vuint32_t _unused_16:16;
  } B;
} RLE_DEC_SR_tag;

typedef union RLE_DEC_ISR_union_tag {  /* Interrupt Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t TXEIF:1;
    vuint32_t RXEIF:1;
    vuint32_t TXFIF:1;
    vuint32_t RXFIF:1;
    vuint32_t TXUIF:1;
    vuint32_t RXUIF:1;
    vuint32_t TXDIF:1;
    vuint32_t RXDIF:1;
    vuint32_t _unused_8:24;
  } B;
} RLE_DEC_ISR_tag;

typedef union RLE_DEC_RIER_union_tag { /* Interrupt Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TXEIE:1;
    vuint32_t RXEIE:1;
    vuint32_t TXFIE:1;
    vuint32_t RXFIE:1;
    vuint32_t TXUIE:1;
    vuint32_t RXUIE:1;
    vuint32_t TXDIE:1;
    vuint32_t RXDIE:1;
    vuint32_t _unused_8:24;
  } B;
} RLE_DEC_RIER_tag;

typedef union RLE_DEC_SPCR_union_tag { /* Start Pixel Co-ordinate Register of Image */
  vuint32_t R;
  struct {
    vuint32_t Y:16;
    vuint32_t X:16;
  } B;
} RLE_DEC_SPCR_tag;

typedef union RLE_DEC_EPCR_union_tag { /* End Pixel Co-ordinate Register of Image */
  vuint32_t R;
  struct {
    vuint32_t Y:16;
    vuint32_t X:16;
  } B;
} RLE_DEC_EPCR_tag;

struct RLE_DEC_tag {
  RLE_DEC_MCR_tag MCR;                 /* Module Configuration Register */
  RLE_DEC_ICR_tag ICR;                 /* Image Configuration Register */
  RLE_DEC_CISR_tag CISR;               /* Compressed Image Size Register */
  RLE_DEC_DICR_tag DICR;               /* Decompressed Image Co-ordinates register */
  RLE_DEC_SR_tag SR;                   /* Status Register */
  RLE_DEC_ISR_tag ISR;                 /* Interrupt Request Status Register */
  RLE_DEC_RIER_tag RIER;               /* Interrupt Request Enable Register */
  RLE_DEC_SPCR_tag SPCR;               /* Start Pixel Co-ordinate Register of Image */
  RLE_DEC_EPCR_tag EPCR;               /* End Pixel Co-ordinate Register of Image */
};


/* ============================================================================
   =============================== Module: RTC ================================
   ============================================================================ */

typedef union RTC_CTRL_union_tag {     /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t SSECEN:1;                /* Sub second interrupt enable */
    vuint32_t SECEN:1;                 /* Second interrupt enable */
    vuint32_t MINEN:1;                 /* Minute interrupt enable */
    vuint32_t HOUREN:1;                /* Hour interrupt enable */
    vuint32_t DAYEN:1;                 /* Day interrupt enable */
    vuint32_t WKPEN:1;                 /* Wakeup interrupt enable */
    vuint32_t _unused_8:1;
    vuint32_t CLKSEL:1;                /* Clock select */
    vuint32_t _unused_10:2;
    vuint32_t FRZEN:1;
    vuint32_t _unused_13:1;
    vuint32_t APIIE:1;                 /* API Interrupt Enable */
    vuint32_t APIEN:1;                 /* Autonomous Periodic Interrupt Enable */
    vuint32_t PREDIV:6;                /* Pre division value */
    vuint32_t SCLKSEL:2;               /* Sub clock select */
    vuint32_t _unused_24:1;
    vuint32_t TRIGEN:1;
    vuint32_t ANL_TRIG_EN:1;           /* Trigger enable for Analog Comparator */
    vuint32_t _unused_27:1;
    vuint32_t WKP_CLK_SEL:1;           /* Wakep clock select */
    vuint32_t WKP_RES:2;               /* Wake up resolution */
    vuint32_t RTCEN:1;                 /* RTC enable */
  } B;
} RTC_CTRL_tag;

typedef union RTC_STATUS_union_tag {   /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t SSECF:1;                 /* Sub second interrupt flag */
    vuint32_t SECF:1;                  /* Second interrupt flag */
    vuint32_t MINF:1;                  /* Minute interrupt flag */
    vuint32_t HOURF:1;                 /* Hour interrupt flag */
    vuint32_t DAYF:1;                  /* Day interrupt flag */
    vuint32_t WKPF:1;                  /* Wakeup interrupt flag */
    vuint32_t _unused_8:7;
    vuint32_t APIF:1;                  /* API Interrupt Flag. */
    vuint32_t INVAL_API_WR:1;          /* Invalid New API write */
    vuint32_t INVAL_WKP_WR:1;          /* Invalid new wakeup period write */
    vuint32_t INVAL_ANL_WR:1;          /* Invalid new analog comparator value write */
    vuint32_t _unused_19:13;
  } B;
} RTC_STATUS_tag;

typedef union RTC_COR_VAL_union_tag {  /* Correction Value Register */
  vuint32_t R;
  struct {
    vuint32_t SCVAL:25;                /* Sub clock correction val */
    vuint32_t _unused_25:7;
  } B;
} RTC_COR_VAL_tag;

typedef union RTC_WKEUP_union_tag {    /* Wakeup Val */
  vuint32_t R;
  struct {
    vuint32_t WKP_PER:32;              /* Wake up period */
  } B;
} RTC_WKEUP_tag;

typedef union RTC_WKEUP_CNT_union_tag { /* Wakeup Count Value */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Wakeup counter's current value */
  } B;
} RTC_WKEUP_CNT_tag;

typedef union RTC_TOD_union_tag {      /* Time of Day Register */
  vuint32_t R;
  struct {
    vuint32_t HOUR_CNT:5;              /* Hour count value */
    vuint32_t _unused_5:3;
    vuint32_t MIN_CNT:6;               /* Minutes count value */
    vuint32_t _unused_14:2;
    vuint32_t SEC_CNT:6;               /* Seconds count value. */
    vuint32_t _unused_22:10;
  } B;
} RTC_TOD_tag;

typedef union RTC_SCCPRSC_union_tag {  /* Sub Clock Correction Prescaler */
  vuint32_t R;
  struct {
    vuint32_t SPRESCLV:32;             /* Sub clock correction prescaler value */
  } B;
} RTC_SCCPRSC_tag;

typedef union RTC_APIVAL_union_tag {   /* APIVAL Register */
  vuint32_t R;
  struct {
    vuint32_t APIVAL:32;
  } B;
} RTC_APIVAL_tag;

typedef union RTC_ANLCMP_union_tag {   /* Analog Comparator Count Register */
  vuint32_t R;
  struct {
    vuint32_t CMP_VAL:32;
  } B;
} RTC_ANLCMP_tag;

struct RTC_tag {
  RTC_CTRL_tag CTRL;                   /* Control Register */
  RTC_STATUS_tag STATUS;               /* Status Register */
  RTC_COR_VAL_tag COR_VAL;             /* Correction Value Register */
  RTC_WKEUP_tag WKEUP;                 /* Wakeup Val */
  RTC_WKEUP_CNT_tag WKEUP_CNT;         /* Wakeup Count Value */
  RTC_TOD_tag TOD;                     /* Time of Day Register */
  RTC_SCCPRSC_tag SCCPRSC;             /* Sub Clock Correction Prescaler */
  RTC_APIVAL_tag APIVAL;               /* APIVAL Register */
  RTC_ANLCMP_tag ANLCMP;               /* Analog Comparator Count Register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE3_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE3_tag;

typedef union SEMA42_GATE2_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE2_tag;

typedef union SEMA42_GATE1_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE1_tag;

typedef union SEMA42_GATE0_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE0_tag;

typedef union SEMA42_GATE7_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE7_tag;

typedef union SEMA42_GATE6_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE6_tag;

typedef union SEMA42_GATE5_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE5_tag;

typedef union SEMA42_GATE4_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE4_tag;

typedef union SEMA42_GATE11_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE11_tag;

typedef union SEMA42_GATE10_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE10_tag;

typedef union SEMA42_GATE9_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE9_tag;

typedef union SEMA42_GATE8_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE8_tag;

typedef union SEMA42_GATE15_union_tag { /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE15_tag;

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
    vuint8_t _unused_4:4;
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t RSTGTN:8;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGSM:2;
    vuint16_t _unused_14:2;
  } B;
} SEMA42_RSTGT_RSTGT_R_tag;

typedef union SEMA42_RSTGT_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGTN:8;
    vuint16_t RSTGDP:8;
  } B;
} SEMA42_RSTGT_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_RSTGT_R_tag RSTGT_R;    /* Reset Gate Read */
  SEMA42_RSTGT_RSTGT_W_tag RSTGT_W;    /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE3_tag GATE3;              /* Gate Register */
  SEMA42_GATE2_tag GATE2;              /* Gate Register */
  SEMA42_GATE1_tag GATE1;              /* Gate Register */
  SEMA42_GATE0_tag GATE0;              /* Gate Register */
  SEMA42_GATE7_tag GATE7;              /* Gate Register */
  SEMA42_GATE6_tag GATE6;              /* Gate Register */
  SEMA42_GATE5_tag GATE5;              /* Gate Register */
  SEMA42_GATE4_tag GATE4;              /* Gate Register */
  SEMA42_GATE11_tag GATE11;            /* Gate Register */
  SEMA42_GATE10_tag GATE10;            /* Gate Register */
  SEMA42_GATE9_tag GATE9;              /* Gate Register */
  SEMA42_GATE8_tag GATE8;              /* Gate Register */
  SEMA42_GATE15_tag GATE15;            /* Gate Register */
  SEMA42_GATE_tag GATE;                /* Gate Register */
  uint8_t SEMA42_reserved0[50];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SGM ================================
   ============================================================================ */

typedef union SGM_SGMCTL_union_tag {   /* SGM control register */
  vuint32_t R;
  struct {
    vuint32_t OS:1;
    vuint32_t PWMCHS:1;
    vuint32_t PWME:1;
    vuint32_t _unused_3:3;
    vuint32_t PBCLKS:1;
    vuint32_t TOE:1;
    vuint32_t _unused_8:4;
    vuint32_t MODCH0:1;
    vuint32_t MODCH1:1;
    vuint32_t MODCH2:1;
    vuint32_t MODCH3:1;
    vuint32_t _unused_16:7;
    vuint32_t MDIS:1;
    vuint32_t _unused_24:4;
    vuint32_t SOGCH0:1;
    vuint32_t SOGCH1:1;
    vuint32_t SOGCH2:1;
    vuint32_t SOGCH3:1;
  } B;
} SGM_SGMCTL_tag;

typedef union SGM_SGMCFG_union_tag {   /* SGM configuration register */
  vuint32_t R;
  struct {
    vuint32_t SFCH0:2;
    vuint32_t SFCH1:2;
    vuint32_t SFCH2:2;
    vuint32_t SFCH3:2;
    vuint32_t _unused_8:4;
    vuint32_t RPTECH0:1;
    vuint32_t RPTECH1:1;
    vuint32_t RPTECH2:1;
    vuint32_t RPTECH3:1;
    vuint32_t TPCECH0:1;
    vuint32_t TPCECH1:1;
    vuint32_t TPCECH2:1;
    vuint32_t TPCECH3:1;
    vuint32_t NOPECH0:1;
    vuint32_t NOPECH1:1;
    vuint32_t NOPECH2:1;
    vuint32_t NOPECH3:1;
    vuint32_t RELFCH0:1;
    vuint32_t RELFCH1:1;
    vuint32_t RELFCH2:1;
    vuint32_t RELFCH3:1;
    vuint32_t ATKFCH0:1;
    vuint32_t ATKFCH1:1;
    vuint32_t ATKFCH2:1;
    vuint32_t ATKFCH3:1;
  } B;
} SGM_SGMCFG_tag;

typedef union SGM_CLKRSP_union_tag {   /* Clock configuration register */
  vuint32_t R;
  struct {
    vuint32_t PRSM:16;
    vuint32_t PRSR:3;
    vuint32_t _unused_19:11;
    vuint32_t CLKS:2;
  } B;
} SGM_CLKRSP_tag;

typedef union SGM_CH_CLK_union_tag {   /* Clock configuration register */
  vuint32_t R;
  struct {
    vuint32_t PRSM:16;
    vuint32_t PRSR:3;
    vuint32_t _unused_19:11;
    vuint32_t CLKS:2;
  } B;
} SGM_CH_CLK_tag;

typedef union SGM_CH_DDS_union_tag {   /* DDS configuration register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t DDSF:16;
  } B;
} SGM_CH_DDS_tag;

typedef union SGM_CH_ECRA_union_tag {  /* Envelop configuration register of attack phase */
  vuint32_t R;
  struct {
    vuint32_t ATKSC:16;                /* Attack Step duration count. */
    vuint32_t ATKSL:8;
    vuint32_t ATKT:8;
  } B;
} SGM_CH_ECRA_tag;

typedef union SGM_CH_ECRR_union_tag {  /* Envelop configuration release phase register */
  vuint32_t R;
  struct {
    vuint32_t RELSC:16;
    vuint32_t RELSL:8;
    vuint32_t RELT:8;
  } B;
} SGM_CH_ECRR_tag;

typedef union SGM_CH_ECRS_union_tag {  /* Envelop configuration register of sustain timing */
  vuint32_t R;
  struct {
    vuint32_t SUST:24;
    vuint32_t _unused_24:8;
  } B;
} SGM_CH_ECRS_tag;

typedef union SGM_CH_NT_union_tag {    /* Inter-note no-output phase timing */
  vuint32_t R;
  struct {
    vuint32_t NOPT:24;                 /* No-Output Timing */
    vuint32_t _unused_24:8;
  } B;
} SGM_CH_NT_tag;

typedef union SGM_CH_TPC_union_tag {   /* Target note pulse count register */
  vuint32_t R;
  struct {
    vuint32_t TPC:16;
    vuint32_t _unused_16:16;
  } B;
} SGM_CH_TPC_tag;

typedef union SGM_CH_PTC_union_tag {   /* Playback timing configuration register */
  vuint32_t R;
  struct {
    vuint32_t PLAYBT:24;               /* PlayBack Time. */
    vuint32_t _unused_24:8;
  } B;
} SGM_CH_PTC_tag;

typedef union SGM_CH_DTC_union_tag {   /* Dead time configuration register */
  vuint32_t R;
  struct {
    vuint32_t DEADT:24;
    vuint32_t _unused_24:8;
  } B;
} SGM_CH_DTC_tag;

typedef union SGM_CH_RNC_union_tag {   /* Repeat number configuration register */
  vuint32_t R;
  struct {
    vuint32_t RPTN:10;
    vuint32_t _unused_10:22;
  } B;
} SGM_CH_RNC_tag;

typedef struct SGM_CH_struct_tag {
  SGM_CH_CLK_tag CLK;                  /* Clock configuration register */
  SGM_CH_DDS_tag DDS;                  /* DDS configuration register */
  SGM_CH_ECRA_tag ECRA;                /* Envelop configuration register of attack phase */
  SGM_CH_ECRR_tag ECRR;                /* Envelop configuration release phase register */
  SGM_CH_ECRS_tag ECRS;                /* Envelop configuration register of sustain timing */
  SGM_CH_NT_tag NT;                    /* Inter-note no-output phase timing */
  SGM_CH_TPC_tag TPC;                  /* Target note pulse count register */
  SGM_CH_PTC_tag PTC;                  /* Playback timing configuration register */
  SGM_CH_DTC_tag DTC;                  /* Dead time configuration register */
  SGM_CH_RNC_tag RNC;                  /* Repeat number configuration register */
} SGM_CH_tag;

typedef union SGM_VCRPLAYB_union_tag { /* Volume control register for playback mode */
  vuint32_t R;
  struct {
    vuint32_t VOLCH0:8;
    vuint32_t VOLCH1:8;
    vuint32_t VOLCH2:8;
    vuint32_t VOLCH3:8;
  } B;
} SGM_VCRPLAYB_tag;

typedef union SGM_SGMTOCR_union_tag {  /* SGM timeout count register */
  vuint32_t R;
  struct {
    vuint32_t TIMEOUT:32;
  } B;
} SGM_SGMTOCR_tag;

typedef union SGM_MIXCR_union_tag {    /* Mixer configuration register */
  vuint32_t R;
  struct {
    vuint32_t CHSR:4;
    vuint32_t _unused_4:12;
    vuint32_t CHSL:4;
    vuint32_t _unused_20:12;
  } B;
} SGM_MIXCR_tag;

typedef union SGM_CLKPWM_union_tag {   /* Clock configuration register */
  vuint32_t R;
  struct {
    vuint32_t PRSM:16;
    vuint32_t PRSR:3;
    vuint32_t _unused_19:11;
    vuint32_t CLKS:2;
  } B;
} SGM_CLKPWM_tag;

typedef union SGM_PWMCR_union_tag {    /* PWM configuration register */
  vuint32_t R;
  struct {
    vuint32_t TONF:16;
    vuint32_t PWMF:16;
  } B;
} SGM_PWMCR_tag;

typedef union SGM_DFIFO1_union_tag {   /* Data FIFO register 1 */
  vuint32_t R;
  struct {
    vuint32_t FIFOCH2:16;
    vuint32_t FIFOCH3:16;
  } B;
} SGM_DFIFO1_tag;

typedef union SGM_DFIFO2_union_tag {   /* Data FIFO register 2 */
  vuint32_t R;
  struct {
    vuint32_t FIFOCH0:16;
    vuint32_t FIFOCH1:16;
  } B;
} SGM_DFIFO2_tag;

typedef union SGM_FIFOWM_union_tag {   /* FIFO watermark register */
  vuint32_t R;
  struct {
    vuint32_t WMCH0:8;
    vuint32_t WMCH1:8;
    vuint32_t WMCH2:8;
    vuint32_t WMCH3:8;
  } B;
} SGM_FIFOWM_tag;

typedef union SGM_FIFORP_union_tag {   /* FIFO read pointer register */
  vuint32_t R;
  struct {
    vuint32_t FRPCH0:8;
    vuint32_t FRPCH1:8;
    vuint32_t FRPCH2:8;
    vuint32_t FRPCH3:8;
  } B;
} SGM_FIFORP_tag;

typedef union SGM_FIFOWP_union_tag {   /* FIFO write pointer register */
  vuint32_t R;
  struct {
    vuint32_t FWPCH0:8;
    vuint32_t FWPCH1:8;
    vuint32_t FWPCH2:8;
    vuint32_t FWPCH3:8;
  } B;
} SGM_FIFOWP_tag;

typedef union SGM_SGMST_union_tag {    /* SGM status register */
  vuint32_t R;
  struct {
    vuint32_t STATCH0:3;
    vuint32_t FLSCH0:1;
    vuint32_t _unused_4:4;
    vuint32_t STATCH1:3;
    vuint32_t FLSCH1:1;
    vuint32_t _unused_12:4;
    vuint32_t STATCH2:3;
    vuint32_t FLSCH2:1;
    vuint32_t _unused_20:4;
    vuint32_t STATCH3:3;
    vuint32_t FLSCH3:1;
    vuint32_t _unused_28:4;
  } B;
} SGM_SGMST_tag;

typedef union SGM_SGMICFD_union_tag {  /* SGM interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t FUIECH0:1;
    vuint32_t FUIECH1:1;
    vuint32_t FUIECH2:1;
    vuint32_t FUIECH3:1;
    vuint32_t FOIECH0:1;
    vuint32_t FOIECH1:1;
    vuint32_t FOIECH2:1;
    vuint32_t FOIECH3:1;
    vuint32_t FEIECH0:1;
    vuint32_t FEIECH1:1;
    vuint32_t FEIECH2:1;
    vuint32_t FEIECH3:1;
    vuint32_t FFIECH0:1;
    vuint32_t FFIECH1:1;
    vuint32_t FFIECH2:1;
    vuint32_t FFIECH3:1;
    vuint32_t _unused_16:4;
    vuint32_t FLIECH0:1;
    vuint32_t FLIECH1:1;
    vuint32_t FLIECH2:1;
    vuint32_t FLIECH3:1;
    vuint32_t _unused_24:4;
    vuint32_t FLDECH0:1;
    vuint32_t FLDECH1:1;
    vuint32_t FLDECH2:1;
    vuint32_t FLDECH3:1;
  } B;
} SGM_SGMICFD_tag;

typedef union SGM_SGMIC_union_tag {    /* SGM interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t PCIECH0:1;
    vuint32_t PCIECH1:1;
    vuint32_t PCIECH2:1;
    vuint32_t PCIECH3:1;
    vuint32_t EONIECH0:1;
    vuint32_t EONIECH1:1;
    vuint32_t EONIECH2:1;
    vuint32_t EONIECH3:1;
    vuint32_t EOAIECH0:1;
    vuint32_t EOAIECH1:1;
    vuint32_t EOAIECH2:1;
    vuint32_t EOAIECH3:1;
    vuint32_t EORIECH0:1;
    vuint32_t EORIECH1:1;
    vuint32_t EORIECH2:1;
    vuint32_t EORIECH3:1;
    vuint32_t RDIECH0:1;
    vuint32_t RDIECH1:1;
    vuint32_t RDIECH2:1;
    vuint32_t RDIECH3:1;
    vuint32_t PDIECH0:1;
    vuint32_t PDIECH1:1;
    vuint32_t PDIECH2:1;
    vuint32_t PDIECH3:1;
    vuint32_t _unused_24:7;
    vuint32_t TOIE:1;
  } B;
} SGM_SGMIC_tag;

typedef union SGM_SGMISFD_union_tag {  /* SGM interrupt status register */
  vuint32_t R;
  struct {
    vuint32_t FUFCH0:1;
    vuint32_t FUFCH1:1;
    vuint32_t FUFCH2:1;
    vuint32_t FUFCH3:1;
    vuint32_t FOFCH0:1;
    vuint32_t FOFCH1:1;
    vuint32_t FOFCH2:1;
    vuint32_t FOFCH3:1;
    vuint32_t FEFCH0:1;
    vuint32_t FEFCH1:1;
    vuint32_t FEFCH2:1;
    vuint32_t FEFCH3:1;
    vuint32_t FFFCH0:1;
    vuint32_t FFFCH1:1;
    vuint32_t FFFCH2:1;
    vuint32_t FFFCH3:1;
    vuint32_t _unused_16:4;
    vuint32_t FLFCH0:1;
    vuint32_t FLFCH1:1;
    vuint32_t FLFCH2:1;
    vuint32_t FLFCH3:1;
    vuint32_t _unused_24:8;
  } B;
} SGM_SGMISFD_tag;

typedef union SGM_SGMIS_union_tag {    /* SGM interrupt status register */
  vuint32_t R;
  struct {
    vuint32_t PCFCH0:1;
    vuint32_t PCFCH1:1;
    vuint32_t PCFCH2:1;
    vuint32_t PCFCH3:1;
    vuint32_t EONFCH0:1;
    vuint32_t EONFCH1:1;
    vuint32_t EONFCH2:1;
    vuint32_t EONFCH3:1;
    vuint32_t EOAFCH0:1;
    vuint32_t EOAFCH1:1;
    vuint32_t EOAFCH2:1;
    vuint32_t EOAFCH3:1;
    vuint32_t EORFCH0:1;
    vuint32_t EORFCH1:1;
    vuint32_t EORFCH2:1;
    vuint32_t EORFCH3:1;
    vuint32_t RDFCH0:1;
    vuint32_t RDFCH1:1;
    vuint32_t RDFCH2:1;
    vuint32_t RDFCH3:1;
    vuint32_t PDFCH0:1;
    vuint32_t PDFCH1:1;
    vuint32_t PDFCH2:1;
    vuint32_t PDFCH3:1;
    vuint32_t _unused_24:7;
    vuint32_t TOF:1;
  } B;
} SGM_SGMIS_tag;

typedef union SGM_I2SEN_union_tag {    /* I2S enable register */
  vuint32_t R;
  struct {
    vuint32_t IEN:1;
    vuint32_t _unused_1:3;
    vuint32_t SRST:1;
    vuint32_t _unused_5:27;
  } B;
} SGM_I2SEN_tag;

typedef union SGM_I2SCTL_union_tag {   /* I2S control register */
  vuint32_t R;
  struct {
    vuint32_t POL:1;
    vuint32_t PSYNC:1;
    vuint32_t _unused_2:2;
    vuint32_t PM:2;
    vuint32_t _unused_6:1;
    vuint32_t CHSEL:1;
    vuint32_t ACSEL:1;
    vuint32_t ACEN:1;
    vuint32_t _unused_10:4;
    vuint32_t FIFOTH:2;
    vuint32_t _unused_16:16;
  } B;
} SGM_I2SCTL_tag;

typedef union SGM_I2SDFC_union_tag {   /* I2S output data format control register */
  vuint32_t R;
  struct {
    vuint32_t IDF:1;
    vuint32_t _unused_1:3;
    vuint32_t ODF:2;
    vuint32_t _unused_6:2;
    vuint32_t BSO:2;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t MSBF:1;                  /* MSB First. */
    vuint32_t _unused_13:3;
    vuint32_t FSL:5;
    vuint32_t _unused_21:11;
  } B;
} SGM_I2SDFC_tag;

typedef union SGM_I2SPRS_union_tag {   /* I2S clock prescale register */
  vuint32_t R;
  struct {
    vuint32_t I2SPSCLR:16;
    vuint32_t ACPSCLR:16;
  } B;
} SGM_I2SPRS_tag;

typedef union SGM_I2SINTC_union_tag {  /* I2S interrupt control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:18;
    vuint32_t CPLEN:1;
    vuint32_t _unused_19:5;
    vuint32_t FUFE:1;
    vuint32_t FOFE:1;
    vuint32_t _unused_26:5;
    vuint32_t TSFEN:1;
  } B;
} SGM_I2SINTC_tag;

typedef union SGM_I2SST_union_tag {    /* I2S status register */
  vuint32_t R;
  struct {
    vuint32_t BSY:1;
    vuint32_t _unused_1:3;
    vuint32_t FIFOST:4;
    vuint32_t _unused_8:10;
    vuint32_t CPL:1;
    vuint32_t _unused_19:5;
    vuint32_t FUF:1;
    vuint32_t FOF:1;
    vuint32_t _unused_26:5;
    vuint32_t TSFE:1;
  } B;
} SGM_I2SST_tag;

struct SGM_tag {
  SGM_SGMCTL_tag SGMCTL;               /* SGM control register */
  SGM_SGMCFG_tag SGMCFG;               /* SGM configuration register */
  SGM_CLKRSP_tag CLKRSP;               /* Clock configuration register */
  SGM_CH_tag CH[4];
  SGM_VCRPLAYB_tag VCRPLAYB;           /* Volume control register for playback mode */
  SGM_SGMTOCR_tag SGMTOCR;             /* SGM timeout count register */
  SGM_MIXCR_tag MIXCR;                 /* Mixer configuration register */
  SGM_CLKPWM_tag CLKPWM;               /* Clock configuration register */
  SGM_PWMCR_tag PWMCR;                 /* PWM configuration register */
  SGM_DFIFO1_tag DFIFO1;               /* Data FIFO register 1 */
  SGM_DFIFO2_tag DFIFO2;               /* Data FIFO register 2 */
  SGM_FIFOWM_tag FIFOWM;               /* FIFO watermark register */
  SGM_FIFORP_tag FIFORP;               /* FIFO read pointer register */
  SGM_FIFOWP_tag FIFOWP;               /* FIFO write pointer register */
  SGM_SGMST_tag SGMST;                 /* SGM status register */
  SGM_SGMICFD_tag SGMICFD;             /* SGM interrupt control register */
  SGM_SGMIC_tag SGMIC;                 /* SGM interrupt control register */
  SGM_SGMISFD_tag SGMISFD;             /* SGM interrupt status register */
  SGM_SGMIS_tag SGMIS;                 /* SGM interrupt status register */
  SGM_I2SEN_tag I2SEN;                 /* I2S enable register */
  SGM_I2SCTL_tag I2SCTL;               /* I2S control register */
  SGM_I2SDFC_tag I2SDFC;               /* I2S output data format control register */
  SGM_I2SPRS_tag I2SPRS;               /* I2S clock prescale register */
  SGM_I2SINTC_tag I2SINTC;             /* I2S interrupt control register */
  SGM_I2SST_tag I2SST;                 /* I2S status register */
};


/* ============================================================================
   =============================== Module: SIRC ===============================
   ============================================================================ */

typedef union SIRC_CTL_union_tag {     /* Control register */
  vuint32_t R;
  struct {
    vuint32_t STDBY:1;                 /* Low power RC control in Standby mode. */
    vuint32_t _unused_1:3;
    vuint32_t SIRCS:1;                 /* Describes the SIRC clock status. */
    vuint32_t _unused_5:3;
    vuint32_t SIRCDIV:5;               /* The SIRC Divider bits select the clock divider . factor */
    vuint32_t _unused_13:3;
    vuint32_t _unused_16:8;
    vuint32_t _unused_24:8;
  } B;
} SIRC_CTL_tag;

struct SIRC_tag {
  SIRC_CTL_tag CTL;                    /* Control register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t _unused_8:2;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t _unused_15:1;
    vuint32_t PARTNUM:16;              /* MCU Part Number */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t PARTNUM:8;               /* ASCII character in MCU Part Number */
    vuint32_t _unused_16:7;
    vuint32_t FLASH_SIZE_2:4;          /* Fine granularity for flash memory size */
    vuint32_t FLASH_SIZE_1:4;          /* Coarse granularity for flash memory size */
    vuint32_t SF:1;                    /* Manufacturer */
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* SIUL2 DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag 0 */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag 1 */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag 2 */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag 3 */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag 4 */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag 5 */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag 6 */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag 7 */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag 8 */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag 9 */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag 10 */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag 11 */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag 12 */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag 13 */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag 14 */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag 15 */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag 16 */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag 17 */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag 18 */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag 19 */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag 20 */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag 21 */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag 22 */
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag 23 */
    vuint32_t EIF24:1;                 /* External Interrupt Status Flag 24 */
    vuint32_t EIF25:1;                 /* External Interrupt Status Flag 25 */
    vuint32_t EIF26:1;                 /* External Interrupt Status Flag 26 */
    vuint32_t EIF27:1;                 /* External Interrupt Status Flag 27 */
    vuint32_t EIF28:1;                 /* External Interrupt Status Flag 28 */
    vuint32_t EIF29:1;                 /* External Interrupt Status Flag 29 */
    vuint32_t EIF30:1;                 /* External Interrupt Status Flag 30 */
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag 31 */
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* SIUL2 DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE0:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE23:1;
    vuint32_t EIRE24:1;
    vuint32_t EIRE25:1;
    vuint32_t EIRE26:1;
    vuint32_t EIRE27:1;
    vuint32_t EIRE28:1;
    vuint32_t EIRE29:1;
    vuint32_t EIRE30:1;
    vuint32_t EIRE31:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* SIUL2 DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR0:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR24:1;
    vuint32_t DIRSR25:1;
    vuint32_t DIRSR26:1;
    vuint32_t DIRSR27:1;
    vuint32_t DIRSR28:1;
    vuint32_t DIRSR29:1;
    vuint32_t DIRSR30:1;
    vuint32_t DIRSR31:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE0:1;
    vuint32_t IREE1:1;
    vuint32_t IREE2:1;
    vuint32_t IREE3:1;
    vuint32_t IREE4:1;
    vuint32_t IREE5:1;
    vuint32_t IREE6:1;
    vuint32_t IREE7:1;
    vuint32_t IREE8:1;
    vuint32_t IREE9:1;
    vuint32_t IREE10:1;
    vuint32_t IREE11:1;
    vuint32_t IREE12:1;
    vuint32_t IREE13:1;
    vuint32_t IREE14:1;
    vuint32_t IREE15:1;
    vuint32_t IREE16:1;
    vuint32_t IREE17:1;
    vuint32_t IREE18:1;
    vuint32_t IREE19:1;
    vuint32_t IREE20:1;
    vuint32_t IREE21:1;
    vuint32_t IREE22:1;
    vuint32_t IREE23:1;
    vuint32_t IREE24:1;
    vuint32_t IREE25:1;
    vuint32_t IREE26:1;
    vuint32_t IREE27:1;
    vuint32_t IREE28:1;
    vuint32_t IREE29:1;
    vuint32_t IREE30:1;
    vuint32_t IREE31:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE0:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE23:1;
    vuint32_t IFEE24:1;
    vuint32_t IFEE25:1;
    vuint32_t IFEE26:1;
    vuint32_t IFEE27:1;
    vuint32_t IFEE28:1;
    vuint32_t IFEE29:1;
    vuint32_t IFEE30:1;
    vuint32_t IFEE31:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE0:1;
    vuint32_t IFE1:1;
    vuint32_t IFE2:1;
    vuint32_t IFE3:1;
    vuint32_t IFE4:1;
    vuint32_t IFE5:1;
    vuint32_t IFE6:1;
    vuint32_t IFE7:1;
    vuint32_t IFE8:1;
    vuint32_t IFE9:1;
    vuint32_t IFE10:1;
    vuint32_t IFE11:1;
    vuint32_t IFE12:1;
    vuint32_t IFE13:1;
    vuint32_t IFE14:1;
    vuint32_t IFE15:1;
    vuint32_t IFE16:1;
    vuint32_t IFE17:1;
    vuint32_t IFE18:1;
    vuint32_t IFE19:1;
    vuint32_t IFE20:1;
    vuint32_t IFE21:1;
    vuint32_t IFE22:1;
    vuint32_t IFE23:1;
    vuint32_t IFE24:1;
    vuint32_t IFE25:1;
    vuint32_t IFE26:1;
    vuint32_t IFE27:1;
    vuint32_t IFE28:1;
    vuint32_t IFE29:1;
    vuint32_t IFE30:1;
    vuint32_t IFE31:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
    vuint32_t _unused_4:28;
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
    vuint32_t _unused_4:28;
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SSS:4;                   /* Source Signal Select */
    vuint32_t _unused_4:4;
    vuint32_t _unused_8:7;
    vuint32_t _unused_15:1;
    vuint32_t PUE:1;                   /* Pull Enable */
    vuint32_t PUS:1;                   /* Pull Select */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t TTL:1;                   /* TTL/Automotive mode selection for GPI only Pads TTL bit also used as term control for DDR Pads */
    vuint32_t _unused_21:1;
    vuint32_t APC:1;                   /* APC is used as term control for DDR Pads.Please refer register description for details. */
    vuint32_t SMCTL:1;                 /* Safe Mode Control */
    vuint32_t ODE:1;                   /* Open Drain Enable */
    vuint32_t OBE:1;                   /* GPIO Output Buffer Enable */
    vuint32_t _unused_26:2;
    vuint32_t SRE:2;                   /* Slew Rate Control */
    vuint32_t _unused_30:2;
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_GPR0_union_tag {   /* General Purpose Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MLBCLK_INV:1;
    vuint32_t FUNC_TEST:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_11:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_31:1;
  } B;
} SIUL2_GPR0_tag;

typedef union SIUL2_GPR1_union_tag {   /* General Purpose Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:27;
    vuint32_t DCU_LDB_CLK:1;
    vuint32_t ENET_CLK:1;              /* ENET clock */
    vuint32_t DCU_SEL_LDB:1;           /* DCU select at LDB interface */
    vuint32_t DCU_SEL_TCON_1:1;        /* DCU select at TCON_1 interface */
    vuint32_t TCON_0_CFG:1;            /* TCON_0 Configuration */
  } B;
} SIUL2_GPR1_tag;

typedef union SIUL2_GPR2_union_tag {   /* General Purpose Register 2 */
  vuint32_t R;
  struct {
    vuint32_t PROG_P0:4;
    vuint32_t PROG_P1_PAD:4;
    vuint32_t PROG_P2_PAD:4;
    vuint32_t PROG_P3_PAD:4;
    vuint32_t PROG_CLK:4;
    vuint32_t _unused_20:11;
    vuint32_t LVDS:1;                  /* LVDS Reference pad */
  } B;
} SIUL2_GPR2_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
  vuint32_t R;
  struct {
    vuint32_t PDO_4n3:1;               /* Pad Data Out */
    vuint32_t _unused_1:7;
    vuint32_t PDO_4n2:1;               /* Pad Data Out */
    vuint32_t _unused_9:7;
    vuint32_t PDO_4n1:1;               /* Pad Data Out */
    vuint32_t _unused_17:7;
    vuint32_t PDO_4n:1;                /* Pad Data Out */
    vuint32_t _unused_25:7;
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
  vuint32_t R;
  struct {
    vuint32_t PDI_4n3:1;               /* Pad Data In */
    vuint32_t _unused_1:7;
    vuint32_t PDI_4n2:1;               /* Pad Data In */
    vuint32_t _unused_9:7;
    vuint32_t PDI_4n1:1;               /* Pad Data In */
    vuint32_t _unused_17:7;
    vuint32_t PDI_4n:1;                /* Pad Data In */
    vuint32_t _unused_25:7;
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO1_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO1_tag;

typedef union SIUL2_PGPDO0_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO0_tag;

typedef union SIUL2_PGPDO3_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO3_tag;

typedef union SIUL2_PGPDO2_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO2_tag;

typedef union SIUL2_PGPDO5_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO5_tag;

typedef union SIUL2_PGPDO4_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO4_tag;

typedef union SIUL2_PGPDO7_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO7_tag;

typedef union SIUL2_PGPDO6_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO6_tag;

typedef union SIUL2_PGPDO9_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO9_tag;

typedef union SIUL2_PGPDO8_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO8_tag;

typedef union SIUL2_PGPDO11_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO11_tag;

typedef union SIUL2_PGPDO10_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO10_tag;

typedef union SIUL2_PGPDO13_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO13_tag;

typedef union SIUL2_PGPDO12_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO12_tag;

typedef union SIUL2_PGPDO15_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO15_tag;

typedef union SIUL2_PGPDO14_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO14_tag;

typedef union SIUL2_PGPDO16_union_tag { /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO16_tag;

typedef union SIUL2_PGPDI1_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI1_tag;

typedef union SIUL2_PGPDI0_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI0_tag;

typedef union SIUL2_PGPDI3_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI3_tag;

typedef union SIUL2_PGPDI2_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI2_tag;

typedef union SIUL2_PGPDI5_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI5_tag;

typedef union SIUL2_PGPDI4_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI4_tag;

typedef union SIUL2_PGPDI7_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI7_tag;

typedef union SIUL2_PGPDI6_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI6_tag;

typedef union SIUL2_PGPDI9_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI9_tag;

typedef union SIUL2_PGPDI8_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI8_tag;

typedef union SIUL2_PGPDI11_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI11_tag;

typedef union SIUL2_PGPDI10_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI10_tag;

typedef union SIUL2_PGPDI13_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI13_tag;

typedef union SIUL2_PGPDI12_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI12_tag;

typedef union SIUL2_PGPDI15_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI15_tag;

typedef union SIUL2_PGPDI14_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI14_tag;

typedef union SIUL2_PGPDI16_union_tag { /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI16_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
    vuint32_t MASK:16;                 /* Mask Field */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* SIUL2 DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* SIUL2 DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* SIUL2 DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[30];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  uint8_t SIUL2_reserved8[8];
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved9[380];
  SIUL2_MSCR_tag MSCR[1024];            /* SIUL2 Multiplexed Signal Configuration Register */
  SIUL2_GPR0_tag GPR0;                 /* General Purpose Register 0 */
  SIUL2_GPR1_tag GPR1;                 /* General Purpose Register 1 */
  SIUL2_GPR2_tag GPR2;                 /* General Purpose Register 2 */
  uint8_t SIUL2_reserved11[180];
  SIUL2_GPDO_tag GPDO[68];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved12[240];
  SIUL2_GPDI_tag GPDI[68];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved13[240];
  SIUL2_PGPDO1_tag PGPDO1;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO0_tag PGPDO0;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO3_tag PGPDO3;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO2_tag PGPDO2;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO5_tag PGPDO5;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO4_tag PGPDO4;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO7_tag PGPDO7;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO6_tag PGPDO6;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO9_tag PGPDO9;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO8_tag PGPDO8;             /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO11_tag PGPDO11;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO10_tag PGPDO10;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO13_tag PGPDO13;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO12_tag PGPDO12;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO15_tag PGPDO15;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  SIUL2_PGPDO14_tag PGPDO14;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved14[2];
  SIUL2_PGPDO16_tag PGPDO16;           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved15[28];
  SIUL2_PGPDI1_tag PGPDI1;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI0_tag PGPDI0;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI3_tag PGPDI3;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI2_tag PGPDI2;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI5_tag PGPDI5;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI4_tag PGPDI4;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI7_tag PGPDI7;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI6_tag PGPDI6;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI9_tag PGPDI9;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI8_tag PGPDI8;             /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI11_tag PGPDI11;           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI10_tag PGPDI10;           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI13_tag PGPDI13;           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI12_tag PGPDI12;           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI15_tag PGPDI15;           /* SIUL2 Parallel GPIO Pad Data In Register */
  SIUL2_PGPDI14_tag PGPDI14;           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved16[2];
  SIUL2_PGPDI16_tag PGPDI16;           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved17[28];
  SIUL2_MPGPDO_tag MPGPDO[17];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMC ================================
   ============================================================================ */

typedef union SMC_MCPER_union_tag {    /* Motor Controller Period Register */
  vuint16_t R;
  struct {
    vuint16_t PER:11;
    vuint16_t _unused_11:5;
  } B;
} SMC_MCPER_tag;

typedef union SMC_MCCTL1_union_tag {   /* Motor Controller Control Register 1 */
  vuint8_t R;
  struct {
    vuint8_t MCTOIE:1;
    vuint8_t _unused_1:6;
    vuint8_t RECIRC:1;
  } B;
} SMC_MCCTL1_tag;

typedef union SMC_MCCTL0_union_tag {   /* Motor Controller Control Register 0 */
  vuint8_t R;
  struct {
    vuint8_t MCTOIF:1;
    vuint8_t _unused_1:1;
    vuint8_t DITH:1;
    vuint8_t _unused_3:1;
    vuint8_t MCHME:1;
    vuint8_t MCPRE:2;
    vuint8_t _unused_7:1;
  } B;
} SMC_MCCTL0_tag;

typedef union SMC_MCCC3_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC3_tag;

typedef union SMC_MCCC2_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC2_tag;

typedef union SMC_MCCC1_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC1_tag;

typedef union SMC_MCCC0_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC0_tag;

typedef union SMC_MCCC7_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC7_tag;

typedef union SMC_MCCC6_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC6_tag;

typedef union SMC_MCCC5_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC5_tag;

typedef union SMC_MCCC4_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC4_tag;

typedef union SMC_MCCC11_union_tag {   /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC11_tag;

typedef union SMC_MCCC10_union_tag {   /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC10_tag;

typedef union SMC_MCCC9_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC9_tag;

typedef union SMC_MCCC8_union_tag {    /* Motor Controller Channel Control Register */
  vuint8_t R;
  struct {
    vuint8_t CD:2;
    vuint8_t _unused_2:2;
    vuint8_t MCAM:2;
    vuint8_t MCOM:2;
  } B;
} SMC_MCCC8_tag;

typedef union SMC_MCDC1_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC1_tag;

typedef union SMC_MCDC0_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC0_tag;

typedef union SMC_MCDC3_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC3_tag;

typedef union SMC_MCDC2_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC2_tag;

typedef union SMC_MCDC5_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC5_tag;

typedef union SMC_MCDC4_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC4_tag;

typedef union SMC_MCDC7_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC7_tag;

typedef union SMC_MCDC6_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC6_tag;

typedef union SMC_MCDC9_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC9_tag;

typedef union SMC_MCDC8_union_tag {    /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC8_tag;

typedef union SMC_MCDC11_union_tag {   /* Motor Controller Duty Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t DUTY:11;
    vuint16_t SIGN:5;
  } B;
} SMC_MCDC11_tag;

typedef union SMC_MCSDTO_union_tag {   /* Short-circuit Detector Time-out Register */
  vuint8_t R;
  struct {
    vuint8_t TOUT:8;
  } B;
} SMC_MCSDTO_tag;

typedef union SMC_MCSDE2_union_tag {   /* Short-circuit Detector Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDEN:8;
  } B;
} SMC_MCSDE2_tag;

typedef union SMC_MCSDE1_union_tag {   /* Short-circuit Detector Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDEN:8;
  } B;
} SMC_MCSDE1_tag;

typedef union SMC_MCSDE0_union_tag {   /* Short-circuit Detector Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDEN:8;
  } B;
} SMC_MCSDE0_tag;

typedef union SMC_MCSDIEN2_union_tag { /* Short-circuit Detector Interrupt Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDIE:8;
  } B;
} SMC_MCSDIEN2_tag;

typedef union SMC_MCSDIEN1_union_tag { /* Short-circuit Detector Interrupt Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDIE:8;
  } B;
} SMC_MCSDIEN1_tag;

typedef union SMC_MCSDIEN0_union_tag { /* Short-circuit Detector Interrupt Enable Register */
  vuint8_t R;
  struct {
    vuint8_t SDIE:8;
  } B;
} SMC_MCSDIEN0_tag;

typedef union SMC_MCSDI2_union_tag {   /* Short-circuit Detector Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SDIF:8;
  } B;
} SMC_MCSDI2_tag;

typedef union SMC_MCSDI1_union_tag {   /* Short-circuit Detector Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SDIF:8;
  } B;
} SMC_MCSDI1_tag;

typedef union SMC_MCSDI0_union_tag {   /* Short-circuit Detector Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SDIF:8;
  } B;
} SMC_MCSDI0_tag;

struct SMC_tag {
  SMC_MCPER_tag MCPER;                 /* Motor Controller Period Register */
  SMC_MCCTL1_tag MCCTL1;               /* Motor Controller Control Register 1 */
  SMC_MCCTL0_tag MCCTL0;               /* Motor Controller Control Register 0 */
  uint8_t SMC_reserved0[12];
  SMC_MCCC3_tag MCCC3;                 /* Motor Controller Channel Control Register */
  SMC_MCCC2_tag MCCC2;                 /* Motor Controller Channel Control Register */
  SMC_MCCC1_tag MCCC1;                 /* Motor Controller Channel Control Register */
  SMC_MCCC0_tag MCCC0;                 /* Motor Controller Channel Control Register */
  SMC_MCCC7_tag MCCC7;                 /* Motor Controller Channel Control Register */
  SMC_MCCC6_tag MCCC6;                 /* Motor Controller Channel Control Register */
  SMC_MCCC5_tag MCCC5;                 /* Motor Controller Channel Control Register */
  SMC_MCCC4_tag MCCC4;                 /* Motor Controller Channel Control Register */
  SMC_MCCC11_tag MCCC11;               /* Motor Controller Channel Control Register */
  SMC_MCCC10_tag MCCC10;               /* Motor Controller Channel Control Register */
  SMC_MCCC9_tag MCCC9;                 /* Motor Controller Channel Control Register */
  SMC_MCCC8_tag MCCC8;                 /* Motor Controller Channel Control Register */
  uint8_t SMC_reserved1[4];
  SMC_MCDC1_tag MCDC1;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC0_tag MCDC0;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC3_tag MCDC3;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC2_tag MCDC2;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC5_tag MCDC5;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC4_tag MCDC4;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC7_tag MCDC7;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC6_tag MCDC6;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC9_tag MCDC9;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC8_tag MCDC8;                 /* Motor Controller Duty Cycle Register */
  SMC_MCDC11_tag MCDC11;               /* Motor Controller Duty Cycle Register */
  uint8_t SMC_reserved2[13];
  SMC_MCSDTO_tag MCSDTO;               /* Short-circuit Detector Time-out Register */
  uint8_t SMC_reserved3[1];
  SMC_MCSDE2_tag MCSDE2;               /* Short-circuit Detector Enable Register */
  SMC_MCSDE1_tag MCSDE1;               /* Short-circuit Detector Enable Register */
  SMC_MCSDE0_tag MCSDE0;               /* Short-circuit Detector Enable Register */
  uint8_t SMC_reserved4[1];
  SMC_MCSDIEN2_tag MCSDIEN2;           /* Short-circuit Detector Interrupt Enable Register */
  SMC_MCSDIEN1_tag MCSDIEN1;           /* Short-circuit Detector Interrupt Enable Register */
  SMC_MCSDIEN0_tag MCSDIEN0;           /* Short-circuit Detector Interrupt Enable Register */
  uint8_t SMC_reserved5[1];
  SMC_MCSDI2_tag MCSDI2;               /* Short-circuit Detector Interrupt Register */
  SMC_MCSDI1_tag MCSDI1;               /* Short-circuit Detector Interrupt Register */
  SMC_MCSDI0_tag MCSDI0;               /* Short-circuit Detector Interrupt Register */
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HALT:1;                  /* Halt */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t _unused_3:5;
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t _unused_15:1;
    vuint32_t PCSIS:4;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_20:4;            /* Always write the reset value to this field. */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t _unused_25:1;
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t BR:4;                    /* Baud Rate Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t DBR:1;                   /* Double Baud Rate */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:22;
    vuint32_t _unused_22:1;
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t _unused_31:1;            /* Always write the reset value to this field. */
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[5];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[1]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t _unused_16:1;
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t _unused_18:1;
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t _unused_20:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_22:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_24:1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t _unused_29:1;
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:14;
    vuint32_t _unused_14:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_15:1;            /* Always write the reset value to this field. */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t _unused_18:1;            /* Always write the reset value to this field. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_23:1;            /* Always write the reset value to this field. */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_30:1;            /* Always write the reset value to this field. */
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
  } B;
} SPI_RSER_tag;

typedef union SPI_MODE_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t PCS:4;
    vuint32_t _unused_20:4;            /* Always write the reset value to this field. */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
  } B;
} SPI_MODE_PUSHR_PUSHR_tag;

typedef union SPI_MODE_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t _unused_16:16;
  } B;
} SPI_MODE_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_MODE_PUSHR_union_tag {
  SPI_MODE_PUSHR_PUSHR_tag PUSHR;      /* PUSH TX FIFO Register In Master Mode */
  SPI_MODE_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_MODE_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXDATA:16;               /* Transmit Data */
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  uint8_t SPI_reserved1[12];
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_MODE_PUSHR_tag MODE_PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[4];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved2[48];
  SPI_RXFR_tag RXFR[4];                /* Receive FIFO Registers */
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:1;
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t _unused_5:1;
    vuint16_t JPIN:10;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:2;
    vuint16_t _unused_2:1;
    vuint16_t _unused_3:1;
    vuint16_t _unused_4:1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t _unused_8:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_10:1;
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t _unused_12:1;
    vuint16_t _unused_13:1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t _unused_15:1;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_UOPS_union_tag {    /* UTEST Secure Boot Register */
  vuint32_t R;
  struct {
    vuint32_t CEN:1;                   /* CSE Enable */
    vuint32_t CSE_BC:3;                /* CSE Boot Configuration */
    vuint32_t SBE:1;                   /* Secure Boot Enable */
    vuint32_t _unused_5:27;
  } B;
} SSCM_UOPS_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t LC:3;                    /* Life Cycle */
    vuint32_t _unused_3:5;
    vuint32_t _unused_8:2;
    vuint32_t _unused_10:22;
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  uint8_t SSCM_reserved0[28];
  SSCM_UOPS_tag UOPS;                  /* UTEST Secure Boot Register */
  uint8_t SSCM_reserved1[4];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved2[8];
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: SSD ================================
   ============================================================================ */

typedef union SSD_IRQ_union_tag {      /* Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t ACOVIE:1;
    vuint16_t _unused_1:5;
    vuint16_t ITGIE:1;
    vuint16_t BLNIE:1;
    vuint16_t ACOVIF:1;
    vuint16_t _unused_9:5;
    vuint16_t ITGIF:1;
    vuint16_t BLNIF:1;
  } B;
} SSD_IRQ_tag;

typedef union SSD_CTRL_union_tag {     /* Control and Status Register */
  vuint16_t R;
  struct {
    vuint16_t DZDIS:1;
    vuint16_t SDCPU:1;
    vuint16_t EXTADC:1;
    vuint16_t _unused_3:2;
    vuint16_t ITGST:1;
    vuint16_t BLNST:1;
    vuint16_t _unused_7:1;
    vuint16_t RTZE:1;
    vuint16_t ITGDCL:1;
    vuint16_t BLNDCL:1;
    vuint16_t ITGDIR:1;
    vuint16_t RCIR:1;
    vuint16_t STEP:2;
    vuint16_t TRIG:1;
  } B;
} SSD_CTRL_tag;

typedef union SSD_DCNT_union_tag {     /* Down Counter Count register */
  vuint16_t R;
  struct {
    vuint16_t DCNT:16;
  } B;
} SSD_DCNT_tag;

typedef union SSD_ITGACC_union_tag {   /* Integrator Accumulator Register */
  vuint16_t R;
  struct {
    vuint16_t ITGACC:16;
  } B;
} SSD_ITGACC_tag;

typedef union SSD_ITGCNTLD_union_tag { /* Integration Counter Load Register */
  vuint16_t R;
  struct {
    vuint16_t ITGCNTLD:16;
  } B;
} SSD_ITGCNTLD_tag;

typedef union SSD_BLNCNTLD_union_tag { /* Blanking Counter Load Register */
  vuint16_t R;
  struct {
    vuint16_t BLNCNTLD:16;
  } B;
} SSD_BLNCNTLD_tag;

typedef union SSD_PRESCALE_union_tag { /* Prescaler Register */
  vuint16_t R;
  struct {
    vuint16_t ACDIV:3;
    vuint16_t _unused_3:1;
    vuint16_t OFFCNC:1;
    vuint16_t _unused_5:1;             /* Software should always write '0' to this bit. */
    vuint16_t _unused_6:2;
    vuint16_t ITGDIV:3;
    vuint16_t _unused_11:1;
    vuint16_t BLNDIV:3;
    vuint16_t _unused_15:1;
  } B;
} SSD_PRESCALE_tag;

struct SSD_tag {
  SSD_IRQ_tag IRQ;                     /* Interrupt Flag and Enable Register */
  SSD_CTRL_tag CTRL;                   /* Control and Status Register */
  SSD_DCNT_tag DCNT;                   /* Down Counter Count register */
  SSD_ITGACC_tag ITGACC;               /* Integrator Accumulator Register */
  SSD_ITGCNTLD_tag ITGCNTLD;           /* Integration Counter Load Register */
  SSD_BLNCNTLD_tag BLNCNTLD;           /* Blanking Counter Load Register */
  uint8_t SSD_reserved0[2];
  SSD_PRESCALE_tag PRESCALE;           /* Prescaler Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t RUN:1;
    vuint32_t _unused_1:7;
    vuint32_t _unused_8:1;
    vuint32_t MBPLLEN:1;
    vuint32_t BYP:1;
    vuint32_t _unused_11:21;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t RUNSW:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:6;
    vuint32_t _unused_8:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t _unused_10:1;
    vuint32_t MBIE:1;
    vuint32_t _unused_12:20;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CLK_CFG:3;
    vuint32_t MBU:1;
    vuint32_t PMOSEN:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_6:2;
    vuint32_t WRP:1;
    vuint32_t _unused_9:5;
    vuint32_t _unused_14:8;
    vuint32_t PTR:9;
    vuint32_t _unused_31:1;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t PLLLDF:7;
    vuint32_t _unused_7:9;
    vuint32_t PLLIDF:3;
    vuint32_t _unused_19:5;
    vuint32_t PLLODF:6;
    vuint32_t _unused_30:2;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_INT_FLG_union_tag { /* STCU2 Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t MBIFLG:1;
    vuint32_t _unused_2:30;
  } B;
} STCU2_INT_FLG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t INVP:1;
    vuint32_t ENGE:1;
    vuint32_t _unused_2:1;
    vuint32_t WDTO:1;
    vuint32_t LOCKE:1;
    vuint32_t _unused_5:3;
    vuint32_t RFSF:1;
    vuint32_t UFSF:1;
    vuint32_t _unused_10:6;
    vuint32_t INVPSW:1;
    vuint32_t ENGESW:1;
    vuint32_t _unused_18:1;
    vuint32_t WDTOSW:1;
    vuint32_t LOCKESW:1;
    vuint32_t _unused_21:3;
    vuint32_t _unused_24:1;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_26:6;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t INVPUFM:1;
    vuint32_t ENGEUFM:1;
    vuint32_t _unused_2:1;
    vuint32_t WDTOUFM:1;
    vuint32_t LOCKEUFM:1;
    vuint32_t _unused_5:27;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS0:1;
    vuint32_t MBS1:1;
    vuint32_t MBS2:1;
    vuint32_t MBS3:1;
    vuint32_t MBS4:1;
    vuint32_t MBS5:1;
    vuint32_t MBS6:1;
    vuint32_t MBS7:1;
    vuint32_t MBS8:1;
    vuint32_t MBS9:1;
    vuint32_t MBS10:1;
    vuint32_t MBS11:1;
    vuint32_t MBS12:1;
    vuint32_t MBS13:1;
    vuint32_t MBS14:1;
    vuint32_t MBS15:1;
    vuint32_t MBS16:1;
    vuint32_t MBS17:1;
    vuint32_t MBS18:1;
    vuint32_t MBS19:1;
    vuint32_t MBS20:1;
    vuint32_t MBS21:1;
    vuint32_t MBS22:1;
    vuint32_t MBS23:1;
    vuint32_t MBS24:1;
    vuint32_t MBS25:1;
    vuint32_t MBS26:1;
    vuint32_t MBS27:1;
    vuint32_t MBS28:1;
    vuint32_t MBS29:1;
    vuint32_t MBS30:1;
    vuint32_t MBS31:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS32:1;
    vuint32_t MBS33:1;
    vuint32_t MBS34:1;
    vuint32_t MBS35:1;
    vuint32_t MBS36:1;
    vuint32_t MBS37:1;
    vuint32_t MBS38:1;
    vuint32_t MBS39:1;
    vuint32_t MBS40:1;
    vuint32_t MBS41:1;
    vuint32_t MBS42:1;
    vuint32_t MBS43:1;
    vuint32_t MBS44:1;
    vuint32_t MBS45:1;
    vuint32_t MBS46:1;
    vuint32_t MBS47:1;
    vuint32_t MBS48:1;
    vuint32_t MBS49:1;
    vuint32_t MBS50:1;
    vuint32_t MBS51:1;
    vuint32_t MBS52:1;
    vuint32_t MBS53:1;
    vuint32_t MBS54:1;
    vuint32_t MBS55:1;
    vuint32_t MBS56:1;
    vuint32_t MBS57:1;
    vuint32_t MBS58:1;
    vuint32_t MBS59:1;
    vuint32_t MBS60:1;
    vuint32_t MBS61:1;
    vuint32_t MBS62:1;
    vuint32_t MBS63:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH0_union_tag {  /* STCU2 Off-Line MBIST Status High Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBS64:1;
    vuint32_t MBS65:1;
    vuint32_t MBS66:1;
    vuint32_t MBS67:1;
    vuint32_t MBS68:1;
    vuint32_t MBS69:1;
    vuint32_t MBS70:1;
    vuint32_t MBS71:1;
    vuint32_t MBS72:1;
    vuint32_t MBS73:1;
    vuint32_t MBS74:1;
    vuint32_t MBS75:1;
    vuint32_t MBS76:1;
    vuint32_t MBS77:1;
    vuint32_t MBS78:1;
    vuint32_t MBS79:1;
    vuint32_t MBS80:1;
    vuint32_t MBS81:1;
    vuint32_t MBS82:1;
    vuint32_t MBS83:1;
    vuint32_t MBS84:1;
    vuint32_t MBS85:1;
    vuint32_t MBS86:1;
    vuint32_t MBS87:1;
    vuint32_t MBS88:1;
    vuint32_t MBS89:1;
    vuint32_t MBS90:1;
    vuint32_t MBS91:1;
    vuint32_t MBS92:1;
    vuint32_t MBS93:1;
    vuint32_t MBS94:1;
    vuint32_t MBS95:1;
  } B;
} STCU2_MBSH0_tag;

typedef union STCU2_MBSH1_union_tag {  /* STCU2 Off-Line MBIST Status High Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBS96:1;
    vuint32_t MBS97:1;
    vuint32_t MBS98:1;
    vuint32_t MBS99:1;
    vuint32_t MBS100:1;
    vuint32_t MBS101:1;
    vuint32_t MBS102:1;
    vuint32_t MBS103:1;
    vuint32_t MBS104:1;
    vuint32_t MBS105:1;
    vuint32_t MBS106:1;
    vuint32_t MBS107:1;
    vuint32_t MBS108:1;
    vuint32_t MBS109:1;
    vuint32_t MBS110:1;
    vuint32_t MBS111:1;
    vuint32_t MBS112:1;
    vuint32_t MBS113:1;
    vuint32_t MBS114:1;
    vuint32_t MBS115:1;
    vuint32_t MBS116:1;
    vuint32_t MBS117:1;
    vuint32_t MBS118:1;
    vuint32_t MBS119:1;
    vuint32_t MBS120:1;
    vuint32_t MBS121:1;
    vuint32_t MBS122:1;
    vuint32_t MBS123:1;
    vuint32_t MBS124:1;
    vuint32_t MBS125:1;
    vuint32_t MBS126:1;
    vuint32_t MBS127:1;
  } B;
} STCU2_MBSH1_tag;

typedef union STCU2_MBSH2_union_tag {  /* STCU2 Off-Line MBIST Status High Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBS128:1;
    vuint32_t MBS129:1;
    vuint32_t MBS130:1;
    vuint32_t MBS131:1;
    vuint32_t MBS132:1;
    vuint32_t MBS133:1;
    vuint32_t MBS134:1;
    vuint32_t MBS135:1;
    vuint32_t MBS136:1;
    vuint32_t MBS137:1;
    vuint32_t MBS138:1;
    vuint32_t MBS139:1;
    vuint32_t MBS140:1;
    vuint32_t MBS141:1;
    vuint32_t MBS142:1;
    vuint32_t MBS143:1;
    vuint32_t MBS144:1;
    vuint32_t MBS145:1;
    vuint32_t MBS146:1;
    vuint32_t MBS147:1;
    vuint32_t MBS148:1;
    vuint32_t MBS149:1;
    vuint32_t MBS150:1;
    vuint32_t MBS151:1;
    vuint32_t MBS152:1;
    vuint32_t MBS153:1;
    vuint32_t MBS154:1;
    vuint32_t MBS155:1;
    vuint32_t MBS156:1;
    vuint32_t MBS157:1;
    vuint32_t MBS158:1;
    vuint32_t MBS159:1;
  } B;
} STCU2_MBSH2_tag;

typedef union STCU2_MBSH3_union_tag {  /* STCU2 Off-Line MBIST Status High Register 3 */
  vuint32_t R;
  struct {
    vuint32_t MBS160:1;
    vuint32_t MBS161:1;
    vuint32_t MBS162:1;
    vuint32_t MBS163:1;
    vuint32_t MBS164:1;
    vuint32_t MBS165:1;
    vuint32_t MBS166:1;
    vuint32_t MBS167:1;
    vuint32_t _unused_8:24;
  } B;
} STCU2_MBSH3_tag;

typedef union STCU2_MBSH4_union_tag {  /* STCU2 Off-Line MBIST Status High Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH4_tag;

typedef union STCU2_MBSH5_union_tag {  /* STCU2 Off-Line MBIST Status High Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH5_tag;

typedef union STCU2_MBSH6_union_tag {  /* STCU2 Off-Line MBIST Status High Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH6_tag;

typedef union STCU2_MBSH7_union_tag {  /* STCU2 Off-Line MBIST Status High Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH7_tag;

typedef union STCU2_MBSH8_union_tag {  /* STCU2 Off-Line MBIST Status High Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH8_tag;

typedef union STCU2_MBSH9_union_tag {  /* STCU2 Off-Line MBIST Status High Register 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH9_tag;

typedef union STCU2_MBSH10_union_tag { /* STCU2 Off-Line MBIST Status High Register 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH10_tag;

typedef union STCU2_MBSH11_union_tag { /* STCU2 Off-Line MBIST Status High Register 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH11_tag;

typedef union STCU2_MBSH12_union_tag { /* STCU2 Off-Line MBIST Status High Register 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH12_tag;

typedef union STCU2_MBSH13_union_tag { /* STCU2 Off-Line MBIST Status High Register 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSH13_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE0:1;
    vuint32_t MBE1:1;
    vuint32_t MBE2:1;
    vuint32_t MBE3:1;
    vuint32_t MBE4:1;
    vuint32_t MBE5:1;
    vuint32_t MBE6:1;
    vuint32_t MBE7:1;
    vuint32_t MBE8:1;
    vuint32_t MBE9:1;
    vuint32_t MBE10:1;
    vuint32_t MBE11:1;
    vuint32_t MBE12:1;
    vuint32_t MBE13:1;
    vuint32_t MBE14:1;
    vuint32_t MBE15:1;
    vuint32_t MBE16:1;
    vuint32_t MBE17:1;
    vuint32_t MBE18:1;
    vuint32_t MBE19:1;
    vuint32_t MBE20:1;
    vuint32_t MBE21:1;
    vuint32_t MBE22:1;
    vuint32_t MBE23:1;
    vuint32_t MBE24:1;
    vuint32_t MBE25:1;
    vuint32_t MBE26:1;
    vuint32_t MBE27:1;
    vuint32_t MBE28:1;
    vuint32_t MBE29:1;
    vuint32_t MBE30:1;
    vuint32_t MBE31:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE32:1;
    vuint32_t MBE33:1;
    vuint32_t MBE34:1;
    vuint32_t MBE35:1;
    vuint32_t MBE36:1;
    vuint32_t MBE37:1;
    vuint32_t MBE38:1;
    vuint32_t MBE39:1;
    vuint32_t MBE40:1;
    vuint32_t MBE41:1;
    vuint32_t MBE42:1;
    vuint32_t MBE43:1;
    vuint32_t MBE44:1;
    vuint32_t MBE45:1;
    vuint32_t MBE46:1;
    vuint32_t MBE47:1;
    vuint32_t MBE48:1;
    vuint32_t MBE49:1;
    vuint32_t MBE50:1;
    vuint32_t MBE51:1;
    vuint32_t MBE52:1;
    vuint32_t MBE53:1;
    vuint32_t MBE54:1;
    vuint32_t MBE55:1;
    vuint32_t MBE56:1;
    vuint32_t MBE57:1;
    vuint32_t MBE58:1;
    vuint32_t MBE59:1;
    vuint32_t MBE60:1;
    vuint32_t MBE61:1;
    vuint32_t MBE62:1;
    vuint32_t MBE63:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH0_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBE64:1;
    vuint32_t MBE65:1;
    vuint32_t MBE66:1;
    vuint32_t MBE67:1;
    vuint32_t MBE68:1;
    vuint32_t MBE69:1;
    vuint32_t MBE70:1;
    vuint32_t MBE71:1;
    vuint32_t MBE72:1;
    vuint32_t MBE73:1;
    vuint32_t MBE74:1;
    vuint32_t MBE75:1;
    vuint32_t MBE76:1;
    vuint32_t MBE77:1;
    vuint32_t MBE78:1;
    vuint32_t MBE79:1;
    vuint32_t MBE80:1;
    vuint32_t MBE81:1;
    vuint32_t MBE82:1;
    vuint32_t MBE83:1;
    vuint32_t MBE84:1;
    vuint32_t MBE85:1;
    vuint32_t MBE86:1;
    vuint32_t MBE87:1;
    vuint32_t MBE88:1;
    vuint32_t MBE89:1;
    vuint32_t MBE90:1;
    vuint32_t MBE91:1;
    vuint32_t MBE92:1;
    vuint32_t MBE93:1;
    vuint32_t MBE94:1;
    vuint32_t MBE95:1;
  } B;
} STCU2_MBEH0_tag;

typedef union STCU2_MBEH1_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBE96:1;
    vuint32_t MBE97:1;
    vuint32_t MBE98:1;
    vuint32_t MBE99:1;
    vuint32_t MBE100:1;
    vuint32_t MBE101:1;
    vuint32_t MBE102:1;
    vuint32_t MBE103:1;
    vuint32_t MBE104:1;
    vuint32_t MBE105:1;
    vuint32_t MBE106:1;
    vuint32_t MBE107:1;
    vuint32_t MBE108:1;
    vuint32_t MBE109:1;
    vuint32_t MBE110:1;
    vuint32_t MBE111:1;
    vuint32_t MBE112:1;
    vuint32_t MBE113:1;
    vuint32_t MBE114:1;
    vuint32_t MBE115:1;
    vuint32_t MBE116:1;
    vuint32_t MBE117:1;
    vuint32_t MBE118:1;
    vuint32_t MBE119:1;
    vuint32_t MBE120:1;
    vuint32_t MBE121:1;
    vuint32_t MBE122:1;
    vuint32_t MBE123:1;
    vuint32_t MBE124:1;
    vuint32_t MBE125:1;
    vuint32_t MBE126:1;
    vuint32_t MBE127:1;
  } B;
} STCU2_MBEH1_tag;

typedef union STCU2_MBEH2_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBE128:1;
    vuint32_t MBE129:1;
    vuint32_t MBE130:1;
    vuint32_t MBE131:1;
    vuint32_t MBE132:1;
    vuint32_t MBE133:1;
    vuint32_t MBE134:1;
    vuint32_t MBE135:1;
    vuint32_t MBE136:1;
    vuint32_t MBE137:1;
    vuint32_t MBE138:1;
    vuint32_t MBE139:1;
    vuint32_t MBE140:1;
    vuint32_t MBE141:1;
    vuint32_t MBE142:1;
    vuint32_t MBE143:1;
    vuint32_t MBE144:1;
    vuint32_t MBE145:1;
    vuint32_t MBE146:1;
    vuint32_t MBE147:1;
    vuint32_t MBE148:1;
    vuint32_t MBE149:1;
    vuint32_t MBE150:1;
    vuint32_t MBE151:1;
    vuint32_t MBE152:1;
    vuint32_t MBE153:1;
    vuint32_t MBE154:1;
    vuint32_t MBE155:1;
    vuint32_t MBE156:1;
    vuint32_t MBE157:1;
    vuint32_t MBE158:1;
    vuint32_t MBE159:1;
  } B;
} STCU2_MBEH2_tag;

typedef union STCU2_MBEH3_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 3 */
  vuint32_t R;
  struct {
    vuint32_t MBE160:1;
    vuint32_t MBE161:1;
    vuint32_t MBE162:1;
    vuint32_t MBE163:1;
    vuint32_t MBE164:1;
    vuint32_t MBE165:1;
    vuint32_t MBE166:1;
    vuint32_t MBE167:1;
    vuint32_t _unused_8:24;
  } B;
} STCU2_MBEH3_tag;

typedef union STCU2_MBEH4_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH4_tag;

typedef union STCU2_MBEH5_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH5_tag;

typedef union STCU2_MBEH6_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH6_tag;

typedef union STCU2_MBEH7_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH7_tag;

typedef union STCU2_MBEH8_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH8_tag;

typedef union STCU2_MBEH9_union_tag {  /* STCU2 Off-Line MBIST End Flag High Register 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH9_tag;

typedef union STCU2_MBEH10_union_tag { /* STCU2 Off-Line MBIST End Flag High Register 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH10_tag;

typedef union STCU2_MBEH11_union_tag { /* STCU2 Off-Line MBIST End Flag High Register 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH11_tag;

typedef union STCU2_MBEH12_union_tag { /* STCU2 Off-Line MBIST End Flag High Register 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH12_tag;

typedef union STCU2_MBEH13_union_tag { /* STCU2 Off-Line MBIST End Flag High Register 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEH13_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW0:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW31:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW32:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW63:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW0_union_tag { /* STCU2 On-Line MBIST Status High Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW64:1;
    vuint32_t MBSSW65:1;
    vuint32_t MBSSW66:1;
    vuint32_t MBSSW67:1;
    vuint32_t MBSSW68:1;
    vuint32_t MBSSW69:1;
    vuint32_t MBSSW70:1;
    vuint32_t MBSSW71:1;
    vuint32_t MBSSW72:1;
    vuint32_t MBSSW73:1;
    vuint32_t MBSSW74:1;
    vuint32_t MBSSW75:1;
    vuint32_t MBSSW76:1;
    vuint32_t MBSSW77:1;
    vuint32_t MBSSW78:1;
    vuint32_t MBSSW79:1;
    vuint32_t MBSSW80:1;
    vuint32_t MBSSW81:1;
    vuint32_t MBSSW82:1;
    vuint32_t MBSSW83:1;
    vuint32_t MBSSW84:1;
    vuint32_t MBSSW85:1;
    vuint32_t MBSSW86:1;
    vuint32_t MBSSW87:1;
    vuint32_t MBSSW88:1;
    vuint32_t MBSSW89:1;
    vuint32_t MBSSW90:1;
    vuint32_t MBSSW91:1;
    vuint32_t MBSSW92:1;
    vuint32_t MBSSW93:1;
    vuint32_t MBSSW94:1;
    vuint32_t MBSSW95:1;
  } B;
} STCU2_MBSHSW0_tag;

typedef union STCU2_MBSHSW1_union_tag { /* STCU2 On-Line MBIST Status High Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW96:1;
    vuint32_t MBSSW97:1;
    vuint32_t MBSSW398:1;
    vuint32_t MBSSW99:1;
    vuint32_t MBSSW100:1;
    vuint32_t MBSSW101:1;
    vuint32_t MBSSW102:1;
    vuint32_t MBSSW103:1;
    vuint32_t MBSSW104:1;
    vuint32_t MBSSW105:1;
    vuint32_t MBSSW106:1;
    vuint32_t MBSSW107:1;
    vuint32_t MBSSW108:1;
    vuint32_t MBSSW109:1;
    vuint32_t MBSSW110:1;
    vuint32_t MBSSW111:1;
    vuint32_t MBSSW112:1;
    vuint32_t MBSSW113:1;
    vuint32_t MBSSW114:1;
    vuint32_t MBSSW115:1;
    vuint32_t MBSSW116:1;
    vuint32_t MBSSW117:1;
    vuint32_t MBSSW118:1;
    vuint32_t MBSSW119:1;
    vuint32_t MBSSW120:1;
    vuint32_t MBSSW121:1;
    vuint32_t MBSSW122:1;
    vuint32_t MBSSW123:1;
    vuint32_t MBSSW124:1;
    vuint32_t MBSSW125:1;
    vuint32_t MBSSW126:1;
    vuint32_t MBSSW127:1;
  } B;
} STCU2_MBSHSW1_tag;

typedef union STCU2_MBSHSW2_union_tag { /* STCU2 On-Line MBIST Status High Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW128:1;
    vuint32_t MBSSW129:1;
    vuint32_t MBSSW130:1;
    vuint32_t MBSSW131:1;
    vuint32_t MBSSW132:1;
    vuint32_t MBSSW133:1;
    vuint32_t MBSSW134:1;
    vuint32_t MBSSW135:1;
    vuint32_t MBSSW136:1;
    vuint32_t MBSSW137:1;
    vuint32_t MBSSW138:1;
    vuint32_t MBSSW139:1;
    vuint32_t MBSSW140:1;
    vuint32_t MBSSW141:1;
    vuint32_t MBSSW142:1;
    vuint32_t MBSSW143:1;
    vuint32_t MBSSW144:1;
    vuint32_t MBSSW145:1;
    vuint32_t MBSSW146:1;
    vuint32_t MBSSW147:1;
    vuint32_t MBSSW148:1;
    vuint32_t MBSSW149:1;
    vuint32_t MBSSW150:1;
    vuint32_t MBSSW151:1;
    vuint32_t MBSSW152:1;
    vuint32_t MBSSW153:1;
    vuint32_t MBSSW154:1;
    vuint32_t MBSSW155:1;
    vuint32_t MBSSW156:1;
    vuint32_t MBSSW157:1;
    vuint32_t MBSSW158:1;
    vuint32_t MBSSW159:1;
  } B;
} STCU2_MBSHSW2_tag;

typedef union STCU2_MBSHSW3_union_tag { /* STCU2 On-Line MBIST Status High Register 3 */
  vuint32_t R;
  struct {
    vuint32_t MBSSW160:1;
    vuint32_t MBSSW161:1;
    vuint32_t MBSSW162:1;
    vuint32_t MBSSW163:1;
    vuint32_t MBSSW164:1;
    vuint32_t MBSSW165:1;
    vuint32_t MBSSW166:1;
    vuint32_t MBSSW167:1;
    vuint32_t _unused_8:24;
  } B;
} STCU2_MBSHSW3_tag;

typedef union STCU2_MBSHSW4_union_tag { /* STCU2 On-Line MBIST Status High Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW4_tag;

typedef union STCU2_MBSHSW5_union_tag { /* STCU2 On-Line MBIST Status High Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW5_tag;

typedef union STCU2_MBSHSW6_union_tag { /* STCU2 On-Line MBIST Status High Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW6_tag;

typedef union STCU2_MBSHSW7_union_tag { /* STCU2 On-Line MBIST Status High Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW7_tag;

typedef union STCU2_MBSHSW8_union_tag { /* STCU2 On-Line MBIST Status High Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW8_tag;

typedef union STCU2_MBSHSW9_union_tag { /* STCU2 On-Line MBIST Status High Register 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW9_tag;

typedef union STCU2_MBSHSW10_union_tag { /* STCU2 On-Line MBIST Status High Register 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW10_tag;

typedef union STCU2_MBSHSW11_union_tag { /* STCU2 On-Line MBIST Status High Register 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW11_tag;

typedef union STCU2_MBSHSW12_union_tag { /* STCU2 On-Line MBIST Status High Register 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW12_tag;

typedef union STCU2_MBSHSW13_union_tag { /* STCU2 On-Line MBIST Status High Register 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBSHSW13_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW0:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW31:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW32:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW63:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW0_union_tag { /* STCU2 On-Line MBIST End Flag High Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBESW64:1;
    vuint32_t MBESW65:1;
    vuint32_t MBESW66:1;
    vuint32_t MBESW67:1;
    vuint32_t MBESW68:1;
    vuint32_t MBESW69:1;
    vuint32_t MBESW70:1;
    vuint32_t MBESW71:1;
    vuint32_t MBESW72:1;
    vuint32_t MBESW73:1;
    vuint32_t MBESW74:1;
    vuint32_t MBESW75:1;
    vuint32_t MBESW76:1;
    vuint32_t MBESW77:1;
    vuint32_t MBESW78:1;
    vuint32_t MBESW79:1;
    vuint32_t MBESW80:1;
    vuint32_t MBESW81:1;
    vuint32_t MBESW82:1;
    vuint32_t MBESW83:1;
    vuint32_t MBESW84:1;
    vuint32_t MBESW85:1;
    vuint32_t MBESW86:1;
    vuint32_t MBESW87:1;
    vuint32_t MBESW88:1;
    vuint32_t MBESW89:1;
    vuint32_t MBESW90:1;
    vuint32_t MBESW91:1;
    vuint32_t MBESW92:1;
    vuint32_t MBESW93:1;
    vuint32_t MBESW94:1;
    vuint32_t MBESW95:1;
  } B;
} STCU2_MBEHSW0_tag;

typedef union STCU2_MBEHSW1_union_tag { /* STCU2 On-Line MBIST End Flag High Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MBEHSW96:1;
    vuint32_t MBEHSW97:1;
    vuint32_t MBEHSW98:1;
    vuint32_t MBEHSW99:1;
    vuint32_t MBEHSW100:1;
    vuint32_t MBEHSW101:1;
    vuint32_t MBEHSW102:1;
    vuint32_t MBEHSW103:1;
    vuint32_t MBEHSW104:1;
    vuint32_t MBEHSW105:1;
    vuint32_t MBEHSW106:1;
    vuint32_t MBEHSW107:1;
    vuint32_t MBEHSW108:1;
    vuint32_t MBEHSW109:1;
    vuint32_t MBEHSW110:1;
    vuint32_t MBEHSW111:1;
    vuint32_t MBEHSW112:1;
    vuint32_t MBEHSW113:1;
    vuint32_t MBEHSW114:1;
    vuint32_t MBEHSW115:1;
    vuint32_t MBEHSW116:1;
    vuint32_t MBEHSW117:1;
    vuint32_t MBEHSW118:1;
    vuint32_t MBEHSW119:1;
    vuint32_t MBEHSW120:1;
    vuint32_t MBEHSW121:1;
    vuint32_t MBEHSW122:1;
    vuint32_t MBEHSW123:1;
    vuint32_t MBEHSW124:1;
    vuint32_t MBEHSW125:1;
    vuint32_t MBEHSW126:1;
    vuint32_t MBEHSW127:1;
  } B;
} STCU2_MBEHSW1_tag;

typedef union STCU2_MBEHSW2_union_tag { /* STCU2 On-Line MBIST End Flag High Register 2 */
  vuint32_t R;
  struct {
    vuint32_t MBEHSW128:1;
    vuint32_t MBEHSW129:1;
    vuint32_t MBEHSW130:1;
    vuint32_t MBEHSW131:1;
    vuint32_t MBEHSW132:1;
    vuint32_t MBEHSW133:1;
    vuint32_t MBEHSW134:1;
    vuint32_t MBEHSW135:1;
    vuint32_t MBEHSW136:1;
    vuint32_t MBEHSW137:1;
    vuint32_t MBEHSW138:1;
    vuint32_t MBEHSW139:1;
    vuint32_t MBEHSW140:1;
    vuint32_t MBEHSW141:1;
    vuint32_t MBEHSW142:1;
    vuint32_t MBEHSW143:1;
    vuint32_t MBEHSW144:1;
    vuint32_t MBEHSW145:1;
    vuint32_t MBEHSW146:1;
    vuint32_t MBEHSW147:1;
    vuint32_t MBEHSW148:1;
    vuint32_t MBEHSW149:1;
    vuint32_t MBEHSW150:1;
    vuint32_t MBEHSW151:1;
    vuint32_t MBEHSW152:1;
    vuint32_t MBEHSW153:1;
    vuint32_t MBEHSW154:1;
    vuint32_t MBEHSW155:1;
    vuint32_t MBEHSW156:1;
    vuint32_t MBEHSW157:1;
    vuint32_t MBEHSW158:1;
    vuint32_t MBEHSW159:1;
  } B;
} STCU2_MBEHSW2_tag;

typedef union STCU2_MBEHSW3_union_tag { /* STCU2 On-Line MBIST End Flag High Register 3 */
  vuint32_t R;
  struct {
    vuint32_t MBEHSW160:1;
    vuint32_t MBEHSW161:1;
    vuint32_t MBEHSW162:1;
    vuint32_t MBEHSW163:1;
    vuint32_t MBEHSW164:1;
    vuint32_t MBEHSW165:1;
    vuint32_t MBEHSW166:1;
    vuint32_t MBEHSW167:1;
    vuint32_t _unused_8:24;
  } B;
} STCU2_MBEHSW3_tag;

typedef union STCU2_MBEHSW4_union_tag { /* STCU2 On-Line MBIST End Flag High Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW4_tag;

typedef union STCU2_MBEHSW5_union_tag { /* STCU2 On-Line MBIST End Flag High Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW5_tag;

typedef union STCU2_MBEHSW6_union_tag { /* STCU2 On-Line MBIST End Flag High Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW6_tag;

typedef union STCU2_MBEHSW7_union_tag { /* STCU2 On-Line MBIST End Flag High Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW7_tag;

typedef union STCU2_MBEHSW8_union_tag { /* STCU2 On-Line MBIST End Flag High Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW8_tag;

typedef union STCU2_MBEHSW9_union_tag { /* STCU2 On-Line MBIST End Flag High Register 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW9_tag;

typedef union STCU2_MBEHSW10_union_tag { /* STCU2 On-Line MBIST End Flag High Register 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW10_tag;

typedef union STCU2_MBEHSW11_union_tag { /* STCU2 On-Line MBIST End Flag High Register 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW11_tag;

typedef union STCU2_MBEHSW12_union_tag { /* STCU2 On-Line MBIST End Flag High Register 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW12_tag;

typedef union STCU2_MBEHSW13_union_tag { /* STCU2 On-Line MBIST End Flag High Register 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBEHSW13_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM0:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM31:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM32:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM63:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH0_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MBUFM64:1;
    vuint32_t MBUFM65:1;
    vuint32_t MBUFM66:1;
    vuint32_t MBUFM67:1;
    vuint32_t MBUFM68:1;
    vuint32_t MBUFM69:1;
    vuint32_t MBUFM70:1;
    vuint32_t MBUFM71:1;
    vuint32_t MBUFM72:1;
    vuint32_t MBUFM73:1;
    vuint32_t MBUFM74:1;
    vuint32_t MBUFM75:1;
    vuint32_t MBUFM76:1;
    vuint32_t MBUFM77:1;
    vuint32_t MBUFM78:1;
    vuint32_t MBUFM79:1;
    vuint32_t MBUFM80:1;
    vuint32_t MBUFM81:1;
    vuint32_t MBUFM82:1;
    vuint32_t MBUFM83:1;
    vuint32_t MBUFM84:1;
    vuint32_t MBUFM85:1;
    vuint32_t MBUFM86:1;
    vuint32_t MBUFM87:1;
    vuint32_t MBUFM88:1;
    vuint32_t MBUFM89:1;
    vuint32_t MBUFM90:1;
    vuint32_t MBUFM91:1;
    vuint32_t MBUFM92:1;
    vuint32_t MBUFM93:1;
    vuint32_t MBUFM94:1;
    vuint32_t MBUFM95:1;
  } B;
} STCU2_MBUFMH0_tag;

typedef union STCU2_MBUFMH1_union_tag { /* STCU2 MBIST Unrecoverable FM High Register1 */
  vuint32_t R;
  struct {
    vuint32_t MBUFMH96:1;
    vuint32_t MBUFM97:1;
    vuint32_t MBUFM98:1;
    vuint32_t MBUFM99:1;
    vuint32_t MBUFM100:1;
    vuint32_t MBUFM101:1;
    vuint32_t MBUFM102:1;
    vuint32_t MBUFM103:1;
    vuint32_t MBUFM104:1;
    vuint32_t MBUFM105:1;
    vuint32_t MBUFMH106:1;
    vuint32_t MBUFMH107:1;
    vuint32_t MBUFMH108:1;
    vuint32_t MBUFMH109:1;
    vuint32_t MBUFMH110:1;
    vuint32_t MBUFMH111:1;
    vuint32_t MBUFMH112:1;
    vuint32_t MBUFMH113:1;
    vuint32_t MBUFMH114:1;
    vuint32_t MBUFMH115:1;
    vuint32_t MBUFMH116:1;
    vuint32_t MBUFMH117:1;
    vuint32_t MBUFMH118:1;
    vuint32_t MBUFMH119:1;
    vuint32_t MBUFMH120:1;
    vuint32_t MBUFMH121:1;
    vuint32_t MBUFMH122:1;
    vuint32_t MBUFMH123:1;
    vuint32_t MBUFMH124:1;
    vuint32_t MBUFMH125:1;
    vuint32_t MBUFMH126:1;
    vuint32_t MBUFMH127:1;
  } B;
} STCU2_MBUFMH1_tag;

typedef union STCU2_MBUFMH2_union_tag { /* STCU2 MBIST Unrecoverable FM High Register2 */
  vuint32_t R;
  struct {
    vuint32_t MBUFMH128:1;
    vuint32_t MBUFMH129:1;
    vuint32_t MBUFMH130:1;
    vuint32_t MBUFMH131:1;
    vuint32_t MBUFMH132:1;
    vuint32_t MBUFMH133:1;
    vuint32_t MBUFMH134:1;
    vuint32_t MBUFMH135:1;
    vuint32_t MBUFMH136:1;
    vuint32_t MBUFMH137:1;
    vuint32_t MBUFMH138:1;
    vuint32_t MBUFMH139:1;
    vuint32_t MBUFMH140:1;
    vuint32_t MBUFMH141:1;
    vuint32_t MBUFMH142:1;
    vuint32_t MBUFMH143:1;
    vuint32_t MBUFMH144:1;
    vuint32_t MBUFMH145:1;
    vuint32_t MBUFMH146:1;
    vuint32_t MBUFMH147:1;
    vuint32_t MBUFMH148:1;
    vuint32_t MBUFMH149:1;
    vuint32_t MBUFMH150:1;
    vuint32_t MBUFMH151:1;
    vuint32_t MBUFMH152:1;
    vuint32_t MBUFMH153:1;
    vuint32_t MBUFMH154:1;
    vuint32_t MBUFMH155:1;
    vuint32_t MBUFMH156:1;
    vuint32_t MBUFMH157:1;
    vuint32_t MBUFMH158:1;
    vuint32_t MBUFMH159:1;
  } B;
} STCU2_MBUFMH2_tag;

typedef union STCU2_MBUFMH3_union_tag { /* STCU2 MBIST Unrecoverable FM High Register3 */
  vuint32_t R;
  struct {
    vuint32_t MBUFMH160:1;
    vuint32_t MBUFMH161:1;
    vuint32_t MBUFMH162:1;
    vuint32_t MBUFMH163:1;
    vuint32_t MBUFMH164:1;
    vuint32_t MBUFMH165:1;
    vuint32_t MBUFMH166:1;
    vuint32_t MBUFMH167:1;
    vuint32_t _unused_8:24;
  } B;
} STCU2_MBUFMH3_tag;

typedef union STCU2_MBUFMH4_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH4_tag;

typedef union STCU2_MBUFMH5_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH5_tag;

typedef union STCU2_MBUFMH6_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH6_tag;

typedef union STCU2_MBUFMH7_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH7_tag;

typedef union STCU2_MBUFMH8_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH8_tag;

typedef union STCU2_MBUFMH9_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 9 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH9_tag;

typedef union STCU2_MBUFMH10_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 10 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH10_tag;

typedef union STCU2_MBUFMH11_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 11 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH11_tag;

typedef union STCU2_MBUFMH12_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 12 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH12_tag;

typedef union STCU2_MBUFMH13_union_tag { /* STCU2 MBIST Unrecoverable FM High Register 13 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} STCU2_MBUFMH13_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:22;
    vuint32_t PTR:9;
    vuint32_t CSM:1;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  STCU2_INT_FLG_tag INT_FLG;           /* STCU2 Interrupt Flag Register */
  uint8_t STCU2_reserved0[8];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  uint8_t STCU2_reserved1[24];
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH0_tag MBSH0;               /* STCU2 Off-Line MBIST Status High Register 0 */
  STCU2_MBSH1_tag MBSH1;               /* STCU2 Off-Line MBIST Status High Register 1 */
  STCU2_MBSH2_tag MBSH2;               /* STCU2 Off-Line MBIST Status High Register 2 */
  STCU2_MBSH3_tag MBSH3;               /* STCU2 Off-Line MBIST Status High Register 3 */
  STCU2_MBSH4_tag MBSH4;               /* STCU2 Off-Line MBIST Status High Register 4 */
  STCU2_MBSH5_tag MBSH5;               /* STCU2 Off-Line MBIST Status High Register 5 */
  STCU2_MBSH6_tag MBSH6;               /* STCU2 Off-Line MBIST Status High Register 6 */
  STCU2_MBSH7_tag MBSH7;               /* STCU2 Off-Line MBIST Status High Register 7 */
  STCU2_MBSH8_tag MBSH8;               /* STCU2 Off-Line MBIST Status High Register 8 */
  STCU2_MBSH9_tag MBSH9;               /* STCU2 Off-Line MBIST Status High Register 9 */
  STCU2_MBSH10_tag MBSH10;             /* STCU2 Off-Line MBIST Status High Register 10 */
  STCU2_MBSH11_tag MBSH11;             /* STCU2 Off-Line MBIST Status High Register 11 */
  STCU2_MBSH12_tag MBSH12;             /* STCU2 Off-Line MBIST Status High Register 12 */
  STCU2_MBSH13_tag MBSH13;             /* STCU2 Off-Line MBIST Status High Register 13 */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH0_tag MBEH0;               /* STCU2 Off-Line MBIST End Flag High Register 0 */
  STCU2_MBEH1_tag MBEH1;               /* STCU2 Off-Line MBIST End Flag High Register 1 */
  STCU2_MBEH2_tag MBEH2;               /* STCU2 Off-Line MBIST End Flag High Register 2 */
  STCU2_MBEH3_tag MBEH3;               /* STCU2 Off-Line MBIST End Flag High Register 3 */
  STCU2_MBEH4_tag MBEH4;               /* STCU2 Off-Line MBIST End Flag High Register 4 */
  STCU2_MBEH5_tag MBEH5;               /* STCU2 Off-Line MBIST End Flag High Register 5 */
  STCU2_MBEH6_tag MBEH6;               /* STCU2 Off-Line MBIST End Flag High Register 6 */
  STCU2_MBEH7_tag MBEH7;               /* STCU2 Off-Line MBIST End Flag High Register 7 */
  STCU2_MBEH8_tag MBEH8;               /* STCU2 Off-Line MBIST End Flag High Register 8 */
  STCU2_MBEH9_tag MBEH9;               /* STCU2 Off-Line MBIST End Flag High Register 9 */
  STCU2_MBEH10_tag MBEH10;             /* STCU2 Off-Line MBIST End Flag High Register 10 */
  STCU2_MBEH11_tag MBEH11;             /* STCU2 Off-Line MBIST End Flag High Register 11 */
  STCU2_MBEH12_tag MBEH12;             /* STCU2 Off-Line MBIST End Flag High Register 12 */
  STCU2_MBEH13_tag MBEH13;             /* STCU2 Off-Line MBIST End Flag High Register 13 */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW0_tag MBSHSW0;           /* STCU2 On-Line MBIST Status High Register 0 */
  STCU2_MBSHSW1_tag MBSHSW1;           /* STCU2 On-Line MBIST Status High Register 1 */
  STCU2_MBSHSW2_tag MBSHSW2;           /* STCU2 On-Line MBIST Status High Register 2 */
  STCU2_MBSHSW3_tag MBSHSW3;           /* STCU2 On-Line MBIST Status High Register 3 */
  STCU2_MBSHSW4_tag MBSHSW4;           /* STCU2 On-Line MBIST Status High Register 4 */
  STCU2_MBSHSW5_tag MBSHSW5;           /* STCU2 On-Line MBIST Status High Register 5 */
  STCU2_MBSHSW6_tag MBSHSW6;           /* STCU2 On-Line MBIST Status High Register 6 */
  STCU2_MBSHSW7_tag MBSHSW7;           /* STCU2 On-Line MBIST Status High Register 7 */
  STCU2_MBSHSW8_tag MBSHSW8;           /* STCU2 On-Line MBIST Status High Register 8 */
  STCU2_MBSHSW9_tag MBSHSW9;           /* STCU2 On-Line MBIST Status High Register 9 */
  STCU2_MBSHSW10_tag MBSHSW10;         /* STCU2 On-Line MBIST Status High Register 10 */
  STCU2_MBSHSW11_tag MBSHSW11;         /* STCU2 On-Line MBIST Status High Register 11 */
  STCU2_MBSHSW12_tag MBSHSW12;         /* STCU2 On-Line MBIST Status High Register 12 */
  STCU2_MBSHSW13_tag MBSHSW13;         /* STCU2 On-Line MBIST Status High Register 13 */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW0_tag MBEHSW0;           /* STCU2 On-Line MBIST End Flag High Register 0 */
  STCU2_MBEHSW1_tag MBEHSW1;           /* STCU2 On-Line MBIST End Flag High Register 1 */
  STCU2_MBEHSW2_tag MBEHSW2;           /* STCU2 On-Line MBIST End Flag High Register 2 */
  STCU2_MBEHSW3_tag MBEHSW3;           /* STCU2 On-Line MBIST End Flag High Register 3 */
  STCU2_MBEHSW4_tag MBEHSW4;           /* STCU2 On-Line MBIST End Flag High Register 4 */
  STCU2_MBEHSW5_tag MBEHSW5;           /* STCU2 On-Line MBIST End Flag High Register 5 */
  STCU2_MBEHSW6_tag MBEHSW6;           /* STCU2 On-Line MBIST End Flag High Register 6 */
  STCU2_MBEHSW7_tag MBEHSW7;           /* STCU2 On-Line MBIST End Flag High Register 7 */
  STCU2_MBEHSW8_tag MBEHSW8;           /* STCU2 On-Line MBIST End Flag High Register 8 */
  STCU2_MBEHSW9_tag MBEHSW9;           /* STCU2 On-Line MBIST End Flag High Register 9 */
  STCU2_MBEHSW10_tag MBEHSW10;         /* STCU2 On-Line MBIST End Flag High Register 10 */
  STCU2_MBEHSW11_tag MBEHSW11;         /* STCU2 On-Line MBIST End Flag High Register 11 */
  STCU2_MBEHSW12_tag MBEHSW12;         /* STCU2 On-Line MBIST End Flag High Register 12 */
  STCU2_MBEHSW13_tag MBEHSW13;         /* STCU2 On-Line MBIST End Flag High Register 13 */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH0_tag MBUFMH0;           /* STCU2 MBIST Unrecoverable FM High Register 0 */
  STCU2_MBUFMH1_tag MBUFMH1;           /* STCU2 MBIST Unrecoverable FM High Register1 */
  STCU2_MBUFMH2_tag MBUFMH2;           /* STCU2 MBIST Unrecoverable FM High Register2 */
  STCU2_MBUFMH3_tag MBUFMH3;           /* STCU2 MBIST Unrecoverable FM High Register3 */
  STCU2_MBUFMH4_tag MBUFMH4;           /* STCU2 MBIST Unrecoverable FM High Register 4 */
  STCU2_MBUFMH5_tag MBUFMH5;           /* STCU2 MBIST Unrecoverable FM High Register 5 */
  STCU2_MBUFMH6_tag MBUFMH6;           /* STCU2 MBIST Unrecoverable FM High Register 6 */
  STCU2_MBUFMH7_tag MBUFMH7;           /* STCU2 MBIST Unrecoverable FM High Register 7 */
  STCU2_MBUFMH8_tag MBUFMH8;           /* STCU2 MBIST Unrecoverable FM High Register 8 */
  STCU2_MBUFMH9_tag MBUFMH9;           /* STCU2 MBIST Unrecoverable FM High Register 9 */
  STCU2_MBUFMH10_tag MBUFMH10;         /* STCU2 MBIST Unrecoverable FM High Register 10 */
  STCU2_MBUFMH11_tag MBUFMH11;         /* STCU2 MBIST Unrecoverable FM High Register 11 */
  STCU2_MBUFMH12_tag MBUFMH12;         /* STCU2 MBIST Unrecoverable FM High Register 12 */
  STCU2_MBUFMH13_tag MBUFMH13;         /* STCU2 MBIST Unrecoverable FM High Register 13 */
  uint8_t STCU2_reserved2[1404];
  STCU2_MB_CTRL_tag MB_CTRL[168];      /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t _unused_2:6;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_16:16;
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t CEN:1;                   /* Channel Enable */
    vuint32_t _unused_1:31;
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t WEN:1;
    vuint32_t FRZ:1;
    vuint32_t STP:1;
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t SLK:1;
    vuint32_t HLK:1;
    vuint32_t ITR:1;                   /* Interrupt Then Reset */
    vuint32_t WND:1;
    vuint32_t RIA:1;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t _unused_11:13;
    vuint32_t MAP7:1;
    vuint32_t MAP6:1;
    vuint32_t MAP5:1;
    vuint32_t MAP4:1;
    vuint32_t MAP3:1;
    vuint32_t MAP2:1;
    vuint32_t MAP1:1;
    vuint32_t MAP0:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
    vuint32_t _unused_1:31;
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t WSC:16;                  /* Watchdog Service Code */
    vuint32_t _unused_16:16;
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t SK:16;                   /* Service Key */
    vuint32_t _unused_16:16;
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: SXOSC ==============================
   ============================================================================ */

typedef union SXOSC_CTL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;
    vuint32_t I_OSC:1;                 /* SXOSC clock interrupt */
    vuint32_t OSCDIV:5;                /* The SXOSC Divider bits select the clock divider factor. */
    vuint32_t _unused_13:2;
    vuint32_t M_OSC:1;                 /* SXOSC clock interrupt mask */
    vuint32_t EOCV:8;                  /* End of Counter Value */
    vuint32_t _unused_24:6;
    vuint32_t ALC:1;                   /* Auto Level Control */
    vuint32_t OSCBYP:1;                /* Oscillator start-up delay bypass */
  } B;
} SXOSC_CTL_tag;

struct SXOSC_tag {
  SXOSC_CTL_tag CTL;
};


/* ============================================================================
   =============================== Module: TCON ===============================
   ============================================================================ */

typedef union TCON_CTRL1_union_tag {   /* TCON control1 register */
  vuint32_t R;
  struct {
    vuint32_t RSDS_MODE:1;
    vuint32_t RGB_PADDING:1;
    vuint32_t RGB_PADDING_EN:1;
    vuint32_t COLOR_DEPTH:1;
    vuint32_t VSYNC_INV:1;
    vuint32_t HSYNC_INV:1;
    vuint32_t VLEN:2;
    vuint32_t H_REF_SEL:2;
    vuint32_t V_REF_SEL:3;
    vuint32_t INIT_DELAY:3;
    vuint32_t TCONx_INV:12;
    vuint32_t INV_EN:1;
    vuint32_t TCON_BYPASS:1;
    vuint32_t _unused_30:1;
    vuint32_t TCON_EN:1;
  } B;
} TCON_CTRL1_tag;

typedef union TCON_BMC_union_tag {     /* Bit map control register */
  vuint32_t R;
  struct {
    vuint32_t BIT_SWAP:1;
    vuint32_t BIT_ORDER:1;
    vuint32_t COLOR_ORDER:3;
    vuint32_t CLK_POS:5;
    vuint32_t _unused_10:22;
  } B;
} TCON_BMC_tag;

typedef union TCON_COMP_union_tag {    /* Comparator configure register */
  vuint32_t R;
  struct {
    vuint32_t COMP_VALUE:12;
    vuint32_t _unused_12:19;
    vuint32_t FUNC_SEL:1;
  } B;
} TCON_COMP_tag;

typedef union TCON_COMP_MSK_union_tag { /* Comparator compare value mask register */
  vuint32_t R;
  struct {
    vuint32_t MSK:12;
    vuint32_t _unused_12:19;
    vuint32_t _unused_31:1;
  } B;
} TCON_COMP_MSK_tag;

typedef union TCON_PULSE_union_tag {   /* Pulse configure register */
  vuint32_t R;
  struct {
    vuint32_t RESET:12;
    vuint32_t _unused_12:2;
    vuint32_t COMPARATOR_SEL:2;
    vuint32_t SET:12;
    vuint32_t _unused_28:2;
    vuint32_t FUNC_SEL:2;
  } B;
} TCON_PULSE_tag;

typedef union TCON_PULSE_MSK_union_tag { /* Pulse compare value mask register */
  vuint32_t R;
  struct {
    vuint32_t RESET_MSK:12;
    vuint32_t _unused_12:4;
    vuint32_t SET_MSK:12;
    vuint32_t _unused_28:4;
  } B;
} TCON_PULSE_MSK_tag;

typedef union TCON_SMX_union_tag {     /* Function control register */
  vuint32_t R;
  struct {
    vuint32_t X_SEL:5;
    vuint32_t Y_SEL:5;
    vuint32_t _unused_10:10;
    vuint32_t INDEX0_SEL:3;
    vuint32_t INDEX1_SEL:3;
    vuint32_t INDEX2_SEL:3;
    vuint32_t INDEX3_SEL:3;
  } B;
} TCON_SMX_tag;

typedef union TCON_OMUX_LOW_union_tag { /* TCON output mux control low */
  vuint32_t R;
  struct {
    vuint32_t TCON0:5;
    vuint32_t TCON1:5;
    vuint32_t TCON2:5;
    vuint32_t TCON3:5;
    vuint32_t TCON4:5;
    vuint32_t TCON5:5;
    vuint32_t _unused_30:2;
  } B;
} TCON_OMUX_LOW_tag;

typedef union TCON_OMUX_HIGH_union_tag { /* TCON output mux control high */
  vuint32_t R;
  struct {
    vuint32_t TCON6:5;
    vuint32_t TCON7:5;
    vuint32_t TCON8:5;
    vuint32_t TCON9:5;
    vuint32_t TCON10:5;
    vuint32_t TCON11:5;
    vuint32_t _unused_30:2;
  } B;
} TCON_OMUX_HIGH_tag;

typedef union TCON_LUT_union_tag {     /* TCON look up table */
  vuint32_t R;
  struct {
    vuint32_t LUT:32;
  } B;
} TCON_LUT_tag;

typedef union TCON_DATA_DLY_union_tag { /* RSDS I/O control register */
  vuint32_t R;
  struct {
    vuint32_t SKEWOPT:8;
    vuint32_t CT_UP_LV:3;
    vuint32_t CT_DW_LV:3;
    vuint32_t _unused_14:1;
    vuint32_t POL:1;
    vuint32_t _unused_16:16;
  } B;
} TCON_DATA_DLY_tag;

typedef union TCON_CTRL2_union_tag {   /* TCON control2 register */
  vuint32_t R;
  struct {
    vuint32_t DIV_RATIO:8;
    vuint32_t _unused_8:8;
    vuint32_t CLK_OFFSET:9;
    vuint32_t _unused_25:7;
  } B;
} TCON_CTRL2_tag;

struct TCON_tag {
  TCON_CTRL1_tag CTRL1;                /* TCON control1 register */
  TCON_BMC_tag BMC;                    /* Bit map control register */
  TCON_COMP_tag COMP[4];               /* Comparator configure register */
  TCON_COMP_MSK_tag COMP_MSK[4];       /* Comparator compare value mask register */
  TCON_PULSE_tag PULSE[6];             /* Pulse configure register */
  TCON_PULSE_MSK_tag PULSE_MSK[6];     /* Pulse compare value mask register */
  TCON_SMX_tag SMX[14];                /* Function control register */
  TCON_OMUX_LOW_tag OMUX_LOW;          /* TCON output mux control low */
  TCON_OMUX_HIGH_tag OMUX_HIGH;        /* TCON output mux control high */
  TCON_LUT_tag LUT[14];                /* TCON look up table */
  TCON_DATA_DLY_tag DATA_DLY[13];      /* RSDS I/O control register */
  TCON_CTRL2_tag CTRL2;                /* TCON control2 register */
};


/* ============================================================================
   =============================== Module: TCON_1 =============================
   ============================================================================ */

typedef union TCON_1_CTRL1_union_tag { /* TCON control1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t COLOR_DEPTH:1;
    vuint32_t _unused_4:25;
    vuint32_t TCON_BYPASS:1;           /* Controls whether TCON_1 is bypassed */
    vuint32_t _unused_30:1;
    vuint32_t TCON_EN:1;
  } B;
} TCON_1_CTRL1_tag;

typedef union TCON_1_BMC_union_tag {   /* Bit map control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t BIT_ORDER:1;
    vuint32_t COLOR_ORDER:3;
    vuint32_t _unused_5:27;
  } B;
} TCON_1_BMC_tag;

struct TCON_1_tag {
  TCON_1_CTRL1_tag CTRL1;              /* TCON control1 register */
  TCON_1_BMC_tag BMC;                  /* Bit map control register */
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t TDRSR0:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR5:1;
    vuint32_t _unused_6:26;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t LFPAR:32;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[6];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: VIU ================================
   ============================================================================ */

typedef union VIU_SCR_union_tag {      /* Status And Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SOFT_RESET:1;
    vuint32_t FORMAT_CTRL:3;
    vuint32_t ERROR_CODE:4;
    vuint32_t FIELD_EN:1;
    vuint32_t VSYNC_EN:1;
    vuint32_t HSYNC_EN:1;
    vuint32_t VSTART_EN:1;
    vuint32_t DMA_END_EN:1;
    vuint32_t ERROR_EN:1;
    vuint32_t ECC_EN:1;
    vuint32_t _unused_15:1;
    vuint32_t FIELD_IRQ:1;
    vuint32_t VSYNC_IRQ:1;
    vuint32_t HSYNC_IRQ:1;
    vuint32_t VSTART_IRQ:1;
    vuint32_t DMA_END_IRQ:1;
    vuint32_t ERROR_IRQ:1;
    vuint32_t _unused_22:1;
    vuint32_t MODE444:1;
    vuint32_t BC_EN:1;
    vuint32_t YUV2RGB_EN:1;
    vuint32_t SCALER_EN:1;
    vuint32_t DMA_ACT:1;
    vuint32_t FIELD_NO:1;
    vuint32_t DITHER_ON:1;
    vuint32_t ROUND_ON:1;
    vuint32_t MODE32BIT:1;
  } B;
} VIU_SCR_tag;

typedef union VIU_DINVSZ_union_tag {   /* Detected Input Video Pixel and Line Counts */
  vuint32_t R;
  struct {
    vuint32_t DETECTED_PIXELC:16;
    vuint32_t DETECTED_LINEC:16;
  } B;
} VIU_DINVSZ_tag;

typedef union VIU_DINVFL_union_tag {   /* Detected Input Video Frame Length */
  vuint32_t R;
  struct {
    vuint32_t DETECTED_FRAME_WIDTH:16;
    vuint32_t DETECTED_FRAME_HEIGHT:16;
  } B;
} VIU_DINVFL_tag;

typedef union VIU_DMA_ADDR_union_tag { /* Base Address Of Every Field/Frame Of Picture In Memory */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t ADDR:29;
  } B;
} VIU_DMA_ADDR_tag;

typedef union VIU_DMA_INC_union_tag {  /* Horizontal DMA Increment */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;
    vuint32_t INC:13;
    vuint32_t _unused_16:16;
  } B;
} VIU_DMA_INC_tag;

typedef union VIU_INVSZ_union_tag {    /* Input Video Pixel and Line Count */
  vuint32_t R;
  struct {
    vuint32_t PIXELC:16;
    vuint32_t LINEC:16;
  } B;
} VIU_INVSZ_tag;

typedef union VIU_HPRALRM_union_tag {  /* High Priority Bus Request Alarm */
  vuint32_t R;
  struct {
    vuint32_t ALARM:16;
    vuint32_t _unused_16:16;
  } B;
} VIU_HPRALRM_tag;

typedef union VIU_ALPHA_union_tag {    /* Programable Alpha Value */
  vuint32_t R;
  struct {
    vuint32_t ALPHA:8;
    vuint32_t _unused_8:24;
  } B;
} VIU_ALPHA_tag;

typedef union VIU_HFACTOR_union_tag {  /* Scaling Factor In Horizontal Direction */
  vuint32_t R;
  struct {
    vuint32_t FACTOR:11;
    vuint32_t _unused_11:21;
  } B;
} VIU_HFACTOR_tag;

typedef union VIU_VFACTOR_union_tag {  /* Down Scaling Factor In Vertical Direction */
  vuint32_t R;
  struct {
    vuint32_t FACTOR:11;
    vuint32_t _unused_11:21;
  } B;
} VIU_VFACTOR_tag;

typedef union VIU_VID_SIZE_union_tag { /* Scaling Destination Pixel and Line Count */
  vuint32_t R;
  struct {
    vuint32_t PIXELC:16;
    vuint32_t LINEC:16;
  } B;
} VIU_VID_SIZE_tag;

typedef union VIU_LUT_ADDR_union_tag { /* B/C Adjust Look-up-table Current Address */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t ADDR:8;
    vuint32_t _unused_10:22;
  } B;
} VIU_LUT_ADDR_tag;

typedef union VIU_LUT_DATA_union_tag { /* B/C Adjust Look-up-table Data Entry */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;
  } B;
} VIU_LUT_DATA_tag;

typedef union VIU_EXT_CONFIG_union_tag { /* Extended Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HMIRROR_EN:1;
    vuint32_t DE_POL:1;
    vuint32_t HSYNC_POL:1;
    vuint32_t VSYNC_POL:1;
    vuint32_t PCLK_POL:1;
    vuint32_t INP_FORMAT:3;
    vuint32_t DE_VALID:1;
    vuint32_t RGB2YUV_EN:1;
    vuint32_t _unused_10:1;
    vuint32_t LENDIAN:1;
    vuint32_t CS_EN:1;
    vuint32_t MODE_8BIT:1;             /* 8 bit mode output format selector */
    vuint32_t MONO_LSB:1;              /* Data location selector on input data bus. */
    vuint32_t _unused_15:17;
  } B;
} VIU_EXT_CONFIG_tag;

typedef union VIU_ACT_ORG_union_tag {  /* Active Image Origin */
  vuint32_t R;
  struct {
    vuint32_t ACT_ORG_X:16;
    vuint32_t ACT_ORG_Y:16;
  } B;
} VIU_ACT_ORG_tag;

typedef union VIU_ACT_SIZE_union_tag { /* Active Image Size */
  vuint32_t R;
  struct {
    vuint32_t ACT_IMG_WIDTH:16;
    vuint32_t ACT_IMG_HEIGHT:16;
  } B;
} VIU_ACT_SIZE_tag;

struct VIU_tag {
  VIU_SCR_tag SCR;                     /* Status And Configuration Register */
  uint8_t VIU_reserved0[4];
  VIU_DINVSZ_tag DINVSZ;               /* Detected Input Video Pixel and Line Counts */
  VIU_DINVFL_tag DINVFL;               /* Detected Input Video Frame Length */
  uint8_t VIU_reserved1[4];
  VIU_DMA_ADDR_tag DMA_ADDR;           /* Base Address Of Every Field/Frame Of Picture In Memory */
  VIU_DMA_INC_tag DMA_INC;             /* Horizontal DMA Increment */
  VIU_INVSZ_tag INVSZ;                 /* Input Video Pixel and Line Count */
  VIU_HPRALRM_tag HPRALRM;             /* High Priority Bus Request Alarm */
  VIU_ALPHA_tag ALPHA;                 /* Programable Alpha Value */
  VIU_HFACTOR_tag HFACTOR;             /* Scaling Factor In Horizontal Direction */
  VIU_VFACTOR_tag VFACTOR;             /* Down Scaling Factor In Vertical Direction */
  VIU_VID_SIZE_tag VID_SIZE;           /* Scaling Destination Pixel and Line Count */
  VIU_LUT_ADDR_tag LUT_ADDR;           /* B/C Adjust Look-up-table Current Address */
  VIU_LUT_DATA_tag LUT_DATA;           /* B/C Adjust Look-up-table Data Entry */
  VIU_EXT_CONFIG_tag EXT_CONFIG;       /* Extended Configuration Register */
  uint8_t VIU_reserved2[12];
  VIU_ACT_ORG_tag ACT_ORG;             /* Active Image Origin */
  VIU_ACT_SIZE_tag ACT_SIZE;           /* Active Image Size */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_WISR_union_tag {    /* Wakeup/Interrupt Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t EIF:32;
  } B;
} WKPU_WISR_tag;

typedef union WKPU_IRER_union_tag {    /* Interrupt Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t EIRE:32;
  } B;
} WKPU_IRER_tag;

typedef union WKPU_WRER_union_tag {    /* Wakeup Request Enable Register */
  vuint32_t R;
  struct {
    vuint32_t WRE:32;
  } B;
} WKPU_WRER_tag;

typedef union WKPU_WIREER_union_tag {  /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IREE:32;
  } B;
} WKPU_WIREER_tag;

typedef union WKPU_WIFEER_union_tag {  /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFEEx:32;
  } B;
} WKPU_WIFEER_tag;

typedef union WKPU_WIFER_union_tag {   /* Wakeup/Interrupt Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IFE:32;
  } B;
} WKPU_WIFER_tag;

typedef union WKPU_WIPUER_union_tag {  /* Wakeup/Interrupt Pullup Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IPUE:32;
  } B;
} WKPU_WIPUER_tag;

struct WKPU_tag {
  uint8_t WKPU_reserved0[20];
  WKPU_WISR_tag WISR;                  /* Wakeup/Interrupt Status Flag Register */
  WKPU_IRER_tag IRER;                  /* Interrupt Request Enable Register */
  WKPU_WRER_tag WRER;                  /* Wakeup Request Enable Register */
  uint8_t WKPU_reserved1[8];
  WKPU_WIREER_tag WIREER;              /* Wakeup/Interrupt Rising-Edge Event Enable Register */
  WKPU_WIFEER_tag WIFEER;              /* Wakeup/Interrupt Falling-Edge Event Enable Register */
  WKPU_WIFER_tag WIFER;                /* Wakeup/Interrupt Filter Enable Register */
  WKPU_WIPUER_tag WIPUER;              /* Wakeup/Interrupt Pullup Enable Register */
};


/* ============================================================================
   =============================== Module: XRDC ===============================
   ============================================================================ */

typedef union XRDC_CR_union_tag {      /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t GVLD:1;
    vuint32_t HRL:4;
    vuint32_t  :2;
    vuint32_t MRF:1;
    vuint32_t VAW:1;
    vuint32_t  :21;
    vuint32_t LK1:1;
    vuint32_t  :1;
  } B;
} XRDC_CR_tag;

typedef union XRDC_HWCFG0_union_tag {  /* Hardware Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t NDID:8;
    vuint32_t NMSTR:8;
    vuint32_t NMRC:8;
    vuint32_t NPAC:4;
    vuint32_t  :1;
    vuint32_t  :3;
  } B;
} XRDC_HWCFG0_tag;

typedef union XRDC_HWCFG1_union_tag {  /* Hardware Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t  :28;
  } B;
} XRDC_HWCFG1_tag;

typedef union XRDC_HWCFG2_union_tag {  /* Hardware Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t PIDP0:1;
    vuint32_t PIDP1:1;
    vuint32_t PIDP2:1;
    vuint32_t PIDP3:1;
    vuint32_t PIDP4:1;
    vuint32_t PIDP5:1;
    vuint32_t PIDP6:1;
    vuint32_t PIDP7:1;
    vuint32_t PIDP8:1;
    vuint32_t PIDP9:1;
    vuint32_t PIDP10:1;
    vuint32_t PIDP11:1;
    vuint32_t PIDP12:1;
    vuint32_t PIDP13:1;
    vuint32_t PIDP14:1;
    vuint32_t PIDP15:1;
    vuint32_t PIDP16:1;
    vuint32_t PIDP17:1;
    vuint32_t PIDP18:1;
    vuint32_t PIDP19:1;
    vuint32_t PIDP20:1;
    vuint32_t PIDP21:1;
    vuint32_t PIDP22:1;
    vuint32_t PIDP23:1;
    vuint32_t PIDP24:1;
    vuint32_t PIDP25:1;
    vuint32_t PIDP26:1;
    vuint32_t PIDP27:1;
    vuint32_t PIDP28:1;
    vuint32_t PIDP29:1;
    vuint32_t PIDP30:1;
    vuint32_t PIDP31:1;
  } B;
} XRDC_HWCFG2_tag;

typedef union XRDC_HWCFG3_union_tag {  /* Hardware Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t PIDP32:1;
    vuint32_t PIDP33:1;
    vuint32_t PIDP34:1;
    vuint32_t PIDP35:1;
    vuint32_t PIDP36:1;
    vuint32_t PIDP37:1;
    vuint32_t PIDP38:1;
    vuint32_t PIDP39:1;
    vuint32_t PIDP40:1;
    vuint32_t PIDP41:1;
    vuint32_t PIDP42:1;
    vuint32_t PIDP43:1;
    vuint32_t PIDP44:1;
    vuint32_t PIDP45:1;
    vuint32_t PIDP46:1;
    vuint32_t PIDP47:1;
    vuint32_t PIDP48:1;
    vuint32_t PIDP49:1;
    vuint32_t PIDP50:1;
    vuint32_t PIDP51:1;
    vuint32_t PIDP52:1;
    vuint32_t PIDP53:1;
    vuint32_t PIDP54:1;
    vuint32_t PIDP55:1;
    vuint32_t PIDP56:1;
    vuint32_t PIDP57:1;
    vuint32_t PIDP58:1;
    vuint32_t PIDP59:1;
    vuint32_t PIDP60:1;
    vuint32_t PIDP61:1;
    vuint32_t PIDP62:1;
    vuint32_t PIDP63:1;
  } B;
} XRDC_HWCFG3_tag;

typedef union XRDC_MDACFG_union_tag {  /* Master Domain Assignment Configuration Register */
  vuint8_t R;
  struct {
    vuint8_t NMDAR:4;
    vuint8_t  :3;
    vuint8_t NCM:1;
  } B;
} XRDC_MDACFG_tag;

typedef union XRDC_MRCFG_union_tag {   /* Memory Region Configuration Register */
  vuint8_t R;
  struct {
    vuint8_t NMGD:5;
    vuint8_t  :3;
  } B;
} XRDC_MRCFG_tag;

typedef union XRDC_DERRLOC_union_tag { /* Domain Error Location Register */
  vuint32_t R;
  struct {
    vuint32_t MRCINST:16;
    vuint32_t PACINST:4;
    vuint32_t  :12;
  } B;
} XRDC_DERRLOC_tag;

typedef union XRDC_CHANNEL_DERR_W0_union_tag { /* Domain Error Word0 Register */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;
  } B;
} XRDC_CHANNEL_DERR_W0_tag;

typedef union XRDC_CHANNEL_DERR_W1_union_tag { /* Domain Error Word1 Register */
  vuint32_t R;
  struct {
    vuint32_t EDID:4;
    vuint32_t  :4;
    vuint32_t EATR:3;
    vuint32_t ERW:1;
    vuint32_t  :12;
    vuint32_t EPORT:3;
    vuint32_t  :3;
    vuint32_t EST:2;
  } B;
} XRDC_CHANNEL_DERR_W1_tag;

typedef union XRDC_CHANNEL_DERR_W2_union_tag { /* Domain Error Word2 Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} XRDC_CHANNEL_DERR_W2_tag;

typedef union XRDC_CHANNEL_DERR_W3_union_tag { /* Domain Error Word3 Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t RECR:2;
  } B;
} XRDC_CHANNEL_DERR_W3_tag;

typedef struct XRDC_CHANNEL_struct_tag {
  XRDC_CHANNEL_DERR_W0_tag DERR_W0;    /* Domain Error Word0 Register */
  XRDC_CHANNEL_DERR_W1_tag DERR_W1;    /* Domain Error Word1 Register */
  XRDC_CHANNEL_DERR_W2_tag DERR_W2;    /* Domain Error Word2 Register */
  XRDC_CHANNEL_DERR_W3_tag DERR_W3;    /* Domain Error Word3 Register */
} XRDC_CHANNEL_tag;

typedef union XRDC_PID_union_tag {     /* Process Identifier */
  vuint32_t R;
  struct {
    vuint32_t PID:6;
    vuint32_t  :22;
    vuint32_t TSM:1;
    vuint32_t LK2:2;
    vuint32_t  :1;
  } B;
} XRDC_PID_tag;

typedef union XRDC_W0_union_tag {      /* Master Domain Assignment W0 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W0_tag;

typedef union XRDC_W1_union_tag {      /* Master Domain Assignment W1 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W1_tag;

typedef union XRDC_W2_union_tag {      /* Master Domain Assignment W2 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W2_tag;

typedef union XRDC_W3_union_tag {      /* Master Domain Assignment W3 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W3_tag;

typedef union XRDC_W4_union_tag {      /* Master Domain Assignment W4 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W4_tag;

typedef union XRDC_W5_union_tag {      /* Master Domain Assignment W5 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W5_tag;

typedef union XRDC_W6_union_tag {      /* Master Domain Assignment W6 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_W6_tag;

typedef union XRDC_MDA_W7__union_tag { /* Master Domain Assignment W7 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W7__tag;

typedef union XRDC_MDA_W0_union_tag {  /* Master Domain Assignment W0 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W0_tag;

typedef union XRDC_MDA_W1_union_tag {  /* Master Domain Assignment W1 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W1_tag;

typedef union XRDC_MDA_W2_union_tag {  /* Master Domain Assignment W2 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W2_tag;

typedef union XRDC_MDA_W3_union_tag {  /* Master Domain Assignment W3 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W3_tag;

typedef union XRDC_MDA_W4_union_tag {  /* Master Domain Assignment W4 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W4_tag;

typedef union XRDC_MDA_W5_union_tag {  /* Master Domain Assignment W5 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W5_tag;

typedef union XRDC_MDA_W6_union_tag {  /* Master Domain Assignment W6 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W6_tag;

typedef union XRDC_MDA_W7_union_tag {  /* Master Domain Assignment W7 */
  vuint32_t R;
  struct {
    vuint32_t DID:4;
    vuint32_t DIDSPA:2;
    vuint32_t PESA:2;
    vuint32_t PIDMDIDB:14;
    vuint32_t  :2;
    vuint32_t LPID:4;
    vuint32_t LPE:1;
    vuint32_t DFMT:1;
    vuint32_t LK1:1;
    vuint32_t VLD:1;
  } B;
} XRDC_MDA_W7_tag;

typedef struct XRDC_MDA_struct_tag {
  XRDC_MDA_W0_tag W0;                  /* Master Domain Assignment W0 */
  XRDC_MDA_W1_tag W1;                  /* Master Domain Assignment W1 */
  XRDC_MDA_W2_tag W2;                  /* Master Domain Assignment W2 */
  XRDC_MDA_W3_tag W3;                  /* Master Domain Assignment W3 */
  XRDC_MDA_W4_tag W4;                  /* Master Domain Assignment W4 */
  XRDC_MDA_W5_tag W5;                  /* Master Domain Assignment W5 */
  XRDC_MDA_W6_tag W6;                  /* Master Domain Assignment W6 */
  XRDC_MDA_W7_tag W7;                  /* Master Domain Assignment W7 */
} XRDC_MDA_tag;

typedef union XRDC_PDAC_W0_union_tag { /* Peripheral Domain Access Control W0 */
  vuint32_t R;
  struct {
    vuint32_t D0ACP:3;
    vuint32_t D1ACP:3;
    vuint32_t D2ACP:3;
    vuint32_t D3ACP:3;
    vuint32_t D4ACP:3;
    vuint32_t D5ACP:3;
    vuint32_t D6ACP:3;
    vuint32_t D7ACP:3;
    vuint32_t SNUM:4;
    vuint32_t  :2;
    vuint32_t SE:1;
    vuint32_t  :1;
  } B;
} XRDC_PDAC_W0_tag;

typedef union XRDC_PDAC_W1_union_tag { /* Peripheral Domain Access Control W1 */
  vuint32_t R;
  struct {
    vuint32_t D8ACP:3;
    vuint32_t D9ACP:3;
    vuint32_t D10ACP:3;
    vuint32_t D11ACP:3;
    vuint32_t D12ACP:3;
    vuint32_t D13ACP:3;
    vuint32_t D14ACP:3;
    vuint32_t D15ACP:3;
    vuint32_t  :5;
    vuint32_t LK2:2;
    vuint32_t VLD:1;
  } B;
} XRDC_PDAC_W1_tag;

typedef struct XRDC_PDAC_struct_tag {
  XRDC_PDAC_W0_tag W0;                 /* Peripheral Domain Access Control W0 */
  XRDC_PDAC_W1_tag W1;                 /* Peripheral Domain Access Control W1 */
} XRDC_PDAC_tag;

typedef union XRDC_MRGD_W0_union_tag { /* Memory Region Descriptor W0 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t SRTADDR:27;
  } B;
} XRDC_MRGD_W0_tag;

typedef union XRDC_MRGD_W1_union_tag { /* Memory Region Descriptor W1 */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t ENDADDR:27;
  } B;
} XRDC_MRGD_W1_tag;

typedef union XRDC_MRGD_W2_union_tag { /* Memory Region Descriptor W2 */
  vuint32_t R;
  struct {
    vuint32_t D0ACP:3;
    vuint32_t D1ACP:3;
    vuint32_t D2ACP:3;
    vuint32_t D3ACP:3;
    vuint32_t D4ACP:3;
    vuint32_t D5ACP:3;
    vuint32_t D6ACP:3;
    vuint32_t D7ACP:3;
    vuint32_t SNUM:4;
    vuint32_t  :2;
    vuint32_t SE:1;
    vuint32_t  :1;
  } B;
} XRDC_MRGD_W2_tag;

typedef union XRDC_MRGD_W3_union_tag { /* Memory Region Descriptor W3 */
  vuint32_t R;
  struct {
    vuint32_t D8ACP:3;
    vuint32_t D9ACP:3;
    vuint32_t D10ACP:3;
    vuint32_t D11ACP:3;
    vuint32_t D12ACP:3;
    vuint32_t D13ACP:3;
    vuint32_t D14ACP:3;
    vuint32_t D15ACP:3;
    vuint32_t  :5;
    vuint32_t LK2:2;
    vuint32_t VLD:1;
  } B;
} XRDC_MRGD_W3_tag;

typedef union XRDC_MRGD_W4_union_tag { /* Memory Region Descriptor W4 */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} XRDC_MRGD_W4_tag;

typedef union XRDC_MRGD_W5_union_tag { /* Memory Region Descriptor W5 */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} XRDC_MRGD_W5_tag;

typedef union XRDC_MRGD_W6_union_tag { /* Memory Region Descriptor W6 */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} XRDC_MRGD_W6_tag;

typedef union XRDC_MRGD_W7_union_tag { /* Memory Region Descriptor W7 */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} XRDC_MRGD_W7_tag;

typedef struct XRDC_MRGD_struct_tag {
  XRDC_MRGD_W0_tag W0;                 /* Memory Region Descriptor W0 */
  XRDC_MRGD_W1_tag W1;                 /* Memory Region Descriptor W1 */
  XRDC_MRGD_W2_tag W2;                 /* Memory Region Descriptor W2 */
  XRDC_MRGD_W3_tag W3;                 /* Memory Region Descriptor W3 */
  XRDC_MRGD_W4_tag W4;                 /* Memory Region Descriptor W4 */
  XRDC_MRGD_W5_tag W5;                 /* Memory Region Descriptor W5 */
  XRDC_MRGD_W6_tag W6;                 /* Memory Region Descriptor W6 */
  XRDC_MRGD_W7_tag W7;                 /* Memory Region Descriptor W7 */
} XRDC_MRGD_tag;

struct XRDC_tag {
  XRDC_CR_tag CR;                      /* Control Register */
  uint8_t XRDC_reserved0[236];
  XRDC_HWCFG0_tag HWCFG0;              /* Hardware Configuration Register 0 */
  XRDC_HWCFG1_tag HWCFG1;              /* Hardware Configuration Register 1 */
  XRDC_HWCFG2_tag HWCFG2;              /* Hardware Configuration Register 2 */
  XRDC_HWCFG3_tag HWCFG3;              /* Hardware Configuration Register 3 */
  XRDC_MDACFG_tag MDACFG[64];          /* Master Domain Assignment Configuration Register */
  XRDC_MRCFG_tag MRCFG[16];            /* Memory Region Configuration Register */
  uint8_t XRDC_reserved1[176];
  XRDC_DERRLOC_tag DERRLOC[16];        /* Domain Error Location Register */
  uint8_t XRDC_reserved2[448];
  XRDC_CHANNEL_tag CHANNEL[20];
  uint8_t XRDC_reserved3[448];
  XRDC_PID_tag PID[64];                /* Process Identifier */
  XRDC_W0_tag W0[1];                   /* Master Domain Assignment W0 */
  XRDC_W1_tag W1[1];                   /* Master Domain Assignment W1 */
  XRDC_W2_tag W2[1];                   /* Master Domain Assignment W2 */
  XRDC_W3_tag W3[1];                   /* Master Domain Assignment W3 */
  XRDC_W4_tag W4[1];                   /* Master Domain Assignment W4 */
  XRDC_W5_tag W5[1];                   /* Master Domain Assignment W5 */
  XRDC_W6_tag W6[1];                   /* Master Domain Assignment W6 */
  XRDC_MDA_W7__tag MDA_W7_[1];         /* Master Domain Assignment W7 */
  XRDC_MDA_tag MDA[63];
  XRDC_PDAC_tag PDAC[512];
  XRDC_MRGD_tag MRGD[256];
};

#define ADC (*(volatile struct ADC_tag *) 0x400BE000UL)
#define AIPS_0 (*(volatile struct AIPS_tag *) 0x40000000UL)
#define AIPS_1 (*(volatile struct AIPS_tag *) 0x40080000UL)
#define AXBS (*(volatile struct AXBS_tag *) 0x40081000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0x400E4000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0x400F8000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0x400BC000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0x400BD000UL)
#define CM4 (*(volatile struct CM4_tag *) 0xE0000000UL)
#define CMP_0 (*(volatile struct CMP_tag *) 0x400A9000UL)
#define CMP_1 (*(volatile struct CMP_tag *) 0x400AA000UL)
#define CMU (*(volatile struct CMU_tag *) 0x400E8000UL)
#define CRC (*(volatile struct CRC_tag *) 0x400C2000UL)
#define CSE (*(volatile struct CSE_tag *) 0x40098000UL)
#define DCU_0 (*(volatile struct DCU_tag *) 0x40028000UL)
#define DCU_1 (*(volatile struct DCU_tag *) 0x40038000UL)
#define DDRC_PRIOMAN (*(volatile struct DDRC_PRIOMAN_tag *) 0x40024000UL)
#define DMA_0 (*(volatile struct DMA_tag *) 0x40090000UL)
#define DMA_1 (*(volatile struct DMA_tag *) 0x40092000UL)
#define DMAMUX (*(volatile struct DMAMUX_tag *) 0x400A1000UL)
#define EIM (*(volatile struct EIM_tag *) 0x40005000UL)
#define ENET (*(volatile struct ENET_tag *) 0x40064000UL)
#define ERM (*(volatile struct ERM_tag *) 0x40006000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0x400C6000UL)
#define FIRC (*(volatile struct FIRC_tag *) 0x400D4200UL)
#define FTM_0 (*(volatile struct FTM_tag *) 0x400A4000UL)
#define FTM_1 (*(volatile struct FTM_tag *) 0x400A5000UL)
#define FTM_2 (*(volatile struct FTM_tag *) 0x400A6000UL)
#define FTM_3 (*(volatile struct FTM_tag *) 0x400A7000UL)
#define FXOSC (*(volatile struct FXOSC_tag *) 0x400D4380UL)
#define GC355 (*(volatile struct GC355_tag *) 0x4004C000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0x400A2000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0x400A3000UL)
#define IOP (*(volatile struct IOP_tag *) 0x400E0000UL)
#define JDC (*(volatile struct JDC_tag *) 0x400C0000UL)
#define LCD (*(volatile struct LCD_tag *) 0x400BB000UL)
#define LDB (*(volatile struct LDB_tag *) 0x40068000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0x400B8000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0x400B9000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0x400BA000UL)
#define LMEM (*(volatile struct LMEM_tag *) 0xE0082000UL)
#define MCM (*(volatile struct MCM_tag *) 0xE0080000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0x400D4000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0x400D8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0x400C8000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0x400D0000UL)
#define MDDRC (*(volatile struct MDDRC_tag *) 0x40024000UL)
#define MLB (*(volatile struct MLB_tag *) 0x4006C000UL)
#define MPR (*(volatile struct MPR_tag *) 0x400B2000UL)
#define MSCM (*(volatile struct MSCM_tag *) 0x40085000UL)
#define PASS (*(volatile struct PASS_tag *) 0x400F0000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0x4009C000UL)
#define PIT (*(volatile struct PIT_tag *) 0x400C4000UL)
#define PLLDIG_0 (*(volatile struct PLLDIG_tag *) 0x400D4000UL)
#define PLLDIG_1 (*(volatile struct PLLDIG_tag *) 0x400D4080UL)
#define PLLDIG_2 (*(volatile struct PLLDIG_tag *) 0x400D4100UL)
#define PLLDIG_3 (*(volatile struct PLLDIG_tag *) 0x400D4180UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0x400CC000UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0x40018000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0x4001C000UL)
#define QuadSPI_0 (*(volatile struct QuadSPI_tag *) 0x40020000UL)
#define QuadSPI_1 (*(volatile struct QuadSPI_tag *) 0x40021000UL)
#define RLE_DEC (*(volatile struct RLE_DEC_tag *) 0x40058000UL)
#define RTC (*(volatile struct RTC_tag *) 0x400F4000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0x40083000UL)
#define SGM (*(volatile struct SGM_tag *) 0x4005C000UL)
#define SIRC (*(volatile struct SIRC_tag *) 0x400D4280UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0x400DC000UL)
#define SMC (*(volatile struct SMC_tag *) 0x400AB000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0x400B3000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0x400B4000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0x400B5000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0x400B6000UL)
#define SPI_4 (*(volatile struct SPI_tag *) 0x400B7000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0x400EC000UL)
#define SSD_0 (*(volatile struct SSD_tag *) 0x400AC000UL)
#define SSD_1 (*(volatile struct SSD_tag *) 0x400AD000UL)
#define SSD_2 (*(volatile struct SSD_tag *) 0x400AE000UL)
#define SSD_3 (*(volatile struct SSD_tag *) 0x400AF000UL)
#define SSD_4 (*(volatile struct SSD_tag *) 0x400B0000UL)
#define SSD_5 (*(volatile struct SSD_tag *) 0x400B1000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0x400FC000UL)
#define STM_0 (*(volatile struct STM_tag *) 0x4008C000UL)
#define STM_1 (*(volatile struct STM_tag *) 0x4008D000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0x40088000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0x40089000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0x4008A000UL)
#define SXOSC (*(volatile struct SXOSC_tag *) 0x400D4300UL)
#define TCON (*(volatile struct TCON_tag *) 0x40050000UL)
#define TCON_1 (*(volatile struct TCON_1_tag *) 0x40054000UL)
#define TDM (*(volatile struct TDM_tag *) 0x400BF000UL)
#define VIU (*(volatile struct VIU_tag *) 0x40048000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0x400C5000UL)
#define XRDC (*(volatile struct XRDC_tag *) 0x40094000UL)

/* ADC */
#define ADC_MCR              ADC.MCR.R                     /* Main Configuration Register */
#define ADC_MSR              ADC.MSR.R                     /* Main Status register */
#define ADC_ISR              ADC.ISR.R                     /* Interrupt Status Register */
#define ADC_CEOCFR0          ADC.CEOCFR0.R                 /* Channel Pending register 0 */
#define ADC_CEOCFR1          ADC.CEOCFR1.R                 /* Channel Pending register 1 */
#define ADC_IMR              ADC.IMR.R                     /* Interrupt Mask Register */
#define ADC_CIMR0            ADC.CIMR0.R                   /* Channel Interrupt Mask Register 0 */
#define ADC_CIMR1            ADC.CIMR1.R                   /* Channel Interrupt Mask Register 1 */
#define ADC_WTISR            ADC.WTISR.R                   /* Watchdog Threshold Interrupt Status Register */
#define ADC_WTIMR            ADC.WTIMR.R                   /* Watchdog Threshold Interrupt Mask Register */
#define ADC_DMAE             ADC.DMAE.R                    /* DMA Enable register */
#define ADC_DMAR0            ADC.DMAR0.R                   /* DMA Channel Select Register 0 */
#define ADC_DMAR1            ADC.DMAR1.R                   /* DMA Channel Select Register 1 */
#define ADC_THRHLR0          ADC.THRHLR0.R                 /* Threshold Register */
#define ADC_THRHLR1          ADC.THRHLR1.R                 /* Threshold Register */
#define ADC_THRHLR2          ADC.THRHLR2.R                 /* Threshold Register */
#define ADC_THRHLR3          ADC.THRHLR3.R                 /* Threshold Register */
#define ADC_PSCR             ADC.PSCR.R                    /* Presampling Control Register */
#define ADC_PSR0             ADC.PSR0.R                    /* Presampling register 0 */
#define ADC_PSR1             ADC.PSR1.R                    /* Presampling register 1 */
#define ADC_CTR0             ADC.CTR0.R                    /* Conversion Timing Register 0 */
#define ADC_CTR1             ADC.CTR1.R                    /* Conversion Timing Register 1 */
#define ADC_NCMR0            ADC.NCMR0.R                   /* Normal Conversion Mask Register 0 */
#define ADC_NCMR1            ADC.NCMR1.R                   /* Normal Conversion Mask Register 1 */
#define ADC_JCMR0            ADC.JCMR0.R                   /* Injected Conversion Mask Register 0 */
#define ADC_JCMR1            ADC.JCMR1.R                   /* Injected Conversion Mask Register 1 */
#define ADC_PDEDR            ADC.PDEDR.R                   /* Power Down Exit Delay Register */
#define ADC_CDR0             ADC.CDR[0].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR1             ADC.CDR[1].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR2             ADC.CDR[2].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR3             ADC.CDR[3].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR4             ADC.CDR[4].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR5             ADC.CDR[5].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR6             ADC.CDR[6].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR7             ADC.CDR[7].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR8             ADC.CDR[8].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR9             ADC.CDR[9].R                  /* Channel Data Register n (Precision Channels) */
#define ADC_CDR10            ADC.CDR[10].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR11            ADC.CDR[11].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR12            ADC.CDR[12].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR13            ADC.CDR[13].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR14            ADC.CDR[14].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR15            ADC.CDR[15].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR16            ADC.CDR[16].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR17            ADC.CDR[17].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR18            ADC.CDR[18].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR19            ADC.CDR[19].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR20            ADC.CDR[20].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR21            ADC.CDR[21].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR22            ADC.CDR[22].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR23            ADC.CDR[23].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR24            ADC.CDR[24].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR25            ADC.CDR[25].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR26            ADC.CDR[26].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR27            ADC.CDR[27].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR28            ADC.CDR[28].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR29            ADC.CDR[29].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR30            ADC.CDR[30].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR31            ADC.CDR[31].R                 /* Channel Data Register n (Precision Channels) */
#define ADC_CDR32            ADC.CDR[32].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR33            ADC.CDR[33].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR34            ADC.CDR[34].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR35            ADC.CDR[35].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR36            ADC.CDR[36].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR37            ADC.CDR[37].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR38            ADC.CDR[38].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR39            ADC.CDR[39].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR40            ADC.CDR[40].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR41            ADC.CDR[41].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR42            ADC.CDR[42].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR43            ADC.CDR[43].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR44            ADC.CDR[44].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR45            ADC.CDR[45].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR46            ADC.CDR[46].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_CDR47            ADC.CDR[47].R                 /* Channel Data Register n (Internal Channels) */
#define ADC_THRHLR4          ADC.THRHLR4.R                 /* Threshold Register */
#define ADC_THRHLR5          ADC.THRHLR5.R                 /* Threshold Register */
#define ADC_THRHLR6          ADC.THRHLR6.R                 /* Threshold Register */
#define ADC_THRHLR7          ADC.THRHLR7.R                 /* Threshold Register */
#define ADC_THRHLR8          ADC.THRHLR8.R                 /* Threshold Register */
#define ADC_THRHLR9          ADC.THRHLR9.R                 /* Threshold Register */
#define ADC_THRHLR10         ADC.THRHLR10.R                /* Threshold Register */
#define ADC_THRHLR11         ADC.THRHLR11.R                /* Threshold Register */
#define ADC_THRHLR12         ADC.THRHLR12.R                /* Threshold Register */
#define ADC_THRHLR13         ADC.THRHLR13.R                /* Threshold Register */
#define ADC_THRHLR14         ADC.THRHLR14.R                /* Threshold Register */
#define ADC_THRHLR15         ADC.THRHLR15.R                /* Threshold Register */
#define ADC_CWSELR0          ADC.CWSELR0.R                 /* Channel Watchdog Select Register 0 */
#define ADC_CWSELR1          ADC.CWSELR1.R                 /* Channel Watchdog Select Register 1 */
#define ADC_CWSELR2          ADC.CWSELR2.R                 /* Channel Watchdog Select Register 2 */
#define ADC_CWSELR3          ADC.CWSELR3.R                 /* Channel Watchdog Select Register 3 */
#define ADC_CWSELR4          ADC.CWSELR4.R                 /* Channel Watchdog Select Register 4 */
#define ADC_CWSELR5          ADC.CWSELR5.R                 /* Channel Watchdog Select Register 5 */
#define ADC_CWENR0           ADC.CWENR0.R                  /* Channel Watchdog Enable Register 0 */
#define ADC_CWENR1           ADC.CWENR1.R                  /* Channel Watchdog Enable Register 1 */
#define ADC_AWORR0           ADC.AWORR0.R                  /* Analog Watchdog Out of Range Register 0 */
#define ADC_AWORR1           ADC.AWORR1.R                  /* Analog Watchdog Out of Range Register 1 */
#define ADC_CALBISTREG       ADC.CALBISTREG.R              /* Calibration, BIST Control and status Register */
#define ADC_OFSGNUSR         ADC.OFSGNUSR.R                /* Offset and Gain User Register */

/* AIPS */
#define AIPS_0_MPRA          AIPS_0.MPRA.R                 /* Master Privilege Register A */
#define AIPS_0_MPRB          AIPS_0.MPRB.R                 /* Master Privilege Register B */
#define AIPS_0_PACRA         AIPS_0.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRB         AIPS_0.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRC         AIPS_0.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRD         AIPS_0.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_0_OPACRA        AIPS_0.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRB        AIPS_0.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRC        AIPS_0.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRD        AIPS_0.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRE        AIPS_0.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRF        AIPS_0.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRG        AIPS_0.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRH        AIPS_0.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRI        AIPS_0.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRJ        AIPS_0.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRK        AIPS_0.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRL        AIPS_0.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRM        AIPS_0.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRN        AIPS_0.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRO        AIPS_0.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRP        AIPS_0.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_PACRU         AIPS_0.PACRU.R                /* Peripheral Access Control Register */

#define AIPS_1_MPRA          AIPS_1.MPRA.R                 /* Master Privilege Register A */
#define AIPS_1_MPRB          AIPS_1.MPRB.R                 /* Master Privilege Register B */
#define AIPS_1_PACRA         AIPS_1.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRB         AIPS_1.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRC         AIPS_1.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRD         AIPS_1.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_1_OPACRA        AIPS_1.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRB        AIPS_1.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRC        AIPS_1.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRD        AIPS_1.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRE        AIPS_1.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRF        AIPS_1.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRG        AIPS_1.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRH        AIPS_1.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRI        AIPS_1.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRJ        AIPS_1.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRK        AIPS_1.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRL        AIPS_1.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRM        AIPS_1.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRN        AIPS_1.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRO        AIPS_1.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRP        AIPS_1.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_PACRU         AIPS_1.PACRU.R                /* Peripheral Access Control Register */

/* AXBS */
#define AXBS_PRS0            AXBS.PORT[0].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS0            AXBS.PORT[0].CRS.R            /* Control Register */
#define AXBS_PRS1            AXBS.PORT[1].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS1            AXBS.PORT[1].CRS.R            /* Control Register */
#define AXBS_PRS2            AXBS.PORT[2].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS2            AXBS.PORT[2].CRS.R            /* Control Register */
#define AXBS_PRS3            AXBS.PORT[3].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS3            AXBS.PORT[3].CRS.R            /* Control Register */
#define AXBS_PRS4            AXBS.PORT[4].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS4            AXBS.PORT[4].CRS.R            /* Control Register */
#define AXBS_PRS5            AXBS.PORT[5].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS5            AXBS.PORT[5].CRS.R            /* Control Register */
#define AXBS_PRS6            AXBS.PORT[6].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS6            AXBS.PORT[6].CRS.R            /* Control Register */
#define AXBS_PRS7            AXBS.PORT[7].PRS.R            /* Priority Registers Slave */
#define AXBS_CRS7            AXBS.PORT[7].CRS.R            /* Control Register */
#define AXBS_MGPCR0          AXBS.MGPCR[0].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR1          AXBS.MGPCR[1].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR2          AXBS.MGPCR[2].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR3          AXBS.MGPCR[3].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR4          AXBS.MGPCR[4].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR5          AXBS.MGPCR[5].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR6          AXBS.MGPCR[6].MGPCR.R         /* Master General Purpose Control Register */
#define AXBS_MGPCR7          AXBS.MGPCR[7].MGPCR.R         /* Master General Purpose Control Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */

#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CBT            CAN_1.CBT.R                   /* CAN Bit Timing Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CBT            CAN_2.CBT.R                   /* CAN Bit Timing Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */
/* CM4 */
#define CM4_0 (*(volatile struct CM4_tag *) 0xE0000000UL)

/* CMP */
#define CMP_0_C0             CMP_0.C0.R                    /* CMP Control Register 0 */
#define CMP_0_C1             CMP_0.C1.R                    /* CMP Control Register 1 */
#define CMP_0_C2             CMP_0.C2.R                    /* CMP Control Register 2 */

#define CMP_1_C0             CMP_1.C0.R                    /* CMP Control Register 0 */
#define CMP_1_C1             CMP_1.C1.R                    /* CMP Control Register 1 */
#define CMP_1_C2             CMP_1.C2.R                    /* CMP Control Register 2 */

/* CMU */
#define CMU_CSR              CMU.CSR.R                     /* CMU Control Status Register */
#define CMU_FDR              CMU.FDR.R                     /* CMU Frequency Display Register */
#define CMU_HFREFR           CMU.HFREFR.R                  /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_LFREFR           CMU.LFREFR.R                  /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ISR              CMU.ISR.R                     /* CMU Interrupt Status Register */
#define CMU_MDR              CMU.MDR.R                     /* CMU Measurement Duration Register */

/* CRC */
#define CRC_DATA             CRC.DATA.R                    /* CRC Data register */
#define CRC_GPOLY            CRC.GPOLY.R                   /* CRC Polynomial register */
#define CRC_CTRL             CRC.CTRL.R                    /* CRC Control register */

/* CSE */
#define CSE_CR               CSE.CR.R                      /* CSE Control Register */
#define CSE_SR               CSE.SR.R                      /* CSE Status Register */
#define CSE_IR               CSE.IR.R                      /* CSE Interrupt Register */
#define CSE_ECR              CSE.ECR.R                     /* CSE Error Code Register */
#define CSE_CMD              CSE.CMD.R                     /* CSE Command Register */
#define CSE_P1               CSE.P[0].R                    /* CSE Parameter Register */
#define CSE_P2               CSE.P[1].R                    /* CSE Parameter Register */
#define CSE_P3               CSE.P[2].R                    /* CSE Parameter Register */
#define CSE_P4               CSE.P[3].R                    /* CSE Parameter Register */
#define CSE_P5               CSE.P[4].R                    /* CSE Parameter Register */

/* DCU */
#define DCU_0_CTRLDESCCURSOR1 DCU_0.CTRLDESCCURSOR1.R      /* Control Descriptor Cursor 1 Register */
#define DCU_0_CTRLDESCCURSOR2 DCU_0.CTRLDESCCURSOR2.R      /* Control Descriptor Cursor 2 Register */
#define DCU_0_CTRLDESCCURSOR3 DCU_0.CTRLDESCCURSOR3.R      /* Control Descriptor Cursor 3 Register */
#define DCU_0_CTRLDESCCURSOR4 DCU_0.CTRLDESCCURSOR4.R      /* Control Descriptor Cursor 4 Register */
#define DCU_0_MODE           DCU_0.MODE.R                  /* Mode Register */
#define DCU_0_BGND           DCU_0.BGND.R                  /* Background Register */
#define DCU_0_DISP_SIZE      DCU_0.DISP_SIZE.R             /* Display Size Register */
#define DCU_0_HSYN_PARA      DCU_0.HSYN_PARA.R             /* Horizontal Sync Parameter Register */
#define DCU_0_VSYN_PARA      DCU_0.VSYN_PARA.R             /* Vertical Sync Parameter Register */
#define DCU_0_SYNPOL         DCU_0.SYNPOL.R                /* Synchronize Polarity Register */
#define DCU_0_THRESHOLD      DCU_0.THRESHOLD.R             /* Threshold Register */
#define DCU_0_INT_STATUS     DCU_0.INT_STATUS.R            /* Interrupt Status Register */
#define DCU_0_INT_MASK       DCU_0.INT_MASK.R              /* Interrupt Mask Register */
#define DCU_0_COLBAR_1       DCU_0.COLBAR_1.R              /* COLBAR_1 Register */
#define DCU_0_COLBAR_2       DCU_0.COLBAR_2.R              /* COLBAR_2 Register */
#define DCU_0_COLBAR_3       DCU_0.COLBAR_3.R              /* COLBAR_3 Register */
#define DCU_0_COLBAR_4       DCU_0.COLBAR_4.R              /* COLBAR_4 Register */
#define DCU_0_COLBAR_5       DCU_0.COLBAR_5.R              /* COLBAR_5 Register */
#define DCU_0_COLBAR_6       DCU_0.COLBAR_6.R              /* COLBAR_6 Register */
#define DCU_0_COLBAR_7       DCU_0.COLBAR_7.R              /* COLBAR_7 Register */
#define DCU_0_COLBAR_8       DCU_0.COLBAR_8.R              /* COLBAR_8 Register */
#define DCU_0_DIV_RATIO      DCU_0.DIV_RATIO.R             /* Divide Ratio Register */
#define DCU_0_SIGN_CALC_1    DCU_0.SIGN_CALC_1.R           /* Sign Calculation 1 Register */
#define DCU_0_SIGN_CALC_2    DCU_0.SIGN_CALC_2.R           /* Sign Calculation 2 Register */
#define DCU_0_CRC_VAL        DCU_0.CRC_VAL.R               /* CRC Value Register */
#define DCU_0_PARR_ERR_STATUS1 DCU_0.PARR_ERR_STATUS1.R    /* Parameter Error Status 1 Register */
#define DCU_0_PARR_ERR_STATUS3 DCU_0.PARR_ERR_STATUS3.R    /* Parameter Error Status 3 Register */
#define DCU_0_MASK_PARR_ERR_STATUS1 DCU_0.MASK_PARR_ERR_STATUS1.R /* Mask Parameter Error Status 1 Register */
#define DCU_0_MASK_PARR_ERR_STATUS3 DCU_0.MASK_PARR_ERR_STATUS3.R /* Mask Parameter Error Status 3 Register */
#define DCU_0_THRESHOLD_INP_BUF_1 DCU_0.THRESHOLD_INP_BUF_1.R /* Threshold Input 1 Register */
#define DCU_0_THRESHOLD_INP_BUF_2 DCU_0.THRESHOLD_INP_BUF_2.R /* Threshold Input 2 Register */
#define DCU_0_THRESHOLD_INP_BUF_3 DCU_0.THRESHOLD_INP_BUF_3.R /* Threshold Input 3 Register */
#define DCU_0_LUMA_COMP      DCU_0.LUMA_COMP.R             /* LUMA Component Register */
#define DCU_0_CHROMA_RED     DCU_0.CHROMA_RED.R            /* Red Chroma Components Register */
#define DCU_0_CHROMA_GREEN   DCU_0.CHROMA_GREEN.R          /* Green Chroma Components Register */
#define DCU_0_CHROMA_BLUE    DCU_0.CHROMA_BLUE.R           /* Blue Chroma Components Register */
#define DCU_0_CRC_POS        DCU_0.CRC_POS.R               /* CRC Position Register */
#define DCU_0_LYR_INTPOL_EN  DCU_0.LYR_INTPOL_EN.R         /* Layer Interpolation Enable Register */
#define DCU_0_LYR_LUMA_COMP  DCU_0.LYR_LUMA_COMP.R         /* Layer Luminance Component Register */
#define DCU_0_LYR_CHRM_RED   DCU_0.LYR_CHRM_RED.R          /* Layer Chroma Red Register */
#define DCU_0_LYR_CHRM_GRN   DCU_0.LYR_CHRM_GRN.R          /* Layer Chroma Green Register */
#define DCU_0_LYR_CHRM_BLUE  DCU_0.LYR_CHRM_BLUE.R         /* Layer Chroma Blue Register */
#define DCU_0_UPDATE_MODE    DCU_0.UPDATE_MODE.R           /* Update Mode Register */
#define DCU_0_UNDERRUN       DCU_0.UNDERRUN.R              /* Underrun Register */
#define DCU_0_WRITEBACK_ADDR DCU_0.WRITEBACK_ADDR.R        /* Write back address */
#define DCU_0_WRITEBACK_CTRL DCU_0.WRITEBACK_CTRL.R        /*  */
#define DCU_0_WRITEBACK_STAT DCU_0.WRITEBACK_STAT.R        /* Writeback status */
#define DCU_0_GPR            DCU_0.GPR.R                   /* Global Protection Register */
#define DCU_0_SLR_L0         DCU_0.SLR_L0.R                /* Soft Lock Bit Layer 0 Register */
#define DCU_0_SLR_L1         DCU_0.SLR_L1.R                /* Soft Lock Bit Layer 1 Register */
#define DCU_0_SLR_DISP_SIZE  DCU_0.SLR_DISP_SIZE.R         /* Soft Lock Display Size Register */
#define DCU_0_SLR_HVSYNC_PARA DCU_0.SLR_HVSYNC_PARA.R      /* Soft Lock Hsync/Vsync Parameter Register */
#define DCU_0_SLR_POL        DCU_0.SLR_POL.R               /* Soft Lock POL Register */
#define DCU_0_SLR_L0_TRANSP  DCU_0.SLR_L0_TRANSP.R         /* Soft Lock L0 Transparency Register */
#define DCU_0_SLR_L1_TRANSP  DCU_0.SLR_L1_TRANSP.R         /* Soft Lock L1 Transparency Register */
#define DCU_0_SLR_HUD        DCU_0.SLR_HUD.R               /* Soft Lock HUD Register */
#define DCU_0_CTRLDESCL0_1   DCU_0.R[0].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL0_2   DCU_0.R[0].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL0_3   DCU_0.R[0].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL0_4   DCU_0.R[0].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL0_5   DCU_0.R[0].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL0_6   DCU_0.R[0].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL0_7   DCU_0.R[0].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL0_8   DCU_0.R[0].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL0_9   DCU_0.R[0].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL0_10  DCU_0.R[0].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL0_11  DCU_0.R[0].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL1_1   DCU_0.R[1].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL1_2   DCU_0.R[1].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL1_3   DCU_0.R[1].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL1_4   DCU_0.R[1].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL1_5   DCU_0.R[1].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL1_6   DCU_0.R[1].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL1_7   DCU_0.R[1].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL1_8   DCU_0.R[1].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL1_9   DCU_0.R[1].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL1_10  DCU_0.R[1].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL1_11  DCU_0.R[1].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL2_1   DCU_0.R[2].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL2_2   DCU_0.R[2].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL2_3   DCU_0.R[2].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL2_4   DCU_0.R[2].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL2_5   DCU_0.R[2].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL2_6   DCU_0.R[2].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL2_7   DCU_0.R[2].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL2_8   DCU_0.R[2].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL2_9   DCU_0.R[2].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL2_10  DCU_0.R[2].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL2_11  DCU_0.R[2].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL3_1   DCU_0.R[3].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL3_2   DCU_0.R[3].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL3_3   DCU_0.R[3].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL3_4   DCU_0.R[3].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL3_5   DCU_0.R[3].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL3_6   DCU_0.R[3].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL3_7   DCU_0.R[3].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL3_8   DCU_0.R[3].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL3_9   DCU_0.R[3].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL3_10  DCU_0.R[3].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL3_11  DCU_0.R[3].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL4_1   DCU_0.R[4].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL4_2   DCU_0.R[4].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL4_3   DCU_0.R[4].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL4_4   DCU_0.R[4].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL4_5   DCU_0.R[4].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL4_6   DCU_0.R[4].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL4_7   DCU_0.R[4].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL4_8   DCU_0.R[4].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL4_9   DCU_0.R[4].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL4_10  DCU_0.R[4].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL4_11  DCU_0.R[4].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL5_1   DCU_0.R[5].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL5_2   DCU_0.R[5].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL5_3   DCU_0.R[5].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL5_4   DCU_0.R[5].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL5_5   DCU_0.R[5].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL5_6   DCU_0.R[5].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL5_7   DCU_0.R[5].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL5_8   DCU_0.R[5].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL5_9   DCU_0.R[5].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL5_10  DCU_0.R[5].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL5_11  DCU_0.R[5].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL6_1   DCU_0.R[6].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL6_2   DCU_0.R[6].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL6_3   DCU_0.R[6].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL6_4   DCU_0.R[6].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL6_5   DCU_0.R[6].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL6_6   DCU_0.R[6].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL6_7   DCU_0.R[6].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL6_8   DCU_0.R[6].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL6_9   DCU_0.R[6].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL6_10  DCU_0.R[6].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL6_11  DCU_0.R[6].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL7_1   DCU_0.R[7].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL7_2   DCU_0.R[7].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL7_3   DCU_0.R[7].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL7_4   DCU_0.R[7].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL7_5   DCU_0.R[7].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL7_6   DCU_0.R[7].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL7_7   DCU_0.R[7].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL7_8   DCU_0.R[7].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL7_9   DCU_0.R[7].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL7_10  DCU_0.R[7].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL7_11  DCU_0.R[7].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL8_1   DCU_0.R[8].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL8_2   DCU_0.R[8].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL8_3   DCU_0.R[8].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL8_4   DCU_0.R[8].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL8_5   DCU_0.R[8].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL8_6   DCU_0.R[8].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL8_7   DCU_0.R[8].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL8_8   DCU_0.R[8].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL8_9   DCU_0.R[8].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL8_10  DCU_0.R[8].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL8_11  DCU_0.R[8].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL9_1   DCU_0.R[9].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL9_2   DCU_0.R[9].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL9_3   DCU_0.R[9].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL9_4   DCU_0.R[9].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL9_5   DCU_0.R[9].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL9_6   DCU_0.R[9].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL9_7   DCU_0.R[9].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL9_8   DCU_0.R[9].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL9_9   DCU_0.R[9].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL9_10  DCU_0.R[9].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL9_11  DCU_0.R[9].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL10_1  DCU_0.R[10].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL10_2  DCU_0.R[10].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL10_3  DCU_0.R[10].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL10_4  DCU_0.R[10].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL10_5  DCU_0.R[10].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL10_6  DCU_0.R[10].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL10_7  DCU_0.R[10].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL10_8  DCU_0.R[10].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL10_9  DCU_0.R[10].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL10_10 DCU_0.R[10].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL10_11 DCU_0.R[10].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL11_1  DCU_0.R[11].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL11_2  DCU_0.R[11].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL11_3  DCU_0.R[11].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL11_4  DCU_0.R[11].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL11_5  DCU_0.R[11].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL11_6  DCU_0.R[11].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL11_7  DCU_0.R[11].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL11_8  DCU_0.R[11].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL11_9  DCU_0.R[11].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL11_10 DCU_0.R[11].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL11_11 DCU_0.R[11].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL12_1  DCU_0.R[12].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL12_2  DCU_0.R[12].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL12_3  DCU_0.R[12].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL12_4  DCU_0.R[12].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL12_5  DCU_0.R[12].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL12_6  DCU_0.R[12].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL12_7  DCU_0.R[12].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL12_8  DCU_0.R[12].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL12_9  DCU_0.R[12].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL12_10 DCU_0.R[12].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL12_11 DCU_0.R[12].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL13_1  DCU_0.R[13].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL13_2  DCU_0.R[13].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL13_3  DCU_0.R[13].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL13_4  DCU_0.R[13].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL13_5  DCU_0.R[13].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL13_6  DCU_0.R[13].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL13_7  DCU_0.R[13].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL13_8  DCU_0.R[13].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL13_9  DCU_0.R[13].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL13_10 DCU_0.R[13].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL13_11 DCU_0.R[13].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL14_1  DCU_0.R[14].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL14_2  DCU_0.R[14].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL14_3  DCU_0.R[14].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL14_4  DCU_0.R[14].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL14_5  DCU_0.R[14].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL14_6  DCU_0.R[14].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL14_7  DCU_0.R[14].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL14_8  DCU_0.R[14].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL14_9  DCU_0.R[14].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL14_10 DCU_0.R[14].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL14_11 DCU_0.R[14].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL15_1  DCU_0.R[15].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL15_2  DCU_0.R[15].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL15_3  DCU_0.R[15].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL15_4  DCU_0.R[15].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL15_5  DCU_0.R[15].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL15_6  DCU_0.R[15].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL15_7  DCU_0.R[15].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL15_8  DCU_0.R[15].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL15_9  DCU_0.R[15].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL15_10 DCU_0.R[15].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL15_11 DCU_0.R[15].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL16_1  DCU_0.R[16].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL16_2  DCU_0.R[16].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL16_3  DCU_0.R[16].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL16_4  DCU_0.R[16].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL16_5  DCU_0.R[16].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL16_6  DCU_0.R[16].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL16_7  DCU_0.R[16].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL16_8  DCU_0.R[16].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL16_9  DCU_0.R[16].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL16_10 DCU_0.R[16].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL16_11 DCU_0.R[16].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL17_1  DCU_0.R[17].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL17_2  DCU_0.R[17].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL17_3  DCU_0.R[17].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL17_4  DCU_0.R[17].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL17_5  DCU_0.R[17].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL17_6  DCU_0.R[17].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL17_7  DCU_0.R[17].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL17_8  DCU_0.R[17].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL17_9  DCU_0.R[17].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL17_10 DCU_0.R[17].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL17_11 DCU_0.R[17].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL18_1  DCU_0.R[18].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL18_2  DCU_0.R[18].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL18_3  DCU_0.R[18].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL18_4  DCU_0.R[18].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL18_5  DCU_0.R[18].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL18_6  DCU_0.R[18].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL18_7  DCU_0.R[18].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL18_8  DCU_0.R[18].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL18_9  DCU_0.R[18].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL18_10 DCU_0.R[18].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL18_11 DCU_0.R[18].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL19_1  DCU_0.R[19].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL19_2  DCU_0.R[19].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL19_3  DCU_0.R[19].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL19_4  DCU_0.R[19].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL19_5  DCU_0.R[19].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL19_6  DCU_0.R[19].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL19_7  DCU_0.R[19].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL19_8  DCU_0.R[19].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL19_9  DCU_0.R[19].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL19_10 DCU_0.R[19].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL19_11 DCU_0.R[19].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL20_1  DCU_0.R[20].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL20_2  DCU_0.R[20].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL20_3  DCU_0.R[20].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL20_4  DCU_0.R[20].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL20_5  DCU_0.R[20].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL20_6  DCU_0.R[20].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL20_7  DCU_0.R[20].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL20_8  DCU_0.R[20].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL20_9  DCU_0.R[20].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL20_10 DCU_0.R[20].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL20_11 DCU_0.R[20].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL21_1  DCU_0.R[21].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL21_2  DCU_0.R[21].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL21_3  DCU_0.R[21].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL21_4  DCU_0.R[21].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL21_5  DCU_0.R[21].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL21_6  DCU_0.R[21].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL21_7  DCU_0.R[21].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL21_8  DCU_0.R[21].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL21_9  DCU_0.R[21].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL21_10 DCU_0.R[21].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL21_11 DCU_0.R[21].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL22_1  DCU_0.R[22].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL22_2  DCU_0.R[22].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL22_3  DCU_0.R[22].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL22_4  DCU_0.R[22].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL22_5  DCU_0.R[22].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL22_6  DCU_0.R[22].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL22_7  DCU_0.R[22].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL22_8  DCU_0.R[22].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL22_9  DCU_0.R[22].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL22_10 DCU_0.R[22].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL22_11 DCU_0.R[22].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL23_1  DCU_0.R[23].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL23_2  DCU_0.R[23].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL23_3  DCU_0.R[23].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL23_4  DCU_0.R[23].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL23_5  DCU_0.R[23].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL23_6  DCU_0.R[23].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL23_7  DCU_0.R[23].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL23_8  DCU_0.R[23].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL23_9  DCU_0.R[23].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL23_10 DCU_0.R[23].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL23_11 DCU_0.R[23].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL24_1  DCU_0.R[24].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL24_2  DCU_0.R[24].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL24_3  DCU_0.R[24].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL24_4  DCU_0.R[24].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL24_5  DCU_0.R[24].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL24_6  DCU_0.R[24].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL24_7  DCU_0.R[24].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL24_8  DCU_0.R[24].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL24_9  DCU_0.R[24].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL24_10 DCU_0.R[24].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL24_11 DCU_0.R[24].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL25_1  DCU_0.R[25].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL25_2  DCU_0.R[25].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL25_3  DCU_0.R[25].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL25_4  DCU_0.R[25].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL25_5  DCU_0.R[25].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL25_6  DCU_0.R[25].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL25_7  DCU_0.R[25].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL25_8  DCU_0.R[25].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL25_9  DCU_0.R[25].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL25_10 DCU_0.R[25].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL25_11 DCU_0.R[25].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL26_1  DCU_0.R[26].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL26_2  DCU_0.R[26].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL26_3  DCU_0.R[26].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL26_4  DCU_0.R[26].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL26_5  DCU_0.R[26].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL26_6  DCU_0.R[26].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL26_7  DCU_0.R[26].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL26_8  DCU_0.R[26].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL26_9  DCU_0.R[26].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL26_10 DCU_0.R[26].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL26_11 DCU_0.R[26].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL27_1  DCU_0.R[27].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL27_2  DCU_0.R[27].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL27_3  DCU_0.R[27].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL27_4  DCU_0.R[27].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL27_5  DCU_0.R[27].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL27_6  DCU_0.R[27].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL27_7  DCU_0.R[27].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL27_8  DCU_0.R[27].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL27_9  DCU_0.R[27].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL27_10 DCU_0.R[27].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL27_11 DCU_0.R[27].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL28_1  DCU_0.R[28].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL28_2  DCU_0.R[28].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL28_3  DCU_0.R[28].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL28_4  DCU_0.R[28].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL28_5  DCU_0.R[28].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL28_6  DCU_0.R[28].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL28_7  DCU_0.R[28].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL28_8  DCU_0.R[28].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL28_9  DCU_0.R[28].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL28_10 DCU_0.R[28].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL28_11 DCU_0.R[28].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL29_1  DCU_0.R[29].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL29_2  DCU_0.R[29].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL29_3  DCU_0.R[29].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL29_4  DCU_0.R[29].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL29_5  DCU_0.R[29].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL29_6  DCU_0.R[29].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL29_7  DCU_0.R[29].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL29_8  DCU_0.R[29].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL29_9  DCU_0.R[29].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL29_10 DCU_0.R[29].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL29_11 DCU_0.R[29].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL30_1  DCU_0.R[30].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL30_2  DCU_0.R[30].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL30_3  DCU_0.R[30].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL30_4  DCU_0.R[30].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL30_5  DCU_0.R[30].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL30_6  DCU_0.R[30].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL30_7  DCU_0.R[30].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL30_8  DCU_0.R[30].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL30_9  DCU_0.R[30].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL30_10 DCU_0.R[30].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL30_11 DCU_0.R[30].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_CTRLDESCL31_1  DCU_0.R[31].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_0_CTRLDESCL31_2  DCU_0.R[31].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_0_CTRLDESCL31_3  DCU_0.R[31].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_0_CTRLDESCL31_4  DCU_0.R[31].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_0_CTRLDESCL31_5  DCU_0.R[31].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_0_CTRLDESCL31_6  DCU_0.R[31].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_0_CTRLDESCL31_7  DCU_0.R[31].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_0_CTRLDESCL31_8  DCU_0.R[31].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_0_CTRLDESCL31_9  DCU_0.R[31].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_0_CTRLDESCL31_10 DCU_0.R[31].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_0_CTRLDESCL31_11 DCU_0.R[31].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_0_HUD_WIDTH      DCU_0.HUD_WIDTH.R             /* Hud width */
#define DCU_0_HUD_HEIGHT     DCU_0.HUD_HEIGHT.R            /* Hud height */
#define DCU_0_WARP_DESC_ADDR DCU_0.WARP_DESC_ADDR.R        /* Warping Descriptor base address */
#define DCU_0_WARP_IRQ_CTRL  DCU_0.WARP_IRQ_CTRL.R         /* Warping interrupt configuration */
#define DCU_0_WARP_IRQ_STAT  DCU_0.WARP_IRQ_STAT.R         /* Warp interrupt status */
#define DCU_0_WARP_CTRL      DCU_0.WARP_CTRL.R             /* Warping control */
#define DCU_0_WARP_XOVR_STAT DCU_0.WARP_XOVR_STAT.R        /* Warping X overflow status */
#define DCU_0_WARP_YOVR_STAT DCU_0.WARP_YOVR_STAT.R        /* Warping Y overflow status */
#define DCU_0_WARP_DESC_TB_SZ DCU_0.WARP_DESC_TB_SZ.R      /* Warping line descriptor table size */

#define DCU_1_CTRLDESCCURSOR1 DCU_1.CTRLDESCCURSOR1.R      /* Control Descriptor Cursor 1 Register */
#define DCU_1_CTRLDESCCURSOR2 DCU_1.CTRLDESCCURSOR2.R      /* Control Descriptor Cursor 2 Register */
#define DCU_1_CTRLDESCCURSOR3 DCU_1.CTRLDESCCURSOR3.R      /* Control Descriptor Cursor 3 Register */
#define DCU_1_CTRLDESCCURSOR4 DCU_1.CTRLDESCCURSOR4.R      /* Control Descriptor Cursor 4 Register */
#define DCU_1_MODE           DCU_1.MODE.R                  /* Mode Register */
#define DCU_1_BGND           DCU_1.BGND.R                  /* Background Register */
#define DCU_1_DISP_SIZE      DCU_1.DISP_SIZE.R             /* Display Size Register */
#define DCU_1_HSYN_PARA      DCU_1.HSYN_PARA.R             /* Horizontal Sync Parameter Register */
#define DCU_1_VSYN_PARA      DCU_1.VSYN_PARA.R             /* Vertical Sync Parameter Register */
#define DCU_1_SYNPOL         DCU_1.SYNPOL.R                /* Synchronize Polarity Register */
#define DCU_1_THRESHOLD      DCU_1.THRESHOLD.R             /* Threshold Register */
#define DCU_1_INT_STATUS     DCU_1.INT_STATUS.R            /* Interrupt Status Register */
#define DCU_1_INT_MASK       DCU_1.INT_MASK.R              /* Interrupt Mask Register */
#define DCU_1_COLBAR_1       DCU_1.COLBAR_1.R              /* COLBAR_1 Register */
#define DCU_1_COLBAR_2       DCU_1.COLBAR_2.R              /* COLBAR_2 Register */
#define DCU_1_COLBAR_3       DCU_1.COLBAR_3.R              /* COLBAR_3 Register */
#define DCU_1_COLBAR_4       DCU_1.COLBAR_4.R              /* COLBAR_4 Register */
#define DCU_1_COLBAR_5       DCU_1.COLBAR_5.R              /* COLBAR_5 Register */
#define DCU_1_COLBAR_6       DCU_1.COLBAR_6.R              /* COLBAR_6 Register */
#define DCU_1_COLBAR_7       DCU_1.COLBAR_7.R              /* COLBAR_7 Register */
#define DCU_1_COLBAR_8       DCU_1.COLBAR_8.R              /* COLBAR_8 Register */
#define DCU_1_DIV_RATIO      DCU_1.DIV_RATIO.R             /* Divide Ratio Register */
#define DCU_1_SIGN_CALC_1    DCU_1.SIGN_CALC_1.R           /* Sign Calculation 1 Register */
#define DCU_1_SIGN_CALC_2    DCU_1.SIGN_CALC_2.R           /* Sign Calculation 2 Register */
#define DCU_1_CRC_VAL        DCU_1.CRC_VAL.R               /* CRC Value Register */
#define DCU_1_PARR_ERR_STATUS1 DCU_1.PARR_ERR_STATUS1.R    /* Parameter Error Status 1 Register */
#define DCU_1_PARR_ERR_STATUS3 DCU_1.PARR_ERR_STATUS3.R    /* Parameter Error Status 3 Register */
#define DCU_1_MASK_PARR_ERR_STATUS1 DCU_1.MASK_PARR_ERR_STATUS1.R /* Mask Parameter Error Status 1 Register */
#define DCU_1_MASK_PARR_ERR_STATUS3 DCU_1.MASK_PARR_ERR_STATUS3.R /* Mask Parameter Error Status 3 Register */
#define DCU_1_THRESHOLD_INP_BUF_1 DCU_1.THRESHOLD_INP_BUF_1.R /* Threshold Input 1 Register */
#define DCU_1_THRESHOLD_INP_BUF_2 DCU_1.THRESHOLD_INP_BUF_2.R /* Threshold Input 2 Register */
#define DCU_1_THRESHOLD_INP_BUF_3 DCU_1.THRESHOLD_INP_BUF_3.R /* Threshold Input 3 Register */
#define DCU_1_LUMA_COMP      DCU_1.LUMA_COMP.R             /* LUMA Component Register */
#define DCU_1_CHROMA_RED     DCU_1.CHROMA_RED.R            /* Red Chroma Components Register */
#define DCU_1_CHROMA_GREEN   DCU_1.CHROMA_GREEN.R          /* Green Chroma Components Register */
#define DCU_1_CHROMA_BLUE    DCU_1.CHROMA_BLUE.R           /* Blue Chroma Components Register */
#define DCU_1_CRC_POS        DCU_1.CRC_POS.R               /* CRC Position Register */
#define DCU_1_LYR_INTPOL_EN  DCU_1.LYR_INTPOL_EN.R         /* Layer Interpolation Enable Register */
#define DCU_1_LYR_LUMA_COMP  DCU_1.LYR_LUMA_COMP.R         /* Layer Luminance Component Register */
#define DCU_1_LYR_CHRM_RED   DCU_1.LYR_CHRM_RED.R          /* Layer Chroma Red Register */
#define DCU_1_LYR_CHRM_GRN   DCU_1.LYR_CHRM_GRN.R          /* Layer Chroma Green Register */
#define DCU_1_LYR_CHRM_BLUE  DCU_1.LYR_CHRM_BLUE.R         /* Layer Chroma Blue Register */
#define DCU_1_UPDATE_MODE    DCU_1.UPDATE_MODE.R           /* Update Mode Register */
#define DCU_1_UNDERRUN       DCU_1.UNDERRUN.R              /* Underrun Register */
#define DCU_1_WRITEBACK_ADDR DCU_1.WRITEBACK_ADDR.R        /* Write back address */
#define DCU_1_WRITEBACK_CTRL DCU_1.WRITEBACK_CTRL.R        /*  */
#define DCU_1_WRITEBACK_STAT DCU_1.WRITEBACK_STAT.R        /* Writeback status */
#define DCU_1_GPR            DCU_1.GPR.R                   /* Global Protection Register */
#define DCU_1_SLR_L0         DCU_1.SLR_L0.R                /* Soft Lock Bit Layer 0 Register */
#define DCU_1_SLR_L1         DCU_1.SLR_L1.R                /* Soft Lock Bit Layer 1 Register */
#define DCU_1_SLR_DISP_SIZE  DCU_1.SLR_DISP_SIZE.R         /* Soft Lock Display Size Register */
#define DCU_1_SLR_HVSYNC_PARA DCU_1.SLR_HVSYNC_PARA.R      /* Soft Lock Hsync/Vsync Parameter Register */
#define DCU_1_SLR_POL        DCU_1.SLR_POL.R               /* Soft Lock POL Register */
#define DCU_1_SLR_L0_TRANSP  DCU_1.SLR_L0_TRANSP.R         /* Soft Lock L0 Transparency Register */
#define DCU_1_SLR_L1_TRANSP  DCU_1.SLR_L1_TRANSP.R         /* Soft Lock L1 Transparency Register */
#define DCU_1_SLR_HUD        DCU_1.SLR_HUD.R               /* Soft Lock HUD Register */
#define DCU_1_CTRLDESCL0_1   DCU_1.R[0].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL0_2   DCU_1.R[0].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL0_3   DCU_1.R[0].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL0_4   DCU_1.R[0].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL0_5   DCU_1.R[0].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL0_6   DCU_1.R[0].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL0_7   DCU_1.R[0].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL0_8   DCU_1.R[0].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL0_9   DCU_1.R[0].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL0_10  DCU_1.R[0].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL0_11  DCU_1.R[0].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL1_1   DCU_1.R[1].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL1_2   DCU_1.R[1].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL1_3   DCU_1.R[1].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL1_4   DCU_1.R[1].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL1_5   DCU_1.R[1].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL1_6   DCU_1.R[1].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL1_7   DCU_1.R[1].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL1_8   DCU_1.R[1].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL1_9   DCU_1.R[1].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL1_10  DCU_1.R[1].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL1_11  DCU_1.R[1].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL2_1   DCU_1.R[2].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL2_2   DCU_1.R[2].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL2_3   DCU_1.R[2].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL2_4   DCU_1.R[2].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL2_5   DCU_1.R[2].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL2_6   DCU_1.R[2].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL2_7   DCU_1.R[2].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL2_8   DCU_1.R[2].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL2_9   DCU_1.R[2].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL2_10  DCU_1.R[2].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL2_11  DCU_1.R[2].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL3_1   DCU_1.R[3].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL3_2   DCU_1.R[3].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL3_3   DCU_1.R[3].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL3_4   DCU_1.R[3].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL3_5   DCU_1.R[3].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL3_6   DCU_1.R[3].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL3_7   DCU_1.R[3].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL3_8   DCU_1.R[3].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL3_9   DCU_1.R[3].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL3_10  DCU_1.R[3].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL3_11  DCU_1.R[3].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL4_1   DCU_1.R[4].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL4_2   DCU_1.R[4].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL4_3   DCU_1.R[4].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL4_4   DCU_1.R[4].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL4_5   DCU_1.R[4].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL4_6   DCU_1.R[4].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL4_7   DCU_1.R[4].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL4_8   DCU_1.R[4].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL4_9   DCU_1.R[4].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL4_10  DCU_1.R[4].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL4_11  DCU_1.R[4].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL5_1   DCU_1.R[5].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL5_2   DCU_1.R[5].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL5_3   DCU_1.R[5].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL5_4   DCU_1.R[5].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL5_5   DCU_1.R[5].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL5_6   DCU_1.R[5].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL5_7   DCU_1.R[5].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL5_8   DCU_1.R[5].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL5_9   DCU_1.R[5].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL5_10  DCU_1.R[5].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL5_11  DCU_1.R[5].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL6_1   DCU_1.R[6].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL6_2   DCU_1.R[6].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL6_3   DCU_1.R[6].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL6_4   DCU_1.R[6].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL6_5   DCU_1.R[6].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL6_6   DCU_1.R[6].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL6_7   DCU_1.R[6].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL6_8   DCU_1.R[6].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL6_9   DCU_1.R[6].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL6_10  DCU_1.R[6].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL6_11  DCU_1.R[6].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL7_1   DCU_1.R[7].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL7_2   DCU_1.R[7].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL7_3   DCU_1.R[7].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL7_4   DCU_1.R[7].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL7_5   DCU_1.R[7].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL7_6   DCU_1.R[7].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL7_7   DCU_1.R[7].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL7_8   DCU_1.R[7].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL7_9   DCU_1.R[7].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL7_10  DCU_1.R[7].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL7_11  DCU_1.R[7].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL8_1   DCU_1.R[8].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL8_2   DCU_1.R[8].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL8_3   DCU_1.R[8].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL8_4   DCU_1.R[8].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL8_5   DCU_1.R[8].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL8_6   DCU_1.R[8].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL8_7   DCU_1.R[8].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL8_8   DCU_1.R[8].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL8_9   DCU_1.R[8].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL8_10  DCU_1.R[8].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL8_11  DCU_1.R[8].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL9_1   DCU_1.R[9].CTRLDESCL_1.R      /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL9_2   DCU_1.R[9].CTRLDESCL_2.R      /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL9_3   DCU_1.R[9].CTRLDESCL_3.R      /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL9_4   DCU_1.R[9].CTRLDESCL_4.R      /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL9_5   DCU_1.R[9].CTRLDESCL_5.R      /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL9_6   DCU_1.R[9].CTRLDESCL_6.R      /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL9_7   DCU_1.R[9].CTRLDESCL_7.R      /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL9_8   DCU_1.R[9].CTRLDESCL_8.R      /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL9_9   DCU_1.R[9].CTRLDESCL_9.R      /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL9_10  DCU_1.R[9].CTRLDESCL_10.R     /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL9_11  DCU_1.R[9].CTRLDESCL_11.R     /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL10_1  DCU_1.R[10].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL10_2  DCU_1.R[10].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL10_3  DCU_1.R[10].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL10_4  DCU_1.R[10].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL10_5  DCU_1.R[10].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL10_6  DCU_1.R[10].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL10_7  DCU_1.R[10].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL10_8  DCU_1.R[10].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL10_9  DCU_1.R[10].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL10_10 DCU_1.R[10].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL10_11 DCU_1.R[10].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL11_1  DCU_1.R[11].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL11_2  DCU_1.R[11].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL11_3  DCU_1.R[11].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL11_4  DCU_1.R[11].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL11_5  DCU_1.R[11].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL11_6  DCU_1.R[11].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL11_7  DCU_1.R[11].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL11_8  DCU_1.R[11].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL11_9  DCU_1.R[11].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL11_10 DCU_1.R[11].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL11_11 DCU_1.R[11].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL12_1  DCU_1.R[12].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL12_2  DCU_1.R[12].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL12_3  DCU_1.R[12].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL12_4  DCU_1.R[12].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL12_5  DCU_1.R[12].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL12_6  DCU_1.R[12].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL12_7  DCU_1.R[12].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL12_8  DCU_1.R[12].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL12_9  DCU_1.R[12].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL12_10 DCU_1.R[12].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL12_11 DCU_1.R[12].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL13_1  DCU_1.R[13].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL13_2  DCU_1.R[13].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL13_3  DCU_1.R[13].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL13_4  DCU_1.R[13].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL13_5  DCU_1.R[13].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL13_6  DCU_1.R[13].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL13_7  DCU_1.R[13].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL13_8  DCU_1.R[13].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL13_9  DCU_1.R[13].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL13_10 DCU_1.R[13].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL13_11 DCU_1.R[13].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL14_1  DCU_1.R[14].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL14_2  DCU_1.R[14].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL14_3  DCU_1.R[14].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL14_4  DCU_1.R[14].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL14_5  DCU_1.R[14].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL14_6  DCU_1.R[14].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL14_7  DCU_1.R[14].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL14_8  DCU_1.R[14].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL14_9  DCU_1.R[14].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL14_10 DCU_1.R[14].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL14_11 DCU_1.R[14].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL15_1  DCU_1.R[15].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL15_2  DCU_1.R[15].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL15_3  DCU_1.R[15].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL15_4  DCU_1.R[15].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL15_5  DCU_1.R[15].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL15_6  DCU_1.R[15].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL15_7  DCU_1.R[15].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL15_8  DCU_1.R[15].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL15_9  DCU_1.R[15].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL15_10 DCU_1.R[15].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL15_11 DCU_1.R[15].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL16_1  DCU_1.R[16].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL16_2  DCU_1.R[16].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL16_3  DCU_1.R[16].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL16_4  DCU_1.R[16].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL16_5  DCU_1.R[16].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL16_6  DCU_1.R[16].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL16_7  DCU_1.R[16].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL16_8  DCU_1.R[16].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL16_9  DCU_1.R[16].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL16_10 DCU_1.R[16].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL16_11 DCU_1.R[16].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL17_1  DCU_1.R[17].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL17_2  DCU_1.R[17].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL17_3  DCU_1.R[17].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL17_4  DCU_1.R[17].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL17_5  DCU_1.R[17].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL17_6  DCU_1.R[17].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL17_7  DCU_1.R[17].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL17_8  DCU_1.R[17].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL17_9  DCU_1.R[17].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL17_10 DCU_1.R[17].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL17_11 DCU_1.R[17].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL18_1  DCU_1.R[18].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL18_2  DCU_1.R[18].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL18_3  DCU_1.R[18].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL18_4  DCU_1.R[18].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL18_5  DCU_1.R[18].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL18_6  DCU_1.R[18].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL18_7  DCU_1.R[18].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL18_8  DCU_1.R[18].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL18_9  DCU_1.R[18].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL18_10 DCU_1.R[18].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL18_11 DCU_1.R[18].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL19_1  DCU_1.R[19].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL19_2  DCU_1.R[19].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL19_3  DCU_1.R[19].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL19_4  DCU_1.R[19].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL19_5  DCU_1.R[19].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL19_6  DCU_1.R[19].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL19_7  DCU_1.R[19].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL19_8  DCU_1.R[19].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL19_9  DCU_1.R[19].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL19_10 DCU_1.R[19].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL19_11 DCU_1.R[19].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL20_1  DCU_1.R[20].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL20_2  DCU_1.R[20].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL20_3  DCU_1.R[20].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL20_4  DCU_1.R[20].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL20_5  DCU_1.R[20].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL20_6  DCU_1.R[20].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL20_7  DCU_1.R[20].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL20_8  DCU_1.R[20].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL20_9  DCU_1.R[20].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL20_10 DCU_1.R[20].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL20_11 DCU_1.R[20].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL21_1  DCU_1.R[21].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL21_2  DCU_1.R[21].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL21_3  DCU_1.R[21].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL21_4  DCU_1.R[21].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL21_5  DCU_1.R[21].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL21_6  DCU_1.R[21].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL21_7  DCU_1.R[21].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL21_8  DCU_1.R[21].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL21_9  DCU_1.R[21].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL21_10 DCU_1.R[21].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL21_11 DCU_1.R[21].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL22_1  DCU_1.R[22].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL22_2  DCU_1.R[22].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL22_3  DCU_1.R[22].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL22_4  DCU_1.R[22].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL22_5  DCU_1.R[22].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL22_6  DCU_1.R[22].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL22_7  DCU_1.R[22].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL22_8  DCU_1.R[22].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL22_9  DCU_1.R[22].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL22_10 DCU_1.R[22].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL22_11 DCU_1.R[22].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL23_1  DCU_1.R[23].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL23_2  DCU_1.R[23].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL23_3  DCU_1.R[23].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL23_4  DCU_1.R[23].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL23_5  DCU_1.R[23].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL23_6  DCU_1.R[23].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL23_7  DCU_1.R[23].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL23_8  DCU_1.R[23].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL23_9  DCU_1.R[23].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL23_10 DCU_1.R[23].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL23_11 DCU_1.R[23].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL24_1  DCU_1.R[24].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL24_2  DCU_1.R[24].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL24_3  DCU_1.R[24].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL24_4  DCU_1.R[24].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL24_5  DCU_1.R[24].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL24_6  DCU_1.R[24].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL24_7  DCU_1.R[24].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL24_8  DCU_1.R[24].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL24_9  DCU_1.R[24].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL24_10 DCU_1.R[24].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL24_11 DCU_1.R[24].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL25_1  DCU_1.R[25].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL25_2  DCU_1.R[25].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL25_3  DCU_1.R[25].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL25_4  DCU_1.R[25].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL25_5  DCU_1.R[25].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL25_6  DCU_1.R[25].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL25_7  DCU_1.R[25].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL25_8  DCU_1.R[25].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL25_9  DCU_1.R[25].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL25_10 DCU_1.R[25].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL25_11 DCU_1.R[25].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL26_1  DCU_1.R[26].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL26_2  DCU_1.R[26].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL26_3  DCU_1.R[26].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL26_4  DCU_1.R[26].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL26_5  DCU_1.R[26].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL26_6  DCU_1.R[26].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL26_7  DCU_1.R[26].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL26_8  DCU_1.R[26].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL26_9  DCU_1.R[26].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL26_10 DCU_1.R[26].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL26_11 DCU_1.R[26].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL27_1  DCU_1.R[27].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL27_2  DCU_1.R[27].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL27_3  DCU_1.R[27].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL27_4  DCU_1.R[27].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL27_5  DCU_1.R[27].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL27_6  DCU_1.R[27].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL27_7  DCU_1.R[27].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL27_8  DCU_1.R[27].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL27_9  DCU_1.R[27].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL27_10 DCU_1.R[27].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL27_11 DCU_1.R[27].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL28_1  DCU_1.R[28].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL28_2  DCU_1.R[28].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL28_3  DCU_1.R[28].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL28_4  DCU_1.R[28].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL28_5  DCU_1.R[28].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL28_6  DCU_1.R[28].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL28_7  DCU_1.R[28].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL28_8  DCU_1.R[28].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL28_9  DCU_1.R[28].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL28_10 DCU_1.R[28].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL28_11 DCU_1.R[28].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL29_1  DCU_1.R[29].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL29_2  DCU_1.R[29].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL29_3  DCU_1.R[29].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL29_4  DCU_1.R[29].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL29_5  DCU_1.R[29].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL29_6  DCU_1.R[29].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL29_7  DCU_1.R[29].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL29_8  DCU_1.R[29].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL29_9  DCU_1.R[29].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL29_10 DCU_1.R[29].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL29_11 DCU_1.R[29].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL30_1  DCU_1.R[30].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL30_2  DCU_1.R[30].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL30_3  DCU_1.R[30].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL30_4  DCU_1.R[30].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL30_5  DCU_1.R[30].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL30_6  DCU_1.R[30].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL30_7  DCU_1.R[30].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL30_8  DCU_1.R[30].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL30_9  DCU_1.R[30].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL30_10 DCU_1.R[30].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL30_11 DCU_1.R[30].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_CTRLDESCL31_1  DCU_1.R[31].CTRLDESCL_1.R     /* Control Descriptor Layer 1 Register */
#define DCU_1_CTRLDESCL31_2  DCU_1.R[31].CTRLDESCL_2.R     /* Control Descriptor Layer 2 Register */
#define DCU_1_CTRLDESCL31_3  DCU_1.R[31].CTRLDESCL_3.R     /* Control Descriptor Layer 3 Register */
#define DCU_1_CTRLDESCL31_4  DCU_1.R[31].CTRLDESCL_4.R     /* Control Descriptor Layer 4 Register */
#define DCU_1_CTRLDESCL31_5  DCU_1.R[31].CTRLDESCL_5.R     /* Control Descriptor Layer 5 Register */
#define DCU_1_CTRLDESCL31_6  DCU_1.R[31].CTRLDESCL_6.R     /* Control Descriptor Layer 6 Register */
#define DCU_1_CTRLDESCL31_7  DCU_1.R[31].CTRLDESCL_7.R     /* Control Descriptor Layer 7 Register */
#define DCU_1_CTRLDESCL31_8  DCU_1.R[31].CTRLDESCL_8.R     /* Control Descriptor Layer 8 Register */
#define DCU_1_CTRLDESCL31_9  DCU_1.R[31].CTRLDESCL_9.R     /* Control Descriptor Layer 9 Register */
#define DCU_1_CTRLDESCL31_10 DCU_1.R[31].CTRLDESCL_10.R    /* Control Descriptor Layer 10 Register */
#define DCU_1_CTRLDESCL31_11 DCU_1.R[31].CTRLDESCL_11.R    /* Control Descriptor Layer 11 Register */
#define DCU_1_HUD_WIDTH      DCU_1.HUD_WIDTH.R             /* Hud width */
#define DCU_1_HUD_HEIGHT     DCU_1.HUD_HEIGHT.R            /* Hud height */
#define DCU_1_WARP_DESC_ADDR DCU_1.WARP_DESC_ADDR.R        /* Warping Descriptor base address */
#define DCU_1_WARP_IRQ_CTRL  DCU_1.WARP_IRQ_CTRL.R         /* Warping interrupt configuration */
#define DCU_1_WARP_IRQ_STAT  DCU_1.WARP_IRQ_STAT.R         /* Warp interrupt status */
#define DCU_1_WARP_CTRL      DCU_1.WARP_CTRL.R             /* Warping control */
#define DCU_1_WARP_XOVR_STAT DCU_1.WARP_XOVR_STAT.R        /* Warping X overflow status */
#define DCU_1_WARP_YOVR_STAT DCU_1.WARP_YOVR_STAT.R        /* Warping Y overflow status */
#define DCU_1_WARP_DESC_TB_SZ DCU_1.WARP_DESC_TB_SZ.R      /* Warping line descriptor table size */

/* DDRC_PRIOMAN */
#define DDRC_PRIOMAN_CONFIG1 DDRC_PRIOMAN.CONFIG1.R        /* DDRC PRIOMAN_CONFIG1 */
#define DDRC_PRIOMAN_CONFIG2 DDRC_PRIOMAN.CONFIG2.R        /* PRIOMAN_CONFIG2 */
#define DDRC_PRIOMAN_HIPRIO_CONFIG DDRC_PRIOMAN.HIPRIO_CONFIG.R /* High Priority Configuration Register */
#define DDRC_PRIOMAN_LUT_MAIN_U0 DDRC_PRIOMAN.LUT_MAIN_U[0].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_U1 DDRC_PRIOMAN.LUT_MAIN_U[1].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_U2 DDRC_PRIOMAN.LUT_MAIN_U[2].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_U3 DDRC_PRIOMAN.LUT_MAIN_U[3].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_U4 DDRC_PRIOMAN.LUT_MAIN_U[4].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_U5 DDRC_PRIOMAN.LUT_MAIN_U[5].R /* LUT Main Upper Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L0 DDRC_PRIOMAN.LUT_MAIN_L[0].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L1 DDRC_PRIOMAN.LUT_MAIN_L[1].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L2 DDRC_PRIOMAN.LUT_MAIN_L[2].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L3 DDRC_PRIOMAN.LUT_MAIN_L[3].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L4 DDRC_PRIOMAN.LUT_MAIN_L[4].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_MAIN_L5 DDRC_PRIOMAN.LUT_MAIN_L[5].R /* LUT Main Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT0 DDRC_PRIOMAN.LUT_ALT[0].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT1 DDRC_PRIOMAN.LUT_ALT[1].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT2 DDRC_PRIOMAN.LUT_ALT[2].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT3 DDRC_PRIOMAN.LUT_ALT[3].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT4 DDRC_PRIOMAN.LUT_ALT[4].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT5 DDRC_PRIOMAN.LUT_ALT[5].R    /* LUT Alternate Upper Registers */
#define DDRC_PRIOMAN_LUT_ALT_L0 DDRC_PRIOMAN.LUT_ALT_L[0].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT_L1 DDRC_PRIOMAN.LUT_ALT_L[1].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT_L2 DDRC_PRIOMAN.LUT_ALT_L[2].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT_L3 DDRC_PRIOMAN.LUT_ALT_L[3].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT_L4 DDRC_PRIOMAN.LUT_ALT_L[4].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_LUT_ALT_L5 DDRC_PRIOMAN.LUT_ALT_L[5].R /* LUT Alternate Lower Registers */
#define DDRC_PRIOMAN_PERMON_CONFIG DDRC_PRIOMAN.PERMON_CONFIG.R /* Performance Monitor Configuration Register */
#define DDRC_PRIOMAN_ETC     DDRC_PRIOMAN.ETC.R            /* Event Time Counter Register */
#define DDRC_PRIOMAN_ETP     DDRC_PRIOMAN.ETP.R            /* Event Time Preset Register */
#define DDRC_PRIOMAN_PER_MON_1_2_L0 DDRC_PRIOMAN.PER_MON_1_2_L0.R /* Performance Monitor 1 and 2 Address Registers */
#define DDRC_PRIOMAN_PER_MON_1_2_L1 DDRC_PRIOMAN.PER_MON_1_2_L1.R /* Performance Monitor 1 and 2 Address Registers */
#define DDRC_PRIOMAN_PER_MON_1_2_H0 DDRC_PRIOMAN.PER_MON_1_2_H0.R /* Performance Monitor 1 and 2 Address High Register */
#define DDRC_PRIOMAN_PER_MON_1_2_H1 DDRC_PRIOMAN.PER_MON_1_2_H1.R /* Performance Monitor 1 and 2 Address High Register */
#define DDRC_PRIOMAN_PER_MON_C0 DDRC_PRIOMAN.PER_MON_C[0].R /* Performance Monitor Counters Registers */
#define DDRC_PRIOMAN_PER_MON_C1 DDRC_PRIOMAN.PER_MON_C[1].R /* Performance Monitor Counters Registers */
#define DDRC_PRIOMAN_PER_MON_C2 DDRC_PRIOMAN.PER_MON_C[2].R /* Performance Monitor Counters Registers */
#define DDRC_PRIOMAN_PER_MON_C3 DDRC_PRIOMAN.PER_MON_C[3].R /* Performance Monitor Counters Registers */
#define DDRC_PRIOMAN_GRA_ACK_C0 DDRC_PRIOMAN.GRA_ACK_C[0].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_GRA_ACK_C1 DDRC_PRIOMAN.GRA_ACK_C[1].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_GRA_ACK_C2 DDRC_PRIOMAN.GRA_ACK_C[2].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_GRA_ACK_C3 DDRC_PRIOMAN.GRA_ACK_C[3].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_GRA_ACK_C4 DDRC_PRIOMAN.GRA_ACK_C[4].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_GRA_ACK_C5 DDRC_PRIOMAN.GRA_ACK_C[5].R /* Granted Ack Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C0 DDRC_PRIOMAN.CUM_WAIT_C[0].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C1 DDRC_PRIOMAN.CUM_WAIT_C[1].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C2 DDRC_PRIOMAN.CUM_WAIT_C[2].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C3 DDRC_PRIOMAN.CUM_WAIT_C[3].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C4 DDRC_PRIOMAN.CUM_WAIT_C[4].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_CUM_WAIT_C5 DDRC_PRIOMAN.CUM_WAIT_C[5].R /* Cumulative Wait Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C0 DDRC_PRIOMAN.SUM_PRI_C[0].R /* Summed Priority Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C1 DDRC_PRIOMAN.SUM_PRI_C[1].R /* Summed Priority Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C2 DDRC_PRIOMAN.SUM_PRI_C[2].R /* Summed Priority Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C3 DDRC_PRIOMAN.SUM_PRI_C[3].R /* Summed Priority Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C4 DDRC_PRIOMAN.SUM_PRI_C[4].R /* Summed Priority Counter Registers */
#define DDRC_PRIOMAN_SUM_PRI_C5 DDRC_PRIOMAN.SUM_PRI_C[5].R /* Summed Priority Counter Registers */

/* DMA */
#define DMA_0_CR             DMA_0.CR.R                    /* Control Register */
#define DMA_0_ES             DMA_0.ES.R                    /* Error Status Register */
#define DMA_0_ERQ            DMA_0.ERQ.R                   /* Enable Request Register */
#define DMA_0_EEI            DMA_0.EEI.R                   /* Enable Error Interrupt Register */
#define DMA_0_CEEI           DMA_0.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_0_SEEI           DMA_0.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_0_CERQ           DMA_0.CERQ.R                  /* Clear Enable Request Register */
#define DMA_0_SERQ           DMA_0.SERQ.R                  /* Set Enable Request Register */
#define DMA_0_CDNE           DMA_0.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_0_SSRT           DMA_0.SSRT.R                  /* Set START Bit Register */
#define DMA_0_CERR           DMA_0.CERR.R                  /* Clear Error Register */
#define DMA_0_CINT           DMA_0.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_0_INT            DMA_0.INT.R                   /* Interrupt Request Register */
#define DMA_0_ERR            DMA_0.ERR.R                   /* Error Register */
#define DMA_0_HRS            DMA_0.HRS.R                   /* Hardware Request Status Register */
#define DMA_0_DCHPRI3        DMA_0.DCHPRI3.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI2        DMA_0.DCHPRI2.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI1        DMA_0.DCHPRI1.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI0        DMA_0.DCHPRI0.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI7        DMA_0.DCHPRI7.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI6        DMA_0.DCHPRI6.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI5        DMA_0.DCHPRI5.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI4        DMA_0.DCHPRI4.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI11       DMA_0.DCHPRI11.R              /* Channel n Priority Register */
#define DMA_0_DCHPRI10       DMA_0.DCHPRI10.R              /* Channel n Priority Register */
#define DMA_0_DCHPRI9        DMA_0.DCHPRI9.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI8        DMA_0.DCHPRI8.R               /* Channel n Priority Register */
#define DMA_0_DCHPRI15       DMA_0.DCHPRI15.R              /* Channel n Priority Register */
#define DMA_0_DCHPRI14       DMA_0.DCHPRI14.R              /* Channel n Priority Register */
#define DMA_0_DCHPRI13       DMA_0.DCHPRI13.R              /* Channel n Priority Register */
#define DMA_0_DCHPRI12       DMA_0.DCHPRI12.R              /* Channel n Priority Register */
#define DMA_0_DCHMID3        DMA_0.DCHMID3.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID2        DMA_0.DCHMID2.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID1        DMA_0.DCHMID1.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID0        DMA_0.DCHMID0.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID7        DMA_0.DCHMID7.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID6        DMA_0.DCHMID6.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID5        DMA_0.DCHMID5.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID4        DMA_0.DCHMID4.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID11       DMA_0.DCHMID11.R              /* Channel n Master ID Register */
#define DMA_0_DCHMID10       DMA_0.DCHMID10.R              /* Channel n Master ID Register */
#define DMA_0_DCHMID9        DMA_0.DCHMID9.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID8        DMA_0.DCHMID8.R               /* Channel n Master ID Register */
#define DMA_0_DCHMID15       DMA_0.DCHMID15.R              /* Channel n Master ID Register */
#define DMA_0_DCHMID14       DMA_0.DCHMID14.R              /* Channel n Master ID Register */
#define DMA_0_DCHMID13       DMA_0.DCHMID13.R              /* Channel n Master ID Register */
#define DMA_0_DCHMID12       DMA_0.DCHMID12.R              /* Channel n Master ID Register */
#define DMA_0_TCD0_SADDR     DMA_0.TCD[0].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD0_SOFF      DMA_0.TCD[0].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD0_ATTR      DMA_0.TCD[0].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD0_NBYTES_MLNO DMA_0.TCD[0].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD0_NBYTES_MLOFFNO DMA_0.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD0_NBYTES_MLOFFYES DMA_0.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD0_SLAST     DMA_0.TCD[0].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD0_DADDR     DMA_0.TCD[0].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD0_DOFF      DMA_0.TCD[0].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD0_CITER_ELINKNO DMA_0.TCD[0].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD0_CITER_ELINKYES DMA_0.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD0_DLASTSGA  DMA_0.TCD[0].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD0_CSR       DMA_0.TCD[0].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD0_BITER_ELINKNO DMA_0.TCD[0].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD0_BITER_ELINKYES DMA_0.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_SADDR     DMA_0.TCD[1].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD1_SOFF      DMA_0.TCD[1].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD1_ATTR      DMA_0.TCD[1].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD1_NBYTES_MLNO DMA_0.TCD[1].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD1_NBYTES_MLOFFNO DMA_0.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD1_NBYTES_MLOFFYES DMA_0.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD1_SLAST     DMA_0.TCD[1].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD1_DADDR     DMA_0.TCD[1].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD1_DOFF      DMA_0.TCD[1].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD1_CITER_ELINKNO DMA_0.TCD[1].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD1_CITER_ELINKYES DMA_0.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_DLASTSGA  DMA_0.TCD[1].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD1_CSR       DMA_0.TCD[1].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD1_BITER_ELINKNO DMA_0.TCD[1].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD1_BITER_ELINKYES DMA_0.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_SADDR     DMA_0.TCD[2].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD2_SOFF      DMA_0.TCD[2].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD2_ATTR      DMA_0.TCD[2].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD2_NBYTES_MLNO DMA_0.TCD[2].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD2_NBYTES_MLOFFNO DMA_0.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD2_NBYTES_MLOFFYES DMA_0.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD2_SLAST     DMA_0.TCD[2].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD2_DADDR     DMA_0.TCD[2].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD2_DOFF      DMA_0.TCD[2].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD2_CITER_ELINKNO DMA_0.TCD[2].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD2_CITER_ELINKYES DMA_0.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_DLASTSGA  DMA_0.TCD[2].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD2_CSR       DMA_0.TCD[2].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD2_BITER_ELINKNO DMA_0.TCD[2].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD2_BITER_ELINKYES DMA_0.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_SADDR     DMA_0.TCD[3].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD3_SOFF      DMA_0.TCD[3].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD3_ATTR      DMA_0.TCD[3].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD3_NBYTES_MLNO DMA_0.TCD[3].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD3_NBYTES_MLOFFNO DMA_0.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD3_NBYTES_MLOFFYES DMA_0.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD3_SLAST     DMA_0.TCD[3].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD3_DADDR     DMA_0.TCD[3].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD3_DOFF      DMA_0.TCD[3].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD3_CITER_ELINKNO DMA_0.TCD[3].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD3_CITER_ELINKYES DMA_0.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_DLASTSGA  DMA_0.TCD[3].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD3_CSR       DMA_0.TCD[3].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD3_BITER_ELINKNO DMA_0.TCD[3].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD3_BITER_ELINKYES DMA_0.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_SADDR     DMA_0.TCD[4].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD4_SOFF      DMA_0.TCD[4].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD4_ATTR      DMA_0.TCD[4].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD4_NBYTES_MLNO DMA_0.TCD[4].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD4_NBYTES_MLOFFNO DMA_0.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD4_NBYTES_MLOFFYES DMA_0.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD4_SLAST     DMA_0.TCD[4].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD4_DADDR     DMA_0.TCD[4].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD4_DOFF      DMA_0.TCD[4].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD4_CITER_ELINKNO DMA_0.TCD[4].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD4_CITER_ELINKYES DMA_0.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_DLASTSGA  DMA_0.TCD[4].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD4_CSR       DMA_0.TCD[4].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD4_BITER_ELINKNO DMA_0.TCD[4].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD4_BITER_ELINKYES DMA_0.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_SADDR     DMA_0.TCD[5].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD5_SOFF      DMA_0.TCD[5].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD5_ATTR      DMA_0.TCD[5].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD5_NBYTES_MLNO DMA_0.TCD[5].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD5_NBYTES_MLOFFNO DMA_0.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD5_NBYTES_MLOFFYES DMA_0.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD5_SLAST     DMA_0.TCD[5].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD5_DADDR     DMA_0.TCD[5].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD5_DOFF      DMA_0.TCD[5].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD5_CITER_ELINKNO DMA_0.TCD[5].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD5_CITER_ELINKYES DMA_0.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_DLASTSGA  DMA_0.TCD[5].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD5_CSR       DMA_0.TCD[5].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD5_BITER_ELINKNO DMA_0.TCD[5].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD5_BITER_ELINKYES DMA_0.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_SADDR     DMA_0.TCD[6].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD6_SOFF      DMA_0.TCD[6].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD6_ATTR      DMA_0.TCD[6].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD6_NBYTES_MLNO DMA_0.TCD[6].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD6_NBYTES_MLOFFNO DMA_0.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD6_NBYTES_MLOFFYES DMA_0.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD6_SLAST     DMA_0.TCD[6].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD6_DADDR     DMA_0.TCD[6].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD6_DOFF      DMA_0.TCD[6].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD6_CITER_ELINKNO DMA_0.TCD[6].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD6_CITER_ELINKYES DMA_0.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_DLASTSGA  DMA_0.TCD[6].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD6_CSR       DMA_0.TCD[6].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD6_BITER_ELINKNO DMA_0.TCD[6].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD6_BITER_ELINKYES DMA_0.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_SADDR     DMA_0.TCD[7].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD7_SOFF      DMA_0.TCD[7].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD7_ATTR      DMA_0.TCD[7].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD7_NBYTES_MLNO DMA_0.TCD[7].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD7_NBYTES_MLOFFNO DMA_0.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD7_NBYTES_MLOFFYES DMA_0.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD7_SLAST     DMA_0.TCD[7].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD7_DADDR     DMA_0.TCD[7].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD7_DOFF      DMA_0.TCD[7].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD7_CITER_ELINKNO DMA_0.TCD[7].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD7_CITER_ELINKYES DMA_0.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_DLASTSGA  DMA_0.TCD[7].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD7_CSR       DMA_0.TCD[7].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD7_BITER_ELINKNO DMA_0.TCD[7].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD7_BITER_ELINKYES DMA_0.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_SADDR     DMA_0.TCD[8].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD8_SOFF      DMA_0.TCD[8].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD8_ATTR      DMA_0.TCD[8].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD8_NBYTES_MLNO DMA_0.TCD[8].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD8_NBYTES_MLOFFNO DMA_0.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD8_NBYTES_MLOFFYES DMA_0.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD8_SLAST     DMA_0.TCD[8].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD8_DADDR     DMA_0.TCD[8].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD8_DOFF      DMA_0.TCD[8].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD8_CITER_ELINKNO DMA_0.TCD[8].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD8_CITER_ELINKYES DMA_0.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_DLASTSGA  DMA_0.TCD[8].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD8_CSR       DMA_0.TCD[8].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD8_BITER_ELINKNO DMA_0.TCD[8].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD8_BITER_ELINKYES DMA_0.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_SADDR     DMA_0.TCD[9].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD9_SOFF      DMA_0.TCD[9].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD9_ATTR      DMA_0.TCD[9].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD9_NBYTES_MLNO DMA_0.TCD[9].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD9_NBYTES_MLOFFNO DMA_0.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD9_NBYTES_MLOFFYES DMA_0.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD9_SLAST     DMA_0.TCD[9].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD9_DADDR     DMA_0.TCD[9].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD9_DOFF      DMA_0.TCD[9].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD9_CITER_ELINKNO DMA_0.TCD[9].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD9_CITER_ELINKYES DMA_0.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_DLASTSGA  DMA_0.TCD[9].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD9_CSR       DMA_0.TCD[9].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD9_BITER_ELINKNO DMA_0.TCD[9].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD9_BITER_ELINKYES DMA_0.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_SADDR    DMA_0.TCD[10].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD10_SOFF     DMA_0.TCD[10].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD10_ATTR     DMA_0.TCD[10].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD10_NBYTES_MLNO DMA_0.TCD[10].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD10_NBYTES_MLOFFNO DMA_0.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD10_NBYTES_MLOFFYES DMA_0.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD10_SLAST    DMA_0.TCD[10].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD10_DADDR    DMA_0.TCD[10].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD10_DOFF     DMA_0.TCD[10].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD10_CITER_ELINKNO DMA_0.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD10_CITER_ELINKYES DMA_0.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_DLASTSGA DMA_0.TCD[10].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD10_CSR      DMA_0.TCD[10].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD10_BITER_ELINKNO DMA_0.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD10_BITER_ELINKYES DMA_0.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_SADDR    DMA_0.TCD[11].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD11_SOFF     DMA_0.TCD[11].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD11_ATTR     DMA_0.TCD[11].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD11_NBYTES_MLNO DMA_0.TCD[11].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD11_NBYTES_MLOFFNO DMA_0.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD11_NBYTES_MLOFFYES DMA_0.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD11_SLAST    DMA_0.TCD[11].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD11_DADDR    DMA_0.TCD[11].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD11_DOFF     DMA_0.TCD[11].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD11_CITER_ELINKNO DMA_0.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD11_CITER_ELINKYES DMA_0.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_DLASTSGA DMA_0.TCD[11].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD11_CSR      DMA_0.TCD[11].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD11_BITER_ELINKNO DMA_0.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD11_BITER_ELINKYES DMA_0.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_SADDR    DMA_0.TCD[12].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD12_SOFF     DMA_0.TCD[12].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD12_ATTR     DMA_0.TCD[12].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD12_NBYTES_MLNO DMA_0.TCD[12].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD12_NBYTES_MLOFFNO DMA_0.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD12_NBYTES_MLOFFYES DMA_0.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD12_SLAST    DMA_0.TCD[12].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD12_DADDR    DMA_0.TCD[12].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD12_DOFF     DMA_0.TCD[12].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD12_CITER_ELINKNO DMA_0.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD12_CITER_ELINKYES DMA_0.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_DLASTSGA DMA_0.TCD[12].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD12_CSR      DMA_0.TCD[12].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD12_BITER_ELINKNO DMA_0.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD12_BITER_ELINKYES DMA_0.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_SADDR    DMA_0.TCD[13].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD13_SOFF     DMA_0.TCD[13].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD13_ATTR     DMA_0.TCD[13].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD13_NBYTES_MLNO DMA_0.TCD[13].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD13_NBYTES_MLOFFNO DMA_0.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD13_NBYTES_MLOFFYES DMA_0.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD13_SLAST    DMA_0.TCD[13].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD13_DADDR    DMA_0.TCD[13].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD13_DOFF     DMA_0.TCD[13].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD13_CITER_ELINKNO DMA_0.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD13_CITER_ELINKYES DMA_0.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_DLASTSGA DMA_0.TCD[13].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD13_CSR      DMA_0.TCD[13].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD13_BITER_ELINKNO DMA_0.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD13_BITER_ELINKYES DMA_0.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_SADDR    DMA_0.TCD[14].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD14_SOFF     DMA_0.TCD[14].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD14_ATTR     DMA_0.TCD[14].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD14_NBYTES_MLNO DMA_0.TCD[14].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD14_NBYTES_MLOFFNO DMA_0.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD14_NBYTES_MLOFFYES DMA_0.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD14_SLAST    DMA_0.TCD[14].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD14_DADDR    DMA_0.TCD[14].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD14_DOFF     DMA_0.TCD[14].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD14_CITER_ELINKNO DMA_0.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD14_CITER_ELINKYES DMA_0.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_DLASTSGA DMA_0.TCD[14].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD14_CSR      DMA_0.TCD[14].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD14_BITER_ELINKNO DMA_0.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD14_BITER_ELINKYES DMA_0.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_SADDR    DMA_0.TCD[15].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD15_SOFF     DMA_0.TCD[15].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD15_ATTR     DMA_0.TCD[15].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD15_NBYTES_MLNO DMA_0.TCD[15].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_0_TCD15_NBYTES_MLOFFNO DMA_0.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_0_TCD15_NBYTES_MLOFFYES DMA_0.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_0_TCD15_SLAST    DMA_0.TCD[15].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD15_DADDR    DMA_0.TCD[15].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD15_DOFF     DMA_0.TCD[15].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD15_CITER_ELINKNO DMA_0.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD15_CITER_ELINKYES DMA_0.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_DLASTSGA DMA_0.TCD[15].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD15_CSR      DMA_0.TCD[15].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD15_BITER_ELINKNO DMA_0.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD15_BITER_ELINKYES DMA_0.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */

#define DMA_1_CR             DMA_1.CR.R                    /* Control Register */
#define DMA_1_ES             DMA_1.ES.R                    /* Error Status Register */
#define DMA_1_ERQ            DMA_1.ERQ.R                   /* Enable Request Register */
#define DMA_1_EEI            DMA_1.EEI.R                   /* Enable Error Interrupt Register */
#define DMA_1_CEEI           DMA_1.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_1_SEEI           DMA_1.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_1_CERQ           DMA_1.CERQ.R                  /* Clear Enable Request Register */
#define DMA_1_SERQ           DMA_1.SERQ.R                  /* Set Enable Request Register */
#define DMA_1_CDNE           DMA_1.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_1_SSRT           DMA_1.SSRT.R                  /* Set START Bit Register */
#define DMA_1_CERR           DMA_1.CERR.R                  /* Clear Error Register */
#define DMA_1_CINT           DMA_1.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_1_INT            DMA_1.INT.R                   /* Interrupt Request Register */
#define DMA_1_ERR            DMA_1.ERR.R                   /* Error Register */
#define DMA_1_HRS            DMA_1.HRS.R                   /* Hardware Request Status Register */
#define DMA_1_DCHPRI3        DMA_1.DCHPRI3.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI2        DMA_1.DCHPRI2.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI1        DMA_1.DCHPRI1.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI0        DMA_1.DCHPRI0.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI7        DMA_1.DCHPRI7.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI6        DMA_1.DCHPRI6.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI5        DMA_1.DCHPRI5.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI4        DMA_1.DCHPRI4.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI11       DMA_1.DCHPRI11.R              /* Channel n Priority Register */
#define DMA_1_DCHPRI10       DMA_1.DCHPRI10.R              /* Channel n Priority Register */
#define DMA_1_DCHPRI9        DMA_1.DCHPRI9.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI8        DMA_1.DCHPRI8.R               /* Channel n Priority Register */
#define DMA_1_DCHPRI15       DMA_1.DCHPRI15.R              /* Channel n Priority Register */
#define DMA_1_DCHPRI14       DMA_1.DCHPRI14.R              /* Channel n Priority Register */
#define DMA_1_DCHPRI13       DMA_1.DCHPRI13.R              /* Channel n Priority Register */
#define DMA_1_DCHPRI12       DMA_1.DCHPRI12.R              /* Channel n Priority Register */
#define DMA_1_DCHMID3        DMA_1.DCHMID3.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID2        DMA_1.DCHMID2.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID1        DMA_1.DCHMID1.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID0        DMA_1.DCHMID0.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID7        DMA_1.DCHMID7.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID6        DMA_1.DCHMID6.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID5        DMA_1.DCHMID5.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID4        DMA_1.DCHMID4.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID11       DMA_1.DCHMID11.R              /* Channel n Master ID Register */
#define DMA_1_DCHMID10       DMA_1.DCHMID10.R              /* Channel n Master ID Register */
#define DMA_1_DCHMID9        DMA_1.DCHMID9.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID8        DMA_1.DCHMID8.R               /* Channel n Master ID Register */
#define DMA_1_DCHMID15       DMA_1.DCHMID15.R              /* Channel n Master ID Register */
#define DMA_1_DCHMID14       DMA_1.DCHMID14.R              /* Channel n Master ID Register */
#define DMA_1_DCHMID13       DMA_1.DCHMID13.R              /* Channel n Master ID Register */
#define DMA_1_DCHMID12       DMA_1.DCHMID12.R              /* Channel n Master ID Register */
#define DMA_1_TCD0_SADDR     DMA_1.TCD[0].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD0_SOFF      DMA_1.TCD[0].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD0_ATTR      DMA_1.TCD[0].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD0_NBYTES_MLNO DMA_1.TCD[0].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD0_NBYTES_MLOFFNO DMA_1.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD0_NBYTES_MLOFFYES DMA_1.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD0_SLAST     DMA_1.TCD[0].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD0_DADDR     DMA_1.TCD[0].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD0_DOFF      DMA_1.TCD[0].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD0_CITER_ELINKNO DMA_1.TCD[0].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD0_CITER_ELINKYES DMA_1.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD0_DLASTSGA  DMA_1.TCD[0].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD0_CSR       DMA_1.TCD[0].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD0_BITER_ELINKNO DMA_1.TCD[0].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD0_BITER_ELINKYES DMA_1.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD1_SADDR     DMA_1.TCD[1].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD1_SOFF      DMA_1.TCD[1].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD1_ATTR      DMA_1.TCD[1].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD1_NBYTES_MLNO DMA_1.TCD[1].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD1_NBYTES_MLOFFNO DMA_1.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD1_NBYTES_MLOFFYES DMA_1.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD1_SLAST     DMA_1.TCD[1].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD1_DADDR     DMA_1.TCD[1].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD1_DOFF      DMA_1.TCD[1].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD1_CITER_ELINKNO DMA_1.TCD[1].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD1_CITER_ELINKYES DMA_1.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD1_DLASTSGA  DMA_1.TCD[1].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD1_CSR       DMA_1.TCD[1].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD1_BITER_ELINKNO DMA_1.TCD[1].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD1_BITER_ELINKYES DMA_1.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD2_SADDR     DMA_1.TCD[2].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD2_SOFF      DMA_1.TCD[2].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD2_ATTR      DMA_1.TCD[2].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD2_NBYTES_MLNO DMA_1.TCD[2].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD2_NBYTES_MLOFFNO DMA_1.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD2_NBYTES_MLOFFYES DMA_1.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD2_SLAST     DMA_1.TCD[2].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD2_DADDR     DMA_1.TCD[2].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD2_DOFF      DMA_1.TCD[2].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD2_CITER_ELINKNO DMA_1.TCD[2].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD2_CITER_ELINKYES DMA_1.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD2_DLASTSGA  DMA_1.TCD[2].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD2_CSR       DMA_1.TCD[2].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD2_BITER_ELINKNO DMA_1.TCD[2].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD2_BITER_ELINKYES DMA_1.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD3_SADDR     DMA_1.TCD[3].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD3_SOFF      DMA_1.TCD[3].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD3_ATTR      DMA_1.TCD[3].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD3_NBYTES_MLNO DMA_1.TCD[3].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD3_NBYTES_MLOFFNO DMA_1.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD3_NBYTES_MLOFFYES DMA_1.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD3_SLAST     DMA_1.TCD[3].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD3_DADDR     DMA_1.TCD[3].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD3_DOFF      DMA_1.TCD[3].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD3_CITER_ELINKNO DMA_1.TCD[3].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD3_CITER_ELINKYES DMA_1.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD3_DLASTSGA  DMA_1.TCD[3].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD3_CSR       DMA_1.TCD[3].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD3_BITER_ELINKNO DMA_1.TCD[3].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD3_BITER_ELINKYES DMA_1.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD4_SADDR     DMA_1.TCD[4].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD4_SOFF      DMA_1.TCD[4].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD4_ATTR      DMA_1.TCD[4].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD4_NBYTES_MLNO DMA_1.TCD[4].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD4_NBYTES_MLOFFNO DMA_1.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD4_NBYTES_MLOFFYES DMA_1.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD4_SLAST     DMA_1.TCD[4].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD4_DADDR     DMA_1.TCD[4].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD4_DOFF      DMA_1.TCD[4].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD4_CITER_ELINKNO DMA_1.TCD[4].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD4_CITER_ELINKYES DMA_1.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD4_DLASTSGA  DMA_1.TCD[4].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD4_CSR       DMA_1.TCD[4].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD4_BITER_ELINKNO DMA_1.TCD[4].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD4_BITER_ELINKYES DMA_1.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD5_SADDR     DMA_1.TCD[5].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD5_SOFF      DMA_1.TCD[5].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD5_ATTR      DMA_1.TCD[5].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD5_NBYTES_MLNO DMA_1.TCD[5].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD5_NBYTES_MLOFFNO DMA_1.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD5_NBYTES_MLOFFYES DMA_1.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD5_SLAST     DMA_1.TCD[5].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD5_DADDR     DMA_1.TCD[5].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD5_DOFF      DMA_1.TCD[5].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD5_CITER_ELINKNO DMA_1.TCD[5].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD5_CITER_ELINKYES DMA_1.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD5_DLASTSGA  DMA_1.TCD[5].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD5_CSR       DMA_1.TCD[5].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD5_BITER_ELINKNO DMA_1.TCD[5].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD5_BITER_ELINKYES DMA_1.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD6_SADDR     DMA_1.TCD[6].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD6_SOFF      DMA_1.TCD[6].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD6_ATTR      DMA_1.TCD[6].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD6_NBYTES_MLNO DMA_1.TCD[6].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD6_NBYTES_MLOFFNO DMA_1.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD6_NBYTES_MLOFFYES DMA_1.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD6_SLAST     DMA_1.TCD[6].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD6_DADDR     DMA_1.TCD[6].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD6_DOFF      DMA_1.TCD[6].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD6_CITER_ELINKNO DMA_1.TCD[6].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD6_CITER_ELINKYES DMA_1.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD6_DLASTSGA  DMA_1.TCD[6].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD6_CSR       DMA_1.TCD[6].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD6_BITER_ELINKNO DMA_1.TCD[6].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD6_BITER_ELINKYES DMA_1.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD7_SADDR     DMA_1.TCD[7].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD7_SOFF      DMA_1.TCD[7].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD7_ATTR      DMA_1.TCD[7].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD7_NBYTES_MLNO DMA_1.TCD[7].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD7_NBYTES_MLOFFNO DMA_1.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD7_NBYTES_MLOFFYES DMA_1.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD7_SLAST     DMA_1.TCD[7].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD7_DADDR     DMA_1.TCD[7].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD7_DOFF      DMA_1.TCD[7].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD7_CITER_ELINKNO DMA_1.TCD[7].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD7_CITER_ELINKYES DMA_1.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD7_DLASTSGA  DMA_1.TCD[7].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD7_CSR       DMA_1.TCD[7].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD7_BITER_ELINKNO DMA_1.TCD[7].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD7_BITER_ELINKYES DMA_1.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD8_SADDR     DMA_1.TCD[8].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD8_SOFF      DMA_1.TCD[8].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD8_ATTR      DMA_1.TCD[8].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD8_NBYTES_MLNO DMA_1.TCD[8].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD8_NBYTES_MLOFFNO DMA_1.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD8_NBYTES_MLOFFYES DMA_1.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD8_SLAST     DMA_1.TCD[8].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD8_DADDR     DMA_1.TCD[8].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD8_DOFF      DMA_1.TCD[8].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD8_CITER_ELINKNO DMA_1.TCD[8].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD8_CITER_ELINKYES DMA_1.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD8_DLASTSGA  DMA_1.TCD[8].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD8_CSR       DMA_1.TCD[8].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD8_BITER_ELINKNO DMA_1.TCD[8].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD8_BITER_ELINKYES DMA_1.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD9_SADDR     DMA_1.TCD[9].SADDR.R          /* TCD Source Address */
#define DMA_1_TCD9_SOFF      DMA_1.TCD[9].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_1_TCD9_ATTR      DMA_1.TCD[9].ATTR.R           /* TCD Transfer Attributes */
#define DMA_1_TCD9_NBYTES_MLNO DMA_1.TCD[9].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD9_NBYTES_MLOFFNO DMA_1.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD9_NBYTES_MLOFFYES DMA_1.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD9_SLAST     DMA_1.TCD[9].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_1_TCD9_DADDR     DMA_1.TCD[9].DADDR.R          /* TCD Destination Address */
#define DMA_1_TCD9_DOFF      DMA_1.TCD[9].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_1_TCD9_CITER_ELINKNO DMA_1.TCD[9].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD9_CITER_ELINKYES DMA_1.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD9_DLASTSGA  DMA_1.TCD[9].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD9_CSR       DMA_1.TCD[9].CSR.R            /* TCD Control and Status */
#define DMA_1_TCD9_BITER_ELINKNO DMA_1.TCD[9].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD9_BITER_ELINKYES DMA_1.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD10_SADDR    DMA_1.TCD[10].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD10_SOFF     DMA_1.TCD[10].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD10_ATTR     DMA_1.TCD[10].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD10_NBYTES_MLNO DMA_1.TCD[10].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD10_NBYTES_MLOFFNO DMA_1.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD10_NBYTES_MLOFFYES DMA_1.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD10_SLAST    DMA_1.TCD[10].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD10_DADDR    DMA_1.TCD[10].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD10_DOFF     DMA_1.TCD[10].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD10_CITER_ELINKNO DMA_1.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD10_CITER_ELINKYES DMA_1.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD10_DLASTSGA DMA_1.TCD[10].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD10_CSR      DMA_1.TCD[10].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD10_BITER_ELINKNO DMA_1.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD10_BITER_ELINKYES DMA_1.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD11_SADDR    DMA_1.TCD[11].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD11_SOFF     DMA_1.TCD[11].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD11_ATTR     DMA_1.TCD[11].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD11_NBYTES_MLNO DMA_1.TCD[11].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD11_NBYTES_MLOFFNO DMA_1.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD11_NBYTES_MLOFFYES DMA_1.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD11_SLAST    DMA_1.TCD[11].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD11_DADDR    DMA_1.TCD[11].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD11_DOFF     DMA_1.TCD[11].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD11_CITER_ELINKNO DMA_1.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD11_CITER_ELINKYES DMA_1.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD11_DLASTSGA DMA_1.TCD[11].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD11_CSR      DMA_1.TCD[11].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD11_BITER_ELINKNO DMA_1.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD11_BITER_ELINKYES DMA_1.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD12_SADDR    DMA_1.TCD[12].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD12_SOFF     DMA_1.TCD[12].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD12_ATTR     DMA_1.TCD[12].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD12_NBYTES_MLNO DMA_1.TCD[12].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD12_NBYTES_MLOFFNO DMA_1.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD12_NBYTES_MLOFFYES DMA_1.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD12_SLAST    DMA_1.TCD[12].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD12_DADDR    DMA_1.TCD[12].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD12_DOFF     DMA_1.TCD[12].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD12_CITER_ELINKNO DMA_1.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD12_CITER_ELINKYES DMA_1.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD12_DLASTSGA DMA_1.TCD[12].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD12_CSR      DMA_1.TCD[12].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD12_BITER_ELINKNO DMA_1.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD12_BITER_ELINKYES DMA_1.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD13_SADDR    DMA_1.TCD[13].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD13_SOFF     DMA_1.TCD[13].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD13_ATTR     DMA_1.TCD[13].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD13_NBYTES_MLNO DMA_1.TCD[13].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD13_NBYTES_MLOFFNO DMA_1.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD13_NBYTES_MLOFFYES DMA_1.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD13_SLAST    DMA_1.TCD[13].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD13_DADDR    DMA_1.TCD[13].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD13_DOFF     DMA_1.TCD[13].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD13_CITER_ELINKNO DMA_1.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD13_CITER_ELINKYES DMA_1.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD13_DLASTSGA DMA_1.TCD[13].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD13_CSR      DMA_1.TCD[13].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD13_BITER_ELINKNO DMA_1.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD13_BITER_ELINKYES DMA_1.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD14_SADDR    DMA_1.TCD[14].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD14_SOFF     DMA_1.TCD[14].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD14_ATTR     DMA_1.TCD[14].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD14_NBYTES_MLNO DMA_1.TCD[14].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD14_NBYTES_MLOFFNO DMA_1.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD14_NBYTES_MLOFFYES DMA_1.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD14_SLAST    DMA_1.TCD[14].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD14_DADDR    DMA_1.TCD[14].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD14_DOFF     DMA_1.TCD[14].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD14_CITER_ELINKNO DMA_1.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD14_CITER_ELINKYES DMA_1.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD14_DLASTSGA DMA_1.TCD[14].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD14_CSR      DMA_1.TCD[14].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD14_BITER_ELINKNO DMA_1.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD14_BITER_ELINKYES DMA_1.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD15_SADDR    DMA_1.TCD[15].SADDR.R         /* TCD Source Address */
#define DMA_1_TCD15_SOFF     DMA_1.TCD[15].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_1_TCD15_ATTR     DMA_1.TCD[15].ATTR.R          /* TCD Transfer Attributes */
#define DMA_1_TCD15_NBYTES_MLNO DMA_1.TCD[15].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_1_TCD15_NBYTES_MLOFFNO DMA_1.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_1_TCD15_NBYTES_MLOFFYES DMA_1.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_1_TCD15_SLAST    DMA_1.TCD[15].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_1_TCD15_DADDR    DMA_1.TCD[15].DADDR.R         /* TCD Destination Address */
#define DMA_1_TCD15_DOFF     DMA_1.TCD[15].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_1_TCD15_CITER_ELINKNO DMA_1.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD15_CITER_ELINKYES DMA_1.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_1_TCD15_DLASTSGA DMA_1.TCD[15].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_1_TCD15_CSR      DMA_1.TCD[15].CSR.R           /* TCD Control and Status */
#define DMA_1_TCD15_BITER_ELINKNO DMA_1.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_1_TCD15_BITER_ELINKYES DMA_1.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */

/* DMAMUX */
#define DMAMUX_CHCFG3        DMAMUX.CHCFG3.R               /* Channel Configuration register */
#define DMAMUX_CHCFG2        DMAMUX.CHCFG2.R               /* Channel Configuration register */
#define DMAMUX_CHCFG1        DMAMUX.CHCFG1.R               /* Channel Configuration register */
#define DMAMUX_CHCFG0        DMAMUX.CHCFG0.R               /* Channel Configuration register */
#define DMAMUX_CHCFG7        DMAMUX.CHCFG7.R               /* Channel Configuration register */
#define DMAMUX_CHCFG6        DMAMUX.CHCFG6.R               /* Channel Configuration register */
#define DMAMUX_CHCFG5        DMAMUX.CHCFG5.R               /* Channel Configuration register */
#define DMAMUX_CHCFG4        DMAMUX.CHCFG4.R               /* Channel Configuration register */
#define DMAMUX_CHCFG11       DMAMUX.CHCFG11.R              /* Channel Configuration register */
#define DMAMUX_CHCFG10       DMAMUX.CHCFG10.R              /* Channel Configuration register */
#define DMAMUX_CHCFG9        DMAMUX.CHCFG9.R               /* Channel Configuration register */
#define DMAMUX_CHCFG8        DMAMUX.CHCFG8.R               /* Channel Configuration register */
#define DMAMUX_CHCFG15       DMAMUX.CHCFG15.R              /* Channel Configuration register */
#define DMAMUX_CHCFG14       DMAMUX.CHCFG14.R              /* Channel Configuration register */
#define DMAMUX_CHCFG13       DMAMUX.CHCFG13.R              /* Channel Configuration register */
#define DMAMUX_CHCFG12       DMAMUX.CHCFG12.R              /* Channel Configuration register */

/* EIM */
#define EIM_EIMCR            EIM.EIMCR.R                   /* Error Injection Module Configuration Register */
#define EIM_EICHEN           EIM.EICHEN.R                  /* Error Injection Channel Enable register */
#define EIM_EICHD0_WORD0     EIM.EICHD[0].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD0_WORD1     EIM.EICHD[0].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD0_WORD2     EIM.EICHD[0].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD1_WORD0     EIM.EICHD[1].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD1_WORD1     EIM.EICHD[1].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD1_WORD2     EIM.EICHD[1].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD2_WORD0     EIM.EICHD[2].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD2_WORD1     EIM.EICHD[2].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD2_WORD2     EIM.EICHD[2].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD3_WORD0     EIM.EICHD[3].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD3_WORD1     EIM.EICHD[3].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD3_WORD2     EIM.EICHD[3].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD4_WORD0     EIM.EICHD[4].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD4_WORD1     EIM.EICHD[4].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD4_WORD2     EIM.EICHD[4].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD5_WORD0     EIM.EICHD[5].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD5_WORD1     EIM.EICHD[5].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD5_WORD2     EIM.EICHD[5].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD6_WORD0     EIM.EICHD[6].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD6_WORD1     EIM.EICHD[6].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD6_WORD2     EIM.EICHD[6].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD7_WORD0     EIM.EICHD[7].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD7_WORD1     EIM.EICHD[7].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD7_WORD2     EIM.EICHD[7].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD8_WORD0     EIM.EICHD[8].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD8_WORD1     EIM.EICHD[8].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD8_WORD2     EIM.EICHD[8].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD9_WORD0     EIM.EICHD[9].WORD0.R          /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD9_WORD1     EIM.EICHD[9].WORD1.R          /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD9_WORD2     EIM.EICHD[9].WORD2.R          /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD10_WORD0    EIM.EICHD[10].WORD0.R         /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD10_WORD1    EIM.EICHD[10].WORD1.R         /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD10_WORD2    EIM.EICHD[10].WORD2.R         /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD11_WORD0    EIM.EICHD[11].WORD0.R         /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD11_WORD1    EIM.EICHD[11].WORD1.R         /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD11_WORD2    EIM.EICHD[11].WORD2.R         /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD12_WORD0    EIM.EICHD[12].WORD0.R         /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD12_WORD1    EIM.EICHD[12].WORD1.R         /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD12_WORD2    EIM.EICHD[12].WORD2.R         /* Error Injection Channel Descriptor, Word2 */
#define EIM_EICHD13_WORD0    EIM.EICHD[13].WORD0.R         /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD13_WORD1    EIM.EICHD[13].WORD1.R         /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD13_WORD2    EIM.EICHD[13].WORD2.R         /* Error Injection Channel Descriptor, Word2 */

/* ENET */
#define ENET_EIR             ENET.EIR.R                    /* Interrupt Event Register */
#define ENET_EIMR            ENET.EIMR.R                   /* Interrupt Mask Register */
#define ENET_RDAR            ENET.RDAR.R                   /* Receive Descriptor Active Register - Ring 0 */
#define ENET_TDAR            ENET.TDAR.R                   /* Transmit Descriptor Active Register - Ring 0 */
#define ENET_ECR             ENET.ECR.R                    /* Ethernet Control Register */
#define ENET_MMFR            ENET.MMFR.R                   /* MII Management Frame Register */
#define ENET_MSCR            ENET.MSCR.R                   /* MII Speed Control Register */
#define ENET_MIBC            ENET.MIBC.R                   /* MIB Control Register */
#define ENET_RCR             ENET.RCR.R                    /* Receive Control Register */
#define ENET_TCR             ENET.TCR.R                    /* Transmit Control Register */
#define ENET_PALR            ENET.PALR.R                   /* Physical Address Lower Register */
#define ENET_PAUR            ENET.PAUR.R                   /* Physical Address Upper Register */
#define ENET_OPD             ENET.OPD.R                    /* Opcode/Pause Duration Register */
#define ENET_TXIC0           ENET.TXIC[0].R                /* Transmit Interrupt Coalescing Register */
#define ENET_TXIC1           ENET.TXIC[1].R                /* Transmit Interrupt Coalescing Register */
#define ENET_TXIC2           ENET.TXIC[2].R                /* Transmit Interrupt Coalescing Register */
#define ENET_RXIC0           ENET.RXIC[0].R                /* Receive Interrupt Coalescing Register */
#define ENET_RXIC1           ENET.RXIC[1].R                /* Receive Interrupt Coalescing Register */
#define ENET_RXIC2           ENET.RXIC[2].R                /* Receive Interrupt Coalescing Register */
#define ENET_IAUR            ENET.IAUR.R                   /* Descriptor Individual Upper Address Register */
#define ENET_IALR            ENET.IALR.R                   /* Descriptor Individual Lower Address Register */
#define ENET_GAUR            ENET.GAUR.R                   /* Descriptor Group Upper Address Register */
#define ENET_GALR            ENET.GALR.R                   /* Descriptor Group Lower Address Register */
#define ENET_TFWR            ENET.TFWR.R                   /* Transmit FIFO Watermark Register */
#define ENET_RDSR1           ENET.RDSR1.R                  /* Receive Descriptor Ring 1 Start Register */
#define ENET_TDSR1           ENET.TDSR1.R                  /* Transmit Buffer Descriptor Ring 1 Start Register */
#define ENET_MRBR1           ENET.MRBR1.R                  /* Maximum Receive Buffer Size Register - Ring 1 */
#define ENET_RDSR2           ENET.RDSR2.R                  /* Receive Descriptor Ring 2 Start Register */
#define ENET_TDSR2           ENET.TDSR2.R                  /* Transmit Buffer Descriptor Ring 2 Start Register */
#define ENET_MRBR2           ENET.MRBR2.R                  /* Maximum Receive Buffer Size Register - Ring 2 */
#define ENET_RDSR            ENET.RDSR.R                   /* Receive Descriptor Ring 0 Start Register */
#define ENET_TDSR            ENET.TDSR.R                   /* Transmit Buffer Descriptor Ring 0 Start Register */
#define ENET_MRBR            ENET.MRBR.R                   /* Maximum Receive Buffer Size Register - Ring 0 */
#define ENET_RSFL            ENET.RSFL.R                   /* Receive FIFO Section Full Threshold */
#define ENET_RSEM            ENET.RSEM.R                   /* Receive FIFO Section Empty Threshold */
#define ENET_RAEM            ENET.RAEM.R                   /* Receive FIFO Almost Empty Threshold */
#define ENET_RAFL            ENET.RAFL.R                   /* Receive FIFO Almost Full Threshold */
#define ENET_TSEM            ENET.TSEM.R                   /* Transmit FIFO Section Empty Threshold */
#define ENET_TAEM            ENET.TAEM.R                   /* Transmit FIFO Almost Empty Threshold */
#define ENET_TAFL            ENET.TAFL.R                   /* Transmit FIFO Almost Full Threshold */
#define ENET_TIPG            ENET.TIPG.R                   /* Transmit Inter-Packet Gap */
#define ENET_FTRL            ENET.FTRL.R                   /* Frame Truncation Length */
#define ENET_TACC            ENET.TACC.R                   /* Transmit Accelerator Function Configuration */
#define ENET_RACC            ENET.RACC.R                   /* Receive Accelerator Function Configuration */
#define ENET_RCMR1           ENET.RCMR[0].R                /* Receive Classification Match Register for Class n */
#define ENET_RCMR2           ENET.RCMR[1].R                /* Receive Classification Match Register for Class n */
#define ENET_DMA1CFG         ENET.DMACFG[0].R              /* DMA Class Based Configuration */
#define ENET_DMA2CFG         ENET.DMACFG[1].R              /* DMA Class Based Configuration */
#define ENET_RDAR1           ENET.RDAR1.R                  /* Receive Descriptor Active Register - Ring 1 */
#define ENET_TDAR1           ENET.TDAR1.R                  /* Transmit Descriptor Active Register - Ring 1 */
#define ENET_RDAR2           ENET.RDAR2.R                  /* Receive Descriptor Active Register - Ring 2 */
#define ENET_TDAR2           ENET.TDAR2.R                  /* Transmit Descriptor Active Register - Ring 2 */
#define ENET_QOS             ENET.QOS.R                    /* QOS Scheme */
#define ENET_RMON_T_DROP     ENET.RMON_T_DROP.R            /* Reserved Statistic Register */
#define ENET_RMON_T_PACKETS  ENET.RMON_T_PACKETS.R         /* Tx Packet Count Statistic Register */
#define ENET_RMON_T_BC_PKT   ENET.RMON_T_BC_PKT.R          /* Tx Broadcast Packets Statistic Register */
#define ENET_RMON_T_MC_PKT   ENET.RMON_T_MC_PKT.R          /* Tx Multicast Packets Statistic Register */
#define ENET_RMON_T_CRC_ALIGN ENET.RMON_T_CRC_ALIGN.R      /* Tx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_T_UNDERSIZE ENET.RMON_T_UNDERSIZE.R      /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
#define ENET_RMON_T_OVERSIZE ENET.RMON_T_OVERSIZE.R        /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
#define ENET_RMON_T_FRAG     ENET.RMON_T_FRAG.R            /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_JAB      ENET.RMON_T_JAB.R             /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_COL      ENET.RMON_T_COL.R             /* Tx Collision Count Statistic Register */
#define ENET_RMON_T_P64      ENET.RMON_T_P64.R             /* Tx 64-Byte Packets Statistic Register */
#define ENET_RMON_T_P65TO127 ENET.RMON_T_P65TO127.R        /* Tx 65- to 127-byte Packets Statistic Register */
#define ENET_RMON_T_P128TO255 ENET.RMON_T_P128TO255.R      /* Tx 128- to 255-byte Packets Statistic Register */
#define ENET_RMON_T_P256TO511 ENET.RMON_T_P256TO511.R      /* Tx 256- to 511-byte Packets Statistic Register */
#define ENET_RMON_T_P512TO1023 ENET.RMON_T_P512TO1023.R    /* Tx 512- to 1023-byte Packets Statistic Register */
#define ENET_RMON_T_P1024TO2047 ENET.RMON_T_P1024TO2047.R  /* Tx 1024- to 2047-byte Packets Statistic Register */
#define ENET_RMON_T_P_GTE2048 ENET.RMON_T_P_GTE2048.R      /* Tx Packets Greater Than 2048 Bytes Statistic Register */
#define ENET_RMON_T_OCTETS   ENET.RMON_T_OCTETS.R          /* Tx Octets Statistic Register */
#define ENET_IEEE_T_DROP     ENET.IEEE_T_DROP.R            /* Reserved Statistic Register */
#define ENET_IEEE_T_FRAME_OK ENET.IEEE_T_FRAME_OK.R        /* Frames Transmitted OK Statistic Register */
#define ENET_IEEE_T_1COL     ENET.IEEE_T_1COL.R            /* Frames Transmitted with Single Collision Statistic Register */
#define ENET_IEEE_T_MCOL     ENET.IEEE_T_MCOL.R            /* Frames Transmitted with Multiple Collisions Statistic Register */
#define ENET_IEEE_T_DEF      ENET.IEEE_T_DEF.R             /* Frames Transmitted after Deferral Delay Statistic Register */
#define ENET_IEEE_T_LCOL     ENET.IEEE_T_LCOL.R            /* Frames Transmitted with Late Collision Statistic Register */
#define ENET_IEEE_T_EXCOL    ENET.IEEE_T_EXCOL.R           /* Frames Transmitted with Excessive Collisions Statistic Register */
#define ENET_IEEE_T_MACERR   ENET.IEEE_T_MACERR.R          /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
#define ENET_IEEE_T_CSERR    ENET.IEEE_T_CSERR.R           /* Frames Transmitted with Carrier Sense Error Statistic Register */
#define ENET_IEEE_T_SQE      ENET.IEEE_T_SQE.R             /* Reserved Statistic Register */
#define ENET_IEEE_T_FDXFC    ENET.IEEE_T_FDXFC.R           /* Flow Control Pause Frames Transmitted Statistic Register */
#define ENET_IEEE_T_OCTETS_OK ENET.IEEE_T_OCTETS_OK.R      /* Octet Count for Frames Transmitted w/o Error Statistic Register */
#define ENET_RMON_R_PACKETS  ENET.RMON_R_PACKETS.R         /* Rx Packet Count Statistic Register */
#define ENET_RMON_R_BC_PKT   ENET.RMON_R_BC_PKT.R          /* Rx Broadcast Packets Statistic Register */
#define ENET_RMON_R_MC_PKT   ENET.RMON_R_MC_PKT.R          /* Rx Multicast Packets Statistic Register */
#define ENET_RMON_R_CRC_ALIGN ENET.RMON_R_CRC_ALIGN.R      /* Rx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_R_UNDERSIZE ENET.RMON_R_UNDERSIZE.R      /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
#define ENET_RMON_R_OVERSIZE ENET.RMON_R_OVERSIZE.R        /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
#define ENET_RMON_R_FRAG     ENET.RMON_R_FRAG.R            /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_JAB      ENET.RMON_R_JAB.R             /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_RESVD_0  ENET.RMON_R_RESVD_0.R         /* Reserved Statistic Register */
#define ENET_RMON_R_P64      ENET.RMON_R_P64.R             /* Rx 64-Byte Packets Statistic Register */
#define ENET_RMON_R_P65TO127 ENET.RMON_R_P65TO127.R        /* Rx 65- to 127-Byte Packets Statistic Register */
#define ENET_RMON_R_P128TO255 ENET.RMON_R_P128TO255.R      /* Rx 128- to 255-Byte Packets Statistic Register */
#define ENET_RMON_R_P256TO511 ENET.RMON_R_P256TO511.R      /* Rx 256- to 511-Byte Packets Statistic Register */
#define ENET_RMON_R_P512TO1023 ENET.RMON_R_P512TO1023.R    /* Rx 512- to 1023-Byte Packets Statistic Register */
#define ENET_RMON_R_P1024TO2047 ENET.RMON_R_P1024TO2047.R  /* Rx 1024- to 2047-Byte Packets Statistic Register */
#define ENET_RMON_R_P_GTE2048 ENET.RMON_R_P_GTE2048.R      /* Rx Packets Greater than 2048 Bytes Statistic Register */
#define ENET_RMON_R_OCTETS   ENET.RMON_R_OCTETS.R          /* Rx Octets Statistic Register */
#define ENET_IEEE_R_DROP     ENET.IEEE_R_DROP.R            /* Frames not Counted Correctly Statistic Register */
#define ENET_IEEE_R_FRAME_OK ENET.IEEE_R_FRAME_OK.R        /* Frames Received OK Statistic Register */
#define ENET_IEEE_R_CRC      ENET.IEEE_R_CRC.R             /* Frames Received with CRC Error Statistic Register */
#define ENET_IEEE_R_ALIGN    ENET.IEEE_R_ALIGN.R           /* Frames Received with Alignment Error Statistic Register */
#define ENET_IEEE_R_MACERR   ENET.IEEE_R_MACERR.R          /* Receive FIFO Overflow Count Statistic Register */
#define ENET_IEEE_R_FDXFC    ENET.IEEE_R_FDXFC.R           /* Flow Control Pause Frames Received Statistic Register */
#define ENET_IEEE_R_OCTETS_OK ENET.IEEE_R_OCTETS_OK.R      /* Octet Count for Frames Received without Error Statistic Register */
#define ENET_ATCR            ENET.ATCR.R                   /* Adjustable Timer Control Register */
#define ENET_ATVR            ENET.ATVR.R                   /* Timer Value Register */
#define ENET_ATOFF           ENET.ATOFF.R                  /* Timer Offset Register */
#define ENET_ATPER           ENET.ATPER.R                  /* Timer Period Register */
#define ENET_ATCOR           ENET.ATCOR.R                  /* Timer Correction Register */
#define ENET_ATINC           ENET.ATINC.R                  /* Time-Stamping Clock Period Register */
#define ENET_ATSTMP          ENET.ATSTMP.R                 /* Timestamp of Last Transmitted Frame */
#define ENET_TGSR            ENET.TGSR.R                   /* Timer Global Status Register */
#define ENET_TCSR0           ENET.TIMER[0].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR0           ENET.TIMER[0].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR1           ENET.TIMER[1].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR1           ENET.TIMER[1].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR2           ENET.TIMER[2].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR2           ENET.TIMER[2].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR3           ENET.TIMER[3].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR3           ENET.TIMER[3].TCCR.R          /* Timer Compare Capture Register */

/* ERM */
#define ERM_CR0              ERM.CR0.R                     /* ERM Configuration Register */
#define ERM_CR1              ERM.CR1.R                     /* ERM Configuration Register */
#define ERM_SR0              ERM.SR0.R                     /* ERM Status Register */
#define ERM_SR1              ERM.SR1.R                     /* ERM Status Register */
#define ERM_EAR0             ERM.ERROR[0].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN0             ERM.ERROR[0].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR1             ERM.ERROR[1].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN1             ERM.ERROR[1].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR2             ERM.ERROR[2].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN2             ERM.ERROR[2].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR3             ERM.ERROR[3].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN3             ERM.ERROR[3].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR4             ERM.ERROR[4].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN4             ERM.ERROR[4].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR5             ERM.ERROR[5].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN5             ERM.ERROR[5].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR6             ERM.ERROR[6].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN6             ERM.ERROR[6].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR7             ERM.ERROR[7].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN7             ERM.ERROR[7].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR8             ERM.ERROR[8].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN8             ERM.ERROR[8].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR9             ERM.ERROR[9].EAR.R            /* ERM Memory n Error Address Register */
#define ERM_SYN9             ERM.ERROR[9].SYN.R            /* ERM Memory n Syndrome Register */
#define ERM_EAR10            ERM.ERROR[10].EAR.R           /* ERM Memory n Error Address Register */
#define ERM_SYN10            ERM.ERROR[10].SYN.R           /* ERM Memory n Syndrome Register */
#define ERM_EAR11            ERM.ERROR[11].EAR.R           /* ERM Memory n Error Address Register */
#define ERM_SYN11            ERM.ERROR[11].SYN.R           /* ERM Memory n Syndrome Register */
#define ERM_EAR12            ERM.ERROR[12].EAR.R           /* ERM Memory n Error Address Register */
#define ERM_SYN12            ERM.ERROR[12].SYN.R           /* ERM Memory n Syndrome Register */
#define ERM_EAR13            ERM.ERROR[13].EAR.R           /* ERM Memory n Error Address Register */
#define ERM_SYN13            ERM.ERROR[13].SYN.R           /* ERM Memory n Syndrome Register */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* Control Key */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* Noncritical Fault Configuration */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* Noncritical Fault Configuration */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* Noncritical Fault Configuration */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* Noncritical Fault State Configuration */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* Noncritical Fault State Configuration */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* Noncritical Fault Status */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* Noncritical Fault Status */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* Noncritical Fault Status */
#define FCCU_NCFK            FCCU.NCFK.R                   /* Noncritical Fault Key */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* Noncritical Fault Enable */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* Noncritical Fault Enable */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* Noncritical Fault Enable */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* Noncritical Fault Timeout Enable */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* Noncritical Fault Timeout */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* Configuration-State Timeout */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control */
#define FCCU_STAT            FCCU.STAT.R                   /* Status */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status */
#define FCCU_NCFF            FCCU.NCFF.R                   /* Noncritical Fault Fake */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR */
#define FCCU_MCS             FCCU.MCS.R                    /* Mode Controller Status */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* Fault-Output (EOUT) Signaling Enable */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* Fault-Output (EOUT) Signaling Enable */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* Fault-Output (EOUT) Signaling Enable */

/* FIRC */
#define FIRC_CTL             FIRC.CTL.R                    /* Control register */

/* FTM */
#define FTM_0_SC             FTM_0.SC.R                    /* Status And Control */
#define FTM_0_CNT            FTM_0.CNT.R                   /* Counter */
#define FTM_0_MOD            FTM_0.MOD.R                   /* Modulo */
#define FTM_0_C0SC           FTM_0.CONTROLS[0].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C0V            FTM_0.CONTROLS[0].CV.R        /* Channel (n) Value */
#define FTM_0_C1SC           FTM_0.CONTROLS[1].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C1V            FTM_0.CONTROLS[1].CV.R        /* Channel (n) Value */
#define FTM_0_C2SC           FTM_0.CONTROLS[2].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C2V            FTM_0.CONTROLS[2].CV.R        /* Channel (n) Value */
#define FTM_0_C3SC           FTM_0.CONTROLS[3].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C3V            FTM_0.CONTROLS[3].CV.R        /* Channel (n) Value */
#define FTM_0_C4SC           FTM_0.CONTROLS[4].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C4V            FTM_0.CONTROLS[4].CV.R        /* Channel (n) Value */
#define FTM_0_C5SC           FTM_0.CONTROLS[5].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C5V            FTM_0.CONTROLS[5].CV.R        /* Channel (n) Value */
#define FTM_0_C6SC           FTM_0.CONTROLS[6].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C6V            FTM_0.CONTROLS[6].CV.R        /* Channel (n) Value */
#define FTM_0_C7SC           FTM_0.CONTROLS[7].CSC.R       /* Channel (n) Status And Control */
#define FTM_0_C7V            FTM_0.CONTROLS[7].CV.R        /* Channel (n) Value */
#define FTM_0_CNTIN          FTM_0.CNTIN.R                 /* Counter Initial Value */
#define FTM_0_STATUS         FTM_0.STATUS.R                /* Capture And Compare Status */
#define FTM_0_MODE           FTM_0.MODE.R                  /* Features Mode Selection */
#define FTM_0_SYNC           FTM_0.SYNC.R                  /* Synchronization */
#define FTM_0_OUTINIT        FTM_0.OUTINIT.R               /* Initial State For Channels Output */
#define FTM_0_OUTMASK        FTM_0.OUTMASK.R               /* Output Mask */
#define FTM_0_COMBINE        FTM_0.COMBINE.R               /* Function For Linked Channels */
#define FTM_0_DEADTIME       FTM_0.DEADTIME.R              /* Deadtime Insertion Control */
#define FTM_0_EXTTRIG        FTM_0.EXTTRIG.R               /* FTM External Trigger */
#define FTM_0_POL            FTM_0.POL.R                   /* Channels Polarity */
#define FTM_0_FMS            FTM_0.FMS.R                   /* Fault Mode Status */
#define FTM_0_FILTER         FTM_0.FILTER.R                /* Input Capture Filter Control */
#define FTM_0_QDCTRL         FTM_0.QDCTRL.R                /* Quadrature Decoder Control And Status */
#define FTM_0_CONF           FTM_0.CONF.R                  /* Configuration */
#define FTM_0_SYNCONF        FTM_0.SYNCONF.R               /* Synchronization Configuration */
#define FTM_0_INVCTRL        FTM_0.INVCTRL.R               /* FTM Inverting Control */
#define FTM_0_SWOCTRL        FTM_0.SWOCTRL.R               /* FTM Software Output Control */
#define FTM_0_PWMLOAD        FTM_0.PWMLOAD.R               /* FTM PWM Load */

#define FTM_1_SC             FTM_1.SC.R                    /* Status And Control */
#define FTM_1_CNT            FTM_1.CNT.R                   /* Counter */
#define FTM_1_MOD            FTM_1.MOD.R                   /* Modulo */
#define FTM_1_C0SC           FTM_1.CONTROLS[0].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C0V            FTM_1.CONTROLS[0].CV.R        /* Channel (n) Value */
#define FTM_1_C1SC           FTM_1.CONTROLS[1].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C1V            FTM_1.CONTROLS[1].CV.R        /* Channel (n) Value */
#define FTM_1_C2SC           FTM_1.CONTROLS[2].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C2V            FTM_1.CONTROLS[2].CV.R        /* Channel (n) Value */
#define FTM_1_C3SC           FTM_1.CONTROLS[3].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C3V            FTM_1.CONTROLS[3].CV.R        /* Channel (n) Value */
#define FTM_1_C4SC           FTM_1.CONTROLS[4].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C4V            FTM_1.CONTROLS[4].CV.R        /* Channel (n) Value */
#define FTM_1_C5SC           FTM_1.CONTROLS[5].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C5V            FTM_1.CONTROLS[5].CV.R        /* Channel (n) Value */
#define FTM_1_C6SC           FTM_1.CONTROLS[6].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C6V            FTM_1.CONTROLS[6].CV.R        /* Channel (n) Value */
#define FTM_1_C7SC           FTM_1.CONTROLS[7].CSC.R       /* Channel (n) Status And Control */
#define FTM_1_C7V            FTM_1.CONTROLS[7].CV.R        /* Channel (n) Value */
#define FTM_1_CNTIN          FTM_1.CNTIN.R                 /* Counter Initial Value */
#define FTM_1_STATUS         FTM_1.STATUS.R                /* Capture And Compare Status */
#define FTM_1_MODE           FTM_1.MODE.R                  /* Features Mode Selection */
#define FTM_1_SYNC           FTM_1.SYNC.R                  /* Synchronization */
#define FTM_1_OUTINIT        FTM_1.OUTINIT.R               /* Initial State For Channels Output */
#define FTM_1_OUTMASK        FTM_1.OUTMASK.R               /* Output Mask */
#define FTM_1_COMBINE        FTM_1.COMBINE.R               /* Function For Linked Channels */
#define FTM_1_DEADTIME       FTM_1.DEADTIME.R              /* Deadtime Insertion Control */
#define FTM_1_EXTTRIG        FTM_1.EXTTRIG.R               /* FTM External Trigger */
#define FTM_1_POL            FTM_1.POL.R                   /* Channels Polarity */
#define FTM_1_FMS            FTM_1.FMS.R                   /* Fault Mode Status */
#define FTM_1_FILTER         FTM_1.FILTER.R                /* Input Capture Filter Control */
#define FTM_1_QDCTRL         FTM_1.QDCTRL.R                /* Quadrature Decoder Control And Status */
#define FTM_1_CONF           FTM_1.CONF.R                  /* Configuration */
#define FTM_1_SYNCONF        FTM_1.SYNCONF.R               /* Synchronization Configuration */
#define FTM_1_INVCTRL        FTM_1.INVCTRL.R               /* FTM Inverting Control */
#define FTM_1_SWOCTRL        FTM_1.SWOCTRL.R               /* FTM Software Output Control */
#define FTM_1_PWMLOAD        FTM_1.PWMLOAD.R               /* FTM PWM Load */

#define FTM_2_SC             FTM_2.SC.R                    /* Status And Control */
#define FTM_2_CNT            FTM_2.CNT.R                   /* Counter */
#define FTM_2_MOD            FTM_2.MOD.R                   /* Modulo */
#define FTM_2_C0SC           FTM_2.CONTROLS[0].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C0V            FTM_2.CONTROLS[0].CV.R        /* Channel (n) Value */
#define FTM_2_C1SC           FTM_2.CONTROLS[1].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C1V            FTM_2.CONTROLS[1].CV.R        /* Channel (n) Value */
#define FTM_2_C2SC           FTM_2.CONTROLS[2].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C2V            FTM_2.CONTROLS[2].CV.R        /* Channel (n) Value */
#define FTM_2_C3SC           FTM_2.CONTROLS[3].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C3V            FTM_2.CONTROLS[3].CV.R        /* Channel (n) Value */
#define FTM_2_C4SC           FTM_2.CONTROLS[4].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C4V            FTM_2.CONTROLS[4].CV.R        /* Channel (n) Value */
#define FTM_2_C5SC           FTM_2.CONTROLS[5].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C5V            FTM_2.CONTROLS[5].CV.R        /* Channel (n) Value */
#define FTM_2_C6SC           FTM_2.CONTROLS[6].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C6V            FTM_2.CONTROLS[6].CV.R        /* Channel (n) Value */
#define FTM_2_C7SC           FTM_2.CONTROLS[7].CSC.R       /* Channel (n) Status And Control */
#define FTM_2_C7V            FTM_2.CONTROLS[7].CV.R        /* Channel (n) Value */
#define FTM_2_CNTIN          FTM_2.CNTIN.R                 /* Counter Initial Value */
#define FTM_2_STATUS         FTM_2.STATUS.R                /* Capture And Compare Status */
#define FTM_2_MODE           FTM_2.MODE.R                  /* Features Mode Selection */
#define FTM_2_SYNC           FTM_2.SYNC.R                  /* Synchronization */
#define FTM_2_OUTINIT        FTM_2.OUTINIT.R               /* Initial State For Channels Output */
#define FTM_2_OUTMASK        FTM_2.OUTMASK.R               /* Output Mask */
#define FTM_2_COMBINE        FTM_2.COMBINE.R               /* Function For Linked Channels */
#define FTM_2_DEADTIME       FTM_2.DEADTIME.R              /* Deadtime Insertion Control */
#define FTM_2_EXTTRIG        FTM_2.EXTTRIG.R               /* FTM External Trigger */
#define FTM_2_POL            FTM_2.POL.R                   /* Channels Polarity */
#define FTM_2_FMS            FTM_2.FMS.R                   /* Fault Mode Status */
#define FTM_2_FILTER         FTM_2.FILTER.R                /* Input Capture Filter Control */
#define FTM_2_QDCTRL         FTM_2.QDCTRL.R                /* Quadrature Decoder Control And Status */
#define FTM_2_CONF           FTM_2.CONF.R                  /* Configuration */
#define FTM_2_SYNCONF        FTM_2.SYNCONF.R               /* Synchronization Configuration */
#define FTM_2_INVCTRL        FTM_2.INVCTRL.R               /* FTM Inverting Control */
#define FTM_2_SWOCTRL        FTM_2.SWOCTRL.R               /* FTM Software Output Control */
#define FTM_2_PWMLOAD        FTM_2.PWMLOAD.R               /* FTM PWM Load */

#define FTM_3_SC             FTM_3.SC.R                    /* Status And Control */
#define FTM_3_CNT            FTM_3.CNT.R                   /* Counter */
#define FTM_3_MOD            FTM_3.MOD.R                   /* Modulo */
#define FTM_3_C0SC           FTM_3.CONTROLS[0].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C0V            FTM_3.CONTROLS[0].CV.R        /* Channel (n) Value */
#define FTM_3_C1SC           FTM_3.CONTROLS[1].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C1V            FTM_3.CONTROLS[1].CV.R        /* Channel (n) Value */
#define FTM_3_C2SC           FTM_3.CONTROLS[2].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C2V            FTM_3.CONTROLS[2].CV.R        /* Channel (n) Value */
#define FTM_3_C3SC           FTM_3.CONTROLS[3].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C3V            FTM_3.CONTROLS[3].CV.R        /* Channel (n) Value */
#define FTM_3_C4SC           FTM_3.CONTROLS[4].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C4V            FTM_3.CONTROLS[4].CV.R        /* Channel (n) Value */
#define FTM_3_C5SC           FTM_3.CONTROLS[5].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C5V            FTM_3.CONTROLS[5].CV.R        /* Channel (n) Value */
#define FTM_3_C6SC           FTM_3.CONTROLS[6].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C6V            FTM_3.CONTROLS[6].CV.R        /* Channel (n) Value */
#define FTM_3_C7SC           FTM_3.CONTROLS[7].CSC.R       /* Channel (n) Status And Control */
#define FTM_3_C7V            FTM_3.CONTROLS[7].CV.R        /* Channel (n) Value */
#define FTM_3_CNTIN          FTM_3.CNTIN.R                 /* Counter Initial Value */
#define FTM_3_STATUS         FTM_3.STATUS.R                /* Capture And Compare Status */
#define FTM_3_MODE           FTM_3.MODE.R                  /* Features Mode Selection */
#define FTM_3_SYNC           FTM_3.SYNC.R                  /* Synchronization */
#define FTM_3_OUTINIT        FTM_3.OUTINIT.R               /* Initial State For Channels Output */
#define FTM_3_OUTMASK        FTM_3.OUTMASK.R               /* Output Mask */
#define FTM_3_COMBINE        FTM_3.COMBINE.R               /* Function For Linked Channels */
#define FTM_3_DEADTIME       FTM_3.DEADTIME.R              /* Deadtime Insertion Control */
#define FTM_3_EXTTRIG        FTM_3.EXTTRIG.R               /* FTM External Trigger */
#define FTM_3_POL            FTM_3.POL.R                   /* Channels Polarity */
#define FTM_3_FMS            FTM_3.FMS.R                   /* Fault Mode Status */
#define FTM_3_FILTER         FTM_3.FILTER.R                /* Input Capture Filter Control */
#define FTM_3_QDCTRL         FTM_3.QDCTRL.R                /* Quadrature Decoder Control And Status */
#define FTM_3_CONF           FTM_3.CONF.R                  /* Configuration */
#define FTM_3_SYNCONF        FTM_3.SYNCONF.R               /* Synchronization Configuration */
#define FTM_3_INVCTRL        FTM_3.INVCTRL.R               /* FTM Inverting Control */
#define FTM_3_SWOCTRL        FTM_3.SWOCTRL.R               /* FTM Software Output Control */
#define FTM_3_PWMLOAD        FTM_3.PWMLOAD.R               /* FTM PWM Load */

/* FXOSC */
#define FXOSC_CTL            FXOSC.CTL.R                   /* FXOSC Control Register */

/* GC355 */
#define GC355_HICLKCTL       GC355.HICLKCTL.R              /* Clock control register */
#define GC355_HIIDLE         GC355.HIIDLE.R                /* Idle status register */
#define GC355_AXI_CONFIG     GC355.AXI_CONFIG.R            /* AXI configuration register */
#define GC355_AXISTATUS      GC355.AXISTATUS.R             /* AXI status register */
#define GC355_INT_ACK        GC355.INT_ACK.R               /* Interrupt acknowledge register */
#define GC355_INT_EN         GC355.INT_EN.R                /* Interrupt enable register */
#define GC355_CHIPID         GC355.CHIPID.R                /* Chip ID register */
#define GC355_CHIPREV        GC355.CHIPREV.R               /* Chip revision register */
#define GC355_CHIPDATE       GC355.CHIPDATE.R              /* Chip date register */
#define GC355_CHIPTIME       GC355.CHIPTIME.R              /* Chip time register */
#define GC355_T_CYC          GC355.T_CYC.R                 /* Total cycles register */
#define GC355_MOD_PWR_CTL    GC355.MOD_PWR_CTL.R           /* Module power control register */
#define GC355_MEM_DEBUG      GC355.MEM_DEBUG.R             /* Memory debug register */
#define GC355_REG_FET_ADD    GC355.REG_FET_ADD.R           /* Fetch address register */
#define GC355_REG_FET_CTL    GC355.REG_FET_CTL.R           /* Fetch control register */

/* I2C */
#define I2C_0_IBSR           I2C_0.IBSR.R                  /* I2C Bus Status Register */
#define I2C_0_IBCR           I2C_0.IBCR.R                  /* I2C Bus Control Register */
#define I2C_0_IBFD           I2C_0.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_0_IBAD           I2C_0.IBAD.R                  /* I2C Bus Address Register */
#define I2C_0_IBDBG          I2C_0.IBDBG.R                 /* I2C Bus Debug Register */
#define I2C_0_IBIC           I2C_0.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_0_IBDR           I2C_0.IBDR.R                  /* I2C Bus Data I/O Register */

#define I2C_1_IBSR           I2C_1.IBSR.R                  /* I2C Bus Status Register */
#define I2C_1_IBCR           I2C_1.IBCR.R                  /* I2C Bus Control Register */
#define I2C_1_IBFD           I2C_1.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_1_IBAD           I2C_1.IBAD.R                  /* I2C Bus Address Register */
#define I2C_1_IBDBG          I2C_1.IBDBG.R                 /* I2C Bus Debug Register */
#define I2C_1_IBIC           I2C_1.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_1_IBDR           I2C_1.IBDR.R                  /* I2C Bus Data I/O Register */

/* IOP */
#define IOP_MCTL             IOP.MCTL.R                    /* IOP Mode Control Register */
#define IOP_RUN_CF           IOP.RUN_CF.R                  /* IOP Run Configuration Register */
#define IOP_STOP_CF          IOP.STOP_CF.R                 /* IOP Stop Configuration Register */
#define IOP_STANDBY_CF       IOP.STANDBY_CF.R              /* IOP Standby Configuration Register */
#define IOP_SR               IOP.SR.R                      /* IOP Status Register */
#define IOP_ICR              IOP.ICR.R                     /* IOP Interrupt control register */
#define IOP_MOD_MDIS         IOP.MOD_MDIS.R                /* Module Disable Register */

/* JDC */
#define JDC_MCR              JDC.MCR.R                     /* Module Configuration Register */
#define JDC_MSR              JDC.MSR.R                     /* Module Status Register */
#define JDC_JOUT_IPS         JDC.JOUT_IPS.R                /* JTAG Output Data Register */
#define JDC_JIN_IPS          JDC.JIN_IPS.R                 /* JTAG Input Data Register */

/* LCD */
#define LCD_LCDCR            LCD.LCDCR.R                   /* LCD Control Register */
#define LCD_LCDPCR           LCD.LCDPCR.R                  /* LCD Prescaler Control Register */
#define LCD_LCDCCR           LCD.LCDCCR.R                  /* LCD Contrast Control Register */
#define LCD_ENFPR0           LCD.ENFPR0.R                  /* LCD Frontplane Enable Register 0 */
#define LCD_ENFPR1           LCD.ENFPR1.R                  /* LCD Frontplane Enable Register 1 */
#define LCD_LCDRAM0          LCD.LCDRAM0.R                 /* LCDRAM (Location 0) */
#define LCD_LCDRAM1          LCD.LCDRAM1.R                 /* LCDRAM Location 1 */
#define LCD_LCDRAM2          LCD.LCDRAM2.R                 /* LCDRAM Location 2 */
#define LCD_LCDRAM3          LCD.LCDRAM3.R                 /* LCDRAM Location 3 */
#define LCD_LCDRAM4          LCD.LCDRAM4.R                 /* LCDRAM Location 4 */
#define LCD_LCDRAM5          LCD.LCDRAM5.R                 /* LCDRAM Location 5 */
#define LCD_LCDRAM6          LCD.LCDRAM6.R                 /* LCDRAM Location 6 */
#define LCD_LCDRAM7          LCD.LCDRAM7.R                 /* LCDRAM Location 7 */
#define LCD_LCDRAM8          LCD.LCDRAM8.R                 /* LCDRAM Location 8 */
#define LCD_LCDRAM9          LCD.LCDRAM9.R                 /* LCDRAM Location 9 */

/* LDB */
#define LDB_CTRL             LDB.CTRL.R                    /* LDB Control Register */

/* LINFlexD */
#define LINFlexD_0_LINCR1    LINFlexD_0.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_0_LINIER    LINFlexD_0.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_0_LINSR     LINFlexD_0.LINSR.R            /* LIN Status Register */
#define LINFlexD_0_LINESR    LINFlexD_0.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_0_UARTCR    LINFlexD_0.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_0_UARTSR    LINFlexD_0.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_0_LINTCSR   LINFlexD_0.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_0_LINOCR    LINFlexD_0.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_0_LINTOCR   LINFlexD_0.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_0_LINFBRR   LINFlexD_0.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_0_LINIBRR   LINFlexD_0.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_0_LINCFR    LINFlexD_0.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_0_LINCR2    LINFlexD_0.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_0_BIDR      LINFlexD_0.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_0_BDRL      LINFlexD_0.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_0_BDRM      LINFlexD_0.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_0_IFER      LINFlexD_0.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_0_IFMI      LINFlexD_0.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_0_IFMR      LINFlexD_0.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_0_IFCR0     LINFlexD_0.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR1     LINFlexD_0.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR2     LINFlexD_0.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR3     LINFlexD_0.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR4     LINFlexD_0.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR5     LINFlexD_0.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR6     LINFlexD_0.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR7     LINFlexD_0.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR8     LINFlexD_0.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR9     LINFlexD_0.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR10    LINFlexD_0.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR11    LINFlexD_0.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR12    LINFlexD_0.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR13    LINFlexD_0.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR14    LINFlexD_0.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR15    LINFlexD_0.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_0_GCR       LINFlexD_0.GCR.R              /* Global Control Register */
#define LINFlexD_0_UARTPTO   LINFlexD_0.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_0_UARTCTO   LINFlexD_0.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_0_DMATXE    LINFlexD_0.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_0_DMARXE    LINFlexD_0.DMARXE.R           /* DMA Rx Enable Register */

#define LINFlexD_1_LINCR1    LINFlexD_1.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_1_LINIER    LINFlexD_1.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_1_LINSR     LINFlexD_1.LINSR.R            /* LIN Status Register */
#define LINFlexD_1_LINESR    LINFlexD_1.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_1_UARTCR    LINFlexD_1.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_1_UARTSR    LINFlexD_1.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_1_LINTCSR   LINFlexD_1.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_1_LINOCR    LINFlexD_1.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_1_LINTOCR   LINFlexD_1.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_1_LINFBRR   LINFlexD_1.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_1_LINIBRR   LINFlexD_1.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_1_LINCFR    LINFlexD_1.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_1_LINCR2    LINFlexD_1.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_1_BIDR      LINFlexD_1.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_1_BDRL      LINFlexD_1.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_1_BDRM      LINFlexD_1.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_1_IFER      LINFlexD_1.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_1_IFMI      LINFlexD_1.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_1_IFMR      LINFlexD_1.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_1_IFCR0     LINFlexD_1.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR1     LINFlexD_1.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR2     LINFlexD_1.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR3     LINFlexD_1.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR4     LINFlexD_1.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR5     LINFlexD_1.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR6     LINFlexD_1.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR7     LINFlexD_1.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR8     LINFlexD_1.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR9     LINFlexD_1.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR10    LINFlexD_1.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR11    LINFlexD_1.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR12    LINFlexD_1.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR13    LINFlexD_1.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR14    LINFlexD_1.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR15    LINFlexD_1.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_1_GCR       LINFlexD_1.GCR.R              /* Global Control Register */
#define LINFlexD_1_UARTPTO   LINFlexD_1.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_1_UARTCTO   LINFlexD_1.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_1_DMATXE    LINFlexD_1.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_1_DMARXE    LINFlexD_1.DMARXE.R           /* DMA Rx Enable Register */

#define LINFlexD_2_LINCR1    LINFlexD_2.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_2_LINIER    LINFlexD_2.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_2_LINSR     LINFlexD_2.LINSR.R            /* LIN Status Register */
#define LINFlexD_2_LINESR    LINFlexD_2.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_2_UARTCR    LINFlexD_2.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_2_UARTSR    LINFlexD_2.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_2_LINTCSR   LINFlexD_2.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_2_LINOCR    LINFlexD_2.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_2_LINTOCR   LINFlexD_2.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_2_LINFBRR   LINFlexD_2.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_2_LINIBRR   LINFlexD_2.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_2_LINCFR    LINFlexD_2.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_2_LINCR2    LINFlexD_2.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_2_BIDR      LINFlexD_2.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_2_BDRL      LINFlexD_2.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_2_BDRM      LINFlexD_2.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_2_IFER      LINFlexD_2.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_2_IFMI      LINFlexD_2.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_2_IFMR      LINFlexD_2.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_2_IFCR0     LINFlexD_2.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR1     LINFlexD_2.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR2     LINFlexD_2.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR3     LINFlexD_2.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR4     LINFlexD_2.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR5     LINFlexD_2.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR6     LINFlexD_2.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR7     LINFlexD_2.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR8     LINFlexD_2.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR9     LINFlexD_2.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR10    LINFlexD_2.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR11    LINFlexD_2.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR12    LINFlexD_2.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR13    LINFlexD_2.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR14    LINFlexD_2.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR15    LINFlexD_2.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_2_GCR       LINFlexD_2.GCR.R              /* Global Control Register */
#define LINFlexD_2_UARTPTO   LINFlexD_2.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_2_UARTCTO   LINFlexD_2.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_2_DMATXE    LINFlexD_2.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_2_DMARXE    LINFlexD_2.DMARXE.R           /* DMA Rx Enable Register */

/* LMEM */
#define LMEM_PCCCR           LMEM.PCCCR.R                  /* Cache control register */
#define LMEM_PCCLCR          LMEM.PCCLCR.R                 /* Cache line control register */
#define LMEM_PCCSAR          LMEM.PCCSAR.R                 /* Cache search address register */
#define LMEM_PCCCVR          LMEM.PCCCVR.R                 /* Cache read/write value register */
#define LMEM_PSCCR           LMEM.PSCCR.R                  /* Cache control register */
#define LMEM_PSCLCR          LMEM.PSCLCR.R                 /* Cache line control register */
#define LMEM_PSCSAR          LMEM.PSCSAR.R                 /* Cache search address register */
#define LMEM_PSCCVR          LMEM.PSCCVR.R                 /* Cache read/write value register */

/* MCM */
#define MCM_PLAMC            MCM.PLAMC.R                   /* Crossbar Switch (AXBS) Master Configuration */
#define MCM_PLASC            MCM.PLASC.R                   /* Crossbar Switch (AXBS) Slave Configuration */
#define MCM_CR               MCM.CR.R                      /* Control Register */
#define MCM_ISCR             MCM.ISCR.R                    /* Interrupt Status and Control Register */
#define MCM_FADR             MCM.FADR.R                    /* Fault address register */
#define MCM_FATR             MCM.FATR.R                    /* Fault attributes register */
#define MCM_FDR              MCM.FDR.R                     /* Fault data register */

/* MC_CGM */
#define MC_CGM_SC_DC6        MC_CGM.SC_DC6.R               /* System Clock Divider 6 Configuration Register */
#define MC_CGM_PCS_SDUR      MC_CGM.PCS_SDUR.R             /* PCS Switch Duration Register */
#define MC_CGM_PCS_DIVC1     MC_CGM.PCS_DIVC1.R            /* PCS Divider Change Register 1 */
#define MC_CGM_PCS_DIVE1     MC_CGM.PCS_DIVE1.R            /* PCS Divider End Register 1 */
#define MC_CGM_PCS_DIVS1     MC_CGM.PCS_DIVS1.R            /* PCS Divider Start Register 1 */
#define MC_CGM_PCS_DIVC4     MC_CGM.PCS_DIVC4.R            /* PCS Divider Change Register 4 */
#define MC_CGM_PCS_DIVE4     MC_CGM.PCS_DIVE4.R            /* PCS Divider End Register 4 */
#define MC_CGM_PCS_DIVS4     MC_CGM.PCS_DIVS4.R            /* PCS Divider Start Register 4 */
#define MC_CGM_PCS_DIVC5     MC_CGM.PCS_DIVC5.R            /* PCS Divider Change Register 5 */
#define MC_CGM_PCS_DIVE5     MC_CGM.PCS_DIVE5.R            /* PCS Divider End Register 5 */
#define MC_CGM_PCS_DIVS5     MC_CGM.PCS_DIVS5.R            /* PCS Divider Start Register 5 */
#define MC_CGM_SC_DIV_RC     MC_CGM.SC_DIV_RC.R            /* System Clock Divider Ratio Change Register */
#define MC_CGM_DIV_UPD_TYPE  MC_CGM.DIV_UPD_TYPE.R         /* Divider Update Type */
#define MC_CGM_DIV_UPD_TRIG  MC_CGM.DIV_UPD_TRIG.R         /* Divider Update Trigger */
#define MC_CGM_DIV_UPD_STAT  MC_CGM.DIV_UPD_STAT.R         /* Divider Update Status */
#define MC_CGM_SC_SS         MC_CGM.SC_SS.R                /* System Clock Select Status Register */
#define MC_CGM_SC_DC0        MC_CGM.SC_DC0.R               /* System Clock Divider 0 Configuration Register */
#define MC_CGM_SC_DC1        MC_CGM.SC_DC1.R               /* System Clock Divider 1 Configuration Register */
#define MC_CGM_SC_DC2        MC_CGM.SC_DC2.R               /* System Clock Divider 2 Configuration Register */
#define MC_CGM_SC_DC3        MC_CGM.SC_DC3.R               /* System Clock Divider 3 Configuration Register */
#define MC_CGM_SC_DC4        MC_CGM.SC_DC4.R               /* System Clock Divider 4 Configuration Register */
#define MC_CGM_SC_DC5        MC_CGM.SC_DC5.R               /* System Clock Divider 5 Configuration Register */
#define MC_CGM_AC0_SC        MC_CGM.AC0_SC.R               /* Auxiliary Clock 0 Select Control Register */
#define MC_CGM_AC0_SS        MC_CGM.AC0_SS.R               /* Auxiliary Clock 0 Select Status Register */
#define MC_CGM_AC1_SC        MC_CGM.AC1_SC.R               /* Auxiliary Clock 1 Select Control Register */
#define MC_CGM_AC1_SS        MC_CGM.AC1_SS.R               /* Auxiliary Clock 1 Select Status Register */
#define MC_CGM_AC1_DC0       MC_CGM.AC1_DC0.R              /* Auxiliary Clock 1 Divider 0 Configuration Register */
#define MC_CGM_AC2_SC        MC_CGM.AC2_SC.R               /* Auxiliary Clock 2 Select Control Register */
#define MC_CGM_AC2_SS        MC_CGM.AC2_SS.R               /* Auxiliary Clock 2 Select Status Register */
#define MC_CGM_AC2_DC0       MC_CGM.AC2_DC0.R              /* Auxiliary Clock 2 Divider 0 Configuration Register */
#define MC_CGM_AC2_DC1       MC_CGM.AC2_DC1.R              /* Auxiliary Clock 2 Divider 1 Configuration Register */
#define MC_CGM_AC3_SC        MC_CGM.AC3_SC.R               /* Auxiliary Clock 3 Select Control Register */
#define MC_CGM_AC3_SS        MC_CGM.AC3_SS.R               /* Auxiliary Clock 3 Select Status Register */
#define MC_CGM_AC3_DC0       MC_CGM.AC3_DC0.R              /* Auxiliary Clock 3 Divider 0 Configuration Register */
#define MC_CGM_AC4_SC        MC_CGM.AC4_SC.R               /* Auxiliary Clock 4 Select Control Register */
#define MC_CGM_AC4_SS        MC_CGM.AC4_SS.R               /* Auxiliary Clock 4 Select Status Register */
#define MC_CGM_AC4_DC0       MC_CGM.AC4_DC0.R              /* Auxiliary Clock 4 Divider 0 Configuration Register */
#define MC_CGM_AC5_SC        MC_CGM.AC5_SC.R               /* Auxiliary Clock 5 Select Control Register */
#define MC_CGM_AC5_SS        MC_CGM.AC5_SS.R               /* Auxiliary Clock 5 Select Status Register */
#define MC_CGM_AC5_DC0       MC_CGM.AC5_DC0.R              /* Auxiliary Clock 5 Divider 0 Configuration Register */
#define MC_CGM_AC5_DC1       MC_CGM.AC5_DC1.R              /* Auxiliary Clock 5 Divider 1 Configuration Register */
#define MC_CGM_AC6_SC        MC_CGM.AC6_SC.R               /* Auxiliary Clock 6 Select Control Register */
#define MC_CGM_AC6_SS        MC_CGM.AC6_SS.R               /* Auxiliary Clock 6 Select Status Register */
#define MC_CGM_AC6_DC0       MC_CGM.AC6_DC0.R              /* Auxiliary Clock 6 Divider 0 Configuration Register */
#define MC_CGM_AC6_DC1       MC_CGM.AC6_DC1.R              /* Auxiliary Clock 6 Divider 1 Configuration Register */
#define MC_CGM_AC7_SC        MC_CGM.AC7_SC.R               /* Auxiliary Clock 7 Select Control Register */
#define MC_CGM_AC7_SS        MC_CGM.AC7_SS.R               /* Auxiliary Clock 7 Select Status Register */
#define MC_CGM_AC7_DC0       MC_CGM.AC7_DC0.R              /* Auxiliary Clock 7 Divider 0 Configuration Register */
#define MC_CGM_AC7_DC1       MC_CGM.AC7_DC1.R              /* Auxiliary Clock 7 Divider 1 Configuration Register */
#define MC_CGM_AC8_SC        MC_CGM.AC8_SC.R               /* Auxiliary Clock 8 Select Control Register */
#define MC_CGM_AC8_SS        MC_CGM.AC8_SS.R               /* Auxiliary Clock 8 Select Status Register */
#define MC_CGM_AC8_DC0       MC_CGM.AC8_DC0.R              /* Auxiliary Clock 8 Divider 0 Configuration Register */
#define MC_CGM_AC9_SC        MC_CGM.AC9_SC.R               /* Auxiliary Clock 9 Select Control Register */
#define MC_CGM_AC9_SS        MC_CGM.AC9_SS.R               /* Auxiliary Clock 9 Select Status Register */
#define MC_CGM_AC9_DC0       MC_CGM.AC9_DC0.R              /* Auxiliary Clock 9 Divider 0 Configuration Register */
#define MC_CGM_AC10_SC       MC_CGM.AC10_SC.R              /* Auxiliary Clock 10 Select Control Register */
#define MC_CGM_AC10_SS       MC_CGM.AC10_SS.R              /* Auxiliary Clock 10 Select Status Register */
#define MC_CGM_AC10_DC0      MC_CGM.AC10_DC0.R             /* Auxiliary Clock 10 Divider 0 Configuration Register */
#define MC_CGM_AC11_SC       MC_CGM.AC11_SC.R              /* Auxiliary Clock 11 Select Control Register */
#define MC_CGM_AC11_SS       MC_CGM.AC11_SS.R              /* Auxiliary Clock 11 Select Status Register */
#define MC_CGM_AC11_DC0      MC_CGM.AC11_DC0.R             /* Auxiliary Clock 11 Divider 0 Configuration Register */
#define MC_CGM_AC12_SC       MC_CGM.AC12_SC.R              /* Auxiliary Clock 12 Select Control Register */
#define MC_CGM_AC12_SS       MC_CGM.AC12_SS.R              /* Auxiliary Clock 12 Select Status Register */
#define MC_CGM_AC12_DC0      MC_CGM.AC12_DC0.R             /* Auxiliary Clock 12 Divider 0 Configuration Register */
#define MC_CGM_AC13_SC       MC_CGM.AC13_SC.R              /* Auxiliary Clock 13 Select Control Register */
#define MC_CGM_AC13_SS       MC_CGM.AC13_SS.R              /* Auxiliary Clock 13 Select Status Register */
#define MC_CGM_AC13_DC0      MC_CGM.AC13_DC0.R             /* Auxiliary Clock 13 Divider 0 Configuration Register */
#define MC_CGM_AC14_SC       MC_CGM.AC14_SC.R              /* Auxiliary Clock 14 Select Control Register */
#define MC_CGM_AC14_SS       MC_CGM.AC14_SS.R              /* Auxiliary Clock 14 Select Status Register */
#define MC_CGM_AC14_DC0      MC_CGM.AC14_DC0.R             /* Auxiliary Clock 14 Divider 0 Configuration Register */
#define MC_CGM_AC15_SC       MC_CGM.AC15_SC.R              /* Auxiliary Clock 15 Select Control Register */
#define MC_CGM_AC15_SS       MC_CGM.AC15_SS.R              /* Auxiliary Clock 14 Select Status Register */
#define MC_CGM_AC15_DC0      MC_CGM.AC15_DC.DC0.R          /* Auxiliary Clock 15 Divider 0 Configuration Register */
#define MC_CGM_AC15_DC1      MC_CGM.AC15_DC.DC1.R          /* Auxiliary Clock 15 Divider 1 Configuration Register */

/* MC_ME */
#define MC_ME_GS             MC_ME.GS.R                    /* Global Status Register */
#define MC_ME_MCTL           MC_ME.MCTL.R                  /* Mode Control Register */
#define MC_ME_ME             MC_ME.ME.R                    /* Mode Enable Register */
#define MC_ME_IS             MC_ME.IS.R                    /* Interrupt Status Register */
#define MC_ME_IM             MC_ME.IM.R                    /* Interrupt Mask Register */
#define MC_ME_IMTS           MC_ME.IMTS.R                  /* Invalid Mode Transition Status Register */
#define MC_ME_DMTS           MC_ME.DMTS.R                  /* Debug Mode Transition Status Register */
#define MC_ME_RESET_MC       MC_ME.RESET_MC.R              /* RESET Mode Configuration Register */
#define MC_ME_SAFE_MC        MC_ME.SAFE_MC.R               /* SAFE Mode Configuration Register */
#define MC_ME_DRUN_MC        MC_ME.DRUN_MC.R               /* DRUN Mode Configuration Register */
#define MC_ME_RUN_MC0        MC_ME.RUN_MC[0].R             /* RUN Mode Configuration Register */
#define MC_ME_RUN_MC1        MC_ME.RUN_MC[1].R             /* RUN Mode Configuration Register */
#define MC_ME_RUN_MC2        MC_ME.RUN_MC[2].R             /* RUN Mode Configuration Register */
#define MC_ME_RUN_MC3        MC_ME.RUN_MC[3].R             /* RUN Mode Configuration Register */
#define MC_ME_STOP0_MC       MC_ME.STOP0_MC.R              /* STOP0 Mode Configuration Register */
#define MC_ME_STANDBY0_MC    MC_ME.STANDBY0_MC.R           /* STANDBY0 Mode Configuration */
#define MC_ME_PS0            MC_ME.PS0.R                   /* Peripheral Status Register 0 */
#define MC_ME_PS1            MC_ME.PS1.R                   /* Peripheral Status Register 1 */
#define MC_ME_PS2            MC_ME.PS2.R                   /* Peripheral Status Register 2 */
#define MC_ME_PS4            MC_ME.PS4.R                   /* Peripheral Status Register 4 */
#define MC_ME_PS5            MC_ME.PS5.R                   /* Peripheral Status Register 5 */
#define MC_ME_PS6            MC_ME.PS6.R                   /* Peripheral Status Register 6 */
#define MC_ME_RUN_PC0        MC_ME.RUN_PC[0].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC1        MC_ME.RUN_PC[1].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC2        MC_ME.RUN_PC[2].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC3        MC_ME.RUN_PC[3].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC4        MC_ME.RUN_PC[4].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC5        MC_ME.RUN_PC[5].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC6        MC_ME.RUN_PC[6].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC7        MC_ME.RUN_PC[7].R             /* Run Peripheral Configuration Register */
#define MC_ME_LP_PC0         MC_ME.LP_PC[0].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC1         MC_ME.LP_PC[1].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC2         MC_ME.LP_PC[2].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC3         MC_ME.LP_PC[3].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC4         MC_ME.LP_PC[4].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC5         MC_ME.LP_PC[5].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC6         MC_ME.LP_PC[6].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC7         MC_ME.LP_PC[7].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_PCTL3          MC_ME.PCTL3.R                 /* I2C_1 Peripheral Control Register */
#define MC_ME_PCTL2          MC_ME.PCTL2.R                 /* I2C_0 Peripheral Control Register */
#define MC_ME_PCTL1          MC_ME.PCTL1.R                 /* DMA_CH_MUX_0 Peripheral Control Register */
#define MC_ME_PCTL7          MC_ME.PCTL7.R                 /* FLEXTIMER_3 Peripheral Control Register */
#define MC_ME_PCTL6          MC_ME.PCTL6.R                 /* FLEXTIMER_2 Peripheral Control Register */
#define MC_ME_PCTL5          MC_ME.PCTL5.R                 /* FLEXTIMER_1 Peripheral Control */
#define MC_ME_PCTL4          MC_ME.PCTL4.R                 /* FLEXTIMER_0 Peripheral Control */
#define MC_ME_PCTL11         MC_ME.PCTL11.R                /* SMC Peripheral Control Register */
#define MC_ME_PCTL10         MC_ME.PCTL10.R                /* CMP_1 Peripheral Control */
#define MC_ME_PCTL9          MC_ME.PCTL9.R                 /* CMP_0 Peripheral Control */
#define MC_ME_PCTL15         MC_ME.PCTL15.R                /* SSD_3 Peripheral Control Register */
#define MC_ME_PCTL14         MC_ME.PCTL14.R                /* SSD_2 Peripheral Control Register */
#define MC_ME_PCTL13         MC_ME.PCTL13.R                /* SSD_1 Peripheral Control */
#define MC_ME_PCTL12         MC_ME.PCTL12.R                /* SSD_0 Peripheral Control */
#define MC_ME_PCTL19         MC_ME.PCTL19.R                /* SPI_0 Peripheral Control */
#define MC_ME_PCTL18         MC_ME.PCTL18.R                /* MPR Peripheral Control */
#define MC_ME_PCTL17         MC_ME.PCTL17.R                /* SSD_5 Peripheral Control */
#define MC_ME_PCTL16         MC_ME.PCTL16.R                /* SSD_4 Peripheral Control */
#define MC_ME_PCTL23         MC_ME.PCTL23.R                /* SPI_4 Peripheral Control */
#define MC_ME_PCTL22         MC_ME.PCTL22.R                /* SPI_3 Peripheral Control */
#define MC_ME_PCTL21         MC_ME.PCTL21.R                /* SPI_2 Peripheral Control Register */
#define MC_ME_PCTL20         MC_ME.PCTL20.R                /* SPI_1 Peripheral Control */
#define MC_ME_PCTL27         MC_ME.PCTL27.R                /* LCD Peripheral Control Register */
#define MC_ME_PCTL26         MC_ME.PCTL26.R                /* LINFLEX_2 Peripheral Control */
#define MC_ME_PCTL25         MC_ME.PCTL25.R                /* LINFLEX_1 Peripheral Control Register */
#define MC_ME_PCTL24         MC_ME.PCTL24.R                /* LINFLEX_0 Peripheral Control Register */
#define MC_ME_PCTL30