/* hello_interrupts.c              (c) 2015 Freescale Semiconductor, Inc.
 * Descriptions: Hello world example with PIT interrupt
 * 28 Sept 2015 Steve Mihalik: Initial version
 */

#include "derivative.h"         /* include peripheral declarations SKEAZ128M4 */
#include "clocks.h"

#define PTE7 7                  /* Port PT7, bit 7: output to blue LED */

int pit0_flag_counter = 0;      /* Counter for PIT0 timer expirations */

void init_IRQs (void) {
  NVIC_ClearPendingIRQ(PIT_CH0_IRQn);  /* Clear any Pending IRQ for all PIT ch0 (#22) */
  NVIC_EnableIRQ(PIT_CH0_IRQn);        /* Set Enable IRQ for PIT_CH0 */
  NVIC_SetPriority(PIT_CH0_IRQn,0);    /* Set Priority for PIT_CH0 */
}

void init_PIT(void) {
  SIM_SCGC |= SIM_SCGC_PIT_MASK;     /* Enable bus clock to PIT module */
  PIT_MCR = 0x0;                     /* Turn on PIT module, Freeze disabled */
  PIT_LDVAL0 = 20000000 - 1;         /* PIT0: Load value to count 20M bus clocks */
  PIT_TCTRL0 |= PIT_TCTRL_TIE_MASK;  /* Enable interrupt */
  PIT_TCTRL0 |= PIT_TCTRL_TEN_MASK;  /* Enable (start) timer */
}

int main(void) {
  int idle_counter = 0;
  GPIOB_PDDR |= 1<<PTE7;    /* Port Data Dir: output on port E7, blue LED */
  init_clks_FEE_40MHz();     /* Initialize FLL: 8MHz xtal, 40 MHz core, 20 MHz bus clks */
  init_IRQs();              /* Initialize interrupts: enable, priorities */
  init_PIT();               /* Initialize PIT0: 1 sec timeout, IRQ enabled */
  for(;;) {
    idle_counter++;
  }
}

void PIT_CH0_IRQHandler (void) {
  pit0_flag_counter++;            /* PIT0 expired. Increment counter */
  GPIOB_PTOR |= 1<<PTE7;          /* Toggle Output (1) on port E7 (blue LED) */
  PIT_TFLG0 |= PIT_TFLG_TIF_MASK; /* Clear PIT0 flag */
}
