/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.ExamplePropertyParser;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class ExampleProjectLoader {
    private static final String EXT_ATTR_PATH = "path";
    private static final String EXT_ATTR_NAME = "name";
    private static final String EXT_ID = "folders";
    public static final String PROJECT_FILE = ".project";
    private static final String PLUGIN_ID = "com.nxp.s32ds.ext.ide.examples.core";

    public static Map<String, List<IExampleComponent>> loadFromExtension() throws CoreException {
        IConfigurationElement[] elements;
        HashMap<String, List<IExampleComponent>> mapProjects = new HashMap<String, List<IExampleComponent>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXT_ID).getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iter = iConfigurationElementArray[n2];
            File contentFolder = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(iter.getAttribute(EXT_ATTR_PATH), true));
            List<File> listProjectFiles = ExampleProjectLoader.findProjectFiles(contentFolder);
            List<IExampleComponent> listProjects = ExampleProjectLoader.loadModelObject(listProjectFiles, contentFolder);
            mapProjects.put(iter.getAttribute(EXT_ATTR_NAME), listProjects);
            ++n2;
        }
        return mapProjects;
    }

    private static List<File> findProjectFiles(File fromFile) {
        ArrayList<File> listProjectFiles = new ArrayList<File>();
        if (fromFile != null && fromFile.exists()) {
            if (fromFile.isFile() && fromFile.getName().equals(PROJECT_FILE)) {
                listProjectFiles.add(fromFile);
                return listProjectFiles;
            }
            if (fromFile.isDirectory()) {
                File[] fileArray = fromFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sfile = fileArray[n2];
                    listProjectFiles.addAll(ExampleProjectLoader.findProjectFiles(sfile));
                    ++n2;
                }
            }
        }
        return listProjectFiles;
    }

    private static List<IExampleComponent> loadModelObject(List<File> listProjectFiles, File contentFolder) throws CoreException {
        ArrayList<IExampleComponent> listProjects = new ArrayList<IExampleComponent>();
        for (File file : listProjectFiles) {
            Path relativePath = contentFolder.toPath().relativize(file.toPath());
            ArrayList<String> grouplist = new ArrayList<String>();
            int lastIndexPath = relativePath.getNameCount() - 2;
            int i = 0;
            while (i < lastIndexPath) {
                String strSegmentPath = relativePath.getName(i).toString();
                grouplist.add(strSegmentPath);
                ++i;
            }
            String group = String.join((CharSequence)";", grouplist);
            try {
                listProjects.add(ExamplePropertyParser.parseToModelObject(file, group));
            }
            catch (CoreException e) {
                Log.log((IStatus)e.getStatus());
            }
        }
        return listProjects;
    }

    public static IProjectDescription getProject(IPath path, boolean needThrow) throws CoreException {
        IProjectDescription pd = null;
        try {
            pd = ResourcesPlugin.getWorkspace().loadProjectDescription(path);
        }
        catch (Exception e) {
            Log.log((String)"Error!", (Throwable)e);
        }
        if (pd == null && needThrow) {
            Status status = new Status(4, PLUGIN_ID, String.format("Cannot read XML file: %s", path.toString()));
            throw new CoreException((IStatus)status);
        }
        return pd;
    }
}

