/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.wizard.imports.ImportConvertorHolder;
import com.freescale.s32ds.cross.wizard.pi.Messages;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import com.freescale.s32ds.cross.wizard.pi.imports.ProjectInfoImportSettings;
import com.nxp.s32ds.ext.ide.resources.IdeValidators;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportPIPage
extends WizardDataTransferPage {
    private static final String GDB_PE_MICRO_INTERFACE_DEBUGGING = "GDB PEMicro Interface Debugging";
    private static final String TITLE_WIZ = Messages.ImportPIPage_ConvertProjectInfo;
    private static final String DESCR_WIZ = Messages.ImportPIPage_CreateProjectFromProjectInfo;
    private static final String KEY_PATH = "keyPE_path";
    private static final String[] FILTER_NAMES = new String[]{"ProjectInfo.xml Files (ProjectInfo.xml)"};
    private static final String[] FILTER_EXTS = new String[]{"ProjectInfo.xml"};
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String NO_PT = Messages.ImportPIPage_NoProjectTypes;
    private static final String DE_PT = Messages.ImportPIPage_SelectProjectType;
    private static final String NO_CORE_FOUND = Messages.ImportPIPage_NoCoreFound;
    private static final String NO_TYPE_FOUND = Messages.ImportPIPage_NoProjectTypeFound;
    private static final String NO_SELECT_DEBUG_CONFIG = Messages.ImportPIPage_NoProjectTypeFound;
    private ScrolledComposite containerSC;
    private Composite comp;
    private Group projectTypeGroup;
    private Binding projectTypeBinding = null;
    private IObservableValue projectTypeGroupObservableValue;
    private Button checkDebug;
    private volatile ImportConvertorHolder selConv;
    private volatile int[] selExtra;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ProjectInfoImportSettings settings = new ProjectInfoImportSettings(new Lingvo());
    private final CompositeValidator compositeNameValidator = new CompositeValidator(IdeValidators.getNameValidators());

    public ImportPIPage() {
        super(TITLE_WIZ);
        this.setTitle(TITLE_WIZ);
        this.setDescription(DESCR_WIZ);
    }

    public PIReader getPIReader() {
        return this.settings.getPiReader();
    }

    public ImportConvertorHolder getSelConverter() {
        return this.selConv;
    }

    public int[] getSelExtraParams() {
        return this.selExtra;
    }

    public void createControl(Composite parent) {
        Composite rootComposite = new Composite(parent, 0);
        rootComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.containerSC = new ScrolledComposite(rootComposite, 512);
        this.containerSC.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(400, 200).create());
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.comp = new Composite((Composite)this.containerSC, 0);
        this.comp.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        this.createProjectTypeObserver();
        this.createProjectPanel();
        this.createDebugConfigurationPanel();
        this.containerSC.setContent((Control)this.comp);
        this.containerSC.setMinSize(this.comp.computeSize(-1, -1));
        this.setControl((Control)rootComposite);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setPageComplete(false);
    }

    private void createDebugConfigurationPanel() {
        Composite configDebugTypesPanel = new Composite(this.comp, 0);
        configDebugTypesPanel.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)configDebugTypesPanel);
        this.checkDebug = new Button(configDebugTypesPanel, 32);
        this.checkDebug.setText("Create Launch Configuration");
        this.checkDebug.setSelection(true);
        DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        this.settings.setDebugConfigurationName(GDB_PE_MICRO_INTERFACE_DEBUGGING);
        new SelectObservableValue();
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.checkDebug), PojoProperties.value((String)"createLaunchConfiguration").observe((Object)this.settings));
    }

    private void createProjectPanel() {
        Composite projectPanel = new Composite(this.comp, 0);
        projectPanel.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectPanel);
        new Label(projectPanel, 0).setText(Messages.ImportPIPage_ExistingFile);
        Composite fileSelectorPanel = new Composite(projectPanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileSelectorPanel);
        fileSelectorPanel.setLayout((Layout)new GridLayout(2, false));
        Text location = new Text(fileSelectorPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)location);
        location.setEnabled(false);
        location.setText(SPACE);
        Button browse = new Button(fileSelectorPanel, 0);
        browse.setText(Messages.ImportPIPage_Browse);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)location), PojoProperties.value((String)"piReader").observe((Object)this.settings), this.createFilePathValidationPolicy(), null);
        this.bindFileSelectorHook(location, browse);
        new Label(projectPanel, 0).setText(Messages.AbstractImportPage_NewProjectName);
        Composite projectNamePanel = new Composite(projectPanel, 0);
        projectNamePanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectNamePanel);
        Text projectName = new Text(projectNamePanel, 2048);
        ControlDecorationSupport.create((ValidationStatusProvider)this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)location), (IObservableValue)WidgetProperties.text().observe((Widget)projectName), this.createProjectNameFromPathStrategy(), null), (int)16512);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectName);
        ControlDecorationSupport.create((ValidationStatusProvider)this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)projectName), PojoProperties.value((String)"projectName").observe((Object)this.settings), this.createProjectNameStrategy(), null), (int)16512);
        this.projectTypeGroup = new Group(this.comp, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectTypeGroup);
        this.projectTypeGroup.setLayout((Layout)new GridLayout());
        this.projectTypeGroup.setText(NO_PT);
        this.dbc.bindValue(this.settings.getPIReaderWritableValue(), this.projectTypeGroupObservableValue, this.createProjectTypeStrategy(), null);
        this.dbc.bindValue(this.projectTypeGroupObservableValue, PojoProperties.value((String)"selectedProjectType").observe((Object)this.settings));
    }

    private void createProjectTypeObserver() {
        this.projectTypeGroupObservableValue = new AbstractObservableValue(){

            public Object getValueType() {
                return IProjectType.class;
            }

            protected Object doGetValue() {
                return ImportPIPage.this.settings.getSelectedProjectType();
            }

            protected void doSetValue(Object value) {
                ImportPIPage.this.updateProjectTypeGroup();
            }
        };
    }

    private void bindFileSelectorHook(final Text location, Button browse) {
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportPIPage.this.comp.getShell(), 4096);
                dialog.setFilterNames(FILTER_NAMES);
                dialog.setFilterExtensions(FILTER_EXTS);
                dialog.setFileName(FILTER_EXTS[0]);
                dialog.setText(Messages.ImportPIPage_SelectFileToProcess);
                dialog.setFilterPath(ImportPIPage.loadSettings(ImportPIPage.KEY_PATH));
                String fileName = dialog.open();
                if (fileName != null) {
                    location.setText(fileName);
                    ImportPIPage.saveSettings(ImportPIPage.KEY_PATH, fileName);
                }
            }
        });
    }

    private void updateProjectTypeGroup() {
        if (this.projectTypeBinding != null) {
            this.dbc.removeBinding(this.projectTypeBinding);
            this.projectTypeBinding = null;
        }
        Control[] controlArray = this.projectTypeGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ct = controlArray[n2];
            ct.dispose();
            ++n2;
        }
        this.comp.pack();
        this.projectTypeGroup.setText(NO_PT);
        ArrayList pts = new ArrayList();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        AtomicReference optionProcessor = new AtomicReference();
        try {
            dialog.run(true, true, monitor -> {
                monitor.beginTask(Messages.ImportPIPage_analyzing, 100);
                pts.addAll(this.settings.getProjectTypes());
                IProjectType projectType = this.settings.getSelectedProjectType();
                if (projectType != null) {
                    IConfiguration[] icfgs = projectType.getConfigurations();
                    optionProcessor.set(this.settings.getSelectedToolChainOptionProcessor(icfgs[0].getToolChain()));
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            S32DSWizardPiPlugin.log(e);
        }
        if (pts.isEmpty() && this.settings.getPiReader() != null) {
            this.projectTypeGroup.setText(String.format("%s(DeviceID: %s | CoreSet: %s)", NO_CORE_FOUND, this.settings.getPiReader().getDeviceId(), this.settings.getPiReader().getCoreSet()));
        }
        if (optionProcessor.get() == null && this.settings.getSelectedProjectType() != null) {
            this.projectTypeGroup.setText(String.format(Messages.ImportPIPage_no_processor, this.settings.getSelectedProjectType().getConfigurations()[0].getToolChain().getId()));
        }
        this.projectTypeGroup.setText(DE_PT);
        SelectObservableValue selectedRadioButtonObservable = new SelectObservableValue();
        for (final IProjectType p : pts) {
            Button button = new Button((Composite)this.projectTypeGroup, 16);
            button.setText(String.valueOf(p.getName()) + " -> " + p.getConfigurations()[0].getToolChain().getName());
            button.setLayoutData((Object)new GridData(4, 4, true, false));
            button.setData((Object)p);
            selectedRadioButtonObservable.addOption((Object)p, (IObservableValue)WidgetProperties.selection().observe((Widget)button));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportPIPage.this.checkDebug.setEnabled(!ImportPIPage.this.settings.isLibrarySelected(p));
                }
            });
        }
        this.dbc.bindValue((IObservableValue)selectedRadioButtonObservable, PojoProperties.value((String)"selectedProjectType").observe((Object)this.settings));
        this.containerSC.setMinSize(this.comp.computeSize(-1, -1));
        this.containerSC.getShell().pack(true);
        this.comp.pack();
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    private UpdateValueStrategy createProjectTypeStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setAfterGetValidator(value -> {
            if (!this.settings.getProjectTypes().isEmpty()) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)NO_TYPE_FOUND);
        });
        return strategy;
    }

    private UpdateValueStrategy createProjectNameStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(value -> {
            if (this.settings.isInitialState()) {
                return ValidationStatus.ok();
            }
            IStatus result = this.compositeNameValidator.validate(value);
            if (!result.isOK()) {
                return result;
            }
            return ValidationStatus.ok();
        });
        return strategy;
    }

    private UpdateValueStrategy createProjectNameFromPathStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                try {
                    return ImportPIPage.this.generateProjectName(fromObject);
                }
                catch (Exception e) {
                    S32DSWizardPiPlugin.log(e);
                    return ImportPIPage.EMPTY;
                }
            }
        });
        return strategy;
    }

    private UpdateValueStrategy createFilePathValidationPolicy() {
        final AtomicReference<Object> piReader = new AtomicReference<Object>(null);
        UpdateValueStrategy updateStrategy = new UpdateValueStrategy();
        updateStrategy.setAfterGetValidator(value -> {
            if (EMPTY.equals(value)) {
                piReader.set(null);
                return ValidationStatus.error((String)Messages.ImportPIPage_provide_file);
            }
            try {
                PIReader reader = new PIReader((String)value);
                piReader.set(reader);
                return ValidationStatus.ok();
            }
            catch (IOException ioe) {
                piReader.set(null);
                return ValidationStatus.error((String)ioe.getMessage());
            }
            catch (JAXBException jaxbe) {
                S32DSWizardPiPlugin.log(jaxbe);
                piReader.set(null);
                String err = jaxbe.getMessage();
                return ValidationStatus.error((String)(String.valueOf(Messages.ImportPIPage_bad_xml) + (err == null ? EMPTY : err)));
            }
        });
        updateStrategy.setConverter(new IConverter(){

            public Object getToType() {
                return PIReader.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                return piReader.get();
            }
        });
        updateStrategy.setAfterConvertValidator(value -> {
            if (value == null && this.settings.getPiReader() == null) {
                return ValidationStatus.ok();
            }
            if (value != null) {
                PIReader pi = (PIReader)value;
                if (!ImportPIPage.isGNU(pi) && !ImportPIPage.isIAR(pi)) {
                    return ValidationStatus.warning((String)Messages.ImportPIPage_GCCIAR_only);
                }
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)Messages.ImportPIPage_Null_data);
        });
        return updateStrategy;
    }

    public ProjectInfoImportSettings getSettings() {
        return this.settings;
    }

    private String generateProjectName(Object fromObject) {
        String piPath;
        Path xml = Paths.get((String)fromObject, new String[0]);
        if (xml.getNameCount() > 1) {
            return xml.getParent().getFileName().toString();
        }
        if (this.settings.getPiReader() != null && (piPath = this.settings.getPiReader().getProjectInfoPath()) != null) {
            return Paths.get(piPath, new String[0]).getParent().getFileName().toString();
        }
        return String.valueOf(fromObject);
    }

    private static boolean isGNU(PIReader pi) {
        for (String option : pi.getOptionsCC()) {
            if (!option.contains("-mcpu=")) continue;
            return true;
        }
        return false;
    }

    private static boolean isIAR(PIReader pi) {
        for (String option : pi.getOptionsCC()) {
            if (!option.contains("--cpu ")) continue;
            return true;
        }
        return false;
    }

    public static String loadSettings(String key) {
        return InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard.pi").get(key, EMPTY);
    }

    public static void saveSettings(String key, String path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard.pi");
        prefs.put(key, path);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            S32DSWizardPiPlugin.log(e);
        }
    }
}

