/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cross.wizard.pi.Messages;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.PIWriter;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import com.freescale.s32ds.cross.wizard.pi.jaxb.Export;
import java.net.URI;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectInfoExporter {
    private final ProjectInfoExportSettings settings;

    public ProjectInfoExporter(ProjectInfoExportSettings settings) {
        this.settings = settings;
    }

    public boolean writeProjectInfo() {
        Path path = this.settings.getOutputFile();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Export.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Export export = new PIWriter(this.settings).createExport();
            marshaller.marshal((Object)export, path.toFile());
            ResourcesUtil.refreshWorkspaceFiles((URI)URIUtil.toURI((String)path.toString()));
        }
        catch (Exception e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (e.getMessage() != null) {
                shell.getDisplay().syncExec(() -> {
                    boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)Messages.ProjectInfoExporter_export_error_title, (String)e.getMessage(), (int)0);
                });
            } else {
                shell.getDisplay().syncExec(() -> {
                    boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)Messages.ProjectInfoExporter_export_error_title, (String)Messages.ProjectInfoExporter_export_error, (int)0);
                });
            }
            S32DSWizardPiPlugin.log(e);
            return false;
        }
        return true;
    }
}

