/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.wizard.pi.Messages;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExportInfoPage
extends WizardPage {
    private final ProjectInfoExportSettings settings;
    private final IProject project;
    private Text filePathText;

    protected ExportInfoPage(IProject project) {
        super(String.format(Messages.ExportInfoPage_generate, project.getName()));
        this.project = project;
        this.setTitle(this.getName());
        this.settings = new ProjectInfoExportSettings(project, new Lingvo());
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite panel = new Composite(parent, 0);
        DataBindingContext dbc = new DataBindingContext();
        GridDataFactory.fillDefaults().applyTo((Control)panel);
        panel.setLayout((Layout)new GridLayout(2, false));
        new Label(panel, 0).setText(Messages.ExportInfoPage_select);
        ComboViewer configs = new ComboViewer(panel, 8);
        this.initConfigurationsCombo(configs);
        new Label(panel, 0).setText(Messages.ExportInfoPage_default);
        Button defaultPaths = new Button(panel, 16);
        new Label(panel, 0).setText(Messages.ExportInfoPage_absolute);
        Button absolutePaths = new Button(panel, 16);
        this.setControl((Control)panel);
        SelectPathStrategy strategy = new SelectPathStrategy(dbc);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)defaultPaths), PojoProperties.value((String)"defaultPaths").observe((Object)this.settings), (UpdateValueStrategy)strategy, null);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)absolutePaths), PojoProperties.value((String)"absolutePaths").observe((Object)this.settings), (UpdateValueStrategy)strategy, null);
        dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)configs), PojoProperties.value((String)"configuration").observe((Object)this.settings));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        try {
            if (ExportInfoPage.hasLinks((IContainer)this.project) || this.hasSDK()) {
                absolutePaths.setSelection(true);
                defaultPaths.setEnabled(false);
                this.setMessage(Messages.ExportInfoPage_LinkerResourceError);
            }
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e.getStatus());
        }
    }

    private void initConfigurationsCombo(ComboViewer configs) {
        configs.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        configs.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICConfigurationDescription) {
                    return ((ICConfigurationDescription)element).getName();
                }
                return super.getText(element);
            }
        });
        ICConfigurationDescription[] configurations = CoreModel.getDefault().getProjectDescription(this.project).getConfigurations();
        if (configurations.length > 0) {
            this.settings.setConfiguration(configurations[0]);
            configs.setInput((Object)configurations);
        } else {
            S32DSWizardPiPlugin.logWarning(String.valueOf(Messages.ExportInfoPage_No_config) + this.project.getName());
        }
    }

    protected void createFileSelectionGroup(Composite parent) {
        Composite fileSelectionGroup = new Composite(parent, 0, parent){
            {
                this.setLayout((Layout)new GridLayout(2, false));
                this.setLayoutData(new GridData(768));
                this.setFont(composite.getFont());
            }
        };
        Label label = new Label(fileSelectionGroup, 0);
        label.setText(Messages.ExportInfoPage_set_output);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)label);
        Text file = new Text(fileSelectionGroup, 2052);
        file.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(fileSelectionGroup, 8);
        browseButton.setText(Messages.ExportInfoPage_browse);
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ExportInfoPage.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.xml"});
                String filePath = fileDialog.open();
                if (filePath != null) {
                    ExportInfoPage.this.filePathText.setText(filePath);
                }
            }
        });
    }

    public ProjectInfoExportSettings getSettings() {
        return this.settings;
    }

    public static boolean hasLinks(IContainer container) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                return true;
            }
            if (resource instanceof IContainer && ExportInfoPage.hasLinks((IContainer)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasSDK() {
        return !SDKAttach.getAttached((IProject)this.project).isEmpty();
    }

    private class SelectPathStrategy
    extends UpdateValueStrategy {
        private final DataBindingContext dbc;

        public SelectPathStrategy(DataBindingContext dbc) {
            this.dbc = dbc;
        }

        public IStatus validateAfterConvert(Object value) {
            try {
                if (ExportInfoPage.this.hasSDK() && ExportInfoPage.this.settings.getDefaultPaths().booleanValue()) {
                    return ValidationStatus.error((String)Messages.ExportInfoPage_cannot_export_sdk);
                }
                if (ExportInfoPage.hasLinks((IContainer)ExportInfoPage.this.project) && ExportInfoPage.this.settings.getDefaultPaths().booleanValue()) {
                    return ValidationStatus.error((String)Messages.ExportInfoPage_cannot_export_link);
                }
                this.dbc.getValidationStatusProviders().stream().forEach(provider -> ((ValidationStatusProvider)provider).getValidationStatus().setValue((Object)ValidationStatus.ok()));
                ExportInfoPage.this.setPageComplete(true);
            }
            catch (CoreException e) {
                S32DSWizardPiPlugin.log(e);
                return ValidationStatus.error((String)e.getMessage());
            }
            return ValidationStatus.ok();
        }
    }
}

