/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cross.wizard.pi.ProjectInfoPathProcessor;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.IPIExporterDataProvider;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import com.freescale.s32ds.cross.wizard.pi.exports.toolchains.FreescaleS32DSToolChainExporter;
import com.freescale.s32ds.cross.wizard.pi.exports.toolchains.GHSToolChainExporter;
import com.freescale.s32ds.cross.wizard.pi.exports.toolchains.IARToolChainExporter;
import com.freescale.s32ds.cross.wizard.pi.exports.toolchains.IToolChainExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class DefaultOptionProvider
implements IPIExporterDataProvider {
    private final IToolChainExporter[] exporters = new IToolChainExporter[]{new IARToolChainExporter(), new GHSToolChainExporter(), new FreescaleS32DSToolChainExporter()};
    private static final String IAR_ARM_TOOLCHAIN_PROJECT = "iar.arm.toolchain.project";
    final IToolChain toolchain;
    final IToolChainExporter exporter;
    final ProjectInfoExportSettings settings;

    public DefaultOptionProvider(ProjectInfoExportSettings settings) {
        this.settings = settings;
        this.toolchain = this.getConfig().getToolChain();
        this.exporter = this.getToolChainExporter(this.toolchain);
    }

    @Override
    public List<String> getCCOpts() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.exporter == null) {
            S32DSWizardPiPlugin.logWarning("Tool Chain Exporter Missing for " + this.toolchain.getId());
            return result;
        }
        try {
            ITool[] iToolArray = this.toolchain.getTools();
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (this.exporter.isCCompiler(tool)) {
                    result.addAll(this.exporter.processOptions(tool, this.getOptions(tool), this.settings));
                }
                ++n2;
            }
        }
        catch (BuildException | CoreException e) {
            S32DSWizardPiPlugin.log(e);
        }
        return result;
    }

    @Override
    public List<String> getAsmOpts() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.exporter == null) {
            S32DSWizardPiPlugin.logWarning("Tool Chain Exporter Missing for " + this.toolchain.getId());
            return result;
        }
        try {
            ITool[] iToolArray = this.toolchain.getTools();
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (this.exporter.isAssembler(tool)) {
                    result.addAll(this.exporter.processOptions(tool, this.getOptions(tool), this.settings));
                }
                ++n2;
            }
        }
        catch (BuildException | CoreException e) {
            S32DSWizardPiPlugin.log(e);
        }
        return result;
    }

    @Override
    public List<String> getLinkerOptions() {
        List<String> result = new ArrayList<String>();
        if (this.exporter == null) {
            S32DSWizardPiPlugin.logWarning("Tool Chain Exporter Missing for " + this.toolchain.getId());
            return result;
        }
        try {
            ITool[] iToolArray = this.toolchain.getTools();
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (this.exporter.isLinker(tool)) {
                    result = this.exporter.processOptions(tool, this.getOptions(tool), this.settings);
                }
                ++n2;
            }
        }
        catch (BuildException | CoreException e) {
            S32DSWizardPiPlugin.log(e);
        }
        return result;
    }

    @Override
    public String getLinkerCommandFile() {
        if (this.exporter == null) {
            return "";
        }
        return this.exporter.getLinkerCommandFile(this.getLinkerOptions(), this.settings);
    }

    @Override
    public boolean mergeOptions() {
        if (this.toolchain.getId().startsWith(IAR_ARM_TOOLCHAIN_PROJECT)) {
            return false;
        }
        return this.settings.getDefaultPaths();
    }

    private IToolChainExporter getToolChainExporter(IToolChain toolchain) {
        return Stream.of(this.exporters).filter(e -> e.isFits(toolchain)).findAny().orElse(null);
    }

    private List<String> getOptions(ITool tool) throws BuildException, CoreException {
        List<String> toolCommandFlagsString = Arrays.asList(tool.getToolCommandFlags(null, null));
        if (this.settings.getDefaultPaths().booleanValue()) {
            toolCommandFlagsString.stream().forEach(option -> {
                String string = ProjectInfoPathProcessor.substituteVarsPaths(option, tool);
            });
        }
        return toolCommandFlagsString;
    }

    @Override
    public List<String> getSourceCodePaths() {
        ArrayList<String> sourceCodePaths = new ArrayList<String>();
        ICSourceEntry[] iCSourceEntryArray = this.getConfig().getSourceEntries();
        int n = iCSourceEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry se = iCSourceEntryArray[n2];
            sourceCodePaths.add(se.getName());
            ++n2;
        }
        return sourceCodePaths;
    }

    @Override
    public List<String> getIncludePaths() throws CoreException {
        List paths = Arrays.stream(this.settings.getConfiguration().getRootFolderDescription().getLanguageSettings()).map(e -> e.getSettingEntries(1)).flatMap(Arrays::stream).map(ICSettingEntry::getName).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            String processedPath = ProjectInfoPathProcessor.process(path, this.settings.getDefaultPaths(), this.settings.getConfiguration());
            if (result.contains(processedPath)) continue;
            result.add(processedPath);
        }
        return result;
    }

    private IConfiguration getConfig() {
        return ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)this.settings.getConfiguration().getConfiguration());
    }

    private static List<IResource> getResources(IConfiguration configuration, IContainer project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getType() == 1 && DefaultOptionProvider.isInConfiguration(r, configuration)) {
                    result.add(r);
                } else if (r.getType() == 2) {
                    result.addAll(DefaultOptionProvider.getResources(configuration, (IContainer)r));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e);
        }
        return result;
    }

    private static boolean isInConfiguration(IResource resource, IConfiguration configuration) {
        return Stream.of(configuration.getSourceEntries()).anyMatch(r -> CDataUtil.isOnSourceEntry((IPath)resource.getProjectRelativePath(), (ICSourceEntry)r));
    }

    @Override
    public List<String> getFiles(String exts) {
        ArrayList<String> result = new ArrayList<String>();
        for (IResource r : DefaultOptionProvider.getResources(this.getConfig(), (IContainer)this.settings.getProject())) {
            String[] stringArray = exts.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.trim().equalsIgnoreCase(r.getFileExtension())) {
                    if (this.settings.getAbsolutePaths().booleanValue()) {
                        result.add(r.getLocation().toOSString().trim());
                    } else {
                        result.add(r.getProjectRelativePath().toOSString());
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

