/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.validation.core;

import com.nxp.s32ds.ext.ide.checker.IResourceChecker;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CdtProjectIndexerSettingsInitializer
implements IResourceChecker {
    private static final String USE_ACTIVE_BUILD_CONFIGURATION = "useActiveBuildConfiguration";
    private static final String SET_DESCRIPTION_TO_PROJECT = "set description to project";

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IProject && CoreModel.hasCNature((IProject)((IProject)resource))) {
            IProject project = (IProject)resource;
            Properties properties = IndexerPreferences.getProperties((IProject)((IProject)resource));
            Object useActive = properties.get(USE_ACTIVE_BUILD_CONFIGURATION);
            if (useActive != null) {
                final ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
                final ICProjectDescription icProjectDescription = prjDescMgr.getProjectDescription(project, true);
                icProjectDescription.setConfigurationRelations(Boolean.valueOf((String)useActive) != false ? 2 : 1);
                Job job = new Job(SET_DESCRIPTION_TO_PROJECT){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            prjDescMgr.setProjectDescription(icProjectDescription.getProject(), icProjectDescription);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                job.setRule((ISchedulingRule)root);
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            }
        }
        return Status.OK_STATUS;
    }
}

