/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class DelConfig
extends ProcessRunner {
    private static final String ERR = "Data for DelConfig should contain configuration name and project name. Cannot continue.";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (template.getValueStore().get("EARLY_DONE") != null) {
            return;
        }
        if (args == null) {
            S32DSWizardPlugin.logWarning(ERR);
            return;
        }
        String name = null;
        String proj = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            if (pa.getName().equals("projectName")) {
                proj = pa.getSimpleValue();
            } else if (pa.getName().equals("name")) {
                name = pa.getSimpleValue();
            } else {
                S32DSWizardPlugin.logWarning("Unknown argument name: " + pa.getName());
            }
            ++n2;
        }
        if (name == null || name.trim().length() == 0 || proj == null || proj.trim().length() == 0) {
            S32DSWizardPlugin.logWarning(ERR);
            return;
        }
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(proj);
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(p);
        try {
            ICConfigurationDescription x = des.getConfigurationByName(name);
            if (x != null) {
                des.removeConfiguration(x);
                CProjectDescriptionManager.getInstance().setProjectDescription(p, des);
                S32DSWizardPlugin.logWarning("DelConfig: deleted config Name=" + name);
                return;
            }
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e);
        }
        S32DSWizardPlugin.logWarning("DelConfig: cannot find config Name=" + name);
    }
}

