/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.imports.IImportConverter;
import com.freescale.s32ds.cross.wizard.imports.ImportConvertorHolder;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchDialog
extends Dialog {
    protected static final byte RESULT_NONE = 0;
    protected static final byte RESULT_RET = 1;
    protected static final byte RESULT_BREAK = 2;
    protected static final String CLICK_PAUSE = Messages.SearchDialog_ClickForPause;
    protected static final String PAUSED = Messages.SearchDialog_Paused;
    protected static final String SEARCH_PROJ = Messages.SearchDialog_SearchProject;
    protected static final String SELECT_PRESS_OK = Messages.SearchDialog_SelectProject;
    protected static final String PRESS_OK_CANCEL = Messages.SearchDialog_PressOkOrCancel;
    protected static final String SEARCH_INTERR = Messages.SearchDialog_SearchInterrupted;
    protected static final String SEARCH_FINISH = Messages.SearchDialog_SearchFinished;
    protected static final String NOTHING_FOUND = Messages.SearchDialog_NothingFound;
    protected static final String TOTAL_FOUND = Messages.SearchDialog_TotalProjectsFound;
    protected Table table;
    protected Label label;
    protected Label help;
    protected ProgressBar pb;
    protected final Text target;
    protected final String path;
    private final List<ImportConvertorHolder> convs;
    private final boolean strict;
    private final boolean use_pe;
    protected volatile boolean interrupt = false;
    protected volatile boolean paused = false;
    protected volatile boolean running = false;
    private static SearchDialog instance;

    public static void start(Text t, String p, List<ImportConvertorHolder> c, boolean strict, boolean pe) {
        if (instance == null || SearchDialog.instance.pb.isDisposed()) {
            instance = new SearchDialog(t, c, p, strict, pe);
            instance.open();
        }
    }

    public SearchDialog(Text t, List<ImportConvertorHolder> c, String p, boolean str, boolean pe) {
        super(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell());
        this.setShellStyle(1264);
        this.target = t;
        this.convs = c;
        this.path = p;
        this.strict = str;
        this.use_pe = pe;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.table = new Table(c, 4);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setSortDirection(128);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (SearchDialog.this.running) {
                    SearchDialog.this.paused = !SearchDialog.this.paused;
                    SearchDialog.this.help.setText(SearchDialog.this.paused ? PAUSED : CLICK_PAUSE);
                    SearchDialog.this.pb.setState(SearchDialog.this.paused ? 4 : 0);
                }
                super.mouseUp(e);
            }
        });
        this.help = new Label(c, 0x1000000);
        this.help.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.label = new Label(c, 0x1000800);
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pb = new ProgressBar(c, 256);
        this.pb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pb.setMinimum(0);
        this.pb.setMaximum(100);
        this.pb.setForeground(new Color((Device)Display.getDefault(), 200, 255, 200));
        Display.getDefault().asyncExec(() -> this.search(this.path));
        return c;
    }

    protected void search(final String path) {
        String s = System.getenv("WINDIR");
        if (s != null) {
            s = s.replace('\\', '/');
        }
        final String windir = s;
        this.running = true;
        this.table.clearAll();
        this.help.setText(CLICK_PAUSE);
        new Thread(){

            @Override
            public void run() {
                SearchDialog.this.scan(new File(path), windir);
                SearchDialog.this.running = false;
                SearchDialog.this.finishUI();
            }
        }.start();
    }

    /*
     * Unable to fully structure code
     */
    protected void scan(File f, String windir) {
        if (!this.interrupt) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (this.interrupt) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException v0) {
                return;
            }
lbl10:
            // 2 sources

            ** while (this.paused)
        }
lbl11:
        // 1 sources

        if (f.isDirectory()) {
            p = f.getAbsolutePath();
            if (windir != null && p.replace('\\', '/').startsWith(windir)) {
                return;
            }
            this.updateUI(p);
            ffs = f.listFiles();
            if (ffs == null || ffs.length == 0) {
                return;
            }
            var8_5 = ffs;
            var7_6 = ffs.length;
            var6_7 = 0;
            block7: while (var6_7 < var7_6) {
                ff = var8_5[var6_7];
                if (this.interrupt) {
                    return;
                }
                switch (this.handleFile(ff, p)) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        break block7;
                    }
                    default: {
                        ++var6_7;
                    }
                }
            }
            var8_5 = ffs;
            var7_6 = ffs.length;
            var6_7 = 0;
            while (var6_7 < var7_6) {
                ff = var8_5[var6_7];
                if (ff.isDirectory()) {
                    this.scan(ff, windir);
                }
                ++var6_7;
            }
        }
    }

    protected int handleFile(File ff, String p) {
        if (".cproject".equals(ff.getName())) {
            for (ImportConvertorHolder c : this.convs) {
                if (this.interrupt) {
                    return 1;
                }
                String s = ((IImportConverter)c.clazz).fits(p, this.strict, this.use_pe);
                if (s != null) continue;
                this.addToTab(p, c.image);
                break;
            }
            return 1;
        }
        return 0;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SEARCH_PROJ);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void okPressed() {
        this.interrupt = true;
        if (this.running) {
            return;
        }
        int n = this.table.getSelectionIndex();
        if (n >= 0 && this.target != null) {
            String txt = this.table.getItem(n).getText();
            this.target.setText(txt);
            Control[] c = this.target.getParent().getParent().getChildren();
            if (c != null && c.length > 1) {
                Control[] controlArray = ((Group)c[1]).getChildren();
                int n2 = controlArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Control x = controlArray[n3];
                    if (x instanceof Text) {
                        ((Text)x).setText(new Path(txt).lastSegment());
                        break;
                    }
                    ++n3;
                }
            }
        }
        instance = null;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.interrupt = true;
        if (this.running) {
            return;
        }
        instance = null;
        super.cancelPressed();
    }

    protected void updateUI(String p) {
        Display.getDefault().asyncExec(() -> {
            if (this.pb != null && (this.pb.isDisposed() || this.pb.getDisplay() == null)) {
                if (this.pb.isDisposed()) {
                    this.cancelPressed();
                    return;
                }
                int n = this.pb.getSelection();
                this.pb.setSelection(n >= this.pb.getMaximum() ? this.pb.getMinimum() : n + 1);
            }
            if (this.label != null) {
                this.label.setText(p);
            }
        });
    }

    protected void addToTab(String s, Image img) {
        Display.getDefault().asyncExec(() -> {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(s.replace('\\', '/'));
            ti.setImage(img);
            this.table.select(this.table.getItemCount() - 1);
        });
    }

    protected void finishUI() {
        Display.getDefault().asyncExec(() -> {
            String act;
            if (this.pb != null) {
                if (this.pb.isDisposed()) {
                    return;
                }
                this.pb.setSelection(this.pb.getMaximum());
            }
            String string = act = this.interrupt ? SEARCH_INTERR : SEARCH_FINISH;
            if (this.table.getItemCount() > 0) {
                this.help.setText(String.valueOf(act) + NLS.bind((String)TOTAL_FOUND, (Object)this.table.getItemCount()));
                this.label.setText(SELECT_PRESS_OK);
            } else {
                this.help.setText(String.valueOf(act) + NOTHING_FOUND);
                this.label.setText(PRESS_OK_CANCEL);
            }
        });
    }
}

