/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.tools.RenameDialog;
import com.freescale.s32ds.cross.core.tools.RenameJob;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IResource res = RenameHandler.stream(selection, IResource.class).findAny().orElse(RenameHandler.stream(selection, IAdaptable.class).map(adaptable -> (IResource)adaptable.getAdapter(IResource.class)).filter(IResource.class::isInstance).map(IResource.class::cast).findAny().orElse(RenameHandler.adapt(selection, ResourceMapping.class).map(FuncUtils.loggingFunction(RenameHandler::getTraversals, null)).filter(Objects::nonNull).flatMap(resourceTraversalArray -> Stream.of(resourceTraversalArray)).map(ResourceTraversal::getResources).flatMap(iResourceArray -> Stream.of(iResourceArray)).findAny().orElse(null)));
        if (res != null) {
            Shell shell;
            ProjectSet projects;
            block6: {
                int segWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().segmentCount();
                int matchingSymb = ResourcesPlugin.getWorkspace().getRoot().getLocation().matchingFirstSegments(res.getLocation());
                projects = null;
                if (segWorkspace == matchingSymb && (projects = RenameHandler.getProjects(res)).isEmpty()) {
                    projects = RenameHandler.getProjectsWithGraphs(res);
                }
                shell = Objects.requireNonNull(EclipseUtils.getShell());
                if (projects != null && !projects.isEmpty()) break block6;
                shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)"Cannot rename", (String)"Nothing selected, or project(s) are out of workspace."));
                return null;
            }
            try {
                RenameDialog dialog = new RenameDialog(shell, projects);
                if (dialog.open() == 0) {
                    new RenameJob(projects, dialog.getResult()).schedule();
                }
            }
            catch (Exception e) {
                Activator.log(e);
                EclipseUtils.openError((String)"Rename failed", (String)e.getMessage(), (Exception)e);
            }
        }
        return null;
    }

    private static ProjectSet getProjects(IResource resource) throws CoreException, IOException {
        if (resource.getLocation().makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()).segmentCount() == 1) {
            IProject project = EclipseUtils.getProjectByName((String)resource.getName());
            IProjectDescription pd = project.getDescription();
            pd.setLocation(project.getLocation());
            return new ProjectSet(pd);
        }
        File fileParent = resource.getLocation().toFile().getParentFile();
        Path path = new Path(fileParent.getAbsolutePath());
        ArrayList<IProjectDescription> listProjectDescr = new ArrayList<IProjectDescription>();
        File[] fileArray = fileParent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            IProject project = EclipseUtils.getProjectByName((String)folder.getName());
            if (project.isAccessible()) {
                listProjectDescr.add(project.getDescription());
            }
            ++n2;
        }
        return new ProjectSet(fileParent.getName(), "", (IPath)path, listProjectDescr);
    }

    private static ProjectSet getProjectsWithGraphs(IResource resource) throws CoreException, IOException {
        IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath resLocation = resource.getLocation();
        File resParent = resLocation.toFile().getParentFile();
        if (resLocation.makeRelativeTo(location).segmentCount() == 2) {
            IProject project = EclipseUtils.getProjectByName((String)resource.getName());
            return new ProjectSet(project.getName(), project.getName(), resLocation, RenameHandler.collectSiblingProjects(resParent).collect(Collectors.toList()));
        }
        return null;
    }

    private static Stream<IProjectDescription> collectSiblingProjects(File parent) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return Stream.of(parent.listFiles(File::isDirectory)).map(file -> new File((File)file, ".project")).filter(file -> file.isFile() && file.length() > 0L).map(File::toString).map(Path::new).map(FuncUtils.loggingFunction(arg_0 -> ((IWorkspace)ws).loadProjectDescription(arg_0), null)).filter(Objects::nonNull);
    }

    public boolean isEnabled() {
        return true;
    }

    private static <T> Stream<T> stream(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().filter(clazz::isInstance);
    }

    private static <T> Stream<T> adapt(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().map(o -> Platform.getAdapterManager().getAdapter(o, clazz)).filter(clazz::isInstance);
    }

    private static ResourceTraversal[] getTraversals(ResourceMapping mapping) throws CoreException {
        return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
    }
}

