/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.tools.DisassembleFilesHandler;
import com.freescale.s32ds.cross.core.tools.Disassembler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PreprocessDisassembleFilesHandler
extends DisassembleFilesHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> selectedFiles = PreprocessDisassembleFilesHandler.getSelectedFiles(event);
        if (selectedFiles.isEmpty()) {
            return null;
        }
        DisassembleFilesHandler.BuildFilesJob preprocessFilesJob = new DisassembleFilesHandler.BuildFilesJob(selectedFiles);
        preprocessFilesJob.schedule();
        try {
            preprocessFilesJob.join();
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        List<IFile> outputPreprocessedFiles = preprocessFilesJob.getOutputBinaryFiles();
        if (outputPreprocessedFiles.isEmpty()) {
            return null;
        }
        DisassembleFilesHandler.BuildFilesJob buildFilesJob = new DisassembleFilesHandler.BuildFilesJob(outputPreprocessedFiles);
        buildFilesJob.schedule();
        try {
            buildFilesJob.join();
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        List<IFile> outputBinaryFiles = buildFilesJob.getOutputBinaryFiles();
        if (!outputBinaryFiles.isEmpty()) {
            new DisassembleFilesHandler.DisassembleFilesJob(outputBinaryFiles).schedule();
        }
        return null;
    }

    @Override
    protected boolean shouldBeEnabled(Object evaluationContext) {
        IStructuredSelection selection = PreprocessDisassembleFilesHandler.convertSelection((IEvaluationContext)evaluationContext, null);
        if (selection.isEmpty()) {
            return false;
        }
        ArrayList<IFile> sources = new ArrayList<IFile>();
        for (Object next : selection) {
            IManagedBuildInfo buildInfo;
            IContentDescription contentDescription;
            IContentType contentType;
            IFile file;
            block13: {
                block12: {
                    file = (IFile)AdapterUtil.adapt(next, IFile.class);
                    if (file == null) {
                        return false;
                    }
                    contentType = null;
                    try {
                        if (file.exists()) break block12;
                        return false;
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        return false;
                    }
                }
                contentDescription = file.getContentDescription();
                if (contentDescription != null) break block13;
                return false;
            }
            contentType = contentDescription.getContentType();
            if (contentType.isKindOf(asm_source) && (buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject())) != null) {
                IConfiguration config = buildInfo.getDefaultConfiguration();
                if (CDataUtil.isExcluded((IPath)file.getProjectRelativePath(), (ICSourceEntry[])config.getSourceEntries())) {
                    return false;
                }
                try {
                    IBuildDescription des = BuildDescriptionManager.createBuildDescription((IConfiguration)config, null, (int)0);
                    if (des.getBuildResource((IResource)file) == null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    return false;
                }
                sources.add(file);
            }
            if (PreprocessDisassembleFilesHandler.hasDisassembler(file)) continue;
            return false;
        }
        this.selectedSourceFiles = sources;
        return true;
    }

    public static boolean hasDisassembler(IFile file) {
        if (file == null) {
            return false;
        }
        if (file.getFileExtension() == null) {
            return false;
        }
        if (file.getLocation() == null) {
            return false;
        }
        IProject project = file.getProject();
        if (!ManagedBuildManager.manages((IResource)project)) {
            return false;
        }
        IManagedBuildInfo builderInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (builderInfo == null) {
            return false;
        }
        IConfiguration configuration = builderInfo.getDefaultConfiguration();
        if (configuration == null) {
            return false;
        }
        String projectType = PreprocessDisassembleFilesHandler.getProjectTypeID(builderInfo);
        if (projectType.equals("")) {
            return false;
        }
        ITool disassembler = Disassembler.getDisassembler(configuration, file);
        return disassembler != null;
    }
}

