/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.AbstractGnuArmLaunchConfigurationDelegate;
import com.pemicro.debug.gdbjtag.pne.GdbServicesLaunchSequence;
import com.pemicro.debug.gdbjtag.pne.Launch;
import com.pemicro.debug.gdbjtag.pne.ServicesFactory;
import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;

public class LaunchConfigurationDelegate
extends AbstractGnuArmLaunchConfigurationDelegate {
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    ILaunchConfiguration fConfig = null;

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
        return new ServicesFactory(version);
    }

    protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        return new Launch(configuration, mode, locator);
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        return Utils.getGDBVersion(config);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.dsfgdbActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.getString((String)"GdbLaunchDelegate.0"), 10);
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal(launch);
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        boolean doAddSemihostingConsole;
        IProcess newProcess;
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal(l);
            return;
        }
        SessionType sessionType = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getSessionType((ILaunchConfiguration)config);
        boolean attach = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsAttach((ILaunchConfiguration)config);
        final GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.1"));
        } else if (sessionType == SessionType.CORE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.2"));
        } else {
            assert (sessionType == SessionType.LOCAL) : "Unexpected session type: " + sessionType.toString();
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.3"));
        }
        if (!attach) {
            this.checkBinaryDetails(config);
        }
        monitor.worked(1);
        String gdbVersion = this.getGDBVersion(config);
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config) && !this.isNonStopSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunchLocal((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Non-stop mode is not supported for GDB " + gdbVersion + ", GDB " + NON_STOP_FIRST_VERSION + " or higher is required.", null));
        }
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsPostMortemTracing((ILaunchConfiguration)config) && !this.isPostMortemTracingSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunchLocal((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Post-mortem tracing is not supported for GDB " + gdbVersion + ", GDB " + NON_STOP_FIRST_VERSION + " or higher is required.", null));
        }
        launch.setServiceFactory(this.newServiceFactory(config, gdbVersion));
        launch.initialize();
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        GdbServicesLaunchSequence servicesLaunchSequence = new GdbServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        boolean succeed = false;
        try {
            try {
                servicesLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Error in services launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    this.cleanupLaunchLocal((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunchLocal((ILaunch)launch);
            }
        }
        if (monitor.isCanceled()) {
            this.cleanupLaunchLocal((ILaunch)launch);
            return;
        }
        launch.initializeControl();
        boolean doAddServerConsole = config.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.USE_EXTERNAL_SERVER", true);
        if (doAddServerConsole) {
            newProcess = ((Launch)launch).addServerProcess(this.getServerCommandName(config));
            newProcess.setAttribute(IProcess.ATTR_CMDLINE, TabDebugger.getGdbServerCommandLine(config));
            monitor.worked(1);
        }
        newProcess = ((Launch)launch).addClientProcess(this.getClientCommandName(config));
        newProcess.setAttribute(IProcess.ATTR_CMDLINE, TabDebugger.getGdbClientCommandLine(config));
        monitor.worked(1);
        config.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
        boolean bl = doAddSemihostingConsole = config.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", true) && config.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", true) && config.getAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", true);
        if (doAddSemihostingConsole) {
            newProcess = ((Launch)launch).addSemihostingProcess("Semihosting Console");
            monitor.worked(1);
        }
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Query<Object> completeLaunchQuery = new Query<Object>((IProgressMonitor)subMon2){
            private final /* synthetic */ IProgressMonitor val$subMon2;
            {
                this.val$subMon2 = iProgressMonitor;
            }

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), this.val$subMon2){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        launch.getSession().getExecutor().execute((Runnable)completeLaunchQuery);
        succeed = false;
        try {
            try {
                completeLaunchQuery.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Error in final launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    this.cleanupLaunchLocal((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunchLocal((ILaunch)launch);
            }
        }
    }

    private String getServerCommandName(ILaunchConfiguration config) {
        String fullCommand = TabDebugger.getGdbServerCommand();
        if (fullCommand == null) {
            return null;
        }
        String[] parts = fullCommand.trim().split("/");
        return parts[parts.length - 1];
    }

    private String getClientCommandName(ILaunchConfiguration config) {
        String fullCommand = TabDebugger.getGdbClientCommand(config);
        if (fullCommand == null) {
            return null;
        }
        String[] parts = fullCommand.trim().split("/");
        return parts[parts.length - 1];
    }
}

