/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.Backend0;
import com.pemicro.debug.gdbjtag.pne.SemihostingProcess;
import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.ui.AdvancedProgrammingDialog;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;

public class Backend
extends Backend0 {
    private final ILaunchConfiguration fLaunchConfiguration;
    private Process fServerProcess;
    private Process fSemihostingProcess;
    private IMIBackend.State fServerBackendState = IMIBackend.State.NOT_INITIALIZED;
    private IMIBackend.State fSemihostingBackendState = IMIBackend.State.NOT_INITIALIZED;
    private int fGdbServerLaunchTimeout = 240;
    private ServerMonitorJob fServerMonitorJob;
    private SemihostingMonitorJob fSemihostingMonitorJob;
    private int fGdbServerExitValue = 0;
    private int fSemihostingExitValue = 0;
    private boolean doStartGdbServer = false;
    private boolean doStartSemihostingConsole = false;
    private static final String GDB_LAUNCH_FAILURE_MESSAGE = "The GDB Server was not able to establish a connection to the target processor. Please check your connections and power. Verify that the launch settings in the Debug Configuration are accurate. To run simultaneous debug sessions, please specify a unique Server Port and GDBMI Port in the Debug Configuration for each project.";

    public Backend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.fLaunchConfiguration = lc;
        try {
            this.doStartGdbServer = this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.USE_EXTERNAL_SERVER", true);
            this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
            this.doStartSemihostingConsole = this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", true) && this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", true) && this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", true);
        }
        catch (CoreException coreException) {}
    }

    public Process getServerProcess() {
        return this.fServerProcess;
    }

    public Process getSemihostingProcess() {
        return this.fSemihostingProcess;
    }

    protected Process launchSemihostingProcess(String host, int port) throws CoreException {
        SemihostingProcess proc = new SemihostingProcess(host, port);
        proc.submit();
        Utils.debugPrint("launchSemihostingProcess() return " + proc);
        return proc;
    }

    @Override
    public void destroy() {
        Utils.debugPrint("Backend.destroy() " + Thread.currentThread());
        boolean client_started = super.getState() == IMIBackend.State.STARTED;
        super.destroy();
        if (this.fSemihostingBackendState == IMIBackend.State.STARTED) {
            Utils.debugPrint("Backend.destroy() before fSemihostingProcess.destroy()");
            this.fSemihostingProcess.destroy();
        }
        if (this.fServerBackendState == IMIBackend.State.STARTED) {
            Utils.debugPrint("Backend.destroy() before fServerProcess.destroy()");
            if (client_started) {
                try {
                    this.fServerProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                Utils.debugPrint("Client was not started, force halting the server");
                this.fServerProcess.destroy();
            }
        }
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        Utils.debugPrint("Backend.initialize() " + Thread.currentThread());
        final Sequence.Step[] initializeSteps = this.doStartGdbServer ? new Sequence.Step[]{new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new ServerMonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new SemihostingConsoleStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new SemihostingMonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)} : new Sequence.Step[]{new SemihostingConsoleStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new SemihostingMonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    Backend.super.initialize(requestMonitor);
                } else {
                    requestMonitor.setStatus(this.getStatus());
                    requestMonitor.done();
                }
            }
        }){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    @Override
    public void shutdown(final RequestMonitor requestMonitor) {
        Utils.debugPrint("Backend.shutdown() " + Thread.currentThread());
        if (this.doStartGdbServer) {
            super.shutdown((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

                protected void handleSuccess() {
                    Backend.this.doShutdown(requestMonitor);
                }
            });
        } else {
            super.shutdown(requestMonitor);
        }
        Utils.debugPrint("Backend.shutdown() return");
    }

    private void doShutdown(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new SemihostingMonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new SemihostingConsoleStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new ServerMonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
        Utils.debugPrint("Backend.doShutdown() return");
    }

    protected class GdbServerStep
    extends GDBControl.InitializationShutdownStep {
        GdbServerStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            class ServerLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                ServerLaunchMonitor() {
                }
            }
            final ServerLaunchMonitor fServerLaunchMonitor = new ServerLaunchMonitor();
            final RequestMonitor fTmpLaunchRequestMonitor = new RequestMonitor((Executor)Backend.this.getExecutor(), requestMonitor){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    Utils.debugPrint("GdbServerStep initalise() handleCompleted()");
                    if (!fServerLaunchMonitor.fTimedOut) {
                        fServerLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startGdbServerJob = new Job("Start GDB Server Job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (fTmpLaunchRequestMonitor.isCanceled()) {
                        Utils.debugPrint("startGdbServerJob run cancel");
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(8, "com.pemicro.debug.gdbjtag.pne", -1, "Canceled starting GDB", null));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    String[] commandLineArray = TabDebugger.getGdbServerCommandLineArray(Backend.this.fLaunchConfiguration);
                    if (TabDebugger.getCorbaError() == 1) {
                        Utils.debugPrint("startGdbServerJob failed because corba ID  is blank");
                        fTmpLaunchRequestMonitor.done((IStatus)new Status(8, "com.pemicro.debug.gdbjtag.pne", 1, "There appears to be an issue with your network settings.\nThe gdb server was unable to start a required server component.Please contact technical support.", null));
                        return Status.CANCEL_STATUS;
                    }
                    if (AdvancedProgrammingDialog.getInitScriptPath() && !AdvancedProgrammingDialog.getMacPathExist()) {
                        Utils.debugPrint("Specified Initialization Script in Advanced Options is invalid or cannot be found");
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(8, "com.pemicro.debug.gdbjtag.pne", -1, "Specified Initialization Script in Advanced Options is invalid or cannot be found", null));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        File dir = Utils.getProjectOsPath(Backend.this.fLaunchConfiguration);
                        Backend.this.fServerProcess = Backend.this.launchGDBProcess(commandLineArray, dir);
                        Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                Utils.debugPrint("startGdbServerJob run() State.STARTED");
                                Backend.this.fServerBackendState = IMIBackend.State.STARTED;
                            }
                        });
                    }
                    catch (CoreException e) {
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", -1, e.getMessage(), (Throwable)e));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    InputStream stdout = Backend.this.fServerProcess.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
                    try {
                        String line;
                        boolean success = false;
                        String gdbErrorMessage = Backend.GDB_LAUNCH_FAILURE_MESSAGE;
                        while ((line = reader.readLine()) != null) {
                            if (line.contains("All Servers Running")) {
                                success = true;
                                break;
                            }
                            if (!line.contains("PEmicro GDB Launch Failure : ")) continue;
                            gdbErrorMessage = line;
                        }
                        if (!success) {
                            Utils.debugPrint("startGdbServerJob failed");
                            Backend.this.fServerProcess.destroy();
                            fTmpLaunchRequestMonitor.done((IStatus)new Status(8, "com.pemicro.debug.gdbjtag.pne", 1, gdbErrorMessage, null));
                            return Status.CANCEL_STATUS;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    fTmpLaunchRequestMonitor.done();
                    Utils.debugPrint("startGdbServerJob run completed");
                    return Status.OK_STATUS;
                }
            };
            startGdbServerJob.schedule();
            Utils.debugPrint("GdbServerStep initalise() after job schedule");
            Backend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (!fServerLaunchMonitor.fLaunched) {
                        fServerLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startGdbServerJob.getThread();
                        if (jobThread != null) {
                            Utils.debugPrint("interrupt thread " + jobThread);
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5010, "Timed out trying to launch GDB Server.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)Backend.this.fGdbServerLaunchTimeout, TimeUnit.SECONDS);
            Utils.debugPrint("GdbServerStep initalise() return");
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            if (Backend.this.fServerBackendState != IMIBackend.State.STARTED) {
                requestMonitor.done();
                return;
            }
            new Job("Terminating GDB Server process."){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Utils.debugPrint("GdbServerStep shutdown() run()");
                        Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                Utils.debugPrint("GdbServerStep shutdown() run() run()");
                                Backend.this.destroy();
                                if (((Backend)((GdbServerStep)(this).GdbServerStep.this).Backend.this).fServerMonitorJob.fMonitorExited) {
                                    Utils.debugPrint("GdbServerStep shutdown() run() run() State.TERMINATED");
                                    Backend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                                    Backend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(Backend.this.getSession().getId(), Backend.this.getId(), IMIBackend.State.TERMINATED), Backend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    Utils.debugPrint("GdbServerStep shutdown() run() before getting exitValue");
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            Backend.this.fGdbServerExitValue = Backend.this.fServerProcess.exitValue();
                            Utils.debugPrint("GdbServerStep shutdown() run() return");
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++attempts;
                        }
                    }
                    Utils.debugPrint("GdbServerStep shutdown() run() REQUEST_FAILED");
                    requestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10004, "GDB Server terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
            Utils.debugPrint("GdbServerStep shutdown() return");
        }
    }

    protected class SemihostingConsoleStep
    extends GDBControl.InitializationShutdownStep {
        SemihostingConsoleStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            if (!Backend.this.doStartSemihostingConsole) {
                requestMonitor.done();
                return;
            }
            class SemihostingLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                SemihostingLaunchMonitor() {
                }
            }
            final SemihostingLaunchMonitor fSemihostingLaunchMonitor = new SemihostingLaunchMonitor();
            final RequestMonitor fTmpLaunchRequestMonitor = new RequestMonitor((Executor)Backend.this.getExecutor(), requestMonitor){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    Utils.debugPrint("SemihostingConsoleStep initalise() handleCompleted()");
                    if (!fSemihostingLaunchMonitor.fTimedOut) {
                        fSemihostingLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startSemihostingJob = new Job("Start GDB Semihosting Job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (fTmpLaunchRequestMonitor.isCanceled()) {
                        Utils.debugPrint("startSemihostingJob run cancel");
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(8, "com.pemicro.debug.gdbjtag.pne", -1, "Canceled starting GDB semihosting", null));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        String host = Backend.this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
                        int port = Backend.this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", 51794);
                        Backend.this.fSemihostingProcess = Backend.this.launchSemihostingProcess(host, port);
                        Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                Utils.debugPrint("startSemihostingJob run State.STARTED");
                                Backend.this.fSemihostingBackendState = IMIBackend.State.STARTED;
                            }
                        });
                    }
                    catch (CoreException e) {
                        fTmpLaunchRequestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", -1, e.getMessage(), (Throwable)e));
                        fTmpLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    fTmpLaunchRequestMonitor.done();
                    Utils.debugPrint("startSemihostingJob run completed");
                    return Status.OK_STATUS;
                }
            };
            startSemihostingJob.schedule();
            Utils.debugPrint("SemihostingConsoleStep initalise() after job schedule");
            Backend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (!fSemihostingLaunchMonitor.fLaunched) {
                        fSemihostingLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startSemihostingJob.getThread();
                        if (jobThread != null) {
                            Utils.debugPrint("interrupt thread " + jobThread);
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5010, "Timed out trying to launch GDB Server.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)Backend.this.fGdbServerLaunchTimeout, TimeUnit.SECONDS);
            Utils.debugPrint("SemihostingConsoleStep initalise() return");
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            if (!Backend.this.doStartSemihostingConsole) {
                requestMonitor.done();
                return;
            }
            if (Backend.this.fSemihostingBackendState != IMIBackend.State.STARTED) {
                requestMonitor.done();
                return;
            }
            new Job("Terminating GDB semihosting process."){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Utils.debugPrint("SemihostingConsoleStep shutdown() run()");
                        Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                Utils.debugPrint("SemihostingConsoleStep shutdown() run() run()");
                                Backend.this.destroy();
                                if (((Backend)((SemihostingConsoleStep)(this).SemihostingConsoleStep.this).Backend.this).fSemihostingMonitorJob.fMonitorExited) {
                                    Utils.debugPrint("SemihostingConsoleStep shutdown() run() run() State.TERMINATED");
                                    Backend.this.fSemihostingBackendState = IMIBackend.State.TERMINATED;
                                    Backend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(Backend.this.getSession().getId(), Backend.this.getId(), IMIBackend.State.TERMINATED), Backend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    Utils.debugPrint("SemihostingConsoleStep shutdown() run() before getting exitValue");
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            Backend.this.fSemihostingExitValue = Backend.this.fSemihostingProcess.exitValue();
                            Utils.debugPrint("SemihostingConsoleStep shutdown() run() return");
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++attempts;
                        }
                    }
                    Utils.debugPrint("SemihostingConsoleStep shutdown() run() REQUEST_FAILED");
                    requestMonitor.setStatus((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 10004, "GDB semihosting terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
            Utils.debugPrint("SemihostingConsoleStep shutdown() return");
        }
    }

    private class SemihostingMonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fProcess;

        SemihostingMonitorJob(Process process, DsfRunnable monitorStarted) {
            super("Semihosting process monitor job.");
            this.fMonitorExited = false;
            this.fProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fProcess;
            synchronized (process) {
                Utils.debugPrint("SemihostingMonitorJob.run() submit " + this.fMonitorStarted + " thread " + this.getThread());
                Backend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fProcess.waitFor();
                    Backend.this.fSemihostingExitValue = this.fProcess.exitValue();
                    Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            Utils.debugPrint("SemihostingMonitorJob.run() run() thread " + SemihostingMonitorJob.this.getThread());
                            if (Backend.this.fSemihostingBackendState == IMIBackend.State.STARTED) {
                                Utils.debugPrint("fSemihostingProcess.destroy()");
                                Backend.this.fSemihostingProcess.destroy();
                            }
                            Utils.debugPrint("SemihostingMonitorJob.run() run() State.TERMINATED");
                            Backend.this.fSemihostingBackendState = IMIBackend.State.TERMINATED;
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                Utils.debugPrint("SemihostingMonitorJob.run() fMonitorExited = true thread " + this.getThread());
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    Utils.debugPrint("SemihostingMonitorJob.kill() interrupt " + this.getThread().toString());
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class SemihostingMonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        SemihostingMonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            if (!Backend.this.doStartSemihostingConsole) {
                requestMonitor.done();
                return;
            }
            Backend.this.fSemihostingMonitorJob = new SemihostingMonitorJob(Backend.this.fSemihostingProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            Backend.this.fSemihostingMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            if (!Backend.this.doStartSemihostingConsole) {
                requestMonitor.done();
                return;
            }
            Utils.debugPrint("SemihostingMonitorJobStep.shutdown()");
            if (Backend.this.fSemihostingMonitorJob != null) {
                ((SemihostingProcess)((Backend)Backend.this).fSemihostingProcess).i = 0;
                Backend.this.fSemihostingMonitorJob.kill();
            }
            requestMonitor.done();
            Utils.debugPrint("SemihostingMonitorJobStep.shutdown() return");
        }
    }

    private class ServerMonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fProcess;

        ServerMonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB Server process monitor job.");
            this.fMonitorExited = false;
            this.fProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fProcess;
            synchronized (process) {
                Utils.debugPrint("ServerMonitorJob.run() submit " + this.fMonitorStarted + " thread " + this.getThread());
                Backend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                try {
                    this.fProcess.waitFor();
                    Backend.this.fGdbServerExitValue = this.fProcess.exitValue();
                    Backend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            Utils.debugPrint("ServerMonitorJob.run() run() thread " + ServerMonitorJob.this.getThread());
                            Backend.this.destroy();
                            Utils.debugPrint("ServerMonitorJob.run() run() State.TERMINATED");
                            Backend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                            Backend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(Backend.this.getSession().getId(), Backend.this.getId(), IMIBackend.State.TERMINATED), Backend.this.getProperties());
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                Utils.debugPrint("ServerMonitorJob.run() fMonitorExited = true thread " + this.getThread());
                this.fMonitorExited = true;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    Utils.debugPrint("ServerMonitorJob.kill() interrupt " + this.getThread().toString());
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class ServerMonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        ServerMonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            Backend.this.fServerMonitorJob = new ServerMonitorJob(Backend.this.fServerProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            Backend.this.fServerMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            Utils.debugPrint("ServerMonitorJobStep.shutdown()");
            if (Backend.this.fServerMonitorJob != null) {
                Backend.this.fServerMonitorJob.kill();
            }
            requestMonitor.done();
            Utils.debugPrint("ServerMonitorJobStep.shutdown() return");
        }
    }
}

