/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageContentProvider;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageLabelProvider;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class SDKTableViewerHolder {
    public static final int[] COLUMN_SIZES = new int[]{50, 150, 70, 150, 300};
    public static final int STATIC_COLUMNS = 3;
    private static final SDKSorter sorter = new SDKSorter();

    public static CheckboxTableViewer newCheckList(Composite composite) {
        CheckboxTableViewer v = new CheckboxTableViewer(SDKTableViewerHolder.createTable(composite, 32));
        SDKTableViewerHolder.setup(composite, (TableViewer)v, null, null);
        return v;
    }

    public static TableViewer newSelList(Composite composite, IProject prj, Map<String, Boolean[]> data) {
        TableViewer v = new TableViewer(SDKTableViewerHolder.createTable(composite));
        SDKTableViewerHolder.setup(composite, v, prj, data);
        return v;
    }

    public static TableViewer newList(Composite composite) {
        TableViewer v = new TableViewer(SDKTableViewerHolder.createTable(composite));
        SDKTableViewerHolder.setup(composite, v, null, null);
        return v;
    }

    private static Table createTable(Composite composite) {
        return SDKTableViewerHolder.createTable(composite, 0);
    }

    private static Table createTable(Composite composite, int style) {
        Table t = new Table(composite, 0x10A02 | style);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = t.getItemHeight() * 7;
        t.setLayoutData((Object)gd);
        return t;
    }

    private static void setup(Composite tableComposite, final TableViewer viewer, IProject prj, Map<String, Boolean[]> data) {
        TableViewerColumn name = new TableViewerColumn(viewer, 0);
        name.getColumn().setText(Messages.SDKTableViewerHolder_name_column_text);
        name.getColumn().setWidth(COLUMN_SIZES[1]);
        name.setLabelProvider(SDKPageLabelProvider.getNameLabelProvider());
        TableViewerColumn version = new TableViewerColumn(viewer, 0);
        version.getColumn().setText(Messages.SDKTableViewerHolder_version_column_text);
        version.getColumn().setWidth(COLUMN_SIZES[2]);
        version.setLabelProvider(SDKPageLabelProvider.getVersionLabelProvider());
        TableViewerColumn status = new TableViewerColumn(viewer, 0);
        status.getColumn().setText(Messages.SDKTableViewerHolder_status_column_text);
        status.getColumn().setWidth(COLUMN_SIZES[3]);
        status.setLabelProvider(SDKPageLabelProvider.getStatusLabelProvider());
        TableViewerColumn[] cols = null;
        if (prj != null) {
            IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)prj).getManagedProject().getConfigurations();
            cols = new TableViewerColumn[cfgs.length];
            int i = 0;
            while (i < cfgs.length) {
                String cname = cfgs[i].getName();
                cols[i] = new TableViewerColumn(viewer, 0);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)cols[i].getViewer());
                cols[i].getColumn().setText(cname);
                cols[i].getColumn().setToolTipText(cname);
                cols[i].getColumn().setWidth(COLUMN_SIZES[0]);
                cols[i].setLabelProvider(SDKPageLabelProvider.getCfgLabelProvider(i, data, cfgs.length, cfgs[i]));
                ++i;
            }
        }
        TableViewerColumn desc = new TableViewerColumn(viewer, 0);
        desc.getColumn().setText(Messages.SDKTableViewerHolder_description_column_text);
        desc.getColumn().setWidth(COLUMN_SIZES[4]);
        desc.setLabelProvider(SDKPageLabelProvider.getDescriptionLabelProvider());
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int n = (Integer)event.widget.getData();
                sorter.setSort(n--);
                viewer.getTable().setSortColumn(viewer.getTable().getColumn(n < 3 ? n : viewer.getTable().getColumnCount() - 1));
                viewer.getTable().setSortDirection(sorter.dir == 1 ? 1024 : 128);
                viewer.refresh();
            }
        };
        name.getColumn().addSelectionListener((SelectionListener)selListener);
        name.getColumn().setData((Object)new Integer(1));
        version.getColumn().addSelectionListener((SelectionListener)selListener);
        version.getColumn().setData((Object)new Integer(2));
        status.getColumn().addSelectionListener((SelectionListener)selListener);
        status.getColumn().setData((Object)new Integer(3));
        desc.getColumn().addSelectionListener((SelectionListener)selListener);
        desc.getColumn().setData((Object)new Integer(4));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[1]));
        tableLayout.setColumnData((Widget)version.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[2]));
        tableLayout.setColumnData((Widget)status.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[3]));
        if (cols != null) {
            TableViewerColumn[] tableViewerColumnArray = cols;
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                TableViewerColumn col = tableViewerColumnArray[n2];
                tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[0]));
                ++n2;
            }
        }
        tableLayout.setColumnData((Widget)desc.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[4]));
        viewer.setContentProvider((IContentProvider)new SDKPageContentProvider());
        viewer.setComparator((ViewerComparator)sorter);
    }

    private static class SDKSorter
    extends ViewerComparator {
        private int col = 0;
        private int dir = 0;

        private SDKSorter() {
        }

        public void setSort(int column) {
            if (column == this.col) {
                this.dir = 1 - this.dir;
            } else {
                this.col = column;
                this.dir = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int res = 0;
            ISDK sdk1 = (ISDK)e1;
            ISDK sdk2 = (ISDK)e2;
            switch (this.col) {
                case 1: {
                    res = sdk1.getName().toLowerCase().compareTo(sdk2.getName().toLowerCase());
                    break;
                }
                case 2: {
                    res = sdk1.getVersion().toLowerCase().compareTo(sdk2.getVersion().toLowerCase());
                    break;
                }
                case 3: {
                    res = sdk1.getStatusText().toLowerCase().compareTo(sdk2.getStatusText().toLowerCase());
                    break;
                }
                case 4: {
                    res = sdk1.getDescription().toLowerCase().compareTo(sdk2.getDescription().toLowerCase());
                    break;
                }
            }
            return this.dir == 0 ? res : -res;
        }
    }
}

