/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class SDKLatestVersionFilter
implements ISDKFilter {
    private Map<String, TreeSet<String>> sdkVersions;
    private final boolean isGlobal;
    private ISDKFilter preFilter;

    public SDKLatestVersionFilter() {
        this(false);
    }

    public SDKLatestVersionFilter(ISDKFilter preFilter) {
        this(false);
        this.preFilter = preFilter;
    }

    public SDKLatestVersionFilter(boolean onlyGlobal) {
        this.isGlobal = onlyGlobal;
    }

    @Override
    public boolean accept(ISDK sdk) {
        TreeSet<String> versions = this.getSDKVersions().get(this.getVerionsMapKey(sdk));
        return versions != null && versions.last().equals(sdk.getVersion()) && (!this.isGlobal || !(sdk instanceof IProjectLocalSDK));
    }

    private Map<String, TreeSet<String>> getSDKVersions() {
        if (this.sdkVersions == null) {
            this.sdkVersions = new HashMap<String, TreeSet<String>>();
            if (this.preFilter != null) {
                SDKUtils.filter(this.preFilter).forEach(sdk -> this.addVersion((ISDK)sdk));
            } else {
                SDKUtils.filter(SDKUtils.NO_FILTER).forEach(sdk -> this.addVersion((ISDK)sdk));
            }
        }
        return this.sdkVersions;
    }

    private void addVersion(ISDK sdk) {
        String key = this.getVerionsMapKey(sdk);
        TreeSet<String> versions = this.sdkVersions.get(key);
        if (versions == null) {
            versions = new TreeSet();
        }
        versions.add(sdk.getVersion());
        this.sdkVersions.put(key, versions);
    }

    private String getVerionsMapKey(ISDK sdk) {
        return String.valueOf(sdk.getName().toLowerCase()) + "@" + (Object)((Object)sdk.getType());
    }
}

