/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.availability;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class SDKMissedMarkerHandler {
    private static final String MISSED_SDK_MARKER_TYPE = "com.freescale.s32ds.cross.sdk.support.MissedSDKMarker";

    public static void create(List<String> missedSDKs, IProject project) {
        missedSDKs.forEach(id -> SDKMissedMarkerHandler.create(id, project));
    }

    public static void create(ISDK missedSDK, IProject project, String message) {
        SDKMissedMarkerHandler.create(missedSDK.getId(), project, message);
    }

    public static void create(String missedSDKId, IProject project, String message) {
        try {
            IMarker marker = project.createMarker(MISSED_SDK_MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)project);
            marker.setAttribute("sdkId", (Object)missedSDKId);
        }
        catch (CoreException ce) {
            SDKSupportPlugin.log(ce.getMessage());
        }
    }

    public static void create(String missedSDKId, IProject project) {
        try {
            IMarker marker = project.createMarker(MISSED_SDK_MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)String.format("SDK Id=%s for the Project \"%s\" is not found.", missedSDKId, project.getName()));
            marker.setAttribute("location", (Object)project);
            marker.setAttribute("sdkName", (Object)missedSDKId);
        }
        catch (CoreException ce) {
            SDKSupportPlugin.log(ce.getMessage());
        }
    }

    public static void delete(IProject project) {
        try {
            project.deleteMarkers(MISSED_SDK_MARKER_TYPE, false, 0);
        }
        catch (CoreException ce) {
            SDKSupportPlugin.log(ce.getMessage());
        }
    }
}

