/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.updater.service.impl;

import com.nxp.s32ds.ext.ide.core.updater.service.impl.ProjectUpdaterServiceObject;
import com.nxp.s32ds.ext.ide.core.updater.service.impl.ProjectUpdaterServiceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProjectUpdaterServiceJob
extends WorkspaceJob {
    String searchTarget;
    String searchTxt;
    String replaceTxt;
    IProject[] projects = null;

    public ProjectUpdaterServiceJob(String jobName, IProject[] projects, String searchTarget, String searchTxt, String replaceTxt) {
        super(jobName);
        this.setSystem(true);
        this.setUser(false);
        this.searchTarget = searchTarget;
        this.searchTxt = searchTxt;
        this.replaceTxt = replaceTxt;
        this.projects = projects;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IStatus status = Status.OK_STATUS;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.projects == null) {
            return Status.CANCEL_STATUS;
        }
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectUpdaterServiceObject upTcObject;
            IProject iter = iProjectArray[n2];
            if (ProjectUpdaterServiceUtil.isCCPPNatureProject(iter) && (upTcObject = ProjectUpdaterServiceUtil.searchUpdateObject(iter, this.searchTarget, this.searchTxt, this.replaceTxt)).isContainsChanges()) {
                try {
                    monitor.beginTask("", -1);
                    status = ProjectUpdaterServiceUtil.applyUpdateObject(upTcObject);
                    iter.deleteMarkers(null, false, 2);
                    iter.refreshLocal(2, monitor);
                }
                finally {
                    monitor.done();
                }
            }
            ++n2;
        }
        return status;
    }
}

