/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license;

import com.nxp.s32ds.ext.rcp.license.IFeatureId;
import com.nxp.s32ds.ext.rcp.license.ILicenseModel;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.Messages;
import com.nxp.s32ds.ext.rcp.license.cll.LicenseException;
import java.util.Map;

public class LicenseFeature {
    private final IFeatureId licenseFeatureId;
    private String label;
    private boolean required;
    private boolean refresh = true;
    private LicenseStatus cachedStatus = null;
    private final ILicenseModel licenseModel;
    private String howToActivate;
    private String howToProlonge;

    public LicenseFeature(IFeatureId licenseFeatureId, ILicenseModel licenseModel) {
        this.licenseFeatureId = licenseFeatureId;
        this.licenseModel = licenseModel;
    }

    public ILicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String getLabel() {
        if (this.licenseModel.isTestMode()) {
            return String.valueOf(this.label) + " (TEST MODE!)";
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.getLicenseModel().getModelDetails();
    }

    public boolean isEnabled() {
        return this.getStatus() == LicenseStatus.ACTIVATED || this.getStatus() == LicenseStatus.EVALUATION;
    }

    public IFeatureId getFeatureId() {
        return this.licenseFeatureId;
    }

    public String getStatusText() {
        switch (this.getStatus()) {
            case INITIALIZATION_ERROR: {
                return Messages.getString("Extension_initError", new Object[]{"unknown error"});
            }
            case ACTIVATED: {
                return Messages.getString("Extension_activated", null);
            }
            case EXPIRED: {
                return Messages.getString("Extension_licenseExpired", null);
            }
            case EVALUATION: {
                int daysLeft = this.getDaysLeft();
                if (daysLeft < 0) {
                    this.resetCache();
                    if (this.getStatus() == LicenseStatus.EVALUATION) {
                        return Messages.getString("Extension_initError", new Object[]{"unknown error"});
                    }
                    return this.getStatusText();
                }
                return Messages.getString("Extension_licenseExpiring", new Object[]{daysLeft});
            }
            case MISSED: {
                return Messages.getString("Extension_licenseMissing", null);
            }
        }
        return "";
    }

    public int getEvaluationDays() {
        return this.getDaysLeft();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LicenseFeature [id=").append(this.licenseFeatureId).append(", label=").append(this.label).append(", licenseModel=").append(this.licenseModel).append("]");
        return builder.toString();
    }

    private int getDaysLeft() {
        if (this.licenseModel == null) {
            return -1;
        }
        return this.licenseModel.getEvaluationDays(this.licenseFeatureId);
    }

    public LicenseStatus getStatus() {
        if (this.licenseModel == null) {
            return LicenseStatus.INITIALIZATION_ERROR;
        }
        if (this.cachedStatus == null) {
            this.cachedStatus = this.licenseModel.getStatus(this.licenseFeatureId);
        }
        return this.cachedStatus;
    }

    public String getActivationId() {
        if (this.licenseModel == null) {
            return "ERROR";
        }
        return this.licenseModel.getActivationId(this.licenseFeatureId);
    }

    public IFeatureId getLicenseFeatureId() {
        return this.licenseFeatureId;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getVersion() {
        return this.getFeatureId().getVersion();
    }

    public void activate(String id, Map<String, String> params) throws LicenseException {
        this.cachedStatus = null;
        this.licenseModel.activate(id, params);
    }

    public void refresh() {
        this.cachedStatus = null;
        this.licenseModel.refreshFeature(this.licenseFeatureId);
    }

    public void returnLicense(String id, Map<String, String> params) throws LicenseException {
        this.cachedStatus = null;
        this.licenseModel.returnFeature(id, params);
    }

    public String getHowToActivate() {
        return this.howToActivate;
    }

    public void setHowToActivate(String howToActivate) {
        this.howToActivate = howToActivate;
    }

    public String getHowToProlonge() {
        return this.howToProlonge;
    }

    public void setHowToProlonge(String howToProlonge) {
        this.howToProlonge = howToProlonge;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void resetCache() {
        this.cachedStatus = null;
    }
}

