/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLCCorePlugin;
import com.freescale.s32ds.cdt.core.OutputLine;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.cdt.core.ProblemMarkerInfo;

public class OutputLineQueue {
    private final LinkedList<OutputLine> lines = new LinkedList();

    public void add(OutputLine line) {
        this.lines.addLast(line);
    }

    public OutputLine getFirst() {
        return this.lines.peek();
    }

    public OutputLine pollDone() {
        OutputLine line = this.getFirst();
        return line != null && line.isDone() ? this.lines.poll() : null;
    }

    public void setAllDone() {
        this.lines.stream().forEach(FuncUtils.bindConsumer(OutputLine::setDone, (Object)true));
    }

    public void setDone(String lineStr, ProblemMarkerInfo marker) {
        ListIterator<OutputLine> it = this.getLineIterator(lineStr);
        if (it.hasNext()) {
            OutputLine line = it.next();
            line.setDone(true);
            line.setInfo(marker);
            this.setNextDuplicatedMarker(marker, it);
        } else {
            this.logError(lineStr);
        }
    }

    private ListIterator<OutputLine> getLineIterator(String lineStr) {
        ListIterator<OutputLine> it = this.lines.listIterator();
        while (it.hasNext()) {
            OutputLine ol = it.next();
            if (ol.getLine() != lineStr && ol.getAlias() != lineStr) continue;
            it.previous();
            return it;
        }
        return it;
    }

    private void setNextDuplicatedMarker(ProblemMarkerInfo marker, ListIterator<OutputLine> it) {
        while (it.hasNext()) {
            OutputLine nextLine = it.next();
            if (!nextLine.isDuplicated() || !nextLine.isDone()) break;
            nextLine.setInfo(marker);
        }
    }

    public void registerAlias(String lineStr, String alias) {
        ListIterator<OutputLine> it = this.getLineIterator(lineStr);
        if (it.hasNext()) {
            it.next().setAlias(alias);
        } else {
            this.logError(lineStr);
        }
    }

    private void logError(String lineStr) {
        FSLCCorePlugin.log(new IllegalArgumentException("Line " + lineStr + " wasn't registered in the queue!"));
    }
}

