/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.data;

import com.pemicro.forms.chip.data.PinData;

public class ChipData {
    public static final int ICD = 0;
    public static final int ICS = 1;
    private static ChipData data;
    private PinData[] allPinData;
    private int chipType = 0;
    private String deviceName = "";
    private String freq = "";
    private String cycles = "";
    private String packageType = "";
    private int numOfPins = 0;
    private int numOfSides = 0;

    public static synchronized ChipData getInstance() {
        if (data != null) {
            return data;
        }
        data = new ChipData();
        return data;
    }

    public int getPinDataNumber(String pinName, String signalName) {
        int number = -1;
        int i = 0;
        while (i < this.allPinData.length) {
            if (this.allPinData[i].getModuleName().toLowerCase().equals(pinName.toLowerCase()) && this.allPinData[i].getSignalName().equals(signalName)) {
                number = this.allPinData[i].getNumber();
            }
            ++i;
        }
        return number;
    }

    public int getChipType() {
        return this.chipType;
    }

    public void setChipType(short chipType) {
        this.chipType = chipType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getFreq() {
        return this.freq;
    }

    public void setFreq(String freq) {
        this.freq = freq;
    }

    public String getCycles() {
        return this.cycles;
    }

    public void setCycles(String cycles) {
        this.cycles = cycles;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public int getNumOfPins() {
        return this.numOfPins;
    }

    public void setNumOfPins(int numOfPins) {
        this.numOfPins = numOfPins;
        this.allPinData = new PinData[numOfPins];
        int i = 0;
        while (i < this.allPinData.length) {
            this.allPinData[i] = new PinData();
            ++i;
        }
    }

    public int getNumOfSides() {
        return this.numOfSides;
    }

    public void setNumOfSides(int numOfSides) {
        this.numOfSides = numOfSides;
    }

    public void setPinData(int number, PinData pinData) {
        int i = 0;
        while (i < this.allPinData.length) {
            if (this.allPinData[i].getNumber() == number) {
                this.allPinData[i] = pinData;
            }
            ++i;
        }
    }

    public PinData[] getPinData() {
        return this.allPinData;
    }

    public PinData getPinData(int number) {
        PinData data = null;
        int i = 0;
        while (i < this.allPinData.length) {
            if (this.allPinData[i].getNumber() == number) {
                data = this.allPinData[i];
            }
            ++i;
        }
        return data;
    }

    public int getUndisplayedCount() {
        int available = 0;
        int i = 0;
        while (i < this.allPinData.length) {
            if (!this.allPinData[i].isDisplayed()) {
                ++available;
            }
            ++i;
        }
        return available;
    }

    public int getDisplayedCount() {
        int displayed = 0;
        int i = 0;
        while (i < this.allPinData.length) {
            if (this.allPinData[i].isDisplayed()) {
                ++displayed;
            }
            ++i;
        }
        return displayed;
    }
}

