/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;

public class AlgorithmParser {
    private HashMap<Long, Byte> Memory = new HashMap();
    private Long baseAddress;
    private static final String runningAlgorithmHeader = "RUNNING_ALGORITHM";
    private boolean runningAlgorithm = false;

    public void parseSRecords(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            boolean endOfFile = false;
            boolean baseAddressFound = false;
            block8: while (!endOfFile) {
                String line = br.readLine();
                if (line.length() == 0) continue;
                if (!endOfFile) {
                    byte[] srecData;
                    Long srecAddress;
                    String firstChar;
                    if (line.contains(runningAlgorithmHeader)) {
                        this.runningAlgorithm = true;
                    }
                    int srecType = (firstChar = Character.toString(line.charAt(0))).matches("S") || firstChar.matches("s") ? Character.getNumericValue(line.charAt(1)) : 100;
                    switch (srecType) {
                        case 1: {
                            int srecByteCount = Integer.parseInt(line.substring(2, 4), 16);
                            srecAddress = Long.parseLong(line.substring(4, 8), 16);
                            srecData = DatatypeConverter.parseHexBinary((String)line.substring(8, srecByteCount * 2 + 2));
                            break;
                        }
                        case 2: {
                            int srecByteCount = Integer.parseInt(line.substring(2, 4), 16);
                            srecAddress = Long.parseLong(line.substring(4, 10), 16);
                            srecData = DatatypeConverter.parseHexBinary((String)line.substring(10, srecByteCount * 2 + 2));
                            break;
                        }
                        case 3: {
                            int srecByteCount = Integer.parseInt(line.substring(2, 4), 16);
                            srecAddress = Long.parseLong(line.substring(4, 12), 16);
                            srecData = DatatypeConverter.parseHexBinary((String)line.substring(12, srecByteCount * 2 + 2));
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            endOfFile = true;
                        }
                        default: {
                            continue block8;
                        }
                    }
                    if (!baseAddressFound) {
                        baseAddressFound = true;
                        this.baseAddress = srecAddress;
                    }
                    int i = 0;
                    while (i < srecData.length) {
                        this.Memory.put(srecAddress + (long)i, srecData[i]);
                        ++i;
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
    }

    public byte[] getCommandTable() {
        Long numberCommandsLocation = (this.Memory.get(this.baseAddress + 32L) & 0xFF) + ((this.Memory.get(this.baseAddress + 32L + 1L) & 0xFF) << 8) + ((this.Memory.get(this.baseAddress + 32L + 2L) & 0xFF) << 16) + ((this.Memory.get(this.baseAddress + 32L + 3L) & 0xFF) << 24);
        int numberCommands = (this.Memory.get(numberCommandsLocation) & 0xFF) + ((this.Memory.get(numberCommandsLocation + 1L) & 0xFF) << 8) + ((this.Memory.get(numberCommandsLocation + 2L) & 0xFF) << 16) + ((this.Memory.get(numberCommandsLocation + 3L) & 0xFF) << 24);
        Long cmdTableBaseAddress = numberCommandsLocation + 4L;
        byte[] cmdTable = new byte[numberCommands];
        int i = 0;
        while (i < numberCommands) {
            cmdTable[i] = this.Memory.get(cmdTableBaseAddress + (long)i);
            ++i;
        }
        return cmdTable;
    }

    public boolean isRunningAlgorithm() {
        return this.runningAlgorithm;
    }
}

