/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.api;

import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.api.IPemicroUtil;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class PemicroUtil
implements IPemicroUtil {
    @Override
    public String convertFreescaleDevice(String freescaleDevice) {
        Pattern p = Pattern.compile("[MPS]([A-Z]+[A\\d]+[A-Z]+\\d+(?:M\\d+)?[AZ]?)[A-Zx]+(\\d+)");
        Matcher m = p.matcher(freescaleDevice);
        String pe_string = "";
        if (!m.find()) {
            return "";
        }
        pe_string = String.valueOf(m.group(1)) + 'M' + m.group(2);
        String family = PemicroUtil.getPemicroFamily(pe_string);
        if (family.isEmpty()) {
            return "";
        }
        pe_string = "NXP_" + family + "_" + pe_string;
        return pe_string;
    }

    @Override
    public ArrayList<String> getSupportedDeviceNames() {
        return Utils.getAvailableDevices();
    }

    @Override
    public boolean setPemicroDevice(String freescaleDevice, ILaunchConfigurationWorkingCopy config) {
        String pe_string = this.convertFreescaleDevice(freescaleDevice);
        if (pe_string.isEmpty()) {
            return false;
        }
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", pe_string);
        return true;
    }

    @Override
    public boolean setNativePemicroDevice(String pemicroDevice, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", pemicroDevice);
        return true;
    }

    @Override
    public ArrayList<IPemicroUtil.PemicroInterface> getPemicroInterfaces() {
        ArrayList<TabDebugger.HardwarePorts> detectedHardware = TabDebugger.getHardwarePorts();
        ArrayList<IPemicroUtil.PemicroInterface> result = new ArrayList<IPemicroUtil.PemicroInterface>();
        int i = 0;
        while (i < detectedHardware.size()) {
            TabDebugger.HardwarePorts currentIface = detectedHardware.get(i);
            int j = 0;
            while (j < currentIface.ports.size()) {
                IPemicroUtil.PemicroInterface temp = new IPemicroUtil.PemicroInterface();
                temp.interfaceEnum = IPemicroUtil.interfaceType.values()[i];
                temp.port = j;
                temp.humanString = currentIface.comboStrings.get(j);
                temp.portString = currentIface.ports.get(j);
                result.add(temp);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void setInterfaceType(IPemicroUtil.PemicroInterface iface, ILaunchConfigurationWorkingCopy config) {
        String postfix = "";
        switch (iface.interfaceEnum) {
            case MULTILINK: {
                postfix = ".ml.";
                break;
            }
            case CYCLONE_SERIAL: {
                postfix = ".cyc_ser.";
                break;
            }
            case CYCLONE_USB: {
                postfix = ".cyc_usb.";
                break;
            }
            case CYCLONE_ETHERNET: {
                postfix = ".cyc_eth.";
                break;
            }
            case TRACELINK_USB: {
                postfix = ".trc_usb.";
                break;
            }
            case TRACELINK_ETHERNET: {
                postfix = ".trc_eth.";
                break;
            }
            case OPENSDA: {
                postfix = ".sda.";
            }
        }
        String attributeHeader = "com.pemicro.debug.gdbjtag.pne" + postfix;
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", iface.port);
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", iface.portString);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", iface.interfaceEnum.ordinal());
    }

    @Override
    public boolean setGdbClientPath(String path, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", path);
        return true;
    }

    @Override
    public boolean setSemihosting(IPemicroUtil.SemihostingConfiguration settings, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", settings.semihostingEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", settings.telnetEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientGdbClient", settings.gdbClientEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", settings.telnetPort);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", settings.telnetConsoleEnabled);
        return true;
    }

    public static String getPemicroFamily(String deviceName) {
        if (deviceName.startsWith("WPR")) {
            return "Sensors";
        }
        Pattern p = Pattern.compile("K(?:L?\\d|[EMSVW])");
        Matcher m = p.matcher(deviceName);
        if (m.find()) {
            String family = m.group();
            return String.valueOf(family) + "x";
        }
        return "";
    }
}

