/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.suppliers;

import com.nxp.s32ds.ext.cdt.suppliers.DefaultPreferences;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import com.nxp.s32ds.ext.ide.utils.PreferencesUtils;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PersistentPreferences {
    public static final String TOOLCHAIN_NAME_KEY = "toolchain.name";
    private static final String TOOLCHAIN_PATH_KEY = "toolchain.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_KEY = "toolchain.search.path.%d";
    private static final String TOOLCHAIN_SEARCH_PATH_OS_KEY = "toolchain.search.path.%s.%d";
    public static final String BUILD_TOOLS_PATH_KEY = "buildTools.path";
    public static final String GLOBAL_TOOLCHAIN_PATH_STRICT = "global.toolchain.path.strict";
    public static final String GLOBAL_BUILDTOOLS_PATH_STRICT = "global.buildTools.path.strict";
    public static final String WORKSPACE_TOOLCHAIN_PATH_STRICT = "workspace.toolchain.path.strict";
    public static final String WORKSPACE_BUILDTOOLS_PATH_STRICT = "workspace.buildTools.path.strict";

    private static String getString(String key, String defaultValue, IProject project) {
        String value = PreferencesUtils.getPreferenceValueForId((String)"com.nxp.s32ds.ext.cdt.core", (String)key, null, (IProject)project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = (String)SharedDefaults.getInstance().getSharedDefaultsMap().get("com.nxp.s32ds.ext.cdt.core." + key);
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    private static String getEclipseString(String key, String defaultValue) {
        return ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").get(key, defaultValue);
    }

    private static String getWorkspaceString(String key, String defaultValue) {
        return InstanceScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").get(key, defaultValue);
    }

    private static void putString(String key, String value) {
        String oldValue = PersistentPreferences.getWorkspaceString(key, null);
        if (oldValue != null) {
            PersistentPreferences.putWorkspaceString(key, value);
        } else {
            PersistentPreferences.putEclipseString(key, value);
        }
    }

    private static void putEclipseString(String key, String value) {
        ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").put(key, value.trim());
    }

    private static void putWorkspaceString(String key, String value) {
        InstanceScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").put(key, value.trim());
    }

    public static void flush() {
        try {
            ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").flush();
            InstanceScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core").flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static void putProjectString(String key, String value, IProject project) {
        new ProjectScope(project).getNode("com.nxp.s32ds.ext.cdt.core").put(key, value.trim());
    }

    public static void flush(IProject project) {
        try {
            new ProjectScope(project).getNode("com.nxp.s32ds.ext.cdt.core").flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static String getToolchainName() {
        String toolchainName = PersistentPreferences.getString(TOOLCHAIN_NAME_KEY, null, null);
        if (toolchainName != null && !toolchainName.isEmpty()) {
            return toolchainName;
        }
        return DefaultPreferences.getToolchainName();
    }

    public static void putToolchainName(String toolchainName) {
        PersistentPreferences.putString(TOOLCHAIN_NAME_KEY, toolchainName);
    }

    public static String getToolchainKey(String toolchainName) {
        return String.format(TOOLCHAIN_PATH_KEY, Math.abs(toolchainName.trim().hashCode()));
    }

    public static String getToolchainPath(String toolchainName, IProject project) {
        String value = PersistentPreferences.getString(PersistentPreferences.getToolchainKey(toolchainName), null, project);
        return value != null && !value.isEmpty() ? value : DefaultPreferences.getToolchainPath(toolchainName);
    }

    public static void putToolchainPath(String toolchainName, String path) {
        PersistentPreferences.putString(PersistentPreferences.getToolchainKey(toolchainName), path);
    }

    public static void putToolchainPath(String toolchainName, String path, IProject project) {
        PersistentPreferences.putProjectString(PersistentPreferences.getToolchainKey(toolchainName), path, project);
    }

    public static String getToolchainSearchKey(String toolchainName) {
        return String.format(TOOLCHAIN_SEARCH_PATH_KEY, Math.abs(toolchainName.trim().hashCode()));
    }

    public static String getToolchainSearchOsKey(String toolchainName) {
        return String.format(TOOLCHAIN_SEARCH_PATH_OS_KEY, OSFamily.current.family, Math.abs(toolchainName.trim().hashCode()));
    }

    public static String getBuildToolsPath(IProject project) {
        return PersistentPreferences.getString(BUILD_TOOLS_PATH_KEY, "", project);
    }
}

