/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.suppliers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathEnvironmentVariable
implements IBuildEnvironmentVariable {
    public static String name = "PATH";
    public static String START_BRACKET = "${";
    public static String END_BRACKET = "}";
    private List<String> paths = new ArrayList<String>();

    protected PathEnvironmentVariable(List<String> paths) {
        this.paths.addAll(paths);
    }

    public String getDelimiter() {
        return Platform.getOS().equals("win32") ? ";" : ":";
    }

    public String getName() {
        return name;
    }

    public int getOperation() {
        return 3;
    }

    public String getValue() {
        String value = "";
        for (String p : this.paths) {
            if (p.isEmpty()) continue;
            value = value.isEmpty() ? p : value.concat(String.valueOf(this.getDelimiter()) + p);
        }
        return value;
    }

    public static PathEnvironmentVariable create(IConfiguration configuration, String variable) {
        return PathEnvironmentVariable.create(configuration, new String[]{variable});
    }

    public static PathEnvironmentVariable create(IConfiguration configuration, String[] variables) {
        return new PathEnvironmentVariable(PathEnvironmentVariable.getPaths(configuration, variables));
    }

    protected static List<String> getPaths(IConfiguration configuration, String[] variables) {
        IToolChain toolchain = configuration.getToolChain();
        IOption option = toolchain.getOptionBySuperClassId("cdt.managedbuild.option.gnu.cross.path");
        String toolchainPathString = option == null ? "" : (String)option.getValue();
        File sysroot = new File(toolchainPathString = PathEnvironmentVariable.resolveMacro(toolchainPathString, configuration));
        File bin = new File(sysroot, "bin");
        if (bin.isDirectory()) {
            sysroot = bin;
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(sysroot.getAbsolutePath());
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            Path pathFromVariable = new Path(PathEnvironmentVariable.resolveMacro(variable, configuration));
            paths.add(pathFromVariable.toOSString());
            ++n2;
        }
        return paths;
    }

    public static boolean isVar(String name) {
        return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
    }

    private static String resolveMacroRecursive(String value, IConfiguration configuration) {
        if (-1 != value.indexOf(START_BRACKET)) {
            String returnedVal = null;
            try {
                returnedVal = ManagedBuildManager.getBuildMacroProvider().resolveValue(value, "", " ", 3, (Object)configuration);
                if (returnedVal != null && returnedVal != value) {
                    return returnedVal;
                }
            }
            catch (CoreException coreException) {}
            int start = value.indexOf(START_BRACKET);
            int end = value.indexOf(END_BRACKET);
            String name = value.substring(start + 2, end);
            String envVar = System.getenv(name);
            if (envVar == null) {
                envVar = System.getenv(name.toUpperCase());
            }
            if (envVar != null) {
                return String.valueOf(value.substring(0, start)) + envVar + value.substring(end + 1);
            }
        }
        return value;
    }

    protected static String resolveMacro(String value, IConfiguration configuration) {
        String result = PathEnvironmentVariable.resolveMacroRecursive(value, configuration);
        while (!result.equals(value)) {
            value = result;
            result = PathEnvironmentVariable.resolveMacroRecursive(value, configuration);
        }
        return result;
    }
}

