/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cross.wizard.pi.Messages;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.ExportInfoPage;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExporter;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ProjectInfoExportWizard
extends Wizard
implements IExportWizard {
    protected static final String WORKSPACE = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    private static final String TITLELONG = Messages.ProjectInfoExportWizard_export_from;
    private static final String EXPT = Messages.ProjectInfoExportWizard_export_error;
    private static final String ERRM = Messages.ProjectInfoExportWizard_no_projects;
    private ExportInfoPage mainPage;
    private IProject project;
    private String errorText;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject result = (IProject)selection.getFirstElement();
        this.setWindowTitle(EXPT);
        if (result == null) {
            this.errorText = Messages.ProjectInfoExportWizard_no_project;
        } else if (!result.isAccessible() || !ProjectInfoExportWizard.canExportProject(result)) {
            this.errorText = String.valueOf(ERRM) + ' ' + Messages.ProjectInfoExportWizard_select_project;
        } else {
            this.project = result;
            this.setWindowTitle(String.format(TITLELONG, this.project.getName()));
        }
    }

    public boolean performFinish() {
        if (new ProjectInfoExporter(this.mainPage.getSettings()).writeProjectInfo()) {
            final IFile piFile = this.mainPage.getSettings().getOutputIFile();
            new UIJob("Open ProjectInfo.xml"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)piFile);
                        return Status.OK_STATUS;
                    }
                    catch (PartInitException e) {
                        S32DSWizardPiPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule();
            return true;
        }
        return false;
    }

    public void addPages() {
        super.addPages();
        if (this.project != null) {
            this.mainPage = new ExportInfoPage(this.project);
            this.addPage((IWizardPage)this.mainPage);
        }
    }

    public boolean canFinish() {
        return this.project != null && this.mainPage.isPageComplete();
    }

    private static boolean canExportProject(IProject project) {
        block6: {
            block5: {
                if (project.hasNature(ManagedCProjectNature.MNG_NATURE_ID)) break block5;
                S32DSWizardPiPlugin.logWarning(String.format("Try to export project %s without MANAGED nature!", project));
                return false;
            }
            if (!project.hasNature("org.eclipse.cdt.core.cnature")) break block6;
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                S32DSWizardPiPlugin.logWarning(String.format("Try to export project %s with C++ nature!", project));
                return false;
            }
            return true;
        }
        try {
            S32DSWizardPiPlugin.logWarning(String.format("Try to export project %s without C nature!", project));
        }
        catch (Exception e) {
            S32DSWizardPiPlugin.log(e);
        }
        return false;
    }

    public IWizardPage getStartingPage() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.project == null) {
            shell.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)EXPT, (String)this.errorText, (int)0);
            });
        }
        return super.getStartingPage();
    }
}

