/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.collateral.internal;

import com.nxp.s32ds.ext.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.ext.rcp.collateral.CollateralPack;
import com.nxp.s32ds.ext.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResource;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.ext.rcp.collateral.CollateralTag;
import com.nxp.s32ds.ext.rcp.collateral.internal.CollateralFeatureImplementation;
import com.nxp.s32ds.ext.rcp.collateral.internal.CollateralPackImplementation;
import com.nxp.s32ds.ext.rcp.collateral.internal.CollateralResourceImplementation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CollateralRegistryImplementation
implements CollateralRegistry {
    private Collection<CollateralPack> packs = new ArrayList<CollateralPack>();
    private Collection<CollateralTag> tags = new ArrayList<CollateralTag>();
    private Collection<CollateralResourceType> resourceTypes = new ArrayList<CollateralResourceType>();

    @Override
    public void addPack(CollateralPack pack) {
        this.packs.add(pack);
    }

    @Override
    public void addTag(CollateralTag tag) {
        this.tags.add(tag);
    }

    @Override
    public void addResourceType(CollateralResourceType resourceType) {
        this.resourceTypes.add(resourceType);
    }

    @Override
    public Collection<CollateralPack> getAllPacks() {
        return Collections.unmodifiableCollection(this.packs);
    }

    @Override
    public Collection<CollateralFeature> getPackFeatures(String packageId) {
        Collection<CollateralFeature> result = null;
        for (CollateralPack clPackage : this.packs) {
            if (!clPackage.getId().equals(packageId)) continue;
            result = clPackage.getFeatures();
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public Collection<CollateralResource> getAllResources() {
        ArrayList<CollateralResource> result = new ArrayList<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                result.addAll(clFeature.getResources());
            }
        }
        return result;
    }

    @Override
    public Collection<CollateralResource> getFeatureResources(String featureId) {
        Collection<CollateralResource> result = null;
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                if (!clFeature.getId().equals(featureId)) continue;
                result = clFeature.getResources();
            }
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public Collection<CollateralResource> getResourcesByTag(String tagId) {
        ArrayList<CollateralResource> result = new ArrayList<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                for (CollateralResource resource : clFeature.getResources()) {
                    for (CollateralTag clTag : resource.getTags()) {
                        if (!clTag.getId().equals(tagId)) continue;
                        result.add(resource);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Collection<CollateralResource> getResourcesByResourceType(String tagId) {
        ArrayList<CollateralResource> result = new ArrayList<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                for (CollateralResource resource : clFeature.getResources()) {
                    if (!resource.getResourceType().getId().equals(tagId)) continue;
                    result.add(resource);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<CollateralResourceType> getAllResourceTypes() {
        return Collections.unmodifiableCollection(this.resourceTypes);
    }

    @Override
    public CollateralPack getPacksById(String packageId) {
        for (CollateralPack collateralPack : this.packs) {
            if (!packageId.equals(collateralPack.getId())) continue;
            return collateralPack;
        }
        return null;
    }

    @Override
    public CollateralFeature getFeatureById(String featureId) {
        for (CollateralPack collateralPack : this.packs) {
            for (CollateralFeature feature : collateralPack.getFeatures()) {
                if (!featureId.equals(feature.getId())) continue;
                return feature;
            }
        }
        return null;
    }

    @Override
    public Collection<CollateralResource> getResourcesByResourcesTypeIdAndFeatureId(String categoryId, String featureId) {
        ArrayList<CollateralResource> collateralResources = new ArrayList<CollateralResource>();
        for (CollateralPack collateralPack : this.packs) {
            for (CollateralFeature feature : collateralPack.getFeatures()) {
                if (!featureId.equals(feature.getId())) continue;
                for (CollateralResource collateralResource : feature.getResources()) {
                    if (!categoryId.equals(collateralResource.getResourceType().getId())) continue;
                    collateralResources.add(collateralResource);
                }
            }
        }
        return collateralResources;
    }

    @Override
    public void addCollateralFeatureToPack(CollateralFeature collateralFeature, CollateralPack pack) {
        if (pack instanceof CollateralPackImplementation) {
            ((CollateralPackImplementation)pack).addCLFeature(collateralFeature);
        }
        if (collateralFeature instanceof CollateralFeatureImplementation) {
            ((CollateralFeatureImplementation)collateralFeature).setPack(pack);
        }
    }

    @Override
    public void addCollateralResourceToFeature(CollateralResource collateralResource, CollateralFeature collateralFeature) {
        if (collateralFeature instanceof CollateralFeatureImplementation) {
            ((CollateralFeatureImplementation)collateralFeature).addCLResource(collateralResource);
        }
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setFeature(collateralFeature);
        }
    }

    @Override
    public void addCollateralTagToResource(CollateralTag tag, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).addCLTag(tag);
        }
    }

    @Override
    public void setCollateralResourceTypeToResource(CollateralResourceType resourceType, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setResourceType(resourceType);
        }
    }
}

