/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.gnu;

import com.freescale.s32ds.cdt.core.OSFamily;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;

public class LinkerScriptCommandGenerator
implements IOptionCommandGenerator {
    public String generateCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        if (option == null) {
            return "";
        }
        StringBuffer command = new StringBuffer();
        try {
            String id = option.getBaseId();
            int valueType = option.getValueType();
            if (id.contains(".linker.option.scriptfile")) {
                if (valueType == 2) {
                    String value = option.getStringValue();
                    value = CdtVariableResolver.resolveToString((String)value, (IVariableSubstitutor)macroSubstitutor);
                    command.append("-T ");
                    command.append(LinkerScriptCommandGenerator.quoteWhitespaces(value));
                } else if (valueType == 3) {
                    String[] stringArray = option.getStringListValue();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        if (value != null && (value = value.trim()).length() > 0) {
                            value = CdtVariableResolver.resolveToString((String)value, (IVariableSubstitutor)macroSubstitutor);
                            command.append("-T ");
                            command.append(LinkerScriptCommandGenerator.quoteWhitespaces(value));
                            command.append(" ");
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        catch (CdtVariableException e) {
            e.printStackTrace();
        }
        return command.toString().trim();
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = (path = path.trim()).split("\\s");
        if (segments.length > 1) {
            if (OSFamily.WINDOWS.isCurrent()) {
                if (path.startsWith("\"") || path.startsWith("'")) {
                    return path;
                }
                return "\"" + path + "\"";
            }
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public static String quoteWhitespaces(String path) {
        String[] segments = (path = path.trim()).split("\\s");
        if (segments.length > 1) {
            if (path.startsWith("\"") || path.startsWith("'")) {
                return path;
            }
            return "\"" + path + "\"";
        }
        return path;
    }
}

