/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.ui;

import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import com.nxp.s32ds.ext.ide.validation.ui.TextChangeFinder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class LaunchConfigurationQuickFix
extends WorkbenchMarkerResolution {
    public static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.validation.ui";
    private final String label;
    private static final String DESCRIPTION = "QuickFix for Launch Configuration";
    private final IMarker selectedMarker;

    public LaunchConfigurationQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IFile) {
            IFile launchConfigFile = (IFile)marker.getResource();
            try {
                String projectName = (String)marker.getAttribute("location");
                String fixAttribute = (String)marker.getAttribute(Messages.LaunchConfigurationMarker_MarkerAttFixAttribute);
                List<ReplaceEdit> changes = TextChangeFinder.findInOneResource((IResource)launchConfigFile, new String[]{"*.launch"}, fixAttribute, projectName, (IProgressMonitor)new NullProgressMonitor());
                this.applyChanges((IProgressMonitor)new NullProgressMonitor(), launchConfigFile, changes);
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfiguration launchConfig = manager.getLaunchConfiguration(launchConfigFile);
                ILaunchConfigurationWorkingCopy lcwc = launchConfig.getWorkingCopy();
                lcwc.rename(lcwc.getName().replace(fixAttribute, projectName));
                lcwc.doSave();
                marker.delete();
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
        }
    }

    public void applyChanges(IProgressMonitor pm, IFile fCurrentFile, List<ReplaceEdit> lstChanges) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        IDocument result = null;
        pm.beginTask("", 2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                IPath path = fCurrentFile.getFullPath();
                manager.connect(path, LocationKind.NORMALIZE, pm);
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                result = buffer.getDocument();
                MultiTextEdit mte = new MultiTextEdit();
                for (ReplaceEdit it : lstChanges) {
                    mte.addChild((TextEdit)it);
                }
                mte.apply(result);
                buffer.commit(pm, true);
            }
            catch (Exception e) {
                Status status = new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (result != null) {
                manager.disconnect(fCurrentFile.getFullPath(), LocationKind.NORMALIZE, pm);
            }
        }
        pm.done();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IProject selectedProject = this.selectedMarker.getResource().getProject();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker it = iMarkerArray[n2];
            if (it.exists() && !it.equals((Object)this.selectedMarker)) {
                try {
                    String type;
                    IProject curProject = it.getResource().getProject();
                    if (curProject != null && curProject.equals((Object)selectedProject) && Messages.LaunchConfigurationMarker_MarkerAttTypeFixLaunchConfig.equals(type = (String)it.getAttribute(Messages.LaunchConfigurationMarker_MarkerAttTypeFix))) {
                        lstMarkers.add(it);
                    }
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }
}

