/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.ContextStyle;
import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.wizard.S32DSMultiProjectWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import com.freescale.s32ds.cross.wizard.page2.GridManager;
import com.freescale.s32ds.cross.wizard.page2.IPage2Manager;
import com.freescale.s32ds.cross.wizard.page2.MemoryMinimumChecker;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.freescale.s32ds.cross.wizard.page2.TableManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class S32DSMultiPageTwo
extends WizardPage {
    protected static final String DESCR = "Select required cores and parameters for them.";
    private final ProcessorContext processorContext;
    private String projectName = "";
    private IPage2Manager pageManager;
    protected final S32DSMultiPageOne firstPage;

    public S32DSMultiPageTwo(String pageName, S32DSMultiProjectWizard w, ProcessorContext processorContext) {
        super(pageName);
        processorContext.initData();
        this.setWizard(w);
        this.setPageComplete(false);
        this.setTitle("New S32DS Project for " + processorContext.getProcessor().getName());
        this.setDescription(DESCR);
        this.processorContext = processorContext;
        processorContext.initData();
        this.firstPage = this.getWizard().getStartingPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        ContextStyle style = this.processorContext.getContextDefinition().getStyle();
        this.pageManager = ContextStyle.TABLE == style ? new TableManager(this.processorContext, this, composite) : new GridManager(this.processorContext, this, composite);
        this.pageManager.createContents(700, 25);
        this.initializeDialogUnits((Control)parent);
        composite.pack();
        this.setPageComplete(this.pageManager.isAnyChecked());
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean fpuSupport = this.processorContext.containsParameter("fpu");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), S32DSWizardPlugin.makeHelpContextId(this.getWizard().getType(), 2, fpuSupport));
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getStartingPage();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    public boolean validatePage() {
        String memoryError = MemoryMinimumChecker.getMinMemoryError(this.processorContext);
        if (memoryError != null) {
            this.setErrorMessage(memoryError);
            return false;
        }
        if (!this.pageManager.isAnyChecked()) {
            String coreNatureDescription = this.getWizard().getContext().isExecutable() ? "core" : "core-type";
            this.setErrorMessage("Choose any " + coreNatureDescription + " to continue");
            return false;
        }
        for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
            if (!(ctx instanceof CProjectMasterContext)) continue;
            final CProjectMasterContext pc = (CProjectMasterContext)ctx;
            for (IModelSDK sdk : pc.getSdkList()) {
                AbstractSmartFilter filter = new AbstractSmartFilter(){

                    public IFilterOptions options() {
                        return FilterOptions.createFilter((ISDKFilterInfo)Page2Utils.createSDKFilterInfo((CProjectContext)pc));
                    }

                    public boolean accept(ISDK sdk) {
                        return true;
                    }
                };
                if (!(sdk instanceof ISDK) || filter.acceptOptions((ISDK)sdk)) continue;
                this.setErrorMessage(String.format("SDK '%s' doesn't fit to selected parameters.", sdk.getName()));
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (this.pageManager != null) {
            this.pageManager.update();
        }
    }

    public S32DSMultiProjectWizard getWizard() {
        return (S32DSMultiProjectWizard)super.getWizard();
    }

    public void disableUI() {
        this.pageManager.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }
}

