/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.wizard.DescriptionUpdater;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Text;

public class ToolChainSelectionAdapter
extends SelectionAdapter {
    private final CCombo combo;
    private final GeneralContext context;
    private final CoreNatureData coreNature;
    private final List<CoreNatureConfiguration> coreNatureConfigurations;
    private final Text descriptionText;

    public ToolChainSelectionAdapter(CCombo combo, CoreNatureData coreNature, GeneralContext context, Text descriptionText) {
        this.combo = combo;
        this.coreNature = coreNature;
        this.context = context;
        this.descriptionText = descriptionText;
        this.coreNatureConfigurations = CoreNatureConfiguration.getAll((CoreNatureData)coreNature);
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public GeneralContext getContext() {
        return this.context;
    }

    public CoreNatureData getCoreNature() {
        return this.coreNature;
    }

    public List<CoreNatureConfiguration> getCoreNatureConfigurations() {
        return this.coreNatureConfigurations;
    }

    public void widgetSelected(SelectionEvent e) {
        ProcessorConfiguration oldConfiguration = this.context.getCurrentProcessorConfiguration();
        CoreNatureConfiguration newConfiguration = null;
        for (CoreNatureConfiguration cConfiguration : this.coreNatureConfigurations) {
            CdtTemplateInfo templateInfo = cConfiguration.getTemplate().getTemplateInfo(this.context.isExecutable());
            String toolChainName = this.combo.getText();
            IToolChain toolChain = (IToolChain)this.combo.getData(toolChainName);
            if (templateInfo == null || toolChain == null || !templateInfo.getToolChainId().equals(toolChain.getId())) continue;
            newConfiguration = cConfiguration;
            break;
        }
        if (newConfiguration != null) {
            LinkedHashMap<String, CoreNatureConfiguration> cConfigurationMap = new LinkedHashMap<String, CoreNatureConfiguration>(oldConfiguration.getCoreNatureConfigurationMap());
            cConfigurationMap.put(newConfiguration.getCoreNature().getId(), newConfiguration);
            this.context.setCurrentProcessorConfiguration(new ProcessorConfiguration(oldConfiguration.getProcessor(), cConfigurationMap.values(), this.context.isExecutable()));
            DescriptionUpdater.updateDescription(this.descriptionText, this.context.getCurrentProcessorConfiguration());
        }
    }
}

