/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.GraphicConstants;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.WizardImages;
import com.freescale.s32ds.cross.wizard.imports.ElfImporterValidator;
import com.freescale.s32ds.cross.wizard.imports.ImportExeWizard;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public class ImportExePage3
extends WizardPage {
    private static final String TITLE = Messages.ImportExePage3_choose_executable;
    private static final String SELECT = Messages.ImportExePage3_select_processor;
    private static final String DESCR = Messages.ImportExePage3_description;
    private static final String BROWSE = Messages.ImportExePage3_browse_binary;
    private static final String EMPTY = "";
    private final ImportExeWizard wizard;
    private static final int TYPE_WIDTH = 50;
    private static final String TFT = "type filter text";
    private static final int FILTER_DELAY = 200;
    private final UIJob FILTER_JOB = this.createFilterJob();
    private TreeViewer treeViewer = null;
    private ImportExeWizard.CoresTreeNode selNode = null;
    private String selectedName = null;
    private String selectedProc = null;
    private String nameError = "";
    private String filterText = "";

    protected ImportExePage3(String pageName, ImportExeWizard wiz) {
        super(pageName);
        this.setTitle(TITLE);
        this.setDescription(SELECT);
        this.setButtons();
        this.wizard = wiz;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout(2, true));
        workArea.setLayoutData((Object)new GridData(1808));
        this.createExeField(workArea);
        this.createProcTable(workArea);
    }

    private void setButtons() {
        if (this.nameError != null) {
            if (this.nameError.isEmpty()) {
                this.setErrorMessage(null);
                this.setDescription(BROWSE);
            } else {
                this.setDescription(null);
                this.setErrorMessage(this.nameError);
            }
        } else if (this.selNode == null) {
            this.setErrorMessage(null);
            this.setDescription(SELECT);
        } else {
            this.setErrorMessage(null);
            this.setDescription(null);
        }
        this.setPageComplete(this.nameError == null & this.selNode != null);
    }

    public CoreData getCore() {
        return this.selNode == null ? null : (CoreData)this.selNode.data;
    }

    public int getCoreIndex() {
        if (this.selNode != null) {
            ImportExeWizard.CoresTreeNode p = this.selNode.parent;
            int i = 0;
            while (i < p.children.size()) {
                if (p.children.get(i) == this.selNode) {
                    return ++i;
                }
                ++i;
            }
        }
        return 0;
    }

    public ProcessorData getProcessor() {
        return this.selNode == null ? null : (ProcessorData)this.selNode.parent.data;
    }

    public FamilyData getFamily() {
        return this.selNode == null ? null : (FamilyData)this.selNode.parent.parent.data;
    }

    public HWModel getModel() {
        return this.selNode == null ? null : this.selNode.parent.parent.model;
    }

    public String getSelectedExecutable() {
        return this.selectedName;
    }

    public String getSelectedProcessor() {
        return this.selectedProc;
    }

    private void createExeField(Composite parent) {
        Composite w = new Composite(parent, 0);
        GridLayout lay = new GridLayout(4, false);
        lay.marginWidth = 0;
        w.setLayout((Layout)lay);
        w.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lb = new Label(w, 0);
        lb.setText(Messages.ImportExePage3_select_executable);
        lb.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text txt = new Text(w, 2056);
        txt.setLayoutData((Object)new GridData(768));
        txt.addModifyListener(e -> this.validateExe(txt.getText()));
        Button btn = new Button(w, 8);
        btn.setText(Messages.ImportExePage3_browse);
        btn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final Text type = new Text(w, 2056);
        type.setBackground(GraphicConstants.GRAY);
        GridDataFactory.swtDefaults().hint(50, -1).applyTo((Control)type);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportExePage3.this.getShell(), 0);
                ImportExePage3.this.wizard.setupFileDialog(dialog);
                String res = dialog.open();
                if (res != null) {
                    txt.setText(res);
                    try {
                        type.setText(Elf.getAttributes((String)res).getCPU());
                        type.setToolTipText("CPU type: " + type.getText());
                    }
                    catch (IOException ex) {
                        type.setText("Error");
                        type.setToolTipText(ex.getMessage());
                    }
                }
            }
        });
    }

    private void createProcTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(SELECT);
        label.setLayoutData((Object)new GridData());
        label = new Label(parent, 0);
        label.setText(DESCR);
        label.setLayoutData((Object)new GridData());
        final Text filter = new Text(parent, 18436);
        filter.setText(TFT);
        filter.setLayoutData((Object)new GridData(768));
        filter.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                filter.setText(ImportExePage3.this.filterText);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        Text description = new Text(parent, 16779274);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        description.setLayoutData((Object)gd);
        description.setBackground(GraphicConstants.GRAY);
        description.setText(SELECT);
        this.treeViewer = new TreeViewer(parent, 2820);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setInput(this.wizard.getInitalInput());
        this.treeViewer.collapseAll();
        this.expandOne(this.treeViewer.getTree().getItem(0), this.treeViewer);
        this.setButtons();
        filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportExePage3.this.filterText = filter.getText().toLowerCase();
                ImportExePage3.this.FILTER_JOB.cancel();
                ImportExePage3.this.FILTER_JOB.schedule(200L);
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            if (event.getSelection() instanceof IStructuredSelection) {
                Object[] sel = ((IStructuredSelection)event.getSelection()).toArray();
                this.selNode = null;
                if (sel != null && sel.length > 0) {
                    ImportExeWizard.CoresTreeNode n = (ImportExeWizard.CoresTreeNode)sel[0];
                    if (n.isLeaf) {
                        this.selNode = n;
                    }
                    description.setText(n.getDescription());
                } else {
                    description.setText(SELECT);
                }
                this.setButtons();
            }
        });
    }

    private void expandOne(TreeItem item, TreeViewer treeViewer) {
        if (item != null) {
            item.setExpanded(true);
            treeViewer.getTree().select(item);
            treeViewer.refresh();
            if (item.getItemCount() > 0) {
                this.expandOne(item.getItem(0), treeViewer);
            }
        }
    }

    private void validateExe(String path) {
        this.selectedName = null;
        if (path.isEmpty()) {
            this.nameError = EMPTY;
        } else {
            IStatus status = new ElfImporterValidator().validate(path);
            if (!status.isOK()) {
                this.nameError = status.getMessage();
            } else {
                this.selectedName = path;
                this.nameError = null;
            }
        }
        this.setButtons();
    }

    private UIJob createFilterJob() {
        return new UIJob("Refresh"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TreeItem[] sel = ImportExePage3.this.treeViewer.getTree().getSelection();
                ImportExePage3.this.treeViewer.refresh();
                if (!ImportExePage3.this.filterText.trim().isEmpty()) {
                    ImportExePage3.this.treeViewer.expandAll();
                } else if (sel != null) {
                    ImportExePage3.this.treeViewer.collapseAll();
                    ImportExePage3.this.expandOne(ImportExePage3.this.treeViewer.getTree().getItem(0), ImportExePage3.this.treeViewer);
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ImportExeWizard.CoresTreeNode) {
                List<ImportExeWizard.CoresTreeNode> res = ((ImportExeWizard.CoresTreeNode)parentElement).children;
                if (ImportExePage3.this.filterText != null && !ImportExePage3.this.filterText.trim().isEmpty()) {
                    res = res.stream().filter(n -> n.fits(ImportExePage3.this.filterText.toLowerCase())).collect(Collectors.toList());
                }
                return res.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return ((ImportExeWizard.CoresTreeNode)element).parent;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    protected class LabelProvider
    implements ILabelProvider {
        protected LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getImage(Object element) {
            return ((ImportExeWizard.CoresTreeNode)element).isLeaf ? WizardImages.getInstance().getImage("chip") : WizardImages.getInstance().getImage("folder");
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

