/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ElfImporterValidator
implements IValidator {
    private static final String[] SUPPORTED_ARCH = new String[]{"ppc", "ppc64", "arm", "aarch64"};
    private final IBinaryParser binaryParser;

    public ElfImporterValidator() {
        String defaultBinaryParserId = ElfImporterValidator.getDefaultBinaryParserId();
        this.binaryParser = this.initBinaryParser(defaultBinaryParserId);
        if (this.binaryParser == null) {
            S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", "Failed to instance binary parser: " + defaultBinaryParserId));
        }
    }

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.error((String)("Unexpected input: " + value));
        }
        String path = (String)value;
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return ValidationStatus.error((String)Messages.ImportExePage3_does_not_exist);
        }
        if (!this.isBinary(path)) {
            return ValidationStatus.error((String)Messages.ImportExePage3_not_an_exe);
        }
        try {
            String cpu = Elf.getAttributes((String)path).getCPU();
            if (!Stream.of(SUPPORTED_ARCH).anyMatch(e -> e.equals(cpu))) {
                return ValidationStatus.error((String)Messages.bind((String)Messages.ImportExePage3_Unsupported_Architecture, (Object)cpu));
            }
        }
        catch (IOException e2) {
            return ValidationStatus.error((String)e2.getMessage(), (Throwable)e2);
        }
        return ValidationStatus.ok();
    }

    private boolean isBinary(String f) {
        try {
            IBinaryParser.IBinaryFile bin = this.binaryParser.getBinary((IPath)new Path(f));
            if (bin != null && bin.getType() == 2) {
                return true;
            }
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e, e.getMessage());
        }
        return false;
    }

    private IBinaryParser initBinaryParser(String binaryParserId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point == null) {
            return null;
        }
        ArrayList<IExtension> extensionsInUse = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            if (ElfImporterValidator.isExtensionVisible(ext)) {
                extensionsInUse.add(ext);
            }
            ++n2;
        }
        IExtension[] binaryParserExtensions = extensionsInUse.toArray(new IExtension[extensionsInUse.size()]);
        int j = 0;
        while (j < binaryParserExtensions.length) {
            if (binaryParserExtensions[j].getUniqueIdentifier().equals(binaryParserId)) {
                return this.instantiateBinaryParser(binaryParserExtensions[j]);
            }
            ++j;
        }
        return null;
    }

    public static String getDefaultBinaryParserId() {
        String defaultBinaryParserId = CCorePlugin.getDefault().getPluginPreferences().getDefaultString("binaryparser");
        if (defaultBinaryParserId == null || defaultBinaryParserId.isEmpty()) {
            return "org.eclipse.cdt.core.ELF";
        }
        return defaultBinaryParserId;
    }

    private static boolean isExtensionVisible(IExtension ext) {
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement element = iConfigurationElementArray[0];
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("filter");
            int n = iConfigurationElementArray2.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray2[n2];
                if ("visibility".equals(child.getAttribute("name")) && "private".equals(child.getAttribute("value"))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private IBinaryParser instantiateBinaryParser(IExtension ext) {
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("run");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                try {
                    return (IBinaryParser)child.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    S32DSWizardPlugin.log(e);
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

