/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.handler;

import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.MemoryUtil;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ExecutableContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemorySizeHandler
extends DefaultParameterHandler {
    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        if (!(context instanceof ExecutableContext)) {
            return ChangeResult.createDeclined();
        }
        ExecutableContext coreContext = (ExecutableContext)context;
        if ("flashSize".equals(tag)) {
            return this.getInitChanges(coreContext, "flashSize", "flashStart");
        }
        if ("ramSize".equals(tag)) {
            return this.getInitChanges(coreContext, "ramSize", "ramStart");
        }
        return ChangeResult.createApproved();
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        if (!(context instanceof ExecutableContext)) {
            return ChangeResult.createDeclined();
        }
        ExecutableContext coreContext = (ExecutableContext)context;
        if ("flashSize".equals(tag)) {
            return this.getEditChanges(newValue, coreContext, "flashSize", "flashStart", "flashSizeMin");
        }
        if ("ramSize".equals(tag)) {
            return this.getEditChanges(newValue, coreContext, "ramSize", "ramStart", "ramSizeMin");
        }
        return ChangeResult.createApproved();
    }

    protected ChangeResult getInitChanges(ExecutableContext coreContext, String sizeTag, String startTag) {
        CoreData core = coreContext.getCoreNature();
        ProcessorData processor = core.getProcessor();
        ProcessorContext processorContext = coreContext.getParent();
        long startOffset = processor.getLongValue(startTag);
        String unusedValue = MemoryUtil.calculateUnused((String)sizeTag, (ProcessorData)coreContext.getParent().getProcessor(), (boolean)coreContext.getParent().isExecutable());
        String unusedTag = sizeTag.equals("flashSize") ? "flashUnused" : "ramUnused";
        int i = 0;
        while (i < processor.getCores().size()) {
            if (core.equals(processor.getCores().get(i))) {
                ContextChange c = new ContextChange((AbstractContext)coreContext, startTag);
                c.addValue(startTag, (Object)startOffset);
                if (coreContext.equals(processorContext.getAutoStartProjectContext())) {
                    c.addValue(unusedTag, (Object)unusedValue);
                }
                return new ChangeResult(Arrays.asList(c));
            }
            startOffset += core.getLongValue(sizeTag);
            ++i;
        }
        return ChangeResult.createApproved();
    }

    protected ChangeResult getEditChanges(Object newValue, ExecutableContext coreContext, String sizeTag, String startTag, String minimalTag) {
        boolean approve;
        ArrayList<ContextChange> result = new ArrayList<ContextChange>();
        CoreData core = coreContext.getCoreNature();
        ProcessorData processor = core.getProcessor();
        ProcessorContext processorContext = coreContext.getParent();
        long allMemorySize = processor.getLongValue(sizeTag);
        long newCoreMemorySize = coreContext.isActive() ? ModelUtil.parseLong((String)newValue.toString()) : 0L;
        long oldCoreMemorySize = coreContext.getLongValue(sizeTag);
        long currentCoreMemorySize = coreContext.getLongValue(sizeTag);
        long coreMemorySizeOffset = newCoreMemorySize - currentCoreMemorySize;
        boolean affected = false;
        long futureProcessorSize = 0L;
        long oldProcessorSize = 0L;
        for (CProjectContext pc : processorContext.getProjectContexts()) {
            if (pc.equals(coreContext)) {
                affected = true;
                oldProcessorSize += pc.getLongValue(sizeTag);
                ContextChange c = new ContextChange((AbstractContext)pc, sizeTag);
                c.addValue(sizeTag, (Object)newCoreMemorySize);
                result.add(c);
                futureProcessorSize += newCoreMemorySize;
                continue;
            }
            if (affected) {
                long oldStart = pc.getLongValue(startTag);
                long newStart = oldStart + coreMemorySizeOffset;
                ContextChange c = new ContextChange((AbstractContext)pc, sizeTag);
                c.addValue(startTag, (Object)newStart);
                result.add(c);
                oldProcessorSize += pc.getLongValue(sizeTag);
                futureProcessorSize += pc.getLongValue(sizeTag);
                continue;
            }
            oldProcessorSize += pc.getLongValue(sizeTag);
            futureProcessorSize += pc.getLongValue(sizeTag);
        }
        boolean bl = approve = futureProcessorSize <= allMemorySize;
        if (!approve && oldProcessorSize <= allMemorySize) {
            long allowedOffset = allMemorySize - oldProcessorSize;
            long allowedSize = allowedOffset + oldCoreMemorySize;
            if (allowedSize > 0L) {
                return this.getEditChanges(allowedSize, coreContext, sizeTag, startTag, minimalTag);
            }
            ContextChange change = new ContextChange((AbstractContext)coreContext, sizeTag);
            change.addValue(sizeTag, (Object)0);
            return new ChangeResult(Arrays.asList(change));
        }
        if (approve) {
            String unusedValue = MemoryUtil.calculateUnused((String)sizeTag, (ProcessorContext)coreContext.getParent(), (CoreNatureData)coreContext.getCoreNature(), (long)newCoreMemorySize);
            this.updateWithUnusedValue(unusedValue, processorContext.getAutoStartProjectContext(), sizeTag, result);
            return new ChangeResult(result);
        }
        return new ChangeResult(false);
    }

    private void updateWithUnusedValue(String unusedValue, CProjectContext mainProjectContext, String sizeTag, List<ContextChange> result) {
        String unusedTag = sizeTag.equals("flashSize") ? "flashUnused" : "ramUnused";
        ContextChange unusedChange = null;
        for (ContextChange c : result) {
            if (!mainProjectContext.equals(c.getContext())) continue;
            unusedChange = c;
        }
        if (unusedChange == null) {
            unusedChange = new ContextChange((AbstractContext)mainProjectContext, unusedTag);
            result.add(unusedChange);
        }
        unusedChange.addValue(unusedTag, (Object)unusedValue);
    }
}

