/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.gnu.arm.importer;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.wizard.imports.IImportConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

public abstract class ImportAbstract
implements IImportConverter {
    protected static final String ERR_NO_PROC_SUPP = "The project does not contain supported processor type.";
    protected static final String ERR_NO_TOOLCHAIN = "The project does not contain known toolchain.";
    protected static final String ERR_FAILED_OPEN = "Failed opening ";
    protected static final String PATH_TO_LD = "../Project_Settings/Linker_Files/";
    protected static final String END_OF_LD = "flash.ld&quot;";
    protected static final String STD_TOOLCHAIN = "com.freescale.s32ds.cross.gnu.arm.cortexm.toolChain";
    protected static final String STD_TC = "com.freescale.s32ds.cross.gnu.arm.cortexm.toolChain.";
    protected static final String CR = " \n";
    protected static final String TOOL = "</tool>";
    protected static final String DEB = "<option id=\"gnu.c.compiler.option.debugging.level.1\" name=\"Debug Level\" superClass=\"gnu.c.compiler.option.debugging.level\" useByScannerDiscovery=\"false\" valueType=\"enumerated\" value=\"gnu.c.debugging.level.";
    protected static final String PRE = "com.freescale.s32ds.cross.gnu.arm.cortexm.";
    protected static final String DB2 = "org.eclipse.cdt.cross.arm.gnu.base.option.debugging.level.";
    protected static final String END_OPT = "</option>";
    protected static final String PATTERN = "value=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.mcpu";
    protected static final String[] TOOL5 = new String[]{"assembler", "c.compiler", "cpp.compiler", "c.linker", "cpp.linker"};
    protected static final String F0 = "<option id=\"";
    protected static final String F1 = "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.";
    protected static final String F2 = ".option.target.mcpu";
    protected static final String F3 = ".1\" name=\"ARM family\" superClass=\"";
    protected static final String F4 = "\" value=\"";
    protected static final String F5 = ".option.target.mcpu";
    protected static final String F6 = "\" valueType=\"enumerated\"/> ";
    protected static final String LIB = "<option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.{0}option.target.sysroot.4\" name=\"Sysroot\" \nsuperClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.{0}option.target.sysroot\" \nvalue=\"--sysroot=&quot;{2}&quot;\" valueType=\"string\"/> \n<option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.{0}option.target.libraries.5\" name=\"Libraries support\" \nsuperClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.{0}option.target.libraries\" valueType=\"enumerated\" \nvalue=\"com.freescale.s32ds.cross.gnu.arm.cortexm.{0}option.target.libraries.{1}\" /> \n";
    protected static final String TOOLPREFIX = "com.freescale.s32ds.cross.gnu.arm.cortexm.";
    protected static final String[] FOR_LINK = new String[]{"tool.c.linker.", "tool.cpp.linker.", "tool.c.compiler.", "tool.cpp.compiler.", "tool.c.linker.", "tool.assembler."};
    protected static final String INC = "<option id=\"gnu.{0}option.include.paths.1\" superClass=\"gnu.{0}option.include.paths\" valueType=\"includePath\"> <listOptionValue builtIn=\"false\" value=\"&quot;../Includes&quot;\"/>\n</option>";
    protected static final String[] FOR_COMP = new String[]{"c.compiler.", "cpp.compiler."};
    protected static final String ARTIFACT = "artifactName=\"";
    protected static final String EMPTY = "";
    protected static final String GT = ">";
    protected static final String LINKORDER_OLD = "org.eclipse.cdt.cross.arm.gnu.c.link.option.linkorder";
    protected static final String LINKORDER_NEW = "com.freescale.s32ds.cross.gnu.tool.c.linker.option.linkOrder";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String read(File ff) {
        if (!ff.exists()) return null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(ff);
                try {
                    byte[] b = new byte[fis.available()];
                    if (fis.read(b) == -1) {
                        return null;
                    }
                    return new String(b);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (fis == null) return null;
                    fis.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log((Throwable)e, (String)(ERR_FAILED_OPEN + ff));
        }
        return null;
    }

    protected static String add(String s, String tool, String opt, String deb) {
        deb = deb != null ? DEB + deb + "\" />\n" : EMPTY;
        int n = s.indexOf(tool);
        if (n < 0) {
            return s;
        }
        if ((n = s.indexOf(GT, n)) < 0) {
            return s;
        }
        if (s.charAt(n - 1) == '/') {
            return String.valueOf(s.substring(0, n - 1)) + GT + CR + opt + CR + deb + TOOL + CR + s.substring(n + 1);
        }
        return (n = s.indexOf(TOOL, n)) < 0 ? s : String.valueOf(s.substring(0, n)) + CR + opt + CR + deb + s.substring(n);
    }

    protected static String moveOpt(String s, String[] tools, String opt) {
        int n = s.indexOf("com.freescale.s32ds.cross.gnu.arm.cortexm." + opt);
        if (n < 0) {
            return s;
        }
        int i = n;
        block0: while (i > 0) {
            if (s.charAt(i) == '<') {
                n = s.indexOf(GT, i);
                if (n < 0) break;
                String copy = s.substring(i, n + 1);
                s = s.replace(copy, EMPTY);
                if (tools == null) {
                    return s;
                }
                String[] stringArray = tools;
                int n2 = tools.length;
                int n3 = 0;
                while (n3 < n2) {
                    String tool = stringArray[n3];
                    n = s.indexOf("<tool id=\"com.freescale.s32ds.cross.gnu.arm.cortexm." + tool, i);
                    if (n < 0) break block0;
                    i = s.indexOf(GT, n);
                    if (i++ < 0) break block0;
                    s = String.valueOf(s.substring(0, i)) + '\n' + copy.replace("com.freescale.s32ds.cross.gnu.arm.cortexm." + opt, "com.freescale.s32ds.cross.gnu.arm.cortexm." + tool + opt) + '\n' + s.substring(i);
                    ++n3;
                }
                break;
            }
            --i;
        }
        return s;
    }

    protected static String insertLD(String s) {
        int n = s.indexOf("Project_Settings/Linker_Files&quot");
        if (n > 0) {
            int m = s.substring(0, n).lastIndexOf("<");
            n = s.indexOf(62, n);
            s = String.valueOf(s.substring(0, m)) + s.substring(n + 1);
        }
        int cnt = 0;
        block0: while (cnt < s.length()) {
            n = s.indexOf(END_OF_LD, cnt);
            if (n < 0) break;
            int i = n;
            while (i > 0) {
                if (s.charAt(i) == ';') {
                    s = String.valueOf(s.substring(0, ++i)) + PATH_TO_LD + s.substring(i);
                    cnt = n + PATH_TO_LD.length() + END_OF_LD.length();
                    continue block0;
                }
                --i;
            }
        }
        return s;
    }

    protected static String calcDeb(String s) {
        int m;
        int n = s.indexOf(DB2);
        if (n > 0 && (m = s.indexOf(34, n += DB2.length())) > 0 && m > n && m - n > 100) {
            String deb = s.substring(n, m);
            Activator.logWarning((String)("Debug level found: " + deb));
            return deb;
        }
        return null;
    }

    protected static String replaceOpt(String s, String id, String data) {
        boolean done = false;
        while (!done) {
            int m;
            int n = s.indexOf(id);
            while (n > 0 && s.charAt(n) != '<') {
                --n;
            }
            if (n > 0 && (m = s.indexOf("/>", n)) > 0) {
                s = String.valueOf(s.substring(0, n)) + CR + data + CR + s.substring(m + 2);
                continue;
            }
            done = true;
        }
        return s;
    }

    protected String copyOption(String s, String opt, String from, String to) {
        int n = s.indexOf(opt);
        while (n > 0 && s.charAt(n) != '<') {
            --n;
        }
        if (n > 0) {
            int m = s.indexOf(END_OPT, n);
            if (m < 0) {
                return s;
            }
            String op = String.valueOf('\n') + s.substring(n, m + END_OPT.length()).replace(from, to) + '\n';
            return String.valueOf(s.substring(0, n)) + op + s.substring(n);
        }
        return s;
    }

    protected String copyFamily(String s) {
        int n = s.indexOf(PATTERN);
        if (n < 0) {
            return s;
        }
        int m = s.indexOf("\"", n += PATTERN.length());
        if (m < 0) {
            return s;
        }
        String family = s.substring(n, m);
        String[] stringArray = TOOL5;
        int n2 = TOOL5.length;
        int n3 = 0;
        while (n3 < n2) {
            String tool = stringArray[n3];
            String opt = "<option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.tool." + tool + ".option.target.mcpu" + F3 + F1 + tool + ".option.target.mcpu" + F4 + F1 + tool + ".option.target.mcpu" + family + F6;
            s = ImportAbstract.add(s, F1 + tool, opt, null);
            ++n3;
        }
        return s;
    }

    protected String normalize(String s, String model, boolean useInc, boolean isPE) {
        s = ImportAbstract.replaceOpt(s, "org.eclipse.cdt.cross.arm.gnu.sourcery.windows.toolchain.sharedoption.librarian", EMPTY);
        s = ImportAbstract.replaceOpt(s, "org.eclipse.cdt.cross.arm.gnu.sourcery.windows.option.debugging.other", EMPTY);
        s = ImportAbstract.replaceOpt(s, "com.freescale.s32ds.cross.gnu.arm.cortexm.option.toolchain.name", EMPTY);
        s = ImportAbstract.replaceOpt(s, "com.freescale.s32ds.cross.gnu.arm.cortexm.option.debugging.format", EMPTY);
        int i = 0;
        while (i < FOR_LINK.length) {
            s = ImportAbstract.add(s, "com.freescale.s32ds.cross.gnu.arm.cortexm." + FOR_LINK[i], LIB.replace("{0}", FOR_LINK[i]).replace("{1}", model).replace("{2}", useInc ? "${ARM_NEWLIB_DIR}/newlib" : "${ARM_EWL_DIR}"), null);
            ++i;
        }
        s = this.rmInputType(s);
        s = this.copyFamily(s);
        s = ImportAbstract.setArtifact(s);
        s = s.replace(LINKORDER_OLD, LINKORDER_NEW);
        return s;
    }

    protected String rmInputType(String s) {
        int n = s.indexOf("id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.tool.cpp.compiler");
        if (n < 0) {
            return s;
        }
        int m = s.indexOf(TOOL, n);
        if (m < 0) {
            return s;
        }
        int k = s.indexOf("<inputType", n);
        while (k > 0 && k < m) {
            int v = s.indexOf("/>", k) + 2;
            s = String.valueOf(s.substring(0, k)) + s.substring(v);
            m -= (v -= k);
            k = s.indexOf("<inputType", k);
        }
        return s;
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] stringArray = file.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    ImportAbstract.delete(new File(file, temp));
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
        return true;
    }

    public boolean supportsToolChain(String id) {
        return id.startsWith(STD_TOOLCHAIN);
    }

    public String toS32DScore(String text) {
        return "M0plus";
    }

    public abstract Map<String, String> getProcessors();

    public String toS32DSproc(String text) {
        Map<String, String> map = this.getProcessors();
        if (map != null && !map.isEmpty()) {
            for (String original : map.keySet()) {
                if (!original.startsWith(text)) continue;
                return map.get(original);
            }
        }
        return text;
    }

    private static String setArtifact(String s) {
        int pos = s.indexOf(ARTIFACT);
        while (pos > 0) {
            int end = s.indexOf(34, pos += ARTIFACT.length());
            if (end > 0) {
                s = String.valueOf(s.substring(0, pos)) + "${ProjName}" + s.substring(end);
                pos = s.indexOf(ARTIFACT, pos);
                continue;
            }
            Activator.logWarning((String)"Bad .cproject format: no quote after ArtifactName");
            pos = -1;
        }
        return s;
    }
}

