/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cli.ISettings;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.ICommand;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import java.util.HashMap;
import java.util.Map;

public class UninstallService
implements ICommand {
    private static final String PARAM_PROD = "prod";
    private final ISettings settings;
    private final ICLL cll;
    private final Map<String, String> paramsDesc = new HashMap<String, String>();

    public UninstallService(ISettings settings, ICLL cll) {
        this.settings = settings;
        this.cll = cll;
        this.getParamsDesc().put(PARAM_PROD, "Product name");
    }

    @Override
    public String getOneLineDesc() {
        return "Uninstall CLL service (Windows only)";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        if (this.settings.getArgs().length != 2) {
            return "Wrong argument count";
        }
        return null;
    }

    @Override
    public int execute() {
        CLLReason result = this.cll.uninstallService(this.settings.getParam(PARAM_PROD));
        if (result == null) {
            return 0;
        }
        System.err.print(result);
        return 1;
    }

    @Override
    public String getName() {
        return "uninstall";
    }

    public Map<String, String> getParamsDesc() {
        return this.paramsDesc;
    }

    @Override
    public Map<String, String> getOneLineParamsDesc() {
        return this.paramsDesc;
    }
}

